Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.Common.DataModel.ContainerItemFontHelper", {
        fields: {
            FontStyle: 0,
            FontColor: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.DatasetHelper", {
        statics: {
            methods: {
                FilterOnServer: function (ds) {
                    return (ds.RecordCount > 0) && (ds.RecordCount !== ds.Records.length);
                },
                IsReadOnly: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.ReadOnly === 1;
                },
                CanRead: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Read === 1;
                },
                CanInsert: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Insert === 1;
                },
                CanUpdate: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Update === 1;
                },
                CanDelete: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Delete === 1;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldDefHelpers", {
        statics: {
            methods: {
                IsVisible: function (fieldValue) {
                    return fieldValue.Hidden === 0;
                },
                IsReadOnly: function (fieldValue) {
                    return fieldValue.ReadOnly === 1;
                },
                IsRequired: function (fieldValue) {
                    return fieldValue.Required === 1;
                },
                GetFormatString: function (fieldDef) {
                    var $t;
                    if (System.String.isNullOrEmpty(fieldDef.Mask)) {
                        if (fieldDef.Type === 9) {
                            return "N2";
                        }
                        return null;
                    }

                    var mask = System.Linq.Enumerable.from(($t = System.String, System.Linq.Enumerable.from(System.String.split(fieldDef.Mask, System.Array.init([59], System.Char).map(function (i) {{ return String.fromCharCode(i); }})), $t).toList($t)), System.String).firstOrDefault(null, null);
                    return mask;
                },
                GetEnumCaption: function (fieldDef, value) {
                    var $t;
                    if (value == null) {
                        return null;
                    }
                    var values = System.String.split(fieldDef.Values, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                    var captions = System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                    return captions[System.Array.index(($t = System.String, System.Linq.Enumerable.from(values, $t).toList($t)).indexOf(value), captions)];
                },
                GetEnumValues: function (fieldDef) {
                    return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumValues$1(fieldDef, fieldDef.Values);
                },
                GetEnumValues$1: function (fieldDef, value) {
                    if (value == null) {
                        return null;
                    }
                    var values = System.String.split(fieldDef.Values, [44].map(function (i) {{ return String.fromCharCode(i); }}));

                    return System.Array.convertAll(values, function (s) { return System.Int32.parse(s); });
                },
                GetEnumDisplayValues: function (fieldDef) {
                    return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumDisplayValues$1(fieldDef, fieldDef.Values);
                },
                GetEnumDisplayValues$1: function (fieldDef, value) {
                    if (value == null) {
                        return null;
                    }
                    return System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                },
                GetSetCaption: function (fieldDef, strValue) {
                    if (strValue == null) {
                        return null;
                    }

                    var value = { };
                    System.Int32.tryParse(strValue, value);

                    var itemCount = 0;
                    var result = "";
                    var values = System.String.split(fieldDef.Values, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                    var captions = System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));

                    for (var i = 0; i < values.length; i = (i + 1) | 0) {
                        var itemValue = System.Int32.parse(values[System.Array.index(i, values)]);
                        if ((value.v & (1 << itemValue)) !== 0) {
                            if (itemCount > 0) {
                                result = (result || "") + ((", " + (captions[System.Array.index(i, captions)] || "")) || "");
                            } else {
                                result = captions[System.Array.index(i, captions)];
                            }

                            itemCount = (itemCount + 1) | 0;
                        }
                    }

                    return result;
                },
                GetSearchHint: function (fieldDef) {
                    if (function (_o1) {
                            _o1.add(1);
                            _o1.add(2);
                            return _o1;
                        }(new (System.Collections.Generic.List$1(System.Int32)).ctor()).contains(fieldDef.Type)) {
                        return System.String.format("{0}: {1}", fieldDef.Label, (System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}))).join(", "));
                    }
                    return fieldDef.Label;
                },
                Clone: function (fieldDef) {
                    var $t;
                    return ($t = new Adaptica.WebForms.Common.DataModel.FieldDef(), $t.Name = fieldDef.Name, $t.Type = fieldDef.Type, $t.Hidden = fieldDef.Hidden, $t.Required = fieldDef.Required, $t.ReadOnly = fieldDef.ReadOnly, $t.ProcessChange = fieldDef.ProcessChange, $t.SelectFunction = fieldDef.SelectFunction, $t.SelectFunctionID = fieldDef.SelectFunctionID, $t.Label = fieldDef.Label, $t.Values = fieldDef.Values, $t.DisplayValues = fieldDef.DisplayValues, $t.Mask = fieldDef.Mask, $t.Description = fieldDef.Description, $t);
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldValueHelper", {
        statics: {
            methods: {
                IsVisible: function (fieldValue) {
                    return (System.Nullable.hasValue(fieldValue.Visible)) && (System.Nullable.getValue(fieldValue.Visible) === 1);
                },
                IsReadOnly: function (fieldValue) {
                    return (System.Nullable.hasValue(fieldValue.ReadOnly)) && (System.Nullable.getValue(fieldValue.ReadOnly) === 1);
                },
                IsRequired: function (fieldValue) {
                    return (System.Nullable.hasValue(fieldValue.Required)) && (System.Nullable.getValue(fieldValue.Required) === 1);
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FormHelper", {
        statics: {
            methods: {
                IsChanged: function (form, silentOnly) {
                    var $t;
                    if (silentOnly === void 0) { silentOnly = false; }
                    if ((($t = form.DataModule) != null ? $t.Datasets : null) == null || (form.DataModule.Datasets.length === 0)) {
                        return false;
                    }

                    return System.Linq.Enumerable.from(form.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).where(function (ds) {
                            return silentOnly && ds.SilentSave || !silentOnly;
                        }).any(function (ds) {
                        return System.Linq.Enumerable.from(ds.Records, Adaptica.WebForms.Common.DataModel.Record).any(function (r) {
                                switch (r.Event) {
                                    case Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None: 
                                        return false;
                                    default: 
                                        return true;
                                }
                            });
                    });
                },
                Clone: function (T, source) {

                    var serialized = JSON.stringify(source, function (s, o) {
                        /* 
                                       if (s == "Design")
                                       {
                                           return null;
                                       }
                        */

                        return o;
                    });

                    return Newtonsoft.Json.JsonConvert.DeserializeObject(serialized, T);
                },
                CloneFormOnlyForInlineEdit: function (form, currencyManager, currentDSPFID, record) {
                    var clone = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Form, form);
                    clone.DataModule.Datasets.forEach(function (d) {
                            Adaptica.WebForms.WebApp.Extensions.Clear(Adaptica.WebForms.Common.DataModel.Record, d.Records);

                            if (Bridge.referenceEquals(d.DSPFID, currentDSPFID)) {
                                var nRecord = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Record, record);
                                Adaptica.WebForms.WebApp.Extensions.Add(Adaptica.WebForms.Common.DataModel.Record, d.Records, nRecord);
                            } else {
                                var r = currencyManager.GetCurrentRecord(d.DSPFID);
                                if (r != null) {
                                    Adaptica.WebForms.WebApp.Extensions.Add(Adaptica.WebForms.Common.DataModel.Record, d.Records, Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Record, r));
                                }
                            }
                            d.RecordCount = d.Records.length;
                        });

                    return clone;
                },
                CloneFormOnlyForInlineInsert: function (form, currencyManager, currentDSPFID) {
                    var clone = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Form, form);
                    clone.DataModule.Datasets.forEach(function (d) {
                            Adaptica.WebForms.WebApp.Extensions.Clear(Adaptica.WebForms.Common.DataModel.Record, d.Records);

                            if (Bridge.referenceEquals(d.DSPFID, currentDSPFID)) {
                                Adaptica.WebForms.Common.DataModel.DataHelpers.InsertRecord(currencyManager, d);
                            } else {
                                var r = currencyManager.GetCurrentRecord(d.DSPFID);
                                if (r != null) {
                                    Adaptica.WebForms.WebApp.Extensions.Add(Adaptica.WebForms.Common.DataModel.Record, d.Records, Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Record, r));
                                }
                            }
                            d.RecordCount = d.Records.length;
                        });

                    return clone;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FunctionHelper", {
        statics: {
            methods: {
                GetRecordMasterId: function ($function, record) {
                    if (System.String.isNullOrEmpty($function.MasterFields)) {
                        return null;
                    }
                    var m = System.Text.RegularExpressions.Regex.match($function.MasterFields, "ID(?<leftsuffix>.*)=(?:(?<fieldName>.*)\\.)*ID(?<rightsuffix>.*)");
                    var fieldName = m.getGroups().getByName("fieldName").getSuccess() ? m.getGroups().getByName("fieldName").getValue() : null;
                    var suffix = m.getGroups().getByName("rightsuffix").getSuccess() ? m.getGroups().getByName("rightsuffix").getValue() : null;
                    return Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldId(record, fieldName, suffix);
                },
                GetMasterId: function (form, item) {
                    return null;
                },
                IsAvailable: function ($function) {

                    var id = $function.PFU;
                    if (System.String.isNullOrEmpty(id)) {
                        id = $function.PFPFU;
                    }

                    return (System.String.endsWith(id, "11262") || System.String.endsWith(id, "11241") || System.String.endsWith(id, "11263") || System.String.endsWith(id, "9999") || System.String.endsWith(id, "11513") || System.String.endsWith(id, "11309") || System.String.endsWith(id, "11460") || System.String.endsWith(id, "11474") || System.String.endsWith(id, "10158") || System.String.endsWith(id, "11557") || System.String.endsWith(id, "11624") || System.String.endsWith(id, "11566") || System.String.endsWith(id, "10516")) && (System.Array.indexOfT(Adaptica.WebForms.Common.DataModel.Function.fullBUID, $function.BUID) > -1);
                },
                IsFunctionVisibleForRecord: function ($function, record) {
                    if (System.String.isNullOrEmpty($function.VisibleExpr)) {
                        return true;
                    }

                    return Adaptica.WebForms.Common.DataModel.FunctionHelper.EvaluateExpressionForRecord($function.VisibleExpr, record);
                },
                IsFunctionEnabledForRecord: function ($function, record) {
                    if (System.String.isNullOrEmpty($function.EnableExpr)) {
                        return true;
                    }

                    return Adaptica.WebForms.Common.DataModel.FunctionHelper.EvaluateExpressionForRecord($function.EnableExpr, record);
                },
                EvaluateExpressionForRecord: function (expression, record) {
                    if ((record != null ? record.FieldValues : null) == null) {
                        return true;
                    }

                    var result;
                    result = false;

                    var expr = new System.Text.StringBuilder(expression);
                    record.FieldValues.forEach(function (fv) {
                            expr.replace(System.String.format("\"MasterDS.{0}\"", [fv.Name]), fv.Value);
                        });

                    try {
                        var e = expr.replace("<>", "!=").replace("=", "==").replace(" AND ", " && ").replace(" And ", " && ").replace(" and ", " && ").replace(" OR ", " || ").replace(" Or ", " || ").replace(" or ", " || ").toString();

                        result = eval(e);
                    } catch (ex) {
                        ex = System.Exception.create(ex);
                        System.Console.WriteLine(System.String.format("Error: {0}", [ex.Message]));
                    }
                    return result;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.RecordHelper", {
        statics: {
            methods: {
                GetFieldValue$1: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);
                    var value = fv != null ? fv.Value : null;
                    if (System.String.isNullOrEmpty(value)) {
                        return null;
                    }

                    return value;
                },
                GetFieldValue: function (record, fieldDef) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldDef.Name);
                        }, null);
                    var value = fv != null ? fv.Value : null;
                    if (System.String.isNullOrEmpty(value)) {
                        return null;
                    }

                    return value;
                },
                GetFieldDisplayValue: function (record, fieldDef) {
                    if (record == null) {
                        return null;
                    }

                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldDef.Name);
                        }, null);
                    var value = fv != null ? fv.Value : null;
                    if (System.String.isNullOrEmpty(value)) {
                        return null;
                    }

                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                        return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumCaption(fieldDef, value);
                    }

                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Set) {
                        return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetSetCaption(fieldDef, value);
                    }

                    var mask = Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetFormatString(fieldDef);
                    var hasMask = !System.String.isNullOrEmpty(mask);


                    if (((fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Memo) || (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.LMemo)) && (Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef))) {
                        value = System.String.replaceAll(value, "\n", "<br>");
                    } else if ((fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) || (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Date) || (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Time)) {
                        var currentCulture = System.Globalization.CultureInfo.getCurrentCulture();
                        var lang = Adaptica.WebForms.WebApp.WebFormsApp.GetText("SystemShortCountryCode");
                        if (System.String.isNullOrEmpty(lang)) {
                            lang = window.navigator.language;
                        }

                        if (System.String.isNullOrEmpty(lang)) {
                            lang = "cs";
                        }

                        try {
                            System.Globalization.CultureInfo.setCurrentCulture(new System.Globalization.CultureInfo(lang));
                        } catch ($e1) {
                            $e1 = System.Exception.create($e1);
                            Bridge.Console.log(System.String.format("Cannot find language: {0}", [lang]));
                        }

                        try {
                            if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) {
                                var dt = System.DateTime.parseExact(value, "yyyy-MM-dd HH:mm:ss.fff", null);
                                return System.String.format("{0} {1}", System.DateTime.format(dt, "d"), System.DateTime.format(dt, System.Globalization.CultureInfo.getCurrentCulture().dateTimeFormat.longTimePattern));

                            }

                            if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Date) {
                                var dt1 = System.DateTime.parseExact(value, "yyyy-MM-dd", null);
                                return System.DateTime.format(dt1, "d");
                            }

                            if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                                var dt2 = System.DateTime.parseExact(value, "HH:mm:ss.fff", null);
                                return System.DateTime.format(dt2, System.Globalization.CultureInfo.getCurrentCulture().dateTimeFormat.longTimePattern);
                            }
                        } finally {
                            System.Globalization.CultureInfo.setCurrentCulture(currentCulture);
                        }
                    }


                    if (hasMask) {
                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Integer) {
                            value = System.Int32.format(System.Int32.parse(value), mask);
                        } else if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float) {
                            value = Bridge.Int.format(System.Decimal(value, System.Globalization.CultureInfo.invariantCulture), mask);
                        } else {
                        }
                    }


                    return value;
                },
                SetFieldValue: function (record, fieldDef, value) {
                    var $t;
                    if (Bridge.referenceEquals(value, "")) {
                        value = null;
                    }

                    var result = false;
                    var fieldValue = null;

                    var fvIdx = -1;
                    for (var i = 0; i < record.FieldValues.length; i = (i + 1) | 0) {
                        var fv = ($t = record.FieldValues)[System.Array.index(i, $t)];
                        if (Bridge.referenceEquals(fv.Name, fieldDef.Name)) {
                            fvIdx = i;
                            fieldValue = fv;
                        }
                    }

                    if (fieldValue == null && value == null) {
                        return false;
                    }

                    if (fieldValue == null) {
                        fieldValue = new Adaptica.WebForms.Common.DataModel.FieldValue.$ctor1(fieldDef);
                        record.FieldValues.push(fieldValue);
                        result = true;
                    }

                    if (value != null) {
                        switch (fieldDef.Type) {
                            case Adaptica.WebForms.Common.DataModel.FieldType.Float: 
                                {
                                    value = Adaptica.WebForms.WebApp.Extensions.NormalizeFloat(value);
                                    break;
                                }
                            case Adaptica.WebForms.Common.DataModel.FieldType.DateTime: 
                                {
                                    var dt = System.DateTime.parse(value);
                                    value = System.DateTime.format(dt, "yyyy-MM-dd HH:mm:ss.fff");
                                    break;
                                }
                            case Adaptica.WebForms.Common.DataModel.FieldType.Date: 
                                {
                                    var dt1 = System.DateTime.parse(value);
                                    value = System.DateTime.format(dt1, "yyyy-MM-dd");
                                    break;
                                }
                            case Adaptica.WebForms.Common.DataModel.FieldType.Time: 
                                {
                                    var dt2 = System.DateTime.parse(value);
                                    value = System.DateTime.format(dt2, "HH:mm:ss.fff");
                                    break;
                                }
                        }
                    }

                    if (!Bridge.referenceEquals(fieldValue.Value, value)) {
                        fieldValue.Value = value;
                        result = true;
                    }
                    if (result && record.Event === Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None) {
                        record.Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Update;
                    }
                    return result;
                },
                GetFieldId: function (record, idFieldName, suffix) {
                    var $t, $t1, $t2, $t3;
                    if (idFieldName == null) {
                        return System.String.format("{0},{1}", Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, "ic" + ((($t = suffix, $t != null ? $t : "")).toLowerCase() || "")), Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, "u" + ((($t1 = suffix, $t1 != null ? $t1 : "")).toLowerCase() || "")));
                    }
                    return System.String.format("{0},{1}", Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, (idFieldName || "") + ".ic" + ((($t2 = suffix, $t2 != null ? $t2 : "")).toLowerCase() || "")), Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, (idFieldName || "") + ".u" + ((($t3 = suffix, $t3 != null ? $t3 : "")).toLowerCase() || "")));
                },
                IsFieldReadOnly: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);

                    return fv != null ? Bridge.cast((System.Nullable.eq(fv.ReadOnly, 1)), System.Boolean, true) : null;
                },
                IsFieldValueRequired: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);

                    return fv != null ? Bridge.cast((System.Nullable.eq(fv.Required, 1)), System.Boolean, true) : null;
                },
                IsFieldValueVisible: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);

                    return fv != null ? Bridge.cast((System.Nullable.eq(fv.Visible, 1)), System.Boolean, true) : null;
                },
                CanUpdate: function (rec) {
                    return rec.Update === 1;
                },
                CanDelete: function (rec) {
                    return rec.Delete === 1;
                }
            }
        }
    });
});
