Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.Controls.BarScanner", {
        statics: {
            fields: {
                ReaderElementId: null
            },
            ctors: {
                init: function () {
                    this.ReaderElementId = "qr-reader";
                }
            },
            methods: {
                /**
                 * Spustí UI skenování a asynchronně čeká na výsledek nebo zrušení.
                 *
                 * @static
                 * @public
                 * @this Adaptica.WebForms.WebApp.Controls.BarScanner
                 * @memberof Adaptica.WebForms.WebApp.Controls.BarScanner
                 * @param   {System.Threading.CancellationToken}    cancellationToken    Token pro zrušení operace (např. při zrušení v UI).
                 * @return  {System.Threading.Tasks.Task$1}                              Task, který vrátí naskenovaný text, nebo bude zrušen.
                 */
                ScanAsync: function (cancellationToken) {
                    var tcs = new System.Threading.Tasks.TaskCompletionSource();

                    cancellationToken.register(function () {
                        tcs.trySetCanceled();
                    });

                    var config = { fps: 10, qrbox: { width: 250, height: 250 } };

                    var scanner = new Html5QrcodeScanner(Adaptica.WebForms.WebApp.Controls.BarScanner.ReaderElementId, config);


                    var onScanSuccess = function (decodedText, decodedResult) {
                        tcs.trySetResult(decodedText);

                        scanner.Clear();
                    };

                    var onScanError = function (errorMessage) { };


                    scanner.Render(onScanSuccess, onScanError);

                    return tcs.task;
                }
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,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
