Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.Common.DTO.DataDTO", {
        fields: {
            Type: null,
            Data: null,
            FormData: null,
            Record: null,
            DTOParams: null,
            Texts: null,
            SelectionParams: null,
            FavouriteItems: null,
            Screen: null,
            TemplateHtml: null,
            TemplateCss: null,
            Exception: null,
            SSID: null,
            LoginType: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DTO.DTOParam", {
        fields: {
            Name: null,
            Value: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DTO.FavouriteItem", {
        fields: {
            FormID: null,
            FormCaption: null,
            MasterID: null,
            MasterCaption: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DTO.Screen", {
        fields: {
            /**
             * Specifies the y-coordinate of the first pixel that is not allocated to permanent or semipermanent user interface features.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            AvailTop: 0,
            /**
             * Returns the first available pixel available from the left side of the screen.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            AvailLeft: 0,
            /**
             * Specifies the height of the screen, in pixels, minus permanent or semipermanent user interface features displayed by the operating system, such as the Taskbar on Windows.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            AvailHeight: 0,
            /**
             * Returns the amount of horizontal space in pixels available to the window.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            AvailWidth: 0,
            /**
             * Returns the color depth of the screen.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            ColorDepth: 0,
            /**
             * Returns the height of the screen in pixels.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            Height: 0,
            /**
             * Returns the distance in pixels from the left side of the main screen to the left side of the current screen.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            Left: 0,
            /**
             * Gets the bit depth of the screen.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            PixelDepth: 0,
            /**
             * Returns the distance in pixels from the top side of the current screen.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            Top: 0,
            /**
             * Returns the width of the screen.
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DTO.Screen
             * @type number
             */
            Width: 0,
            ViewportHeight: 0,
            ViewportWidth: 0
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DTO.SelectionParams", {
        fields: {
            PFPFID: null,
            DSPFID: null,
            FieldName: null,
            DataForm: null,
            SelectionForm: null,
            CurrentDSPFID: null,
            CurrentRecord: null,
            OriginalRecord: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DTO.UserDTO", {
        fields: {
            Name: null,
            Email: null,
            Message: null
        }
    });
});
