Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.DataSignature", {
        statics: {
            fields: {
                Current: null
            },
            methods: {
                ClearCurrent: function () {
                    Adaptica.WebForms.WebApp.DataSignature.Current = null;
                },
                ProcessSignedDataNia: function (resultJson) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dtoObj, 
                        niaDto, 
                        postData, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (!Bridge.referenceEquals((resultJson).VysledekOvereni, true)) {
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            dtoObj = { };
                                            dtoObj.token = Adaptica.WebForms.WebApp.DataSignature.Current._token;
                                            dtoObj.data = Adaptica.WebForms.WebApp.DataSignature.Current._data;
                                            dtoObj.fileName = Adaptica.WebForms.WebApp.DataSignature.Current._fileName;
                                            dtoObj.hash = Adaptica.WebForms.WebApp.DataSignature.Current._hash;

                                            niaDto = { };
                                            niaDto.status = (resultJson).Status;
                                            niaDto.detail = (resultJson).Detail;
                                            niaDto.idUkonu = (resultJson).IdUkonu;
                                            niaDto.sePP = (resultJson).SePP;
                                            niaDto.loA = (resultJson).LoA;
                                            niaDto.cas = (resultJson).Cas;

                                            dtoObj.nia = Bridge.unbox(niaDto);

                                            postData = JSON.stringify(Bridge.unbox(dtoObj));

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ProcessSignedDataNia", postData, "POST", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    resultXml, 
                                                    $t, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        if ($taskResult1) {
                                                                            $step = 2;
                                                                            continue;
                                                                        } 
                                                                        $step = 3;
                                                                        continue;
                                                                    }
                                                                    case 2: {
                                                                        resultXml = Bridge.as(dataDTO.Data, System.String);
                                                                        !Bridge.staticEquals(($t = Adaptica.WebForms.WebApp.DataSignature.Current.OnSuccessfulSignature), null) ? $t(resultXml) : null;
                                                                        Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                                                        Adaptica.WebForms.WebApp.DataSignature.Current = null;
                                                                        $step = 3;
                                                                        continue;
                                                                    }
                                                                    case 3: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                }
            }
        },
        fields: {
            _signDataWindow: null,
            _token: null,
            _data: null,
            _hash: null,
            _fileName: null,
            OnSuccessfulSignature: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
                Adaptica.WebForms.WebApp.DataSignature.Current = this;
            }
        },
        methods: {
            SignData: function (token) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    dataToSend, 
                    btn1, 
                    $t, 
                    $t1, 
                    btn2, 
                    $t2, 
                    dParams, 
                    $t3, 
                    $t4, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        this._token = token;


                                        if (typeof(Signature) === 'undefined')
                                        {
                                            Adaptica.WebForms.WebApp.WebFormsApp.LoadScript('resources/js/3rd-party/forge.1.31.min.js', null, function()
                                            {
                                                alert('forge.1.31.min.js not found');
                                            });
                                            Adaptica.WebForms.WebApp.WebFormsApp.LoadScript('resources/js/DataSignatureUtils.js', null, function()
                                            {
                                                alert('DataSignatureUtils.js not found');
                                            });
                                        };

                                        dataToSend = JSON.stringify(System.Array.init([token], System.String));

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetDataToSign", dataToSend, "POST", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                dataStruct, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    if ($taskResult1) {
                                                                        $step = 2;
                                                                        continue;
                                                                    } 
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    dataStruct = dataDTO.Data;
                                                                    this._data = dataStruct[0];
                                                                    this._hash = dataStruct[1];
                                                                    this._fileName = dataStruct[2];
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 3: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByCert");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        btn1 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t1 = $taskResult2, $t1 != null ? $t1 : "Certifik\u00e1tem"), $t.Primary = true, $t.Handler = Bridge.fn.bind(this, function () {
                                            window.setTimeout(Bridge.fn.bind(this, function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = this.SignByCert(this._data, this._hash);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            }), 700);
                                        }), $t);

                                        btn2 = null;

                                        if (Bridge.referenceEquals(Adaptica.WebForms.WebApp.WebFormsApp.LoginType, "nia")) {
                                            $step = 3;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 3: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByNia");
                                        $step = 4;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        btn2 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t2 = $taskResult3, $t2 != null ? $t2 : "Identita ob\u010dana"), $t.Primary = true, $t.Handler = Bridge.fn.bind(this, function () {
                                            Adaptica.WebForms.WebApp.WebFormsApp.ShowSplash();
                                            var rnd = Math.floor(Math.random() * (999000)) + 1000;
                                            this._signDataWindow = window.open("nia/Signature.htm?_=" + (System.Double.format(rnd) || ""));

                                            var interval = 0;
                                            var postCalled = false;

                                            interval = window.setInterval(Bridge.fn.bind(this, function () {
                                                if ((!postCalled) && (!Bridge.referenceEquals((typeof (this._signDataWindow).doSubmit), "undefined"))) {
                                                    postCalled = true;
                                                    this.PostData(this._signDataWindow, this._data, this._hash);
                                                }

                                                if (this._signDataWindow.closed) {
                                                    window.clearInterval(interval);
                                                    Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                                }

                                            }), 100);
                                        }), $t);
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByCert");
                                        $step = 6;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SelectSignType");
                                        $step = 7;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.Title = ($t3 = $taskResult4, $t3 != null ? $t3 : "Podpis sady dat"), $t.Message = ($t4 = $taskResult5, $t4 != null ? $t4 : "Pros\u00edm zvolte zp\u016fsob podpisu dat"), $t.Buttons = (Bridge.referenceEquals(Adaptica.WebForms.WebApp.WebFormsApp.LoginType, "nia")) ? System.Array.init([btn1, btn2], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef) : System.Array.init([btn1], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef), $t.OnDialogClosed = function () {
                                            $(".modal-dialog").removeClass("wf-signTypeDialog");
                                        }, $t);

                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                        $step = 8;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task6.getAwaitedResult();
                                        $(".modal-dialog").addClass("wf-signTypeDialog");
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            PostData: function ($window, data, hash) {
                var dataElem = $window.document.getElementById("data");
                if (dataElem != null) {
                    dataElem.value = data;
                }

                var hashElem = $window.document.getElementById("hash");
                if (hashElem != null) {
                    hashElem.value = hash;
                }

                ($window).doSubmit();
            },
            SignByCert: function (data, hashToSign) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    body, 
                    btn1, 
                    $t, 
                    $t1, 
                    btn2, 
                    $t2, 
                    dParams, 
                    $t3, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        body = $("\r\n<div>\r\n\t<label id='signCertLabel' for='pfx'>Vyberte soubor s certifik\u00e1tem (PFX/P12):</label><br/>\r\n\t<input name='pfx' class='form-control border-none' type='file' id='pfx' accept='.pfx,.p12' required>\r\n</div>\r\n<div>\r\n\t<label id='signCertPwdLabel' for='pfxp'>Vlo\u017ete heslo k priv\u00e1tn\u00edmu kl\u00ed\u010di:</label><br/>\r\n\t<input name='pfxp' class='form-control' type='password' id='pfxp' required><br/>\r\n\t<i id='signInfo'>Priv\u00e1tn\u00ed kl\u00ed\u010d ani heslo <b>se nikam nep\u0159en\u00e1\u0161\u00ed</b>, podpis prob\u00edh\u00e1 <b>p\u0159\u00edmo v prohl\u00ed\u017ee\u010di</b>, p\u0159en\u00e1\u0161\u00ed se pouze podpis a ve\u0159ejn\u00e1 \u010d\u00e1st certifik\u00e1tu.</i>\r\n</div>");

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DoSign");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        btn1 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t1 = $taskResult1, $t1 != null ? $t1 : "Podepsat"), $t.Primary = true, $t.AutoClose = false, $t.Handler = Bridge.fn.bind(this, function () {
                                            var self = this;
                                            Signature.Sign(hashToSign).then((result) => { self.ProcessSignedData(data, hashToSign, result.signature, result.publicCert).wait(); }, (reason) => { self.SignFailed(reason); });
                                        }), $t);

                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("Cancel");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        btn2 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t2 = $taskResult2, $t2 != null ? $t2 : "Zru\u0161it"), $t.Handler = function () {
                                            /* */
                                        }, $t);

                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByCert");
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.Title = ($t3 = $taskResult3, $t3 != null ? $t3 : "Podpis sady dat"), $t.MessageBody = body, $t.Buttons = System.Array.init([btn1, btn2], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef), $t.OnDialogClosed = function () {
                                            $(".modal-dialog").removeClass("wf-signByCert");
                                        }, $t);

                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                        $step = 4;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task4.getAwaitedResult();
                                        $(".modal-dialog").addClass("wf-signByCert");
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ProcessSignedData: function (data, hash, signature, publicCert) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    dtoObj, 
                    postData, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.HideAlert();

                                        dtoObj = { };
                                        dtoObj.token = this._token;
                                        dtoObj.data = data;
                                        dtoObj.hash = hash;
                                        dtoObj.fileName = this._fileName;
                                        dtoObj.signature = signature;
                                        dtoObj.publicCert = publicCert;

                                        postData = JSON.stringify(Bridge.unbox(dtoObj));

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ProcessSignedData", postData, "POST", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                resultXml, 
                                                $t, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    if ($taskResult1) {
                                                                        $step = 2;
                                                                        continue;
                                                                    } 
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    resultXml = Bridge.as(dataDTO.Data, System.String);
                                                                    !Bridge.staticEquals(($t = this.OnSuccessfulSignature), null) ? $t(resultXml) : null;
                                                                    Adaptica.WebForms.WebApp.DataSignature.Current = null;
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 3: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SignFailed: function (reason) {

                var dReason = reason;
                var reasonId = dReason.reason;
                var reasonText = dReason.text;

                if (!System.String.isNullOrEmpty(reasonText)) {
                    window.alert(reasonText);
                }
            }
        }
    });
});
