Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ActionSheet", {
        statics: {
            methods: {
                DisplayActionSheet: function (triggerEl, title, cancel, destruction, callback, buttons) {
                    var $t;
                    if (buttons === void 0) { buttons = []; }
                    var CloseSheet = null;
                    var triggerElement = null;
                    var selector;
                    if (((selector = Bridge.as(triggerEl, System.String))) != null) {
                        triggerElement = Bridge.as($(selector).get(0), HTMLElement);
                    } else {
                        var el;
                        if (((el = Bridge.as(triggerEl, HTMLElement))) != null) {
                            triggerElement = el;
                        }
                    }
                    if (triggerElement == null) {
                        return;
                    }

                    var backdrop = $("<div class='action-sheet-backdrop'></div>");
                    var sheet = $("<div class='action-sheet'></div>");
                    var list = $("<div class='list-group list-group-flush mb-0'></div>");

                    if (!System.String.isNullOrEmpty(title)) {
                        list.append(System.String.format("<div class='list-group-item fw-bold'>{0}</div>", [title]));
                    }

                    if (!System.String.isNullOrEmpty(destruction)) {
                        list.append(System.String.format("<div class='list-group-item text-danger fw-bold' data-action='{0}'>{1}</div>", destruction, destruction));
                    }

                    if (buttons != null) {
                        $t = Bridge.getEnumerator(buttons);
                        try {
                            while ($t.moveNext()) {
                                var btn = $t.Current;
                                list.append(System.String.format("<div class='list-group-item' data-action='{0}'>{1}</div>", btn, btn));
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }

                    if (!System.String.isNullOrEmpty(cancel)) {
                        list.append(System.String.format("<div class='list-group-item text-secondary fw-bold' data-action='{0}'>{1}</div>", cancel, cancel));
                    }

                    sheet.append(list);
                    $("body").append(backdrop).append(sheet);

                    var rect = triggerElement.getBoundingClientRect();
                    var sheetWidth = sheet.outerWidth();
                    var sheetHeight = sheet.outerHeight();
                    var viewportWidth = window.innerWidth;
                    var viewportHeight = window.innerHeight;

                    var top, left;
                    if (rect.bottom + sheetHeight <= viewportHeight) {
                        top = rect.bottom + window.scrollY;
                    } else {
                        top = rect.top - sheetHeight + window.scrollY;
                    }

                    if (rect.left + sheetWidth <= viewportWidth) {
                        left = rect.left + window.scrollX;
                    } else {
                        left = rect.right - sheetWidth + window.scrollX;
                    }

                    sheet.css({ top: System.Double.format(top) + "px", left: System.Double.format(left) + "px" });

                    backdrop.fadeIn(100);
                    window.setTimeout(function () {
                        sheet.addClass("show");
                    }, 1);
                    CloseSheet = function () {
                        sheet.removeClass("show");
                        backdrop.fadeOut(100, function () {
                            backdrop.remove();
                        });
                        window.setTimeout(function () {
                            sheet.remove();
                        }, 150);
                    };

                    sheet.on("click", ".list-group-item", function (ev) {
                        var action = Bridge.cast(ev.currentTarget, HTMLElement).getAttribute("data-action");
                        CloseSheet();
                        !Bridge.staticEquals(callback, null) ? callback(action) : null;
                    });

                    backdrop.on("click", function () {
                        var $t1;
                        CloseSheet();
                        !Bridge.staticEquals(callback, null) ? callback(($t1 = cancel, $t1 != null ? $t1 : null)) : null;
                    });


                }
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,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
