Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ActionSheet", {
        statics: {
            methods: {
                DisplayActionSheet: function (triggerEl, title, cancel, destruction, callback, buttons) {
                    var $t;
                    if (buttons === void 0) { buttons = []; }
                    var CloseSheet = null;
                    var triggerElement = null;
                    var selector;
                    if (((selector = Bridge.as(triggerEl, System.String))) != null) {
                        triggerElement = Bridge.as($(selector).get(0), HTMLElement);
                    } else {
                        var el;
                        if (((el = Bridge.as(triggerEl, HTMLElement))) != null) {
                            triggerElement = el;
                        }
                    }
                    if (triggerElement == null) {
                        return;
                    }

                    var backdrop = $("<div class='action-sheet-backdrop'></div>");
                    var sheet = $("<div class='action-sheet'></div>");
                    var list = $("<div class='list-group list-group-flush mb-0'></div>");

                    if (!System.String.isNullOrEmpty(title)) {
                        list.append(System.String.format("<div class='list-group-item title'>{0}</div>", [title]));
                    }

                    if (buttons != null) {
                        $t = Bridge.getEnumerator(buttons);
                        try {
                            while ($t.moveNext()) {
                                var btn = $t.Current;
                                list.append(System.String.format("<div class='list-group-item wf-action-sheet-item' data-action='{0}'>{1}</div>", btn, btn));
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }
                    /* 
                               if (!string.IsNullOrEmpty(destruction))
                               {
                                   list.Append($"<div class='list-group-item wf-action-sheet-item destruct' data-action='{destruction}'>{destruction}</div>");
                               }

                               if (!string.IsNullOrEmpty(cancel))
                               {
                                   list.Append($"<div class='list-group-item wf-action-sheet-item cancel' data-action='{cancel}'>{cancel}</div>");
                               }
                    */
                    if (!System.String.isNullOrEmpty(cancel) || !System.String.isNullOrEmpty(destruction)) {
                        var outerRow = $("<div class='list-group-item p-0'>");
                        var row = $("<div style='display:flex; width:100%;'>").appendTo(outerRow);

                        var destructionRow = null;
                        var cancelRow = null;
                        if (!System.String.isNullOrEmpty(destruction)) {
                            destructionRow = $(System.String.format("<div class=\"wf-action-sheet-item destruct\" data-action='{0}'>", [destruction]));
                            destructionRow.append($(System.String.format("<button type=\"button\" class=\"btn button wf-formButton\"><div class=\"wf-buttonCaption\">{0}</div></button></div>", [destruction])));
                            row.append(destructionRow);
                        }

                        if (!System.String.isNullOrEmpty(cancel)) {
                            /* 
                                               row += $"<div style='flex:1; text-align:center; padding:8px; cursor:pointer;' " +
                                                      $"class='wf-action-sheet-item cancel' data-action='{cancel}'>{cancel}</div>";
                            */
                            cancelRow = $(System.String.format("<div class=\"wf-action-sheet-item cancel\" data-action='{0}'>", [cancel]));
                            if (destructionRow == null) {
                                cancelRow.css("flex", 1);
                            }
                            cancelRow.append($(System.String.format("<button type=\"button\" class=\"btn button wf-formButton\"><div class=\"wf-buttonCaption\">Storno</div></button></div>", null)));
                            row.append(cancelRow);
                        }

                        list.append(outerRow);
                    }

                    sheet.append(list);
                    $("body").append(backdrop).append(sheet);

                    var rect = triggerElement.getBoundingClientRect();
                    var sheetWidth = sheet.outerWidth();
                    var sheetHeight = sheet.outerHeight();
                    var viewportWidth = window.innerWidth;
                    var viewportHeight = window.innerHeight;

                    var top, left;


                    if (rect.bottom + sheetHeight <= viewportHeight) {
                        top = rect.bottom + window.scrollY;
                    } else {
                        var spaceAbove = rect.top + window.scrollY;
                        if (spaceAbove >= sheetHeight) {
                            top = rect.top - sheetHeight + window.scrollY;
                        } else {
                            top = (((window.scrollY + viewportHeight) | 0) - sheetHeight) | 0;
                            if (top < 0) {
                                top = 0;
                            }
                        }
                    }

                    if (rect.left + sheetWidth <= viewportWidth) {
                        left = rect.left + window.scrollX;
                    } else {
                        left = rect.right - sheetWidth + window.scrollX;
                    }

                    sheet.css({ top: System.Double.format(top) + "px", left: System.Double.format(left) + "px" });

                    backdrop.fadeIn(100);
                    window.setTimeout(function () {
                        sheet.addClass("show");
                    }, 1);
                    CloseSheet = function () {
                        sheet.removeClass("show");
                        backdrop.fadeOut(100, function () {
                            backdrop.remove();
                        });
                        window.setTimeout(function () {
                            sheet.remove();
                        }, 150);
                    };

                    sheet.on("click", ".wf-action-sheet-item", function (ev) {
                        var action = Bridge.cast(ev.currentTarget, HTMLElement).getAttribute("data-action");
                        CloseSheet();
                        !Bridge.staticEquals(callback, null) ? callback(action) : null;
                    });

                    backdrop.on("click", function () {
                        var $t1;
                        CloseSheet();
                        !Bridge.staticEquals(callback, null) ? callback(($t1 = cancel, $t1 != null ? $t1 : null)) : null;
                    });

                    document.addEventListener("keydown", function (e) {
                        var $t1;
                        var kev = e;
                        if (Bridge.referenceEquals(kev.key, "Escape")) {
                            CloseSheet();
                            !Bridge.staticEquals(callback, null) ? callback(($t1 = cancel, $t1 != null ? $t1 : null)) : null;
                        }
                    });


                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.BarScanner", {
        statics: {
            fields: {
                ReaderElementId: null
            },
            ctors: {
                init: function () {
                    this.ReaderElementId = "qr-reader";
                }
            },
            methods: {
                /**
                 * Starts UI scanning and asynchronously waits for result or cancellation.
                 *
                 * @static
                 * @public
                 * @this Adaptica.WebForms.WebApp.Controls.BarScanner
                 * @memberof Adaptica.WebForms.WebApp.Controls.BarScanner
                 * @param   {System.Threading.CancellationToken}    cancellationToken    Token for operation cancellation (e.g. when cancelled in UI).
                 * @return  {System.Threading.Tasks.Task$1}                              Task that returns scanned text or will be cancelled.
                 */
                ScanAsync: function (cancellationToken) {
                    var tcs = new System.Threading.Tasks.TaskCompletionSource();

                    cancellationToken.register(function () {
                        tcs.trySetCanceled();
                    });

                    var config = { fps: 10, qrbox: { width: 250, height: 250 } };

                    var scanner = new Html5QrcodeScanner(Adaptica.WebForms.WebApp.Controls.BarScanner.ReaderElementId, config);


                    var onScanSuccess = function (decodedText, decodedResult) {
                        tcs.trySetResult(decodedText);

                        scanner.Clear();
                    };

                    var onScanError = function (errorMessage) { };


                    scanner.Render(onScanSuccess, onScanError);

                    return tcs.task;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ViewBase", {
        inherits: [System.IDisposable],
        fields: {
            _control: null,
            _required: null,
            _infoIcon: null,
            _clearContentElem: null,
            _clearContentClicked: false,
            _changeHandlers: null,
            FormControl: null,
            EditControl: null,
            DataItem: null,
            Dataset: null,
            FieldDef: null,
            Record: null,
            FieldName: null,
            _id: null,
            Parent: null,
            _mainControl: null,
            IsCreatingControl: false,
            IsEditing: false
        },
        props: {
            ControlId: {
                get: function () {
                    return this._id;
                }
            },
            MainControl: {
                get: function () {
                    var $t;
                    if ((this._mainControl == null) || (this._mainControl.length === 0)) {
                        this._mainControl = ($t = this.Parent) != null ? $t.find(System.String.format("#{0}", [this.ControlId])) : null;
                        if (System.Nullable.eq((this._mainControl != null ? this._mainControl.length : null), 0)) {
                            this._mainControl = null;
                        }
                    }

                    return this._mainControl;
                },
                set: function (value) {
                    this._mainControl = value;
                }
            },
            IsRequired: {
                get: function () {
                    return this.EditControl.IsRequired;
                }
            },
            IsReadOnly: {
                get: function () {
                    return this.EditControl.IsReadOnly;
                }
            },
            Value: {
                get: function () {
                    var $t;
                    return ($t = this.Record) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue($t, this.FieldDef) : null;
                }
            },
            IsEnabled: {
                get: function () {
                    return !this.MainControl.hasClass("disabled");
                }
            }
        },
        alias: ["Dispose", "System$IDisposable$Dispose"],
        ctors: {
            init: function () {
                this._changeHandlers = new (System.Collections.Generic.List$1(Function)).ctor();
            },
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                this.FormControl = formControl;
                this.EditControl = editControl;
                this.DataItem = dataItem;
                this.Dataset = ds;
                this.FieldDef = fieldDef;
                this.Record = rec;
                this.FieldName = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(fieldDef.Name);
                this._id = (this.FormControl.CreateUniqueControlId() || "") + (System.String.format("_ctrl_{0}", [this.FieldName]) || "");
            }
        },
        methods: {
            GetControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this._control == null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.CreateControlInternal();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        this._control = $taskResult1;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateControlInternal: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    lbl, 
                    $t, 
                    ctrl, 
                    ctrlWrap, 
                    prnt, 
                    $async_e, 
                    $async_e1, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        this.IsCreatingControl = true;
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        this.Parent = $(document.createElement("div")).addClass("form-group col-auto mb-auto wf-control");

                                        lbl = $(($t = document.createElement("label"), $t.htmlFor = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.ControlId), $t.innerHTML = this.FieldDef.Label, $t)).appendTo(this.Parent);

                                        this._required = $("<span>").addClass("wf-required").html("*");

                                        if (!this.IsRequired) {
                                            this._required.addClass("wf-hidden");
                                        }

                                        if (!System.String.isNullOrEmpty(this.FieldDef.Description)) {
                                            this._infoIcon = $("<span>").addClass("wf-tooltip-icon fas fa-info-circle").attr("title", System.String.replaceAll(this.FieldDef.Description, "\n", "<br>")).attr("data-toggle", "tooltip").attr("data-boundary", "window");

                                            this._infoIcon.tooltip({ trigger: "hover", placement: "auto", html: true, title: System.String.replaceAll(this.FieldDef.Description, "\n", "<br>") });
                                        }

                                        $task1 = this.CreateControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        ctrl = $taskResult1;

                                        if (ctrl != null) {
                                            if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon, this.DataItem.Action)) {
                                                $returnValue = ctrl;
                                                $step = 3;
                                                continue;
                                            }

                                            if (this.MainControl == null) {
                                                this.MainControl = ctrl.find((System.String.format("#", null) || "") + (this.ControlId || ""));
                                            }

                                            if (this.EditControl.CreateControlOnly) {
                                                if (Bridge.referenceEquals(ctrl, this.MainControl)) {
                                                    ctrlWrap = $("<span>").append(ctrl);

                                                    if (this._infoIcon != null) {
                                                        this.Parent.append(this._infoIcon);
                                                    }

                                                    ctrlWrap.append(this._required);

                                                    ctrl = ctrlWrap;
                                                } else {
                                                    prnt = this.MainControl.parent();

                                                    if (this._infoIcon != null) {
                                                        prnt.append(this._infoIcon);
                                                    }

                                                    prnt.append(this._required);
                                                }

                                                this.SetChangeHandler();
                                                $returnValue = ctrl;
                                                $step = 3;
                                                continue;
                                            }

                                            if (this._infoIcon != null) {
                                                this.Parent.append(this._infoIcon);
                                            }

                                            this.Parent.append(this._required).append(ctrl);
                                        }

                                        this.SetChangeHandler();

                                        $returnValue = this.Parent;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this.IsCreatingControl = false;

                                        if ($jumpFromFinally > -1) {
                                            $step = $jumpFromFinally;
                                            $jumpFromFinally = null;
                                        } else if ($async_e) {
                                            $tcs.setException($async_e);
                                            return;
                                        } else if (Bridge.isDefined($returnValue)) {
                                            $tcs.setResult($returnValue);
                                            return;
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            if ($step >= 1 && $step <= 2) {
                                $step = 3;
                                $asyncBody();
                                return;
                            }
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AppendClearContent: function (inputElem) {
                this._clearContentElem = $("<div>");
                this._clearContentElem.addClass("input-group-append input-group-text del-icon wf-hidden").on("click", Bridge.fn.bind(this, function (e) {

                    e.preventDefault();

                    if ((!this.EditControl.IsEnabled) && (this.FieldDef.SelectFunction === 0)) {
                        return;
                    }

                    this.SetControlValue("");
                    this.OnChange(null);

                    if ((inputElem != null) && (!Bridge.referenceEquals(inputElem.val(), ""))) {
                        inputElem.val("");
                    }

                    this._clearContentClicked = true;

                    Adaptica.WebForms.WebApp.Extensions.WFHide(this._clearContentElem);
                    inputElem != null ? inputElem.removeClass("wf-input-w-del") : null;
                    inputElem != null ? inputElem.focus() : null;
                })).insertAfter(inputElem);

                $("<span>").addClass("fa fa-times-circle").appendTo(this._clearContentElem);

                if (inputElem != null) {
                    inputElem.on("input", Bridge.fn.bind(this, function () {
                        if (!this.IsEditing) {
                            return;
                        }

                        if (!!((this.EditControl.AllowEdit(this.DataItem.DSPFID)) & (!Bridge.referenceEquals(inputElem.val(), "")))) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(this._clearContentElem);
                            inputElem.addClass("wf-input-w-del");
                        } else {
                            Adaptica.WebForms.WebApp.Extensions.WFHide(this._clearContentElem);
                        }
                    }));

                    inputElem.on("focus", Bridge.fn.bind(this, function () {
                        if (!!((this.EditControl.AllowEdit(this.DataItem.DSPFID)) & (!System.String.isNullOrEmpty(this.GetControlValue())))) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(this._clearContentElem);
                            inputElem.addClass("wf-input-w-del");
                        }

                    }));

                    inputElem.on("blur", Bridge.fn.bind(this, function () {
                        window.setTimeout(Bridge.fn.bind(this, function () {
                            var clicked = this._clearContentClicked;
                            this._clearContentClicked = false;
                            if (clicked) {
                                return;
                            }

                            Adaptica.WebForms.WebApp.Extensions.WFHide(this._clearContentElem);
                            inputElem.removeClass("wf-input-w-del");
                        }), 200);
                    }));
                }
            },
            SetClearContentVisibility: function (enable) { },
            SetChangeHandler: function () {
                var $t;
                ($t = this.MainControl) != null ? $t.change(Bridge.fn.bind(this, function () {
                    this.OnChange(this.GetControlValue());



                })) : null;
            },
            SetEnabled: function (enabled) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((this.MainControl == null) || (this.MainControl.length === 0)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ((this.MainControl == null) || (this.MainControl.length === 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this.MainControl.prop("disabled", !enabled);

                                        if (enabled) {
                                            this.MainControl.removeClass("disabled");
                                        } else {
                                            this.MainControl.addClass("disabled");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if (visible) {
                                            this._control.removeClass("wf-hidden");
                                        } else {
                                            this._control.addClass("wf-hidden");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetRequired: function (required) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if (this._required != null) {

                                            if (required) {
                                                this._required.removeClass("wf-hidden");
                                            } else {
                                                this._required.addClass("wf-hidden");
                                            }
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetControlValue: function () {
                var $t;
                return ($t = this.MainControl) != null ? $t.val() : null;
            },
            SetControlValue: function (value) {
                if (this.MainControl != null) {
                    this.MainControl.val(value);

                    this.EditControl.SetFontProperties(this.MainControl, value);

                    /* 
                                   var color = EditControl.GetTextColor(value);
                                   if (!string.IsNullOrEmpty(color))
                                   {
                                       MainControl.Css("color", color);
                                   }
                    */
                }
            },
            Focus: function () {
                if (!this.IsEnabled) {
                    return false;
                }

                window.setTimeout(Bridge.fn.bind(this, function () {
                    var $t;
                    ($t = this.MainControl) != null ? $t.focus() : null;
                }), 10);

                return true;
            },
            Change: function (handler) {
                this._changeHandlers.add(handler);
            },
            OnChange: function (value) {
                var $t;
                $t = Bridge.getEnumerator(this._changeHandlers);
                try {
                    while ($t.moveNext()) {
                        var handler = $t.Current;
                        handler(value);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            BeginEdit: function () {
                this.IsEditing = true;
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            BeforeEndEdit: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            EndEdit: function () {
                this.IsEditing = false;
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            EndFailed: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            Dispose: function () {
                var $t;

                ($t = this.MainControl) != null ? $t.off() : null;
                this._clearContentElem != null ? this._clearContentElem.off() : null;

                this._changeHandlers.clear();
                this._mainControl = null;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.IControlDataContext", {
        $kind: "interface"
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.IControl", {
        inherits: [System.IDisposable],
        $kind: "interface"
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ControlUtils", {
        statics: {
            fields: {
                IgnoreKeys: null
            },
            ctors: {
                init: function () {
                    this.IgnoreKeys = System.Array.init(["Home", "End", "PageUp", "PageDown", "Insert", "Shift", "Control", "Alt", "Clear", "Tab"], System.String);
                }
            },
            methods: {
                CreateValidId: function (s) {
                    return System.String.replaceAll(System.String.replaceAll(System.String.replaceAll(System.String.replaceAll(s, ",", "_"), "/", "_"), "+", "_"), "=", "_");
                },
                GetTextColor: function (dataItem, fieldDef, text) {
                    var item = dataItem;
                    if ((item != null ? item.FontColor : null) == null) {
                        return null;
                    }

                    return Adaptica.WebForms.WebApp.Controls.ControlUtils.GetTextColor$1(item.FontColor, fieldDef.Values, text);
                },
                GetTextColor$1: function (colors, defValues, text) {
                    var $t;
                    if (System.String.isNullOrEmpty(colors)) {
                        return null;
                    }

                    var colorCodes = System.String.split(colors, [44].map(function (i) {{ return String.fromCharCode(i); }}));

                    if ((System.String.isNullOrEmpty(defValues)) || (System.String.isNullOrEmpty(text))) {
                        return colorCodes[System.Array.index(0, colorCodes)];
                    }

                    var values = System.String.split(defValues, System.Array.init([44], System.Char).map(function (i) {{ return String.fromCharCode(i); }}), null, 0);

                    var index = ($t = System.String, System.Linq.Enumerable.from(values, $t).toList($t)).indexOf(text);

                    if (index !== -1 && index < colorCodes.length) {
                        return colorCodes[System.Array.index(index, colorCodes)];
                    }

                    return null;
                },
                SetFontProperties: function (dataItem, fieldDef, ctrl, text) {
                    var item = dataItem;
                    Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontProperties$1(item.FontColor, fieldDef != null ? fieldDef.Values : null, item.FontStyle, ctrl, text);
                },
                SetFontProperties$1: function (colors, defValues, fontStyle, ctrl, text) {
                    if (!System.String.isNullOrEmpty(colors)) {
                        var color = Adaptica.WebForms.WebApp.Controls.ControlUtils.GetTextColor$1(colors, defValues, text);
                        if (!System.String.isNullOrEmpty(color)) {
                            ctrl.css("color", color);
                        }
                    }

                    Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontStyle(ctrl, fontStyle);
                },
                SetFontStyle: function (ctrl, fontStyle) {
                    if ((fontStyle & 1) > 0) {
                        ctrl.css("font-weight", "bold");
                    }
                    if ((fontStyle & 2) > 0) {
                        ctrl.css("font-style", "italic");
                    }
                },
                CreateViewByFieldDefType: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                    var value = rec != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef) : null;

                    if (!System.String.isNullOrEmpty(value)) {
                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                            return new Adaptica.WebForms.WebApp.Controls.BlobView(formControl, editControl, dataItem, ds, fieldDef, rec);
                        }
                    }

                    var result;

                    switch (fieldDef.Type) {
                        case Adaptica.WebForms.Common.DataModel.FieldType.Bit: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.BitView(formControl, editControl, dataItem, ds, fieldDef, rec);

                                break;
                            }
                        case Adaptica.WebForms.Common.DataModel.FieldType.Enum: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.EnumView(formControl, editControl, dataItem, ds, fieldDef, rec);

                                break;
                            }
                        case Adaptica.WebForms.Common.DataModel.FieldType.Set: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.SetView(formControl, editControl, dataItem, ds, fieldDef, rec);

                                break;
                            }
                        case Adaptica.WebForms.Common.DataModel.FieldType.DateTime: 
                        case Adaptica.WebForms.Common.DataModel.FieldType.Date: 
                        case Adaptica.WebForms.Common.DataModel.FieldType.Time: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.DateTimeView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                /* 
                                                   if (editControl.AllowEdit(dataItem.DSPFID))
                                                   {
                                                       result = new DateTimeView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                                   }
                                                   else
                                                   {
                                                       result = new EditView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                                   }
                                */

                                break;
                            }
                        default: 
                            {
                                if (Bridge.referenceEquals(dataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) {
                                    result = new Adaptica.WebForms.WebApp.Controls.EditView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                } else {
                                    result = new Adaptica.WebForms.WebApp.Controls.EditView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                }

                                break;
                            }
                    }

                    return result;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.FormContainers", {
        fields: {
            Form: null,
            Top: null,
            NavBar: null,
            Common: null,
            Content: null
        },
        ctors: {
            ctor: function (form, top, navBar, common, content) {
                this.$initialize();
                this.Form = form;
                this.Top = top;
                this.NavBar = navBar;
                this.Common = common;
                this.Content = content;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs", {
        $kind: "nested class",
        fields: {
            Action: null
        },
        ctors: {
            ctor: function (Action) {
                this.$initialize();
                System.Object.call(this);
                this.Action = Action;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.BitView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        fields: {
            _input: null
        },
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    result, 
                    onText, 
                    offText, 
                    dv, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        this.MainControl = (this._input = $(($t = document.createElement("input"), $t.id = this.ControlId, $t.type = "checkbox", $t)).attr("data-toggle", "toggle").attr("data-style", "round"));

                                        if (Bridge.referenceEquals(this.Value, "1")) {
                                            this._input.attr("checked", "checked");
                                        }

                                        result = $("<div>").addClass("input-group").append(this._input);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        onText = $taskResult1;
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        offText = $taskResult2;
                                        if (!System.String.isNullOrEmpty(this.FieldDef.DisplayValues)) {
                                            dv = System.String.split(this.FieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                                            offText = dv[System.Array.index(0, dv)];
                                            onText = dv[System.Array.index(1, dv)];
                                        }

                                        eval(System.String.format("this._input.bootstrapToggle({{ size: 'sm', on: '{0}', off: '{1}' }});", onText, offText));

                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetEnabled: function (enable) {
                if (enable) {
                    this.MainControl.bootstrapToggle('enable');
                } else {
                    this.MainControl.bootstrapToggle('disable');
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            GetControlValue: function () {
                var ch = this.MainControl.prop("checked");
                return (ch) ? "1" : "0";
            },
            SetControlValue: function (value) {
                var item = this._input;

                var isDisabled = item.prop("disabled") || item.prop("readonly");
                if (isDisabled) {
                    item.bootstrapToggle('enable');
                }

                if (System.String.equals(("1"), value)) {
                    item.bootstrapToggle('on');
                } else {
                    item.bootstrapToggle('off');
                }

                if (isDisabled) {
                    item.bootstrapToggle('disable');
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.BlobView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $t;
                var img = ($t = new Image(), $t.src = "data:image/png;base64," + (this.Value || ""), $t.className = "wf-dataImage", $t);

                return System.Threading.Tasks.Task.fromResult($(document.createElement("div")).addClass("form-group col-auto mb-auto wf-control wf-blob").append(img), $);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ControlBase", {
        inherits: [Adaptica.WebForms.WebApp.Controls.IControl,Adaptica.WebForms.WebApp.Controls.IControlDataContext],
        fields: {
            FieldName: null,
            ControlId: null,
            FormControl: null,
            DataItem: null,
            CurrentRecord: null,
            MainControl: null,
            View: null,
            IsEditing: false,
            SubControls: null,
            IsShown: false,
            _dset: null,
            _fieldDef: null,
            CreateControlOnly: false,
            IsDisposed: false
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    return false;
                }
            },
            NeedsProcessDataOnInsert: {
                get: function () {
                    return this.FormControl.NeedsProcessDataOnInsert;
                }
            },
            Dataset: {
                get: function () {
                    var $t;
                    if ((this._dset == null) && (!System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null))) {
                        this._dset = this.FormControl.CurrencyManager.GetCurrentDataset(this.DataItem.DSPFID);
                    }

                    return this._dset;
                }
            },
            FieldDef: {
                get: function () {
                    var $t;
                    if ((this._fieldDef == null) && (this.DataItem != null)) {
                        var header = ($t = this.Dataset) != null ? $t.Header : null;
                        this._fieldDef = header != null ? System.Linq.Enumerable.from(header.FieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault(Bridge.fn.bind(this, function (fld) {
                                return Bridge.referenceEquals(fld.Name, this.DataItem.FieldName);
                            }), null) : null;
                    }

                    return this._fieldDef;
                }
            },
            Value: {
                get: function () {
                    var $t, $t1;
                    if (((($t = this.DataItem) != null ? $t.DSPFID : null) == null) || (this.CurrentRecord == null)) {
                        return null;
                    }

                    return ($t1 = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1($t1, this.DataItem.FieldName) : null;
                },
                set: function (value) {
                    if ((this.IsEnabled) && (this.CurrentRecord != null)) {
                        if ((this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) && (Bridge.referenceEquals(value, "-1"))) {
                            value = null;
                        }

                        if (Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(this.CurrentRecord, this.FieldDef, value)) {
                        }
                    }
                }
            },
            Text: {
                get: function () {
                    var $t, $t1;
                    if (((($t = this.DataItem) != null ? $t.DSPFID : null) == null) || (this.CurrentRecord == null)) {
                        return null;
                    }

                    return ($t1 = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue($t1, this.FieldDef) : null;
                },
                set: function (value) {
                    if ((this.IsEnabled) && (this.CurrentRecord != null)) {
                        if (Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(this.CurrentRecord, this.FieldDef, value)) {
                        }
                    }
                }
            },
            TextColor: {
                get: function () {
                    return this.GetTextColor(this.Text);
                }
            },
            IsEnabled: {
                get: function () {
                    var $t;
                    return (this.FormControl.EditMode) && this.AllowEdit(($t = this.DataItem) != null ? $t.DSPFID : null);
                }
            },
            IsVisible: {
                get: function () {
                    var $t, $t1;
                    return (this.FieldDef.Hidden === 0) && ((this.CurrentRecord == null) || (($t = Adaptica.WebForms.Common.DataModel.RecordHelper.IsFieldValueVisible(this.CurrentRecord, ($t1 = this.DataItem) != null ? $t1.FieldName : null), $t != null ? $t : true)));
                }
            },
            IsRequired: {
                get: function () {
                    var $t;
                    return (this.FieldDef.Required !== 0) || ((this.CurrentRecord != null) && (System.Nullable.eq(Adaptica.WebForms.Common.DataModel.RecordHelper.IsFieldValueRequired(this.CurrentRecord, ($t = this.DataItem) != null ? $t.FieldName : null), true)));
                }
            },
            IsReadOnly: {
                get: function () {
                    return this.IsRecordReadOnly(this.CurrentRecord);
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "BeforeEndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit",
            "EndFailed", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed",
            "AllowInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert",
            "AllowEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit",
            "AllowDelete", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "NeedsProcessDataOnInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$NeedsProcessDataOnInsert",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "IsValid", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "CreateControlOnly", "Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this.SubControls = new (System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.ControlBase)).ctor();
                this.CreateControlOnly = false;
            },
            ctor: function (formControl, dataItem, currentRecord) {
                if (currentRecord === void 0) { currentRecord = null; }
                var $t;

                this.$initialize();
                this.FormControl = formControl;
                this.DataItem = dataItem;

                if (dataItem == null) {
                }

                if (currentRecord != null) {
                    this.CurrentRecord = currentRecord;
                } else {
                    this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(($t = this.DataItem) != null ? $t.DSPFID : null);
                    this.FormControl.CurrencyManager.addOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedInternal));
                }

                if (this.FieldDef != null) {
                    this.FieldName = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FieldDef.Name);
                    Bridge.ensureBaseProperty(this, "ControlId").$Adaptica$WebForms$WebApp$Controls$ControlBase$ControlId = System.String.format("ctrl_{0}", [this.FieldName]);
                }
            }
        },
        methods: {
            CurrentRecordChangedInternal: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $t, 
                    $t1, 
                    $t2, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1,2,3,4], $step);
                            switch ($step) {
                                case 0: {
                                    if (System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null)) {
                                        $step = 1;
                                        continue;
                                    } 
                                    $step = 3;
                                    continue;
                                }
                                case 1: {
                                    $task1 = this.CurrentRecordChanged(sender, e).wait();
                                    $step = 2;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 2: {
                                    $task1.getAwaitedResult();
                                    return;
                                }
                                case 3: {
                                    if (e != null) {
                                        if ((!Bridge.referenceEquals((($t1 = this.DataItem) != null ? $t1.DSPFID : null), e.DSPFID)) || ((this.MainControl == null) && (this.View == null))) {
                                            return;
                                        }
                                    }

                                    this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecord(($t2 = this.DataItem) != null ? $t2.DSPFID : null);
                                    $task2 = this.CurrentRecordChanged(sender, e).wait();
                                    $step = 4;
                                    if ($task2.isCompleted()) {
                                        continue;
                                    }
                                    $task2.continue($asyncBody);
                                    return;
                                }
                                case 4: {
                                    $task2.getAwaitedResult();
                                    window.setTimeout(Bridge.fn.bind(this, function () {
                                        var $step = 0,
                                            $task1, 
                                            $jumpFromFinally, 
                                            $asyncBody = Bridge.fn.bind(this, function () {
                                                for (;;) {
                                                    $step = System.Array.min([0,1], $step);
                                                    switch ($step) {
                                                        case 0: {
                                                            $task1 = this.SetControlProperties();
                                                            $step = 1;
                                                            if ($task1.isCompleted()) {
                                                                continue;
                                                            }
                                                            $task1.continue($asyncBody);
                                                            return;
                                                        }
                                                        case 1: {
                                                            $task1.getAwaitedResult();
                                                            return;
                                                        }
                                                        default: {
                                                            return;
                                                        }
                                                    }
                                                }
                                            }, arguments);

                                        $asyncBody();
                                    }), 100);
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            GetFunction: function () {
                return System.Linq.Enumerable.from(this.FormControl.FormData.Functions, Adaptica.WebForms.Common.DataModel.Function).firstOrDefault(Bridge.fn.bind(this, function (fn) {
                        var $t;
                        return Bridge.referenceEquals(fn.PFPFID, (($t = this.DataItem) != null ? $t.PFPFID : null));
                    }), null);
            },
            Focus: function () {
                var $t;
                if ((this.IsEnabled) && (this.MainControl != null)) {
                    if (this.View != null) {
                        return this.View.Focus();
                    }
                    /* 
                                   Window.SetTimeout(() =>
                                   {
                                       MainControl?.Focus();
                                   }, 100);
                    */
                    ($t = this.MainControl) != null ? $t.focus() : null;

                    return true;
                }

                return false;
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        this.SubControls.ForEach(Bridge.fn.bind(this, function (ctrl) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = ctrl.BeginEdit();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        this.IsEditing = true;
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeforeEndEdit: function () {
                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        this.SubControls.ForEach(Bridge.fn.bind(this, function (ctrl) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = ctrl.EndEdit();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        this.IsEditing = false;
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndFailed: function () {
                this.SubControls.ForEach(Bridge.fn.bind(this, function (ctrl) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = ctrl.EndFailed();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }));

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            AllowInsert: function (DSPFID) {
                var $t, $t1, $t2;
                if (System.String.isNullOrEmpty(DSPFID)) {
                    DSPFID = ($t = this.DataItem) != null ? $t.DSPFID : null;
                }

                if ((System.String.isNullOrEmpty(($t1 = this.DataItem) != null ? $t1.DSPFID : null)) || (!Bridge.referenceEquals((($t2 = this.DataItem) != null ? $t2.DSPFID : null), DSPFID))) {
                    return false;
                }

                return (this.Dataset != null) && (!Adaptica.WebForms.Common.DataModel.DatasetHelper.IsReadOnly(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanInsert(this.Dataset));
            },
            AllowEdit: function (DSPFID) {
                var $t, $t1;
                if ((System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null)) || (!Bridge.referenceEquals((($t1 = this.DataItem) != null ? $t1.DSPFID : null), DSPFID))) {
                    return false;
                }

                if ((this.Dataset == null) || (this.CurrentRecord == null) || (this.FieldDef == null)) {
                    return false;
                }

                var result = (!Adaptica.WebForms.Common.DataModel.DatasetHelper.IsReadOnly(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanUpdate(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.RecordHelper.CanUpdate(this.CurrentRecord)) && ((!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(this.FieldDef)) && (System.Nullable.neq(Adaptica.WebForms.Common.DataModel.RecordHelper.IsFieldReadOnly(this.CurrentRecord, this.FieldDef.Name), true)));


                return result;
            },
            AllowDelete: function (DSPFID) {
                var $t, $t1;
                if ((System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null)) || (!Bridge.referenceEquals((($t1 = this.DataItem) != null ? $t1.DSPFID : null), DSPFID))) {
                    return false;
                }

                return (this.Dataset != null) && (!Adaptica.WebForms.Common.DataModel.DatasetHelper.IsReadOnly(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanDelete(this.Dataset)) && (this.CurrentRecord != null) && (Adaptica.WebForms.Common.DataModel.RecordHelper.CanDelete(this.CurrentRecord));
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                var $t;
                return Bridge.referenceEquals((($t = this.DataItem) != null ? $t.DSPFID : null), DSPFID);
            },
            RaiseDataChanged: function () {

                this.CurrentRecordChangedInternal(null, null);

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            OnFormCreated: function () { },
            OnFormActivated: function () { },
            OnFormDeactivated: function () { },
            OnShow: function () {
                this.IsShown = true;
            },
            OnHide: function () {
                this.IsShown = false;
            },
            GetTextColor: function (text) {
                return Adaptica.WebForms.WebApp.Controls.ControlUtils.GetTextColor(this.DataItem, this.FieldDef, text);
            },
            SetFontProperties: function (control, text) {
                Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontProperties(this.DataItem, this.FieldDef, control, text);
            },
            IsValid: function (sb) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $t, 
                    ctrl, 
                    isValid, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7], $step);
                                switch ($step) {
                                    case 0: {
                                        result = true;
                                        $t = Bridge.getEnumerator(this.SubControls);
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        if ($t.moveNext()) {
                                            ctrl = $t.Current;
                                            $step = 2;
                                            continue;
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = ctrl.IsValid(sb);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        isValid = $taskResult1;
                                        if (!isValid) {
                                            result = false;
                                            $step = 4;
                                            continue;
                                        }
                                        $step = 1;
                                        continue;
                                    }
                                    case 4: {
                                        if (!result) {
                                            $tcs.setResult(result);
                                            return;
                                        }

                                        if (this.FieldDef == null) {
                                            $tcs.setResult(true);
                                            return;
                                        }

                                        if ((this.IsRequired) && (System.String.isNullOrEmpty(this.Text)) && (this.CurrentRecord != null)) {
                                            $step = 5;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 5: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("ValidationRequiredField", [this.FieldDef.Label]);
                                        $step = 6;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        sb.appendLine($taskResult2);
                                        result = false;
                                        $step = 7;
                                        continue;
                                    }
                                    case 7: {
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsRecordReadOnly: function (rec) {
                var $t;
                if (this.FieldDef == null) {
                    return false;
                }

                var readOnly = (this.Dataset.Header.ReadOnly > 0) || (this.FieldDef.SelectFunction > 0);
                if (!readOnly) {
                    var fieldValue = rec != null && ($t = rec.FieldValues) != null ? System.Linq.Enumerable.from($t, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(Bridge.fn.bind(this, function (fv) {
                            return Bridge.referenceEquals(fv.Name, this.FieldDef.Name);
                        }), null) : null;

                    readOnly = (fieldValue != null) ? (System.Nullable.gt((System.Nullable.bor(this.FieldDef.ReadOnly, fieldValue.ReadOnly)), 0)) : (this.FieldDef.ReadOnly > 0);
                }

                return readOnly;
            },
            SetControlProperties: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.FieldName : null)) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        $task1 = this.SetVisible(this.IsVisible);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.SetEnabled(this.IsEnabled);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $task3 = this.SetRequired(this.IsRequired);
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetEnabled: function (enabled) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.View.SetEnabled(enabled);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 3: {
                                        if (this.MainControl != null) {

                                            this.MainControl.prop("disabled", !enabled);
                                            if (enabled) {
                                                this.MainControl.removeClass("disabled");
                                            } else {
                                                this.MainControl.addClass("disabled");
                                            }
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.View.SetVisible(visible);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 3: {
                                        if (this.MainControl != null) {

                                            if (visible) {
                                                this.MainControl.removeClass("wf-hidden");
                                            } else {
                                                this.MainControl.addClass("wf-hidden");
                                            }
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetRequired: function (required) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.SetRequired(required);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Dispose: function () {
                this.FormControl.CurrencyManager.removeOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedInternal));
                this._fieldDef = null;
                this._dset = null;
                this.View = null;
                this.MainControl = null;
                this.CurrentRecord = null;
                this.DataItem = null;
                this.FormControl = null;
                this.IsDisposed = true;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.DateTimeView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    editControl, 
                    format, 
                    qiFormat, 
                    icon, 
                    $t, 
                    id, 
                    disabled, 
                    color, 
                    htmlTemplate, 
                    group, 
                    inputElem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this._infoIcon != null) {
                                            this.Parent.append(this._infoIcon);
                                        }

                                        this.Parent.append(this._required);

                                        editControl = this.EditControl;
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemDateTimeJSFormat");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        format = $taskResult1;
                                        qiFormat = "YYYY-MM-DD HH:mm:ss";
                                        icon = "fa-calendar";
                                        $t = this.FieldDef.Type;
                                        if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Date) {
                                            $step = 2;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                                            $step = 4;
                                            continue;
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 2: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemDateJSFormat");
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        format = $taskResult2;
                                        qiFormat = "YYYY-MM-DD";
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemTimeJSFormat");
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        format = $taskResult3;
                                        qiFormat = "HH:mm:ss";
                                        icon = "fa-clock";
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        id = this.ControlId;
                                        disabled = this.IsReadOnly ? " disabled=\"disabled\"" : "";

                                        color = this.EditControl.GetTextColor(this.Value);
                                        if (!System.String.isNullOrEmpty(color)) {
                                            color = System.String.format(" style=\"color: {0}\"", [color]);
                                        }

                                        htmlTemplate = System.String.format("\r\n<div class=\"input-group\">\r\n  <div class=\"input-group date\" id=\"{0}_wrap\" data-target-input=\"nearest\">\r\n    <input id=\"{1}\" type=\"text\" class=\"form-control datetimepicker-input\" data-target=\"#{2}_wrap\"{3}{4}/>\r\n    <div id=\"{5}_append\" class=\"input-group-append\" data-target=\"#{6}_wrap\" data-toggle=\"datetimepicker\">\r\n      <div class=\"input-group-text\"><i class=\"fa {7}\"></i></div>\r\n    </div>\r\n  </div>\r\n</div>", id, id, id, disabled, color, id, id, icon);

                                        if (this.EditControl.CreateControlOnly) {
                                            this.Parent = $("<span>");
                                        }


                                        group = $(htmlTemplate);
                                        group.appendTo(this.Parent);

                                        var mmnt = null;
                                        if (!System.String.isNullOrEmpty(this.Value)) {
                                            mmnt = moment(this.Value, format);
                                        }

                                        $(function () {
                                          var elem = $('#' + id + '_wrap');
                                          elem.datetimepicker({ defaultDate: mmnt, format: format });
                                          elem.on('change.datetimepicker', function (e) { editControl.Value = moment(e.date).format(qiFormat); });
                                        });

                                        inputElem = group.find("input.datetimepicker-input");

                                        this.AppendClearContent(inputElem);

                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetChangeHandler: function () {
                var $t;
                ($t = this.MainControl) != null ? $t.change(Bridge.fn.bind(this, function (e) {
                    var v = this.GetControlValue();

                    if (System.String.isNullOrEmpty(v)) {
                        $('#' + this.ControlId + '_wrap').datetimepicker('clear');
                    }

                    this.OnChange(v);
                    e.preventDefault();
                    e.stopImmediatePropagation();













                })) : null;
            },
            SetEnabled: function (enable) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    append, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        append = this.Parent.find(System.String.format("#{0}_append", [this.ControlId]));
                                        if (enable) {
                                            append.show();
                                        } else {
                                            append.hide();
                                        }

                                        this.SetClearContentVisibility(enable);

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetEnabled.call(this, enable);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.EditView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        statics: {
            fields: {
                _intRegex: null,
                _floatRegex: null
            },
            ctors: {
                init: function () {
                    this._intRegex = new RegExp("^(\\+|-)?\\d*$");
                    this._floatRegex = new RegExp("^(\\+|-)?\\d*(\\.,)?\\d*$");
                }
            },
            methods: {
                SetFontIconValue: function (icon, value) {
                    if (System.String.isNullOrEmpty(value)) {
                        icon.html("");
                        return;
                    }

                    var isGMI = System.Text.RegularExpressions.Regex.isMatch(value, "^0*E[0-9A-F]{3}$", 1);
                    var isMDI = System.Text.RegularExpressions.Regex.isMatch(value, "^0*F[0-9A-F]{4}$", 1);

                    if ((!isGMI) && (!isMDI)) {
                        return;
                    }

                    var className = (isGMI) ? "material-icons" : "mdi-set";

                    icon.attr("data-code", value);
                    Adaptica.WebForms.WebApp.Extensions.WFShow(icon.prop("class", className).addClass("wf-font-icon").html(System.String.format("&#x{0};", [value])));
                }
            }
        },
        fields: {
            _f4Elem: null,
            _icon: null,
            _groupIconInnerDiv: null,
            _groupIconDiv: null,
            _uploadInput: null,
            _uploadIcon: null,
            _allowedKeys: null,
            _fileName: null
        },
        alias: ["Dispose", "System$IDisposable$Dispose"],
        ctors: {
            init: function () {
                this._allowedKeys = System.Array.init([8, 9, 35, 36, 37, 39, 46], System.Int32);
            },
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    inputElem, 
                    inputGroup, 
                    result, 
                    $t, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8,9,10], $step);
                                switch ($step) {
                                    case 0: {
                                        inputElem = null;

                                        inputGroup = $("<div>").addClass("input-group");

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon, this.DataItem.Action)) {
                                            result = this.CreateFontIcon();
                                            this.MainControl = result;
                                            this.EditControl.CreateControlOnly = true;
                                            $tcs.setResult(result);
                                            return;
                                        }

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature, this.DataItem.Action)) {
                                        } else {
                                            inputElem = $(($t = document.createElement("input"), $t.id = this.ControlId, $t.className = "form-control wf-edit", $t.value = this.Value, $t.required = this.IsRequired, $t.disabled = this.IsReadOnly, $t)).appendTo(inputGroup);

                                            if (this.IsRequired) {
                                                inputElem.addClass("wf-required");
                                            }

                                            this.EditControl.SetFontProperties(inputElem, this.Value);
                                        }

                                        this.AppendClearContent(inputElem);

                                        if (this.FieldDef.SelectFunction > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        this.AppendF4(inputGroup, inputElem);
                                        $step = 7;
                                        continue;
                                    }
                                    case 2: {
                                        if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachmentOnline))) {
                                            $step = 3;
                                            continue;
                                        } else  {
                                            $step = 5;
                                            continue;
                                        }
                                    }
                                    case 3: {
                                        $task1 = this.AppendUpload(inputGroup, inputElem);
                                        $step = 4;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task1.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        if (!System.String.isNullOrEmpty(this.DataItem.Action)) {
                                            this.AppendAction(inputGroup, inputElem);
                                        }
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        if ((this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Integer) || (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float)) {
                                            inputElem.keydown(Bridge.fn.bind(this, function (keyboardEvent) {
                                                this.CheckKeyIsNumber(inputElem, keyboardEvent, this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float);
                                            }));

                                            inputElem.on("paste", Bridge.fn.bind(this, function () {
                                                window.setTimeout(Bridge.fn.bind(this, function () {
                                                    var $t1;
                                                    var isDecimal = this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float;
                                                    var regex = (isDecimal) ? Adaptica.WebForms.WebApp.Controls.EditView._floatRegex : Adaptica.WebForms.WebApp.Controls.EditView._intRegex;
                                                    var val = inputElem.val();
                                                    if (!regex.test(val)) {
                                                        var sb = new System.Text.StringBuilder("", val.length);
                                                        $t1 = Bridge.getEnumerator(val);
                                                        try {
                                                            while ($t1.moveNext()) {
                                                                var chr = $t1.Current;
                                                                if ((System.Char.isDigit(chr)) || (chr === 45 || (isDecimal && (chr === 44 || chr === 46)))) {
                                                                    sb.append(String.fromCharCode(chr));
                                                                }
                                                            }
                                                        } finally {
                                                            if (Bridge.is($t1, System.IDisposable)) {
                                                                $t1.System$IDisposable$Dispose();
                                                            }
                                                        }

                                                        inputElem.val(sb.toString());
                                                    }
                                                }), 10);
                                            }));
                                            /* 
                                                           inputElem.Change(evnt =>
                                                           {
                                                               var regex = (FieldDef.Type == FieldType.Integer) ? _intRegex : _floatRegex;
                                                               var className = "wf-invalid";

                                                               if (!regex.Test(inputElem.Val()))
                                                               {
                                                                   inputElem.AddClass(className);
                                                               }
                                                               else
                                                               {
                                                                   inputElem.RemoveClass(className);
                                                               }
                                                           });
                                            */
                                        }

                                        this.MainControl = inputElem;

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature, this.DataItem.Action)) {
                                            this.MainControl = this._icon;
                                            this.EditControl.CreateControlOnly = true;
                                        }

                                        if (this.IsCurrentLocationAction()) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 10;
                                        continue;
                                    }
                                    case 8: {
                                        $task2 = this.SetEnabled(false);
                                        $step = 9;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 9: {
                                        $task2.getAwaitedResult();
                                        $step = 10;
                                        continue;
                                    }
                                    case 10: {
                                        $tcs.setResult(inputGroup);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetCurrentLocation: function () {
                var $t;
                window.navigator.geolocation.getCurrentPosition(Bridge.fn.bind(this, function (position) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        lat, 
                        $long, 
                        value, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        lat = position.coords.latitude;
                                        $long = position.coords.longitude;

                                        value = System.String.format("{0},{1}", Bridge.box(lat, System.Double, System.Double.format, System.Double.getHashCode), Bridge.box($long, System.Double, System.Double.format, System.Double.getHashCode));

                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetCurrentLocationText(lat, $long);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        value = $taskResult1;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this.SetControlValue(value);
                                        this.OnChange(value);
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }), function (error) { }, ($t = new Object(), $t.enableHighAccuracy = true, $t.timeout = 5000, $t));
            },
            GetCurrentLocationText: function (lat, lon) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    address, 
                    options, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        address = "";

                                        options = { url: System.String.format("https://nominatim.openstreetmap.org/reverse?lat={0}&lon={1}&format=json", Bridge.box(lat, System.Double, System.Double.format, System.Double.getHashCode), Bridge.box(lon, System.Double, System.Double.format, System.Double.getHashCode)), success: function (data, textStatus, request) {
                                            var json = data;
                                            var housenumber = System.String.isNullOrEmpty(json.house_number) ? "" : System.String.format(" {0}", [json.house_number]);
                                            address = System.String.format("{0}{1}, {2}, {3}, {4}", json.address.road, housenumber, json.address.city, json.address.postcode, json.address.country);
                                        } };

                                        $task1 = System.Threading.Tasks.Task.fromPromise($.ajax(options));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $tcs.setResult(address);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CheckKeyIsNumber: function (inputElem, evt, isDecimal) {
                var val = inputElem.val();
                var charCode = evt.which;
                var key = evt.key;

                if (System.Array.indexOfT(this._allowedKeys, charCode) > -1) {
                    return;
                }

                if (charCode === 109) {
                    var ss = evt.target.selectionStart;
                    if ((ss === 0) && (System.String.indexOf(val, String.fromCharCode(45)) === -1)) {
                        return;
                    }
                }

                if ((evt.ctrlKey && (charCode === 86 || charCode === 67))) {
                    return;
                }

                if (charCode === 45 && (evt.shiftKey || evt.ctrlKey)) {
                    return;
                }

                if ((isDecimal) && (charCode === 188 || charCode === 190)) {
                    var ss1 = evt.target.selectionStart;
                    if ((System.String.indexOf(val, String.fromCharCode(46)) === -1) && (System.String.indexOf(val, String.fromCharCode(44)) === -1) && (ss1 > 0)) {
                        return;
                    }
                }

                if (System.Char.isDigit(key.charCodeAt(0))) {
                    return;
                }

                evt.preventDefault();
            },
            AppendF4: function (inputGroup, inputElem) {
                inputElem.addClass("f4");
                inputElem.prop("readonly", true);

                this._f4Elem = $("<div>").addClass("input-group-append input-group-text f4-icon").on("click", Bridge.fn.bind(this, function (e) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        lRec, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        e.preventDefault();

                                        if (!this.EditControl.IsEnabled) {
                                            return;
                                        }

                                        lRec = (this.EditControl.IsGridEdit) ? this.Record : this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.Dataset.DSPFID);
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetSelectFunction(this.FormControl, this.Dataset.DSPFID, this.FieldDef.Name, lRec);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                })).appendTo(inputGroup);

                $("<span>").addClass("fa fa-search").appendTo(this._f4Elem);

                if (!this.EditControl.AllowEdit(this.DataItem.DSPFID)) {
                    Adaptica.WebForms.WebApp.Extensions.WFHide(this._f4Elem);
                }
            },
            AppendUpload: function (inputGroup, inputElem) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    fieldPlaceholder, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        inputElem.addClass("wf-fileUpload");
                                        inputElem.prop("readonly", true);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AttachmentButton");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        fieldPlaceholder = $taskResult1;

                                        this._uploadInput = Adaptica.WebForms.WebApp.Extensions.WFHide($(System.String.format("<input type=\"file\" id=\"{0}_upload\" placeholder=\"{1}\">", this.ControlId, fieldPlaceholder)).on("change", Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                files, 
                                                name, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1,2,3,4], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                files = (this._uploadInput.get(0)).files;
                                                                if (files.length > 0) {
                                                                    $step = 1;
                                                                    continue;
                                                                } else  {
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                            }
                                                            case 1: {
                                                                $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetAttachmentKey(files[0].name);
                                                                $step = 2;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 2: {
                                                                $taskResult1 = $task1.getAwaitedResult();
                                                                name = $taskResult1;
                                                                this.SetControlValue(name);
                                                                this.OnChange(name);
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 3: {
                                                                inputElem.prop("placeholder", fieldPlaceholder);
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 4: {
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        })).appendTo(inputGroup));

                                        this._uploadIcon = $("<div>").addClass("input-group-append input-group-text wf-fileUpload-icon").on("click", Bridge.fn.bind(this, function (e) {
                                            e.preventDefault();

                                            if (!this.EditControl.IsEnabled) {
                                                return;
                                            }

                                            this._uploadInput.click();

                                        })).appendTo(inputGroup);


                                        $("<span>").addClass("fa fa-upload").appendTo(this._uploadIcon);
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AppendAction: function (inputGroup, inputElem) {
                var iconName = "";
                switch (this.DataItem.Action) {
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIURL: 
                        {
                            iconName = "fa-external-link-alt";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIEmail: 
                        {
                            iconName = "fa-envelope";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIMap: 
                        {
                            iconName = "fa-map";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIPhone: 
                        {
                            iconName = "fa-phone";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile: 
                        {
                            iconName = "fa-paperclip";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile: 
                        {
                            iconName = "fa-print";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature: 
                        {
                            iconName = "fa-file-signature";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocation: 
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText: 
                        {
                            iconName = "fa-location-dot";
                            break;
                        }
                }

                if (!System.String.isNullOrEmpty(iconName)) {
                    var icon = $("<i>").addClass(System.String.format("fas {0}", [iconName]));

                    this._groupIconInnerDiv = $("<div>").addClass("input-group-text").append(icon);

                    this._groupIconDiv = $("<div>").attr("id", System.String.format("{0}-append", [this.ControlId])).addClass("input-group-append").on("click", Bridge.fn.bind(this, function (e) {
                        var $step = 0,
                            $task1, 
                            $jumpFromFinally, 
                            lRec, 
                            value, 
                            $t, 
                            dSig, 
                            $asyncBody = Bridge.fn.bind(this, function () {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (this.IsEnabled) {
                                                e.stopPropagation();
                                                e.preventDefault();
                                            }

                                            lRec = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.Dataset.DSPFID);
                                            value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(lRec, this.FieldDef);

                                            if (!System.String.isNullOrEmpty(value)) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 13;
                                            continue;
                                        }
                                        case 1: {
                                            $t = this.DataItem.Action;
                                            if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIURL) {
                                                $step = 2;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIEmail) {
                                                $step = 3;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIMap) {
                                                $step = 4;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIPhone) {
                                                $step = 5;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile || $t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile) {
                                                $step = 6;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature) {
                                                $step = 7;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocation || $t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText) {
                                                $step = 11;
                                                continue;
                                            }
                                            $step = 12;
                                            continue;
                                        }
                                        case 2: {
                                            if (System.String.indexOf(value, "://", 0, null, 4) > -1) {
                                                window.open(value);
                                            } else {
                                                window.open(System.String.format("http://{0}", [value]));
                                            }

                                            $step = 12;
                                            continue;
                                        }
                                        case 3: {
                                            window.open(System.String.format("mailto:{0}", [value]));
                                            $step = 12;
                                            continue;
                                        }
                                        case 4: {
                                            if (System.String.startsWith(value, "http")) {
                                                window.open(value);
                                            } else {
                                                value = System.String.replaceAll(value, String.fromCharCode(59), String.fromCharCode(32));

                                                window.open(System.String.format("https://maps.google.com?q={0}", [encodeURIComponent(value)]));
                                            }

                                            $step = 12;
                                            continue;
                                        }
                                        case 5: {
                                            window.open(System.String.format("tel:{0}", [value]));
                                            $step = 12;
                                            continue;
                                        }
                                        case 6: {
                                            window.open("GetFile.ashx" + (value || ""));
                                            $step = 12;
                                            continue;
                                        }
                                        case 7: {
                                            if (!System.String.isNullOrEmpty(value)) {
                                                $step = 8;
                                                continue;
                                            } 
                                            $step = 10;
                                            continue;
                                        }
                                        case 8: {
                                            dSig = new Adaptica.WebForms.WebApp.DataSignature();
                                            dSig.OnSuccessfulSignature = Bridge.fn.bind(this, function (signatureResult) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = this.FormControl.ReloadData();
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    this.FormControl.SetNeedsReloadParents();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });

                                            $task1 = dSig.SignData(value);
                                            $step = 9;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 9: {
                                            $task1.getAwaitedResult();
                                            $step = 10;
                                            continue;
                                        }
                                        case 10: {
                                            $step = 12;
                                            continue;
                                        }
                                        case 11: {
                                            this.GetCurrentLocation();
                                            $step = 12;
                                            continue;
                                        }

                                        case 13: {
                                            return;
                                        }
                                        default: {
                                            return;
                                        }
                                    }
                                }
                            }, arguments);

                        $asyncBody();
                    }));

                    if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature)) {
                        this._groupIconInnerDiv.append(this.FieldDef.Label);

                        this._groupIconDiv.append($("<div class=\"form-group mb-auto wf-control wf-dataSignature\">").append(this._groupIconInnerDiv));

                        var lRec = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.Dataset.DSPFID);
                        var value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(lRec, this.FieldDef);
                        this.CheckSignatureButtonState(value);

                    } else {
                        this._groupIconDiv.append(this._groupIconInnerDiv);
                    }

                    var outerDiv = $("<div>").attr("id", System.String.format("{0}-wrap", [this.ControlId])).attr("data-target-input", "nearest").addClass("input-group");

                    if (inputElem != null) {
                        outerDiv.append(inputElem);
                        if (this._clearContentElem != null) {
                            outerDiv.append(this._clearContentElem);
                        }
                    }

                    outerDiv.append(this._groupIconDiv);

                    this._icon = this._groupIconDiv;

                    inputGroup.append(outerDiv);
                }
            },
            CreateFontIcon: function () {
                this._icon = $("<i>");

                Adaptica.WebForms.WebApp.Controls.EditView.SetFontIconValue(this._icon, this.Value);

                var result = $("<div class=\"form-group col-auto mb-auto wf-control\">").append(this._icon);

                return result;
            },
            SetControlValue: function (value) {
                if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon, this.DataItem.Action)) {
                    Adaptica.WebForms.WebApp.Controls.EditView.SetFontIconValue(this._icon, value);
                    return;
                }

                Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetControlValue.call(this, value);

                if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile))) {
                    if (System.String.isNullOrEmpty(value)) {
                        Adaptica.WebForms.WebApp.Extensions.WFHide(this._icon);
                    } else {
                        Adaptica.WebForms.WebApp.Extensions.WFShow(this._icon);
                    }
                }

                if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature)) {
                    this.CheckSignatureButtonState(value);
                }
            },
            CheckSignatureButtonState: function (value) {
                if (System.String.isNullOrEmpty(value)) {
                    this._groupIconInnerDiv.addClass("wf-existingSignature");
                    this._groupIconInnerDiv.removeClass("button");
                    this._groupIconDiv.addClass("wf-existingSignature");
                } else {
                    this._groupIconInnerDiv.removeClass("wf-existingSignature");
                    this._groupIconInnerDiv.addClass("button");
                    this._groupIconDiv.removeClass("wf-existingSignature");
                }
            },
            IsCurrentLocationAction: function () {
                return (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocation)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationReadOnly));
            },
            SetEnabled: function (enable) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    value, 
                    allowEdit, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (enable && this.IsCurrentLocationAction()) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetEnabled.call(this, enable);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        value = this.GetControlValue();
                                        allowEdit = this.EditControl.AllowEdit(this.DataItem.DSPFID);

                                        if (this.FieldDef.SelectFunction > 0) {
                                        }

                                        if ((enable) && (allowEdit)) {
                                            this._f4Elem != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._f4Elem) : null;
                                            this._uploadIcon != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._uploadIcon) : null;
                                        } else {
                                            this._f4Elem != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._f4Elem) : null;
                                            this._uploadIcon != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._uploadIcon) : null;
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetRequired: function (required) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetRequired.call(this, required);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        if (required) {
                                            this.MainControl.addClass("wf-required");
                                        } else {
                                            this.MainControl.removeClass("wf-required");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeginEdit: function () {
                var result = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.BeginEdit.call(this);

                if ((this.IsCurrentLocationAction()) && (System.String.isNullOrEmpty(this.Value))) {
                    this.GetCurrentLocation();
                }

                return result;
            },
            BeforeEndEdit: function () {
                if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachmentOnline))) {
                    this._fileName = this.Value;
                }

                return Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.BeforeEndEdit.call(this);
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    files, 
                    fd, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachmentOnline))) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 1: {
                                        files = (this._uploadInput.get(0)).files;
                                        if (files.length > 0) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        fd = new FormData();
                                        fd.append("file", files[0]);
                                        fd.append("fileName", this.GetControlValue());

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.UploadAttachment(fd);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }

                                    case 5: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.EndEdit.call(this);
                                        $step = 6;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Dispose: function () {
                this._f4Elem != null ? this._f4Elem.find("*").off() : null;
                this._f4Elem = null;

                Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.Dispose.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.EnumView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        fields: {
            _selectedValue: null,
            _selectedElem: null
        },
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    value, 
                    $t, 
                    $t1, 
                    fieldValues, 
                    fieldDispValues, 
                    result, 
                    id, 
                    fieldValue, 
                    fieldDisplayValue, 
                    lbl, 
                    input, 
                    color, 
                    select, 
                    $t2, 
                    jqSelect, 
                    fieldValue1, 
                    fieldDisplayValue1, 
                    option, 
                    jqOption, 
                    fontHelper, 
                    fontStyle, 
                    inputGroup, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        value = ($t = (($t1 = this.Record) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1($t1, this.FieldDef.Name) : null), $t != null ? $t : "-1");

                                        fieldValues = System.String.split(System.String.format("-1,{0}", [this.FieldDef.Values]), [44].map(function (i) {{ return String.fromCharCode(i); }}));
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        fieldDispValues = System.String.split(System.String.format("{0},{1}", $taskResult1, this.FieldDef.DisplayValues), [44].map(function (i) {{ return String.fromCharCode(i); }}));


                                        if (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.ButtonPicker) {
                                            result = $("<div>").attr("id", this.ControlId).addClass("btn-group btn-group-toggle wf-enum wf-enum-buttonPicker").attr("data-toggle", "buttons");

                                            id = this.FormControl.CreateUniqueControlId();

                                            for (var i = 0; i < fieldValues.length; i = (i + 1) | 0) {
                                                fieldValue = { v : fieldValues[System.Array.index(i, fieldValues)] };
                                                fieldDisplayValue = fieldDispValues[System.Array.index(i, fieldDispValues)];

                                                lbl = { v : $("<label>").addClass("btn btn-secondary").appendTo(result) };

                                                if (this.IsReadOnly) {
                                                    lbl.v.addClass("disabled");
                                                }

                                                input = $("<input>").attr("type", "radio").attr("name", id).attr("id", id).attr("autocomplete", "off").appendTo(lbl.v);

                                                if (Bridge.referenceEquals(value, fieldValue.v)) {
                                                    this._selectedValue = fieldValue.v;
                                                    this._selectedElem = lbl.v;

                                                    lbl.v.addClass("wf-active");

                                                    color = this.EditControl.GetTextColor(fieldValue.v);
                                                    if (!System.String.isNullOrEmpty(color)) {
                                                        lbl.v.css("background-color", color);
                                                    }
                                                }

                                                lbl.v.append(fieldDisplayValue);

                                                lbl.v.on("click", (function ($me, fieldValue, lbl) {
                                                    return Bridge.fn.bind($me, function () {
                                                        if (!this.IsEnabled) {
                                                            return;
                                                        }

                                                        this._selectedElem != null ? this._selectedElem.removeClass("wf-active") : null;

                                                        this._selectedValue = fieldValue.v;
                                                        this._selectedElem = lbl.v;

                                                        lbl.v.addClass("wf-active");

                                                        result.find("label").css("background-color", "");

                                                        var color1 = this.EditControl.GetTextColor(fieldValue.v);
                                                        if (!System.String.isNullOrEmpty(color1)) {
                                                            lbl.v.css("background-color", color1);
                                                        }

                                                        this.OnChange(this._selectedValue);
                                                    });
                                                })(this, fieldValue, lbl));
                                            }
                                        } else {
                                            select = ($t2 = document.createElement("select"), $t2.id = this.ControlId, $t2.required = this.IsRequired, $t2.className = "form-control wf-enum", $t2.disabled = this.IsReadOnly, $t2);
                                            jqSelect = $(select);

                                            /* 
                                                           select.Add(new HTMLOptionElement()
                                                               {
                                                                   Value = "-1",
                                                                   Text = await WebFormsApp.GetTextAsync("NullPickerValue"),
                                                                   Style = {Color = "black"}
                                                               }
                                                           );
                                            */

                                            for (var i1 = 0; i1 < fieldValues.length; i1 = (i1 + 1) | 0) {
                                                fieldValue1 = fieldValues[System.Array.index(i1, fieldValues)];
                                                fieldDisplayValue1 = fieldDispValues[System.Array.index(i1, fieldDispValues)];

                                                option = ($t2 = document.createElement("option"), $t2.value = fieldValue1, $t2.text = fieldDisplayValue1, $t2.selected = (Bridge.referenceEquals(value, fieldValue1)), $t2);
                                                jqOption = $(option);

                                                if (System.String.isNullOrEmpty(option.style.color)) {
                                                    option.style.color = "black";
                                                }

                                                fontHelper = this.DataItem;
                                                fontStyle = fontHelper.FontStyle;

                                                this.EditControl.SetFontProperties(jqOption, fieldValue1);

                                                if (Bridge.referenceEquals(value, fieldValue1)) {
                                                    this.EditControl.SetFontProperties(jqSelect, fieldValue1);
                                                }

                                                select.add(option);
                                            }

                                            select.onchange = Bridge.fn.bind(this, function (evnt) {
                                                var idx = evnt.currentTarget.selectedIndex;
                                                var item = evnt.currentTarget.item(idx);
                                                select.style.color = item.style.color;
                                                select.style.fontWeight = item.style.fontWeight;

                                                this.OnChange(fieldValues[System.Array.index(idx, fieldValues)]);
                                            });

                                            result = $(select);
                                        }

                                        inputGroup = $("<div>").addClass("input-group").append(result);


                                        $tcs.setResult(inputGroup);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetControlValue: function () {
                if (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.ButtonPicker) {
                    return this._selectedValue;
                }

                return Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.GetControlValue.call(this);
            },
            SetEnabled: function (enable) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.ButtonPicker) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (enable) {
                                            this.MainControl.find("label").removeAttr("disabled");
                                            this.MainControl.find("input").removeAttr("disabled");
                                            this.MainControl.removeClass("disabled");
                                        } else {
                                            this.MainControl.find("label").attr("disabled", "disabled");
                                            this.MainControl.find("input").attr("disabled", "disabled");
                                            this.MainControl.addClass("disabled");
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetEnabled.call(this, enable);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.FormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.IControl],
        statics: {
            methods: {
                AppendClearContent: function (parent, inputElem, clearCallback) {
                    var clearContentClicked = false;
                    var clearElem = $("<div>");
                    clearElem.addClass("input-group-append input-group-text del-icon wf-hidden").on("click", function (e) {
                        e.preventDefault();

                        inputElem.val("");

                        clearContentClicked = true;

                        Adaptica.WebForms.WebApp.Extensions.WFHide(clearElem);
                        inputElem.removeClass("wf-input-w-del");
                        inputElem.focus();

                        if (!Bridge.staticEquals(clearCallback, null)) {
                            clearCallback();
                        }

                    }).appendTo(parent);

                    $("<span>").addClass("fa fa-times-circle").appendTo(clearElem);

                    inputElem.on("input", function () {
                        if (!Bridge.referenceEquals(inputElem.val(), "")) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(clearElem);
                            inputElem.addClass("wf-input-w-del");
                        } else {
                            Adaptica.WebForms.WebApp.Extensions.WFHide(clearElem);
                        }
                    });

                    inputElem.on("focus", function () {
                        if (!Bridge.referenceEquals(inputElem.val(), "")) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(clearElem);
                            inputElem.addClass("wf-input-w-del");
                        }
                    });

                    inputElem.on("blur", function () {
                        window.setTimeout(function () {
                            var clicked = clearContentClicked;
                            clearContentClicked = false;
                            if (clicked) {
                                return;
                            }

                            Adaptica.WebForms.WebApp.Extensions.WFHide(clearElem);
                            inputElem.removeClass("wf-input-w-del");
                        }, 200);
                    });

                    return clearElem;
                }
            }
        },
        fields: {
            _formControl: null,
            _containerContent: null,
            _controls: null,
            _jqControls: null,
            _tabControls: null,
            _vertical: false,
            _scrollX: 0,
            _scrollY: 0,
            _id: 0,
            ParentForm: null,
            CurrencyManager: null,
            Toolbar: null,
            TextFilter: null,
            ActiveFilter: null,
            FormData: null,
            Content: null,
            FormId: null,
            FormInternalID: null,
            IgnoreItems: false,
            IsInlineForm: false,
            CreateControlOnly: false,
            IsFullRowControl: false,
            Containers: null,
            OnToolbarAction: null,
            BreadCrumbSeparator: null,
            _firstLabelControl: null,
            FirstLabelValue: null,
            _searchBar: null,
            _searchInput: null,
            _searchBarClearInput: null,
            EditMode: false,
            _needsReloadData: false,
            _isActivated: false
        },
        props: {
            MainDSPFID: {
                get: function () {
                    return null;
                }
            },
            Controls: {
                get: function () {
                    return this._controls;
                }
            },
            Caption: {
                get: function () {
                    var $t;
                    return ($t = this.FormData) != null ? $t.Caption : null;
                }
            },
            BreadCrumb: {
                get: function () {
                    return (this.ParentForm == null) ? this.Caption : (this.IsInlineForm) ? this.ParentForm.BreadCrumb : System.String.format("{0}{1}{2}", this.ParentForm.BreadCrumb, this.BreadCrumbSeparator, this.Caption);
                }
            },
            NeedsProcessDataOnInsert: {
                get: function () {
                    var ds = this.CurrencyManager.MainDataset;
                    return (ds != null) && (ds.Header != null) && (ds.Header.InsertMode === 1);
                }
            },
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsVisible: {
                get: function () {
                    return this.IsActivated;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            NeedsReloadData: {
                get: function () {
                    return this._needsReloadData;
                },
                set: function (value) {
                    if (!this.FormData.IsMainMenu) {
                        this._needsReloadData = value;
                    }
                }
            },
            MasterID: {
                get: function () {
                    var $t, $t1, $t2;
                    var currRec = this.CurrencyManager.GetCurrentRecord(($t = this.CurrencyManager.MainDataset) != null ? $t.DSPFID : null);
                    /* ???
                                   if ((currRec != null) && (currRec.RecID == null))
                                   {
                                       CurrencyManager.SetCurrentRecord(CurrencyManager.MainDataset?.DSPFID, null);
                                   }
                    */
                    return ($t1 = (currRec != null ? currRec.MasterIDParent : null), $t1 != null ? $t1 : (($t2 = this.CurrencyManager.MainDataset) != null ? $t2.MasterIDParent : null));
                }
            },
            IsActivated: {
                get: function () {
                    return this._isActivated;
                }
            }
        },
        alias: [
            "CreateControlOnly", "Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly",
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._controls = new (System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.IControl)).ctor();
                this._jqControls = new (System.Collections.Generic.List$1($)).ctor();
                this._tabControls = new (System.Collections.Generic.Dictionary$2(System.String,System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.IControl))).ctor();
                this._vertical = false;
                this._scrollX = 0;
                this._scrollY = 0;
                this._id = 0;
                this.TextFilter = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).ctor();
                this.ActiveFilter = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).ctor();
                this.IsFullRowControl = false;
                this.BreadCrumbSeparator = " > ";
            },
            ctor: function (formData, parentForm) {
                if (parentForm === void 0) { parentForm = null; }
                var $t;

                this.$initialize();
                this.FormData = formData;
                this.ParentForm = parentForm;
                this.CurrencyManager = new Adaptica.WebForms.Common.DataModel.CurrencyManager();

                this.FormInternalID = ($t = this.FormData.PFID, $t != null ? $t : this.FormData.PFPFID);
                this.FormId = "form-" + (Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FormInternalID) || "");
            }
        },
        methods: {
            CreateUniqueControlId: function () {
                return System.String.format("{0}_ctrl_{1}", this.FormId, Bridge.box(Bridge.identity(this._id, ((this._id = (this._id + 1) | 0))), System.Int32));
            },
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $taskResult9, 
                    $task10, 
                    $task11, 
                    $taskResult11, 
                    $task12, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    $taskResult1, 
                    template, 
                    tInfo, 
                    $t1, 
                    topContainer, 
                    navBar, 
                    tbarPanel, 
                    $t2, 
                    commonContainer, 
                    commonItems, 
                    activeTab, 
                    firstContainer, 
                    buttonContainer, 
                    editContainer, 
                    container, 
                    $t3, 
                    $t4, 
                    item, 
                    ctrl, 
                    jq, 
                    div, 
                    tabHeader, 
                    tabContent, 
                    tabHeaderOuter, 
                    tabContentOuter, 
                    row, 
                    activeItem, 
                    i, 
                    container1, 
                    $t5, 
                    caption, 
                    hasGrid, 
                    item1, 
                    $t6, 
                    tabItem, 
                    tabElem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,30,31,32,33,35,36,37,38,39,40,41,42], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((($t = this.FormData) != null ? $t.DataModule : null) != null) {
                                            this.CurrencyManager.LoadDataModule(this.FormData.DataModule, this.MainDSPFID);
                                        }

                                        this._formControl = $("<div>").addClass("wf").attr("id", this.FormId);

                                        if ((this.FormData != null) && (this.FormData.IsMainMenu)) {
                                            this._formControl.addClass("wf-mainMenu");
                                        }

                                        if ((this.FormData != null)) {
                                            $step = 1;
                                            continue;
                                        }
                                        $taskResult1 = false;
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemSetFormIdClass");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $taskResult1 = (Bridge.referenceEquals($taskResult2, "1"));
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if ($taskResult1) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 4: {
                                        if (!System.String.isNullOrEmpty(this.FormData.ClearPFPFID)) {
                                            this._formControl.addClass(System.String.format("form-{0}", [this.FormData.ClearPFPFID]));
                                        }

                                        if (!System.String.isNullOrEmpty(this.FormData.ClearPFID)) {
                                            this._formControl.addClass(System.String.format("form-{0}", [this.FormData.ClearPFID]));
                                        }
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        template = null;
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.UseTemplate(($t1 = this.FormData) != null ? $t1.TemplateName : null);
                                        $step = 6;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        tInfo = $taskResult3;
                                        if (!System.String.isNullOrEmpty(tInfo != null ? tInfo.Html : null)) {
                                            template = $(tInfo.Html).appendTo(this._formControl);
                                        }

                                        topContainer = template != null ? template.find(".wf-toolbar") : null;
                                        if ((topContainer == null) || (topContainer.length === 0)) {
                                            topContainer = $("<div>").addClass("wf-container-top sticky-top");

                                            this._formControl.append(topContainer);
                                        }

                                        this.Toolbar = new Adaptica.WebForms.WebApp.Controls.ToolbarControl(this, "wf-form-nav");
                                        this.Toolbar.addOnAction(Bridge.fn.cacheBind(this, this.ToolbarActionHandler));
                                        this._controls.insert(0, this.Toolbar);

                                        this._containerContent = template != null ? template.find("*").filter(".wf-tmpl-fc") : null;

                                        if ((this._containerContent == null) || (this._containerContent.length === 0)) {
                                            this._containerContent = $("<div>").addClass("wf-container-content");

                                            this._formControl.append(this._containerContent);
                                        }

                                        $task4 = this.Toolbar.RenderControl();
                                        $step = 7;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        navBar = $taskResult4;
                                        this._jqControls.add(navBar);

                                        tbarPanel = $();
                                        if (tbarPanel.length > 1) {
                                            window.alert("Multiple toolbar panels defined.");
                                            navBar.appendTo(topContainer);
                                        } else {
                                            navBar.appendTo(tbarPanel.length > 0 ? tbarPanel : topContainer);
                                        }

                                        if ((this.FormData == null) || (this.IgnoreItems) || (this.IsInlineForm)) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 8: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.AddForm(this);

                                        if (this.IsInlineForm) {
                                            $step = 9;
                                            continue;
                                        } 
                                        $step = 11;
                                        continue;
                                    }
                                    case 9: {
                                        /* 
                                                       var formElem = new jQuery("<div>")
                                                           .AddClass("form-row  align-items-center")
                                                           .AppendTo(_containerContent);

                                                       await CreateItems(FormData.Design.Containers[0], formElem);
                                        */

                                        $task5 = this.CreateItems(($t2 = this.FormData.Design.Containers)[System.Array.index(0, $t2)], Bridge.fn.bind(this, function () {
                                            return $("<div>").addClass("form-row  align-items-center").appendTo(this._containerContent);
                                        }));
                                        $step = 10;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 10: {
                                        $task5.getAwaitedResult();
                                        $step = 11;
                                        continue;
                                    }
                                    case 11: {
                                        this.Content = this._formControl;
                                        this.OnFormCreated();

                                        $tcs.setResult(this._formControl);
                                        return;
                                    }
                                    case 12: {
                                        commonContainer = null;
                                        commonItems = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.ContainerItem)).ctor();
                                        activeTab = 0;

                                        firstContainer = 0;
                                        if (this.FormData.Design.Containers.length > 1) {
                                            $step = 13;
                                            continue;
                                        } 
                                        $step = 19;
                                        continue;
                                    }
                                    case 13: {
                                        commonContainer = $("<div>").addClass("wf-commonContainer").appendTo(topContainer);

                                        buttonContainer = null;
                                        editContainer = null;

                                        firstContainer = 1;
                                        activeTab = 1;
                                        container = ($t3 = this.FormData.Design.Containers)[System.Array.index(0, $t3)];
                                        $t4 = Bridge.getEnumerator(System.Linq.Enumerable.from(container.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).orderBy(function (ci) {
                                            return ci.Order;
                                        }));
                                        $step = 14;
                                        continue;
                                    }
                                    case 14: {
                                        if ($t4.moveNext()) {
                                            item = $t4.Current;
                                            $step = 15;
                                            continue;
                                        }
                                        $step = 18;
                                        continue;
                                    }
                                    case 15: {
                                        $task6 = this.CreateControl(item);
                                        $step = 16;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 16: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        ctrl = $taskResult6;
                                        if (ctrl == null) {
                                            $step = 14;
                                            continue;
                                        }

                                        if (System.String.equals(("Label"), item.ItemType)) {
                                            ctrl.Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly = true;
                                        }

                                        this._controls.add(ctrl);

                                        $task7 = ctrl.Adaptica$WebForms$WebApp$Controls$IControl$RenderControl();
                                        $step = 17;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        jq = $taskResult7;
                                        this._jqControls.add(jq);

                                        if (System.String.equals(("Label"), item.ItemType)) {
                                            this._firstLabelControl = Bridge.as(ctrl, Adaptica.WebForms.WebApp.Controls.LabelControl);
                                            this.FirstLabelValue = this._firstLabelControl.DisplayValue;
                                        }

                                        div = $("<div>").addClass("wf-commonContainer-item text-center").append(jq);

                                        if (System.String.equals(("Button"), item.ItemType)) {
                                            if (buttonContainer == null) {
                                                buttonContainer = $("<div>").addClass("wf-buttonContainer");
                                                commonContainer.append(buttonContainer);
                                            }

                                            buttonContainer.append(div);
                                        } else if (System.String.equals(("Edit"), item.ItemType)) {
                                            if (editContainer == null) {
                                                editContainer = $("<div>").addClass("form-row");
                                                commonContainer.append(editContainer);
                                            }

                                            editContainer.append(div);
                                        } else {
                                            buttonContainer = null;
                                            editContainer = null;
                                            commonContainer.append(div);
                                        }
                                        $step = 14;
                                        continue;
                                    }
                                    case 18: {
                                        this.CheckButtonsOnly(container, commonContainer);
                                        $step = 19;
                                        continue;
                                    }
                                    case 19: {
                                        tabHeader = $("<ul>").addClass("nav").attr("role", "tablist");

                                        tabContent = $("<div>").addClass("tab-content wf-tab-content");

                                        if (this._vertical) {
                                            tabHeader.addClass("nav-pills flex-column");

                                            tabHeaderOuter = $("<div>").addClass("col-md-2 mb-3").append(tabHeader);


                                            tabContentOuter = $("<div>").addClass("col-md-10").append(tabContent);

                                            row = $("<div>").addClass("row").append(tabHeaderOuter).append(tabContentOuter).appendTo(this._containerContent);
                                        } else {
                                            tabHeader.addClass("nav-tabs wf-nav-tabs").appendTo(topContainer);

                                            tabContent.appendTo(this._containerContent);
                                        }


                                        this.Containers = new Adaptica.WebForms.WebApp.Controls.FormContainers(this._formControl, topContainer, navBar, commonContainer, this._containerContent);

                                        activeItem = null;

                                        i = firstContainer;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        if ( i < this.FormData.Design.Containers.length ) {
                                            $step = 21;
                                            continue;
                                        }
                                        $step = 38;
                                        continue;
                                    }
                                    case 21: {
                                        container1 = ($t5 = this.FormData.Design.Containers)[System.Array.index(i, $t5)];
                                        caption = container1.Caption;

                                        if (container1.Items.length === 0) {
                                            $step = 37;
                                            continue;
                                        }

                                        if (!this.FormData.IsMainMenu) {
                                            $step = 22;
                                            continue;
                                        } 
                                        $step = 30;
                                        continue;
                                    }
                                    case 22: {
                                        if ((i === 0) || ((i === 1) && (commonItems.Count > 0))) {
                                            $step = 23;
                                            continue;
                                        } 
                                        $step = 29;
                                        continue;
                                    }
                                    case 23: {
                                        if (this.FormData.Design.Containers.length === ((i + 1) | 0)) {
                                            $step = 24;
                                            continue;
                                        } 
                                        $step = 28;
                                        continue;
                                    }
                                    case 24: {
                                        hasGrid = System.Linq.Enumerable.from(this.FormData.Design.Containers, Adaptica.WebForms.Common.DataModel.Container).any(function (c) {
                                            return System.Linq.Enumerable.from(c.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (item1) {
                                                return System.String.equals(("Grid"), item1.ItemType);
                                            });
                                        });
                                        if (hasGrid) {
                                            $step = 25;
                                            continue;
                                        } 
                                        $step = 27;
                                        continue;
                                    }
                                    case 25: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("ListLabel");
                                        $step = 26;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        caption = $taskResult8;
                                        $step = 27;
                                        continue;
                                    }



                                    case 30: {
                                        if ((System.String.isNullOrEmpty(caption)) && (container1.Items.length > 0)) {
                                            $step = 31;
                                            continue;
                                        } 
                                        $step = 35;
                                        continue;
                                    }
                                    case 31: {
                                        item1 = ($t6 = container1.Items)[System.Array.index(0, $t6)];

                                        if (item1.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) {
                                            caption = item1.Caption;
                                        }

                                        if ((container1.Items.length === 1) && (System.String.equals(("Grid"), item1.ItemType))) {
                                            $step = 32;
                                            continue;
                                        } 
                                        $step = 34;
                                        continue;
                                    }
                                    case 32: {
                                        $task9 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("ListLabel");
                                        $step = 33;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 33: {
                                        $taskResult9 = $task9.getAwaitedResult();
                                        caption = $taskResult9;
                                        $step = 34;
                                        continue;
                                    }

                                    case 35: {
                                        tabItem = $("<a>").addClass("nav-link wf-nav-tab").addClass((i === activeTab) ? "active" : "").attr("data-toggle", "tab").attr("href", System.String.format("#{0}_tab{1}", this.FormId, Bridge.box(i, System.Int32))).attr("role", "tab").html(caption);

                                        if (i === activeTab) {
                                            activeItem = tabItem;
                                        }

                                        tabHeader.append($(document.createElement("li")).addClass("nav-item wf-nav-item").append(tabItem));

                                        tabItem.on("shown.bs.tab", Bridge.fn.bind(this, function (e) {
                                            var newTab = $(e.target);
                                            var prevTab = $(e.relatedTarget);

                                            this.TabSwitch(prevTab, newTab);
                                        }));

                                        tabElem = { v : $("<div>").attr("id", System.String.format("{0}_tab{1}", this.FormId, Bridge.box(i, System.Int32))).attr("role", "tabpanel").addClass("tab-pane fade").addClass((i === activeTab) ? "show active" : "") };

                                        /* 
                                                       var formElem = new jQuery("<div>")
                                                           .AddClass("form-row  align-items-center")
                                                           .AppendTo(tabElem);

                                                       await CreateItems(container, formElem, $"#{FormId}_tab{i}");
                                        */
                                        $task10 = this.CreateItems(container1, (function ($me, tabElem) {
                                            return function () {
                                                return $("<div>").addClass("form-row  align-items-center").appendTo(tabElem.v);
                                            };
                                        })(this, tabElem), System.String.format("#{0}_tab{1}", this.FormId, Bridge.box(i, System.Int32)));
                                        $step = 36;
                                        if ($task10.isCompleted()) {
                                            continue;
                                        }
                                        $task10.continue($asyncBody);
                                        return;
                                    }
                                    case 36: {
                                        $task10.getAwaitedResult();
                                        tabContent.append(tabElem.v);
                                        $step = 37;
                                        continue;
                                    }
                                    case 37: {
                                        i = (i + 1) | 0;
                                        $step = 20;
                                        continue;
                                    }
                                    case 38: {
                                        $task11 = this.CheckIsNavigationValid();
                                        $step = 39;
                                        if ($task11.isCompleted()) {
                                            continue;
                                        }
                                        $task11.continue($asyncBody);
                                        return;
                                    }
                                    case 39: {
                                        $taskResult11 = $task11.getAwaitedResult();
                                        if (!$taskResult11) {
                                            $step = 40;
                                            continue;
                                        } 
                                        $step = 41;
                                        continue;
                                    }
                                    case 40: {
                                        this.Dispose();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 41: {
                                        $task12 = this.AddHelpTab(this.FormData, tabHeader, tabContent);
                                        $step = 42;
                                        if ($task12.isCompleted()) {
                                            continue;
                                        }
                                        $task12.continue($asyncBody);
                                        return;
                                    }
                                    case 42: {
                                        $task12.getAwaitedResult();
                                        if (activeItem != null) {
                                            this.TabSwitch(null, activeItem);
                                        }

                                        Adaptica.WebForms.WebApp.WebFormsApp.AddForm(this);

                                        this.Content = this._formControl;
                                        this.OnFormCreated();

                                        $tcs.setResult(this._formControl);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            TabSwitch: function (prevTab, newTab) {
                var $t, $t1;
                var tabItems = { v : null };
                var tabName;

                if (prevTab != null) {
                    tabName = prevTab.attr("href");
                    if ((!System.String.isNullOrEmpty(tabName)) && (this._tabControls.tryGetValue(tabName, tabItems))) {
                        $t = Bridge.getEnumerator(tabItems.v);
                        try {
                            while ($t.moveNext()) {
                                var control = $t.Current;
                                control.Adaptica$WebForms$WebApp$Controls$IControl$OnHide();
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }
                }

                if (newTab != null) {
                    tabName = newTab.attr("href");
                    if ((!System.String.isNullOrEmpty(tabName)) && (this._tabControls.tryGetValue(tabName, tabItems))) {
                        $t1 = Bridge.getEnumerator(tabItems.v);
                        try {
                            while ($t1.moveNext()) {
                                var control1 = $t1.Current;
                                control1.Adaptica$WebForms$WebApp$Controls$IControl$OnShow();
                            }
                        } finally {
                            if (Bridge.is($t1, System.IDisposable)) {
                                $t1.System$IDisposable$Dispose();
                            }
                        }
                    }
                }
            },
            CreateItems: function (container, parentFactory, tabName) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tabItems, 
                    parent, 
                    buttonsOnly, 
                    lastControlsFullRow, 
                    itemIndex, 
                    item, 
                    $t, 
                    control, 
                    isFullRow, 
                    ctrl, 
                    prevCtrl, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        if (tabName === void 0) { tabName = null; }
                                        tabItems = { v : null };
                                        if (!System.String.isNullOrEmpty(tabName)) {
                                            if (!this._tabControls.tryGetValue(tabName, tabItems)) {
                                                tabItems.v = new (System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.IControl)).ctor();
                                                this._tabControls.add(tabName, tabItems.v);
                                            }
                                        }

                                        parent = parentFactory();


                                        buttonsOnly = false;
                                        if (this.FormData.Design.Containers.length <= 2) {
                                            buttonsOnly = this.CheckButtonsOnly(container, parent);

                                            if ((this.FormData.IsMainMenu) || (this.FormData.ShowSearchBar)) {
                                                this.CreateSearchBar();
                                            }
                                        }

                                        lastControlsFullRow = false;
                                        itemIndex = 0;
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        if ( itemIndex < container.Items.length ) {
                                            $step = 2;
                                            continue;
                                        }
                                        $step = 8;
                                        continue;
                                    }
                                    case 2: {
                                        item = ($t = container.Items)[System.Array.index(itemIndex, $t)];

                                        $task1 = this.CreateControl(item);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        control = { v : $taskResult1 };
                                        if (control.v != null) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        isFullRow = control.v.Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl;

                                        this._controls.add(control.v);
                                        tabItems.v != null ? tabItems.v.add(control.v) : null;

                                        $task2 = control.v.Adaptica$WebForms$WebApp$Controls$IControl$RenderControl();
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        ctrl = $taskResult2;
                                        this._jqControls.add(ctrl);

                                        if ((!buttonsOnly) && (Bridge.is(control.v, Adaptica.WebForms.WebApp.Controls.ButtonControl))) {
                                            prevCtrl = (this._controls.Count === 0) ? null : this._controls.getItem(((this._controls.Count - 1) | 0));
                                            if ((prevCtrl != null) && (!(Bridge.is(prevCtrl, Adaptica.WebForms.WebApp.Controls.ButtonControl)))) {
                                                parent = parentFactory();
                                            }
                                        }

                                        if (ctrl.parent().length === 0) {
                                            if (isFullRow) {
                                                if (!lastControlsFullRow) {
                                                    parent = parentFactory();
                                                }

                                                lastControlsFullRow = true;
                                            }

                                            parent.append(ctrl);

                                            if (isFullRow) {
                                                parent = parentFactory();
                                            }
                                        }
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        itemIndex = (itemIndex + 1) | 0;
                                        $step = 1;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateSearchBar: function () {
                var $t;

                if (this._searchBar != null) {
                    return;
                }

                var timeoutId = 0;
                this._searchInput = $(($t = document.createElement("input"), $t.className = "form-control wf-form-search", $t.autocomplete = "new-password", $t.onkeyup = Bridge.fn.bind(this, function (evnt) {
                        if ((evnt.altKey) || (evnt.metaKey)) {
                            return;
                        }

                        if ((evnt.ctrlKey) && (evnt.keyCode !== 86)) {
                            return;
                        }

                        if ((System.String.contains(evnt.key,"Arrow") || (System.Array.indexOfT(Adaptica.WebForms.WebApp.Controls.ControlUtils.IgnoreKeys, evnt.key) > -1))) {
                            return;
                        }

                        window.clearTimeout(timeoutId);

                        evnt.preventDefault();
                        if (evnt.keyCode === 13) {
                            var searchText = (evnt.currentTarget || evnt.target).value;
                            this.FilterButtons(searchText);
                        } else {
                            timeoutId = window.setTimeout(Bridge.fn.bind(this, function () {
                                var searchText1 = (evnt.currentTarget || evnt.target).value;
                                this.FilterButtons(searchText1);
                            }), 500);
                        }
                    }), $t));

                var searchIconElem = $("<span>").addClass("fas fa-search wf-search-icon");

                this._searchBar = $("<div>").addClass("wf-form-search-box fade show").appendTo(this.Containers.Top);

                var row = $("<div>").addClass("wf-search-row").append(searchIconElem).append(this._searchInput).appendTo(this._searchBar);

                this._searchBarClearInput = Adaptica.WebForms.WebApp.Controls.FormControl.AppendClearContent(row, this._searchInput, Bridge.fn.bind(this, function () {
                    this.FilterButtons("");
                }));

            },
            FilterButtons: function (searchText) {
                var $t;
                $t = Bridge.getEnumerator(this._controls);
                try {
                    while ($t.moveNext()) {
                        var ctrl = $t.Current;
                        var btn;
                        if (((btn = Bridge.as(ctrl, Adaptica.WebForms.WebApp.Controls.ButtonControl))) != null) {
                            if (System.String.isNullOrEmpty(searchText) || (System.String.indexOf(btn.Text, searchText, 0, null, 3) > -1)) {
                                btn.OnShow();
                            } else {
                                btn.OnHide();
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            CheckButtonsOnly: function (container, parent) {
                var buttonsOnly = System.Linq.Enumerable.from(container.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).all(function (item) {
                        return System.String.equals(("Button"), item.ItemType);
                    });
                if (buttonsOnly) {
                    parent.addClass("wf-buttonsOnly");
                    return true;
                }

                return false;
            },
            CreateControl: function (item) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    control, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((System.String.equals(("QIMobile.SignaturePad"), item.Action)) || (System.String.equals(("QIMobile.mbwblueqiconnector"), item.Action))) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile, item.Action)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        item.ItemType = "Button";
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DownloadFileActionButton");
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        item.Caption = $taskResult1;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile, item.Action)) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        item.ItemType = "Button";
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("PrintFileActionButton");
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        item.Caption = $taskResult2;
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        control = null;
                                        switch (item.ItemType) {
                                            case "Button": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.ButtonControl(this, item);
                                                    break;
                                                }
                                            case "Edit": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.EditControl(this, item);
                                                    break;
                                                }
                                            case "Grid": 
                                                {

                                                    control = this.CreateGrid(item);

                                                    break;
                                                }
                                            case "Image": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.ImageControl(this, item);
                                                    break;
                                                }
                                            case "Label": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.LabelControl(this, item);
                                                    break;
                                                }
                                            case "Memo": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.MemoControl(this, item);
                                                    break;
                                                }
                                        }

                                        $tcs.setResult(control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateGrid: function (item) {
                var $t;
                var control;

                if (Adaptica.WebForms.WebApp.Controls.GridControlBase.IsKanbanGrid(item)) {
                    control = new Adaptica.WebForms.WebApp.Controls.KanbanGridControl(this, item);
                } else {
                    var useMobileGrid = (window.screen.availWidth <= 420);
                    if (!System.String.isNullOrEmpty(($t = window.self.gridType) != null ? Bridge.toString($t) : null)) {
                        useMobileGrid = (Bridge.equals(("mobile"), window.self.gridType));
                    }

                    if (useMobileGrid) {
                        control = new Adaptica.WebForms.WebApp.Controls.MobileGridControl(this, item);
                    } else {
                        control = new Adaptica.WebForms.WebApp.Controls.DataTablesGridControl(this, item);
                    }
                }

                return control;
            },
            Focus: function () {
                var $t;
                var result = false;

                $t = Bridge.getEnumerator(this._controls);
                try {
                    while ($t.moveNext()) {
                        var control = $t.Current;
                        if (control.Adaptica$WebForms$WebApp$Controls$IControl$Focus()) {
                            result = true;
                            break;
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return result;
            },
            ToolbarActionHandler: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $task4, 
                    $task5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $task10, 
                    $taskResult10, 
                    $task11, 
                    $jumpFromFinally, 
                    handled, 
                    $t, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29], $step);
                            switch ($step) {
                                case 0: {
                                    if (!Bridge.staticEquals(this.OnToolbarAction, null)) {
                                        $step = 1;
                                        continue;
                                    } 
                                    $step = 3;
                                    continue;
                                }
                                case 1: {
                                    $task1 = this.OnToolbarAction(e.Action);
                                    $step = 2;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 2: {
                                    $taskResult1 = $task1.getAwaitedResult();
                                    handled = $taskResult1;
                                    if (handled) {
                                        return;
                                    }
                                    $step = 3;
                                    continue;
                                }
                                case 3: {
                                    $t = e.Action;
                                    if ($t === "Back") {
                                        $step = 4;
                                        continue;
                                    }
                                    else if ($t === "PrevRec") {
                                        $step = 6;
                                        continue;
                                    }
                                    else if ($t === "NextRec") {
                                        $step = 7;
                                        continue;
                                    }
                                    else if ($t === "Insert") {
                                        $step = 8;
                                        continue;
                                    }
                                    else if ($t === "Delete") {
                                        $step = 10;
                                        continue;
                                    }
                                    else if ($t === "Refresh") {
                                        $step = 12;
                                        continue;
                                    }
                                    else if ($t === "AddFavourite") {
                                        $step = 14;
                                        continue;
                                    }
                                    else if ($t === "RemoveFavourite") {
                                        $step = 19;
                                        continue;
                                    }
                                    else if ($t === "Edit") {
                                        $step = 24;
                                        continue;
                                    }
                                    else if ($t === "Save") {
                                        $step = 25;
                                        continue;
                                    }
                                    else if ($t === "Logout") {
                                        $step = 27;
                                        continue;
                                    }
                                    $step = 29;
                                    continue;
                                }
                                case 4: {
                                    $task2 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                    $step = 5;
                                    if ($task2.isCompleted()) {
                                        continue;
                                    }
                                    $task2.continue($asyncBody);
                                    return;
                                }
                                case 5: {
                                    $task2.getAwaitedResult();
                                    return;
                                }
                                case 6: {
                                    this.MovePrevRecord();
                                    return;
                                }
                                case 7: {
                                    this.MoveNextRecord();
                                    return;
                                }
                                case 8: {
                                    $task3 = this.DoInsert(this.CurrencyManager.MainDataset.DSPFID);
                                    $step = 9;
                                    if ($task3.isCompleted()) {
                                        continue;
                                    }
                                    $task3.continue($asyncBody);
                                    return;
                                }
                                case 9: {
                                    $task3.getAwaitedResult();
                                    return;
                                }
                                case 10: {
                                    $task4 = this.DeleteRecord(this.CurrencyManager.MainDataset.DSPFID);
                                    $step = 11;
                                    if ($task4.isCompleted()) {
                                        continue;
                                    }
                                    $task4.continue($asyncBody);
                                    return;
                                }
                                case 11: {
                                    $task4.getAwaitedResult();
                                    return;
                                }
                                case 12: {
                                    $task5 = this.ReloadData();
                                    $step = 13;
                                    if ($task5.isCompleted()) {
                                        continue;
                                    }
                                    $task5.continue($asyncBody);
                                    return;
                                }
                                case 13: {
                                    $task5.getAwaitedResult();
                                    return;
                                }
                                case 14: {
                                    $task6 = Adaptica.WebForms.WebApp.WebFormsApp.AddFavourite(this.FormInternalID, this.Caption, this.MasterID, this.FirstLabelValue);
                                    $step = 15;
                                    if ($task6.isCompleted()) {
                                        continue;
                                    }
                                    $task6.continue($asyncBody);
                                    return;
                                }
                                case 15: {
                                    $taskResult6 = $task6.getAwaitedResult();
                                    if ($taskResult6) {
                                        $step = 16;
                                        continue;
                                    } 
                                    $step = 18;
                                    continue;
                                }
                                case 16: {
                                    $task7 = this.Toolbar.CheckItemsStatus();
                                    $step = 17;
                                    if ($task7.isCompleted()) {
                                        continue;
                                    }
                                    $task7.continue($asyncBody);
                                    return;
                                }
                                case 17: {
                                    $task7.getAwaitedResult();
                                    $step = 18;
                                    continue;
                                }
                                case 18: {
                                    return;
                                }
                                case 19: {
                                    $task8 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveFavourite(this.FormInternalID, this.MasterID);
                                    $step = 20;
                                    if ($task8.isCompleted()) {
                                        continue;
                                    }
                                    $task8.continue($asyncBody);
                                    return;
                                }
                                case 20: {
                                    $taskResult8 = $task8.getAwaitedResult();
                                    if ($taskResult8) {
                                        $step = 21;
                                        continue;
                                    } 
                                    $step = 23;
                                    continue;
                                }
                                case 21: {
                                    $task9 = this.Toolbar.CheckItemsStatus();
                                    $step = 22;
                                    if ($task9.isCompleted()) {
                                        continue;
                                    }
                                    $task9.continue($asyncBody);
                                    return;
                                }
                                case 22: {
                                    $task9.getAwaitedResult();
                                    $step = 23;
                                    continue;
                                }
                                case 23: {
                                    return;
                                }
                                case 24: {
                                    this.BeginEdit();
                                    return;
                                }
                                case 25: {
                                    $task10 = this.EndEdit();
                                    $step = 26;
                                    if ($task10.isCompleted()) {
                                        continue;
                                    }
                                    $task10.continue($asyncBody);
                                    return;
                                }
                                case 26: {
                                    $taskResult10 = $task10.getAwaitedResult();
                                    return;
                                }
                                case 27: {
                                    $task11 = Adaptica.WebForms.WebApp.WebFormsApp.Logout();
                                    $step = 28;
                                    if ($task11.isCompleted()) {
                                        continue;
                                    }
                                    $task11.continue($asyncBody);
                                    return;
                                }
                                case 28: {
                                    $task11.getAwaitedResult();
                                    return;
                                }
                                case 29: {
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            AddHelpTab: function (form, tabHeader, tabContent) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    formId, 
                    $t, 
                    tabItem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (System.String.isNullOrEmpty(form.Description)) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        formId = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(($t = form.PFID, $t != null ? $t : form.PFPFID));

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("HelpTabTitle");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        tabItem = $("<a>").addClass("nav-link wf-nav-tab").attr("data-toggle", "tab").attr("href", System.String.format("#form-{0}_tab_help", [formId])).attr("role", "tab").html($taskResult1);

                                        $(document.createElement("li")).addClass("nav-item wf-nav-item").append(tabItem).appendTo(tabHeader);

                                        $("<div>").attr("id", System.String.format("form-{0}_tab_help", [formId])).attr("role", "tabpanel").addClass("tab-pane fade wf-help").html(System.String.replaceAll(form.Description, "\n", "<br>")).appendTo(tabContent);

                                        tabItem.on("shown.bs.tab", Bridge.fn.bind(this, function (e) {
                                            var newTab = $(e.target);
                                            var prevTab = $(e.relatedTarget);

                                            this.TabSwitch(prevTab, newTab);
                                        }));
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            OnFormCreated: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1], $step);
                            switch ($step) {
                                case 0: {
                                    $task1 = this.ActivateForm();
                                    $step = 1;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 1: {
                                    $task1.getAwaitedResult();
                                    window.setTimeout(Bridge.fn.bind(this, function () {
                                        var $step = 0,
                                            $task1, 
                                            $jumpFromFinally, 
                                            $asyncBody = Bridge.fn.bind(this, function () {
                                                for (;;) {
                                                    $step = System.Array.min([0,1], $step);
                                                    switch ($step) {
                                                        case 0: {
                                                            $task1 = this.OnFormCreatedInternal();
                                                            $step = 1;
                                                            if ($task1.isCompleted()) {
                                                                continue;
                                                            }
                                                            $task1.continue($asyncBody);
                                                            return;
                                                        }
                                                        case 1: {
                                                            $task1.getAwaitedResult();
                                                            return;
                                                        }
                                                        default: {
                                                            return;
                                                        }
                                                    }
                                                }
                                            }, arguments);

                                        $asyncBody();
                                    }), 100);
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            OnFormActivated: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }

                if (this._searchBar != null) {
                    window.setTimeout(Bridge.fn.bind(this, function () {
                        this._searchInput.focus();
                    }), 10);
                }
            },
            OnFormDeactivated: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }
            },
            OnShow: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnShow();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }

                if (this._searchBar != null) {
                    this._searchBar.addClass("show");
                    this._searchBar.removeClass("wf-hidden");
                }
            },
            OnHide: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnHide();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }

                if (this._searchBar != null) {
                    this._searchBar.removeClass("show");
                    this._searchBar.addClass("wf-hidden");
                }
            },
            OnFormCreatedInternal: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    control, 
                    $t1, 
                    ds, 
                    $t2, 
                    $t3, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        $t = Bridge.getEnumerator(this._controls);
                                        try {
                                            while ($t.moveNext()) {
                                                control = $t.Current;
                                                control.Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated();
                                            }
                                        } finally {
                                            if (Bridge.is($t, System.IDisposable)) {
                                                $t.System$IDisposable$Dispose();
                                            }
                                        }

                                        if ((($t1 = this.CurrencyManager) != null ? $t1.MainDataset : null) != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 1: {
                                        ds = this.CurrencyManager.MainDataset;

                                        if ((ds.Header.Read === 0) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanInsert(ds))) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = this.DoInsert(ds.DSPFID);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ((ds.Header.Read === 2) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanUpdate(ds)) || (($t2 = (($t3 = this.FormData.DataModule) != null ? $t3.EditMode : null), $t2 != null ? $t2 : false))) {
                                            this.BeginEdit();
                                        }
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        $task2 = this.Toolbar.CheckItemsStatus();
                                        $step = 6;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task2.getAwaitedResult();
                                        this.CurrencyManager.addOnCurrentRecordChanged(Bridge.fn.bind(this, function (sender, args) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.Toolbar.CheckItemsStatus();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetNeedsReloadParents: function () {
                var parent = this.ParentForm;
                while (parent != null) {
                    parent.NeedsReloadData = true;
                    parent = parent.ParentForm;
                }
            },
            BeginEdit: function () {
                $(System.String.format("#{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FormId)])).addClass("editing");

                this.EditMode = true;
                var focused = false;

                this._controls.ForEach(function (control) {
                    var context;
                    if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                        context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit();
                    }

                    if ((!focused) && (control.Adaptica$WebForms$WebApp$Controls$IControl$Focus())) {
                        focused = true;
                    }
                });
            },
            BeforeEndEdit: function () {
                this._controls.ForEach(function (control) {
                    var context;
                    if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                        context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit();
                    }
                });
            },
            EndEdit: function (save) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (save === void 0) { save = true; }
                                        this.BeforeEndEdit();

                                        $(System.String.format("#{0}", [this.FormId])).removeClass("editing");

                                        if (!(!save)) {
                                            $step = 1;
                                            continue;
                                        }
                                        $taskResult1 = true;
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task2 = this.SaveForm();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $taskResult1 = ($taskResult2);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        result = $taskResult1;

                                        if (result) {
                                            this.EditMode = false;
                                            this._controls.ForEach(function (control) {
                                                var context;
                                                if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                                                    context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit();
                                                }
                                            });
                                        } else {
                                            this._controls.ForEach(function (control) {
                                                var context;
                                                if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                                                    context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed();
                                                }
                                            });
                                        }

                                        if (this.IsInlineForm) {
                                            this.ParentForm.EditMode = false;
                                        }

                                        $task3 = this.Toolbar.CheckItemsStatus();
                                        $step = 4;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AllowInsert: function (DSPFID) {
                if (DSPFID == null) {
                    return false;
                }

                return this._controls.Exists(function (control) {
                    return (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext)).Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert(DSPFID);
                });
            },
            AllowEdit: function (DSPFID) {
                if (DSPFID == null) {
                    return false;
                }

                return this._controls.Exists(function (control) {
                    return (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext)).Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit(DSPFID);
                }) || this.FormData.DataModule.AllowEditMode;
            },
            AllowDelete: function (DSPFID) {
                if (DSPFID == null) {
                    return false;
                }

                return this._controls.Exists(function (control) {
                    return (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext)).Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete(DSPFID);
                });
            },
            CheckIsNavigationValid: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    ds, 
                    defOK, 
                    $t1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,8], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((($t = this.CurrencyManager) != null ? $t.MainDataset : null) != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 8;
                                        continue;
                                    }
                                    case 1: {
                                        ds = this.CurrencyManager.MainDataset;

                                        if (this.IsNavigationInvalid(ds)) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 2: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        defOK = ($t1 = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t1.Caption = $taskResult3, $t1.AddClass = "btn-secondary", $t1);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AppTitle");
                                        $step = 4;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("TooManyRecordError");
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$1($taskResult1, $taskResult2, System.Array.init([defOK], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef));
                                        $step = 6;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task4.getAwaitedResult();
                                        $tcs.setResult(false);
                                        return;
                                    }

                                    case 8: {
                                        $tcs.setResult(true);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsNavigationInvalid$1: function (DSPFID) {
                var ds = this.CurrencyManager.MainDataset;
                if (Bridge.referenceEquals((ds != null ? ds.DSPFID : null), DSPFID)) {
                    return this.IsNavigationInvalid(ds);
                }

                return false;
            },
            IsNavigationInvalid: function (ds) {
                return (ds != null) && (ds.Records.length === 0) && (ds.RecordCount > 0) && (this._controls.TrueForAll(function (control) {
                    var $t, $t1;
                    return ($t = (($t1 = (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null ? $t1.Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation(ds.DSPFID) : null), $t != null ? $t : true);
                }));
            },
            AllowCurrentRecordNavigation$1: function (DSPFID) {
                var ds = this.CurrencyManager.MainDataset;
                if (Bridge.referenceEquals((ds != null ? ds.DSPFID : null), DSPFID)) {
                    return this.AllowCurrentRecordNavigation(ds);
                }

                return false;
            },
            AllowCurrentRecordNavigation: function (ds) {
                return (!this.EditMode) && (!this.IsInlineForm) && (ds != null) && (ds.Records.length > 1) && (this._controls.TrueForAll(function (control) {
                    var $t, $t1;
                    return ($t = (($t1 = (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null ? $t1.Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation(ds.DSPFID) : null), $t != null ? $t : true);
                }));
            },
            MovePrevRecord: function () {
                var ds = this.CurrencyManager.MainDataset;
                if ((ds != null) && (!this.CurrencyManager.IsFirstRecord(ds.DSPFID))) {
                    this.CurrencyManager.MovePrevious(ds.DSPFID);
                }
            },
            MoveNextRecord: function () {
                var ds = this.CurrencyManager.MainDataset;
                if ((ds != null) && (!this.CurrencyManager.IsLastRecord(ds.DSPFID))) {
                    this.CurrencyManager.MoveNext(ds.DSPFID);
                }
            },
            RaiseDataChanged: function () { },
            ExecuteGridDefaultAction: function (DSPFID, record) {
                return System.Threading.Tasks.Task.fromResult(false, System.Boolean);
            },
            DoInsert: function (DSPFID) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        this.CurrencyManager.SetCurrentRecord(DSPFID, Adaptica.WebForms.Common.DataModel.DataHelpers.InsertRecord(this.CurrencyManager, this.CurrencyManager.GetCurrentDataset(DSPFID)));

                                        if (this.NeedsProcessDataOnInsert) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ProcessData(this);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this.RefreshData();
                                        this.BeginEdit();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            DeleteRecord: function (DSPFID) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    defCancel, 
                    $t, 
                    defDelete, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("CancelButton");
                                        $step = 1;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        defCancel = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult2, $t.AddClass = "btn-secondary", $t);

                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DeleteAction");
                                        $step = 2;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        defDelete = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult3, $t.AddClass = "btn-secondary", $t.Handler = Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.DoDelete(DSPFID);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }), $t);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DeletingRecord");
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$1($taskResult1, "Vymazat vybran\u00fd z\u00e1znam?", System.Array.init([defCancel, defDelete], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef));
                                        $step = 4;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task4.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            DoDelete: function (DSPFID) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        this.CurrencyManager.GetCurrentRecord(DSPFID).Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Delete;
                                        this.CurrencyManager.SetCurrentRecord(DSPFID, null);

                                        $task1 = this.SetData();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if (this.ParentForm != null) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task2 = this.ParentForm.ReloadData();
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task2.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm(true);
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task3.getAwaitedResult();
                                        $task4 = this.Toolbar.CheckItemsStatus();
                                        $step = 6;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task4.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ReloadData: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    $t1, 
                    textFilter, 
                    $t2, 
                    activeFilter, 
                    $t3, 
                    masterId, 
                    functionId, 
                    insertedRecordMasterId, 
                    overridenFunctionId, 
                    $t4, 
                    $t5, 
                    $t6, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        if (System.Nullable.eq((($t = this.FormData.DataModule) != null && ($t1 = $t.Datasets) != null ? $t1.length : null), 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        textFilter = (($t2 = System.Collections.Generic.KeyValuePair$2(System.String,System.String), System.Linq.Enumerable.from(this.TextFilter, $t2).toList($t2)).ConvertAll(System.String, function (p) {
                                            return System.String.format("{0}:{1}", p.key, p.value);
                                        }).ToArray()).join("|");
                                        activeFilter = (($t3 = System.Collections.Generic.KeyValuePair$2(System.String,System.String), System.Linq.Enumerable.from(this.ActiveFilter, $t3).toList($t3)).ConvertAll(System.String, function (p) {
                                            return System.String.format("{0}:{1}", p.key, p.value);
                                        }).ToArray()).join("|");

                                        masterId = this.MasterID;
                                        functionId = this.FormData.PFPFID;

                                        insertedRecordMasterId = null;
                                        overridenFunctionId = null;
                                        if ((this.CurrencyManager.MainDataset != null && this.CurrencyManager.MainDataset.Header.Read === 0 && this.CurrencyManager.MainDataset.Header.Insert === 1)) {
                                            insertedRecordMasterId = (System.Linq.Enumerable.from(this.CurrencyManager.MainDataset.Records, Adaptica.WebForms.Common.DataModel.Record).select(function (r) {
                                                return r.RecID;
                                            }).where(function (s) {
                                                return !System.String.isNullOrEmpty(s);
                                            }).ToArray(System.String)).join(";");
                                            overridenFunctionId = this.FormData.PFID;
                                        }

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetFormData", { PFPFID: ($t4 = overridenFunctionId, $t4 != null ? $t4 : ($t5 = functionId, $t5 != null ? $t5 : this.FormData.PFID)), MasterID: ($t6 = insertedRecordMasterId, $t6 != null ? $t6 : masterId), TextFilter: textFilter, ActiveFilter: activeFilter }, "GET", Bridge.fn.bind(this, function (dto) {
                                            var $t7, $t8;
                                            if ((dto != null && ($t7 = dto.FormData) != null ? $t7.DataModule : null) != null) {
                                                Adaptica.WebForms.Common.DataModel.DataHelpers.MergeWith(this.FormData.DataModule, dto.FormData.DataModule, false);
                                                this.CurrencyManager.LoadDataModule(this.FormData.DataModule, this.MainDSPFID);
                                                this.RefreshData();
                                            }

                                            if ((!this.EditMode) && (this.AllowEdit(($t8 = this.CurrencyManager.MainDataset) != null ? $t8.DSPFID : null) && this.FormData.DataModule.EditMode)) {
                                                this.BeginEdit();
                                            }

                                            this.NeedsReloadData = false;

                                            return System.Threading.Tasks.Task.fromResult(null, System.Object);
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.Toolbar.CheckItemsStatus();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RefreshData: function () {
                this._controls.ForEach(function (control) {
                    var context;
                    if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                        context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged();
                    }
                });

                this.FirstLabelValue = this._firstLabelControl != null ? this._firstLabelControl.DisplayValue : null;
            },
            ShowRequiredFieldsError: function (sb) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AppTitle");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2($taskResult1, sb.replace("\n", "<br>").toString(), $taskResult2);
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CheckRequiredFields: function (sb) {
                var result = true;

                this._controls.ForEach(Bridge.fn.bind(this, function (control) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        context, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid(sb);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = !!(result & $taskResult1);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }));

                return result;
            },
            SaveForm: function (silent) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    validationMessage, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5], $step);
                                switch ($step) {
                                    case 0: {
                                        if (silent === void 0) { silent = false; }
                                        if (!Adaptica.WebForms.Common.DataModel.FormHelper.IsChanged(this.FormData)) {
                                            $tcs.setResult(true);
                                            return;
                                        }

                                        result = false;
                                        validationMessage = new System.Text.StringBuilder();
                                        if (!this.CheckRequiredFields(validationMessage)) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.ShowRequiredFieldsError(validationMessage);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 5;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = this.SetData(silent);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        result = $taskResult2;

                                        if (result) {
                                            this.SetNeedsReloadParents();
                                        }
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetData: function (silent) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (silent === void 0) { silent = false; }
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.SetData(this, silent);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;
                                        if (result) {
                                            this.SetNeedsReloadParents();
                                        }

                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ProcessData: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ProcessData(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;
                                        /* 
                                                   if (result)
                                                   {
                                                       SetNeedsReloadParents();
                                                   }
                                        */

                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ActivateForm: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        this._isActivated = true;
                                        this._formControl.show();

                                        this._jqControls.ForEach(Bridge.fn.bind(this, function (control) {
                                            if (!$.contains(this._formControl.get(0),control.get(0))) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(control);
                                            }
                                        }));

                                        window.scrollTo(this._scrollX, this._scrollY);

                                        if (this.NeedsReloadData) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.ReloadData().wait();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = this.Toolbar.CheckItemsStatus();
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        this.OnFormActivated();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RecalculateSize: function () {
                var ch = this._containerContent.height();
                var h = (((window.innerHeight - this.Content.find(".sticky-top").height()) | 0) - 10) | 0;
                this._containerContent.css("height", h);

            },
            DeactivateForm: function () {
                this._scrollX = window.scrollX;
                this._scrollY = window.scrollY;

                this._formControl.hide();
                this._isActivated = false;

                this._jqControls.ForEach(Bridge.fn.bind(this, function (control) {
                    if (!$.contains(this._formControl.get(0),control.get(0))) {
                        Adaptica.WebForms.WebApp.Extensions.WFHide(control);
                    }
                }));

                this.OnFormDeactivated();
            },
            ExecuteFunction: function (pfpfid, evnt) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $task7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $task10, 
                    $taskResult10, 
                    $task11, 
                    $task12, 
                    $task13, 
                    $taskResult13, 
                    $task14, 
                    $task15, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $function, 
                    $t, 
                    masterIDParent, 
                    keyEvent, 
                    win, 
                    $t1, 
                    $taskResult2, 
                    $taskResult1, 
                    ds, 
                    $async_e, 
                    $async_e1, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,19,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,41,42,44,45,46], $step);
                                switch ($step) {
                                    case 0: {
                                        if (evnt === void 0) { evnt = null; }
                                        Adaptica.WebForms.WebApp.WebFormsApp.ShowSplash();
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        $function = System.Linq.Enumerable.from(this.FormData.Functions, Adaptica.WebForms.Common.DataModel.Function).firstOrDefault(function (fn) {
                                            return Bridge.referenceEquals(fn.PFPFID, pfpfid);
                                        }, null);
                                        if ($function == null) {
                                            $returnValue = null;
                                            $step = 44;
                                            continue;
                                        }

                                        $t = $function.FunctionType;
                                        if ($t === Adaptica.WebForms.Common.DataModel.FunctionType.OpenForm) {
                                            $step = 2;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FunctionType.ExecMacro) {
                                            $step = 16;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FunctionType.SpecialFunction) {
                                            $step = 23;
                                            continue;
                                        }
                                        $step = 43;
                                        continue;
                                    }
                                    case 2: {
                                        if (this.EditMode) {
                                            $step = 3;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 3: {
                                        $task5 = this.EndEdit();
                                        $step = 4;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        if (!$taskResult5) {
                                            $step = 5;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        $returnValue = null;
                                        $step = 44;
                                        continue;
                                    }

                                    case 7: {
                                        masterIDParent = null;
                                        if (!System.String.isNullOrEmpty($function.DSPFID) && this.CurrencyManager.GetCurrentRecordOrFirst($function.DSPFID) != null) {
                                            masterIDParent = Adaptica.WebForms.Common.DataModel.FunctionHelper.GetRecordMasterId($function, this.CurrencyManager.GetCurrentRecordOrFirst($function.DSPFID));
                                        }

                                        keyEvent = evnt;
                                        if ((keyEvent != null) && ((keyEvent.ctrlKey || keyEvent.metaKey))) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 14;
                                        continue;
                                    }
                                    case 8: {
                                        win = window.open((window.location.origin || "") + (window.location.pathname || "") + "?FormID=" + (encodeURIComponent(pfpfid) || ""), "_blank");
                                        if ((win == null) || (Bridge.referenceEquals((typeof win), "undefined"))) {
                                            $step = 9;
                                            continue;
                                        } 
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AppTitle");
                                        $step = 10;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 10: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2($taskResult3, "Prohl\u00ed\u017ee\u010d pravd\u011bpodobn\u011b blokuje otev\u00edr\u00e1n\u00ed extern\u00edch oken, pros\u00edm zkontrolujte nastaven\u00ed.<br>V\u011bt\u0161inou je zobrazena ikonka v prav\u00e9 \u010d\u00e1sti adresn\u00edho \u0159\u00e1dku.", $taskResult4);
                                        $step = 12;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 12: {
                                        $task6.getAwaitedResult();
                                        $step = 13;
                                        continue;
                                    }
                                    case 13: {
                                        $returnValue = null;
                                        $step = 44;
                                        continue;
                                    }
                                    case 14: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetForm", { PFPFID: pfpfid, MasterID: masterIDParent }, Bridge.fn.bind(this, function (dto) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm$1(dto, this);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 15;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 15: {
                                        $task7.getAwaitedResult();
                                        $step = 44;
                                        $jumpFromFinally = 43;
                                        continue;
                                    }
                                    case 16: {
                                        this.BeforeEndEdit();

                                        if (($function.SaveDS === 1) && this.EditMode) {
                                            $step = 17;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 17: {
                                        $task8 = this.EndEdit();
                                        $step = 18;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 18: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        if (!$taskResult8) {
                                            $step = 19;
                                            continue;
                                        } 
                                        $step = 20;
                                        continue;
                                    }
                                    case 19: {
                                        $returnValue = null;
                                        $step = 44;
                                        continue;
                                    }

                                    case 21: {
                                        $task9 = this.ExecuteMacro($function);
                                        $step = 22;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 22: {
                                        $task9.getAwaitedResult();
                                        $step = 44;
                                        $jumpFromFinally = 43;
                                        continue;
                                    }
                                    case 23: {
                                        $t1 = $function.SpecFunctionType;
                                        if ($t1 === Adaptica.WebForms.Common.DataModel.SpecFunctionType.Save) {
                                            $step = 24;
                                            continue;
                                        }
                                        else if ($t1 === Adaptica.WebForms.Common.DataModel.SpecFunctionType.Cancel) {
                                            $step = 31;
                                            continue;
                                        }
                                        else if ($t1 === Adaptica.WebForms.Common.DataModel.SpecFunctionType.SaveAndInsert) {
                                            $step = 33;
                                            continue;
                                        }
                                        $step = 42;
                                        continue;
                                    }
                                    case 24: {
                                        if (!!this.EditMode) {
                                            $step = 25;
                                            continue;
                                        }
                                        $taskResult2 = true;
                                        $step = 27;
                                        continue;
                                    }
                                    case 25: {
                                        $task10 = this.EndEdit();
                                        $step = 26;
                                        if ($task10.isCompleted()) {
                                            continue;
                                        }
                                        $task10.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult10 = $task10.getAwaitedResult();
                                        $taskResult2 = $taskResult10;
                                        $step = 27;
                                        continue;
                                    }
                                    case 27: {
                                        if ($taskResult2) {
                                            $step = 28;
                                            continue;
                                        } 
                                        $step = 30;
                                        continue;
                                    }
                                    case 28: {
                                        $task11 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                        $step = 29;
                                        if ($task11.isCompleted()) {
                                            continue;
                                        }
                                        $task11.continue($asyncBody);
                                        return;
                                    }
                                    case 29: {
                                        $task11.getAwaitedResult();
                                        $step = 30;
                                        continue;
                                    }
                                    case 30: {
                                        $step = 44;
                                        $jumpFromFinally = 42;
                                        continue;
                                    }
                                    case 31: {
                                        $task12 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                        $step = 32;
                                        if ($task12.isCompleted()) {
                                            continue;
                                        }
                                        $task12.continue($asyncBody);
                                        return;
                                    }
                                    case 32: {
                                        $task12.getAwaitedResult();
                                        $step = 44;
                                        $jumpFromFinally = 42;
                                        continue;
                                    }
                                    case 33: {
                                        if (!!this.EditMode) {
                                            $step = 34;
                                            continue;
                                        }
                                        $taskResult1 = true;
                                        $step = 36;
                                        continue;
                                    }
                                    case 34: {
                                        $task13 = this.EndEdit();
                                        $step = 35;
                                        if ($task13.isCompleted()) {
                                            continue;
                                        }
                                        $task13.continue($asyncBody);
                                        return;
                                    }
                                    case 35: {
                                        $taskResult13 = $task13.getAwaitedResult();
                                        $taskResult1 = $taskResult13;
                                        $step = 36;
                                        continue;
                                    }
                                    case 36: {
                                        if ($taskResult1) {
                                            $step = 37;
                                            continue;
                                        } 
                                        $step = 41;
                                        continue;
                                    }
                                    case 37: {
                                        ds = this.CurrencyManager.MainDataset;
                                        if (ds != null && ds.Header.Read === 0 && ds.Header.Insert === 1) {
                                            $step = 38;
                                            continue;
                                        } 
                                        $step = 40;
                                        continue;
                                    }
                                    case 38: {
                                        $task14 = this.DoInsert(this.CurrencyManager.MainDataset.DSPFID);
                                        $step = 39;
                                        if ($task14.isCompleted()) {
                                            continue;
                                        }
                                        $task14.continue($asyncBody);
                                        return;
                                    }
                                    case 39: {
                                        $task14.getAwaitedResult();
                                        $step = 40;
                                        continue;
                                    }

                                    case 41: {
                                        $step = 44;
                                        $jumpFromFinally = 42;
                                        continue;
                                    }
                                    case 42: {
                                        $step = 44;
                                        $jumpFromFinally = 43;
                                        continue;
                                    }

                                    case 44: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();

                                        $task15 = this.Toolbar.CheckItemsStatus();
                                        $step = 45;
                                        if ($task15.isCompleted()) {
                                            continue;
                                        }
                                        $task15.continue($asyncBody);
                                        return;
                                    }
                                    case 45: {
                                        $task15.getAwaitedResult();
                                        
                                        if ($jumpFromFinally > -1) {
                                            $step = $jumpFromFinally;
                                            $jumpFromFinally = null;
                                        } else if ($async_e) {
                                            $tcs.setException($async_e);
                                            return;
                                        } else if (Bridge.isDefined($returnValue)) {
                                            $tcs.setResult($returnValue);
                                            return;
                                        }
                                        $step = 46;
                                        continue;
                                    }
                                    case 46: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            if ($step >= 1 && $step <= 43) {
                                $step = 44;
                                $asyncBody();
                                return;
                            }
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ExecuteMacro: function ($function) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    selParams, 
                    $t, 
                    dto, 
                    data, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        selParams = ($t = new Adaptica.WebForms.Common.DTO.SelectionParams(), $t.PFPFID = $function.PFPFID, $t.DSPFID = $function.DSPFID, $t.DataForm = this.FormData, $t.CurrentRecord = this.CurrencyManager.GetCurrentRecord($function.DSPFID), $t);

                                        dto = ($t = new Adaptica.WebForms.Common.DTO.DataDTO(), $t.SelectionParams = selParams, $t);
                                        data = Adaptica.WebForms.WebApp.WebFormsApp.Serialize(dto);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ExecuteFunction", data, "POST", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $task2, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                ex, 
                                                newFormData, 
                                                anyChanges, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3,4,5,6,8,9,10], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    if (System.String.equals(("exception"), dataDTO.Type)) {
                                                                        $step = 1;
                                                                        continue;
                                                                    } else  {
                                                                        $step = 2;
                                                                        continue;
                                                                    }
                                                                }
                                                                case 1: {
                                                                    ex = dataDTO.Data;
                                                                    window.alert(ex.Message);
                                                                    $step = 10;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    newFormData = dataDTO.FormData;
                                                                    anyChanges = Adaptica.WebForms.Common.DataModel.DataHelpers.MergeWith(this.FormData.DataModule, newFormData.DataModule, true);
                                                                    this.CurrencyManager.SetCurrentRecordToFirstFromDataModule($function.DSPFID, newFormData.DataModule);

                                                                    this.RefreshData();

                                                                    if (Adaptica.WebForms.Common.DataModel.FormHelper.IsChanged(newFormData)) {
                                                                        $step = 3;
                                                                        continue;
                                                                    } else  {
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                }
                                                                case 3: {
                                                                    this.BeginEdit();
                                                                    this.Focus();
                                                                    $step = 8;
                                                                    continue;
                                                                }
                                                                case 4: {
                                                                    if (this.EditMode) {
                                                                        $step = 5;
                                                                        continue;
                                                                    } 
                                                                    $step = 7;
                                                                    continue;
                                                                }
                                                                case 5: {
                                                                    $task1 = this.EndEdit();
                                                                    $step = 6;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 6: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    $step = 7;
                                                                    continue;
                                                                }

                                                                case 8: {
                                                                    if (anyChanges) {
                                                                        this.SetNeedsReloadParents();
                                                                    }

                                                                    $task2 = this.Toolbar.CheckItemsStatus();
                                                                    $step = 9;
                                                                    if ($task2.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task2.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 9: {
                                                                    $task2.getAwaitedResult();
                                                                    $step = 10;
                                                                    continue;
                                                                }
                                                                case 10: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetSiblingsByPFPFID: function (PFPFID) {
                var container = System.Linq.Enumerable.from(this.FormData.Design.Containers, Adaptica.WebForms.Common.DataModel.Container).firstOrDefault(function (x) {
                        return System.Linq.Enumerable.from(x.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (i) {
                                return Bridge.referenceEquals(i.PFPFID, PFPFID);
                            });
                    }, null);
                return container != null ? container.Items : null;
            },
            GetSiblingsByFieldName: function (fieldName) {
                var container = System.Linq.Enumerable.from(this.FormData.Design.Containers, Adaptica.WebForms.Common.DataModel.Container).firstOrDefault(function (x) {
                        return System.Linq.Enumerable.from(x.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (i) {
                                return Bridge.referenceEquals(i.FieldName, fieldName);
                            });
                    }, null);
                return container != null ? container.Items : null;
            },
            Dispose: function () {
                var $t;

                Adaptica.WebForms.WebApp.WebFormsApp.ReleaseTemplate(this.FormData.TemplateName);

                this.Toolbar.removeOnAction(Bridge.fn.cacheBind(this, this.ToolbarActionHandler));

                $t = Bridge.getEnumerator(this._controls);
                try {
                    while ($t.moveNext()) {
                        var ctrl = $t.Current;
                        ctrl.System$IDisposable$Dispose();
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                this._jqControls.ForEach(function (jqControl) {
                    jqControl.off();
                });
                this._searchInput != null ? this._searchInput.off() : null;
                this._searchBarClearInput != null ? this._searchBarClearInput.off() : null;

                this._controls.clear();
                this._jqControls.clear();

                this._formControl.remove();
                this._formControl = null;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.SetView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        fields: {
            _itemsCount: 0,
            _items: null,
            _splittedValues: null,
            _splittedDispValues: null,
            _isSetting: false
        },
        props: {
            Value: {
                get: function () {
                    var $t;
                    return ($t = this.Record) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue($t, this.FieldDef) : null;
                }
            }
        },
        ctors: {
            init: function () {
                this._items = new (System.Collections.Generic.List$1($)).ctor();
            },
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    value, 
                    jq, 
                    i, 
                    itemValue, 
                    input, 
                    $t, 
                    div, 
                    group, 
                    onText, 
                    offText, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        value = { };
                                        System.Int32.tryParse(this.Value, value);

                                        jq = $("<div>");
                                        this.MainControl = jq;

                                        this._splittedValues = this.FieldDef.Values.split(",");
                                        this._splittedDispValues = this.FieldDef.DisplayValues.split(",");
                                        this._itemsCount = this._splittedValues.length;
                                        i = 0;
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        if ( i < this._itemsCount ) {
                                            $step = 2;
                                            continue;
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 2: {
                                        itemValue = System.Int32.parse(this._splittedValues[System.Array.index(i, this._splittedValues)]);

                                        input = $(($t = document.createElement("input"), $t.id = (this.ControlId || "") + (System.String.format("_{0}", [Bridge.box(i, System.Int32)]) || ""), $t.type = "checkbox", $t)).attr("data-toggle", "toggle").attr("data-style", "round");

                                        this._items.add(input);

                                        if ((value.v & (1 << itemValue)) !== 0) {
                                            input.attr("checked", "checked");
                                        }

                                        div = $("<div>").addClass("form-row wf-set");

                                        $("<div>").addClass("col-auto wf-set-label").append(this._splittedDispValues[System.Array.index(i, this._splittedDispValues)]).appendTo(div);

                                        $("<div>").addClass("col-auto wf-set-control").append(input).appendTo(div);

                                        group = $("<div>").addClass("input-group").append(div).appendTo(jq);


                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        onText = $taskResult1;
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        offText = $taskResult2;

                                        eval(System.String.format("input.bootstrapToggle({{ size: 'sm', on: '{0}', off: '{1}' }});", onText, offText));
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        i = (i + 1) | 0;
                                        $step = 1;
                                        continue;
                                    }
                                    case 6: {
                                        $tcs.setResult(jq);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetEnabled: function (enable) {
                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var item = this._items.getItem(i);

                    if (enable) {
                        item.bootstrapToggle('enable');
                    } else {
                        item.bootstrapToggle('disable');
                    }
                }


                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetChangeHandler: function () {
                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var item = this._items.getItem(i);
                    item.change(Bridge.fn.bind(this, function () {
                        if (!this._isSetting) {
                            this.OnChange(this.GetControlValue());
                        }
                    }));
                }
            },
            GetControlValue: function () {
                var value = 0;

                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var ch = this._items.getItem(i).prop("checked");
                    if (ch) {
                        var itemValue = System.Int32.parse(this._splittedValues[System.Array.index(i, this._splittedValues)]);
                        value = value | (1 << itemValue);
                    }
                }

                return Bridge.toString(value);
            },
            SetControlValue: function (value) {
                this._isSetting = true;
                var v = { };
                System.Int32.tryParse(value, v);

                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var itemValue = System.Int32.parse(this._splittedValues[System.Array.index(i, this._splittedValues)]);
                    var item = this._items.getItem(i);

                    var isDisabled = item.prop("disabled") || item.prop("readonly");
                    if (isDisabled) {
                        item.bootstrapToggle('enable');
                    }

                    if ((v.v > -1) && (v.v & (1 << itemValue)) !== 0) {
                        item.bootstrapToggle('on');
                    } else {
                        item.bootstrapToggle('off');
                    }

                    if (isDisabled) {
                        item.bootstrapToggle('disable');
                    }
                }

                this._isSetting = false;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ToolbarControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.IControl,Adaptica.WebForms.WebApp.Controls.IControlDataContext],
        fields: {
            _formControl: null,
            _formId: null,
            _classesToAdd: null,
            _caption: null,
            _items: null,
            CreateControlOnly: false,
            IsFullRowControl: false,
            IsEnabled: false,
            IsVisible: false,
            IsRequired: false
        },
        events: {
            OnAction: null
        },
        props: {
            NeedsProcessDataOnInsert: {
                get: function () {
                    return false;
                }
            }
        },
        alias: [
            "CreateControlOnly", "Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly",
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "BeforeEndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit",
            "EndFailed", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed",
            "AllowInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert",
            "AllowEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit",
            "AllowDelete", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "NeedsProcessDataOnInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$NeedsProcessDataOnInsert",
            "IsValid", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._items = new (System.Collections.Generic.Dictionary$2(System.String,$)).ctor();
                this.IsFullRowControl = false;
            },
            ctor: function (formControl, classedToAdd) {
                if (classedToAdd === void 0) { classedToAdd = null; }

                this.$initialize();
                this._formControl = formControl;

                this._formId = (this._formControl != null) ? this._formControl.FormId : "tmp-toolbar";

                this._classesToAdd = classedToAdd;
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tBar, 
                    rightContainer, 
                    showLogout, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7], $step);
                                switch ($step) {
                                    case 0: {
                                        tBar = $("<div>").addClass("bg-faded wf-form-nav");

                                        if (!System.String.isNullOrEmpty(this._classesToAdd)) {
                                            tBar.addClass(this._classesToAdd);
                                        }

                                        if (Adaptica.WebForms.WebApp.WebFormsApp.OpenFormsCount > 0) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BackButton");
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $("<div>").attr("title", $taskResult1).append($("<a>").addClass("fas fa-long-arrow-alt-left wf-nav-icon").click(Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Back")) : null;
                                        }))).appendTo(tBar);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this._caption = $("<div>").addClass("wf-tBar-caption").html(this._formControl.Caption).attr("title", this._formControl.BreadCrumb).appendTo(tBar);

                                        rightContainer = $("<div>").addClass("d-flex flex-row justify-content-end").attr("id", "navb").appendTo(tBar);

                                        $task2 = this.CreateItems(rightContainer);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        showLogout = true;
                                        if (Adaptica.WebForms.WebApp.WebFormsApp.IsRunningInPortal) {
                                            showLogout = QIWebForms.showLogout;
                                        }

                                        if (showLogout) {
                                            $step = 5;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 5: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("LogoutAction");
                                        $step = 6;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        $("<div>").addClass("nav-item wf-nav-logout").attr("title", $taskResult3).append($("<a>").addClass("fas fa-sign-out-alt wf-nav-icon").click(Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Logout")) : null;
                                        }))).appendTo(rightContainer);
                                        $step = 7;
                                        continue;
                                    }
                                    case 7: {
                                        $tcs.setResult(tBar);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Focus: function () {
                return false;
            },
            OnFormCreated: function () { },
            OnFormActivated: function () { },
            OnFormDeactivated: function () { },
            OnShow: function () { },
            OnHide: function () { },
            CreateItem: function (parent, id, titleId, itemClass, imageClass, handler) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    iClass, 
                    $t, 
                    item, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        iClass = ($t = imageClass, $t != null ? $t : "");
                                        if ((System.String.indexOf(iClass, "far ") === -1) && (System.String.indexOf(iClass, "fas ") === -1)) {
                                            iClass = "fas " + (iClass || "");
                                        }

                                        item = $("<div>").attr("id", id).addClass(System.String.format("nav-item {0}", [System.String.replaceAll(System.String.replaceAll(itemClass, "fas ", ""), "far ", "")])).append($("<a>").addClass(System.String.format("{0} wf-nav-icon nav-link", [iClass])).click(handler)).appendTo(parent);

                                        if (!System.String.isNullOrEmpty(titleId)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync(titleId);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        item.attr("title", $taskResult1);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this._items.add(id, item);

                                        $tcs.setResult(item);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateItems: function (tbItems) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    id, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        id = System.String.format("{0}-nav-prev", [this._formId]);
                                        $task1 = this.CreateItem(tbItems, id, "PrevRecAction", "wf-nav-prev", "fa-angle-left", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("PrevRec")) : null;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        id = System.String.format("{0}-nav-next", [this._formId]);
                                        $task2 = this.CreateItem(tbItems, id, "NextRecAction", "wf-nav-next", "fa-angle-right", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("NextRec")) : null;
                                        }));
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        id = System.String.format("{0}-nav-insert", [this._formId]);
                                        $task3 = this.CreateItem(tbItems, id, "InsertAction", "wf-nav-insert", "fa-plus", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Insert")) : null;
                                        }));
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        id = System.String.format("{0}-nav-refresh", [this._formId]);
                                        $task4 = this.CreateItem(tbItems, id, "Refresh", "wf-nav-refresh", "fa-redo-alt", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Refresh")) : null;
                                        }));
                                        $step = 4;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        /* 
                                                   id = $"{_formId}-nav-addFavourite";
                                                   await CreateItem(tbItems, id, "AddFavourite", "wf-nav-addFavourite", "far fa-heart", () =>
                                                       {
                                                           OnAction?.Invoke(this, new ToolbarEventArgs("AddFavourite"));
                                                       });

                                                   id = $"{_formId}-nav-removeFavourite";
                                                   await CreateItem(tbItems, id, "RemoveFavourite", "wf-nav-removeFavourite", "fas fa-heart", () =>
                                                       {
                                                           OnAction?.Invoke(this, new ToolbarEventArgs("RemoveFavourite"));
                                                       });
                                        */

                                        id = System.String.format("{0}-nav-edit", [this._formId]);
                                        $task5 = this.CreateItem(tbItems, id, "Edit", "wf-nav-edit", "fa-pen", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Edit")) : null;
                                        }));
                                        $step = 5;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        id = System.String.format("{0}-nav-save", [this._formId]);
                                        $task6 = this.CreateItem(tbItems, id, "SaveAction", "wf-nav-save", "fa-save", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Save")) : null;
                                        }));
                                        $step = 6;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        id = System.String.format("{0}-nav-delete", [this._formId]);
                                        $task7 = this.CreateItem(tbItems, id, "DeleteAction", "wf-nav-delete", "fa-trash", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Delete")) : null;
                                        }));
                                        $step = 7;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $task8 = this.CheckItemsStatus();
                                        $step = 8;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task8.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CheckItemsStatus: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $task4, 
                    $task5, 
                    $task6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    action, 
                    id, 
                    cm, 
                    ds, 
                    isFilterForm, 
                    allowNav, 
                    $t, 
                    $taskResult6, 
                    $taskResult5, 
                    $taskResult4, 
                    $taskResult3, 
                    $taskResult2, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,12,13,14,15,16,17,18,19,20,21,22,24], $step);
                                switch ($step) {
                                    case 0: {
                                        action = { };

                                        cm = this._formControl != null ? this._formControl.CurrencyManager : null;
                                        ds = cm != null ? cm.MainDataset : null;

                                        isFilterForm = Bridge.is(this._formControl, Adaptica.WebForms.WebApp.Controls.FilterSelectionFormControl);

                                        allowNav = (ds != null) && (($t = (this._formControl != null ? this._formControl.AllowCurrentRecordNavigation$1(ds.DSPFID) : null), $t != null ? $t : false));
                                        id = System.String.format("{0}-nav-prev", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((allowNav)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                                if (this._formControl.CurrencyManager.IsFirstRecord(ds.DSPFID)) {
                                                    action.v.find("a.nav-link").addClass("disabled");
                                                } else {
                                                    action.v.find("a.nav-link").removeClass("disabled");
                                                }
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-next", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((allowNav)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                                if (this._formControl.CurrencyManager.IsLastRecord(ds.DSPFID)) {
                                                    action.v.find("a.nav-link").addClass("disabled");
                                                } else {
                                                    action.v.find("a.nav-link").removeClass("disabled");
                                                }
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-insert", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((ds != null) && (this._formControl.AllowInsert(ds.DSPFID)) && (!this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-refresh", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((this._formControl != null) && (!this._formControl.EditMode) && (!this._formControl.IsInlineForm) && (!this._formControl.FormData.IsMainMenu) && (!(Bridge.is(this._formControl, Adaptica.WebForms.WebApp.Controls.SelectionFormControl)))) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-addFavourite", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 1: {
                                        if ((this._formControl != null)) {
                                            $step = 2;
                                            continue;
                                        }
                                        $taskResult6 = false;
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.IsInFavourites(this._formControl.FormInternalID, this._formControl.MasterID);
                                        $step = 3;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $taskResult6 = (!$taskResult7);
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ($taskResult6) {
                                            $step = 5;
                                            continue;
                                        }
                                        $taskResult5 = false;
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        $taskResult5 = (!this._formControl.IsInlineForm);
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        if ($taskResult5) {
                                            $step = 7;
                                            continue;
                                        }
                                        $taskResult4 = false;
                                        $step = 8;
                                        continue;
                                    }
                                    case 7: {
                                        $taskResult4 = (!this._formControl.FormData.IsMainMenu);
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        if ($taskResult4) {
                                            $step = 9;
                                            continue;
                                        } else  {
                                            $step = 10;
                                            continue;
                                        }
                                    }
                                    case 9: {
                                        Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                        $step = 11;
                                        continue;
                                    }
                                    case 10: {
                                        Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                        $step = 11;
                                        continue;
                                    }

                                    case 12: {
                                        id = System.String.format("{0}-nav-removeFavourite", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            $step = 13;
                                            continue;
                                        } 
                                        $step = 24;
                                        continue;
                                    }
                                    case 13: {
                                        if ((this._formControl != null)) {
                                            $step = 14;
                                            continue;
                                        }
                                        $taskResult3 = false;
                                        $step = 16;
                                        continue;
                                    }
                                    case 14: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.IsInFavourites(this._formControl.FormInternalID, this._formControl.MasterID);
                                        $step = 15;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 15: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult3 = ($taskResult8);
                                        $step = 16;
                                        continue;
                                    }
                                    case 16: {
                                        if ($taskResult3) {
                                            $step = 17;
                                            continue;
                                        }
                                        $taskResult2 = false;
                                        $step = 18;
                                        continue;
                                    }
                                    case 17: {
                                        $taskResult2 = (!this._formControl.IsInlineForm);
                                        $step = 18;
                                        continue;
                                    }
                                    case 18: {
                                        if ($taskResult2) {
                                            $step = 19;
                                            continue;
                                        }
                                        $taskResult1 = false;
                                        $step = 20;
                                        continue;
                                    }
                                    case 19: {
                                        $taskResult1 = (!this._formControl.FormData.IsMainMenu);
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        if ($taskResult1) {
                                            $step = 21;
                                            continue;
                                        } else  {
                                            $step = 22;
                                            continue;
                                        }
                                    }
                                    case 21: {
                                        Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                        $step = 23;
                                        continue;
                                    }
                                    case 22: {
                                        Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                        $step = 23;
                                        continue;
                                    }

                                    case 24: {
                                        id = System.String.format("{0}-nav-edit", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((ds != null) && (this._formControl.AllowEdit(ds.DSPFID)) && (!this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-save", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((this._formControl != null) && (!isFilterForm) && (this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-delete", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((ds != null) && (this._formControl.AllowDelete(ds.DSPFID)) && (!this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetCaption: function (caption) {
                this._caption.html(caption);
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.CheckItemsStatus();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeforeEndEdit: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.CheckItemsStatus();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndFailed: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            AllowInsert: function (DSPFID) {
                return false;
            },
            AllowEdit: function (DSPFID) {
                return false;
            },
            AllowDelete: function (DSPFID) {
                return false;
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return true;
            },
            IsValid: function (sb) {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            RaiseDataChanged: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.CheckItemsStatus();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Dispose: function () {
                var $t;
                if (!Bridge.staticEquals(this.OnAction, null)) {
                    $t = Bridge.getEnumerator(Bridge.fn.getInvocationList(this.OnAction));
                    try {
                        while ($t.moveNext()) {
                            var d = $t.Current;
                            this.removeOnAction(d);
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }
                this._items.clear();
                this._formControl = null;
                this._caption = null;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ButtonControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _fullControl: null,
            _function: null
        },
        props: {
            IsDownloadButton: {
                get: function () {
                    return (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile));
                }
            },
            IsSignatureButton: {
                get: function () {

                    return Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature);
                }
            },
            Text: {
                get: function () {
                    return this.DataItem.Caption;
                }
            },
            IsEnabled: {
                get: function () {
                    var $function = this._function || this.GetFunction();
                    if ($function == null) {
                        return false;
                    }

                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord($function.DSPFID);
                    if ((!System.String.isNullOrEmpty($function.DSPFID)) && (rec != null)) {
                        if (!System.String.isNullOrEmpty($function.EnableExpr)) {
                            return Adaptica.WebForms.Common.DataModel.FunctionHelper.IsFunctionEnabledForRecord($function, rec);
                        }

                        if ($function.FunctionType === 1) {
                            return true;
                        }

                        if ($function.FunctionType === 2) {
                            switch ($function.SpecFunctionType) {
                                case 0: 
                                    return this.FormControl.EditMode;
                                case 1: 
                                    return true;
                                case 2: 
                                    return this.FormControl.EditMode;
                            }
                        }

                        return true;
                    }

                    return true;
                }
            },
            Dataset: {
                get: function () {
                    if (this._dset == null) {
                        var fn = this._function || this.GetFunction();
                        if (fn != null) {
                            this._dset = this.FormControl.CurrencyManager.GetCurrentDataset(fn.DSPFID);
                        } else if (!System.String.isNullOrEmpty(this.DataItem.DSPFID)) {
                            this._dset = Bridge.ensureBaseProperty(this, "Dataset").$Adaptica$WebForms$WebApp$Controls$ControlBase$Dataset;
                        }
                    }

                    return this._dset;
                }
            },
            IsVisible: {
                get: function () {
                    var result;
                    var $function = this._function || this.GetFunction();
                    if ($function == null) {
                        if (!System.String.isNullOrEmpty(this.DataItem.Action)) {
                            var btnRec = this.FormControl.CurrencyManager.GetCurrentRecord(this.Dataset.DSPFID);
                            var value = btnRec != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(btnRec, this.FieldDef) : null;
                            result = !System.String.isNullOrEmpty(value);

                            return result;
                        }

                        return false;
                    }

                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord($function.DSPFID);

                    result = (Adaptica.WebForms.Common.DataModel.FunctionHelper.IsAvailable($function) && Adaptica.WebForms.Common.DataModel.FunctionHelper.IsFunctionVisibleForRecord($function, rec) || $function.FunctionType !== 0);

                    return result;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            ImageSource: {
                get: function () {
                    var $function = this._function || this.GetFunction();
                    if (($function != null ? $function.Icon : null) != null) {
                        return "data:image/png;base64," + ($function.Icon || "");
                    }
                    return null;
                }
            }
        },
        alias: [
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus"
        ],
        ctors: {
            ctor: function (form, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, form, dataItem);
                this._function = this.GetFunction();
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $function, 
                    isTile, 
                    colorHex, 
                    wfTileCss, 
                    htmlBtn, 
                    $t, 
                    s, 
                    formButtons, 
                    siblings, 
                    rec, 
                    value, 
                    div, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        $function = this._function || this.GetFunction();
                                        isTile = (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) || (this.FormControl.FormData.IsMainMenu);
                                        colorHex = isTile ? $function.FunctionColorHex : null;
                                        wfTileCss = (isTile) ? " wf-tile" : "";

                                        htmlBtn = ($t = document.createElement("button"), $t.type = "button", $t);
                                        if (!System.String.isNullOrEmpty(this.DataItem.FieldName)) {
                                            htmlBtn.id = this.ControlId;
                                        }

                                        htmlBtn.addEventListener("click", Bridge.fn.bind(this, function (e) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.ButtonClick(e);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        if (!System.String.isNullOrEmpty(colorHex)) {
                                            htmlBtn.style.backgroundColor = System.String.format("#{0}", [colorHex]);
                                        }

                                        if (isTile) {
                                            htmlBtn.className = "btn wf-tileButton";
                                        } else if (this.DataItem.Type !== Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.Unknown) {
                                            s = System.Enum.toString(Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum, this.DataItem.Type);
                                            htmlBtn.className = "btn " + String.fromCharCode(String.fromCharCode(s.charCodeAt(0)).toLowerCase().charCodeAt(0)) + (s.substr(1) || "");
                                        } else {
                                            htmlBtn.className = "btn button";
                                        }

                                        formButtons = false;
                                        this.MainControl = $(htmlBtn);
                                        if (!System.String.isNullOrEmpty(this.DataItem.PFPFID)) {
                                            siblings = this.FormControl.GetSiblingsByPFPFID(this.DataItem.PFPFID);
                                            if ((siblings != null) && (System.Linq.Enumerable.from(siblings, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (i) {
                                                return (!Bridge.referenceEquals(i.ItemType, "Button"));
                                            }))) {
                                                formButtons = true;
                                                this.MainControl.addClass("wf-formButton");
                                            }
                                        }

                                        if (($function != null) || (this.IsDownloadButton)) {
                                            if ((isTile) && (!System.String.isNullOrEmpty($function.Icon))) {
                                                htmlBtn.appendChild(($t = new Image(), $t.src = "data:image/png;base64," + ($function.Icon || ""), $t.className = "wf-buttonImage", $t));
                                            }

                                            htmlBtn.appendChild(($t = document.createElement("div"), $t.className = "wf-buttonCaption", $t.innerHTML = this.DataItem.Caption, $t));
                                        }

                                        if ((isTile) && (!formButtons)) {
                                            $tcs.setResult(this.MainControl);
                                            return;
                                        }

                                        if (this.IsDownloadButton) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 1: {
                                        rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.Dataset.DSPFID);
                                        value = rec != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, this.FieldDef) : null;
                                        if (System.String.isNullOrEmpty(value)) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetEnabled.call(this, false);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }

                                    case 5: {
                                        div = $(document.createElement("div")).addClass("form-group col-auto mb-auto wf-control wf-button");
                                        if (formButtons) {
                                            div.append($("<div>").addClass(System.String.format("wf-label-div{0}", [wfTileCss])).append($("<label>").addClass("wf-empty").html("&nbsp;")));
                                        }

                                        if (this.IsDownloadButton) {
                                            $(($t = document.createElement("label"), $t.innerHTML = this.FieldDef.Label, $t)).appendTo(div);
                                        }

                                        div.append(htmlBtn);
                                        this._fullControl = div;

                                        if (!this.IsDownloadButton) {
                                            $step = 6;
                                            continue;
                                        } 
                                        $step = 8;
                                        continue;
                                    }
                                    case 6: {
                                        $task2 = this.SetControlProperties();
                                        $step = 7;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $task2.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(div);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CurrentRecordChanged: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $function, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        $function = this._function || this.GetFunction();

                                        if ((e == null) || (($function != null) && (Bridge.referenceEquals(e.DSPFID, $function.DSPFID)))) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.SetVisible(this.IsVisible);
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task2.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ButtonClick: function (e) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    rec, 
                    value, 
                    rec1, 
                    value1, 
                    dSig, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,10], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.IsDownloadButton) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.Dataset.DSPFID);
                                        value = rec != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, this.FieldDef) : null;
                                        if (!System.String.isNullOrEmpty(value)) {
                                            window.open("GetFile.ashx" + (value || ""));
                                        }
                                        $step = 10;
                                        continue;
                                    }
                                    case 2: {
                                        if (this.IsSignatureButton) {
                                            $step = 3;
                                            continue;
                                        } else  {
                                            $step = 7;
                                            continue;
                                        }
                                    }
                                    case 3: {
                                        rec1 = this.FormControl.CurrencyManager.GetCurrentRecord(this.Dataset.DSPFID);
                                        value1 = rec1 != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec1, this.FieldDef) : null;
                                        if (!System.String.isNullOrEmpty(value1)) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        dSig = new Adaptica.WebForms.WebApp.DataSignature();
                                        dSig.OnSuccessfulSignature = Bridge.fn.bind(this, function (signatureResult) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.FormControl.ReloadData();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                this.FormControl.SetNeedsReloadParents();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        });

                                        $task1 = dSig.SignData(value1);
                                        $step = 5;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task1.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        $step = 9;
                                        continue;
                                    }
                                    case 7: {
                                        $task2 = this.FormControl.ExecuteFunction(this.DataItem.PFPFID, e);
                                        $step = 8;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task2.getAwaitedResult();
                                        $step = 9;
                                        continue;
                                    }

                                    case 10: {
                                        e.preventDefault();
                                        e.stopPropagation();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return true;
            },
            SetControlProperties: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.SetVisible(this.IsVisible);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.SetEnabled(this.IsEnabled);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $task3 = this.SetRequired(this.IsRequired);
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetEnabled: function (enabled) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.IsDownloadButton) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetEnabled.call(this, enabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.IsDownloadButton) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        if (this._fullControl == null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetVisible.call(this, visible);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        if (visible) {
                                            this._fullControl.removeClass("wf-hidden");
                                        } else {
                                            this._fullControl.addClass("wf-hidden");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            OnShow: function () {
                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnShow.call(this);

                var isTile = (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) || (this.FormControl.FormData.IsMainMenu);
                var ctrl = (isTile) ? this.MainControl : this._fullControl;

                if (ctrl == null) {
                    return;
                }

                if (this.IsVisible) {
                    ctrl.removeClass("wf-hidden");
                }
            },
            OnHide: function () {
                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnHide.call(this);

                var isTile = (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) || (this.FormControl.FormData.IsMainMenu);
                var ctrl = (isTile) ? this.MainControl : this._fullControl;

                ctrl != null ? ctrl.addClass("wf-hidden") : null;
            },
            Focus: function () {
                return false;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.GridControlBase", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        statics: {
            methods: {
                IsKanbanGrid: function (containerItem) {
                    var grid = containerItem;
                    return System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).any(function (col) {
                            return Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIKanban);
                        });
                }
            }
        },
        fields: {
            _formData: null,
            _currentRecord: null,
            _tableScrollTop: 0,
            _control: null,
            _gridContentElem: null,
            _searchBar: null,
            _searchBarClearInput: null,
            _searchInput: null,
            _searchText: null,
            _filterOnServer: false,
            _isVisible: false,
            _orgOnToolbarAction: null,
            ImageDisplayType: 0,
            ImageMinSize: 0,
            _searchBarFilterIcon: null,
            _activeFilter: null
        },
        props: {
            AllowInlineInsert: {
                get: function () {
                    var ds = this.Dataset;
                    return (ds != null) && (ds.Header != null) && (ds.Header.ReadOnly === 0) && (ds.Header.Insert === 1);
                }
            },
            HasFilters: {
                get: function () {
                    var $t;
                    return System.Nullable.gt((($t = this.Dataset) != null ? $t.Header.Filters.length : null), 0);
                }
            },
            IsActiveFilter: {
                get: function () {
                    return this.FormControl.ActiveFilter.containsKey(this.DataItem.DSPFID);
                }
            }
        },
        alias: [
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "AllowEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit",
            "AllowDelete", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete",
            "AllowInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this.ImageDisplayType = 1;
            },
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
                this._formData = formControl.FormData;

                formControl.CurrencyManager.addOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedWrapper));

                this.InitImageDisplayType();
            }
        },
        methods: {
            InitImageDisplayType: function () {
                var idt = window.getComputedStyle(window.document.documentElement).getPropertyValue("--wf-grid-imageDisplayType");
                if (!System.String.isNullOrEmpty(idt)) {
                    this.ImageDisplayType = System.Int32.parse(idt);
                }

                if (this.ImageDisplayType === 1) {
                    var s = "";
                    var defCss = Adaptica.WebForms.WebApp.WebFormsApp.GetCssStyle(".wf-dataImage", ["width", "height", "max-height"]);
                    if (defCss != null) {
                        s = (!Bridge.referenceEquals(defCss[System.Array.index(0, defCss)], "")) ? defCss[System.Array.index(0, defCss)] : defCss[System.Array.index(1, defCss)];
                    }

                    if ((Bridge.referenceEquals(s, "")) || (Bridge.referenceEquals(s, "auto"))) {
                        s = window.getComputedStyle(window.document.documentElement).getPropertyValue("--wf-dataImage-size");
                    }

                    if (!Bridge.referenceEquals(s, "")) {
                        if (System.String.indexOf(s, "px") > -1) {
                            s = System.String.replaceAll(s, "px", "");
                        }
                        var minSize = { };
                        System.Int32.tryParse(s, minSize);
                        this.ImageMinSize = minSize.v;
                    }
                }
            },
            CurrentRecordChangedWrapper: function (sender, args) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1], $step);
                            switch ($step) {
                                case 0: {
                                    $task1 = this.CurrentRecordChanged(sender, args);
                                    $step = 1;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 1: {
                                    $task1.getAwaitedResult();
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    ds, 
                    header, 
                    fieldDefs, 
                    gridWrapper, 
                    gridElem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        this._orgOnToolbarAction = this.FormControl.OnToolbarAction;
                                        this.FormControl.OnToolbarAction = Bridge.fn.cacheBind(this, this.OnToolbarActionInternal);

                                        ds = this.Dataset;
                                        header = ds != null ? ds.Header : null;
                                        fieldDefs = header != null ? header.FieldDefs : null;

                                        $task1 = this.CreateSearchBar(ds, fieldDefs);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        gridWrapper = $("<div>").addClass("wf-grid-wrapper");

                                        gridElem = $("<div>").addClass("col-auto wf-grid").appendTo(gridWrapper);

                                        this._gridContentElem = $("<div>").addClass("wf-grid-content").appendTo(gridElem);

                                        this._control = gridWrapper;

                                        $task2 = this.RefreshRecords(ds, fieldDefs);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            OnToolbarActionInternal: function (action) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $task4, 
                    $taskResult4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    cloned, 
                    ds, 
                    $t, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9], $step);
                                switch ($step) {
                                    case 0: {
                                        if (Bridge.referenceEquals(action, "Insert")) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 1: {
                                        cloned = Adaptica.WebForms.Common.DataModel.FormHelper.CloneFormOnlyForInlineInsert(this._formData, this.FormControl.CurrencyManager, this.DataItem.DSPFID);

                                        if (this.NeedsProcessDataOnInsert) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ProcessData(this.FormControl, cloned);
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        ds = System.Linq.Enumerable.from(cloned.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).first(Bridge.fn.bind(this, function (x) {
                                            return Bridge.referenceEquals(x.DSPFID, this.DataItem.DSPFID);
                                        }));
                                        $task3 = this.CreateAutoFieldsForm(cloned, ds, ($t = ds.Records)[System.Array.index(0, $t)], this.GetGridColumns(), true);
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(true);
                                        return;
                                    }
                                    case 6: {
                                        if ((!Bridge.staticEquals(this._orgOnToolbarAction, null))) {
                                            $step = 7;
                                            continue;
                                        }
                                        $taskResult1 = false;
                                        $step = 9;
                                        continue;
                                    }
                                    case 7: {
                                        $task4 = this._orgOnToolbarAction(action);
                                        $step = 8;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        $taskResult1 = ($taskResult4);
                                        $step = 9;
                                        continue;
                                    }
                                    case 9: {
                                        $tcs.setResult($taskResult1);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateSearchBar: function (ds, fieldDefs) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    timeoutId, 
                    $t, 
                    searchIconElem, 
                    row, 
                    row2, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        this._filterOnServer = (ds.RecordCount > 0) && (ds.RecordCount !== ds.Records.length);

                                        if ((this._searchBar != null) || (Bridge.is(this.FormControl, Adaptica.WebForms.WebApp.Controls.FilterSelectionFormControl)) || ((ds.Records.length <= 0) && (!this._filterOnServer))) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        timeoutId = 0;
                                        this._searchInput = $(($t = document.createElement("input"), $t.className = "form-control wf-grid-search", $t.onkeyup = Bridge.fn.bind(this, function (evnt) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1,2,3,4], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                if ((evnt.altKey) || (evnt.metaKey)) {
                                                                    return;
                                                                }

                                                                if ((evnt.ctrlKey) && (evnt.keyCode !== 86)) {
                                                                    return;
                                                                }

                                                                if ((System.String.contains(evnt.key,"Arrow") || (System.Array.indexOfT(Adaptica.WebForms.WebApp.Controls.ControlUtils.IgnoreKeys, evnt.key) > -1))) {
                                                                    return;
                                                                }

                                                                window.clearTimeout(timeoutId);

                                                                evnt.preventDefault();
                                                                if (evnt.keyCode === 13) {
                                                                    $step = 1;
                                                                    continue;
                                                                } else  {
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                            }
                                                            case 1: {
                                                                this._searchText = (evnt.currentTarget || evnt.target).value;
                                                                $task1 = this.SetTextFilter(ds, fieldDefs);
                                                                $step = 2;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 2: {
                                                                $task1.getAwaitedResult();
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 3: {
                                                                timeoutId = window.setTimeout(Bridge.fn.bind(this, function () {
                                                                    var $step = 0,
                                                                        $task1, 
                                                                        $jumpFromFinally, 
                                                                        $asyncBody = Bridge.fn.bind(this, function () {
                                                                            for (;;) {
                                                                                $step = System.Array.min([0,1], $step);
                                                                                switch ($step) {
                                                                                    case 0: {
                                                                                        this._searchText = (evnt.currentTarget || evnt.target).value;
                                                                                        $task1 = this.SetTextFilter(ds, fieldDefs);
                                                                                        $step = 1;
                                                                                        if ($task1.isCompleted()) {
                                                                                            continue;
                                                                                        }
                                                                                        $task1.continue($asyncBody);
                                                                                        return;
                                                                                    }
                                                                                    case 1: {
                                                                                        $task1.getAwaitedResult();
                                                                                        return;
                                                                                    }
                                                                                    default: {
                                                                                        return;
                                                                                    }
                                                                                }
                                                                            }
                                                                        }, arguments);

                                                                    $asyncBody();
                                                                }), 500);
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 4: {
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }), $t));

                                        searchIconElem = $("<span>").addClass("fas fa-search wf-search-icon");

                                        this._searchBar = $("<div>").addClass("wf-grid-search-box fade wf-hidden");

                                        row = $("<div>").addClass("wf-search-row").appendTo(this._searchBar);

                                        if (this.HasFilters) {
                                            this._searchBar.addClass("wf-with-filter");
                                            row.append(this.CreateSearchBarFilterIcon());
                                        }

                                        row.append(searchIconElem).append(this._searchInput);

                                        row2 = $("<div>").addClass("wf-search-row").appendTo(this._searchBar);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("RecordsCountFormatted", [Bridge.toString(this.Dataset.RecordCount)]);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $("<div>").addClass("wf-grid-recCount").html($taskResult1).appendTo(row2);

                                        this._searchBarClearInput = Adaptica.WebForms.WebApp.Controls.FormControl.AppendClearContent(row, this._searchInput, Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                this._searchText = this._searchInput.val();
                                                                $task1 = this.SetTextFilter(ds, fieldDefs);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        this._searchBar.appendTo(this.FormControl.Containers.Top);
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetTextFilter: function (ds, fieldDefs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    textFilters, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (!this._filterOnServer) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.RefreshRecords(ds, fieldDefs);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        textFilters = this.FormControl.TextFilter;
                                        if (textFilters.containsKey(this.DataItem.DSPFID)) {
                                            if (System.String.isNullOrEmpty(this._searchText)) {
                                                textFilters.remove(this.DataItem.DSPFID);
                                            } else {
                                                textFilters.setItem(this.DataItem.DSPFID, this._searchText);
                                            }
                                        } else {
                                            if (!System.String.isNullOrEmpty((this._searchText))) {
                                                textFilters.add(this.DataItem.DSPFID, this._searchText);
                                            }
                                        }

                                        $task2 = this.FormControl.ReloadData();
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RefreshRecords: function (dset, fieldDefs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    header, 
                    recs, 
                    cnt, 
                    $t, 
                    $t1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if (dset === void 0) { dset = null; }
                                        if (fieldDefs === void 0) { fieldDefs = null; }

                                        if (dset == null) {
                                            dset = this.FormControl.CurrencyManager.GetCurrentDataset(this.DataItem.DSPFID);
                                        }


                                        /* 
                                                   var currRec = FormControl.CurrencyManager.GetCurrentRecord(dset.DSPFID);
                                                   if ((currRec != null) && (currRec.RecID == null))  // new record
                                                   {
                                                       WebFormsApp.Log("Current record is empty or has empty RecId.");
                                                       //CreateAutoFieldsForm(dset, currRec, GetGridColumns(), true);
                                                       return;
                                                   }
                                        */

                                        header = dset != null ? dset.Header : null;
                                        if (fieldDefs == null) {
                                            fieldDefs = header != null ? header.FieldDefs : null;
                                            if (fieldDefs == null) {
                                                $tcs.setResult(null);
                                                return;
                                            }
                                        }

                                        this.ClearTable();

                                        recs = (System.String.isNullOrEmpty(this._searchText)) ? System.Linq.Enumerable.from(dset.Records, Adaptica.WebForms.Common.DataModel.Record).orderBy(function (rec) {
                                            return rec.RecNo;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.Record) : System.Linq.Enumerable.from(dset.Records, Adaptica.WebForms.Common.DataModel.Record).where(Bridge.fn.bind(this, function (rec) {
                                            return System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).any(Bridge.fn.bind(this, function (fd) {
                                                return this.SearchMatcher(rec, fd, this._searchText);
                                            }));
                                        })).orderBy(function (rec) {
                                            return rec.RecNo;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.Record);

                                        $task1 = this.CreateGridContent(this._formData, dset, this.DataItem, fieldDefs, recs);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        if (this._searchBar != null) {
                                            $step = 2;
                                            continue;
                                        } else  {
                                            $step = 4;
                                            continue;
                                        }
                                    }
                                    case 2: {
                                        cnt = (System.String.isNullOrEmpty(this._searchText)) ? this.Dataset.RecordCount : recs.length;
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("RecordsCountFormatted", [Bridge.toString(cnt)]);
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        this._searchBar.find(".wf-grid-recCount").html($taskResult2);

                                        if ((this._isVisible) && ((cnt > 1) || (!System.String.isNullOrEmpty(this._searchText)) || (this.IsActiveFilter))) {
                                            this._searchBar.addClass("show");
                                            this._searchBar.removeClass("wf-hidden");
                                        } else {
                                            this._searchBar.removeClass("show");
                                            this._searchBar.addClass("wf-hidden");
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task3 = this.CreateSearchBar(this.Dataset, ($t = this.Dataset) != null && ($t1 = $t.Header) != null ? $t1.FieldDefs : null);
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task3.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        window.setTimeout(Bridge.fn.bind(this, function () {
                                            this._searchInput != null ? this._searchInput.focus() : null;
                                        }), 10);
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ClearTable: function () {
                this._gridContentElem.find("*").off("click");
                this._gridContentElem.empty();
            },
            SearchMatcher: function (rec, fd, textToSearch) {
                return (fd.Hidden === 0) && (fd.Type !== Adaptica.WebForms.Common.DataModel.FieldType.Blob) && (System.String.indexOf(Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fd), textToSearch, 0, null, 3) > -1);
            },
            SetColumnValue: function (col, valueElem, fieldDef, value, text, color) {
                if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreateMobileFontValue(valueElem, value);
                    }
                } else if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreateDownloadFileValue(valueElem, value);
                    }
                } else if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreatePrintFileValue(valueElem, value);
                    }
                } else if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIURL)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreateUrlValue(valueElem, value);
                    }
                } else {
                    if ((!System.String.isNullOrEmpty(text)) && (fieldDef.Type >= Adaptica.WebForms.Common.DataModel.FieldType.Memo) && (fieldDef.Type <= Adaptica.WebForms.Common.DataModel.FieldType.LString)) {
                        valueElem.html(System.String.replaceAll(text, "_", "_<wbr>")).attr("title", text);
                    } else {
                        valueElem.html(text).attr("title", text);
                    }

                    Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontProperties$1(color, fieldDef.Values, col.FontStyle, valueElem, value);
                }
            },
            CreateMobileFontValue: function (valueElem, value) {
                var icon = $("<i>");

                Adaptica.WebForms.WebApp.Controls.EditView.SetFontIconValue(icon, value);

                valueElem.append(icon);
            },
            CreateUrlValue: function (valueElem, value) {
                var url = value;

                if ((System.String.indexOf(url, "://", 0, null, 4) === -1) && (!System.String.startsWith(url, "//"))) {
                    url = System.String.format("//{0}", [value]);
                }

                var jq = $("<a>").attr("href", "#").html(value).on("click", function (e) {
                    e.stopPropagation();
                    e.preventDefault();

                    window.open(url);
                });

                valueElem.append(jq);
            },
            CreateDownloadFileValue: function (valueElem, value) {
                this.CreateFileLinkValue("paperclip", valueElem, value);
            },
            CreatePrintFileValue: function (valueElem, value) {
                this.CreateFileLinkValue("print", valueElem, value);
            },
            CreateFileLinkValue: function (iconClass, valueElem, value) {
                var icon = $("<i>").addClass(System.String.format("fas fa-{0}", [iconClass]));

                var groupIconInnerDiv = $("<div>").addClass("input-group-text").append(icon);

                var groupIconDiv = $("<div>").attr("id", System.String.format("{0}-append", [this.ControlId])).addClass("input-group-append").on("click", function (e) {
                    e.stopPropagation();
                    e.preventDefault();

                    window.open("GetFile.ashx" + (value || ""));
                }).append(groupIconInnerDiv);

                valueElem.append(groupIconDiv);
            },
            OnRowClick: function (form, dset, recs, cols, localRecNo) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    rec, 
                    $function, 
                    cloned, 
                    ds, 
                    $t, 
                    masterId, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.IsEditing) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        rec = recs[System.Array.index(localRecNo, recs)];
                                        this.FormControl.CurrencyManager.SetCurrentRecord(dset.DSPFID, rec);

                                        $task1 = this.FormControl.ExecuteGridDefaultAction(dset.DSPFID, rec);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ($taskResult1) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 2: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        $function = System.Linq.Enumerable.from(form.Functions, Adaptica.WebForms.Common.DataModel.Function).firstOrDefault(Bridge.fn.bind(this, function (fn) {
                                            return (Bridge.referenceEquals(fn.DSPFID, dset.DSPFID)) && (this.IsFunctionEnabled(fn, rec));
                                        }), null);
                                        if ($function == null) {
                                            $step = 4;
                                            continue;
                                        } else  {
                                            $step = 6;
                                            continue;
                                        }
                                    }
                                    case 4: {
                                        cloned = Adaptica.WebForms.Common.DataModel.FormHelper.CloneFormOnlyForInlineEdit(this._formData, this.FormControl.CurrencyManager, this.DataItem.DSPFID, rec);
                                        ds = System.Linq.Enumerable.from(cloned.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).first(Bridge.fn.bind(this, function (x) {
                                            return Bridge.referenceEquals(x.DSPFID, this.DataItem.DSPFID);
                                        }));
                                        $task2 = this.CreateAutoFieldsForm(cloned, ds, ($t = ds.Records)[System.Array.index(0, $t)], this.GetGridColumns(), false);
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task2.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 6: {
                                        masterId = Adaptica.WebForms.Common.DataModel.FunctionHelper.GetRecordMasterId($function, rec);
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetForm", { PFPFID: $function.PFPFID, MasterID: masterId }, Bridge.fn.bind(this, function (dto) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm$1(dto, this.FormControl);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 7;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $task3.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetSearchableColumnList: function (dset) {
                var columns = System.Linq.Enumerable.from(dset.Header.FieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).where(function (fd) {
                        return function (_o1) {
                                _o1.add(1);
                                _o1.add(2);
                                _o1.add(4);
                                _o1.add(5);
                                _o1.add(6);
                                _o1.add(7);
                                _o1.add(8);
                                _o1.add(9);
                                return _o1;
                            }(new (System.Collections.Generic.List$1(System.Int32)).ctor()).contains(fd.Type) && (fd.Hidden === 0);
                    }).select(function (fd) {
                    return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetSearchHint(fd);
                }).toList(System.String);

                columns.Sort();

                return Bridge.toArray(columns).join("<br>");
            },
            CreateAutoFieldsForm: function (form, dset, rec, gridColumns, beginEdit) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    fDefs, 
                    ds, 
                    c, 
                    items, 
                    col, 
                    fieldDef, 
                    fd, 
                    ci, 
                    $t, 
                    edit, 
                    currentFormId, 
                    inlineForm, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (beginEdit === void 0) { beginEdit = false; }
                                        fDefs = dset.Header.FieldDefs;

                                        ds = dset;
                                        if (!Bridge.referenceEquals(ds.DSPFID, this.DataItem.DSPFID)) {
                                            ds = System.Linq.Enumerable.from(form.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).firstOrDefault(Bridge.fn.bind(this, function (d) {
                                                return Bridge.referenceEquals(d.DSPFID, this.DataItem.DSPFID);
                                            }), null);
                                        }

                                        c = new Adaptica.WebForms.Common.DataModel.Container();
                                        items = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.ContainerItem)).ctor();

                                        for (var i = 0; i < gridColumns.length; i = (i + 1) | 0) {
                                            col = { v : gridColumns[System.Array.index(i, gridColumns)] };

                                            fieldDef = System.Linq.Enumerable.from(fDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                                return function (fld) {
                                                    return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                                };
                                            })(this, col), null);
                                            if (fieldDef.Hidden !== 0) {
                                                continue;
                                            }

                                            fd = null;
                                            ci = null;
                                            if (ds != null) {
                                                fd = System.Linq.Enumerable.from(ds.Header.FieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).firstOrDefault((function ($me, col) {
                                                    return function (f) {
                                                        return Bridge.referenceEquals(f.Name, col.v.FieldName);
                                                    };
                                                })(this, col), null);
                                            }
                                            if (fd != null && fd.Type === 3) {
                                                ci = ($t = new Adaptica.WebForms.Common.DataModel.Image(), $t.ItemType = "Image", $t);
                                            } else if (fd != null && fd.Type === 4) {
                                                ci = ($t = new Adaptica.WebForms.Common.DataModel.Memo(), $t.ItemType = "Memo", $t);
                                            } else {
                                                edit = ($t = new Adaptica.WebForms.Common.DataModel.Edit(), $t.ItemType = "Edit", $t.FontColor = col.v.FontColor, $t.FontStyle = col.v.FontStyle, $t);
                                                ci = edit;
                                            }

                                            ci.DSPFID = this.DataItem.DSPFID;
                                            ci.FieldName = col.v.FieldName;
                                            ci.Action = col.v.Action;
                                            ci.Order = col.v.Order;
                                            items.add(ci);
                                        }

                                        c.Items = System.Linq.Enumerable.from(items, Adaptica.WebForms.Common.DataModel.ContainerItem).orderBy(function (i1) {
                                            return i1.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.ContainerItem);
                                        form.Design.Containers = System.Array.init([c], Adaptica.WebForms.Common.DataModel.Container);

                                        currentFormId = Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.FormId;
                                        currentFormId = (currentFormId || "") + "_AutoFieldsForm";

                                        inlineForm = ($t = new Adaptica.WebForms.WebApp.Controls.InlineFormControl(this.DataItem, form, this.FormControl), $t.FormId = currentFormId, $t.IsInlineForm = true, $t);
                                        inlineForm.CurrencyManager.SetCurrentRecord(dset.DSPFID, rec);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DisplayFormControl(inlineForm);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        inlineForm.RefreshData();

                                        if (beginEdit) {
                                            inlineForm.BeginEdit();
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            HandleImageOnLoad: function (img) {
                img.on("load", Bridge.fn.bind(this, function () {
                    var imgElem = Bridge.as(img.get(0), HTMLImageElement);

                    img.off("load");

                    var w = imgElem.naturalWidth;
                    var h = imgElem.naturalHeight;
                    if (this.ImageDisplayType === 0) {
                        if (h > w) {
                            img.removeClass("wf-dataImage");
                            img.addClass("wf-dataImage-h");
                        }
                    } else {
                        var canvas = Bridge.as(document.createElement("canvas"), HTMLCanvasElement);
                        var ctx = Bridge.as(canvas.getContext("2d"), CanvasRenderingContext2D);
                        if (w > h) {
                            var newWidth = System.Decimal.toInt((System.Decimal(this.ImageMinSize).div(System.Decimal(h))).mul(System.Decimal(w)), System.Int32);
                            canvas.width = newWidth;
                            canvas.height = this.ImageMinSize;
                            ctx.drawImage(imgElem, 0, 0, newWidth, this.ImageMinSize);
                        } else {
                            var newHeight = System.Decimal.toInt((System.Decimal(this.ImageMinSize).div(System.Decimal(w))).mul(System.Decimal(h)), System.Int32);
                            canvas.width = this.ImageMinSize;
                            canvas.height = newHeight;
                            ctx.drawImage(imgElem, 0, 0, this.ImageMinSize, newHeight);
                        }

                        var url = canvas.toDataURL();
                        img.attr("src", url);
                    }

                }));
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return false;
            },
            AllowEdit: function (DSPFID) {
                return this.FormControl.CurrencyManager.GetCurrentDataset(this.DataItem.DSPFID).Header.SaveMode === 1;
            },
            AllowDelete: function (DSPFID) {
                return false;
            },
            AllowInsert: function (DSPFID) {
                return Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.AllowInsert.call(this, DSPFID) || this.AllowInlineInsert;
            },
            IsFunctionEnabled: function (f, record) {
                return Adaptica.WebForms.Common.DataModel.FunctionHelper.IsFunctionEnabledForRecord(f, record);
            },
            RaiseDataChanged: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.RaiseDataChanged.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.RefreshRecords();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Focus: function () {
                return false;
            },
            OnShow: function () {
                this._isVisible = true;

                if ((this._searchBar != null) && (this.Dataset.RecordCount > 1)) {
                    this._searchBar.addClass("show");
                    this._searchBar.removeClass("wf-hidden");
                }
                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnShow.call(this);
            },
            OnHide: function () {
                this._isVisible = false;

                if (this._searchBar != null) {
                    this._searchBar.removeClass("show");
                    this._searchBar.addClass("wf-hidden");
                }

                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnHide.call(this);
            },
            Dispose: function () {
                if (this.IsDisposed) {
                    return;
                }

                this.FormControl.CurrencyManager.removeOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedWrapper));

                if (this._gridContentElem != null) {
                    this._gridContentElem.find(".wf-grid-row").off("click");
                    this._gridContentElem.empty();
                }

                if ((!Bridge.staticEquals(this._orgOnToolbarAction, null)) && (Bridge.staticEquals(this.FormControl.OnToolbarAction, this._orgOnToolbarAction))) {
                    this.FormControl.OnToolbarAction = this._orgOnToolbarAction;
                }

                this._searchInput != null ? this._searchInput.off() : null;
                this._searchBarClearInput != null ? this._searchBarClearInput.off() : null;

                this._formData = null;
                this._currentRecord = null;
                this._control = null;
                this._gridContentElem = null;
                this._searchInput = null;
                this._searchBar = null;

                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.Dispose.call(this);
            },
            GetActiveFilterNames: function () {
                var $t, $t1;
                return (($t = this.Dataset) != null && ($t1 = $t.Header.Filters) != null ? System.Linq.Enumerable.from($t1, Adaptica.WebForms.Common.DataModel.Filter).select(function (f) {
                        return f.Name;
                    }).toList(System.String) : null) || new (System.Collections.Generic.List$1(System.String)).ctor();
            },
            FilterForName: function (filterName) {
                var $t;
                return ($t = this.Dataset) != null ? System.Linq.Enumerable.from($t.Header.Filters, Adaptica.WebForms.Common.DataModel.Filter).firstOrDefault(function (f) {
                        return Bridge.referenceEquals(f.Name, filterName);
                    }, null) : null;
            },
            ActiveFilterFor: function (filterName) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    filter, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        filter = this.FilterForName(filterName);
                                        if (filter == null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.ApplyActiveFilter(null);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        if (filter.Type === 1) {
                                            $step = 4;
                                            continue;
                                        } else  {
                                            $step = 6;
                                            continue;
                                        }
                                    }
                                    case 4: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ShowFilterForm(null, filter, Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.ApplyActiveFilter(filter);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task2.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 6: {
                                        $task3 = this.ApplyActiveFilter(filter);
                                        $step = 7;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $task3.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ApplyActiveFilter: function (filter) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    filterId, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        this._activeFilter = filter;

                                        filterId = filter != null ? filter.ID : null;
                                        if (this.FormControl.ActiveFilter.containsKey(this.DataItem.DSPFID)) {
                                            if (System.String.isNullOrEmpty(filterId)) {
                                                this.FormControl.ActiveFilter.remove(this.DataItem.DSPFID);
                                                this._searchBarFilterIcon.removeClass("mdi-filter").addClass("mdi-filter-outline");
                                                this.SetCaption();
                                            } else {
                                                this.FormControl.ActiveFilter.setItem(this.DataItem.DSPFID, filterId);
                                                this._searchBarFilterIcon.removeClass("mdi-filter-outline").addClass("mdi-filter");
                                                this.SetCaption();
                                            }
                                        } else {
                                            if (!System.String.isNullOrEmpty(filterId)) {
                                                this.FormControl.ActiveFilter.add(this.DataItem.DSPFID, filterId);
                                                this._searchBarFilterIcon.removeClass("mdi-filter-outline").addClass("mdi-filter");
                                                this.SetCaption();
                                            }
                                        }


                                        $task1 = this.FormControl.ReloadData();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetCaption: function () {
                if (this._activeFilter == null) {
                    this.FormControl.Toolbar.SetCaption(this.FormControl.Caption);
                    this._searchBarFilterIcon.removeAttr("title");
                } else {
                    this.FormControl.Toolbar.SetCaption((this.FormControl.Caption || "") + " &nbsp; &nbsp; Filtr: " + (this._activeFilter.Name || ""));
                    this._searchBarFilterIcon.attr("title", this._activeFilter.Name);
                }
            },
            CreateSearchBarFilterIcon: function () {
                this._searchBarFilterIcon = $("<i>");
                this._searchBarFilterIcon.addClass("mdi mdi-filter-outline wf-filter-icon").on("click", Bridge.fn.bind(this, function (ev) {
                    this.DisplayActionSheet(ev.currentTarget);
                    ev.preventDefault();
                }));

                return this._searchBarFilterIcon;
            },
            DisplayActionSheet: function (elem) {
                var cancelAction = Adaptica.WebForms.WebApp.WebFormsApp.GetText("CancelButton");
                var removeFilterAction = this.IsActiveFilter ? Adaptica.WebForms.WebApp.WebFormsApp.GetText("CancelFilterAction") : null;
                Adaptica.WebForms.WebApp.Controls.ActionSheet.DisplayActionSheet(elem, Adaptica.WebForms.WebApp.WebFormsApp.GetText("ActiveFilter"), cancelAction, removeFilterAction, Bridge.fn.bind(this, function (selectedFilter) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7], $step);
                                switch ($step) {
                                    case 0: {
                                        if (!Bridge.referenceEquals(selectedFilter, cancelAction)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 1: {
                                        if (Bridge.referenceEquals(selectedFilter, removeFilterAction)) {
                                            $step = 2;
                                            continue;
                                        } else  {
                                            $step = 4;
                                            continue;
                                        }
                                    }
                                    case 2: {
                                        $task1 = this.ActiveFilterFor(null);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task2 = this.ActiveFilterFor(selectedFilter);
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task2.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }), this.GetActiveFilterNames().ToArray());
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.EditControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _control: null,
            IsGridEdit: false
        },
        props: {
            IsEnabled: {
                get: function () {
                    return (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileCurrentLocalTime)) || Bridge.ensureBaseProperty(this, "IsEnabled").$Adaptica$WebForms$WebApp$Controls$ControlBase$IsEnabled;
                }
            },
            IsVisible: {
                get: function () {
                    if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileCurrentLocalTime)) {
                        return false;
                    }

                    return Bridge.ensureBaseProperty(this, "IsVisible").$Adaptica$WebForms$WebApp$Controls$ControlBase$IsVisible;
                }
            }
        },
        alias: [
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "IsValid", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "BeforeEndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit",
            "EndFailed", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed"
        ],
        ctors: {
            ctor: function (form, dataItem, currentRecord) {
                if (currentRecord === void 0) { currentRecord = null; }

                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, form, dataItem, currentRecord);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                var $t;
                var value;

                value = ((this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) || (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Set)) ? ($t = this.Value, $t != null ? $t : "-1") : this.Text;

                this.View.SetControlValue(value);

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.CurrentRecord == null) {
                                            this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.DataItem.DSPFID);
                                        }

                                        this.View = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateViewByFieldDefType(this.FormControl, this, this.DataItem, this.Dataset, this.FieldDef, this.CurrentRecord);
                                        $task1 = this.View.GetControl();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        this._control = $taskResult1;
                                        this.MainControl = this.View.MainControl;

                                        $task2 = this.SetControlProperties();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        this.View.Change(Bridge.fn.bind(this, function (s) {
                                            this.Value = s;
                                        }));

                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RaiseDataChanged: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.RaiseDataChanged.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.CurrentRecordChanged(null, null);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return Bridge.referenceEquals(this.DataItem.DSPFID, DSPFID);
            },
            IsValid: function (sb) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    value, 
                    $t, 
                    _discard1, 
                    maxValue, 
                    d, 
                    _discard2, 
                    _discard3, 
                    _discard4, 
                    _discard5, 
                    _discard6, 
                    _discard7, 
                    _discard8, 
                    _discard9, 
                    _discard10, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,12,13,15], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.IsValid.call(this, sb);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;
                                        value = this.Value;

                                        if ((result) && (!System.String.isNullOrEmpty(value))) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 15;
                                        continue;
                                    }
                                    case 2: {
                                        $t = this.FieldDef.Type;
                                        if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Integer) {
                                            $step = 3;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Float) {
                                            $step = 7;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) {
                                            $step = 11;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Date) {
                                            $step = 12;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                                            $step = 13;
                                            continue;
                                        }
                                        $step = 14;
                                        continue;
                                    }
                                    case 3: {
                                        _discard1 = { };
                                        if (!System.Int32.tryParse(value, _discard1)) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("ValidationInvalidNumberField", [this.FieldDef.Label]);
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        sb.appendLine($taskResult2);
                                        result = false;
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        $step = 14;
                                        continue;
                                    }
                                    case 7: {
                                        maxValue = System.Decimal(99999999999.9999, 4);

                                        value = Adaptica.WebForms.WebApp.Extensions.NormalizeFloat(value);
                                        d = { };

                                        if ((!System.Decimal.tryParse(value, null, d)) || (maxValue.neg().gt(d.v) || d.v.gt(maxValue))) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 10;
                                        continue;
                                    }
                                    case 8: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("ValidationInvalidFloatField", [this.FieldDef.Label]);
                                        $step = 9;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 9: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        sb.appendLine($taskResult3);
                                        result = false;
                                        $step = 10;
                                        continue;
                                    }
                                    case 10: {
                                        $step = 14;
                                        continue;
                                    }
                                    case 11: {
                                        _discard2 = { };
                                        _discard3 = { };
                                        _discard4 = { };
                                        _discard5 = { };
                                        if ((!System.DateTime.tryParseExact(value, "yyyy-MM-dd HH:mm:ss.fff", null, _discard2)) && (!System.DateTime.tryParseExact(value, "yyyy-MM-dd HH:mm:ss", null, _discard3)) && (!System.DateTime.tryParseExact(value, "yyyy-MM-dd HH:mm", null, _discard4)) && (!System.DateTime.tryParse(value, null, _discard5))) {
                                            sb.appendLine("Chybn\u00e1 hodnota");
                                            result = false;
                                        }

                                        $step = 14;
                                        continue;
                                    }
                                    case 12: {
                                        _discard6 = { };
                                        if (!System.DateTime.tryParseExact(value, "yyyy-MM-dd", null, _discard6)) {
                                            sb.appendLine("Chybn\u00e1 hodnota");
                                            result = false;
                                        }

                                        $step = 14;
                                        continue;
                                    }
                                    case 13: {
                                        _discard7 = { };
                                        _discard8 = { };
                                        _discard9 = { };
                                        _discard10 = { };
                                        if ((!System.DateTime.tryParseExact(value, "HH:mm:ss.fff", null, _discard7)) && (!System.DateTime.tryParseExact(value, "HH:mm:ss", null, _discard8)) && (!System.DateTime.tryParseExact(value, "HH:mm", null, _discard9)) && (!System.DateTime.tryParse(value, null, _discard10))) {
                                            sb.appendLine("Chybn\u00e1 hodnota");
                                            result = false;
                                        }

                                        $step = 14;
                                        continue;
                                    }

                                    case 15: {
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.BeginEdit();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.BeginEdit.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeforeEndEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.BeforeEndEdit();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileCurrentLocalTime)) {
                                            this.Text = System.DateTime.format(System.DateTime.getNow(), "O", System.Globalization.CultureInfo.invariantCulture);
                                        }

                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.BeforeEndEdit.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.EndEdit();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.EndEdit.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndFailed: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.EndFailed();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.EndFailed.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.FilterSelectionFormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.FormControl],
        fields: {
            _onSaved: null
        },
        ctors: {
            ctor: function (formData, parentForm, onSaved) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.FormControl.ctor.call(this, formData, parentForm);
                this._onSaved = onSaved;
            }
        },
        methods: {
            EndEdit: function (save) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (save === void 0) { save = true; }
                                        $task1 = Adaptica.WebForms.WebApp.Controls.FormControl.prototype.EndEdit.call(this, save);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;

                                        if (result) {
                                            this._onSaved();
                                        }

                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ImageControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _topControl: null,
            _fileInput: null,
            _image: null,
            _required: null
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    return true;
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus"
        ],
        ctors: {
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIImage)) {
                                            result = this.CreateEditableImage();
                                        } else {
                                            result = this.CreateImage();
                                        }

                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        this._topControl = result;
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateEditableImage: function () {
                var $t;
                var div = $("<div>").addClass("text-center wf-qiImage");

                var ctrl = this.CreateImage();
                this._image = this.MainControl;
                var parent = this._image.parent();
                this._image.detach();

                var del = this.CreateImageButton("fas fa-trash");
                var add = this.CreateImageButton("fas fa-plus-square");
                var cam = this.CreateImageButton("fas fa-camera");

                del.on("click", Bridge.fn.bind(this, function () {
                    if (!this.IsEnabled) {
                        return;
                    }

                    var width = this._image.css("width");

                    this._image.css("visibility", "hidden");
                    this._image.attr("src", "");
                    this._image.addClass("empty");
                    this.Value = null;
                }));

                add.on("click", Bridge.fn.bind(this, function (e) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (!this.IsEnabled) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        e.preventDefault();
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        e.preventDefault();

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("SessionState", null, "POST", Bridge.fn.bind(this, function (dto) {
                                            this._fileInput.click();
                                            return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                        }), function (statusCode, statusText, errorText) {
                                            if (statusCode === 401) {
                                                window.setTimeout(Bridge.fn.bind(this, function () {
                                                    var $step = 0,
                                                        $task1, 
                                                        $jumpFromFinally, 
                                                        $asyncBody = Bridge.fn.bind(this, function () {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DoLogout();
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        }, arguments);

                                                    $asyncBody();
                                                }), 100);
                                            }

                                            return System.Threading.Tasks.Task.fromResult(false, System.Boolean);
                                        });
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }));

                var addLabel = $("<label>").attr("for", System.String.format("{0}_file", [this.ControlId])).append(add);

                this._fileInput = ($t = document.createElement("input"), $t.id = System.String.format("{0}_file", [this.ControlId]), $t.type = "file", $t);

                this._fileInput.onchange = Bridge.fn.bind(this, function (evnt) {
                    var file = this._fileInput.files[0];
                    this.CreateImageFromFile(file);
                });

                var jqInput = $(this._fileInput).addClass("wf-dataImage-select");

                var imgOuterDiv = $("<div>").addClass("wf-dataImage-outer").append(this._image);

                var tmpFocus = $("<input>").attr("type", "text").addClass("wf-input-hidden");

                imgOuterDiv.on("click", Bridge.fn.bind(this, function () {
                    if (!this.IsEnabled) {
                        return;
                    }

                    ctrl.find(".wf-dataImage-outer.active").removeClass("active");
                    imgOuterDiv.addClass("active");
                    tmpFocus.focus();
                }));

                tmpFocus.on("blur", function () {
                    imgOuterDiv.removeClass("active");
                });

                div.append(imgOuterDiv).append($("<div>").addClass("wf-dataImage-buttons").append(del).append(addLabel).append(jqInput).append(tmpFocus));

                parent.append(div);


                $("html").on("paste", Bridge.fn.bind(this, function (e) {
                    var $t1;
                    if (!this.FormControl.IsActivated) {
                        return;
                    }

                    var active = this._topControl.find(".wf-dataImage-outer.active");
                    if (active.length === 0) {
                        return;
                    }

                    var d = e;
                    if (e.originalEvent != null) {
                        d = e.originalEvent;
                    }
                    var evnt = d;

                    var cb = evnt.clipboardData;
                    for (var i = 0; i < cb.types.length; i = (i + 1) | 0) {
                        var cbType = ($t1 = cb.types)[System.Array.index(i, $t1)];
                        if ((System.String.indexOf(cbType, "image", 0, null, 5) === -1) && (System.String.indexOf(cb.items[i].type, "image", 0, null, 5) === -1)) {
                            continue;
                        }

                        var file = cb.items[i].getAsFile();
                        this.CreateImageFromFile(file);
                    }
                }));


                this.MainControl = div;

                return ctrl;
            },
            CreateImage: function () {
                var $t, $t1, $t2;
                var id = this.ControlId;
                var label = ($t = this.FieldDef) != null ? $t.Label : null;

                var divElem = $("<div>").addClass("form-group col-auto wf-w-100-minus-scroll mb-auto wf-control wf-image");

                $(($t1 = document.createElement("label"), $t1.htmlFor = id, $t1.innerHTML = label, $t1)).appendTo(divElem);

                this._required = $("<span>").addClass("wf-required").html("*").appendTo(divElem);

                if (!this.IsRequired) {
                    this._required.addClass("wf-hidden");
                }

                var inputGroup = $("<div>").addClass("input-group").appendTo(divElem);

                var val = this.Value;
                this._image = ($t1 = $(($t2 = new Image(), $t2.id = id, $t2.className = "wf-dataImage", $t2)).appendTo(inputGroup), this.MainControl = $t1, $t1);

                if (System.String.isNullOrEmpty(val)) {
                    this.MainControl.addClass("empty");
                    this.MainControl.css("visibility", "hidden");
                } else {
                    this._image.attr("src", "data:image/png;base64," + (val || ""));
                }

                return divElem;
            },
            CreateImageButton: function (className) {
                var btn = $("<i>").addClass(className);

                return $("<span>").append(btn);
            },
            CurrentRecordChanged: function (sender, e) {
                var $t;
                if (this._image != null) {
                    var value = ($t = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue($t, this.FieldDef) : null;
                    if (System.String.isNullOrEmpty(value)) {
                        this._image.css("visibility", "hidden");
                    } else {
                        this._image.attr("src", "data:image/png;base64," + (value || ""));
                        this._image.show();
                        this._image.css("visibility", "visible");
                    }
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetRequired: function (required) {
                if (required) {
                    this._required != null ? this._required.removeClass("wf-hidden") : null;
                } else {
                    this._required != null ? this._required.addClass("wf-hidden") : null;
                }

                return Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetRequired.call(this, required);
            },
            CreateImageFromFile: function (f) {
                var file = Bridge.cast(f, File);

                this.GetFileInBase64(file, Bridge.fn.bind(this, function (data) {
                    var commaIdx = System.String.indexOf(data, String.fromCharCode(44));
                    var imgType = data.substr(0, commaIdx);
                    var imgData = data.substr(((commaIdx + 1) | 0));
                    this.Value = imgData;

                    this._image.attr("src", "data:image/png;base64," + (imgData || ""));
                    this._image.show();
                    this._image.css("visibility", "visible");
                    this._image.removeClass("empty");
                }));
            },
            GetFileInBase64: function (file, okEvent, errEvent) {
                if (okEvent === void 0) { okEvent = null; }
                if (errEvent === void 0) { errEvent = null; }
                var reader = new FileReader();
                reader.onerror = function (evnt) {
                    !Bridge.staticEquals(errEvent, null) ? errEvent(reader, evnt) : null;
                };
                reader.onload = function () {
                    !Bridge.staticEquals(okEvent, null) ? okEvent(Bridge.toString(reader.result)) : null;
                };

                reader.readAsDataURL(file);
            },
            Focus: function () {
                this._topControl.find(".wf-dataImage-outer").click();

                return true;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.InlineFormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.FormControl],
        fields: {
            _gridData: null
        },
        props: {
            MainDSPFID: {
                get: function () {
                    return this._gridData.DSPFID;
                }
            },
            MasterID: {
                get: function () {
                    var $t, $t1, $t2;
                    var currRec = this.CurrencyManager.GetCurrentRecord(($t = this.CurrencyManager.MainDataset) != null ? $t.DSPFID : null);
                    return ($t1 = (currRec != null ? currRec.MasterIDParent : null), $t1 != null ? $t1 : (($t2 = this.CurrencyManager.MainDataset) != null ? $t2.MasterIDParent : null));
                }
            }
        },
        ctors: {
            ctor: function (gridData, formData, parentForm) {
                if (parentForm === void 0) { parentForm = null; }

                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.FormControl.ctor.call(this, formData, parentForm);
                this._gridData = gridData;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.LabelControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _timer: null,
            _interval: 0
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    var result = false;

                    var fd = this.FieldDef;
                    if ((fd != null) && (fd.Type >= 4) && (fd.Type <= 7)) {
                        result = true;
                    }

                    return result;
                }
            },
            DisplayValue: {
                get: function () {
                    var $t;
                    return ($t = this.MainControl) != null ? $t.html() : null;
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._timer = System.DateTime.getDefaultValue();
                this._timer = System.DateTime.getMinValue();
            },
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    value, 
                    displayValue, 
                    ctrl, 
                    result, 
                    labelElem, 
                    inputGroup, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        value = this.Value;
                                        displayValue = this.Text;

                                        ctrl = $("<div>").addClass("wf-label").html(displayValue);

                                        result = ctrl;
                                        if (!this.CreateControlOnly) {
                                            labelElem = $(document.createElement("label"));

                                            inputGroup = $("<div>").addClass("input-group").append(ctrl);

                                            result = $(document.createElement("div")).addClass("form-group col-auto wf-control wf-label").append(labelElem).append(inputGroup);
                                        }

                                        this.MainControl = ctrl;

                                        this.SetFontProperties(ctrl, value);

                                        if (System.String.isNullOrEmpty(displayValue)) {
                                            this.MainControl.css("visibility", "hidden");
                                        }

                                        this.SetInterval();

                                        $task1 = this.SetControlProperties();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetInterval: function () {
                var v = this.Value;

                if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QITimer)) {
                    this.ClearInterval();

                    if (!System.String.isNullOrEmpty(v)) {
                        if (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) {
                            this._timer = System.DateTime.parseExact(v, "yyyy-MM-dd HH:mm:ss.fff", null);
                        } else if (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                            this._timer = System.DateTime.parseExact(v, "HH:mm:ss.fff", null);
                        }

                        this.Refresh();

                        this._interval = window.setInterval(Bridge.fn.cacheBind(this, this.Refresh), 1000);
                    } else {
                        this.MainControl.html(System.TimeSpan.zero.toString("hh\\:mm\\:ss"));
                    }
                }
            },
            ClearInterval: function () {
                if (this._interval !== 0) {
                    window.clearInterval(this._interval);
                    this._interval = 0;
                }
            },
            Refresh: function () {
                var $t;
                var s = (System.DateTime.subdd(System.DateTime.getNow(), this._timer));
                var v = (s.getTotalDays() > 1) ? s.toString("d\\.hh\\:mm\\:ss") : s.toString("HH\\:mm\\:ss");
                ($t = this.MainControl) != null ? $t.html(v) : null;
            },
            RaiseDataChanged: function () {
                this.CurrentRecordChangedInternal(null, null);
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            CurrentRecordChanged: function (sender, e) {
                var $t, $t1;
                this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.DataItem.DSPFID);
                var value = ($t = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue($t, this.FieldDef) : null;
                var displayValue = ($t1 = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue($t1, this.FieldDef) : null;

                if (System.String.isNullOrEmpty(displayValue)) {
                    this.ClearInterval();

                    this.MainControl.css("visibility", "hidden");

                    return System.Threading.Tasks.Task.fromResult(null, System.Object);
                }

                var color = this.GetTextColor(value);
                if (!System.String.isNullOrEmpty(color)) {
                    this.MainControl.css("color", color);
                }

                if (Bridge.referenceEquals(this.DataItem.Action, "QIMobile.Timer")) {
                    this.SetInterval();
                } else {
                    this.MainControl.html(displayValue);
                }

                this.MainControl.css("visibility", "visible");

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            Focus: function () {
                return false;
            },
            Dispose: function () {
                this.ClearInterval();

                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.Dispose.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.MemoControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _control: null,
            _required: null,
            _infoIcon: null,
            _linkRegex: null,
            QrCode: null,
            CreateCopyIcon: false
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    return true;
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit"
        ],
        ctors: {
            init: function () {
                this.CreateCopyIcon = false;
            },
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    isQrCode, 
                    isHtml, 
                    $class, 
                    id, 
                    label, 
                    $t, 
                    $t1, 
                    inputGroup, 
                    childNodes, 
                    $t2, 
                    node, 
                    jq, 
                    textArea, 
                    $t3, 
                    inputElem, 
                    copyIcon, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        isQrCode = Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileQRCodeImage);
                                        isHtml = Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileHTMLText);

                                        $class = (isQrCode) ? "wf-qrCode" : "wf-memo";

                                        id = this.GetId();
                                        label = ($t = this.FieldDef) != null ? $t.Label : null;

                                        this._control = $(document.createElement("div")).addClass("form-group mb-auto wf-w-100-minus-scroll wf-control").addClass($class);

                                        if (!isHtml) {
                                            $(($t1 = document.createElement("label"), $t1.htmlFor = id, $t1.innerHTML = label, $t1)).appendTo(this._control);

                                            if (!System.String.isNullOrEmpty(($t1 = this.FieldDef) != null ? $t1.Description : null)) {
                                                this._infoIcon = $("<span>").addClass("wf-tooltip-icon fas fa-info-circle").attr("title", System.String.replaceAll(this.FieldDef.Description, "\n", "<br>")).attr("data-toggle", "tooltip").attr("data-boundary", "window").appendTo(this._control);

                                                this._infoIcon.tooltip({ trigger: "hover", placement: "auto", html: true, title: System.String.replaceAll(this.FieldDef.Description, "\n", "<br>") });
                                            }

                                            this._required = $("<span>").addClass("wf-required").html("*").appendTo(this._control);

                                            if (!this.IsRequired) {
                                                this._required.addClass("wf-hidden");
                                            }
                                        }

                                        inputGroup = $("<div>").addClass("input-group").appendTo(this._control);

                                        if (isQrCode) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        this.MainControl = $("<img>").attr("id", id).attr("src", this.GetQrCodeUrl()).addClass("form-control").addClass($class).appendTo(inputGroup);
                                        $step = 7;
                                        continue;
                                    }
                                    case 2: {
                                        if (isHtml) {
                                            $step = 3;
                                            continue;
                                        } else  {
                                            $step = 5;
                                            continue;
                                        }
                                    }
                                    case 3: {
                                        this.CreateControlOnly = true;

                                        this.MainControl = $("<div>").addClass("wf-html").appendTo(inputGroup);

                                        $task1 = this.GetHtml();
                                        $step = 4;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        childNodes = ($t2 = Node, System.Linq.Enumerable.from(($taskResult1).body.childNodes, $t2).ToArray($t2));
                                        for (var i = 0; i < childNodes.length; i = (i + 1) | 0) {
                                            node = childNodes[System.Array.index(i, childNodes)];
                                            jq = $(node);
                                            this.MainControl.first().append(jq);
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        textArea = ($t3 = document.createElement("textarea"), $t3.id = id, $t3.className = "form-control " + ($class || ""), $t3.value = this.Value, $t3.required = this.IsRequired, $t3.disabled = this.IsReadOnly || !this.IsEnabled, $t3);

                                        inputElem = $(textArea).appendTo(inputGroup);

                                        inputElem.change(Bridge.fn.bind(this, function () {
                                            this.Value = inputElem.val();
                                        }));

                                        if (this.CreateCopyIcon) {
                                            copyIcon = $("<span>").appendTo(inputGroup);

                                            $("<i>").addClass("far fa-copy wf-memo-copy-icon").appendTo(copyIcon);

                                            copyIcon.on("click", function () {
                                                var isDisabled = textArea.disabled;
                                                textArea.disabled = false;
                                                textArea.select();
                                                textArea.setSelectionRange(0, 99999);
                                                document.execCommand("copy");
                                                textArea.setSelectionRange(0, 0);
                                                textArea.disabled = isDisabled;
                                            });
                                        }

                                        this.MainControl = inputElem;
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        $task2 = this.SetControlProperties();
                                        $step = 8;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetQrCodeUrl: function () {
                return System.String.format("{0}GetQrCode?wfsid={1}&qrText={2}", Adaptica.WebForms.WebApp.Config.DataUrl, encodeURIComponent(Adaptica.WebForms.WebApp.WebFormsApp.SSID), encodeURIComponent(this.Value));
            },
            GetHtml: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        result = null;

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetDataByToken", { Token: this.Value, IsHtml: true }, "GET", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    if ($taskResult1) {
                                                                        $step = 2;
                                                                        continue;
                                                                    } 
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    result = this.ProcessHtml(dataDTO.Data);
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 3: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ProcessHtml: function (html) {
                var $t;
                var appUrl = Adaptica.WebForms.WebApp.WebFormsApp.AppRoot;

                var isForm;
                var parser = new DOMParser();
                var doc = parser.parseFromString(html, "text/html");
                $t = Bridge.getEnumerator(doc.querySelectorAll("a"), "getEnumerator");
                try {
                    while ($t.moveNext()) {
                        var link = Bridge.cast($t.Current, HTMLAnchorElement);
                        isForm = false;
                        var href = link.href;
                        if (System.String.isNullOrEmpty(href)) {
                            continue;
                        }

                        {
                            if (this._linkRegex == null) {
                                this._linkRegex = new System.Text.RegularExpressions.Regex.ctor("formId=([^&]+).*?masterId=([^&]+)");
                            }

                            var match = this._linkRegex.match(href);
                            if (match.getSuccess()) {
                                isForm = true;
                                var formId = match.getGroups().get(1).getValue();
                                var masterId = match.getGroups().get(2).getValue();
                                if (System.String.isNullOrEmpty(masterId)) {
                                    masterId = "null";
                                } else {
                                    masterId = System.String.format("'{0}'", [masterId]);
                                }

                                link.href = System.String.format("javascript:Adaptica.WebForms.WebApp.WebFormsApp.GetForm('{0}', {1}, Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm)", formId, masterId);
                            }
                        }

                        if (!isForm) {
                            if (System.String.startsWith(href, (appUrl || "") + "#", 4)) {
                                this.AddClinkHandlerToAnchorLink(link);
                            } else {
                                link.target = "_blank";
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return doc;
            },
            AddClinkHandlerToAnchorLink: function (link) {
                link.addEventListener("click", function (ev) {
                    ev.preventDefault();

                    var href = link.hash;
                    if (System.String.isNullOrEmpty(href)) {
                        return;
                    }

                    var idOrName = decodeURIComponent(href.substr(1));

                    var target = document.getElementById(idOrName) || document.querySelector(System.String.format("[name='{0}']", [idOrName]));
                    var headers = document.querySelectorAll(".sticky-top");

                    var header = headers[((headers.length - 1) | 0)];
                    if (target != null && header != null) {
                        var rect = target.getBoundingClientRect();
                        var y = rect.top + window.pageYOffset - Bridge.cast(header, HTMLElement).offsetHeight;


                        window.scrollTo(0, Bridge.Int.clip32(y));
                    }
                });
            },
            CurrentRecordChanged: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    jq, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileQRCodeImage)) {
                                            $(System.String.format("#{0}", [this.GetId()])).attr("src", this.GetQrCodeUrl());
                                        }

                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileHTMLText)) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.GetHtml();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        jq = $(($taskResult1).body.childNodes);
                                        this.MainControl.add(jq);
                                        $step = 4;
                                        continue;
                                    }
                                    case 3: {
                                        this.MainControl.val(this.Text);
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    id, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        id = this.GetId();
                                        $(System.String.format("#{0}", [id])).addClass("editing");

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.BeginEdit.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    id, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        id = this.GetId();
                                        $(System.String.format("#{0}", [id])).removeClass("editing");

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.EndEdit.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                if (visible) {
                    this._control.removeClass("wf-hidden");
                } else {
                    this._control.addClass("wf-hidden");
                }

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            SetRequired: function (required) {
                if (this._required != null) {

                    if (required) {
                        this._required.removeClass("wf-hidden");
                    } else {
                        this._required.addClass("wf-hidden");
                    }
                }

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            GetId: function () {
                return "ctrl_" + (Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FieldDef.Name) || "");
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.SelectionFormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.FormControl],
        fields: {
            SourceForm: null,
            DSPFID: null,
            FieldName: null,
            OriginalRecord: null
        },
        ctors: {
            ctor: function (formData, sourceForm, dspfid, fieldName, originalRecord) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.FormControl.ctor.call(this, formData, sourceForm);
                this.SourceForm = sourceForm;
                this.DSPFID = dspfid;
                this.FieldName = fieldName;
                this.OriginalRecord = originalRecord;
            }
        },
        methods: {
            ExecuteGridDefaultAction: function (dspfid, record) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ExecuteSelectFunctionAsync(this, dspfid, record);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(true);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.DataTablesGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        fields: {
            _table: null,
            _notFound: null,
            _notFoundMsg: null,
            _dataTable: null,
            _isCreating: false,
            _isRecalculating: false,
            _cols: null,
            _eventsAttached: false
        },
        props: {
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            IsVisible: {
                get: function () {
                    return true;
                }
            },
            IsResponsive: {
                get: function () {
                    return false;
                }
            },
            FloatThead: {
                get: function () {
                    return true;
                }
            },
            Scroller: {
                get: function () {
                    return false;
                }
            },
            ColReorder: {
                get: function () {
                    return false;
                }
            },
            ControlId: {
                get: function () {
                    return System.String.format("ctrl_{0}", [this.FormControl.CreateUniqueControlId()]);
                }
            }
        },
        alias: [
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._eventsAttached = false;
            },
            ctor: function (form, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, form, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                if ((Bridge.referenceEquals(this.DataItem.DSPFID, (e != null ? e.DSPFID : null))) && (this._control != null)) {
                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.DataItem.DSPFID);
                    this.SetRecordSelectedClass(rec, true);

                    this._currentRecord = rec;
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetRecordSelectedClass: function (rec, readScrollTop) {
                var $t, $t1;
                if (readScrollTop === void 0) { readScrollTop = false; }
                var id;

                if ((this._currentRecord != null) && (!Bridge.referenceEquals(this._currentRecord, rec))) {
                    id = ($t = this._currentRecord.RecID, $t != null ? $t : Bridge.toString(this._currentRecord.RecNo));
                    $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(id)])).removeClass("wf-grid-row-selected");
                }

                if (rec == null) {
                    return;
                }

                id = ($t1 = rec.RecID, $t1 != null ? $t1 : Bridge.toString(rec.RecNo));

                var row = $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(id)]));
                row.addClass("wf-grid-row-selected");

                if (readScrollTop) {
                    this._tableScrollTop = row.closest(".dataTables_scrollBody").scrollTop();
                }
            },
            GetGridColumns: function () {
                if (this._cols == null) {
                    var grid = this.DataItem;
                    this.CreateColumns(grid, this.Dataset.Header.FieldDefs);
                }

                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $taskResult9, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tbody, 
                    rows, 
                    selRecord, 
                    selRow, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    id, 
                    $t, 
                    row, 
                    i, 
                    col, 
                    color, 
                    fieldDef, 
                    fieldValue, 
                    $t1, 
                    cell, 
                    text, 
                    value, 
                    $taskResult2, 
                    valueElem, 
                    imgElem, 
                    $t2, 
                    img, 
                    rowValueCol, 
                    edt, 
                    edit, 
                    txt, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17,18,19,20,22,23,24,25,26,27,29,30,32,33,34,35,36,37,38,39,40], $step);
                                switch ($step) {
                                    case 0: {
                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 34;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (this._notFound != null) {
                                            this._notFound.remove();
                                            this._notFound = null;

                                            this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._control.find(".wf-grid-datatables")) : null;
                                        }

                                        if (this._table == null) {
                                            this.CreateGridHeader(containerItem, fieldDefs);
                                        }

                                        tbody = $("<tbody>").appendTo(this._table);

                                        this._table != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._table) : null;

                                        rows = null;
                                        if (this._dataTable != null) {
                                            rows = System.Array.init(recs.length, null, System.Object);
                                        }

                                        selRecord = null;
                                        selRow = null;

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 33;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(localRecNo.v, recs)];

                                        id = ($t = rec.RecID, $t != null ? $t : Bridge.toString(rec.RecNo));

                                        row = $("<tr>").addClass(System.String.format("wf-grid-row id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(id)]));

                                        if (this._currentRecord != null && (((this._currentRecord.RecID == null) && (this._currentRecord.RecNo === rec.RecNo)) || (Bridge.referenceEquals((this._currentRecord != null ? this._currentRecord.RecID : null), rec.RecID)))) {
                                            selRecord = rec;
                                            selRow = row;
                                        }

                                        if (this._dataTable != null) {
                                            rows[System.Array.index(recNo, rows)] = row.get(0);
                                        } else {
                                            row.appendTo(tbody);
                                        }

                                        row.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if (!System.String.isNullOrEmpty(Bridge.toString(window.getSelection()))) {
                                                                            $tcs.setResult(null);
                                                                            return;
                                                                        }


                                                                        if (!this.IsEditing) {
                                                                            e.stopImmediatePropagation();
                                                                            e.preventDefault();
                                                                        }

                                                                        $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                        })(this, localRecNo));

                                        i = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 31;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i, this._cols)] };
                                        color = col.v.FontColor;
                                        fieldDef = { v : System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null) };

                                        fieldValue = rec != null && ($t1 = rec.FieldValues) != null ? System.Linq.Enumerable.from($t1, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault((function ($me, fieldDef) {
                                            return function (fd) {
                                                return System.String.equals(fd.Name, fieldDef.v != null ? fieldDef.v.Name : null);
                                            };
                                        })(this, fieldDef), null) : null;
                                        if (fieldValue != null && System.Nullable.hasValue(fieldValue.ViewType)) {
                                            fieldDef.v.Type = System.Nullable.getValue(fieldValue.ViewType);
                                            fieldDef.v.Values = fieldValue.ViewValues;
                                            fieldDef.v.DisplayValues = fieldValue.ViewDisplayValues;
                                            fieldDef.v.Mask = fieldValue.ViewMask;
                                        }

                                        cell = $("<td>").appendTo(row);

                                        cell.addClass("fld-" + (System.String.replaceAll(col.v.FieldName, String.fromCharCode(44), String.fromCharCode(95)) || ""));

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef.v);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef.v);

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        color = "#7b7b7b";
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 22;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 15: {
                                        if (System.String.equals(text, "1")) {
                                            $step = 16;
                                            continue;
                                        }  else {
                                            $step = 18;
                                            continue;
                                        }
                                    }
                                    case 16: {
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 17;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        $taskResult2 = $taskResult5;
                                        $step = 20;
                                        continue;
                                    }
                                    case 18: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 19;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 19: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult2 = $taskResult6;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        text = $taskResult2;
                                        $step = 21;
                                        continue;
                                    }

                                    case 22: {
                                        valueElem = null;

                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            $step = 23;
                                            continue;
                                        } else  {
                                            $step = 24;
                                            continue;
                                        }
                                    }
                                    case 23: {
                                        valueElem = $("<div>").addClass("wf-grid-value wf-grid-image").appendTo(cell);

                                        imgElem = ($t2 = new Image(), $t2.className = "wf-dataImage", $t2);

                                        img = $(imgElem).appendTo(valueElem);

                                        if (!System.String.isNullOrEmpty(text)) {
                                            this.HandleImageOnLoad(img);

                                            img.attr("src", "data:image/png;base64," + (text || ""));
                                        } else {
                                            img.css("visibility", "hidden");
                                        }
                                        $step = 29;
                                        continue;
                                    }
                                    case 24: {
                                        rowValueCol = $("<div>").appendTo(cell);

                                        valueElem = $("<div>").addClass("wf-grid-value").appendTo(rowValueCol);

                                        if ((this.AllowEdit(dset.DSPFID)) && (!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef.v))) {
                                            $step = 25;
                                            continue;
                                        } else  {
                                            $step = 27;
                                            continue;
                                        }
                                    }
                                    case 25: {
                                        edt = ($t2 = new Adaptica.WebForms.Common.DataModel.Edit(), $t2.DSPFID = dset.DSPFID, $t2.Caption = fieldDef.v.Label, $t2.FieldName = fieldDef.v.Name, $t2.FontColor = col.v.FontColor, $t2.FontStyle = col.v.FontStyle, $t2.Type = col.v.Type, $t2.Action = col.v.Action, $t2);

                                        edit = ($t2 = new Adaptica.WebForms.WebApp.Controls.EditControl(this.FormControl, edt, rec), $t2.CreateControlOnly = true, $t2.IsGridEdit = true, $t2);
                                        this.SubControls.add(edit);

                                        $task7 = edit.RenderControl();
                                        $step = 26;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        ($taskResult7).appendTo(valueElem);
                                        $step = 28;
                                        continue;
                                    }
                                    case 27: {
                                        if ((Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile))) {
                                            cell.addClass("wf-grid-cell-download");
                                        }

                                        this.SetColumnValue(col.v, valueElem, fieldDef.v, value, text, color);
                                        $step = 28;
                                        continue;
                                    }

                                    case 29: {
                                        if (i === 0) {
                                            valueElem != null ? valueElem.addClass("wf-grid-first") : null;
                                        }
                                        $step = 30;
                                        continue;
                                    }
                                    case 30: {
                                        i = (i + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 32: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 33: {
                                        if (this._dataTable == null) {
                                            this.CreateDataTable();
                                        } else {
                                            this._dataTable.rows.add(Bridge.unbox(rows)).draw();
                                            if (this.FloatThead) {
                                                this._table.floatThead("reflow");
                                            }
                                        }

                                        if (selRecord != null) {
                                            this.SetRecordSelectedClass(selRecord);
                                            window.setTimeout(Bridge.fn.bind(this, function () {
                                                if (!this.IsElementInViewport(Bridge.as(selRow.get(0), HTMLElement))) {
                                                    selRow.closest(".dataTables_scrollBody").scrollTop(this._tableScrollTop);
                                                }
                                            }), 50);
                                        }
                                        $step = 40;
                                        continue;
                                    }
                                    case 34: {
                                        if (((this._filterOnServer) && (System.String.isNullOrEmpty(this._searchText)))) {
                                            $step = 35;
                                            continue;
                                        }  else {
                                            $step = 37;
                                            continue;
                                        }
                                    }
                                    case 35: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 36;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 36: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult1 = ($taskResult8 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 39;
                                        continue;
                                    }
                                    case 37: {
                                        $task9 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 38;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 38: {
                                        $taskResult9 = $task9.getAwaitedResult();
                                        $taskResult1 = $taskResult9;
                                        $step = 39;
                                        continue;
                                    }
                                    case 39: {
                                        txt = $taskResult1;

                                        if (this._notFound == null) {
                                            this._notFound = $("<div>").addClass("form-row wf-msg").appendTo(this._gridContentElem);

                                            this._notFoundMsg = $("<div>").addClass("col-auto").html(txt).appendTo(this._notFound);
                                        } else {
                                            this._notFoundMsg.html(txt);
                                        }

                                        this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._control.find(".wf-grid-datatables")) : null;
                                        $step = 40;
                                        continue;
                                    }
                                    case 40: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsElementInViewport: function (e) {
                var el = null;

                if (Bridge.is(e, $)) {
                    el = Bridge.as((Bridge.as(e, $)).get(0), HTMLElement);
                } else if (Bridge.is(e, HTMLElement)) {
                    el = Bridge.as(e, HTMLElement);
                }

                if (el == null) {
                    throw new System.Exception("Invalid type");
                }

                var rect = el.getBoundingClientRect();

                var h = window.innerHeight;
                if (h === 0) {
                    h = window.document.documentElement.clientHeight;
                }
                var w = window.innerHeight;
                if (w === 0) {
                    w = window.document.documentElement.clientWidth;
                }

                return (rect.top >= 0 && rect.left >= 0 && rect.bottom <= h && rect.right <= w);
            },
            CreateColumns: function (grid, fieldDefs) {
                var tmpCols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                        return col.Order;
                    }).toList(Adaptica.WebForms.Common.DataModel.GridColumn);

                var colIdx = 0;
                var i = (tmpCols.Count - 1) | 0;
                while (i > colIdx) {
                    var col = { v : tmpCols.getItem(i) };
                    var fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                            return function (fld) {
                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                            };
                        })(this, col), null);
                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                        tmpCols.removeAt(i);
                        tmpCols.insert(colIdx, col.v);
                        colIdx = (colIdx + 1) | 0;
                    } else {
                        i = (i - 1) | 0;
                    }
                }

                this._cols = tmpCols.ToArray();
            },
            CreateGridHeader: function (containerItem, fieldDefs) {
                var $t;
                var grid = containerItem;

                this.CreateColumns(grid, fieldDefs);

                this._table = $("<table>").attr("id", this.ControlId).addClass("wf-grid-datatables table table-striped table-bordered nowrap");

                if (this.IsResponsive) {
                    this._table.addClass("dt-responsive");
                }

                var tHead = $("<thead>").appendTo(this._table);

                if (Bridge.equals(("no"), window.self.gridHeader)) {
                    tHead.addClass("wf-hidden");
                }

                var tHeadRow = $("<tr>").appendTo(tHead);

                $t = Bridge.getEnumerator(this._cols);
                try {
                    while ($t.moveNext()) {
                        var col = { v : $t.Current };
                        var fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                return function (fld) {
                                    return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                };
                            })(this, col), null);
                        var isDownload = (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile));
                        var lbl = fieldDef.Label;

                        var cell = $("<th>").addClass("wf-grid-header").html(lbl).appendTo(tHeadRow);

                        cell.addClass("fld-" + (System.String.replaceAll(col.v.FieldName, String.fromCharCode(44), String.fromCharCode(95)) || ""));

                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                            cell.addClass("wf-grid-cell-img");
                        }

                        if (isDownload) {
                            cell.addClass("wf-grid-cell-download");
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                this._gridContentElem.append(this._table);
            },
            ClearTable: function () {
                if (this._table == null) {
                    return;
                }

                this._dataTable.rows().remove().draw();
            },
            OnFormActivated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormActivated.call(this);
                if (this.IsResponsive) {
                    this._dataTable != null ? this._dataTable.responsive.recalc() : null;
                }

                this.OnShownOrActivated();
            },
            OnFormDeactivated: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormDeactivated.call(this);
            },
            OnShow: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnShow.call(this);

                this.OnShownOrActivated();
            },
            OnHide: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnHide.call(this);

                this.OnHiddenOrDeactivated();
            },
            OnShownOrActivated: function () {
                if ((this.IsShown) && (!this._eventsAttached)) {
                    this._eventsAttached = true;

                    window.addEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));

                    if (this._searchBar != null) {
                        window.setTimeout(Bridge.fn.bind(this, function () {
                            this._searchInput.focus();
                        }), 10);
                    }
                }

                this.RecalculateSize();
            },
            OnHiddenOrDeactivated: function () {
                window.removeEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));
                this._eventsAttached = false;
            },
            RecalculateSize: function () {
                if ((this._notFound != null) || (this._isRecalculating)) {
                    return;
                }

                window.setTimeout(Bridge.fn.bind(this, function () {
                    var $t;
                    if (this._isRecalculating) {
                        return;
                    }

                    this._isRecalculating = true;

                    var sTopElem = this.FormControl.Content.find(".sticky-top");
                    var prnt = this._gridContentElem.parent();

                    var h = this._gridContentElem.height();
                    var sTop = sTopElem.height();
                    var sTopOffsetTop = sTopElem.offset().top;
                    var scrollH = (prnt.prop("offsetHeight") - this._gridContentElem.prop("offsetHeight")) | 0;

                    var calc = (((((window.innerHeight - sTop) | 0) - sTopOffsetTop) | 0) - (((scrollH + 10) | 0))) | 0;
                    this._gridContentElem.css("height", calc);

                    var sh = prnt.prop("scrollHeight");
                    var oh = prnt.prop("offsetHeight");
                    var ch = prnt.prop("clientHeight");


                    if (this.Scroller) {
                        if (this._dataTable != null) {
                            window.setTimeout(Bridge.fn.bind(this, function () {
                                this._dataTable.scroller.measure(true);
                            }), 10);
                        }
                    }

                    if (this.FloatThead) {
                        ($t = this._table) != null ? $t.floatThead("reflow") : null;
                    }

                    this._isRecalculating = false;
                }), 10);
            },
            OnScroll: function () {
                if (this.FloatThead) {
                    this._table.floatThead("reflow");
                }
            },
            OnFormCreated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormCreated.call(this);

                if (this._notFound == null) {
                    this.CreateDataTable();
                }
            },
            CreateDataTable: function () {
                if ((this._dataTable == null) && (!this._isCreating)) {
                    this._isCreating = true;
                    window.setTimeout(Bridge.fn.bind(this, function () {
                        var s = { pageLength: -1, info: false, paging: false, ordering: false, searching: false, stateSave: true, stateDuration: -1, autoWidth: false, dom: "Rt" };


                        if (this.ColReorder) {
                            var opts = { };
                            opts.allowReorder = true;
                            opts.allowResize = false;
                            opts.floatThead = true;
                            s.colReorder = opts;
                        }

                        s.colResize = { isEnabled: true, hasBoundCheck: false };

                        if (this.Scroller) {
                            s.scroller = true;
                            s.scrollY = "200px";
                            s.scrollCollapse = true;
                            s.scrollResize = true;
                            s.deferRender = true;
                        }

                        if (this.IsResponsive) {
                            var resp = { };
                            resp.details = false;
                            s.responsive = resp;
                        }

                        /* 
                                           FixedHeaderOpts fh = (FixedHeaderOpts)new object();
                                           fh.header = true;
                                           fh.headerOffset = FormControl.Content.Find(".sticky-top").Height() - 7;

                                           s.fixedHeader = fh;
                        */
                        var tbl = jQuery(this._table);
                        tbl.dataTable.defaults.pageLength = -1;
                        this._dataTable = tbl.DataTable(s);

                        this._dataTable.on("column-reorder.dt", Bridge.fn.bind(this, function (event, settings) {
                            var reorderArgs = arguments[2];
                            if (this.Scroller) {
                                this._dataTable.scroller.measure(true);
                            }
                        }));

                        /* 
                                           if (ColReorder)
                                           {
                                               _dataTable.colReorder().ColReorder();
                                           }
                        */

                        if (this.FloatThead) {
                            var opts1 = { };
                            opts1.top = (this.FormControl.Content.find(".sticky-top").height() - 7) | 0;
                            opts1.position = "absolute";
                            opts1.scrollContainer = true;
                            opts1.autoReflow = true;

                            var support = { };
                            support.bootstrap = true;
                            support.datatables = true;

                            opts1.support = support;

                            tbl.floatThead(opts1);
                        }

                        this.RecalculateSize();

                        this._isCreating = false;
                    }), 100);

                }
            },
            Dispose: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.Dispose.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.KanbanGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        statics: {
            fields: {
                undefinedColor: null
            },
            ctors: {
                init: function () {
                    this.undefinedColor = "#7b7b7b";
                }
            }
        },
        fields: {
            _cols: null,
            _notFound: null,
            _notFoundMsg: null
        },
        ctors: {
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            GetGridColumns: function () {
                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    grid, 
                    kanbanControl, 
                    kanbanCol, 
                    colorCodes, 
                    $t, 
                    kanbanField, 
                    kanbanValues, 
                    kanbanDispValues, 
                    kanbanPanels, 
                    kv, 
                    panel, 
                    color, 
                    heading, 
                    nextColor, 
                    setColor, 
                    prevColor, 
                    maxH, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    kValue, 
                    panel1, 
                    bgColor, 
                    item, 
                    i1, 
                    col, 
                    color1, 
                    fieldDef, 
                    text, 
                    value, 
                    $taskResult2, 
                    valueElem, 
                    img, 
                    $t1, 
                    h, 
                    txt, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17,18,19,20,22,23,25,26,27,28,29,30,31,32,33], $step);
                                switch ($step) {
                                    case 0: {
                                        grid = containerItem;
                                        this._cols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                                            return col.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.GridColumn);

                                        kanbanControl = $("<div>").addClass("wf-kanban").appendTo(this._gridContentElem);

                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 27;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (this._notFound != null) {
                                            this._notFound.remove();
                                            this._notFound = null;

                                            this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._control.find(".wf-kanban")) : null;
                                        }

                                        kanbanCol = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).first(function (col) {
                                            return Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIKanban);
                                        });
                                        colorCodes = ($t = kanbanCol.FontColor) != null ? System.String.split($t, [44].map(function (i) {{ return String.fromCharCode(i); }})) : null;

                                        kanbanField = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault(function (fld) {
                                            return Bridge.referenceEquals(fld.Name, kanbanCol.FieldName);
                                        }, null);
                                        kanbanValues = Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumValues(kanbanField);
                                        kanbanDispValues = Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumDisplayValues(kanbanField);

                                        kanbanPanels = new (System.Collections.Generic.Dictionary$2(System.Int32,$)).ctor();
                                        for (var i = 0; i < kanbanValues.length; i = (i + 1) | 0) {
                                            kv = kanbanValues[System.Array.index(i, kanbanValues)];
                                            panel = $("<div>").addClass("wf-kanban-panel").appendTo(kanbanControl);

                                            kanbanPanels.add(kv, panel);

                                            color = colorCodes != null ? colorCodes[System.Array.index(i, colorCodes)] : null;
                                            if (System.String.isNullOrEmpty(color)) {
                                                color = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                            }

                                            heading = $("<div>").addClass("wf-kanban-heading").attr("style", System.String.format("background-color: {0};", [color])).text(kanbanDispValues[System.Array.index(i, kanbanDispValues)]).appendTo(panel);

                                            if (i < ((kanbanValues.length - 1) | 0)) {
                                                nextColor = colorCodes != null ? colorCodes[System.Array.index(((i + 1) | 0), colorCodes)] : null;
                                                if (System.String.isNullOrEmpty(nextColor)) {
                                                    nextColor = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                                }

                                                $("<div>").addClass("triangle").attr("style", System.String.format("border-top-color: {0};border-bottom-color: {1};", nextColor, nextColor)).appendTo(kanbanControl);
                                            }

                                            setColor = true;
                                            if (i === 0) {
                                                panel.addClass("wf-kanban-panel-first");
                                                setColor = false;
                                            } else if (i === ((kanbanValues.length - 1) | 0)) {
                                                panel.addClass("wf-kanban-panel-last");
                                            }

                                            if (setColor) {
                                                prevColor = colorCodes != null ? colorCodes[System.Array.index(((i - 1) | 0), colorCodes)] : null;
                                                if (System.String.isNullOrEmpty(prevColor)) {
                                                    prevColor = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                                }
                                                panel.attr("style", System.String.format("--wf-color: {0};", [prevColor]));
                                            }
                                        }

                                        maxH = 0;
                                        this._cols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                                            return col.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.GridColumn);

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 26;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(recNo, recs)];

                                        kValue = System.Int32.parse(Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(rec, kanbanCol.FieldName));
                                        panel1 = kanbanPanels.getItem(kValue);

                                        bgColor = colorCodes != null ? colorCodes[System.Array.index(Adaptica.WebForms.WebApp.Extensions.IndexOf(System.Int32, kanbanValues, kValue), colorCodes)] : null;
                                        if (System.String.isNullOrEmpty(bgColor)) {
                                            bgColor = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                        }

                                        item = $("<div>").addClass("wf-kanban-item").attr("style", System.String.format("background-color: {0}10;", [bgColor])).appendTo(panel1);

                                        item.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    e.preventDefault();

                                                                    $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });
                                        })(this, localRecNo));

                                        i1 = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i1 < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 24;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i1, this._cols)] };
                                        if ((Bridge.referenceEquals(col.v.FieldName, kanbanCol.FieldName)) || (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile))) {
                                            $step = 23;
                                            continue;
                                        }

                                        color1 = col.v.FontColor;
                                        fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null);

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef);
                                        if (System.String.isNullOrEmpty(text)) {
                                            text = "&nbsp;";
                                        }

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        color1 = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 22;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 15: {
                                        if (System.String.equals(text, "1")) {
                                            $step = 16;
                                            continue;
                                        }  else {
                                            $step = 18;
                                            continue;
                                        }
                                    }
                                    case 16: {
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 17;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        $taskResult2 = $taskResult5;
                                        $step = 20;
                                        continue;
                                    }
                                    case 18: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 19;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 19: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult2 = $taskResult6;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        text = $taskResult2;
                                        $step = 21;
                                        continue;
                                    }

                                    case 22: {
                                        valueElem = $("<div>").addClass("wf-kanban-item-value").appendTo(item);

                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            img = $(($t1 = new Image(), $t1.className = "wf-dataImage", $t1)).appendTo(valueElem);

                                            if (!System.String.isNullOrEmpty(text)) {
                                                img.attr("src", "data:image/png;base64," + (text || ""));

                                                h = img.height();
                                                if (h > maxH) {
                                                    maxH = h;
                                                }
                                            } else {
                                                img.css("visibility", "hidden");
                                            }
                                        } else {
                                            this.SetColumnValue(col.v, valueElem, fieldDef, value, text, color1);
                                        }
                                        $step = 23;
                                        continue;
                                    }
                                    case 23: {
                                        i1 = (i1 + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 25: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 26: {
                                        $step = 33;
                                        continue;
                                    }
                                    case 27: {
                                        if (((this._filterOnServer) && (System.String.isNullOrEmpty(this._searchText)))) {
                                            $step = 28;
                                            continue;
                                        }  else {
                                            $step = 30;
                                            continue;
                                        }
                                    }
                                    case 28: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 29;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 29: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $taskResult1 = ($taskResult7 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 32;
                                        continue;
                                    }
                                    case 30: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 31;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 31: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult1 = $taskResult8;
                                        $step = 32;
                                        continue;
                                    }
                                    case 32: {
                                        txt = $taskResult1;

                                        if (this._notFound == null) {

                                            this._notFound = $("<div>").addClass("form-row wf-msg").appendTo(this._gridContentElem);

                                            this._notFoundMsg = $("<div>").addClass("col-auto").html(txt).appendTo(this._notFound);
                                        } else {
                                            this._notFoundMsg.html(txt);
                                        }

                                        this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._control.find(".wf-kanban")) : null;
                                        $step = 33;
                                        continue;
                                    }
                                    case 33: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetColumnValue: function (col, valueElem, fieldDef, value, text, color) {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.SetColumnValue.call(this, col, valueElem, fieldDef, value, text, color);

                if (Bridge.referenceEquals(text, "&nbsp;")) {
                    text = "";
                }

                valueElem.attr("title", System.String.format("{0}: {1}", fieldDef.Label, text));
            },
            ClearTable: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.ClearTable.call(this);

                if (this._notFound != null) {
                    this._notFound.remove();
                    this._notFound = null;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.MobileGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        fields: {
            _cols: null
        },
        props: {
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            IsVisible: {
                get: function () {
                    return true;
                }
            }
        },
        alias: [
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible"
        ],
        ctors: {
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                if ((Bridge.referenceEquals(this.DataItem.DSPFID, e.DSPFID)) && (this._control != null)) {

                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.DataItem.DSPFID);
                    if (!Bridge.referenceEquals(this._currentRecord, rec)) {
                        if ((this._currentRecord != null ? this._currentRecord.RecID : null) != null) {
                            $(System.String.format(".wf-grid-row.id-{0}", [System.String.replaceAll(this._currentRecord.RecID, ",", "_")])).removeClass("wf-grid-row-selected");
                        }
                    }

                    if ((rec != null ? rec.RecID : null) != null) {
                        $(System.String.format(".wf-grid-row.id-{0}", [System.String.replaceAll(rec.RecID, ",", "_")])).addClass("wf-grid-row-selected");
                    }

                    this._currentRecord = rec;
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            CreateGridRow: function (form, dset, recs, cols, localRecNo) {
                var idClass = (recs[System.Array.index(localRecNo, recs)].RecID != null) ? System.String.format("id-{0}", [System.String.replaceAll(recs[System.Array.index(localRecNo, recs)].RecID, ",", "_")]) : "";

                var result = $("<div>").addClass(System.String.format("col-auto wf-grid-row {0}", [idClass])).appendTo(this._gridContentElem);

                if (localRecNo % 2 === 0) {
                    result.addClass("even");
                }

                return result;
            },
            GetGridColumns: function () {
                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    grid, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    gridRowElem, 
                    innerRow, 
                    imageElem, 
                    othersElem, 
                    rowValueRow, 
                    prevIsLeftCol, 
                    i, 
                    col, 
                    nextCol, 
                    fieldDef, 
                    fieldValue, 
                    $t, 
                    isLeftCol, 
                    text, 
                    value, 
                    valueElem, 
                    img, 
                    $t1, 
                    rowValueCol, 
                    edt, 
                    edit, 
                    txt, 
                    $taskResult1, 
                    rowValueRow1, 
                    rowValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36], $step);
                                switch ($step) {
                                    case 0: {
                                        grid = containerItem;

                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 30;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        this._cols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                                            return col.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.GridColumn);

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 29;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(recNo, recs)];

                                        gridRowElem = this.CreateGridRow(form, dset, recs, this._cols, localRecNo.v);
                                        gridRowElem.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    e.preventDefault();

                                                                    $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });
                                        })(this, localRecNo));

                                        innerRow = $("<div>").addClass("form-row").appendTo(gridRowElem);
                                        imageElem = $("<div>").addClass("wf-grid-row-image d-none").appendTo(innerRow);
                                        othersElem = $("<div>").addClass("col-auto flex-fill").appendTo(innerRow);

                                        rowValueRow = null;
                                        prevIsLeftCol = true;

                                        i = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 27;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i, this._cols)] };
                                        nextCol = (i < ((this._cols.length - 1) | 0)) ? this._cols[System.Array.index(((i + 1) | 0), this._cols)] : null;
                                        fieldDef = { v : System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null) };

                                        if (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile)) {
                                            $step = 26;
                                            continue;
                                        }

                                        fieldValue = rec != null && ($t = rec.FieldValues) != null ? System.Linq.Enumerable.from($t, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault((function ($me, fieldDef) {
                                            return function (fd) {
                                                return System.String.equals(fd.Name, fieldDef.v != null ? fieldDef.v.Name : null);
                                            };
                                        })(this, fieldDef), null) : null;
                                        if (fieldValue != null && System.Nullable.hasValue(fieldValue.ViewType)) {
                                            fieldDef.v.Type = System.Nullable.getValue(fieldValue.ViewType);
                                            fieldDef.v.Values = fieldValue.ViewValues;
                                            fieldDef.v.DisplayValues = fieldValue.ViewDisplayValues;
                                            fieldDef.v.Mask = fieldValue.ViewMask;
                                        }

                                        isLeftCol = (i <= 1) || ((nextCol != null) && (nextCol.RelatePrevious === 1)) || (!prevIsLeftCol);

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef.v);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef.v);

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        text = $taskResult2;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 18;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 17;
                                        continue;
                                    }
                                    case 15: {
                                        $task4 = (System.String.equals(text, "1") ? Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption") : Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption"));
                                        $step = 16;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 16: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 17;
                                        continue;
                                    }

                                    case 18: {
                                        if (isLeftCol) {
                                            rowValueRow = $("<div>").addClass("form-row").appendTo(othersElem);
                                        } else {
                                            rowValueRow.addClass("container");
                                        }

                                        valueElem = null;

                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            $step = 19;
                                            continue;
                                        } else  {
                                            $step = 20;
                                            continue;
                                        }
                                    }
                                    case 19: {
                                        imageElem.removeClass("d-none");

                                        if (!System.String.isNullOrEmpty(text)) {
                                            valueElem = $("<div>").addClass("wf-grid-value wf-grid-image").appendTo(imageElem);

                                            img = $(($t1 = new Image(), $t1.className = "wf-dataImage", $t1)).appendTo(valueElem);

                                            this.HandleImageOnLoad(img);

                                            img.attr("src", "data:image/png;base64," + (text || ""));

                                        }
                                        $step = 25;
                                        continue;
                                    }
                                    case 20: {
                                        rowValueCol = $("<div>").addClass("col-auto").appendTo(rowValueRow);

                                        valueElem = $("<div>").addClass("wf-grid-value").appendTo(rowValueCol);

                                        if ((this.AllowEdit(dset.DSPFID)) && (!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef.v))) {
                                            $step = 21;
                                            continue;
                                        } else  {
                                            $step = 23;
                                            continue;
                                        }
                                    }
                                    case 21: {
                                        edt = ($t1 = new Adaptica.WebForms.Common.DataModel.Edit(), $t1.DSPFID = dset.DSPFID, $t1.Caption = fieldDef.v.Label, $t1.FieldName = fieldDef.v.Name, $t1.FontColor = col.v.FontColor, $t1.FontStyle = col.v.FontStyle, $t1.Type = col.v.Type, $t1);

                                        edit = new Adaptica.WebForms.WebApp.Controls.EditControl(this.FormControl, edt, rec);
                                        edit.CreateControlOnly = true;
                                        this.SubControls.add(edit);

                                        $task5 = edit.RenderControl();
                                        $step = 22;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 22: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        ($taskResult5).appendTo(valueElem);
                                        $step = 24;
                                        continue;
                                    }
                                    case 23: {
                                        this.SetColumnValue(col.v, valueElem, fieldDef.v, value, text, col.v.FontColor);
                                        $step = 24;
                                        continue;
                                    }
                                    case 24: {
                                        if (!isLeftCol) {
                                            valueElem.addClass("float-right");
                                        }
                                        $step = 25;
                                        continue;
                                    }
                                    case 25: {
                                        if (i === 0) {
                                            valueElem != null ? valueElem.addClass("wf-grid-first") : null;
                                        }

                                        prevIsLeftCol = isLeftCol;
                                        $step = 26;
                                        continue;
                                    }
                                    case 26: {
                                        i = (i + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 28: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 29: {
                                        $step = 36;
                                        continue;
                                    }
                                    case 30: {
                                        if ((this._filterOnServer)) {
                                            $step = 31;
                                            continue;
                                        }  else {
                                            $step = 33;
                                            continue;
                                        }
                                    }
                                    case 31: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 32;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 32: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult1 = ($taskResult6 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 35;
                                        continue;
                                    }
                                    case 33: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 34;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 34: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $taskResult1 = $taskResult7;
                                        $step = 35;
                                        continue;
                                    }
                                    case 35: {
                                        txt = $taskResult1;

                                        rowValueRow1 = $("<div>").addClass("form-row").appendTo(this._gridContentElem);

                                        rowValue = $("<div>").addClass("col-auto").html(txt).appendTo(rowValueRow1);

                                        window.setTimeout(Bridge.fn.bind(this, function () {
                                            this._searchInput.focus();
                                        }), 100);
                                        $step = 36;
                                        continue;
                                    }
                                    case 36: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.TabulatorGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        fields: {
            _table: null,
            _notFound: null,
            _notFoundMsg: null,
            _tabulator: null,
            _isCreating: false,
            _isRecalculating: false,
            _cols: null,
            _eventsAttached: false
        },
        props: {
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            IsVisible: {
                get: function () {
                    return true;
                }
            },
            IsResponsive: {
                get: function () {
                    return false;
                }
            },
            FloatThead: {
                get: function () {
                    return true;
                }
            },
            Scroller: {
                get: function () {
                    return false;
                }
            },
            ColReorder: {
                get: function () {
                    return false;
                }
            },
            ControlId: {
                get: function () {
                    return System.String.format("ctrl_{0}", [this.FormControl.CreateUniqueControlId()]);
                }
            }
        },
        alias: [
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._eventsAttached = false;
            },
            ctor: function (form, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, form, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                if ((Bridge.referenceEquals(this.DataItem.DSPFID, e.DSPFID)) && (this._control != null)) {
                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.DataItem.DSPFID);
                    this.SetRecordSelectedClass(rec, true);

                    this._currentRecord = rec;
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetRecordSelectedClass: function (rec, readScrollTop) {
                if (readScrollTop === void 0) { readScrollTop = false; }
                if (!Bridge.referenceEquals(this._currentRecord, rec)) {
                    if ((this._currentRecord != null ? this._currentRecord.RecID : null) != null) {
                        $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this._currentRecord.RecID)])).removeClass("wf-grid-row-selected");
                    }
                }

                if ((rec != null ? rec.RecID : null) != null) {
                    var row = $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(rec.RecID)]));
                    row.addClass("wf-grid-row-selected");

                    if (readScrollTop) {
                        this._tableScrollTop = row.closest(".tabulator_scrollBody").scrollTop();
                    }
                }
            },
            GetGridColumns: function () {
                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $taskResult9, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tbody, 
                    rows, 
                    selRecord, 
                    selRow, 
                    maxH, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    row, 
                    i, 
                    col, 
                    color, 
                    fieldDef, 
                    fieldValue, 
                    $t, 
                    cell, 
                    text, 
                    value, 
                    $taskResult2, 
                    valueElem, 
                    img, 
                    $t1, 
                    h, 
                    edt, 
                    edit, 
                    txt, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17,18,19,20,22,23,24,25,26,27,29,30,32,33,34,35,36,37,38,39,40], $step);
                                switch ($step) {
                                    case 0: {
                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 34;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (this._notFound != null) {
                                            this._notFound.remove();
                                            this._notFound = null;

                                            this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._control.find(".wf-grid-tabulator")) : null;
                                        }

                                        if (this._table == null) {
                                            this.CreateGridHeader(containerItem, fieldDefs);
                                        }

                                        tbody = $("<tbody>").appendTo(this._table);

                                        this._table != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._table) : null;

                                        rows = null;
                                        if (this._tabulator != null) {
                                            rows = System.Array.init(recs.length, null, System.Object);
                                        }

                                        selRecord = null;
                                        selRow = null;
                                        maxH = 0;

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 33;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(localRecNo.v, recs)];

                                        row = $("<tr>").addClass(System.String.format("wf-grid-row id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(rec.RecID)]));

                                        if (Bridge.referenceEquals((this._currentRecord != null ? this._currentRecord.RecID : null), rec.RecID)) {
                                            selRecord = rec;
                                            selRow = row;
                                        }

                                        if (this._tabulator != null) {
                                            rows[System.Array.index(recNo, rows)] = row.get(0);
                                        } else {
                                            row.appendTo(tbody);
                                        }

                                        row.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if (!System.String.isNullOrEmpty(Bridge.toString(window.getSelection()))) {
                                                                            $tcs.setResult(null);
                                                                            return;
                                                                        }


                                                                        e.stopImmediatePropagation();
                                                                        e.preventDefault();

                                                                        $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                        })(this, localRecNo));

                                        i = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 31;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i, this._cols)] };
                                        color = col.v.FontColor;
                                        fieldDef = { v : System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null) };

                                        fieldValue = rec != null && ($t = rec.FieldValues) != null ? System.Linq.Enumerable.from($t, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault((function ($me, fieldDef) {
                                            return function (fd) {
                                                return System.String.equals(fd.Name, fieldDef.v != null ? fieldDef.v.Name : null);
                                            };
                                        })(this, fieldDef), null) : null;
                                        if (fieldValue != null && System.Nullable.hasValue(fieldValue.ViewType)) {
                                            fieldDef.v.Type = System.Nullable.getValue(fieldValue.ViewType);
                                            fieldDef.v.Values = fieldValue.ViewValues;
                                            fieldDef.v.DisplayValues = fieldValue.ViewDisplayValues;
                                            fieldDef.v.Mask = fieldValue.ViewMask;
                                        }

                                        cell = $("<td>").appendTo(row);

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef.v);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef.v);

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        color = "#7b7b7b";
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 22;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 15: {
                                        if (System.String.equals(text, "1")) {
                                            $step = 16;
                                            continue;
                                        }  else {
                                            $step = 18;
                                            continue;
                                        }
                                    }
                                    case 16: {
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 17;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        $taskResult2 = $taskResult5;
                                        $step = 20;
                                        continue;
                                    }
                                    case 18: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 19;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 19: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult2 = $taskResult6;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        text = $taskResult2;
                                        $step = 21;
                                        continue;
                                    }

                                    case 22: {
                                        valueElem = null;

                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            $step = 23;
                                            continue;
                                        } else  {
                                            $step = 24;
                                            continue;
                                        }
                                    }
                                    case 23: {
                                        valueElem = $("<div>").addClass("wf-grid-value wf-grid-image").appendTo(cell);

                                        img = $(($t1 = new Image(), $t1.className = "wf-dataImage", $t1)).appendTo(valueElem);

                                        if (!System.String.isNullOrEmpty(text)) {
                                            img.attr("src", "data:image/png;base64," + (text || ""));

                                            h = img.height();
                                            if (h > maxH) {
                                                maxH = h;
                                            }
                                        } else {
                                            img.css("visibility", "hidden");
                                        }
                                        $step = 29;
                                        continue;
                                    }
                                    case 24: {
                                        /* 
                                                                   var rowValueCol = new jQuery("<div>")
                                                                       .AppendTo(cell);

                                                                   valueElem = new jQuery("<div>")
                                                                       .AddClass("wf-grid-value")
                                                                       .AppendTo(rowValueCol);
                                        */

                                        cell.addClass("wf-grid-value");
                                        valueElem = cell;

                                        if ((this.AllowEdit(dset.DSPFID)) && (!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef.v))) {
                                            $step = 25;
                                            continue;
                                        } else  {
                                            $step = 27;
                                            continue;
                                        }
                                    }
                                    case 25: {
                                        edt = ($t1 = new Adaptica.WebForms.Common.DataModel.Edit(), $t1.DSPFID = dset.DSPFID, $t1.Caption = fieldDef.v.Label, $t1.FieldName = fieldDef.v.Name, $t1.FontColor = col.v.FontColor, $t1.FontStyle = col.v.FontStyle, $t1.Type = col.v.Type, $t1);

                                        edit = ($t1 = new Adaptica.WebForms.WebApp.Controls.EditControl(this.FormControl, edt, rec), $t1.CreateControlOnly = true, $t1);
                                        this.SubControls.add(edit);

                                        $task7 = edit.RenderControl();
                                        $step = 26;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        ($taskResult7).appendTo(valueElem);
                                        $step = 28;
                                        continue;
                                    }
                                    case 27: {
                                        if (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile)) {
                                            cell.addClass("wf-grid-cell-download");
                                        }

                                        this.SetColumnValue(col.v, valueElem, fieldDef.v, value, text, color);
                                        $step = 28;
                                        continue;
                                    }

                                    case 29: {
                                        if (i === 0) {
                                            valueElem != null ? valueElem.addClass("wf-grid-first") : null;
                                        }
                                        $step = 30;
                                        continue;
                                    }
                                    case 30: {
                                        i = (i + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 32: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 33: {
                                        if (this._tabulator == null) {
                                            this.CreateTable();
                                        } else {
                                        }

                                        if (selRecord != null) {
                                            this.SetRecordSelectedClass(selRecord);
                                            window.setTimeout(Bridge.fn.bind(this, function () {
                                                if (!this.IsElementInViewport(Bridge.as(selRow.get(0), HTMLElement))) {
                                                    selRow.closest(".tabulator_scrollBody").scrollTop(this._tableScrollTop);
                                                }
                                            }), 50);
                                        }
                                        $step = 40;
                                        continue;
                                    }
                                    case 34: {
                                        if (((this._filterOnServer) && (System.String.isNullOrEmpty(this._searchText)))) {
                                            $step = 35;
                                            continue;
                                        }  else {
                                            $step = 37;
                                            continue;
                                        }
                                    }
                                    case 35: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 36;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 36: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult1 = ($taskResult8 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 39;
                                        continue;
                                    }
                                    case 37: {
                                        $task9 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 38;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 38: {
                                        $taskResult9 = $task9.getAwaitedResult();
                                        $taskResult1 = $taskResult9;
                                        $step = 39;
                                        continue;
                                    }
                                    case 39: {
                                        txt = $taskResult1;

                                        if (this._notFound == null) {

                                            this._notFound = $("<div>").addClass("form-row wf-msg").appendTo(this._gridContentElem);

                                            this._notFoundMsg = $("<div>").addClass("col-auto").html(txt).appendTo(this._notFound);
                                        } else {
                                            this._notFoundMsg.html(txt);
                                        }

                                        this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._control.find(".wf-grid-tabulator")) : null;
                                        $step = 40;
                                        continue;
                                    }
                                    case 40: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsElementInViewport: function (e) {
                var el = null;

                if (Bridge.is(e, $)) {
                    el = Bridge.as((Bridge.as(e, $)).get(0), HTMLElement);
                } else if (Bridge.is(e, HTMLElement)) {
                    el = Bridge.as(e, HTMLElement);
                }

                if (el == null) {
                    throw new System.Exception("Invalid type");
                }

                var rect = el.getBoundingClientRect();

                var h = window.innerHeight;
                if (h === 0) {
                    h = window.document.documentElement.clientHeight;
                }
                var w = window.innerHeight;
                if (w === 0) {
                    w = window.document.documentElement.clientWidth;
                }

                return (rect.top >= 0 && rect.left >= 0 && rect.bottom <= h && rect.right <= w);
            },
            CreateGridHeader: function (containerItem, fieldDefs) {
                var $t;
                var grid = containerItem;

                var tmpCols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                        return col.Order;
                    }).toList(Adaptica.WebForms.Common.DataModel.GridColumn);

                var colIdx = 0;
                var i = (tmpCols.Count - 1) | 0;
                while (i > colIdx) {
                    var col = { v : tmpCols.getItem(i) };
                    var fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                            return function (fld) {
                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                            };
                        })(this, col), null);
                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                        tmpCols.removeAt(i);
                        tmpCols.insert(colIdx, col.v);
                        colIdx = (colIdx + 1) | 0;
                    } else {
                        i = (i - 1) | 0;
                    }
                }

                this._cols = tmpCols.ToArray();

                this._table = $("<table>").attr("id", this.ControlId).addClass("wf-grid-tabulator table table-striped table-bordered xnowrap");

                if (this.IsResponsive) {
                    this._table.addClass("dt-responsive");
                }

                var tHead = $("<thead>").appendTo(this._table);

                if (Bridge.equals(("no"), window.self.gridHeader)) {
                    tHead.addClass("wf-hidden");
                }

                var tHeadRow = $("<tr>").appendTo(tHead);

                $t = Bridge.getEnumerator(this._cols);
                try {
                    while ($t.moveNext()) {
                        var col1 = { v : $t.Current };
                        var fieldDef1 = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col1) {
                                return function (fld) {
                                    return Bridge.referenceEquals(fld.Name, col1.v.FieldName);
                                };
                            })(this, col1), null);
                        var isDownload = Bridge.referenceEquals(col1.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col1.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile);
                        var lbl = (isDownload) ? "" : fieldDef1.Label;

                        var cell = $("<th>").addClass("wf-grid-header").html(lbl).appendTo(tHeadRow);

                        if (isDownload) {
                            cell.addClass("wf-grid-cell-download");
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                this._gridContentElem.append(this._table);
            },
            ClearTable: function () {
                if (this._table == null) {
                    return;
                }

                this._tabulator.clearData();
            },
            OnFormActivated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormActivated.call(this);

                this.OnShownOrActivated();
            },
            OnFormDeactivated: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormDeactivated.call(this);
            },
            OnShow: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnShow.call(this);

                this.OnShownOrActivated();
            },
            OnHide: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnHide.call(this);

                this.OnHiddenOrDeactivated();
            },
            OnShownOrActivated: function () {
                if ((this.IsShown) && (!this._eventsAttached)) {
                    this._eventsAttached = true;

                    window.addEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));

                    if (this._searchBar != null) {
                        window.setTimeout(Bridge.fn.bind(this, function () {
                            this._searchInput.focus();
                        }), 10);
                    }
                }

                this.RecalculateSize();
            },
            OnHiddenOrDeactivated: function () {
                window.removeEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));
                this._eventsAttached = false;
            },
            RecalculateSize: function () {
                if ((this._notFound != null) || (this._isRecalculating)) {
                    return;
                }

                window.setTimeout(Bridge.fn.bind(this, function () {
                    if (this._isRecalculating) {
                        return;
                    }

                    this._isRecalculating = true;

                    var sTopElem = this.FormControl.Content.find(".sticky-top");
                    var prnt = this._gridContentElem.parent();

                    var h = this._gridContentElem.height();
                    var sTop = sTopElem.height();
                    var sTopOffsetTop = sTopElem.offset().top;
                    var scrollH = (prnt.prop("offsetHeight") - this._gridContentElem.prop("offsetHeight")) | 0;

                    var calc = (((((window.innerHeight - sTop) | 0) - sTopOffsetTop) | 0) - (((scrollH + 10) | 0))) | 0;
                    this._gridContentElem.css("height", calc);

                    var sh = prnt.prop("scrollHeight");
                    var oh = prnt.prop("offsetHeight");
                    var ch = prnt.prop("clientHeight");


                    this._isRecalculating = false;
                }), 10);
            },
            OnScroll: function () {
                if (this.FloatThead) {
                    this._table.floatThead("reflow");
                }
            },
            OnFormCreated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormCreated.call(this);

                if (this._notFound == null) {
                    this.CreateTable();
                }
            },
            CreateTable: function () {
                if ((this._tabulator == null) && (!this._isCreating)) {
                    this._isCreating = true;
                    window.setTimeout(Bridge.fn.bind(this, function () {
                        var tbl = jQuery(this._table);

                        this._tabulator = new Tabulator('#' + tbl.attr('id'), { layout:"fitColumns", movableColumns:true, resizableColumns:true, resizableRows:false, pagination:false, height:"100%", columnDefaults: { formatter: "html" } });

                        this.RecalculateSize();

                        this._isCreating = false;
                    }), 100);

                }
            },
            Dispose: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.Dispose.call(this);
            }
        }
    });
});
