/**
 * @version 1.0.0.0
 * @author HP Inc.
 * @copyright Copyright © HP Inc. 2019
 * @compiler Bridge.NET 17.10.1
 */
Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.Common.DataModel.IContainerItemFont", {
        $kind: "interface"
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.ContainerItem", {
        statics: {
            fields: {
                QIImage: null,
                QIVCard: null,
                QIICalendar: null,
                QIBarcode: null,
                QIBarcodeButton: null,
                QIEmail: null,
                QITimer: null,
                QICommunicate: null,
                QIMap: null,
                QIPhone: null,
                QIURL: null,
                QIAttachment: null,
                QIAttachmentOnline: null,
                QIDownloadFile: null,
                QIPrintFile: null,
                QIKanban: null,
                QIMobileCurrentLocalTime: null,
                QIMobileQRCodeImage: null,
                QIMobileHTMLText: null,
                QIMobileDataSignature: null
            },
            ctors: {
                init: function () {
                    this.QIImage = "QIMobile.Image";
                    this.QIVCard = "QIMobile.vCard";
                    this.QIICalendar = "QIMobile.iCalendar";
                    this.QIBarcode = "QIMobile.BarCode";
                    this.QIBarcodeButton = "QIMobile.BarCodeButton";
                    this.QIEmail = "QIMobile.Email";
                    this.QITimer = "QIMobile.Timer";
                    this.QICommunicate = "QIMobile.Communicate";
                    this.QIMap = "QIMobile.Map";
                    this.QIPhone = "QIMobile.PhoneNo";
                    this.QIURL = "QIMobile.URL";
                    this.QIAttachment = "QIMobile.Attachment";
                    this.QIAttachmentOnline = "QIMobile.Attachment.Online";
                    this.QIDownloadFile = "QIMobile.DownloadFile";
                    this.QIPrintFile = "QIMobile.PrintFile";
                    this.QIKanban = "QIMobile.KanbanTable";
                    this.QIMobileCurrentLocalTime = "QIMobile.CurrentLocalTime";
                    this.QIMobileQRCodeImage = "QIMobile.QRCodeImage";
                    this.QIMobileHTMLText = "QIMobile.HTMLText";
                    this.QIMobileDataSignature = "QIMobile.SignatureData";
                }
            }
        },
        fields: {
            PFPFID: null,
            DSPFID: null,
            Caption: null,
            FieldName: null,
            Order: 0,
            Action: null,
            Type: 0,
            ItemType: null
        },
        methods: {
            Clone: function () {

                var i = Bridge.as(Bridge.clone(this), Adaptica.WebForms.Common.DataModel.ContainerItem);
                return i;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Configuration", {
        fields: {
            Version: null,
            Language: null,
            OrganizationName: null,
            UserName: null,
            UserEmail: null,
            MainMenuID: null,
            ClearCache: 0,
            Texts: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Container", {
        fields: {
            Caption: null,
            Icon: null,
            Items: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum", {
        $kind: "nested enum",
        statics: {
            fields: {
                Unknown: 0,
                Button: 1,
                TileButton: 2,
                ButtonPicker: 3
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.CurrencyManager", {
        fields: {
            currentRecords: null,
            currentDatasets: null,
            MainDataset: null
        },
        events: {
            OnCurrentRecordChanged: null,
            OnDataSetChanged: null
        },
        ctors: {
            init: function () {
                this.currentRecords = new (System.Collections.Generic.Dictionary$2(System.String,Adaptica.WebForms.Common.DataModel.Record)).ctor();
                this.currentDatasets = new (System.Collections.Generic.Dictionary$2(System.String,Adaptica.WebForms.Common.DataModel.Dataset)).ctor();
            }
        },
        methods: {
            SetCurrentRecord: function (DSPFID, record) {
                var changed = false;
                if (this.currentRecords.containsKey(DSPFID)) {
                    changed = !Bridge.referenceEquals(this.currentRecords.getItem(DSPFID), record);
                    this.currentRecords.setItem(DSPFID, record);
                } else {
                    this.currentRecords.add(DSPFID, record);
                    changed = record != null;
                }

                if (changed) {
                    !Bridge.staticEquals(this.OnCurrentRecordChanged, null) ? this.OnCurrentRecordChanged(this, new Adaptica.WebForms.Common.DataModel.CurrencyManager.CurrencyManagerEventArgs(DSPFID)) : null;
                }
            },
            MoveNext: function (DSPFID) {
                var $t;
                var ds = this.GetCurrentDataset(DSPFID);
                this.SetCurrentRecord(DSPFID, ($t = ds.Records)[System.Array.index(((Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, this.GetCurrentRecord(DSPFID)) + 1) | 0), $t)]);
            },
            MovePrevious: function (DSPFID) {
                var $t;
                var ds = this.GetCurrentDataset(DSPFID);
                this.SetCurrentRecord(DSPFID, ($t = ds.Records)[System.Array.index(((Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, this.GetCurrentRecord(DSPFID)) - 1) | 0), $t)]);
            },
            SetCurrentDataset: function (DSPFID, dataset) {
                if (this.currentDatasets.containsKey(DSPFID)) {
                    if (!Bridge.referenceEquals(this.currentDatasets.getItem(DSPFID), dataset)) {
                        this.currentDatasets.setItem(DSPFID, dataset);
                        this.SetCurrentRecord(DSPFID, null);
                    } else {
                        if (!System.Array.contains(dataset.Records, this.GetCurrentRecord(DSPFID), Adaptica.WebForms.Common.DataModel.Record)) {
                            this.SetCurrentRecord(DSPFID, null);
                        }
                    }
                } else {
                    this.currentDatasets.add(DSPFID, dataset);
                    this.SetCurrentRecord(DSPFID, null);
                }

                if (!Bridge.staticEquals(this.OnDataSetChanged, null)) {
                    this.OnDataSetChanged(this, new Adaptica.WebForms.Common.DataModel.CurrencyManager.CurrencyManagerEventArgs(DSPFID));
                }

            },
            SetCurrentRecordToFirstFromDataModule: function (DSPFID, dataModule) {
                var $t;
                var sds = System.Linq.Enumerable.from(dataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).firstOrDefault(function (ds) {
                        return Bridge.referenceEquals(ds.DSPFID, DSPFID);
                    }, null);
                if (sds != null && sds.Records.length > 0) {
                    var sr = ($t = sds.Records)[System.Array.index(0, $t)];

                    var tds = this.currentDatasets.getItem(DSPFID);

                    var tr = System.Linq.Enumerable.from(tds.Records, Adaptica.WebForms.Common.DataModel.Record).singleOrDefault(function (r) {
                            return Bridge.referenceEquals(r.RecID, sr.RecID) || r.RecID == null && r.RecNo === sr.RecNo;
                        }, null);

                    if (tr != null) {
                        this.SetCurrentRecord(DSPFID, tr);
                    }
                }
            },
            LoadDataModule: function (dm, MainDSPFID) {
                var $t, $t1;
                dm != null ? dm.Datasets.forEach(Bridge.fn.bind(this, function (ds) {
                            this.SetCurrentDataset(ds.DSPFID, ds);
                        })) : null;

                if (System.String.isNullOrEmpty(MainDSPFID)) {
                    this.MainDataset = ($t = Adaptica.WebForms.Common.DataModel.Dataset, System.Linq.Enumerable.from(this.currentDatasets.Values, $t).toList($t)).Find(function (ds) {
                        return System.String.isNullOrEmpty(ds.MasterFields) || (!System.String.isNullOrEmpty(ds.MasterDSPFID) && !System.String.isNullOrEmpty(ds.MasterFields));
                    });
                } else {
                    this.MainDataset = ($t1 = Adaptica.WebForms.Common.DataModel.Dataset, System.Linq.Enumerable.from(this.currentDatasets.Values, $t1).toList($t1)).Find(function (ds) {
                        return Bridge.referenceEquals(ds.DSPFID, MainDSPFID);
                    });
                }
            },
            GetCurrentRecord: function (DSPFID) {
                if (System.String.isNullOrEmpty(DSPFID)) {
                    return null;
                }
                var result = { };

                this.currentRecords.tryGetValue(DSPFID, result);
                return result.v;
            },
            GetCurrentRecordOrFirst: function (DSPFID) {
                if (System.String.isNullOrEmpty(DSPFID)) {
                    return null;
                }

                if (this.GetCurrentRecord(DSPFID) == null) {
                    this.MoveToFirstRecord(DSPFID);
                }
                return this.GetCurrentRecord(DSPFID);
            },
            GetCurrentDataset: function (DSPFID) {
                if ((System.String.isNullOrEmpty(DSPFID)) || (!this.currentDatasets.containsKey(DSPFID))) {
                    return null;
                }
                return this.currentDatasets.getItem(DSPFID);
            },
            MoveToFirstRecord: function (DSPFID) {
                var $t, $t1;
                var ds = this.GetCurrentDataset(DSPFID);
                if (System.Nullable.gt((ds != null && ($t = ds.Records) != null ? $t.length : null), 0)) {
                    this.SetCurrentRecord(DSPFID, ($t1 = ds.Records)[System.Array.index(0, $t1)]);
                }
            },
            IsFirstRecord: function (DSPFID) {
                var r = this.GetCurrentRecord(DSPFID);
                var ds = this.GetCurrentDataset(DSPFID);

                return Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, r) === 0;
            },
            IsLastRecord: function (DSPFID) {
                var r = this.GetCurrentRecord(DSPFID);
                var ds = this.GetCurrentDataset(DSPFID);

                return Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, r) === ((ds.Records.length - 1) | 0);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.CurrencyManager.CurrencyManagerEventArgs", {
        $kind: "nested class",
        fields: {
            DSPFID: null
        },
        ctors: {
            ctor: function (DSPFID) {
                this.$initialize();
                System.Object.call(this);
                this.DSPFID = DSPFID;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.DataHelpers", {
        statics: {
            methods: {
                Commit: function (dataModule) {
                    dataModule.Datasets.forEach(function (ds) {
                            ds.Records = System.Linq.Enumerable.from(ds.Records, Adaptica.WebForms.Common.DataModel.Record).where(function (r) {
                                    return r.Event !== Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Delete;
                                }).ToArray(Adaptica.WebForms.Common.DataModel.Record);
                            ds.RecordCount = ds.Records.length;
                        });
                },
                MergeWith: function (target, source, updateExistingOnly) {
                    var anyChanges = false;
                    if ((target != null ? target.Datasets : null) == null) {
                        return false;
                    }

                    target.InstanceID = source.InstanceID;
                    source.Datasets.forEach(function (sds) {
                            var tds = System.Linq.Enumerable.from(target.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).firstOrDefault(function (ds) {
                                    return Bridge.referenceEquals(ds.DSPFID, sds.DSPFID);
                                }, null);
                            if (tds == null) {
                                target.Datasets.push(sds);
                                anyChanges = true;
                            } else {
                                if (!updateExistingOnly) {
                                    tds.RecordCount = sds.RecordCount;
                                    tds.MasterIDParent = sds.MasterIDParent;
                                    tds.InnerDSDSID = sds.InnerDSDSID;
                                    tds.OuterDSDSID = sds.OuterDSDSID;
                                }

                                tds.InstanceID = sds.InstanceID;
                                var destIds = System.Linq.Enumerable.from(tds.Records, Adaptica.WebForms.Common.DataModel.Record).select(function (r) {
                                        return r.RecID;
                                    }).toList(System.String);
                                sds.Records.forEach(function (sr) {
                                        var tr = System.Linq.Enumerable.from(tds.Records, Adaptica.WebForms.Common.DataModel.Record).firstOrDefault(function (r) {
                                                return Bridge.referenceEquals(r.RecID, sr.RecID) || r.RecID == null && r.RecNo === sr.RecNo;
                                            }, null);

                                        if (tr == null) {
                                            tds.Records.push(sr);
                                            anyChanges = true;
                                            if (sr.RecNo <= 0) {
                                                sr.RecNo = tds.Records.length;
                                            }
                                        } else {
                                            tr.RecID = sr.RecID;
                                            tr.RecNo = sr.RecNo;
                                            tr.Flags = sr.Flags;
                                            destIds.remove(tr.RecID);

                                            tr.Event = sr.Event;

                                            var unmatchedDestFieldValues = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.FieldValue)).$ctor1(tr.FieldValues);
                                            sr.FieldValues.forEach(function (sfv) {
                                                    var tfv = System.Linq.Enumerable.from(tr.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (fv) {
                                                            return Bridge.referenceEquals(fv.Name, sfv.Name);
                                                        }, null);
                                                    if (tfv == null) {
                                                        tr.FieldValues.push(sfv);
                                                        anyChanges = true;
                                                    } else {
                                                        if (!Bridge.referenceEquals(tfv.Value, sfv.Value)) {
                                                            tfv.Value = sfv.Value;
                                                            anyChanges = true;
                                                        }

                                                        if (System.Nullable.neq(tfv.ReadOnly, sfv.ReadOnly)) {
                                                            tfv.ReadOnly = sfv.ReadOnly;
                                                            anyChanges = true;
                                                        }

                                                        if (System.Nullable.neq(tfv.Visible, sfv.Visible)) {
                                                            tfv.Visible = sfv.Visible;
                                                            anyChanges = true;
                                                        }

                                                        if (System.Nullable.neq(tfv.Required, sfv.Required)) {
                                                            tfv.Required = sfv.Required;
                                                            anyChanges = true;
                                                        }
                                                        tfv.Event = sfv.Event;
                                                        unmatchedDestFieldValues.remove(tfv);
                                                    }
                                                });
                                            if (!updateExistingOnly) {
                                                tr.FieldValues = System.Linq.Enumerable.from(tr.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).except(unmatchedDestFieldValues).ToArray(Adaptica.WebForms.Common.DataModel.FieldValue);
                                            }
                                        }
                                    });
                                if (!updateExistingOnly) {
                                    var tmpRecs = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.Record)).$ctor1(tds.Records);

                                    var removedCount = tmpRecs.RemoveAll(function (r) {
                                        return destIds.contains(r.RecID);
                                    });
                                    if (removedCount > 0) {
                                        tds.Records = tmpRecs.ToArray();
                                        anyChanges = true;
                                    }
                                }
                            }
                        });
                    target.Datasets.forEach(function (ds) {
                            ds.Records.sort(function (a, b) {
                                    return ((a.RecNo - b.RecNo) | 0);
                                });
                        });

                    return anyChanges;
                },
                InsertRecord: function (cm, dataset) {
                    var $t;
                    var r = new Adaptica.WebForms.Common.DataModel.Record();
                    r.Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Insert;
                    r.RecID = null;
                    r.Update = 1;
                    r.Delete = dataset.Header.Delete;
                    dataset.Records.push(r);

                    r.RecNo = dataset.Records.length;

                    if (!System.String.isNullOrEmpty(dataset.MasterFields)) {
                        var m = System.Text.RegularExpressions.Regex.match(dataset.MasterFields, "(?:(?<leftPrefix>.*)\\.)*ID(?<leftSuffix>.*)=(?:(?<rightPrefix>.*)\\.)*ID(?<rightSuffix>.*)");
                        var leftPrefix = m.getGroups().getByName("leftPrefix").getSuccess() ? (m.getGroups().getByName("leftPrefix").getValue().toLowerCase() || "") + "." : "";
                        var leftSuffix = m.getGroups().getByName("leftSuffix").getSuccess() ? m.getGroups().getByName("leftSuffix").getValue().toLowerCase() : "";
                        var rightPrefix = m.getGroups().getByName("rightPrefix").getSuccess() ? (m.getGroups().getByName("rightPrefix").getValue().toLowerCase() || "") + "." : "";
                        var rightSuffix = m.getGroups().getByName("rightSuffix").getSuccess() ? m.getGroups().getByName("rightSuffix").getValue().toLowerCase() : "";
                        var ic_master = null, u_master = null;

                        if (!System.String.isNullOrEmpty(dataset.MasterIDParent)) {
                            if (System.String.indexOf(dataset.MasterIDParent, String.fromCharCode(44)) === -1) {
                                ic_master = dataset.MasterIDParent;
                            } else {
                                var splitted = System.String.split(dataset.MasterIDParent, System.Array.init([","], System.String), null, 1);
                                ic_master = splitted[System.Array.index(0, splitted)];
                                u_master = splitted[System.Array.index(1, splitted)];
                            }
                        } else {
                            var masterRecord = cm.GetCurrentRecordOrFirst(dataset.MasterDSPFID);
                            if (masterRecord != null) {
                                ic_master = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(masterRecord, (rightPrefix || "") + "ic" + (rightSuffix || ""));
                                u_master = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(masterRecord, (rightPrefix || "") + "u" + (rightSuffix || ""));
                            }
                        }
                        Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(r, ($t = new Adaptica.WebForms.Common.DataModel.FieldDef(), $t.Name = (leftPrefix || "") + "ic" + (leftSuffix || ""), $t), ic_master);
                        Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(r, ($t = new Adaptica.WebForms.Common.DataModel.FieldDef(), $t.Name = (leftPrefix || "") + "u" + (leftSuffix || ""), $t), u_master);
                        r.MasterIDParent = System.String.format("{0},{1}", ic_master, u_master);
                    }

                    return r;
                },
                DeleteRecord: function (cm, dataset, record) {
                    var recIdx = Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, dataset.Records, record);
                    if (recIdx > -1) {
                        var currRec = cm.GetCurrentRecord(dataset.DSPFID);
                        if (Bridge.referenceEquals(currRec, record)) {
                            cm.SetCurrentRecord(dataset.DSPFID, null);
                            dataset.Records.splice(recIdx, 1);
                        }
                    }
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.DataModule", {
        fields: {
            Datasets: null,
            InstanceID: null,
            InvalidData: false
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Dataset", {
        fields: {
            DSID: null,
            DSPFID: null,
            MasterDSPFID: null,
            MasterIDParent: null,
            InstanceID: null,
            InnerDSDSID: null,
            OuterDSDSID: null,
            MasterFields: null,
            RecordCount: 0,
            Header: null,
            Records: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Design", {
        fields: {
            Containers: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldDef", {
        fields: {
            Name: null,
            /**
             * - 0 - Bit
             - 1 - Enum
             - 2 - Set
             - 3 - Blob
             - 4 - Memo
             - 5 - LMemo
             - 6 - String
             - 7 - LString
             - 8 - Integer
             - 9 - Float
             - 10 - DateTime
             - 11 - Date
             - 12 - Time
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DataModel.FieldDef
             * @function Type
             * @type number
             */
            Type: 0,
            Hidden: 0,
            Required: 0,
            ReadOnly: 0,
            SelectFunction: 0,
            SelectFunctionID: null,
            Label: null,
            Values: null,
            DisplayValues: null,
            Mask: null,
            Action: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldType", {
        statics: {
            fields: {
                Bit: 0,
                Enum: 0,
                Set: 0,
                Blob: 0,
                Memo: 0,
                LMemo: 0,
                String: 0,
                LString: 0,
                Integer: 0,
                Float: 0,
                DateTime: 0,
                Date: 0,
                Time: 0
            },
            ctors: {
                init: function () {
                    this.Bit = 0;
                    this.Enum = 1;
                    this.Set = 2;
                    this.Blob = 3;
                    this.Memo = 4;
                    this.LMemo = 5;
                    this.String = 6;
                    this.LString = 7;
                    this.Integer = 8;
                    this.Float = 9;
                    this.DateTime = 10;
                    this.Date = 11;
                    this.Time = 12;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldValue", {
        fields: {
            Name: null,
            ReadOnly: null,
            Visible: null,
            Required: null,
            Value: null,
            Event: 0
        },
        ctors: {
            ctor: function () {
                this.$initialize();
            },
            $ctor1: function (fieldDef) {
                this.$initialize();
                this.Name = fieldDef.Name;
                this.ReadOnly = fieldDef.ReadOnly;
                this.Visible = fieldDef.Hidden === 0 ? 1 : 0;
                this.Required = fieldDef.Required;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldValue.FieldValueEventEnum", {
        $kind: "nested enum",
        statics: {
            fields: {
                Read: 0,
                Insert: 1,
                Update: 2,
                Delete: 3
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Form", {
        fields: {
            PFPFID: null,
            PFID: null,
            Caption: null,
            TimeStamp: null,
            BUID: null,
            DataModule: null,
            Functions: null,
            Design: null,
            Description: null,
            DescriptionMarks: null,
            IsMainMenu: false,
            IsF4: false,
            _templateName: null
        },
        props: {
            TemplateName: {
                get: function () {
                    var $t;
                    return ($t = this._templateName, $t != null ? $t : "Default");
                },
                set: function (value) {
                    this._templateName = value;
                }
            }
        },
        methods: {
            Clone: function () {
                var $t;
                var f = ($t = new Adaptica.WebForms.Common.DataModel.Form(), $t.PFPFID = this.PFPFID, $t.PFID = this.PFID, $t.Caption = this.Caption, $t.TimeStamp = this.TimeStamp, $t.BUID = this.BUID, $t.DataModule = this.DataModule, $t.Functions = this.Functions, $t.Design = this.Design, $t.Description = this.Description, $t.DescriptionMarks = this.DescriptionMarks, $t.IsMainMenu = this.IsMainMenu, $t.IsF4 = this.IsF4, $t.TemplateName = this.TemplateName, $t);

                return f;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Function", {
        statics: {
            fields: {
                fullBUID: null,
                AvailableColorsHex: null
            },
            ctors: {
                init: function () {
                    this.fullBUID = System.Array.init(["825666,10", "15600296,10", "14734745,10", "14734748,10", "14734750,10", "15600294,10", "15600292,10", "15600290,10", "15600288,10", "15600286,10", "15600284,10", "15600299,10", "16161295,10", "2087526,9", "27474808,10", "29178050,10", "29733131,10", "30624982,10"], System.String);
                    this.AvailableColorsHex = System.Array.init(["f15a29", "4a6fa5", "fbb03f", "f7931d", "3e5278", "808080", "91A1cf", "0FA8BC", "1E786C", "0B93D7", "C65911", "c0c0c0", "180B59", "bf211e", "598059", "4a6fa5"], System.String);
                }
            }
        },
        fields: {
            DSPFID: null,
            PFPFID: null,
            PFID: null,
            MFID: null,
            PFU: null,
            PFPFU: null,
            MasterFields: null,
            FunctionType: 0,
            SpecFunctionType: 0,
            SaveDS: 0,
            Icon: null,
            EnableExpr: null,
            VisibleExpr: null,
            BUID: null
        },
        props: {
            FunctionColorHex: {
                get: function () {
                    var index = System.Array.indexOfT(Adaptica.WebForms.Common.DataModel.Function.fullBUID, this.BUID);
                    if (index < 0) {
                        return Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex[System.Array.index(0, Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex)];
                    }
                    return Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex[System.Array.index(index % Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex.length, Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex)];
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FunctionType", {
        statics: {
            fields: {
                OpenForm: 0,
                ExecMacro: 0,
                SpecialFunction: 0
            },
            ctors: {
                init: function () {
                    this.OpenForm = 0;
                    this.ExecMacro = 1;
                    this.SpecialFunction = 2;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Header", {
        fields: {
            ReadOnly: 0,
            Read: 0,
            Insert: 0,
            Update: 0,
            Delete: 0,
            SaveMode: 0,
            InsertMode: 0,
            FieldDefs: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
                this.Read = 1;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Record", {
        fields: {
            RecID: null,
            RecNo: 0,
            Update: 0,
            Delete: 0,
            Flags: 0,
            MasterIDParent: null,
            Event: 0,
            FieldValues: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
                this.FieldValues = System.Array.init(0, null, Adaptica.WebForms.Common.DataModel.FieldValue);
                this.Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum", {
        $kind: "nested enum",
        statics: {
            fields: {
                None: 0,
                Insert: 1,
                Update: 2,
                Delete: 3
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.SpecFunctionType", {
        statics: {
            fields: {
                Save: 0,
                Cancel: 0,
                SaveAndInsert: 0
            },
            ctors: {
                init: function () {
                    this.Save = 0;
                    this.Cancel = 1;
                    this.SaveAndInsert = 2;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.UIText", {
        fields: {
            Icon: null,
            Text: null,
            ID: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Button", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem,Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            MasterFields: null,
            FontStyle: 0,
            FontColor: null,
            EnableExpr: null
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Edit", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem,Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            FontStyle: 0,
            FontColor: null
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Grid", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem],
        fields: {
            GridColumns: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.GridColumn", {
        inherits: [Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            Action: null,
            RelatePrevious: 0,
            FieldName: null,
            FontStyle: 0,
            FontColor: null,
            Type: 0,
            Order: 0
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
                this.Order = 2147483647;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Image", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem],
        ctors: {
            ctor: function () {
                this.$initialize();
                Adaptica.WebForms.Common.DataModel.ContainerItem.ctor.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Label", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem,Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            FontStyle: 0,
            FontColor: null
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Memo", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem],
        ctors: {
            ctor: function () {
                this.$initialize();
                Adaptica.WebForms.Common.DataModel.ContainerItem.ctor.call(this);
            }
        }
    });
});
