/**
 * @license
 * File:        ColReorderWithResize.js
 * Version:     3.0
 * CVS:         $Id$
 * Description: Allow columns to be reordered in a DataTable
 * Author:      Allan Jardine (www.sprymedia.co.uk)
 * Author:      Christophe Battarel (www.altairis.fr)
 * Created:     Wed Sep 15 18:23:29 BST 2010
 * Modified:    July 2011 by Christophe Battarel - christophe.battarel@altairis.fr (columns resizable)
 * Modified:    February 2012 by Martin Marchetta - martin.marchetta@gmail.com
 *  1. Made the "hot area" for resizing a little wider (it was a little difficult to hit the exact border of a column for resizing)
 *  2. Resizing didn't work at all when using scroller (that plugin splits the table into 2 different tables: one for the header and another one for the body, so when you resized the header, the data columns didn't follow)
 *  3. Fixed collateral effects of sorting feature
 *  4. If sScrollX is enabled (i.e. horizontal scrolling), when resizing a column the width of the other columns is not changed, but the whole
 *     table is resized to give an Excel-like behavior (good suggestion by Allan)
 * Modified:    February 2012 by Christophe Battarel - christophe.battarel@altairis.fr (ColReorder v1.0.5 adaptation)
 * Modified:    September 16th 2012 by Hassan Kamara - h@phrmc.com
 * Modified:    June 2017 by Jeff Walter - jeffreydwalter@gmail.com
 *  1. ColReorder v1.3.3 adaptation.
 *  2. Fixed issues with column width calculations which allowed column headers to become misaligned with table body when using scroller plugin.
 * Modified:    June 2018 by Jeff Walter - jeffreydwalter@gmail.com
 *  1. Took a second stab at this plugin. Made things work for both scroller and non-scroller tables.
 * Language:    Javascript
 * License:     MIT
 * Project:     DataTables
 *
 */
(function(n){typeof define=="function"&&define.amd?define(["jquery","datatables.net"],function(t){return n(t,window,document)}):typeof exports=="object"?module.exports=function(t,i){return t||(t=window),i&&i.fn.dataTable||(i=require("datatables.net")(t,i).$),n(i,t,t.document)}:n(jQuery,window,document)})(function(n,t,i,r){"use strict";function e(n){for(var i=[],t=0,r=n.length;t<r;t++)i[n[t]]=t;return i}function f(n,t,i){var r=n.splice(t,1)[0];n.splice(i,0,r)}function o(n,t,i){for(var f,u=[],r=0,e=n.childNodes.length;r<e;r++)n.childNodes[r].nodeType==1&&u.push(n.childNodes[r]);f=u[t];i!==null?n.insertBefore(f,u[i]):n.appendChild(f)}var s=n.fn.dataTable,u;n.fn.dataTableExt.oApi.fnColReorder=function(t,i,u,s,h){var c,l,y,it,rt,p=t.aoColumns.length,b,a,g=function(n,t,i){if(n[t]&&typeof n[t]!="function"){var r=n[t].split("."),u=r.shift();isNaN(u*1)||(n[t]=i[u*1]+"."+r.join("."))}},nt,v,tt,k,d,w;if(i!=u){if(i<0||i>=p){this.oApi._fnLog(t,1,"ColReorder 'from' index is out of bounds: "+i);return}if(u<0||u>=p){this.oApi._fnLog(t,1,"ColReorder 'to' index is out of bounds: "+u);return}for(nt=[],c=0,l=p;c<l;c++)nt[c]=c;for(f(nt,i,u),v=e(nt),c=0,l=t.aaSorting.length;c<l;c++)t.aaSorting[c][0]=v[t.aaSorting[c][0]];if(t.aaSortingFixed!==null)for(c=0,l=t.aaSortingFixed.length;c<l;c++)t.aaSortingFixed[c][0]=v[t.aaSortingFixed[c][0]];for(c=0,l=p;c<l;c++){for(a=t.aoColumns[c],y=0,it=a.aDataSort.length;y<it;y++)a.aDataSort[y]=v[a.aDataSort[y]];a.idx=v[a.idx]}for(n.each(t.aLastSort,function(n,i){t.aLastSort[n].src=v[i.src]}),c=0,l=p;c<l;c++)a=t.aoColumns[c],typeof a.mData=="number"?a.mData=v[a.mData]:n.isPlainObject(a.mData)&&(g(a.mData,"_",v),g(a.mData,"filter",v),g(a.mData,"sort",v),g(a.mData,"type",v));if(t.aoColumns[i].bVisible){for(tt=this.oApi._fnColumnIndexToVisible(t,i),k=null,c=u<i?u:u+1;k===null&&c<p;)k=this.oApi._fnColumnIndexToVisible(t,c),c++;for(b=t.nTHead.getElementsByTagName("tr"),c=0,l=b.length;c<l;c++)o(b[c],tt,k);if(t.nTFoot!==null)for(b=t.nTFoot.getElementsByTagName("tr"),c=0,l=b.length;c<l;c++)o(b[c],tt,k);for(c=0,l=t.aoData.length;c<l;c++)t.aoData[c].nTr!==null&&o(t.aoData[c].nTr,tt,k)}for(f(t.aoColumns,i,u),c=0,l=p;c<l;c++)t.oApi._fnColumnOptions(t,c,{});for(f(t.aoPreSearchCols,i,u),c=0,l=t.aoData.length;c<l;c++){if(d=t.aoData[c],w=d.anCells,w)for(f(w,i,u),y=0,rt=w.length;y<rt;y++)w[y]&&w[y]._DT_CellIndex&&(w[y]._DT_CellIndex.column=y);d.src!=="dom"&&n.isArray(d._aData)&&f(d._aData,i,u)}for(c=0,l=t.aoHeader.length;c<l;c++)f(t.aoHeader[c],i,u);if(t.aoFooter!==null)for(c=0,l=t.aoFooter.length;c<l;c++)f(t.aoFooter[c],i,u);for((h||h===r)&&n.fn.dataTable.Api(t).rows().invalidate(),c=0,l=p;c<l;c++)n(t.aoColumns[c].nTh).off("click.DT"),this.oApi._fnSortAttachListener(t,t.aoColumns[c].nTh,c);n(t.oInstance).trigger("column-reorder.dt",[t,{from:i,to:u,mapping:v,drop:s,iFrom:i,iTo:u,aiInvertMapping:v}])}};u=function(t,i){var e=new n.fn.dataTable.Api(t).settings()[0],f;return e._colReorder?e._colReorder:(i===!0&&(i={}),f=n.fn.dataTable.camelToHungarian,f&&(f(u.defaults,u.defaults,!0),f(u.defaults,i||{})),this.s={dt:null,init:n.extend(!0,{},u.defaults,i),allowReorder:!0,allowResize:!0,fixed:0,fixedRight:0,reorderCallback:null,resizeCallback:null,mouse:{startX:-1,startY:-1,offsetX:-1,offsetY:-1,target:-1,targetIndex:-1,fromIndex:-1},aoTargets:[]},this.dom={drag:null,resize:null,pointer:null},this.s.dt=e,this.s.dt.oInit.sScrollX===r&&(this.table_size=-1),this.s.dt._colReorder=this,this._fnConstruct(),this)};n.extend(u.prototype,{fnReset:function(){return this._fnOrderColumns(this.fnOrder()),this},fnGetCurrentOrder:function(){return this.fnOrder()},fnOrder:function(t,i){var f=[],u,o,s=this.s.dt.aoColumns,h;if(t===r){for(u=0,o=s.length;u<o;u++)f.push(s[u]._ColReorder_iOrigCol);return f}if(i){for(h=this.fnOrder(),u=0,o=t.length;u<o;u++)f.push(n.inArray(t[u],h));t=f}return this._fnOrderColumns(e(t)),this},fnTranspose:function(t,i){i||(i="toCurrent");var r=this.fnOrder(),u=this.s.dt.aoColumns;return i==="toCurrent"?n.isArray(t)?n.map(t,function(t){return n.inArray(t,r)}):n.inArray(t,r):n.isArray(t)?n.map(t,function(n){return u[n]._ColReorder_iOrigCol}):u[t]._ColReorder_iOrigCol},_fnConstruct:function(){var t=this,s=this.s.dt.aoColumns.length,f=this.s.dt.nTable,i,u,o,h;for(this.s.init.allowReorder!=r&&(this.s.allowReorder=this.s.init.allowReorder),this.s.init.allowResize!=r&&(this.s.allowResize=this.s.init.allowResize),this.s.init.iFixedColumns&&(this.s.fixed=this.s.init.iFixedColumns),this.s.init.iFixedColumnsLeft&&(this.s.fixed=this.s.init.iFixedColumnsLeft),this.s.init.classNameClonedTable&&(this.s.classNameClonedTable=this.s.init.classNameClonedTable),this.s.init.classNamePointer&&(this.s.classNamePointer=this.s.init.classNamePointer),this.s.init.classNameTableHeader&&(this.s.classNameTableHeader=this.s.init.classNameTableHeader),this.s.init.classNameTableHeaderHover&&(this.s.classNameTableHeaderHover=this.s.init.classNameTableHeaderHover),this.s.fixedRight=this.s.init.iFixedColumnsRight?this.s.init.iFixedColumnsRight:0,this.s.init.fnReorderCallback&&(this.s.reorderCallback=this.s.init.fnReorderCallback),this.s.init.fnResizeCallback&&(this.s.resizeCallback=this.s.init.fnResizeCallback),i=0;i<s;i++)i>this.s.fixed-1&&i<s-this.s.fixedRight&&this._fnMouseListener(i,this.s.dt.aoColumns[i].nTh),this.s.dt.aoColumns[i]._ColReorder_iOrigCol=i;if(this.s.dt.oApi._fnCallbackReg(this.s.dt,"aoStateSaveParams",function(n,i){t._fnStateSave.call(t,i)},"ColReorder_State"),u=null,this.s.init.aiOrder&&(u=this.s.init.aiOrder.slice()),this.s.dt.oLoadedState&&typeof this.s.dt.oLoadedState.ColReorder!="undefined"&&this.s.dt.oLoadedState.ColReorder.length==this.s.dt.aoColumns.length&&(u=this.s.dt.oLoadedState.ColReorder),u)if(t.s.dt._bInitComplete)h=e(u),t._fnOrderColumns.call(t,h);else{o=!1;n(f).on("draw.dt.colReorder",function(){if(!t.s.dt._bInitComplete&&!o){o=!0;var n=e(u);t._fnOrderColumns.call(t,n);t._fnSetMouseListeners()}})}else this._fnSetColumnIndexes();n(f).on("destroy.dt.colReorder",function(){n(f).off("destroy.dt.colReorder draw.dt.colReorder");n(t.s.dt.nTHead).find("*").off(".ColReorder");n.each(t.s.dt.aoColumns,function(t,i){n(i.nTh).removeAttr("data-column-index")});t.s.dt._colReorder=null;t.s=null})},_fnSetMouseListeners:function(){for(var t=this.s.dt.aoColumns.length,n=0;n<t;n++)n>this.s.fixed-1&&n<t-this.s.fixedRight&&this._fnMouseListener(n,this.s.dt.aoColumns[n].nTh)},_fnOrderColumns:function(t){var u=!1,i,e,r;if(t.length!=this.s.dt.aoColumns.length){this.s.dt.oInstance.oApi._fnLog(this.s.dt,1,"ColReorder - array reorder does not match known number of columns. Skipping.");return}for(i=0,e=t.length;i<e;i++)r=n.inArray(i,t),i!=r&&(f(t,r,i),this.s.dt.oInstance.fnColReorder(r,i,!0,!1),u=!0);(n.fn.dataTable.Api(this.s.dt).rows().invalidate(),this._fnSetColumnIndexes(),u)&&((this.s.dt.oScroll.sX!==""||this.s.dt.oScroll.sY!=="")&&this.s.dt.oInstance.fnAdjustColumnSizing(!1),this.s.dt.oInstance.oApi._fnSaveState(this.s.dt),this.s.reorderCallback!==null&&this.s.reorderCallback.call(this))},_fnStateSave:function(t){var i,f,r,s=this.s.dt,u=s.aoColumns,e,o;if(t.ColReorder=[],t.aaSorting){for(i=0;i<t.aaSorting.length;i++)t.aaSorting[i][0]=u[t.aaSorting[i][0]]._ColReorder_iOrigCol;for(e=n.extend(!0,[],t.aoSearchCols),i=0,f=u.length;i<f;i++)r=u[i]._ColReorder_iOrigCol,t.aoSearchCols[r]=e[i],t.abVisCols[r]=u[i].bVisible,t.ColReorder.push(r)}else if(t.order){for(i=0;i<t.order.length;i++)t.order[i][0]=u[t.order[i][0]]._ColReorder_iOrigCol;for(o=n.extend(!0,[],t.columns),i=0,f=u.length;i<f;i++)r=u[i]._ColReorder_iOrigCol,t.columns[r]=o[i],t.ColReorder.push(r)}},_fnMouseListener:function(t,i){var r=this,e=this.s.dt.aoColumns,o=r.s.dt.oFeatures.bSort,u=this.s.classNameTableHeaderHover,f=this.s.classNameTableHeader;if(n(i).off(".ColReorder"),this.s.allowResize)n(i).on("mousemove.ColReorder",function(t){if(r.dom.drag===null&&r.dom.resize===null){var i=t.target.nodeName=="TH"?t.target:n(t.target).parents("TH")[0],e=n(i).offset(),o=n(i).innerWidth();Math.abs(t.pageX-Math.round(e.left+o))<=5?(n(i).css({cursor:"col-resize"}),n(i).removeClass(f),n(i).addClass(u)):(n(i).css({cursor:"pointer"}),n(i).removeClass(u),n(i).addClass(f))}});n(i).on("mousedown.ColReorder",function(n){n.preventDefault();n.which==1&&r._fnMouseDown.call(r,n,i,t)}).on("touchstart.ColReorder",function(n){r._fnMouseDown.call(r,n,i,t)})},_fnMouseDown:function(t,u,f){function h(){n(i).on("mousemove.ColReorder touchmove.ColReorder",function(n){e._fnMouseMove.call(e,n,f)}).on("mouseup.ColReorder touchend.ColReorder",function(n){n.preventDefault();n.stopPropagation();e._fnMouseUp.call(e,n,f)})}var e=this,o=this.s.dt.aoColumns,c;if(n(u).css("cursor")=="col-resize")this.s.mouse.startX=t.pageX,this.s.mouse.startWidth=n(u).width(),this.s.mouse.resizeElem=n(u),c=n(u).next(),this.s.mouse.nextStartWidth=n(c).width(),e.dom.resize=!0,o[f].CRbSortableCache=o[f].bSortable,o[f].bSortable=!1,this.s.dt.oFeatures.bAutoWidth=!1,h();else if(this.s.allowReorder){if(o[f].bReorderable===!1)return!1;e.dom.resize=null;var a=n(t.target).closest("th, td"),l=a.offset(),s=parseInt(n(u).attr("data-column-index"),10);if(s===r)return;this.s.mouse.startX=this._fnCursorPosition(t,"pageX");this.s.mouse.startY=this._fnCursorPosition(t,"pageY");this.s.mouse.offsetX=this._fnCursorPosition(t,"pageX")-l.left;this.s.mouse.offsetY=this._fnCursorPosition(t,"pageY")-l.top;this.s.mouse.target=this.s.dt.aoColumns[s].nTh;this.s.mouse.targetIndex=s;this.s.mouse.fromIndex=s;this._fnRegions();h()}},_fnMouseMove:function(t,i){var ot=this,a,s,k,v,nt,l,b,h,w,d,rt,o,ut;if(this.dom.resize){for(s=-1,a=-1;a<this.s.dt.aoColumns.length-1&&a!=i;a++)this.s.dt.aoColumns[a+1].bVisible&&s++;s++;var u=n(this.s.mouse.resizeElem),p=n(u.next("th")),st=n(this.s.dt.nTBody),ht=n(this.s.dt.nTHead),ct=u.first().innerWidth(),ft=p.first().innerWidth(),f=t.pageX-this.s.mouse.startX,e=parseInt(this.s.mouse.startWidth+f),lt=parseInt(this.s.mouse.nextStartWidth-f),g=this.s.dt.oInit.sScrollX!==r,et=this.s.dt.oInit.sScrollY!==r;if(g||et){k=n(this.s.dt.nScrollHead);v=n(this.s.dt.nScrollBody);g&&(nt=k.find("div.dataTables_scrollHeadInner"),l=n(this.s.dt.nTableWrapper),(this.table_size===r||this.table_size<0)&&l.length>0&&(this.table_size=n(k[0].childNodes[0].childNodes[0]).width()),this.table_size+f>l.width()&&(l.length&&n(l[0].childNodes[0].childNodes[0]).width(this.table_size+f),n(nt).width(this.table_size+f),b=this.table_size,this.table_size+f>l.width()&&(b+=f),v.closest(".dataTables_scroll").find(".dataTables_scrollHead table").first().width(b),v.closest(".dataTables_scroll").find(".dataTables_scrollBody table").first().width(b)));var tt=v.find("thead").first("tr"),c=tt.find("th:nth-child("+s+")"),y=tt.find("th:nth-child("+(s+1)+")"),at=c.find(".dataTables_sizing"),vt=y.find(".dataTables_sizing"),it=v.find("tbody").first("tr"),yt=it.find("td:nth-child("+s+")"),pt=it.find("td:nth-child("+(s+1)+")");if(f<0)console.log("ColReorderWithResize, moveLength: "+f),c.width("1%"),h=c.width(),c.width(this.s.mouse.startWidth),e>=h?(console.log("ColReorderWithResize, set width: "+e),u.width(e),c.width(e)):(u.width(h),c.width(h));else{if(y.width("1%"),w=y.width(),y.width(this.s.mouse.nextStartWidth),y.width()<=w)return;console.log("ColReorderWithResize, set width: "+e);u.width(e);c.width(e)}}else if(f<0)u.width("1%"),h=u.width(),u.width(this.s.mouse.startWidth),e>=h?u.width(e):u.width(h);else{if(p.width("1%"),w=p.width(),p.width(this.s.mouse.nextStartWidth),ft<=w)return;u.width(e)}}else if(this.s.allowReorder){if(this.dom.drag===null){if(Math.pow(Math.pow(this._fnCursorPosition(t,"pageX")-this.s.mouse.startX,2)+Math.pow(this._fnCursorPosition(t,"pageY")-this.s.mouse.startY,2),.5)<5)return;this._fnCreateDragNode()}for(this.dom.drag.css({left:this._fnCursorPosition(t,"pageX")-this.s.mouse.offsetX,top:this._fnCursorPosition(t,"pageY")-this.s.mouse.offsetY}),d=!1,rt=this.s.mouse.toIndex,o=1,ut=this.s.aoTargets.length;o<ut;o++)if(this._fnCursorPosition(t,"pageX")<this.s.aoTargets[o-1].x+(this.s.aoTargets[o].x-this.s.aoTargets[o-1].x)/2){this.dom.pointer.css("left",this.s.aoTargets[o-1].x);this.s.mouse.toIndex=this.s.aoTargets[o-1].to;d=!0;break}d||(this.dom.pointer.css("left",this.s.aoTargets[this.s.aoTargets.length-1].x),this.s.mouse.toIndex=this.s.aoTargets[this.s.aoTargets.length-1].to);this.s.init.bRealtime&&rt!==this.s.mouse.toIndex&&(this.s.dt.oInstance.fnColReorder(this.s.mouse.fromIndex,this.s.mouse.toIndex,!1),this.s.mouse.fromIndex=this.s.mouse.toIndex,this._fnRegions())}},_fnMouseUp:function(t,u){var c=this,e,s,f,o,h;if(n(i).off(".ColReorder"),this.dom.drag!==null)this.dom.drag.remove(),this.dom.pointer.remove(),this.dom.drag=null,this.dom.pointer=null,this.s.dt.oInstance.fnColReorder(this.s.mouse.fromIndex,this.s.mouse.toIndex,!0),this._fnSetColumnIndexes(),(this.s.dt.oScroll.sX!==""||this.s.dt.oScroll.sY!=="")&&this.s.dt.oInstance.fnAdjustColumnSizing(!1),this.s.dt.oInstance.trigger("column-reorder.dt.mouseup",[this.s.dt]),this.s.dt.oInstance.oApi._fnSaveState(this.s.dt),this._fnSetMouseListeners(),this.s.reorderCallback!==null&&this.s.reorderCallback.call(this);else if(this.dom.resize!==null){if(this.s.dt.aoColumns[u].bSortable=this.s.dt.aoColumns[u].CRbSortableCache,this.s.dt.aoColumns[u].sWidth=n(this.s.mouse.resizeElem).width()+"px",h=this.s.dt.oInit.sScrollX===""?!1:!0,!h){for(f=u+1;f<this.s.dt.aoColumns.length;f++)if(this.s.dt.aoColumns[f].bVisible)break;for(o=u-1;o>=0;o--)if(this.s.dt.aoColumns[o].bVisible)break;if(this.s.dt.aoColumns.length>f)this.s.dt.aoColumns[f].sWidth=n(this.s.mouse.resizeElem).next().width()+"px";else for(s=this.s.mouse.resizeElem,e=o;e>0;e--)this.s.dt.aoColumns[e].bVisible&&(s=n(s).prev(),this.s.dt.aoColumns[e].sWidth=n(s).width()+"px")}h&&n(this.s.dt.nScrollHead,this.s.dt.nTableWrapper)!=r&&n(this.s.dt.nScrollHead,this.s.dt.nTableWrapper).length>0&&(this.table_size=n(n(this.s.dt.nScrollHead,this.s.dt.nTableWrapper)[0].childNodes[0].childNodes[0]).width());this.s.dt.oInstance.trigger("column-resize.dt.mouseup",[this.s.dt]);this.s.dt.oInstance.oApi._fnSaveState(this.s.dt);(this.s.dt.oScroll.sX!==""||this.s.dt.oScroll.sY!=="")&&this.s.dt.oInstance.fnAdjustColumnSizing(!1);this.s.resizeCallback!==null&&this.s.resizeCallback.call(this)}return this.dom.resize=null,!1},_fnRegions:function(){var i=this.s.dt.aoColumns,r,u,t,f;for(this.s.aoTargets.splice(0,this.s.aoTargets.length),this.s.aoTargets.push({x:n(this.s.dt.nTable).offset().left,to:0}),r=0,u=this.s.aoTargets[0].x,t=0,f=i.length;t<f;t++)t!=this.s.mouse.fromIndex&&r++,i[t].bVisible&&i[t].nTh.style.display!=="none"&&(u+=n(i[t].nTh).outerWidth(),this.s.aoTargets.push({x:u,to:r}));this.s.fixedRight!==0&&this.s.aoTargets.splice(this.s.aoTargets.length-this.s.fixedRight);this.s.fixed!==0&&this.s.aoTargets.splice(0,this.s.fixed)},_fnCreateDragNode:function(){var i=this.s.dt.oScroll.sX!==""||this.s.dt.oScroll.sY!=="",t=this.s.dt.aoColumns[this.s.mouse.targetIndex].nTh,r=t.parentNode,u=r.parentNode,f=u.parentNode,e=n(t).clone();this.dom.drag=n(f.cloneNode(!1)).addClass(this.s.classNameClonedTable).append(n(u.cloneNode(!1)).append(n(r.cloneNode(!1)).append(e[0]))).css({position:"absolute",top:0,left:0,width:n(t).outerWidth(),height:n(t).outerHeight()}).appendTo("body");this.dom.pointer=n("<div><\/div>").addClass(this.s.classNamePointer).css({position:"absolute",top:i?n("div.dataTables_scroll",this.s.dt.nTableWrapper).offset().top:n(this.s.dt.nTable).offset().top,height:i?n("div.dataTables_scroll",this.s.dt.nTableWrapper).height():n(this.s.dt.nTable).height()}).appendTo("body")},_fnSetColumnIndexes:function(){n.each(this.s.dt.aoColumns,function(t,i){n(i.nTh).attr("data-column-index",t)})},_fnCursorPosition:function(n,t){return n.type.indexOf("touch")!==-1?n.originalEvent.touches[0][t]:n[t]}});u.defaults={aiOrder:null,bRealtime:!0,iFixedColumnsLeft:0,iFixedColumnsRight:0,fnReorderCallback:null,fnResizeCallback:null,allowReorder:!0,allowResize:!0,classNameClonedTable:"DTCR_clonedTable",classNamePointer:"DTCR_pointer",classNameTableHeader:"DTCR_tableHeader",classNameTableHeaderHover:"DTCR_tableHeaderHover"};u.version="1.3.3";n.fn.dataTable.ColReorder=u;n.fn.DataTable.ColReorder=u;typeof n.fn.dataTable=="function"&&typeof n.fn.dataTableExt.fnVersionCheck=="function"&&n.fn.dataTableExt.fnVersionCheck("1.10.8")?n.fn.dataTableExt.aoFeatures.push({fnInit:function(n){var r=n.oInstance,t,i;return n._colReorder?r.oApi._fnLog(n,1,"ColReorder attempted to initialise twice. Ignoring second"):(t=n.oInit,i=t.colReorder||t.oColReorder||{},new u(n,i)),null},cFeature:"R",sFeature:"ColReorder"}):alert("Warning: ColReorder requires DataTables 1.10.8 or greater - www.datatables.net/download");n(i).on("preInit.dt.colReorder",function(t,i){var r,f,e;t.namespace==="dt"&&(r=i.oInit.colReorder,f=s.defaults.colReorder,(r||f)&&(e=n.extend({},r,f),r!==!1&&new u(i,e)))});return n.fn.dataTable.Api.register("colReorder.reset()",function(){return this.iterator("table",function(n){n._colReorder.fnReset()})}),n.fn.dataTable.Api.register("colReorder.order()",function(n,t){return n?this.iterator("table",function(i){i._colReorder.fnOrder(n,t)}):this.context.length?this.context[0]._colReorder.fnOrder():null}),n.fn.dataTable.Api.register("colReorder.transpose()",function(n,t){return this.context.length&&this.context[0]._colReorder?this.context[0]._colReorder.fnTranspose(n,t):n}),u});