Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.Extensions", {
        statics: {
            methods: {
                Clear: function (T, array) {
                    array.splice(0, array.length);
                },
                Add: function (T, array, item) {
                    array.push(item);
                },
                WFShow: function (action) {
                    return action.removeClass("wf-hidden");
                },
                WFHide: function (action) {
                    /* 
                               var disp = action.Css("display");
                               if (disp != "none")
                               {
                                   action.Data("wf-orgDisplay", disp);
                               }
                    */
                    return action.addClass("wf-hidden");
                },
                SetCustomPlaceholder: function (jq, textId) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        ph, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (textId === void 0) { textId = null; }
                                            ph = jq.attr("data-userPlaceholder");
                                            /* 
                                                       if (string.IsNullOrEmpty(ph))
                                                       {
                                                           ph = jq.Attr("placeholder");
                                                       }
                                            */

                                            if (!System.String.isNullOrEmpty(ph)) {
                                                if (System.String.equals(("*none*"), ph)) {
                                                    jq.removeAttr("placeholder");
                                                    $tcs.setResult(null);
                                                    return;
                                                }

                                                if (System.String.indexOf(ph, "${text.", 0, null, 3) > -1) {
                                                    ph = ph.replace(Adaptica.WebForms.WebApp.WebFormsApp.TextMarkRegex, function (s, i, textId1) {
                                                        return Adaptica.WebForms.WebApp.WebFormsApp.GetText(textId1);
                                                    });
                                                }
                                            }

                                            if ((System.String.isNullOrEmpty(ph)) && (!System.String.isNullOrEmpty(textId))) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync(textId);
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            ph = $taskResult1;
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            if (!System.String.isNullOrEmpty(ph)) {
                                                jq.attr("placeholder", ph);
                                            }
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                IndexOf: function (T, array, value) {
                    return System.Array.indexOfT(array, value);
                },
                NormalizeFloat: function (value) {
                    if ((System.String.indexOf(value, String.fromCharCode(44)) > -1) && (System.String.indexOf(value, String.fromCharCode(46)) > -1)) {
                        value = System.String.replaceAll(value, ",", "");
                    } else {
                        value = System.String.replaceAll(value, ",", ".");
                    }

                    value = System.String.replaceAll(value, " ", "");

                    return value;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.HistoryPopState", {
        fields: {
            stateCounter: 0,
            formId: null
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.TemplateInfo", {
        fields: {
            Html: null,
            Css: null,
            UsageCount: 0
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.WebFormsApp", {
        $literal: true,
        statics: {
            fields: {
                _texts: null,
                _favouriteItems: null,
                _historyStateCounter: 0,
                _broadcast: null,
                _queryString: null,
                _templateUsage: null,
                LoginType: null,
                _loginPrepared: false,
                _regPrepared: false,
                _regApproval: false,
                _mailRegex: null,
                _pwdDialogPrepared: false,
                _ssid: null,
                _appRoot: null,
                _appPath: null,
                _userName: null,
                _organizationName: null,
                MarkRegex: null,
                TextMarkRegex: null,
                _openForms: null
            },
            props: {
                IsRunningInPortal: {
                    get: function () {
                        return typeof (QIWebForms) !== 'undefined';
                    }
                },
                SSID: {
                    get: function () {
                        if (!System.String.isNullOrEmpty(Adaptica.WebForms.WebApp.WebFormsApp._ssid)) {
                            return Adaptica.WebForms.WebApp.WebFormsApp._ssid;
                        }

                        var ssid;
                        try {
                            ssid = Adaptica.WebForms.WebApp.WebFormsApp.GetLS("ssid");
                            Adaptica.WebForms.WebApp.WebFormsApp.Log("get ssid: " + (ssid || ""));
                        } catch ($e1) {
                            $e1 = System.Exception.create($e1);
                            ssid = Adaptica.WebForms.WebApp.WebFormsApp._ssid;
                        }

                        return ssid;
                    },
                    set: function (value) {
                        try {
                            if (System.String.isNullOrEmpty(value)) {
                                Adaptica.WebForms.WebApp.WebFormsApp.RemoveLS("ssid");
                                Adaptica.WebForms.WebApp.WebFormsApp.Log("ssid cleared");
                            } else {
                                Adaptica.WebForms.WebApp.WebFormsApp.SetLS("ssid", value);
                                Adaptica.WebForms.WebApp.WebFormsApp.Log("set ssid: " + (value || ""));
                            }

                        } catch ($e1) {
                            $e1 = System.Exception.create($e1);
                            Adaptica.WebForms.WebApp.WebFormsApp._ssid = value;
                        }
                    }
                },
                AppRoot: {
                    get: function () {
                        if (System.String.isNullOrEmpty(Adaptica.WebForms.WebApp.WebFormsApp._appRoot)) {
                            Adaptica.WebForms.WebApp.WebFormsApp._appRoot = Adaptica.WebForms.WebApp.WebFormsApp.GetText("SystemAppRoot");
                        }

                        return Adaptica.WebForms.WebApp.WebFormsApp._appRoot;
                    }
                },
                AppPath: {
                    get: function () {
                        if (System.String.isNullOrEmpty(Adaptica.WebForms.WebApp.WebFormsApp._appPath)) {
                            Adaptica.WebForms.WebApp.WebFormsApp._appPath = Adaptica.WebForms.WebApp.WebFormsApp.GetText("SystemAppId");
                        }

                        return Adaptica.WebForms.WebApp.WebFormsApp._appPath;
                    }
                },
                UserName: {
                    get: function () {
                        if (System.String.isNullOrEmpty(Adaptica.WebForms.WebApp.WebFormsApp._userName)) {
                            Adaptica.WebForms.WebApp.WebFormsApp._userName = Adaptica.WebForms.WebApp.WebFormsApp.GetText("SystemUserName");
                        }

                        return Adaptica.WebForms.WebApp.WebFormsApp._userName;
                    }
                },
                OrganizationName: {
                    get: function () {
                        if (System.String.isNullOrEmpty(Adaptica.WebForms.WebApp.WebFormsApp._organizationName)) {
                            Adaptica.WebForms.WebApp.WebFormsApp._organizationName = Adaptica.WebForms.WebApp.WebFormsApp.GetText("SystemOrgName");
                        }

                        return Adaptica.WebForms.WebApp.WebFormsApp._organizationName;
                    }
                },
                OpenFormsCount: {
                    get: function () {
                        return Adaptica.WebForms.WebApp.WebFormsApp._openForms.Count;
                    }
                },
                CurrentForm: {
                    get: function () {
                        if (Adaptica.WebForms.WebApp.WebFormsApp._openForms.Count === 0) {
                            return null;
                        }

                        return Adaptica.WebForms.WebApp.WebFormsApp._openForms.Peek();
                    }
                },
                IsSplashVisible: {
                    get: function () {
                        var jq = $("#_splash_");
                        return (jq.length > 0) && (!jq.is(":hidden")) && (!jq.hasClass("wf-hide"));
                    }
                }
            },
            ctors: {
                init: function () {
                    this._historyStateCounter = 0;
                    this._queryString = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).ctor();
                    this._templateUsage = new (System.Collections.Generic.Dictionary$2(System.String,Adaptica.WebForms.WebApp.TemplateInfo)).ctor();
                    this._loginPrepared = false;
                    this._mailRegex = new RegExp("^(([^<>()\\[\\]\\\\.,;:\\s@\"]+(\\.[^<>()\\[\\]\\\\.,;:\\s@\"]+)*)|(\".+\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$");
                    this._pwdDialogPrepared = false;
                    this.MarkRegex = new RegExp("(\\$\\{(.*?)\\})", "g");
                    this.TextMarkRegex = new RegExp("(\\$\\{[Tt]ext\\.(.*?)\\})", "g");
                    this._openForms = new (System.Collections.Generic.Stack$1(Adaptica.WebForms.WebApp.Controls.FormControl)).ctor();
                    Bridge.ready(this.Main);
                }
            },
            methods: {
                Main: function () {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $task3, 
                        $task4, 
                        $task5, 
                        $taskResult5, 
                        $task6, 
                        $task7, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        unsup, 
                        msg, 
                        $taskResult1, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,12,13], $step);
                                    switch ($step) {
                                        case 0: {
                                            unsup = ((Bridge.Browser.isIE) || ((Bridge.Browser.chromeVersion > 0) && (Bridge.Browser.chromeVersion < 80)) || ((Bridge.Browser.firefoxVersion > 0) && (Bridge.Browser.firefoxVersion < 72)) || ((Bridge.Browser.safariVersion > 0) && (Bridge.Browser.safariVersion < 13.0)));

                                            if ((unsup) && (Bridge.Browser.isAndroid)) {
                                                if ((System.String.indexOf(window.navigator.userAgent, " EdgA/", 0, null, 3) > -1) && (Bridge.Browser.chromeVersion > 70)) {
                                                    unsup = false;
                                                }
                                            }

                                            if (unsup) {
                                                msg = "Tento webov\u00fd prohl\u00ed\u017ee\u010d ji\u017e nen\u00ed podporov\u00e1n, pros\u00edm st\u00e1hn\u011bte si novou verzi n\u011bkter\u00e9ho z modern\u00edch prohl\u00ed\u017ee\u010d\u016f.";
                                                if (Bridge.Browser.isIE) {
                                                    Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody().html(System.String.format("<div style=\"text-align: center; padding-top: 100px;\"><center><b>{0}</b><center></div>", [msg]));
                                                } else {
                                                    Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody().html(System.String.format("<div style=\"text-align: center; padding-top: 100px;\"><b>{0}</b><br>Pokud si mysl\u00edte, \u017ee do\u0161lo k chybn\u00e9 detekci a m\u00e1te modern\u00ed prohl\u00ed\u017ee\u010d, kontaktujte n\u00e1s pros\u00edm a uve\u010fte n\u00e1sleduj\u00edc\u00ed \u0159et\u011bzec:<br>{1}</div>", msg, window.navigator.userAgent));
                                                }

                                                $tcs.setResult(null);
                                                return;
                                            }

                                            Adaptica.WebForms.WebApp.WebFormsApp.CheckBroadcastInstance();

                                            Adaptica.WebForms.WebApp.WebFormsApp.InitQueryString();

                                            $task2 = Adaptica.WebForms.WebApp.WebFormsUtils.ResolveIncludes();
                                            $step = 1;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task2.getAwaitedResult();
                                            if (Adaptica.WebForms.WebApp.WebFormsApp.IsRunningInPortal) {
                                                $step = 2;
                                                continue;
                                            } else  {
                                                $step = 4;
                                                continue;
                                            }
                                        }
                                        case 2: {
                                            QIWebForms.init();

                                            $task3 = Adaptica.WebForms.WebApp.WebFormsApp.MainPortal();
                                            $step = 3;
                                            if ($task3.isCompleted()) {
                                                continue;
                                            }
                                            $task3.continue($asyncBody);
                                            return;
                                        }
                                        case 3: {
                                            $task3.getAwaitedResult();
                                            $step = 13;
                                            continue;
                                        }
                                        case 4: {
                                            $task4 = Adaptica.WebForms.WebApp.WebFormsApp.PrepareLoginDialog();
                                            $step = 5;
                                            if ($task4.isCompleted()) {
                                                continue;
                                            }
                                            $task4.continue($asyncBody);
                                            return;
                                        }
                                        case 5: {
                                            $task4.getAwaitedResult();
                                            if ((!System.String.isNullOrEmpty(Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("act")))) {
                                                $step = 6;
                                                continue;
                                            }
                                            $taskResult1 = false;
                                            $step = 8;
                                            continue;
                                        }
                                        case 6: {
                                            $task5 = Adaptica.WebForms.WebApp.WebFormsApp.CheckLogin();
                                            $step = 7;
                                            if ($task5.isCompleted()) {
                                                continue;
                                            }
                                            $task5.continue($asyncBody);
                                            return;
                                        }
                                        case 7: {
                                            $taskResult5 = $task5.getAwaitedResult();
                                            $taskResult1 = ($taskResult5);
                                            $step = 8;
                                            continue;
                                        }
                                        case 8: {
                                            if ($taskResult1) {
                                                $step = 9;
                                                continue;
                                            } 
                                            $step = 11;
                                            continue;
                                        }
                                        case 9: {
                                            $task6 = Adaptica.WebForms.WebApp.WebFormsApp.PreparePwdDialog(true);
                                            $step = 10;
                                            if ($task6.isCompleted()) {
                                                continue;
                                            }
                                            $task6.continue($asyncBody);
                                            return;
                                        }
                                        case 10: {
                                            $task6.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        case 11: {
                                            $task7 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("SessionState", Adaptica.WebForms.WebApp.WebFormsApp.Serialize(Adaptica.WebForms.WebApp.WebFormsApp.GetScreenDto()), "POST", function (dto) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        Adaptica.WebForms.WebApp.WebFormsApp.LoginType = dto.LoginType;

                                                                        Adaptica.WebForms.WebApp.Extensions.WFHide($(".wf-login"));
                                                                        Adaptica.WebForms.WebApp.Extensions.WFShow(Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody());

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetMainMenuOrForm();
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, function (statusCode, statusText, errorText) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if (statusCode === 401) {
                                                                            $step = 1;
                                                                            continue;
                                                                        } 
                                                                        $step = 3;
                                                                        continue;
                                                                    }
                                                                    case 1: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowLogin();
                                                                        $step = 2;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 2: {
                                                                        $task1.getAwaitedResult();
                                                                        $step = 3;
                                                                        continue;
                                                                    }
                                                                    case 3: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 12;
                                            if ($task7.isCompleted()) {
                                                continue;
                                            }
                                            $task7.continue($asyncBody);
                                            return;
                                        }
                                        case 12: {
                                            $task7.getAwaitedResult();
                                            $step = 13;
                                            continue;
                                        }
                                        case 13: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                WaitFor: function (checker, delay) {
                    if (delay === void 0) { delay = 50; }
                    if (!checker()) {
                        var task = new System.Threading.Tasks.Task(null);
                        var intr = 0;

                        intr = window.setInterval(function () {
                            if (checker()) {
                                window.clearInterval(intr);
                                task.complete();
                            }

                        }, delay);

                        return task;
                    }

                    return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                },
                GetLS: function (name) {
                    return Bridge.as(window.localStorage.getItem((Adaptica.WebForms.WebApp.WebFormsApp.AppPath || "") + (name || "")), System.String);
                },
                SetLS: function (name, value) {
                    window.localStorage.setItem((Adaptica.WebForms.WebApp.WebFormsApp.AppPath || "") + (name || ""), value);
                },
                RemoveLS: function (name) {
                    window.localStorage.removeItem((Adaptica.WebForms.WebApp.WebFormsApp.AppPath || "") + (name || ""));
                },
                CheckBroadcastInstance: function () {
                    var $t;
                    if (Adaptica.WebForms.WebApp.WebFormsApp._broadcast == null) {
                        try {
                            Adaptica.WebForms.WebApp.WebFormsApp._broadcast = ($t = new BroadcastChannel("webForms"), $t.onmessage = function (ev) {
                                var $step = 0,
                                    $task1, 
                                    $task2, 
                                    $jumpFromFinally, 
                                    $returnValue, 
                                    msg, 
                                    $async_e, 
                                    $asyncBody = Bridge.fn.bind(this, function () {
                                        try {
                                            for (;;) {
                                                $step = System.Array.min([0,1,2,3,4,5,7], $step);
                                                switch ($step) {
                                                    case 0: {
                                                        msg = Bridge.toString(ev.data);
                                                        if (!System.String.startsWith(msg, Adaptica.WebForms.WebApp.WebFormsApp.AppPath)) {
                                                            return;
                                                        }

                                                        Adaptica.WebForms.WebApp.WebFormsApp.Log("Broadcast message received: " + (msg || ""));

                                                        msg = msg.substr(Adaptica.WebForms.WebApp.WebFormsApp.AppPath.length);

                                                        if (System.String.equals(("Login"), msg)) {
                                                            $step = 1;
                                                            continue;
                                                        } else  {
                                                            $step = 3;
                                                            continue;
                                                        }
                                                    }
                                                    case 1: {
                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowMainMenuOrForm();
                                                        $step = 2;
                                                        if ($task1.isCompleted()) {
                                                            continue;
                                                        }
                                                        $task1.continue($asyncBody);
                                                        return;
                                                    }
                                                    case 2: {
                                                        $task1.getAwaitedResult();
                                                        $step = 7;
                                                        continue;
                                                    }
                                                    case 3: {
                                                        if (System.String.equals(("Logout"), msg)) {
                                                            $step = 4;
                                                            continue;
                                                        } 
                                                        $step = 6;
                                                        continue;
                                                    }
                                                    case 4: {
                                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.Logout(true);
                                                        $step = 5;
                                                        if ($task2.isCompleted()) {
                                                            continue;
                                                        }
                                                        $task2.continue($asyncBody);
                                                        return;
                                                    }
                                                    case 5: {
                                                        $task2.getAwaitedResult();
                                                        $step = 6;
                                                        continue;
                                                    }

                                                    case 7: {
                                                        return;
                                                    }
                                                    default: {
                                                        return;
                                                    }
                                                }
                                            }
                                        } catch($async_e1) {
                                            $async_e = System.Exception.create($async_e1);
                                            throw $async_e;
                                        }
                                    }, arguments);

                                $asyncBody();
                            }, $t);
                        } catch (e) {
                            e = System.Exception.create(e);
                            Adaptica.WebForms.WebApp.WebFormsApp.Log("Error creating Broadcast channel: " + (e.Message || ""));
                        }
                    }
                },
                SendBroadcast: function (s) {
                    Adaptica.WebForms.WebApp.WebFormsApp.Log("Sending broadcast: " + (s || ""));

                    Adaptica.WebForms.WebApp.WebFormsApp.CheckBroadcastInstance();
                    Adaptica.WebForms.WebApp.WebFormsApp._broadcast != null ? Adaptica.WebForms.WebApp.WebFormsApp._broadcast.postMessage((Adaptica.WebForms.WebApp.WebFormsApp.AppPath || "") + (s || "")) : null;
                },
                CloseBroadcast: function () {
                    if (Adaptica.WebForms.WebApp.WebFormsApp._broadcast != null) {
                        Adaptica.WebForms.WebApp.WebFormsApp._broadcast.close();
                        Adaptica.WebForms.WebApp.WebFormsApp._broadcast = null;
                    }
                },
                MainPortal: function () {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $task3, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3], $step);
                                    switch ($step) {
                                        case 0: {
                                            Adaptica.WebForms.WebApp.WebFormsApp.ShowSplash();

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.WaitFor(function () {
                                                return QIWebForms.allLibrariersLoaded;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("SessionState", Adaptica.WebForms.WebApp.WebFormsApp.Serialize(Adaptica.WebForms.WebApp.WebFormsApp.GetScreenDto()), "POST", function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    formIC, 
                                                    formU, 
                                                    masterIC, 
                                                    masterU, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        formIC = QIWebForms.formIC;
                                                                        formU = QIWebForms.formU;
                                                                        masterIC = QIWebForms.masterIC;
                                                                        masterU = QIWebForms.masterU;

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetMainMenuOrForm(formIC, formU, masterIC, masterU);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, function (statusCode, statusText, errorText) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.LoginPortal();
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 2;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task2.getAwaitedResult();
                                            $task3 = Adaptica.WebForms.WebApp.WebFormsApp.CheckTexts();
                                            $step = 3;
                                            if ($task3.isCompleted()) {
                                                continue;
                                            }
                                            $task3.continue($asyncBody);
                                            return;
                                        }
                                        case 3: {
                                            $task3.getAwaitedResult();
                                            Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetQueryString: function (name) {
                    var lName = name != null ? name.toLowerCase() : null;
                    if ((System.String.isNullOrEmpty(lName)) || (!Adaptica.WebForms.WebApp.WebFormsApp._queryString.containsKey(lName))) {
                        return null;
                    }

                    return Adaptica.WebForms.WebApp.WebFormsApp._queryString.getItem(lName);
                },
                GetScreenDto: function () {
                    var $t, $t1;
                    var viewportSize = Adaptica.WebForms.WebApp.WebFormsUtils.GetViewPortSize();

                    var dto = ($t = new Adaptica.WebForms.Common.DTO.DataDTO(), $t.Screen = ($t1 = new Adaptica.WebForms.Common.DTO.Screen(), $t1.AvailTop = window.screen.availTop, $t1.AvailLeft = window.screen.availLeft, $t1.AvailHeight = window.screen.availHeight, $t1.AvailWidth = window.screen.availWidth, $t1.ColorDepth = window.screen.colotDepth, $t1.Height = window.screen.height, $t1.Width = window.screen.width, $t1.PixelDepth = window.screen.pixelDepth, $t1.ViewportWidth = viewportSize.Item1, $t1.ViewportHeight = viewportSize.Item2, $t1), $t);

                    return dto;
                },
                InitQueryString: function () {
                    var $t;
                    if (Adaptica.WebForms.WebApp.WebFormsApp._queryString.Count === 0) {
                        var srch = window.location.search;
                        if ((srch != null) && (srch.length > 1)) {
                            var items = srch.substr(1).split("&");
                            $t = Bridge.getEnumerator(items);
                            try {
                                while ($t.moveNext()) {
                                    var item = $t.Current;
                                    var nv = item.split("=");
                                    if (nv.length > 1) {
                                        Adaptica.WebForms.WebApp.WebFormsApp._queryString.add(nv[System.Array.index(0, nv)].toLowerCase(), decodeURIComponent(nv[System.Array.index(1, nv)]));
                                    } else {
                                        Adaptica.WebForms.WebApp.WebFormsApp._queryString.add(nv[System.Array.index(0, nv)].toLowerCase(), "");
                                    }
                                }
                            } finally {
                                if (Bridge.is($t, System.IDisposable)) {
                                    $t.System$IDisposable$Dispose();
                                }
                            }
                        }
                    }
                },
                ClearQueryString: function () {
                    Adaptica.WebForms.WebApp.WebFormsApp._queryString.clear();
                },
                GetInitValues: function (formIC, formU, masterIC, masterU) {
                    Adaptica.WebForms.WebApp.WebFormsApp.InitQueryString();

                    var formID = Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("FormID");
                    if (!System.String.isNullOrEmpty(formID)) {
                        var splitted = formID.split(",");
                        formIC.v = splitted[System.Array.index(0, splitted)];
                        formU.v = (splitted.length === 1) ? null : splitted[System.Array.index(1, splitted)];
                    } else {
                        formIC.v = Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("FormIC");
                        formU.v = Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("FormU");
                    }

                    var masterID = Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("MasterID");
                    if (!System.String.isNullOrEmpty(masterID)) {
                        var splitted1 = masterID.split(",");
                        masterIC.v = splitted1[System.Array.index(0, splitted1)];
                        masterU.v = (splitted1.length === 1) ? null : splitted1[System.Array.index(1, splitted1)];
                    } else {
                        masterIC.v = Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("MasterIC");
                        masterU.v = Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("MasterU");
                    }
                },
                UseTemplate: function (name, apply) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        tInfo, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (apply === void 0) { apply = true; }
                                            if (System.String.isNullOrEmpty(name)) {
                                                $tcs.setResult(null);
                                                return;
                                            }
                                            tInfo = { };

                                            Adaptica.WebForms.WebApp.WebFormsApp._templateUsage.tryGetValue(name, tInfo);
                                            if (tInfo.v == null) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetTemplate", { Name: name }, "GET", function (dto) {
                                                var $t;
                                                if (!System.String.isNullOrEmpty(dto.TemplateHtml)) {
                                                    tInfo.v = ($t = new Adaptica.WebForms.WebApp.TemplateInfo(), $t.Html = dto.TemplateHtml, $t.Css = dto.TemplateCss, $t);

                                                    Adaptica.WebForms.WebApp.WebFormsApp._templateUsage.add(name, tInfo.v);
                                                }

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            }, function (errorCode, status, exception) {
                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            }, function (exceptionData) {

                                            });
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            if (tInfo.v != null) {
                                                if (apply) {
                                                    Adaptica.WebForms.WebApp.WebFormsUtils.AddTemplateStylesToDom(name, tInfo.v);
                                                }

                                                tInfo.v.UsageCount = (tInfo.v.UsageCount + 1) | 0;
                                            }

                                            $tcs.setResult(tInfo.v);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ReleaseTemplate: function (name) {
                    if (System.String.isNullOrEmpty(name)) {
                        return;
                    }
                    var tInfo = { };

                    if (Adaptica.WebForms.WebApp.WebFormsApp._templateUsage.tryGetValue(name, tInfo)) {
                        tInfo.v.UsageCount = (tInfo.v.UsageCount - 1) | 0;
                        if (tInfo.v.UsageCount === 0) {
                            Adaptica.WebForms.WebApp.WebFormsUtils.RemoveTemplateStylesFromDom(name);
                        }
                    }
                },
                GetMainMenuOrForm: function (formIC, formU, masterIC, masterU) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        frmID, 
                        masterID, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (formIC === void 0) { formIC = null; }
                                            if (formU === void 0) { formU = null; }
                                            if (masterIC === void 0) { masterIC = null; }
                                            if (masterU === void 0) { masterU = null; }
                                            formIC = {v:formIC};
                                            formU = {v:formU};
                                            masterIC = {v:masterIC};
                                            masterU = {v:masterU};
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("GetMainMenuOrForm({0}, {1}, {2}, {3})", formIC.v, formU.v, masterIC.v, masterU.v));

                                            if (formIC.v == null) {
                                                Adaptica.WebForms.WebApp.WebFormsApp.GetInitValues(formIC, formU, masterIC, masterU);
                                            }

                                            Adaptica.WebForms.WebApp.Extensions.WFShow(Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody());

                                            if ((System.String.isNullOrEmpty(formIC.v)) || (Bridge.referenceEquals(formIC.v, "0")) || Bridge.referenceEquals(formIC.v, "")) {
                                                $step = 1;
                                                continue;
                                            } else  {
                                                $step = 3;
                                                continue;
                                            }
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetMainMenu();
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $step = 5;
                                            continue;
                                        }
                                        case 3: {
                                            Adaptica.WebForms.WebApp.WebFormsApp.CreateMainPanel();

                                            frmID = (System.String.isNullOrEmpty(formU.v)) ? formIC.v : System.String.format("{0},{1}", formIC.v, formU.v);
                                            masterID = ((System.String.isNullOrEmpty(masterIC.v)) || (Bridge.referenceEquals(masterIC.v, "0")) || (Bridge.referenceEquals(masterIC.v, ""))) ? null : ((System.String.isNullOrEmpty(masterU.v)) ? masterIC.v : System.String.format("{0},{1}", masterIC.v, masterU.v));

                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$3("GetForm", { PFPFID: frmID, MasterID: masterID }, "GET", function (dto) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm$1(dto);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, function (errorCode, status, exception) {
                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            }, function (exceptionData) {

                                            }, true);
                                            $step = 4;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 4: {
                                            $task2.getAwaitedResult();
                                            $step = 5;
                                            continue;
                                        }
                                        case 5: {
                                            Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetForm: function (formId, masterId, parentForm) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (masterId === void 0) { masterId = null; }
                                            if (parentForm === void 0) { parentForm = null; }
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetForm", { PFPFID: formId, MasterID: masterId }, function (dto) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm$1(dto, parentForm);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ShowFilterForm: function (parentForm, filter, onSaved) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetForm", { PFPFID: filter.PFID, MasterID: filter.ID }, function (dto) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    control, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        control = new Adaptica.WebForms.WebApp.Controls.FilterSelectionFormControl(dto.FormData, parentForm, onSaved);
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DisplayFormControl(control);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetWFBody: function () {
                    var panel = $("#wf-body, .wf-body");
                    if (panel.length > 1) {
                        window.alert("Multiple WebForm bodies defined.");
                    }

                    return panel;
                },
                GetToolbarPanel: function (parent) {
                    if (parent === void 0) { parent = null; }
                    var panel = (parent != null) ? parent.find("#wf-toolbar, .wf-toolbar") : $("#wf-toolbar, .wf-toolbar");
                    if (panel.length > 1) {
                        window.alert("Multiple WebForm toolbars defined.");
                    }

                    if (Bridge.referenceEquals(panel.css("display"), "none")) {
                        return null;
                    }

                    return panel;
                },
                ShowToast: function (message) {
                    $(".wf-toast.toast .toast-body").html(message);
                    var toast = $(".wf-toast.toast");
                    toast.toast('show');
                },
                PrepareLoginDialog: function (show) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        loginForm, 
                        loginInput, 
                        pwdInput, 
                        submit, 
                        register, 
                        loginNia, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (show === void 0) { show = false; }
                                            if (Adaptica.WebForms.WebApp.WebFormsApp._loginPrepared) {
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            loginForm = null;
                                            loginInput = null;

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.WaitFor(function () {
                                                loginForm = $(".wf-login");
                                                loginInput = loginForm.find("#login");
                                                return ((loginForm.length > 0) && (loginInput.length > 0));
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            pwdInput = loginForm.find("#password");
                                            submit = loginForm.find("#submit");
                                            register = loginForm.find("#register");
                                            loginNia = loginForm.find("#submitNia");

                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.CheckTexts(function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $task2, 
                                                    $task3, 
                                                    $taskResult3, 
                                                    $task4, 
                                                    $taskResult4, 
                                                    $task5, 
                                                    $jumpFromFinally, 
                                                    eyeIcon, 
                                                    regEnabled, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3,4,5,6,7], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();

                                                                    $task1 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(loginInput, "UserName");
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    $task2 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(pwdInput, "Password");
                                                                    $step = 2;
                                                                    if ($task2.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task2.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 2: {
                                                                    $task2.getAwaitedResult();
                                                                    $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("LoginAction");
                                                                    $step = 3;
                                                                    if ($task3.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task3.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 3: {
                                                                    $taskResult3 = $task3.getAwaitedResult();
                                                                    submit.val($taskResult3);

                                                                    submit.on("click", function () {
                                                                        var $step = 0,
                                                                            $task1, 
                                                                            $jumpFromFinally, 
                                                                            $asyncBody = Bridge.fn.bind(this, function () {
                                                                                for (;;) {
                                                                                    $step = System.Array.min([0,1], $step);
                                                                                    switch ($step) {
                                                                                        case 0: {
                                                                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.Login();
                                                                                            $step = 1;
                                                                                            if ($task1.isCompleted()) {
                                                                                                continue;
                                                                                            }
                                                                                            $task1.continue($asyncBody);
                                                                                            return;
                                                                                        }
                                                                                        case 1: {
                                                                                            $task1.getAwaitedResult();
                                                                                            return;
                                                                                        }
                                                                                        default: {
                                                                                            return;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }, arguments);

                                                                        $asyncBody();
                                                                    });

                                                                    loginNia.on("click", function () {
                                                                        var $step = 0,
                                                                            $task1, 
                                                                            $jumpFromFinally, 
                                                                            $asyncBody = Bridge.fn.bind(this, function () {
                                                                                for (;;) {
                                                                                    $step = System.Array.min([0,1], $step);
                                                                                    switch ($step) {
                                                                                        case 0: {
                                                                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.LoginNia();
                                                                                            $step = 1;
                                                                                            if ($task1.isCompleted()) {
                                                                                                continue;
                                                                                            }
                                                                                            $task1.continue($asyncBody);
                                                                                            return;
                                                                                        }
                                                                                        case 1: {
                                                                                            $task1.getAwaitedResult();
                                                                                            return;
                                                                                        }
                                                                                        default: {
                                                                                            return;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }, arguments);

                                                                        $asyncBody();
                                                                    });

                                                                    loginInput.keypress(function (keyboard) {
                                                                        if (keyboard.keyCode === 13) {
                                                                            pwdInput.focus();
                                                                        }
                                                                    });

                                                                    pwdInput.keypress(function (keyboard) {
                                                                        if (keyboard.keyCode === 13) {
                                                                            submit.click();
                                                                        }
                                                                    });

                                                                    eyeIcon = loginForm.find(".wf-togglePassword");
                                                                    eyeIcon.click(function (evnt) {
                                                                        var type = Bridge.referenceEquals(pwdInput.attr("type"), "password") ? "text" : "password";
                                                                        pwdInput.attr("type", type);
                                                                        pwdInput.focus();
                                                                        eyeIcon.toggleClass("fa-eye fa-eye-slash");
                                                                        evnt.stopPropagation();
                                                                        evnt.preventDefault();
                                                                    });

                                                                    $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemRegEnabled");
                                                                    $step = 4;
                                                                    if ($task4.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task4.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 4: {
                                                                    $taskResult4 = $task4.getAwaitedResult();
                                                                    regEnabled = $taskResult4;

                                                                    if (System.String.equals(("true"), regEnabled)) {
                                                                        register != null ? register.on("click", function () {
                                                                            var $step = 0,
                                                                                $task1, 
                                                                                $jumpFromFinally, 
                                                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                                                    for (;;) {
                                                                                        $step = System.Array.min([0,1], $step);
                                                                                        switch ($step) {
                                                                                            case 0: {
                                                                                                $task1 = Adaptica.WebForms.WebApp.WebFormsApp.PrepareRegisterDialog(true);
                                                                                                $step = 1;
                                                                                                if ($task1.isCompleted()) {
                                                                                                    continue;
                                                                                                }
                                                                                                $task1.continue($asyncBody);
                                                                                                return;
                                                                                            }
                                                                                            case 1: {
                                                                                                $task1.getAwaitedResult();
                                                                                                return;
                                                                                            }
                                                                                            default: {
                                                                                                return;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }, arguments);

                                                                            $asyncBody();
                                                                        }) : null;
                                                                    } else {
                                                                        register != null ? register.remove() : null;
                                                                    }

                                                                    Adaptica.WebForms.WebApp.WebFormsApp._loginPrepared = true;

                                                                    if (show) {
                                                                        $step = 5;
                                                                        continue;
                                                                    } 
                                                                    $step = 7;
                                                                    continue;
                                                                }
                                                                case 5: {
                                                                    $task5 = Adaptica.WebForms.WebApp.WebFormsApp.ShowLogin(loginInput, loginForm);
                                                                    $step = 6;
                                                                    if ($task5.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task5.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 6: {
                                                                    $task5.getAwaitedResult();
                                                                    $step = 7;
                                                                    continue;
                                                                }
                                                                case 7: {
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });
                                            $step = 2;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task2.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ShowLogin: function (loginInput, loginForm) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (loginInput === void 0) { loginInput = null; }
                                            if (loginForm === void 0) { loginForm = null; }
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("ShowLogin");

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.WaitFor(function () {
                                                return Adaptica.WebForms.WebApp.WebFormsApp._loginPrepared;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            if (loginForm == null) {
                                                loginForm = $(".wf-login");
                                                loginInput = loginForm.find("#login");
                                            }

                                            loginForm != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(loginForm) : null;
                                            loginInput != null ? loginInput.focus() : null;
                                            Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                Login: function (login, pwd) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        loginForm, 
                        loginInput, 
                        pwdInput, 
                        data, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (login === void 0) { login = null; }
                                            if (pwd === void 0) { pwd = null; }
                                            Adaptica.WebForms.WebApp.WebFormsApp.ShowSplash();

                                            Adaptica.WebForms.WebApp.Extensions.WFHide($(".wf-login #loginFailed"));

                                            loginForm = $(".wf-login");
                                            loginInput = $(".wf-login #login");
                                            pwdInput = $(".wf-login #password");

                                            if (System.String.isNullOrEmpty(login)) {
                                                login = loginInput.val();
                                                pwd = pwdInput.val();
                                            }

                                            data = JSON.stringify(System.Array.init([login, pwd], System.String));

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$3("Login", data, "POST", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems = (dataDTO != null ? dataDTO.FavouriteItems : null) || new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DTO.FavouriteItem)).ctor();

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowMainMenuOrForm();
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        Adaptica.WebForms.WebApp.WebFormsApp.SendBroadcast("Login");
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, function (statusCode, statusText, errorText) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $task2, 
                                                    $taskResult2, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    failed, 
                                                    errText, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3,4,5,6,7], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();

                                                                        Adaptica.WebForms.WebApp.Extensions.WFShow(loginForm);
                                                                        if (statusCode === 401) {
                                                                            $step = 1;
                                                                            continue;
                                                                        } 
                                                                        $step = 7;
                                                                        continue;
                                                                    }
                                                                    case 1: {
                                                                        failed = $(".wf-login #loginFailed");

                                                                        errText = Adaptica.WebForms.WebApp.WebFormsApp.GetErrorText(errorText);
                                                                        if (System.String.indexOf(errorText, "Login expired", 0, null, 3) > -1) {
                                                                            $step = 2;
                                                                            continue;
                                                                        } else  {
                                                                            $step = 4;
                                                                            continue;
                                                                        }
                                                                    }
                                                                    case 2: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("LoginExpired");
                                                                        $step = 3;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 3: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        failed.html($taskResult1);
                                                                        $step = 6;
                                                                        continue;
                                                                    }
                                                                    case 4: {
                                                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("LoginFailedPassword");
                                                                        $step = 5;
                                                                        if ($task2.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task2.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 5: {
                                                                        $taskResult2 = $task2.getAwaitedResult();
                                                                        failed.html($taskResult2);
                                                                        failed.attr("title", errText);
                                                                        $step = 6;
                                                                        continue;
                                                                    }
                                                                    case 6: {
                                                                        Adaptica.WebForms.WebApp.Extensions.WFShow(failed);
                                                                        loginInput.focus();
                                                                        $step = 7;
                                                                        continue;
                                                                    }
                                                                    case 7: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, function (exceptionData) { }, true);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ShowMainMenuOrForm: function () {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            Adaptica.WebForms.WebApp.Extensions.WFHide($(".wf-login"));
                                            $(".wf-login #login").val("");
                                            $(".wf-login #password").val("");
                                            Adaptica.WebForms.WebApp.Extensions.WFShow(Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody());

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetMainMenuOrForm();
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                LoginPortal: function () {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("LoginPortal", null, "GET", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems = (dataDTO != null ? dataDTO.FavouriteItems : null) || new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DTO.FavouriteItem)).ctor();

                                                                        Adaptica.WebForms.WebApp.Extensions.WFShow(Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody());

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetMainMenu();
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, function (statusCode, statusText, errorText) {
                                                if (statusCode === 401) {
                                                }

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                LoginNia: function () {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        url, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            url = "";

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("LoginNia", null, "GET", function (dataDTO) {
                                                url = Bridge.as((dataDTO != null ? dataDTO.Data : null), System.String);
                                                window.setTimeout(function () {
                                                    window.location.assign(url);
                                                }, 10);

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            }, function (statusCode, statusText, errorText) {

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            /* 
                                                       if (!string.IsNullOrEmpty(url))
                                                       {
                                                           Window.Location.Assign("Redirect.aspx?Url=" + Window.EncodeURIComponent(url));
                                                       }
                                            */
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                PrepareRegisterDialog: function (show) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $task2, 
                        $taskResult2, 
                        $task3, 
                        $taskResult3, 
                        $task4, 
                        $task5, 
                        $task6, 
                        $task7, 
                        $task8, 
                        $task9, 
                        $task10, 
                        $taskResult10, 
                        $task11, 
                        $taskResult11, 
                        $task12, 
                        $taskResult12, 
                        $task13, 
                        $taskResult13, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        loginForm, 
                        regForm, 
                        labels, 
                        i, 
                        lbl, 
                        jq, 
                        id, 
                        txt, 
                        lblFor, 
                        input, 
                        surname, 
                        email, 
                        regApproval, 
                        approval, 
                        chb, 
                        lbl1, 
                        submit, 
                        back, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6,7,8,11,12,13,14,15,16,17,18,19,20,21,22,23,25,26,27,28], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (show === void 0) { show = false; }
                                            loginForm = $(".wf-login");
                                            regForm = $(".wf-register");

                                            if (!Adaptica.WebForms.WebApp.WebFormsApp._regPrepared) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 28;
                                            continue;
                                        }
                                        case 1: {
                                            labels = regForm.find("label");
                                            i = 0;
                                            $step = 2;
                                            continue;
                                        }
                                        case 2: {
                                            if ( i < labels.length ) {
                                                $step = 3;
                                                continue;
                                            }
                                            $step = 12;
                                            continue;
                                        }
                                        case 3: {
                                            lbl = labels.get(i);
                                            jq = $(lbl);
                                            id = lbl.id;
                                            if (System.String.startsWith(id, "reg")) {
                                                id = id.substr(3);
                                            }
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync(id);
                                            $step = 4;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 4: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            txt = $taskResult1;
                                            if (!System.String.isNullOrEmpty(txt)) {
                                                jq.text(txt);
                                            }

                                            lblFor = jq.prop("for");
                                            if (!System.String.isNullOrEmpty(lblFor)) {
                                                $step = 5;
                                                continue;
                                            } 
                                            $step = 10;
                                            continue;
                                        }
                                        case 5: {
                                            input = regForm.find("#" + (lblFor || ""));
                                            if ((input.length > 0) && (input.prop("required"))) {
                                                $("<span>").addClass("wf-required").text("*").appendTo(jq);
                                            }

                                            if (System.String.equals(("regSex"), lblFor)) {
                                                $step = 6;
                                                continue;
                                            } 
                                            $step = 9;
                                            continue;
                                        }
                                        case 6: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SexM");
                                            $step = 7;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 7: {
                                            $taskResult2 = $task2.getAwaitedResult();
                                            input.find("option[value='0']").text($taskResult2);
                                            $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SexF");
                                            $step = 8;
                                            if ($task3.isCompleted()) {
                                                continue;
                                            }
                                            $task3.continue($asyncBody);
                                            return;
                                        }
                                        case 8: {
                                            $taskResult3 = $task3.getAwaitedResult();
                                            input.find("option[value='1']").text($taskResult3);
                                            $step = 9;
                                            continue;
                                        }


                                        case 11: {
                                            i = (i + 1) | 0;
                                            $step = 2;
                                            continue;
                                        }
                                        case 12: {
                                            $task4 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(regForm.find("#regFirstName"));
                                            $step = 13;
                                            if ($task4.isCompleted()) {
                                                continue;
                                            }
                                            $task4.continue($asyncBody);
                                            return;
                                        }
                                        case 13: {
                                            $task4.getAwaitedResult();
                                            surname = regForm.find("#regSurname");
                                            $task5 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(surname);
                                            $step = 14;
                                            if ($task5.isCompleted()) {
                                                continue;
                                            }
                                            $task5.continue($asyncBody);
                                            return;
                                        }
                                        case 14: {
                                            $task5.getAwaitedResult();
                                            surname.focusout(function () {
                                                var val = surname.val();
                                                if ((!System.String.isNullOrEmpty(val)) && (System.String.endsWith(val, "ov\u00e1", 3))) {
                                                    regForm.find("#regSex").val("1");
                                                }
                                            });

                                            email = regForm.find("#regEmail");
                                            $task6 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(email);
                                            $step = 15;
                                            if ($task6.isCompleted()) {
                                                continue;
                                            }
                                            $task6.continue($asyncBody);
                                            return;
                                        }
                                        case 15: {
                                            $task6.getAwaitedResult();
                                            email.focusout(function () {
                                                var val = email.val();
                                                if (!System.String.isNullOrEmpty(val)) {
                                                    if (!Adaptica.WebForms.WebApp.WebFormsApp._mailRegex.test(val)) {
                                                        var placeHolder = email.attr("placeholder");
                                                        if (System.String.isNullOrEmpty(placeHolder)) {
                                                            placeHolder = "mail@domena.cz";
                                                        }

                                                        email.addClass("wf-is-invalid");
                                                        email.attr("title", placeHolder);
                                                        email[0].setCustomValidity(placeHolder);
                                                        email[0].reportValidity();
                                                        email.focus();
                                                    } else {
                                                        email.removeAttr("title");
                                                        email.removeClass("wf-is-invalid");
                                                        email[0].setCustomValidity('');
                                                    }
                                                }
                                            });

                                            $task7 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(regForm.find("#regMobile"));
                                            $step = 16;
                                            if ($task7.isCompleted()) {
                                                continue;
                                            }
                                            $task7.continue($asyncBody);
                                            return;
                                        }
                                        case 16: {
                                            $task7.getAwaitedResult();
                                            $task8 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(regForm.find("#regPartnerName"));
                                            $step = 17;
                                            if ($task8.isCompleted()) {
                                                continue;
                                            }
                                            $task8.continue($asyncBody);
                                            return;
                                        }
                                        case 17: {
                                            $task8.getAwaitedResult();
                                            $task9 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(regForm.find("#regContractNumber"));
                                            $step = 18;
                                            if ($task9.isCompleted()) {
                                                continue;
                                            }
                                            $task9.continue($asyncBody);
                                            return;
                                        }
                                        case 18: {
                                            $task9.getAwaitedResult();
                                            $task10 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemRegApproval");
                                            $step = 19;
                                            if ($task10.isCompleted()) {
                                                continue;
                                            }
                                            $task10.continue($asyncBody);
                                            return;
                                        }
                                        case 19: {
                                            $taskResult10 = $task10.getAwaitedResult();
                                            regApproval = $taskResult10;
                                            Adaptica.WebForms.WebApp.WebFormsApp._regApproval = (System.String.equals(("true"), regApproval, 3)) || (System.String.equals(("1"), regApproval));
                                            if (Adaptica.WebForms.WebApp.WebFormsApp._regApproval) {
                                                $step = 20;
                                                continue;
                                            } 
                                            $step = 25;
                                            continue;
                                        }
                                        case 20: {
                                            approval = regForm.find("#regApproval");
                                            if (approval.length === 0) {
                                                $step = 21;
                                                continue;
                                            } else  {
                                                $step = 22;
                                                continue;
                                            }
                                        }
                                        case 21: {
                                            regForm.add($("<div style=\"color: red; font-size: 2em\">Element with id=\"approval\" is missing!</div>"));
                                            $step = 24;
                                            continue;
                                        }
                                        case 22: {
                                            chb = regForm.find("#regApprovalChb");
                                            chb.prop("required", true);

                                            $task11 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("RegistrationApprovalLabel");
                                            $step = 23;
                                            if ($task11.isCompleted()) {
                                                continue;
                                            }
                                            $task11.continue($asyncBody);
                                            return;
                                        }
                                        case 23: {
                                            $taskResult11 = $task11.getAwaitedResult();
                                            lbl1 = regForm.find("#regApprovalLabel").text($taskResult11);
                                            lbl1.on("click", function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $task2, 
                                                    $taskResult2, 
                                                    $task3, 
                                                    $taskResult3, 
                                                    $task4, 
                                                    $jumpFromFinally, 
                                                    text, 
                                                    btn1, 
                                                    $t, 
                                                    btn2, 
                                                    dParams, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3,4], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    text = "";
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetRegApprovalText", null, function (dto) {
                                                                        text = Bridge.as(dto.Data, System.String);

                                                                        return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                                                    });
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                                                    $step = 2;
                                                                    if ($task2.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task2.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 2: {
                                                                    $taskResult2 = $task2.getAwaitedResult();
                                                                    btn1 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult2, $t.Primary = true, $t.Handler = function () {
                                                                        chb.prop("checked", "checked");
                                                                    }, $t);

                                                                    $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("CancelButton");
                                                                    $step = 3;
                                                                    if ($task3.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task3.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 3: {
                                                                    $taskResult3 = $task3.getAwaitedResult();
                                                                    btn2 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult3, $t.Handler = function () {
                                                                        chb.prop("checked", "");
                                                                    }, $t);

                                                                    dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.Title = "*none*", $t.Message = text, $t.Buttons = System.Array.init([btn1, btn2], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef), $t.OnDialogClosed = function () {
                                                                        $(".modal-dialog").removeClass("wf-regApprovalDialog");
                                                                    }, $t);

                                                                    $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                                                    $step = 4;
                                                                    if ($task4.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task4.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 4: {
                                                                    $task4.getAwaitedResult();
                                                                    $(".modal-dialog").addClass("wf-regApprovalDialog");
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });

                                            Adaptica.WebForms.WebApp.Extensions.WFShow(approval);
                                            $step = 24;
                                            continue;
                                        }

                                        case 25: {
                                            submit = regForm.find("#regSubmit");
                                            $task12 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("RegisterButton");
                                            $step = 26;
                                            if ($task12.isCompleted()) {
                                                continue;
                                            }
                                            $task12.continue($asyncBody);
                                            return;
                                        }
                                        case 26: {
                                            $taskResult12 = $task12.getAwaitedResult();
                                            submit.val($taskResult12);
                                            submit.on("click", function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.Register();
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });

                                            back = regForm.find("#regBack");
                                            $task13 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BackButton");
                                            $step = 27;
                                            if ($task13.isCompleted()) {
                                                continue;
                                            }
                                            $task13.continue($asyncBody);
                                            return;
                                        }
                                        case 27: {
                                            $taskResult13 = $task13.getAwaitedResult();
                                            back.val($taskResult13);
                                            back.on("click", function () {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(regForm);
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(loginForm);
                                                loginForm.find("input:not(:disabled)").first().focus();
                                            });

                                            Adaptica.WebForms.WebApp.WebFormsApp._regPrepared = true;
                                            $step = 28;
                                            continue;
                                        }
                                        case 28: {
                                            if (show) {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(loginForm);
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(regForm);

                                                regForm.find("select,input:not([type='submit'],[type='button'])").first().focus();
                                            }
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                Register: function () {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        regForm, 
                        inputs, 
                        items, 
                        allValid, 
                        firstInvalid, 
                        jq, 
                        name, 
                        val, 
                        isValid, 
                        chb, 
                        pars, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            regForm = $(".wf-register");
                                            inputs = regForm.find("select,input:not([type='submit'],[type='button'])");
                                            items = System.Array.init(inputs.length, null, System.String);
                                            allValid = true;
                                            firstInvalid = null;
                                            for (var i = 0; i < inputs.length; i = (i + 1) | 0) {
                                                jq = $(inputs.get(i));
                                                name = jq.prop("name");
                                                val = jq.val();
                                                items[System.Array.index(i, items)] = System.String.format("{0}={1}", name, val);
                                                isValid = true;
                                                if (jq.prop("required")) {
                                                    isValid = (!System.String.isNullOrEmpty(val));
                                                }

                                                if ((isValid) && (System.String.equals(("regEmail"), name))) {
                                                    isValid = Adaptica.WebForms.WebApp.WebFormsApp._mailRegex.test(val);
                                                }

                                                if (isValid) {
                                                } else {
                                                    if (firstInvalid == null) {
                                                        firstInvalid = jq;
                                                    }

                                                    allValid = false;
                                                }
                                            }

                                            if ((allValid) && (Adaptica.WebForms.WebApp.WebFormsApp._regApproval)) {
                                                chb = regForm.find("#regApprovalChb");
                                                if (!chb.prop("checked")) {
                                                    allValid = false;
                                                    firstInvalid = chb;
                                                }
                                            }

                                            if (!allValid) {
                                                firstInvalid.focus();
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            pars = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.GetDataParams(), $t.DataType = "Register", $t.Method = "POST", $t.DataToSend = JSON.stringify(items), $t.OKHandler = function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $task2, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    ButtonHandler, 
                                                    ex, 
                                                    fid, 
                                                    msg, 
                                                    btn, 
                                                    $t1, 
                                                    dParams, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3,4,5], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if (Adaptica.WebForms.WebApp.WebFormsApp.IsException(dataDTO)) {
                                                                            $step = 1;
                                                                            continue;
                                                                        } else  {
                                                                            $step = 3;
                                                                            continue;
                                                                        }
                                                                    }
                                                                    case 1: {
                                                                        ButtonHandler = null;
                                                                        ex = dataDTO.Data;
                                                                        fid = ex.FieldId;

                                                                        ButtonHandler = function () {
                                                                            if (!System.String.isNullOrEmpty(fid)) {
                                                                                regForm.find(System.String.format("#{0}", [fid])).focus();
                                                                            }
                                                                        };

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2(null, ex.Message, null, ButtonHandler);
                                                                        $step = 2;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 2: {
                                                                        $task1.getAwaitedResult();
                                                                        $step = 5;
                                                                        continue;
                                                                    }
                                                                    case 3: {
                                                                        msg = Bridge.as(dataDTO.Data, System.String);

                                                                        btn = ($t1 = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t1.Caption = null, $t1.Primary = true, $t1);

                                                                        dParams = ($t1 = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t1.Message = msg, $t1.Buttons = System.Array.init([btn], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef), $t1.OnDialogClosed = (btn.Handler = function () {
                                                                            Adaptica.WebForms.WebApp.Extensions.WFHide(regForm);

                                                                            var loginForm = $(".wf-login");
                                                                            Adaptica.WebForms.WebApp.Extensions.WFShow(loginForm);
                                                                            loginForm.find("input:not(:disabled)").first().focus();
                                                                        }), $t1);

                                                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                                                        $step = 4;
                                                                        if ($task2.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task2.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 4: {
                                                                        $task2.getAwaitedResult();
                                                                        $step = 5;
                                                                        continue;
                                                                    }
                                                                    case 5: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, $t.CheckForServerException = false, $t);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync(pars);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                Logout: function (fromOutside) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (fromOutside === void 0) { fromOutside = false; }
                                            if (!fromOutside) {
                                                $step = 1;
                                                continue;
                                            } else  {
                                                $step = 3;
                                                continue;
                                            }
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.QueryLogout();
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $step = 5;
                                            continue;
                                        }
                                        case 3: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.DoLogout(fromOutside);
                                            $step = 4;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 4: {
                                            $task2.getAwaitedResult();
                                            $step = 5;
                                            continue;
                                        }
                                        case 5: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                DoLogout: function (fromOutside) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        redirectUrl, 
                        content, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (fromOutside === void 0) { fromOutside = false; }
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("Logout(" + (System.Boolean.toString(fromOutside) || "") + ")");

                                            Adaptica.WebForms.WebApp.WebFormsApp._openForms.Clear();

                                            redirectUrl = null;
                                            if (!fromOutside) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("Logout", null, function (dto) {
                                                redirectUrl = Bridge.as((dto != null ? dto.Data : null), System.String);
                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            });
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            Adaptica.WebForms.WebApp.WebFormsApp.SSID = "";
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            content = Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody();
                                            Adaptica.WebForms.WebApp.WebFormsUtils.HideElement(content);
                                            content.empty();
                                            Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();

                                            if (System.String.isNullOrEmpty(redirectUrl)) {
                                                $step = 4;
                                                continue;
                                            } 
                                            $step = 6;
                                            continue;
                                        }
                                        case 4: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ShowLogin();
                                            $step = 5;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 5: {
                                            $task2.getAwaitedResult();
                                            $step = 6;
                                            continue;
                                        }
                                        case 6: {
                                            if (!fromOutside) {
                                                Adaptica.WebForms.WebApp.WebFormsApp.SendBroadcast("Logout");
                                            }

                                            if (!System.String.isNullOrEmpty(redirectUrl)) {
                                                window.location.replace(redirectUrl);
                                            }
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                QueryLogout: function () {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $task2, 
                        $taskResult2, 
                        $task3, 
                        $taskResult3, 
                        $task4, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        btn1, 
                        $t, 
                        btn2, 
                        dParams, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4], $step);
                                    switch ($step) {
                                        case 0: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            btn1 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult1, $t.Primary = true, $t.Handler = function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DoLogout();
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            }, $t);

                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("CancelButton");
                                            $step = 2;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $taskResult2 = $task2.getAwaitedResult();
                                            btn2 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult2, $t.Handler = function () { }, $t);

                                            $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("LoggoutingText");
                                            $step = 3;
                                            if ($task3.isCompleted()) {
                                                continue;
                                            }
                                            $task3.continue($asyncBody);
                                            return;
                                        }
                                        case 3: {
                                            $taskResult3 = $task3.getAwaitedResult();
                                            dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.Title = $taskResult3, $t.Message = "Opravdu se chcete odhl\u00e1sit?", $t.Buttons = System.Array.init([btn1, btn2], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef), $t.OnDialogClosed = function () {
                                                $(".modal-dialog").removeClass("wf-logoutDialog");
                                            }, $t);

                                            $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                            $step = 4;
                                            if ($task4.isCompleted()) {
                                                continue;
                                            }
                                            $task4.continue($asyncBody);
                                            return;
                                        }
                                        case 4: {
                                            $task4.getAwaitedResult();
                                            $(".modal-dialog").addClass("wf-logoutDialog");
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                CheckLogin: function () {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        data, 
                        result, 
                        hasResult, 
                        pars, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2], $step);
                                    switch ($step) {
                                        case 0: {
                                            data = JSON.stringify(System.Array.init([Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("act")], System.String));

                                            result = false;
                                            hasResult = false;


                                            pars = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.GetDataParams(), $t.DataType = "CheckLogin", $t.Method = "POST", $t.DataToSend = data, $t.OKHandler = function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    ex, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3,5], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        result = !Adaptica.WebForms.WebApp.WebFormsApp.IsException(dataDTO);
                                                                        hasResult = true;

                                                                        if (!result) {
                                                                            $step = 1;
                                                                            continue;
                                                                        } 
                                                                        $step = 5;
                                                                        continue;
                                                                    }
                                                                    case 1: {
                                                                        ex = dataDTO.Data;
                                                                        if (!Bridge.referenceEquals(ex.Message, "PwdSet")) {
                                                                            $step = 2;
                                                                            continue;
                                                                        } 
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                    case 2: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2(null, ex.Message);
                                                                        $step = 3;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 3: {
                                                                        $task1.getAwaitedResult();
                                                                        $step = 4;
                                                                        continue;
                                                                    }

                                                                    case 5: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, $t.CheckForServerException = false, $t);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync(pars);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.WaitFor(function () {
                                                return hasResult;
                                            });
                                            $step = 2;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task2.getAwaitedResult();
                                            $tcs.setResult(result);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                PreparePwdDialog: function (show) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $task3, 
                        $taskResult3, 
                        $task4, 
                        $taskResult4, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        form, 
                        pwdInput, 
                        eyeIcon, 
                        hint, 
                        submit, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (show === void 0) { show = false; }
                                            form = null;
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.WaitFor(function () {
                                                form = $(".wf-chPwd");
                                                return form.length > 0;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            if (!Adaptica.WebForms.WebApp.WebFormsApp._pwdDialogPrepared) {
                                                $step = 2;
                                                continue;
                                            } 
                                            $step = 6;
                                            continue;
                                        }
                                        case 2: {
                                            pwdInput = form.find("#chPwdPassword1");
                                            $task2 = Adaptica.WebForms.WebApp.Extensions.SetCustomPlaceholder(pwdInput, "Password");
                                            $step = 3;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 3: {
                                            $task2.getAwaitedResult();
                                            eyeIcon = form.find(".wf-togglePassword");
                                            eyeIcon.click(function (evnt) {
                                                var type = Bridge.referenceEquals(pwdInput.attr("type"), "password") ? "text" : "password";
                                                pwdInput.attr("type", type);
                                                pwdInput.focus();
                                                eyeIcon.toggleClass("fa-eye fa-eye-slash");
                                                evnt.stopPropagation();
                                                evnt.preventDefault();
                                            });


                                            $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemPasswordHelp");
                                            $step = 4;
                                            if ($task3.isCompleted()) {
                                                continue;
                                            }
                                            $task3.continue($asyncBody);
                                            return;
                                        }
                                        case 4: {
                                            $taskResult3 = $task3.getAwaitedResult();
                                            hint = $taskResult3;
                                            if (!System.String.isNullOrEmpty(hint)) {
                                                pwdInput.attr("title", hint).attr("data-html", "true");
                                                if (System.String.isNullOrEmpty(pwdInput.attr("data-placement"))) {
                                                    pwdInput.attr("data-placement", "auto");
                                                }
                                                pwdInput.tooltip({ trigger: "hover" });
                                            }

                                            submit = form.find("#chPwdSubmit");
                                            $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("ChangePasswordButton");
                                            $step = 5;
                                            if ($task4.isCompleted()) {
                                                continue;
                                            }
                                            $task4.continue($asyncBody);
                                            return;
                                        }
                                        case 5: {
                                            $taskResult4 = $task4.getAwaitedResult();
                                            submit.val(($t = $taskResult4, $t != null ? $t : "Nastavit heslo"));
                                            submit.on("click", function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ChangePassword();
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });

                                            Adaptica.WebForms.WebApp.WebFormsApp._pwdDialogPrepared = true;
                                            $step = 6;
                                            continue;
                                        }
                                        case 6: {
                                            if (show) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(form);
                                                form.find("#chPwdPassword1").focus();
                                            }
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ChangePassword: function () {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        form, 
                        pwd1, 
                        val1, 
                        pwd2, 
                        val2, 
                        msg, 
                        $t, 
                        data, 
                        pars, 
                        $t1, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4], $step);
                                    switch ($step) {
                                        case 0: {
                                            form = $(".wf-chPwd");
                                            pwd1 = form.find("#chPwdPassword1");
                                            val1 = pwd1.val();
                                            if (System.String.isNullOrEmpty(val1)) {
                                                pwd1.focus();
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            pwd2 = form.find("#chPwdPassword2");
                                            val2 = pwd2.val();
                                            if (System.String.isNullOrEmpty(val2)) {
                                                pwd2.focus();
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            msg = form.find("#chPwdMessage");
                                            if (!Bridge.referenceEquals(val1, val2)) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NonMatchingPasswords");
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            msg.text(($t = $taskResult1, $t != null ? $t : "Hesla nejsou shodn\u00e1"));
                                            Adaptica.WebForms.WebApp.Extensions.WFShow(msg);
                                            pwd2.focus();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        case 3: {
                                            msg.text("");
                                            Adaptica.WebForms.WebApp.Extensions.WFHide(msg);

                                            data = JSON.stringify(System.Array.init([Adaptica.WebForms.WebApp.WebFormsApp.GetQueryString("act"), val1], System.String));

                                            pars = ($t1 = new Adaptica.WebForms.WebApp.WebFormsApp.GetDataParams(), $t1.DataType = "SetFirstPwd", $t1.Method = "POST", $t1.DataToSend = data, $t1.OKHandler = function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    ButtonHandler, 
                                                    ex, 
                                                    fid, 
                                                    qs, 
                                                    cnt, 
                                                    $t2, 
                                                    kvp, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3,4], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if (Adaptica.WebForms.WebApp.WebFormsApp.IsException(dataDTO)) {
                                                                            $step = 1;
                                                                            continue;
                                                                        } else  {
                                                                            $step = 3;
                                                                            continue;
                                                                        }
                                                                    }
                                                                    case 1: {
                                                                        ButtonHandler = null;
                                                                        ex = dataDTO.Data;
                                                                        fid = ex.FieldId;

                                                                        ButtonHandler = function () {
                                                                            var itemToFocus = pwd1;
                                                                            if (!System.String.isNullOrEmpty(fid)) {
                                                                                var input = form.find(System.String.format("#{0}", [fid]));
                                                                                if (input.length === 1) {
                                                                                    itemToFocus = input;
                                                                                }
                                                                            }

                                                                            itemToFocus.focus();
                                                                        };

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2(null, Adaptica.WebForms.WebApp.WebFormsApp.GetErrorText(ex.Message), null, ButtonHandler);
                                                                        $step = 2;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 2: {
                                                                        $task1.getAwaitedResult();
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                    case 3: {
                                                                        Adaptica.WebForms.WebApp.Extensions.WFHide(form);

                                                                        if (Adaptica.WebForms.WebApp.WebFormsApp._queryString.Count > 0) {
                                                                            qs = System.Array.init(((Adaptica.WebForms.WebApp.WebFormsApp._queryString.Count - 1) | 0), null, System.String);
                                                                            cnt = 0;
                                                                            $t2 = Bridge.getEnumerator(Adaptica.WebForms.WebApp.WebFormsApp._queryString);
                                                                            try {
                                                                                while ($t2.moveNext()) {
                                                                                    kvp = $t2.Current;
                                                                                    if (System.String.equals(("act"), kvp.key)) {
                                                                                        continue;
                                                                                    }

                                                                                    qs[System.Array.index(cnt, qs)] = System.String.format("{0}={1}", kvp.key, kvp.value);
                                                                                    cnt = (cnt + 1) | 0;
                                                                                }
                                                                            } finally {
                                                                                if (Bridge.is($t2, System.IDisposable)) {
                                                                                    $t2.System$IDisposable$Dispose();
                                                                                }
                                                                            }

                                                                            window.location.search = (qs).join("&");
                                                                        }
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                    case 4: {
                                                                        ;
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            }, $t1.CheckForServerException = false, $t1);

                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync(pars);
                                            $step = 4;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 4: {
                                            $task2.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetMainMenu: function () {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2], $step);
                                    switch ($step) {
                                        case 0: {
                                            Adaptica.WebForms.WebApp.WebFormsApp.CreateMainPanel();

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("MainMenu", null, function (dto) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if ((dto.Texts != null) && (dto.Texts.Count > 0)) {
                                                                            Adaptica.WebForms.WebApp.WebFormsApp._texts = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).$ctor1(dto.Texts);
                                                                        }

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ProcessDto(dto);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        window.addEventListener("popstate", function (arg) {
                                                                            var $step = 0,
                                                                                $task1, 
                                                                                $jumpFromFinally, 
                                                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                                                    for (;;) {
                                                                                        $step = System.Array.min([0,1], $step);
                                                                                        switch ($step) {
                                                                                            case 0: {
                                                                                                $task1 = Adaptica.WebForms.WebApp.WebFormsApp.OnPopState(arg);
                                                                                                $step = 1;
                                                                                                if ($task1.isCompleted()) {
                                                                                                    continue;
                                                                                                }
                                                                                                $task1.continue($asyncBody);
                                                                                                return;
                                                                                            }
                                                                                            case 1: {
                                                                                                $task1.getAwaitedResult();
                                                                                                return;
                                                                                            }
                                                                                            default: {
                                                                                                return;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }, arguments);

                                                                            $asyncBody();
                                                                        });
                                                                        window.addEventListener("beforeunload", Adaptica.WebForms.WebApp.WebFormsApp.OnBeforeUnload);
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.CheckTexts();
                                            $step = 2;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task2.getAwaitedResult();
                                            window.document.title = System.String.format("{0} ({1})", Adaptica.WebForms.WebApp.WebFormsApp.OrganizationName, Adaptica.WebForms.WebApp.WebFormsApp.UserName);
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                OnBeforeUnload: function (arg) {
                    if ((Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm != null) && (!Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.FormData.IsMainMenu)) {
                        var anyChange = System.Linq.Enumerable.from(Adaptica.WebForms.WebApp.WebFormsApp._openForms, Adaptica.WebForms.WebApp.Controls.FormControl).any(function (f) {
                                return Adaptica.WebForms.Common.DataModel.FormHelper.IsChanged(f.FormData);
                            });
                        if (anyChange) {
                            var evnt = arg;
                            evnt.stopPropagation();
                            evnt.preventDefault();
                            evnt.returnValue = "";
                        }
                    }
                },
                OnPopState: function (arg) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        evnt, 
                        state, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,6], $step);
                                    switch ($step) {
                                        case 0: {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("OnPopState");

                                            evnt = arg;
                                            state = evnt.state;

                                            if (state != null) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 6;
                                            continue;
                                        }
                                        case 1: {
                                            if (state.stateCounter < Adaptica.WebForms.WebApp.WebFormsApp._historyStateCounter) {
                                                $step = 2;
                                                continue;
                                            } else  {
                                                $step = 4;
                                                continue;
                                            }
                                        }
                                        case 2: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                            $step = 3;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 3: {
                                            $task1.getAwaitedResult();
                                            $step = 5;
                                            continue;
                                        }
                                        case 4: {
                                            Adaptica.WebForms.WebApp.WebFormsApp._historyStateCounter = state.stateCounter;
                                            $step = 5;
                                            continue;
                                        }

                                        case 6: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                CheckTexts: function (completed) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (completed === void 0) { completed = null; }
                                            if ((Adaptica.WebForms.WebApp.WebFormsApp._texts == null) || (Adaptica.WebForms.WebApp.WebFormsApp._texts.Count === 0)) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetTexts", null, function (dto) {
                                                Adaptica.WebForms.WebApp.WebFormsApp._texts = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).$ctor1(dto.Texts);

                                                /* 
                                                                   string lang;
                                                                   if (_texts.TryGetValue("SystemShortCountryCode", out lang))
                                                                   {
                                                                       CultureInfo.CurrentCulture = new CultureInfo(lang);
                                                                   }
                                                */
                                                if (!Bridge.staticEquals(completed, null)) {
                                                    completed();
                                                }

                                                var pageTitle = { };
                                                if ((Adaptica.WebForms.WebApp.WebFormsApp._texts.tryGetValue("SystemPageTitle", pageTitle)) && (!System.String.isNullOrEmpty(pageTitle.v))) {
                                                    document.title = pageTitle.v;
                                                }

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            });
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetText: function (key) {
                    if (Adaptica.WebForms.WebApp.WebFormsApp._texts == null) {
                        return "";
                    }
                    var result = { };

                    Adaptica.WebForms.WebApp.WebFormsApp._texts.tryGetValue(key, result);

                    return result.v;
                },
                GetTextAsync: function (key) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        result, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckTexts();
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            result = { };

                                            Adaptica.WebForms.WebApp.WebFormsApp._texts.tryGetValue(key, result);

                                            $tcs.setResult(result.v);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetTextAsync$1: function (key, values) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        text, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (values === void 0) { values = []; }
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync(key);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            text = $taskResult1;
                                            if (!System.String.isNullOrEmpty(text)) {
                                                text = System.String.format.apply(System.String, [text].concat(values));
                                            }

                                            $tcs.setResult(text);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetTextsCount: function () {
                    return (Adaptica.WebForms.WebApp.WebFormsApp._texts == null) ? 0 : Adaptica.WebForms.WebApp.WebFormsApp._texts.Count;
                },
                SetText: function (key, value) {
                    if (Adaptica.WebForms.WebApp.WebFormsApp._texts == null) {
                        Adaptica.WebForms.WebApp.WebFormsApp._texts = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).ctor();
                    }

                    Adaptica.WebForms.WebApp.WebFormsApp._texts.setItem(key, value);
                },
                CreateMainPanel: function () {
                    var content = Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody();

                    var mainPanel = $("<div>").addClass("panel panel-default mainPanel");

                    $("<div>").addClass("col").append(mainPanel).appendTo(content);
                },
                Serialize: function (dto) {
                    var data = JSON.stringify(dto, function (s, o) {
                        if ((Bridge.referenceEquals(s, "Design")) || (Bridge.referenceEquals(s, "Functions"))) {
                            return null;
                        }

                        return o;
                    });

                    Adaptica.WebForms.WebApp.WebFormsApp.Log("Serialized: " + (data || ""));

                    return data;
                },
                GetSelectFunction: function (formControl, dspfid, fieldName, originalRecord) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        par, 
                        $t, 
                        filter, 
                        $t1, 
                        filter1, 
                        $t2, 
                        dto, 
                        data, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            par = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DTO.DTOParam)).ctor();
                                            par.add(($t = new Adaptica.WebForms.Common.DTO.DTOParam(), $t.Name = "DSPFID", $t.Value = dspfid, $t));
                                            par.add(($t = new Adaptica.WebForms.Common.DTO.DTOParam(), $t.Name = "FieldName", $t.Value = fieldName, $t));

                                            if (formControl.TextFilter.Count > 0) {
                                                filter = (($t = System.Collections.Generic.KeyValuePair$2(System.String,System.String), System.Linq.Enumerable.from(formControl.TextFilter, $t).toList($t)).ConvertAll(System.String, function (p) {
                                                    return System.String.format("{0}:{1}", p.key, p.value);
                                                }).ToArray()).join("|");
                                                par.add(($t1 = new Adaptica.WebForms.Common.DTO.DTOParam(), $t1.Name = "DataFilter", $t1.Value = filter, $t1));
                                            }

                                            if (formControl.ActiveFilter.Count > 0) {
                                                filter1 = (($t1 = System.Collections.Generic.KeyValuePair$2(System.String,System.String), System.Linq.Enumerable.from(formControl.ActiveFilter, $t1).toList($t1)).ConvertAll(System.String, function (p) {
                                                    return System.String.format("{0}:{1}", p.key, p.value);
                                                }).ToArray()).join("|");
                                                par.add(($t2 = new Adaptica.WebForms.Common.DTO.DTOParam(), $t2.Name = "ActiveFilter", $t2.Value = filter1, $t2));
                                            }

                                            dto = new Adaptica.WebForms.Common.DTO.DataDTO();
                                            dto.FormData = formControl.FormData;
                                            dto.Record = originalRecord;
                                            dto.DTOParams = par.ToArray();

                                            data = Adaptica.WebForms.WebApp.WebFormsApp.Serialize(dto);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetSelectFunction", data, "POST", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    selForm, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        selForm = new Adaptica.WebForms.WebApp.Controls.SelectionFormControl(dataDTO.FormData, formControl, dspfid, fieldName, originalRecord);
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DisplayFormControl(selForm);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ExecuteSelectFunctionAsync: function (selectionForm, currentDSPFID, currentSelectionRecord) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dspfid, 
                        fieldName, 
                        dataForm, 
                        selForm, 
                        originalRecord, 
                        selParams, 
                        $t, 
                        dto, 
                        data, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            dspfid = selectionForm.DSPFID;
                                            fieldName = selectionForm.FieldName;
                                            dataForm = selectionForm.SourceForm.FormData;
                                            selForm = selectionForm.FormData;
                                            originalRecord = selectionForm.OriginalRecord;

                                            selParams = ($t = new Adaptica.WebForms.Common.DTO.SelectionParams(), $t.DSPFID = dspfid, $t.FieldName = fieldName, $t.DataForm = dataForm, $t.SelectionForm = selForm, $t.CurrentDSPFID = currentDSPFID, $t.CurrentRecord = currentSelectionRecord, $t.OriginalRecord = originalRecord, $t);

                                            dto = ($t = new Adaptica.WebForms.Common.DTO.DataDTO(), $t.SelectionParams = selParams, $t);
                                            data = Adaptica.WebForms.WebApp.WebFormsApp.Serialize(dto);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ExecuteSelectFunction", data, "POST", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    newFormData, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        newFormData = dataDTO.FormData;
                                                                        Adaptica.WebForms.Common.DataModel.DataHelpers.MergeWith(dataForm.DataModule, newFormData.DataModule, true);
                                                                        selectionForm.SourceForm.RefreshData();

                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                SetData: function (formControl, silent) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dto, 
                        data, 
                        result, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (silent === void 0) { silent = false; }
                                            dto = new Adaptica.WebForms.Common.DTO.DataDTO();
                                            dto.Silent = silent;
                                            if (formControl.FormData.DataModule.Datasets.length === 1) {
                                                dto.FormData = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Form, formControl.FormData);
                                                dto.FormData.DataModule.Datasets.forEach(function (ds) {
                                                    ds.Header = null;
                                                    ds.Records = System.Linq.Enumerable.from(ds.Records, Adaptica.WebForms.Common.DataModel.Record).where(function (rec) {
                                                        return rec.Event !== Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None;
                                                    }).ToArray(Adaptica.WebForms.Common.DataModel.Record);
                                                });
                                            } else {
                                                dto.FormData = formControl.FormData;
                                            }

                                            data = Adaptica.WebForms.WebApp.WebFormsApp.Serialize(dto);

                                            result = false;
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("SetData", data, "POST", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    newFormData, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3,4], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        newFormData = dataDTO.FormData;
                                                                        if (newFormData.DataModule.InvalidData) {
                                                                            $step = 1;
                                                                            continue;
                                                                        } else  {
                                                                            $step = 3;
                                                                            continue;
                                                                        }
                                                                    }
                                                                    case 1: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ReloadData(formControl);
                                                                        $step = 2;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 2: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                    case 3: {
                                                                        Adaptica.WebForms.Common.DataModel.DataHelpers.MergeWith(formControl.FormData.DataModule, newFormData.DataModule, true);
                                                                        Adaptica.WebForms.Common.DataModel.DataHelpers.Commit(formControl.FormData.DataModule);
                                                                        formControl.CurrencyManager.RefreshCurrentRecords();
                                                                        formControl.RefreshData();
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                    case 4: {
                                                                        result = true;
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(result);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ProcessData: function (formControl, formData) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dto, 
                        data, 
                        result, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (formData === void 0) { formData = null; }
                                            if (formData == null) {
                                                formData = formControl.FormData;
                                            }

                                            dto = new Adaptica.WebForms.Common.DTO.DataDTO();
                                            if (formData.DataModule.Datasets.length === 1) {
                                                dto.FormData = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Form, formData);
                                                dto.FormData.DataModule.Datasets.forEach(function (ds) {
                                                    ds.Header = null;
                                                    ds.Records = System.Linq.Enumerable.from(ds.Records, Adaptica.WebForms.Common.DataModel.Record).where(function (rec) {
                                                        return rec.Event !== Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None;
                                                    }).ToArray(Adaptica.WebForms.Common.DataModel.Record);
                                                });
                                            } else {
                                                dto.FormData = formData;
                                            }

                                            data = Adaptica.WebForms.WebApp.WebFormsApp.Serialize(dto);

                                            result = false;
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ProcessData", data, "POST", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    newFormData, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3,4], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        newFormData = dataDTO.FormData;
                                                                        if (newFormData.DataModule.InvalidData) {
                                                                            $step = 1;
                                                                            continue;
                                                                        } else  {
                                                                            $step = 3;
                                                                            continue;
                                                                        }
                                                                    }
                                                                    case 1: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ReloadData(formControl);
                                                                        $step = 2;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 2: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                    case 3: {
                                                                        Adaptica.WebForms.Common.DataModel.DataHelpers.MergeWith(formData.DataModule, newFormData.DataModule, true);
                                                                        Adaptica.WebForms.Common.DataModel.DataHelpers.Commit(formData.DataModule);
                                                                        formControl.CurrencyManager.RefreshCurrentRecords();
                                                                        formControl.RefreshData();
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                    case 4: {
                                                                        result = true;
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(result);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetDataAsync$1: function (dataType, sendData, okHandler, keepSplash) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (sendData === void 0) { sendData = null; }
                                            if (okHandler === void 0) { okHandler = null; }
                                            if (keepSplash === void 0) { keepSplash = false; }
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$3(dataType, sendData, "GET", okHandler, null, null, keepSplash);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetDataAsync$2: function (dataType, sendData, method, okHandler, errorHandler, serverExceptionHandler) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (errorHandler === void 0) { errorHandler = null; }
                                            if (serverExceptionHandler === void 0) { serverExceptionHandler = null; }
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$3(dataType, sendData, method, okHandler, errorHandler, serverExceptionHandler, false);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetDataAsync$3: function (dataType, sendData, method, okHandler, errorHandler, serverExceptionHandler, keepSplash) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        pars, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            pars = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.GetDataParams(), $t.DataType = dataType, $t.DataToSend = sendData, $t.Method = method, $t.OKHandler = okHandler, $t.ErrorHandler = errorHandler, $t.ServerExceptionHandler = serverExceptionHandler, $t.KeepSplash = keepSplash, $t);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync(pars);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetDataAsync: function (pars) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        isSplashVisible, 
                        sid, 
                        options, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if ((Adaptica.WebForms.WebApp.WebFormsApp.IsRunningInPortal) && (QIWebForms.authException)) {
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            isSplashVisible = Adaptica.WebForms.WebApp.WebFormsApp.IsSplashVisible || pars.NoSplash;
                                            if (!isSplashVisible) {
                                                Adaptica.WebForms.WebApp.WebFormsApp.ShowSplash();
                                            }

                                            sid = Adaptica.WebForms.WebApp.WebFormsApp.SSID;

                                            if ((System.String.isNullOrEmpty(sid)) && (!Bridge.referenceEquals(pars.DataType, "Login")) && (!Bridge.referenceEquals(pars.DataType, "SessionState")) && (!Bridge.referenceEquals(pars.DataType, "GetTexts"))) {
                                            }

                                            options = { url: (Adaptica.WebForms.WebApp.Config.DataUrl || "") + (pars.DataType || ""), cache: false, data: pars.DataToSend, type: pars.Method, contentType: "application/json; charset=utf-8", beforeSend: function (xhr, o) {
                                                if (!System.String.isNullOrEmpty(sid)) {
                                                    xhr.setRequestHeader("X-WFSid", sid);
                                                }

                                                return true;
                                            }, success: function (data, textStatus, request) {
                                                var $step = 0,
                                                    $task1, 
                                                    $task2, 
                                                    $taskResult2, 
                                                    $task3, 
                                                    $jumpFromFinally, 
                                                    sData, 
                                                    dto, 
                                                    $taskResult1, 
                                                    processor, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3,4,5,6,7], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    sData = Bridge.as(data, System.String);
                                                                    Adaptica.WebForms.WebApp.WebFormsApp.Log(sData);

                                                                    dto = null;
                                                                    if (!System.String.isNullOrEmpty(sData)) {
                                                                        dto = Newtonsoft.Json.JsonConvert.DeserializeObject(sData, Adaptica.WebForms.Common.DTO.DataDTO);
                                                                    }

                                                                    if (!(!pars.CheckForServerException)) {
                                                                        $step = 1;
                                                                        continue;
                                                                    }
                                                                    $taskResult1 = true;
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 1: {
                                                                    $task2 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dto);
                                                                    $step = 2;
                                                                    if ($task2.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task2.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 2: {
                                                                    $taskResult2 = $task2.getAwaitedResult();
                                                                    $taskResult1 = ($taskResult2);
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 3: {
                                                                    if ($taskResult1) {
                                                                        $step = 4;
                                                                        continue;
                                                                    } else  {
                                                                        $step = 6;
                                                                        continue;
                                                                    }
                                                                }
                                                                case 4: {
                                                                    if ((dto != null) && (!System.String.isNullOrEmpty(dto.SSID))) {
                                                                        Adaptica.WebForms.WebApp.WebFormsApp.SSID = dto.SSID;
                                                                    }

                                                                    processor = pars.OKHandler;
                                                                    if (Bridge.staticEquals(processor, null)) {
                                                                        processor = Adaptica.WebForms.WebApp.WebFormsApp.ProcessDto;
                                                                    }

                                                                    $task3 = processor(dto);
                                                                    $step = 5;
                                                                    if ($task3.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task3.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 5: {
                                                                    $task3.getAwaitedResult();
                                                                    $step = 7;
                                                                    continue;
                                                                }
                                                                case 6: {
                                                                    !Bridge.staticEquals(pars.ServerExceptionHandler, null) ? pars.ServerExceptionHandler(dto.Data) : null;
                                                                    $step = 7;
                                                                    continue;
                                                                }
                                                                case 7: {
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            }, error: function (xhr, textStatus, errorThrown) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $t, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    if ((Bridge.staticEquals(pars.ErrorHandler, null)) && (xhr.status === 401)) {
                                                                        $step = 1;
                                                                        continue;
                                                                    } 
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 1: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DoLogout();
                                                                    $step = 2;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 2: {
                                                                    $task1.getAwaitedResult();
                                                                    Adaptica.WebForms.WebApp.WebFormsApp.ShowToast("Va\u0161e relace vypr\u0161ela, mus\u00edte se znovu p\u0159ihl\u00e1sit!");

                                                                    return;
                                                                }
                                                                case 3: {
                                                                    !Bridge.staticEquals(pars.ErrorHandler, null) ? pars.ErrorHandler(xhr.status, textStatus, ($t = xhr.getResponseHeader("X-WF-Error"), $t != null ? $t : errorThrown)) : null;
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            }, complete: function (xhr, s) {
                                                if (!(pars.KeepSplash || isSplashVisible)) {
                                                    Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                                }
                                            } };

                                            if (Bridge.is(pars.DataToSend, FormData)) {
                                                options.processData = false;
                                                options.contentType = false;
                                            }

                                            $task1 = System.Threading.Tasks.Task.fromPromise($.ajax(options));
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ReloadData: function (formControl) {
                    /* 
                               string filter = null;
                               if (formControl.DataFilter.Count > 0)
                               {
                                   filter = string.Join(Environment.NewLine, formControl.DataFilter.ToList().ConvertAll(p => string.Format("{0}={1}", p.Key, p.Value)).ToArray());
                               }
                               //QISession.FormResult resultData = null;

                               string insertedRecordMasterId = null;
                               string overridenFunctionId = null;
                               var mainDS = formControl.CurrencyManager.MainDataset;
                               if ((mainDS != null) && (mainDS.Header.Read == 0) && (mainDS.Header.Insert == 1))
                               {
                                   insertedRecordMasterId = string.Join(";", mainDS.Records.Select(r => r.RecID).ToList().FindAll(s=>!string.IsNullOrEmpty(s)).ToArray());
                                   overridenFunctionId = formControl.FormData.PFID;
                               }

                               Form form = await FormProvider.LoadForm (MainNavigationPage, overridenFunctionId, insertedRecordMasterId, filter, null);

                               if (form != null) {
                                   formControl.FormData.DataModule.MergeWith(newFormData.DataModule, true);
                                   formControl.FormData.DataModule.Commit();
                                   formControl.RefreshData();

                                   DataHelpers.MergeWith() (Form.DataModule, form.DataModule, false);

                                   CurrencyManager.LoadDataModule (Form.DataModule, FormProvider.MainDSPFID);
                    				
                                   RefreshData ();
                               }

                               NeedsReloadData = false;
                    */
                    return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                },
                IsException: function (dto) {
                    return ((dto != null) && (System.String.equals(("exception"), dto.Type)));
                },
                CheckException: function (dto, showDefaultDialog) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        ex, 
                        className, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,11,12], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (showDefaultDialog === void 0) { showDefaultDialog = true; }
                                            if (Adaptica.WebForms.WebApp.WebFormsApp.IsException(dto)) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 12;
                                            continue;
                                        }
                                        case 1: {
                                            ex = dto.Data;
                                            className = ex.ClassName || "";

                                            if (System.String.contains(className,"AuthenticationException")) {
                                                $step = 2;
                                                continue;
                                            } else  {
                                                $step = 7;
                                                continue;
                                            }
                                        }
                                        case 2: {
                                            if (Adaptica.WebForms.WebApp.WebFormsApp.IsRunningInPortal) {
                                                $step = 3;
                                                continue;
                                            } else  {
                                                $step = 4;
                                                continue;
                                            }
                                        }
                                        case 3: {
                                            QIWebForms.authException=true;
                                            Adaptica.WebForms.WebApp.WebFormsApp.GetWFBody().text(Bridge.cast(ex.Message, System.String));
                                            $step = 6;
                                            continue;
                                        }
                                        case 4: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DoLogout();
                                            $step = 5;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 5: {
                                            $task1.getAwaitedResult();
                                            $step = 6;
                                            continue;
                                        }
                                        case 6: {
                                            $step = 11;
                                            continue;
                                        }
                                        case 7: {
                                            if (showDefaultDialog) {
                                                $step = 8;
                                                continue;
                                            } 
                                            $step = 10;
                                            continue;
                                        }
                                        case 8: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2(null, ex.Message);
                                            $step = 9;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 9: {
                                            $task2.getAwaitedResult();
                                            $step = 10;
                                            continue;
                                        }

                                        case 11: {
                                            $tcs.setResult(false);
                                            return;
                                        }
                                        case 12: {
                                            $tcs.setResult(true);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ProcessDto: function (dto) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $taskResult2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (dto == null) {
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            if (dto.Exception != null) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2("", dto.Exception.Message);
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        case 3: {
                                            if (Bridge.referenceEquals(dto.Type, "form")) {
                                                $step = 4;
                                                continue;
                                            } 
                                            $step = 6;
                                            continue;
                                        }
                                        case 4: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm(dto.FormData);
                                            $step = 5;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 5: {
                                            $taskResult2 = $task2.getAwaitedResult();
                                            $step = 6;
                                            continue;
                                        }
                                        case 6: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                CreateForm$1: function (dto, parentForm) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (parentForm === void 0) { parentForm = null; }
                                            if (!Bridge.referenceEquals(dto.Type, "form")) {
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm(dto.FormData, parentForm);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            $tcs.setResult($taskResult1);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                CreateForm: function (formData, parentForm) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        control, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (parentForm === void 0) { parentForm = null; }
                                            control = new Adaptica.WebForms.WebApp.Controls.FormControl(formData, parentForm);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DisplayFormControl(control);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            $tcs.setResult(control);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                DisplayFormControl: function (control) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        result, 
                        state, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            $task1 = control.RenderControl();
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            result = $taskResult1;
                                            if (result != null) {
                                                $(".mainPanel").append(result);

                                                Adaptica.WebForms.WebApp.WebFormsApp._historyStateCounter = (Adaptica.WebForms.WebApp.WebFormsApp._historyStateCounter + 1) | 0;
                                                state = ($t = new Adaptica.WebForms.WebApp.HistoryPopState(), $t.stateCounter = Adaptica.WebForms.WebApp.WebFormsApp._historyStateCounter, $t.formId = control.FormId, $t);
                                                window.history.pushState(state, null, "");
                                            }

                                            $tcs.setResult(result);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                HideCurrentForm: function () {
                    if (Adaptica.WebForms.WebApp.WebFormsApp._openForms.Count > 0) {
                        var currentForm = Adaptica.WebForms.WebApp.WebFormsApp._openForms.Peek();
                        currentForm.DeactivateForm();
                    }
                },
                AddForm: function (form, hideCurrent) {
                    if (hideCurrent === void 0) { hideCurrent = true; }
                    if (hideCurrent) {
                        Adaptica.WebForms.WebApp.WebFormsApp.HideCurrentForm();
                    }

                    Adaptica.WebForms.WebApp.WebFormsApp._openForms.Push(form);
                },
                RemoveCurrentForm: function (showPrevious) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $task2, 
                        $taskResult2, 
                        $task3, 
                        $taskResult3, 
                        $task4, 
                        $taskResult4, 
                        $task5, 
                        $task6, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        defKeep, 
                        $t, 
                        defCancel, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (showPrevious === void 0) { showPrevious = true; }
                                            if ((Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.EditMode) && (Adaptica.WebForms.Common.DataModel.FormHelper.IsChanged(Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.FormData, true))) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.SaveForm(true);
                                            $step = 2;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $taskResult2 = $task2.getAwaitedResult();
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            if ((Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.EditMode) && (Adaptica.WebForms.Common.DataModel.FormHelper.IsChanged(Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.FormData))) {
                                                $step = 4;
                                                continue;
                                            } else  {
                                                $step = 9;
                                                continue;
                                            }
                                        }
                                        case 4: {
                                            $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("UnsavedBack");
                                            $step = 5;
                                            if ($task3.isCompleted()) {
                                                continue;
                                            }
                                            $task3.continue($asyncBody);
                                            return;
                                        }
                                        case 5: {
                                            $taskResult3 = $task3.getAwaitedResult();
                                            defKeep = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult3, $t.AddClass = "btn-secondary", $t);

                                            $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("UnsavedDiscard");
                                            $step = 6;
                                            if ($task4.isCompleted()) {
                                                continue;
                                            }
                                            $task4.continue($asyncBody);
                                            return;
                                        }
                                        case 6: {
                                            $taskResult4 = $task4.getAwaitedResult();
                                            defCancel = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult4, $t.AddClass = "btn-secondary", $t.Handler = function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $task2, 
                                                    $jumpFromFinally, 
                                                    cm, 
                                                    rec, 
                                                    $t1, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentFormInternal(showPrevious);
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.EndEdit(false);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    cm = Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.CurrencyManager;
                                                                    rec = cm != null ? cm.GetCurrentRecord(($t1 = cm.MainDataset) != null ? $t1.DSPFID : null) : null;
                                                                    if ((rec != null) && (rec.RecID == null)) {
                                                                        Adaptica.WebForms.Common.DataModel.DataHelpers.DeleteRecord(cm, cm.MainDataset, rec);
                                                                    }

                                                                    $task2 = Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.ActivateForm();
                                                                    $step = 2;
                                                                    if ($task2.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task2.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 2: {
                                                                    $task2.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            }, $t);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("UnsavedFormQuestion");
                                            $step = 7;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 7: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            $task5 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$1(null, $taskResult1, System.Array.init([defKeep, defCancel], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef));
                                            $step = 8;
                                            if ($task5.isCompleted()) {
                                                continue;
                                            }
                                            $task5.continue($asyncBody);
                                            return;
                                        }
                                        case 8: {
                                            $task5.getAwaitedResult();
                                            $step = 11;
                                            continue;
                                        }
                                        case 9: {
                                            Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentFormInternal(showPrevious);
                                            $task6 = Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.ActivateForm();
                                            $step = 10;
                                            if ($task6.isCompleted()) {
                                                continue;
                                            }
                                            $task6.continue($asyncBody);
                                            return;
                                        }
                                        case 10: {
                                            $task6.getAwaitedResult();
                                            $step = 11;
                                            continue;
                                        }
                                        case 11: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                RemoveCurrentFormInternal: function (showPrevious) {
                    if (showPrevious === void 0) { showPrevious = true; }
                    if (Adaptica.WebForms.WebApp.WebFormsApp._openForms.Count > 1) {
                        var form = Adaptica.WebForms.WebApp.WebFormsApp._openForms.Pop();
                        form.DeactivateForm();
                        form.Dispose();
                        Adaptica.WebForms.WebApp.WebFormsApp._historyStateCounter = (Adaptica.WebForms.WebApp.WebFormsApp._historyStateCounter - 1) | 0;

                        if (showPrevious) {
                            form = Adaptica.WebForms.WebApp.WebFormsApp._openForms.Peek();
                        }
                    }
                },
                IsInFavourites: function (formID, masterID) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems == null) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetFavouriteItems();
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            $tcs.setResult(Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems.Exists(function (item) {
                                                return (Bridge.referenceEquals(item.FormID, formID)) && (Bridge.referenceEquals(item.MasterID, masterID));
                                            }));
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                AddFavourite: function (formID, formCaption, masterID, masterCaption) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (masterID === void 0) { masterID = null; }
                                            if (masterCaption === void 0) { masterCaption = null; }
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.IsInFavourites(formID, masterID);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            if (!$taskResult1) {
                                                $step = 2;
                                                continue;
                                            } 
                                            $step = 4;
                                            continue;
                                        }
                                        case 2: {
                                            Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems.add(($t = new Adaptica.WebForms.Common.DTO.FavouriteItem(), $t.FormID = formID, $t.FormCaption = formCaption, $t.MasterID = masterID, $t.MasterCaption = masterCaption, $t));

                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.SaveFavouriteItems();
                                            $step = 3;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 3: {
                                            $task2.getAwaitedResult();
                                            $tcs.setResult(true);
                                            return;
                                        }
                                        case 4: {
                                            $tcs.setResult(false);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                RemoveFavourite: function (formID, masterID) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        cnt, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (masterID === void 0) { masterID = null; }
                                            if (Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems == null) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetFavouriteItems();
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            cnt = Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems.RemoveAll(function (item) {
                                                return (Bridge.referenceEquals(item.FormID, formID)) && (Bridge.referenceEquals(item.MasterID, masterID));
                                            });

                                            if (cnt > 0) {
                                                $step = 4;
                                                continue;
                                            } 
                                            $step = 6;
                                            continue;
                                        }
                                        case 4: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.SaveFavouriteItems();
                                            $step = 5;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 5: {
                                            $task2.getAwaitedResult();
                                            $tcs.setResult(true);
                                            return;
                                        }
                                        case 6: {
                                            $tcs.setResult(false);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetFavouriteItems: function () {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetFavouriteItems", null, "GET", function (dataDTO) {
                                                if ((dataDTO != null ? dataDTO.FavouriteItems : null) != null) {
                                                    Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DTO.FavouriteItem)).$ctor1(dataDTO.FavouriteItems);
                                                } else {
                                                    Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DTO.FavouriteItem)).ctor();
                                                }

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                SaveFavouriteItems: function () {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dto, 
                        $t, 
                        data, 
                        pars, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            dto = ($t = new Adaptica.WebForms.Common.DTO.DataDTO(), $t.FavouriteItems = Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems, $t);
                                            data = Adaptica.WebForms.WebApp.WebFormsApp.Serialize(dto);

                                            pars = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.GetDataParams(), $t.DataType = "SetFavouriteItems", $t.DataToSend = data, $t.Method = "POST", $t.OKHandler = function (dataDTO) {
                                                if ((dataDTO != null ? dataDTO.FavouriteItems : null) != null) {
                                                    Adaptica.WebForms.WebApp.WebFormsApp._favouriteItems = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DTO.FavouriteItem)).$ctor1(dataDTO.FavouriteItems);
                                                }

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            }, $t.NoSplash = true, $t);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync(pars);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                GetAttachmentKey: function (fileName) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        result, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            result = null;

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetAttachmentKey", { FileName: fileName }, "GET", function (dto) {
                                                result = Bridge.as(dto.Data, System.String);

                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(result);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                UploadAttachment: function (formData) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dParams, 
                        $t, 
                        $async_e, 
                        $async_e1, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([1,2,3,4], $step);
                                    switch ($step) {

                                        case 1: {
                                            dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.HideCloseButton = true, $t.Title = "*none*", $t.Message = "Uploading files", $t);


                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("UploadAttachment", formData, "POST", function (dto) {
                                                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                            });
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $task1.getAwaitedResult();
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            
                                            if ($jumpFromFinally > -1) {
                                                $step = $jumpFromFinally;
                                                $jumpFromFinally = null;
                                            } else if ($async_e) {
                                                $tcs.setException($async_e);
                                                return;
                                            } else if (Bridge.isDefined($returnValue)) {
                                                $tcs.setResult($returnValue);
                                                return;
                                            }
                                            $step = 4;
                                            continue;
                                        }
                                        case 4: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                if ($step >= 1 && $step <= 2) {
                                    $step = 3;
                                    $asyncBody();
                                    return;
                                }
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                CreateModalWithProgressBar: function () {
                    return $("<div>").addClass("modal fade").append($("<div>").addClass("modal-dialog").append($("<div>").addClass("modal-content").append($("<div>").addClass("modal-header").append($("<h4>").addClass("modal-title").html("Long running process..."))).append($("<div>").addClass("modal-body").append($("<div>").addClass("progress").append($("<div>").addClass("progress-bar").attr("role", "progressbar").attr("aria-valuemin", "0").attr("aria-valuemax", "100"))))));
                },
                ShowAlert$2: function (title, message, buttonCaption, buttonHandler) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $task2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        def, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (buttonCaption === void 0) { buttonCaption = null; }
                                            if (buttonHandler === void 0) { buttonHandler = null; }
                                            if (System.String.isNullOrEmpty(buttonCaption)) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            buttonCaption = $taskResult1;
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            def = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = buttonCaption, $t.Primary = true, $t.Handler = buttonHandler, $t);

                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$1(title, message, System.Array.init([def], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef));
                                            $step = 4;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 4: {
                                            $task2.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ShowAlert$1: function (title, message, buttonDefs) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dParams, 
                        $t, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.Title = title, $t.Message = message, $t.Buttons = buttonDefs, $t);

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                ShowAlert: function (alarmParams) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $task2, 
                        $taskResult2, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        alert, 
                        title, 
                        closeBtn, 
                        body, 
                        label, 
                        footer, 
                        $t, 
                        def, 
                        cap, 
                        btn, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6,7,8,9], $step);
                                    switch ($step) {
                                        case 0: {
                                            alert = $("#alertDialog");

                                            title = alarmParams.Title;
                                            if (System.String.isNullOrEmpty(title)) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 3;
                                            continue;
                                        }
                                        case 1: {
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AppName");
                                            $step = 2;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 2: {
                                            $taskResult1 = $task1.getAwaitedResult();
                                            title = $taskResult1;
                                            $step = 3;
                                            continue;
                                        }
                                        case 3: {
                                            if (alert.length === 0) {
                                                alert = $("\r\n<div class=\"modal fade\" id=\"alertDialog\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"alertDialogLabel\" aria-hidden=\"true\">\r\n  <div class=\"modal-dialog\" role=\"document\">\r\n    <div class=\"modal-content\">\r\n      <div class=\"modal-header\">\r\n        <h5 class=\"modal-title\" id=\"alertDialogLabel\"></h5>\r\n        <button id=\"alertCloseBtn\" type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-label=\"Close\">\r\n          <span aria-hidden=\"true\">&times;</span>\r\n        </button>\r\n      </div>\r\n      <div id=\"alertDialogBody\" class=\"modal-body\"></div>\r\n      <div class=\"modal-footer\"></div>\r\n    </div>\r\n  </div>\r\n</div>").appendTo(document.body);
                                            }

                                            closeBtn = alert.find("#alertCloseBtn");
                                            if (alarmParams.HideCloseButton) {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(closeBtn);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(closeBtn);
                                            }

                                            alert.find("#alertDialogLabel").html(title);
                                            body = alert.find("#alertDialogBody");
                                            if (alarmParams.MessageBody != null) {
                                                body.empty();
                                                body.append(alarmParams.MessageBody);
                                            } else {
                                                body.html(alarmParams.Message);
                                            }

                                            label = alert.find("#alertDialogLabel");
                                            if (System.String.equals(("*none*"), title)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(label);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(label);
                                            }

                                            footer = alert.find(".modal-footer");
                                            footer.empty();

                                            $t = Bridge.getEnumerator(alarmParams.Buttons, Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef);
                                            $step = 4;
                                            continue;
                                        }
                                        case 4: {
                                            if ($t.moveNext()) {
                                                def = { v : $t.Current };
                                                $step = 5;
                                                continue;
                                            }
                                            $step = 9;
                                            continue;
                                        }
                                        case 5: {
                                            cap = def.v.Caption;
                                            if (System.String.isNullOrEmpty(cap)) {
                                                $step = 6;
                                                continue;
                                            } 
                                            $step = 8;
                                            continue;
                                        }
                                        case 6: {
                                            $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                            $step = 7;
                                            if ($task2.isCompleted()) {
                                                continue;
                                            }
                                            $task2.continue($asyncBody);
                                            return;
                                        }
                                        case 7: {
                                            $taskResult2 = $task2.getAwaitedResult();
                                            cap = $taskResult2;
                                            $step = 8;
                                            continue;
                                        }
                                        case 8: {
                                            btn = { v : $("<button type=\"button\">").addClass("btn").html(cap).appendTo(footer) };

                                            if (def.v.AutoClose) {
                                                btn.v.attr("data-dismiss", "modal");
                                            }

                                            if (def.v.Primary) {
                                                btn.v.addClass("btn-primary");
                                            }

                                            if (!System.String.isNullOrEmpty(def.v.AddClass)) {
                                                btn.v.addClass(def.v.AddClass);
                                            }

                                            if (!Bridge.staticEquals(def.v.Handler, null)) {
                                                btn.v.click((function ($me, btn, def) {
                                                    return function () {
                                                        btn.v.off("click");
                                                        def.v.Handler();
                                                    };
                                                })(this, btn, def));
                                            }
                                            $step = 4;
                                            continue;
                                        }
                                        case 9: {
                                            $("#alertDialog").modal({backdrop: 'static'});

                                            if (!Bridge.staticEquals(alarmParams.OnDialogClosed, null)) {
                                                alert.on("hidden.bs.modal", alarmParams.OnDialogClosed);
                                            }

                                            /* 
                                                       if (string.IsNullOrEmpty(buttonCaption))
                                                       {
                                                           Window.SetTimeout(() => alert.Remove(), 3000);
                                                       }
                                            */
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                HideAlert: function () {
                    var alert = $("#alertDialog");
                    (alert).modal("hide");
                },
                ShowSplash: function () {
                    if (Adaptica.WebForms.WebApp.WebFormsApp.IsRunningInPortal) {
                        QIPortalAPI.showSplash();
                        return;
                    }

                    var splash = $("#_splash_");
                    if (splash.length > 0) {
                        Adaptica.WebForms.WebApp.Extensions.WFShow(splash);
                        return;
                    }

                    splash = $("<div>").attr("id", "_splash_").addClass("wf-splash").appendTo(document.body);


                    $("<img>").attr("src", "./resources/images/big-circle-ball.gif").addClass("wf-splash-image").appendTo(splash);
                },
                HideSplash: function () {
                    if (Adaptica.WebForms.WebApp.WebFormsApp.IsRunningInPortal) {
                        QIPortalAPI.hideSplash();
                        return;
                    }

                    Adaptica.WebForms.WebApp.Extensions.WFHide($("#_splash_"));
                },
                GetErrorText: function (errorText) {
                    return (System.Nullable.eq((errorText != null ? System.String.startsWith(errorText, "ICCM - ") : null), true)) ? errorText.substr(7) : errorText;
                },
                Log: function (item) {
                    Bridge.Console.log(item);
                },
                LoadScript: function (src, onLoad, onError) {
                    if (onLoad === void 0) { onLoad = null; }
                    if (onError === void 0) { onError = null; }
                    var scriptTag = document.createElement("script");
                    scriptTag.src = src;

                    if (!Bridge.staticEquals(onLoad, null)) {
                        scriptTag.onload = onLoad;
                    }

                    if (!Bridge.staticEquals(onError, null)) {
                        scriptTag.onerror = onError;
                    }

                    document.head.appendChild(scriptTag);
                },
                OpenNewWindowWithPost: function (url, dataToPost) {
                    var $t;
                    var win = window.open("");
                    var form = win.document.createElement("form");
                    form.method = "POST";
                    form.action = url;
                    form.style.display = "none";

                    $t = Bridge.getEnumerator(dataToPost);
                    try {
                        while ($t.moveNext()) {
                            var kvp = $t.Current;
                            var input = win.document.createElement("input");
                            input.type = "hidden";
                            input.name = kvp.key;
                            input.value = kvp.value;
                            form.appendChild(input);
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    /* 
                               var submit = win.Document.CreateElement("input") as HTMLInputElement;
                               submit.Type = InputType.Submit;
                               submit.Name = "Submit";
                               submit.Value = "Submit";
                               form.AppendChild(submit);
                    */

                    win.document.body.appendChild(form);

                    var script = win.document.createElement("script");
                    script.type = "text/javascript";

                    script.innerHTML = "alert(1); window.setTimeout('document.forms[0].submit()', 0);";
                    win.document.body.appendChild(script);

                    return win;
                },
                GetCssStyle: function (selector, styles) {
                    var $t;
                    if (styles === void 0) { styles = []; }
                    var sheets = window.document.styleSheets;
                    for (var sIndex = 0; sIndex < sheets.length; sIndex = (sIndex + 1) | 0) {
                        var sheet = sheets[sIndex];
                        if ((System.String.isNullOrEmpty(sheet.href)) || (Bridge.referenceEquals(sheet.href.toLowerCase().indexOf("webforms.css"), -1))) {
                            continue;
                        }

                        try { if (typeof(sheet.cssRules) == 'undefined') continue; } catch(e) { continue; };

                        $t = Bridge.getEnumerator(sheet.cssRules);
                        try {
                            while ($t.moveNext()) {
                                var rule = Bridge.cast($t.Current, System.Object);
                                var selText = rule.selectorText;

                                if (!System.String.isNullOrEmpty(selText)) {
                                    var sel = System.String.split(selText, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                                    if (System.Linq.Enumerable.from(sel, System.String).all(function (s) {
                                            return System.String.indexOf(s, selector) === -1;
                                        })) {
                                        continue;
                                    }

                                    var result = System.Array.init(styles.length, null, System.String);
                                    for (var i = 0; i < styles.length; i = (i + 1) | 0) {
                                        var value = Bridge.as(rule.style[styles[System.Array.index(i, styles)]], System.String);
                                        var idx = System.String.indexOf(value, "var(");
                                        if (idx > -1) {
                                            var idx2 = System.String.indexOf(value, ")", idx);
                                            var varName = value.substr(((idx + 4) | 0), ((((idx2 - idx) | 0) - 4) | 0));
                                            value = window.getComputedStyle(window.document.documentElement).getPropertyValue(varName);
                                        }
                                        result[System.Array.index(i, result)] = value;
                                    }

                                    return result;
                                }
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }

                    return null;
                }
            }
        },
        $entryPoint: true
    });

    Bridge.define("Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef", {
        $kind: "nested class",
        fields: {
            Caption: null,
            Handler: null,
            AddClass: null,
            Primary: false,
            AutoClose: false
        },
        ctors: {
            init: function () {
                this.AutoClose = true;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.WebFormsApp.DialogParams", {
        $kind: "nested class",
        fields: {
            HideCloseButton: false,
            Title: null,
            Message: null,
            MessageBody: null,
            OnDialogClosed: null,
            Buttons: null
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.WebFormsApp.GetDataParams", {
        $kind: "nested class",
        fields: {
            DataType: null,
            DataToSend: null,
            Method: null,
            OKHandler: null,
            ErrorHandler: null,
            ServerExceptionHandler: null,
            CheckForServerException: false,
            KeepSplash: false,
            NoSplash: false
        },
        ctors: {
            init: function () {
                this.Method = "GET";
                this.CheckForServerException = true;
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,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
