Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.DataSignature", {
        statics: {
            fields: {
                Current: null
            },
            methods: {
                ClearCurrent: function () {
                    Adaptica.WebForms.WebApp.DataSignature.Current = null;
                },
                ProcessSignedDataNia: function (resultJson) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        dtoObj, 
                        niaDto, 
                        postData, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (!Bridge.referenceEquals((resultJson).VysledekOvereni, true)) {
                                                $tcs.setResult(null);
                                                return;
                                            }

                                            dtoObj = { };
                                            dtoObj.token = Adaptica.WebForms.WebApp.DataSignature.Current._token;
                                            dtoObj.data = Adaptica.WebForms.WebApp.DataSignature.Current._data;
                                            dtoObj.fileName = Adaptica.WebForms.WebApp.DataSignature.Current._fileName;
                                            dtoObj.hash = Adaptica.WebForms.WebApp.DataSignature.Current._hash;

                                            niaDto = { };
                                            niaDto.status = (resultJson).Status;
                                            niaDto.detail = (resultJson).Detail;
                                            niaDto.idUkonu = (resultJson).IdUkonu;
                                            niaDto.sePP = (resultJson).SePP;
                                            niaDto.loA = (resultJson).LoA;
                                            niaDto.cas = (resultJson).Cas;

                                            dtoObj.nia = Bridge.unbox(niaDto);

                                            postData = JSON.stringify(Bridge.unbox(dtoObj));

                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ProcessSignedDataNia", postData, "POST", function (dataDTO) {
                                                var $step = 0,
                                                    $task1, 
                                                    $taskResult1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    resultXml, 
                                                    $t, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1,2,3], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $taskResult1 = $task1.getAwaitedResult();
                                                                        if ($taskResult1) {
                                                                            $step = 2;
                                                                            continue;
                                                                        } 
                                                                        $step = 3;
                                                                        continue;
                                                                    }
                                                                    case 2: {
                                                                        resultXml = Bridge.as(dataDTO.Data, System.String);
                                                                        !Bridge.staticEquals(($t = Adaptica.WebForms.WebApp.DataSignature.Current.OnSuccessfulSignature), null) ? $t(resultXml) : null;
                                                                        Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                                                        Adaptica.WebForms.WebApp.DataSignature.Current = null;
                                                                        $step = 3;
                                                                        continue;
                                                                    }
                                                                    case 3: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                }
            }
        },
        fields: {
            _signDataWindow: null,
            _token: null,
            _data: null,
            _hash: null,
            _fileName: null,
            OnSuccessfulSignature: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
                Adaptica.WebForms.WebApp.DataSignature.Current = this;
            }
        },
        methods: {
            SignData: function (token) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    dataToSend, 
                    btn1, 
                    $t, 
                    $t1, 
                    btn2, 
                    $t2, 
                    dParams, 
                    $t3, 
                    $t4, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        this._token = token;

                                        
                                        if (typeof(Signature) === 'undefined')
                                        {
                                            Adaptica.WebForms.WebApp.WebFormsApp.LoadScript('resources/js/3rd-party/forge.1.31.min.js', null, function()
                                            {
                                                alert('forge.1.31.min.js not found');
                                            });
                                            Adaptica.WebForms.WebApp.WebFormsApp.LoadScript('resources/js/DataSignatureUtils.js', null, function()
                                            {
                                                alert('DataSignatureUtils.js not found');
                                            });
                                        };

                                        dataToSend = JSON.stringify(System.Array.init([token], System.String));

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetDataToSign", dataToSend, "POST", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                dataStruct, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    if ($taskResult1) {
                                                                        $step = 2;
                                                                        continue;
                                                                    } 
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    dataStruct = dataDTO.Data;
                                                                    this._data = dataStruct[0];
                                                                    this._hash = dataStruct[1];
                                                                    this._fileName = dataStruct[2];
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 3: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByCert");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        btn1 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t1 = $taskResult2, $t1 != null ? $t1 : "Certifik\u00e1tem"), $t.Primary = true, $t.Handler = Bridge.fn.bind(this, function () {
                                            window.setTimeout(Bridge.fn.bind(this, function () {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = this.SignByCert(this._data, this._hash);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            }), 700);
                                        }), $t);

                                        btn2 = null;

                                        if (Bridge.referenceEquals(Adaptica.WebForms.WebApp.WebFormsApp.LoginType, "nia")) {
                                            $step = 3;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 3: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByNia");
                                        $step = 4;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        btn2 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t2 = $taskResult3, $t2 != null ? $t2 : "Identita ob\u010dana"), $t.Primary = true, $t.Handler = Bridge.fn.bind(this, function () {
                                            Adaptica.WebForms.WebApp.WebFormsApp.ShowSplash();
                                            var rnd = Math.floor(Math.random() * (999000)) + 1000;
                                            this._signDataWindow = window.open("nia/Signature.htm?_=" + (System.Double.format(rnd) || ""));

                                            var interval = 0;
                                            var postCalled = false;

                                            interval = window.setInterval(Bridge.fn.bind(this, function () {
                                                if ((!postCalled) && (!Bridge.referenceEquals((typeof (this._signDataWindow).doSubmit), "undefined"))) {
                                                    postCalled = true;
                                                    this.PostData(this._signDataWindow, this._data, this._hash);
                                                }

                                                if (this._signDataWindow.closed) {
                                                    window.clearInterval(interval);
                                                    Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();
                                                }

                                            }), 100);
                                        }), $t);
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByCert");
                                        $step = 6;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SelectSignType");
                                        $step = 7;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.Title = ($t3 = $taskResult4, $t3 != null ? $t3 : "Podpis sady dat"), $t.Message = ($t4 = $taskResult5, $t4 != null ? $t4 : "Pros\u00edm zvolte zp\u016fsob podpisu dat"), $t.Buttons = (Bridge.referenceEquals(Adaptica.WebForms.WebApp.WebFormsApp.LoginType, "nia")) ? System.Array.init([btn1, btn2], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef) : System.Array.init([btn1], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef), $t.OnDialogClosed = function () {
                                            $(".modal-dialog").removeClass("wf-signTypeDialog");
                                        }, $t);

                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                        $step = 8;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task6.getAwaitedResult();
                                        $(".modal-dialog").addClass("wf-signTypeDialog");
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            PostData: function ($window, data, hash) {
                var dataElem = $window.document.getElementById("data");
                if (dataElem != null) {
                    dataElem.value = data;
                }

                var hashElem = $window.document.getElementById("hash");
                if (hashElem != null) {
                    hashElem.value = hash;
                }

                ($window).doSubmit();
            },
            SignByCert: function (data, hashToSign) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    body, 
                    btn1, 
                    $t, 
                    $t1, 
                    btn2, 
                    $t2, 
                    dParams, 
                    $t3, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        body = $("\r\n<div>\r\n\t<label id='signCertLabel' for='pfx'>Vyberte soubor s certifik\u00e1tem (PFX/P12):</label><br/>\r\n\t<input name='pfx' class='form-control border-none' type='file' id='pfx' accept='.pfx,.p12' required>\r\n</div>\r\n<div>\r\n\t<label id='signCertPwdLabel' for='pfxp'>Vlo\u017ete heslo k priv\u00e1tn\u00edmu kl\u00ed\u010di:</label><br/>\r\n\t<input name='pfxp' class='form-control' type='password' id='pfxp' required><br/>\r\n\t<i id='signInfo'>Priv\u00e1tn\u00ed kl\u00ed\u010d ani heslo <b>se nikam nep\u0159en\u00e1\u0161\u00ed</b>, podpis prob\u00edh\u00e1 <b>p\u0159\u00edmo v prohl\u00ed\u017ee\u010di</b>, p\u0159en\u00e1\u0161\u00ed se pouze podpis a ve\u0159ejn\u00e1 \u010d\u00e1st certifik\u00e1tu.</i>\r\n</div>");

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DoSign");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        btn1 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t1 = $taskResult1, $t1 != null ? $t1 : "Podepsat"), $t.Primary = true, $t.AutoClose = false, $t.Handler = Bridge.fn.bind(this, function () {
                                            var self = this;
                                            Signature.Sign(hashToSign).then((result) => { self.ProcessSignedData(data, hashToSign, result.signature, result.publicCert).wait(); }, (reason) => { self.SignFailed(reason); });
                                        }), $t);

                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("Cancel");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        btn2 = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = ($t2 = $taskResult2, $t2 != null ? $t2 : "Zru\u0161it"), $t.Handler = function () {
                                            /* */
                                        }, $t);

                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SignByCert");
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        dParams = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogParams(), $t.Title = ($t3 = $taskResult3, $t3 != null ? $t3 : "Podpis sady dat"), $t.MessageBody = body, $t.Buttons = System.Array.init([btn1, btn2], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef), $t.OnDialogClosed = function () {
                                            $(".modal-dialog").removeClass("wf-signByCert");
                                        }, $t);

                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert(dParams);
                                        $step = 4;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task4.getAwaitedResult();
                                        $(".modal-dialog").addClass("wf-signByCert");
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ProcessSignedData: function (data, hash, signature, publicCert) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    dtoObj, 
                    postData, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.HideAlert();

                                        dtoObj = { };
                                        dtoObj.token = this._token;
                                        dtoObj.data = data;
                                        dtoObj.hash = hash;
                                        dtoObj.fileName = this._fileName;
                                        dtoObj.signature = signature;
                                        dtoObj.publicCert = publicCert;

                                        postData = JSON.stringify(Bridge.unbox(dtoObj));

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ProcessSignedData", postData, "POST", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                resultXml, 
                                                $t, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    if ($taskResult1) {
                                                                        $step = 2;
                                                                        continue;
                                                                    } 
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    resultXml = Bridge.as(dataDTO.Data, System.String);
                                                                    !Bridge.staticEquals(($t = this.OnSuccessfulSignature), null) ? $t(resultXml) : null;
                                                                    Adaptica.WebForms.WebApp.DataSignature.Current = null;
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 3: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SignFailed: function (reason) {

                var dReason = reason;
                var reasonId = dReason.reason;
                var reasonText = dReason.text;

                if (!System.String.isNullOrEmpty(reasonText)) {
                    window.alert(reasonText);
                }
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,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
