/**
 * @version 1.0.0.0
 * @author HP Inc.
 * @copyright Copyright © HP Inc. 2019
 * @compiler Bridge.NET 17.10.1
 */
Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.Common.DataModel.IContainerItemFont", {
        $kind: "interface"
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.ContainerItem", {
        statics: {
            fields: {
                QIImage: null,
                QIVCard: null,
                QIICalendar: null,
                QIBarcode: null,
                QIBarcodeButton: null,
                QIEmail: null,
                QITimer: null,
                QICommunicate: null,
                QIMap: null,
                QIPhone: null,
                QIURL: null,
                QIAttachment: null,
                QIAttachmentOnline: null,
                QIGetCurrentLocation: null,
                QIGetCurrentLocationText: null,
                QIGetCurrentLocationReadOnly: null,
                QISignaturePad: null,
                QIDownloadFile: null,
                QIPrintFile: null,
                QIKanban: null,
                QIMobileCurrentLocalTime: null,
                QIMobileQRCodeImage: null,
                QIMobileHTMLText: null,
                QIMobileDataSignature: null,
                QIMobileFontIcon: null
            },
            ctors: {
                init: function () {
                    this.QIImage = "QIMobile.Image";
                    this.QIVCard = "QIMobile.vCard";
                    this.QIICalendar = "QIMobile.iCalendar";
                    this.QIBarcode = "QIMobile.BarCode";
                    this.QIBarcodeButton = "QIMobile.BarCodeButton";
                    this.QIEmail = "QIMobile.Email";
                    this.QITimer = "QIMobile.Timer";
                    this.QICommunicate = "QIMobile.Communicate";
                    this.QIMap = "QIMobile.Map";
                    this.QIPhone = "QIMobile.PhoneNo";
                    this.QIURL = "QIMobile.URL";
                    this.QIAttachment = "QIMobile.Attachment";
                    this.QIAttachmentOnline = "QIMobile.Attachment.Online";
                    this.QIGetCurrentLocation = "QIMobile.GetCurrentLocation";
                    this.QIGetCurrentLocationText = "QIMobile.GetCurrentGeolocation";
                    this.QIGetCurrentLocationReadOnly = "QIMobile.GetCurrentLocationRO";
                    this.QISignaturePad = "QIMobile.SignaturePad";
                    this.QIDownloadFile = "QIMobile.DownloadFile";
                    this.QIPrintFile = "QIMobile.PrintFile";
                    this.QIKanban = "QIMobile.KanbanTable";
                    this.QIMobileCurrentLocalTime = "QIMobile.CurrentLocalTime";
                    this.QIMobileQRCodeImage = "QIMobile.QRCodeImage";
                    this.QIMobileHTMLText = "QIMobile.HTMLText";
                    this.QIMobileDataSignature = "QIMobile.SignatureData";
                    this.QIMobileFontIcon = "QIMobile.FontIcon";
                }
            }
        },
        fields: {
            PFPFID: null,
            DSPFID: null,
            Caption: null,
            FieldName: null,
            Order: 0,
            Action: null,
            Type: 0,
            ItemType: null
        },
        methods: {
            Clone: function () {

                var i = Bridge.as(Bridge.clone(this), Adaptica.WebForms.Common.DataModel.ContainerItem);
                return i;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Configuration", {
        fields: {
            Version: null,
            Language: null,
            OrganizationName: null,
            UserName: null,
            UserEmail: null,
            MainMenuID: null,
            ClearCache: 0,
            Texts: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Container", {
        fields: {
            Caption: null,
            Icon: null,
            Items: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum", {
        $kind: "nested enum",
        statics: {
            fields: {
                Unknown: 0,
                Button: 1,
                TileButton: 2,
                ButtonPicker: 3
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.CurrencyManager", {
        fields: {
            currentRecords: null,
            currentDatasets: null,
            MainDataset: null
        },
        events: {
            OnCurrentRecordChanged: null,
            OnDataSetChanged: null
        },
        ctors: {
            init: function () {
                this.currentRecords = new (System.Collections.Generic.Dictionary$2(System.String,Adaptica.WebForms.Common.DataModel.Record)).ctor();
                this.currentDatasets = new (System.Collections.Generic.Dictionary$2(System.String,Adaptica.WebForms.Common.DataModel.Dataset)).ctor();
            }
        },
        methods: {
            RefreshCurrentRecords: function () {
                var $t;
                ($t = System.Collections.Generic.KeyValuePair$2(System.String,Adaptica.WebForms.Common.DataModel.Record), System.Linq.Enumerable.from(this.currentRecords, $t).toList($t)).ForEach(Bridge.fn.bind(this, function (x) {
                    if (x.value != null) {
                        if (x.value.Event === Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Delete) {
                            this.MoveToFirstRecord(x.key);
                        }
                        ;
                    }
                }));
            },
            SetCurrentRecord: function (DSPFID, record) {
                var changed = false;
                if (this.currentRecords.containsKey(DSPFID)) {
                    changed = !Bridge.referenceEquals(this.currentRecords.getItem(DSPFID), record);
                    this.currentRecords.setItem(DSPFID, record);
                } else {
                    this.currentRecords.add(DSPFID, record);
                    changed = record != null;
                }

                if (changed) {
                    !Bridge.staticEquals(this.OnCurrentRecordChanged, null) ? this.OnCurrentRecordChanged(this, new Adaptica.WebForms.Common.DataModel.CurrencyManager.CurrencyManagerEventArgs(DSPFID)) : null;
                }
            },
            MoveNext: function (DSPFID) {
                var $t;
                var ds = this.GetCurrentDataset(DSPFID);
                this.SetCurrentRecord(DSPFID, ($t = ds.Records)[System.Array.index(((Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, this.GetCurrentRecord(DSPFID)) + 1) | 0), $t)]);
            },
            MovePrevious: function (DSPFID) {
                var $t;
                var ds = this.GetCurrentDataset(DSPFID);
                this.SetCurrentRecord(DSPFID, ($t = ds.Records)[System.Array.index(((Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, this.GetCurrentRecord(DSPFID)) - 1) | 0), $t)]);
            },
            SetCurrentDataset: function (DSPFID, dataset) {
                if (this.currentDatasets.containsKey(DSPFID)) {
                    if (!Bridge.referenceEquals(this.currentDatasets.getItem(DSPFID), dataset)) {
                        this.currentDatasets.setItem(DSPFID, dataset);
                        this.SetCurrentRecord(DSPFID, null);
                    } else {
                        if (!System.Array.contains(dataset.Records, this.GetCurrentRecord(DSPFID), Adaptica.WebForms.Common.DataModel.Record)) {
                            this.SetCurrentRecord(DSPFID, null);
                        }
                    }
                } else {
                    this.currentDatasets.add(DSPFID, dataset);
                    this.SetCurrentRecord(DSPFID, null);
                }

                if (!Bridge.staticEquals(this.OnDataSetChanged, null)) {
                    this.OnDataSetChanged(this, new Adaptica.WebForms.Common.DataModel.CurrencyManager.CurrencyManagerEventArgs(DSPFID));
                }

            },
            SetCurrentRecordToFirstFromDataModule: function (DSPFID, dataModule) {
                var $t;
                var sds = System.Linq.Enumerable.from(dataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).firstOrDefault(function (ds) {
                        return Bridge.referenceEquals(ds.DSPFID, DSPFID);
                    }, null);
                if (sds != null && sds.Records.length > 0) {
                    var sr = ($t = sds.Records)[System.Array.index(0, $t)];

                    var tds = this.currentDatasets.getItem(DSPFID);

                    var tr = System.Linq.Enumerable.from(tds.Records, Adaptica.WebForms.Common.DataModel.Record).singleOrDefault(function (r) {
                            return Bridge.referenceEquals(r.RecID, sr.RecID) || r.RecID == null && r.RecNo === sr.RecNo;
                        }, null);

                    if (tr != null) {
                        this.SetCurrentRecord(DSPFID, tr);
                    }
                }
            },
            LoadDataModule: function (dm, MainDSPFID) {
                var $t, $t1;
                dm != null ? dm.Datasets.forEach(Bridge.fn.bind(this, function (ds) {
                            this.SetCurrentDataset(ds.DSPFID, ds);
                        })) : null;

                if (System.String.isNullOrEmpty(MainDSPFID)) {
                    this.MainDataset = ($t = Adaptica.WebForms.Common.DataModel.Dataset, System.Linq.Enumerable.from(this.currentDatasets.Values, $t).toList($t)).Find(function (ds) {
                        return System.String.isNullOrEmpty(ds.MasterFields) || (!System.String.isNullOrEmpty(ds.MasterDSPFID) && !System.String.isNullOrEmpty(ds.MasterFields));
                    });
                } else {
                    this.MainDataset = ($t1 = Adaptica.WebForms.Common.DataModel.Dataset, System.Linq.Enumerable.from(this.currentDatasets.Values, $t1).toList($t1)).Find(function (ds) {
                        return Bridge.referenceEquals(ds.DSPFID, MainDSPFID);
                    });
                }
            },
            GetCurrentRecord: function (DSPFID) {
                if (System.String.isNullOrEmpty(DSPFID)) {
                    return null;
                }
                var result = { };

                this.currentRecords.tryGetValue(DSPFID, result);
                return result.v;
            },
            GetCurrentRecordOrFirst: function (DSPFID) {
                if (System.String.isNullOrEmpty(DSPFID)) {
                    return null;
                }

                if (this.GetCurrentRecord(DSPFID) == null) {
                    this.MoveToFirstRecord(DSPFID);
                }
                return this.GetCurrentRecord(DSPFID);
            },
            GetCurrentDataset: function (DSPFID) {
                if ((System.String.isNullOrEmpty(DSPFID)) || (!this.currentDatasets.containsKey(DSPFID))) {
                    return null;
                }
                return this.currentDatasets.getItem(DSPFID);
            },
            MoveToFirstRecord: function (DSPFID) {
                var $t, $t1;
                var ds = this.GetCurrentDataset(DSPFID);
                if (System.Nullable.gt((ds != null && ($t = ds.Records) != null ? $t.length : null), 0)) {
                    this.SetCurrentRecord(DSPFID, ($t1 = ds.Records)[System.Array.index(0, $t1)]);
                }
            },
            IsFirstRecord: function (DSPFID) {
                var r = this.GetCurrentRecord(DSPFID);
                var ds = this.GetCurrentDataset(DSPFID);

                return Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, r) === 0;
            },
            IsLastRecord: function (DSPFID) {
                var r = this.GetCurrentRecord(DSPFID);
                var ds = this.GetCurrentDataset(DSPFID);

                return Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, ds.Records, r) === ((ds.Records.length - 1) | 0);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.CurrencyManager.CurrencyManagerEventArgs", {
        $kind: "nested class",
        fields: {
            DSPFID: null
        },
        ctors: {
            ctor: function (DSPFID) {
                this.$initialize();
                System.Object.call(this);
                this.DSPFID = DSPFID;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.DataHelpers", {
        statics: {
            methods: {
                Commit: function (dataModule) {
                    dataModule.Datasets.forEach(function (ds) {
                            ds.Records = System.Linq.Enumerable.from(ds.Records, Adaptica.WebForms.Common.DataModel.Record).where(function (r) {
                                    return r.Event !== Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Delete;
                                }).ToArray(Adaptica.WebForms.Common.DataModel.Record);
                            ds.RecordCount = ds.Records.length;
                        });
                },
                MergeWith: function (target, source, updateExistingOnly) {
                    var anyChanges = false;
                    if ((target != null ? target.Datasets : null) == null) {
                        return false;
                    }

                    target.InstanceID = source.InstanceID;
                    target.EditMode = source.EditMode;
                    source.Datasets.forEach(function (sds) {
                            var tds = System.Linq.Enumerable.from(target.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).firstOrDefault(function (ds) {
                                    return Bridge.referenceEquals(ds.DSPFID, sds.DSPFID);
                                }, null);
                            if (tds == null) {
                                target.Datasets.push(sds);
                                anyChanges = true;
                            } else {
                                if (!updateExistingOnly) {
                                    tds.RecordCount = sds.RecordCount;
                                    tds.MasterIDParent = sds.MasterIDParent;
                                    tds.InnerDSDSID = sds.InnerDSDSID;
                                    tds.OuterDSDSID = sds.OuterDSDSID;
                                }

                                tds.InstanceID = sds.InstanceID;
                                var destIds = System.Linq.Enumerable.from(tds.Records, Adaptica.WebForms.Common.DataModel.Record).select(function (r) {
                                        return r.RecID;
                                    }).toList(System.String);
                                sds.Records.forEach(function (sr) {
                                        var tr = System.Linq.Enumerable.from(tds.Records, Adaptica.WebForms.Common.DataModel.Record).firstOrDefault(function (r) {
                                                return Bridge.referenceEquals(r.RecID, sr.RecID) || r.RecID == null && r.RecNo === sr.RecNo;
                                            }, null);

                                        if (tr == null) {
                                            tds.Records.push(sr);
                                            anyChanges = true;
                                            if (sr.RecNo <= 0) {
                                                sr.RecNo = tds.Records.length;
                                            }
                                        } else {
                                            tr.RecID = sr.RecID;
                                            tr.RecNo = sr.RecNo;
                                            tr.Flags = sr.Flags;
                                            destIds.remove(tr.RecID);

                                            tr.Event = sr.Event;

                                            var unmatchedDestFieldValues = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.FieldValue)).$ctor1(tr.FieldValues);
                                            sr.FieldValues.forEach(function (sfv) {
                                                    var tfv = System.Linq.Enumerable.from(tr.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (fv) {
                                                            return Bridge.referenceEquals(fv.Name, sfv.Name);
                                                        }, null);
                                                    if (tfv == null) {
                                                        tr.FieldValues.push(sfv);
                                                        anyChanges = true;
                                                    } else {
                                                        if (!Bridge.referenceEquals(tfv.Value, sfv.Value)) {
                                                            tfv.Value = sfv.Value;
                                                            anyChanges = true;
                                                        }

                                                        if (System.Nullable.neq(tfv.ReadOnly, sfv.ReadOnly)) {
                                                            tfv.ReadOnly = sfv.ReadOnly;
                                                            anyChanges = true;
                                                        }

                                                        if (System.Nullable.neq(tfv.Visible, sfv.Visible)) {
                                                            tfv.Visible = sfv.Visible;
                                                            anyChanges = true;
                                                        }

                                                        if (System.Nullable.neq(tfv.Required, sfv.Required)) {
                                                            tfv.Required = sfv.Required;
                                                            anyChanges = true;
                                                        }
                                                        tfv.Event = sfv.Event;
                                                        unmatchedDestFieldValues.remove(tfv);
                                                    }
                                                });
                                            if (!updateExistingOnly) {
                                                tr.FieldValues = System.Linq.Enumerable.from(tr.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).except(unmatchedDestFieldValues).ToArray(Adaptica.WebForms.Common.DataModel.FieldValue);
                                            }
                                        }
                                    });
                                if (!updateExistingOnly) {
                                    var tmpRecs = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.Record)).$ctor1(tds.Records);

                                    var removedCount = tmpRecs.RemoveAll(function (r) {
                                        return destIds.contains(r.RecID);
                                    });
                                    if (removedCount > 0) {
                                        tds.Records = tmpRecs.ToArray();
                                        anyChanges = true;
                                    }
                                }
                            }
                        });
                    target.Datasets.forEach(function (ds) {
                            ds.Records.sort(function (a, b) {
                                    return ((a.RecNo - b.RecNo) | 0);
                                });
                        });

                    return anyChanges;
                },
                InsertRecord: function (cm, dataset) {
                    var $t;
                    var r = new Adaptica.WebForms.Common.DataModel.Record();
                    r.Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Insert;
                    r.RecID = null;
                    r.Update = 1;
                    r.Delete = dataset.Header.Delete;
                    dataset.Records.push(r);

                    r.RecNo = dataset.Records.length;

                    if (!System.String.isNullOrEmpty(dataset.MasterFields)) {
                        var m = System.Text.RegularExpressions.Regex.match(dataset.MasterFields, "(?:(?<leftPrefix>.*)\\.)*ID(?<leftSuffix>.*)=(?:(?<rightPrefix>.*)\\.)*ID(?<rightSuffix>.*)");
                        var leftPrefix = m.getGroups().getByName("leftPrefix").getSuccess() ? (m.getGroups().getByName("leftPrefix").getValue().toLowerCase() || "") + "." : "";
                        var leftSuffix = m.getGroups().getByName("leftSuffix").getSuccess() ? m.getGroups().getByName("leftSuffix").getValue().toLowerCase() : "";
                        var rightPrefix = m.getGroups().getByName("rightPrefix").getSuccess() ? (m.getGroups().getByName("rightPrefix").getValue().toLowerCase() || "") + "." : "";
                        var rightSuffix = m.getGroups().getByName("rightSuffix").getSuccess() ? m.getGroups().getByName("rightSuffix").getValue().toLowerCase() : "";
                        var ic_master = null, u_master = null;

                        if (!System.String.isNullOrEmpty(dataset.MasterIDParent)) {
                            if (System.String.indexOf(dataset.MasterIDParent, String.fromCharCode(44)) === -1) {
                                ic_master = dataset.MasterIDParent;
                            } else {
                                var splitted = System.String.split(dataset.MasterIDParent, System.Array.init([","], System.String), null, 1);
                                ic_master = splitted[System.Array.index(0, splitted)];
                                u_master = splitted[System.Array.index(1, splitted)];
                            }
                        } else {
                            var masterRecord = cm.GetCurrentRecordOrFirst(dataset.MasterDSPFID);
                            if (masterRecord != null) {
                                ic_master = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(masterRecord, (rightPrefix || "") + "ic" + (rightSuffix || ""));
                                u_master = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(masterRecord, (rightPrefix || "") + "u" + (rightSuffix || ""));
                            }
                        }
                        Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(r, ($t = new Adaptica.WebForms.Common.DataModel.FieldDef(), $t.Name = (leftPrefix || "") + "ic" + (leftSuffix || ""), $t), ic_master);
                        Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(r, ($t = new Adaptica.WebForms.Common.DataModel.FieldDef(), $t.Name = (leftPrefix || "") + "u" + (leftSuffix || ""), $t), u_master);
                        r.MasterIDParent = System.String.format("{0},{1}", ic_master, u_master);
                    }

                    return r;
                },
                DeleteRecord: function (cm, dataset, record) {
                    var recIdx = Adaptica.WebForms.WebApp.Extensions.IndexOf(Adaptica.WebForms.Common.DataModel.Record, dataset.Records, record);
                    if (recIdx > -1) {
                        var currRec = cm.GetCurrentRecord(dataset.DSPFID);
                        if (Bridge.referenceEquals(currRec, record)) {
                            cm.SetCurrentRecord(dataset.DSPFID, null);
                            dataset.Records.splice(recIdx, 1);
                        }
                    }
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.DataModule", {
        fields: {
            Datasets: null,
            InstanceID: null,
            InvalidData: false,
            AllowEditMode: false,
            EditMode: false
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Dataset", {
        fields: {
            DSID: null,
            DSPFID: null,
            MasterDSPFID: null,
            MasterIDParent: null,
            InstanceID: null,
            InnerDSDSID: null,
            OuterDSDSID: null,
            MasterFields: null,
            RecordCount: 0,
            SilentSave: false,
            Type: 0,
            MergeMode: 0,
            Filter: null,
            ActiveFilterID: null,
            Header: null,
            Records: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Design", {
        fields: {
            Containers: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldDef", {
        fields: {
            Name: null,
            /**
             * - 0 - Bit
             - 1 - Enum
             - 2 - Set
             - 3 - Blob
             - 4 - Memo
             - 5 - LMemo
             - 6 - String
             - 7 - LString
             - 8 - Integer
             - 9 - Float
             - 10 - DateTime
             - 11 - Date
             - 12 - Time
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DataModel.FieldDef
             * @function Type
             * @type number
             */
            Type: 0,
            Hidden: 0,
            Required: 0,
            ReadOnly: 0,
            ProcessChange: false,
            SelectFunction: 0,
            SelectFunctionID: null,
            Label: null,
            Values: null,
            DisplayValues: null,
            Mask: null,
            Description: null
        },
        methods: {
            xClone: function () {
                var $t;
                return ($t = new Adaptica.WebForms.Common.DataModel.FieldDef(), $t.Name = this.Name, $t.Type = this.Type, $t.Hidden = this.Hidden, $t.Required = this.Required, $t.ReadOnly = this.ReadOnly, $t.ProcessChange = this.ProcessChange, $t.SelectFunction = this.SelectFunction, $t.SelectFunctionID = this.SelectFunctionID, $t.Label = this.Label, $t.Values = this.Values, $t.DisplayValues = this.DisplayValues, $t.Mask = this.Mask, $t.Description = this.Description, $t);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldType", {
        statics: {
            fields: {
                Bit: 0,
                Enum: 0,
                Set: 0,
                Blob: 0,
                Memo: 0,
                LMemo: 0,
                String: 0,
                LString: 0,
                Integer: 0,
                Float: 0,
                DateTime: 0,
                Date: 0,
                Time: 0
            },
            ctors: {
                init: function () {
                    this.Bit = 0;
                    this.Enum = 1;
                    this.Set = 2;
                    this.Blob = 3;
                    this.Memo = 4;
                    this.LMemo = 5;
                    this.String = 6;
                    this.LString = 7;
                    this.Integer = 8;
                    this.Float = 9;
                    this.DateTime = 10;
                    this.Date = 11;
                    this.Time = 12;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldValue", {
        fields: {
            Name: null,
            ReadOnly: null,
            Visible: null,
            Required: null,
            Value: null,
            Event: 0,
            /**
             * - 0 - Bit
             - 1 - Enum
             - 2 - Set
             - 3 - Blob
             - 4 - Memo
             - 5 - LMemo
             - 6 - String
             - 7 - LString
             - 8 - Integer
             - 9 - Float
             - 10 - DateTime
             - 11 - Date
             - 12 - Time
             *
             * @instance
             * @public
             * @memberof Adaptica.WebForms.Common.DataModel.FieldValue
             * @function ViewType
             * @type ?number
             */
            ViewType: null,
            ViewValues: null,
            ViewDisplayValues: null,
            ViewMask: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
            },
            $ctor1: function (fieldDef) {
                this.$initialize();
                this.Name = fieldDef.Name;
                this.ReadOnly = fieldDef.ReadOnly;
                this.Visible = fieldDef.Hidden === 0 ? 1 : 0;
                this.Required = fieldDef.Required;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldValue.FieldValueEventEnum", {
        $kind: "nested enum",
        statics: {
            fields: {
                Read: 0,
                Insert: 1,
                Update: 2,
                Delete: 3
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Filter", {
        fields: {
            Name: null,
            ID: null,
            Type: 0,
            PFID: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Form", {
        fields: {
            PFPFID: null,
            PFID: null,
            ClearPFPFID: null,
            ClearPFID: null,
            ClientID: null,
            Caption: null,
            TimeStamp: null,
            BUID: null,
            UserID: null,
            LoginID: null,
            DataModule: null,
            Functions: null,
            Design: null,
            Description: null,
            DescriptionMarks: null,
            NoCache: false,
            IsMainMenu: false,
            ShowSearchBar: false,
            IsF4: false,
            _templateName: null
        },
        props: {
            TemplateName: {
                get: function () {
                    var $t;
                    return ($t = this._templateName, $t != null ? $t : "Default");
                },
                set: function (value) {
                    this._templateName = value;
                }
            }
        },
        methods: {
            Clone: function () {
                var $t;
                var f = ($t = new Adaptica.WebForms.Common.DataModel.Form(), $t.PFPFID = this.PFPFID, $t.PFID = this.PFID, $t.ClearPFPFID = this.ClearPFPFID, $t.ClearPFID = this.ClearPFID, $t.Caption = this.Caption, $t.TimeStamp = this.TimeStamp, $t.BUID = this.BUID, $t.DataModule = this.DataModule, $t.Functions = this.Functions, $t.Design = this.Design, $t.Description = this.Description, $t.DescriptionMarks = this.DescriptionMarks, $t.IsMainMenu = this.IsMainMenu, $t.IsF4 = this.IsF4, $t.TemplateName = this.TemplateName, $t);

                return f;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Function", {
        statics: {
            fields: {
                fullBUID: null,
                AvailableColorsHex: null
            },
            ctors: {
                init: function () {
                    this.fullBUID = System.Array.init(["825666,10", "15600296,10", "14734745,10", "14734748,10", "14734750,10", "15600294,10", "15600292,10", "15600290,10", "15600288,10", "15600286,10", "15600284,10", "15600299,10", "16161295,10", "2087526,9", "27474808,10", "29178050,10", "29733131,10", "30624982,10"], System.String);
                    this.AvailableColorsHex = System.Array.init(["f15a29", "4a6fa5", "fbb03f", "f7931d", "3e5278", "808080", "91A1cf", "0FA8BC", "1E786C", "0B93D7", "C65911", "c0c0c0", "180B59", "bf211e", "598059", "4a6fa5"], System.String);
                }
            }
        },
        fields: {
            DSPFID: null,
            PFPFID: null,
            PFID: null,
            PFU: null,
            PFPFU: null,
            MasterFields: null,
            FunctionType: 0,
            SpecFunctionType: 0,
            SaveDS: 0,
            Icon: null,
            EnableExpr: null,
            VisibleExpr: null,
            BUID: null
        },
        props: {
            FunctionColorHex: {
                get: function () {
                    var index = System.Array.indexOfT(Adaptica.WebForms.Common.DataModel.Function.fullBUID, this.BUID);
                    if (index < 0) {
                        return Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex[System.Array.index(0, Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex)];
                    }
                    return Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex[System.Array.index(index % Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex.length, Adaptica.WebForms.Common.DataModel.Function.AvailableColorsHex)];
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FunctionType", {
        statics: {
            fields: {
                OpenForm: 0,
                ExecMacro: 0,
                SpecialFunction: 0
            },
            ctors: {
                init: function () {
                    this.OpenForm = 0;
                    this.ExecMacro = 1;
                    this.SpecialFunction = 2;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Header", {
        fields: {
            ReadOnly: 0,
            Read: 0,
            Insert: 0,
            Update: 0,
            Delete: 0,
            SaveMode: 0,
            InsertMode: 0,
            FieldDefs: null,
            Filters: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
                this.Read = 1;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Record", {
        fields: {
            RecID: null,
            RecNo: 0,
            Update: 0,
            Delete: 0,
            Flags: 0,
            MasterIDParent: null,
            Event: 0,
            FieldValues: null
        },
        ctors: {
            ctor: function () {
                this.$initialize();
                this.FieldValues = System.Array.init(0, null, Adaptica.WebForms.Common.DataModel.FieldValue);
                this.Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum", {
        $kind: "nested enum",
        statics: {
            fields: {
                None: 0,
                Insert: 1,
                Update: 2,
                Delete: 3
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.SpecFunctionType", {
        statics: {
            fields: {
                Save: 0,
                Cancel: 0,
                SaveAndInsert: 0
            },
            ctors: {
                init: function () {
                    this.Save = 0;
                    this.Cancel = 1;
                    this.SaveAndInsert = 2;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.UIText", {
        fields: {
            Icon: null,
            Text: null,
            ID: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Button", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem,Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            MasterFields: null,
            FontStyle: 0,
            FontColor: null,
            EnableExpr: null
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Edit", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem,Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            FontStyle: 0,
            FontColor: null
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Grid", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem],
        fields: {
            GridColumns: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.GridColumn", {
        inherits: [Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            Action: null,
            RelatePrevious: 0,
            FieldName: null,
            FontStyle: 0,
            FontColor: null,
            Type: 0,
            Order: 0
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
                this.Order = 2147483647;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Image", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem],
        ctors: {
            ctor: function () {
                this.$initialize();
                Adaptica.WebForms.Common.DataModel.ContainerItem.ctor.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Label", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem,Adaptica.WebForms.Common.DataModel.IContainerItemFont],
        fields: {
            FontStyle: 0,
            FontColor: null
        },
        alias: [
            "FontStyle", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontStyle",
            "FontColor", "Adaptica$WebForms$Common$DataModel$IContainerItemFont$FontColor"
        ],
        ctors: {
            init: function () {
                this.FontStyle = 0;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.Memo", {
        inherits: [Adaptica.WebForms.Common.DataModel.ContainerItem],
        ctors: {
            ctor: function () {
                this.$initialize();
                Adaptica.WebForms.Common.DataModel.ContainerItem.ctor.call(this);
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,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
