Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ActionSheet", {
        statics: {
            methods: {
                DisplayActionSheet: function (triggerEl, title, cancel, destruction, callback, buttons) {
                    var $t;
                    if (buttons === void 0) { buttons = []; }
                    var CloseSheet = null;
                    var triggerElement = null;
                    var selector;
                    if (((selector = Bridge.as(triggerEl, System.String))) != null) {
                        triggerElement = Bridge.as($(selector).get(0), HTMLElement);
                    } else {
                        var el;
                        if (((el = Bridge.as(triggerEl, HTMLElement))) != null) {
                            triggerElement = el;
                        }
                    }
                    if (triggerElement == null) {
                        return;
                    }

                    var backdrop = $("<div class='action-sheet-backdrop'></div>");
                    var sheet = $("<div class='action-sheet'></div>");
                    var list = $("<div class='list-group list-group-flush mb-0'></div>");

                    if (!System.String.isNullOrEmpty(title)) {
                        list.append(System.String.format("<div class='list-group-item title'>{0}</div>", [title]));
                    }

                    if (buttons != null) {
                        $t = Bridge.getEnumerator(buttons);
                        try {
                            while ($t.moveNext()) {
                                var btn = $t.Current;
                                list.append(System.String.format("<div class='list-group-item wf-action-sheet-item' data-action='{0}'>{1}</div>", btn, btn));
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }
                    /* 
                               if (!string.IsNullOrEmpty(destruction))
                               {
                                   list.Append($"<div class='list-group-item wf-action-sheet-item destruct' data-action='{destruction}'>{destruction}</div>");
                               }

                               if (!string.IsNullOrEmpty(cancel))
                               {
                                   list.Append($"<div class='list-group-item wf-action-sheet-item cancel' data-action='{cancel}'>{cancel}</div>");
                               }
                    */
                    if (!System.String.isNullOrEmpty(cancel) || !System.String.isNullOrEmpty(destruction)) {
                        var row = "<div class='list-group-item p-0'><div style='display:flex; width:100%;'>";

                        if (!System.String.isNullOrEmpty(destruction)) {
                            row = (row || "") + (((System.String.format("<div style='flex:1; text-align:center; padding:8px; cursor:pointer;' ", null) || "") + (System.String.format("class='wf-action-sheet-item destruct' data-action='{0}'>{1}</div>", destruction, destruction) || "")) || "");
                        }

                        if (!System.String.isNullOrEmpty(cancel)) {
                            row = (row || "") + (((System.String.format("<div style='flex:1; text-align:center; padding:8px; cursor:pointer;' ", null) || "") + (System.String.format("class='wf-action-sheet-item cancel' data-action='{0}'>{1}</div>", cancel, cancel) || "")) || "");
                        }

                        row = (row || "") + "</div></div>";

                        list.append(row);
                    }

                    sheet.append(list);
                    $("body").append(backdrop).append(sheet);

                    var rect = triggerElement.getBoundingClientRect();
                    var sheetWidth = sheet.outerWidth();
                    var sheetHeight = sheet.outerHeight();
                    var viewportWidth = window.innerWidth;
                    var viewportHeight = window.innerHeight;

                    var top, left;


                    if (rect.bottom + sheetHeight <= viewportHeight) {
                        top = rect.bottom + window.scrollY;
                    } else {
                        var spaceAbove = rect.top + window.scrollY;
                        if (spaceAbove >= sheetHeight) {
                            top = rect.top - sheetHeight + window.scrollY;
                        } else {
                            top = (((window.scrollY + viewportHeight) | 0) - sheetHeight) | 0;
                            if (top < 0) {
                                top = 0;
                            }
                        }
                    }

                    if (rect.left + sheetWidth <= viewportWidth) {
                        left = rect.left + window.scrollX;
                    } else {
                        left = rect.right - sheetWidth + window.scrollX;
                    }

                    sheet.css({ top: System.Double.format(top) + "px", left: System.Double.format(left) + "px" });

                    backdrop.fadeIn(100);
                    window.setTimeout(function () {
                        sheet.addClass("show");
                    }, 1);
                    CloseSheet = function () {
                        sheet.removeClass("show");
                        backdrop.fadeOut(100, function () {
                            backdrop.remove();
                        });
                        window.setTimeout(function () {
                            sheet.remove();
                        }, 150);
                    };

                    sheet.on("click", ".wf-action-sheet-item", function (ev) {
                        var action = Bridge.cast(ev.currentTarget, HTMLElement).getAttribute("data-action");
                        CloseSheet();
                        !Bridge.staticEquals(callback, null) ? callback(action) : null;
                    });

                    backdrop.on("click", function () {
                        var $t1;
                        CloseSheet();
                        !Bridge.staticEquals(callback, null) ? callback(($t1 = cancel, $t1 != null ? $t1 : null)) : null;
                    });

                    document.addEventListener("keydown", function (e) {
                        var $t1;
                        var kev = e;
                        if (Bridge.referenceEquals(kev.key, "Escape")) {
                            CloseSheet();
                            !Bridge.staticEquals(callback, null) ? callback(($t1 = cancel, $t1 != null ? $t1 : null)) : null;
                        }
                    });


                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ViewBase", {
        inherits: [System.IDisposable],
        fields: {
            _control: null,
            _required: null,
            _infoIcon: null,
            _clearContentElem: null,
            _clearContentClicked: false,
            _changeHandlers: null,
            FormControl: null,
            EditControl: null,
            DataItem: null,
            Dataset: null,
            FieldDef: null,
            Record: null,
            FieldName: null,
            _id: null,
            Parent: null,
            _mainControl: null,
            IsCreatingControl: false,
            IsEditing: false
        },
        props: {
            ControlId: {
                get: function () {
                    return this._id;
                }
            },
            MainControl: {
                get: function () {
                    var $t;
                    if ((this._mainControl == null) || (this._mainControl.length === 0)) {
                        this._mainControl = ($t = this.Parent) != null ? $t.find(System.String.format("#{0}", [this.ControlId])) : null;
                        if (System.Nullable.eq((this._mainControl != null ? this._mainControl.length : null), 0)) {
                            this._mainControl = null;
                        }
                    }

                    return this._mainControl;
                },
                set: function (value) {
                    this._mainControl = value;
                }
            },
            IsRequired: {
                get: function () {
                    return this.EditControl.IsRequired;
                }
            },
            IsReadOnly: {
                get: function () {
                    return this.EditControl.IsReadOnly;
                }
            },
            Value: {
                get: function () {
                    var $t;
                    return ($t = this.Record) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue($t, this.FieldDef) : null;
                }
            },
            IsEnabled: {
                get: function () {
                    return !this.MainControl.hasClass("disabled");
                }
            }
        },
        alias: ["Dispose", "System$IDisposable$Dispose"],
        ctors: {
            init: function () {
                this._changeHandlers = new (System.Collections.Generic.List$1(Function)).ctor();
            },
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                this.FormControl = formControl;
                this.EditControl = editControl;
                this.DataItem = dataItem;
                this.Dataset = ds;
                this.FieldDef = fieldDef;
                this.Record = rec;
                this.FieldName = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(fieldDef.Name);
                this._id = (this.FormControl.CreateUniqueControlId() || "") + (System.String.format("_ctrl_{0}", [this.FieldName]) || "");
            }
        },
        methods: {
            GetControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this._control == null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.CreateControlInternal();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        this._control = $taskResult1;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateControlInternal: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    lbl, 
                    $t, 
                    ctrl, 
                    ctrlWrap, 
                    prnt, 
                    $async_e, 
                    $async_e1, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        this.IsCreatingControl = true;
                                        
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        this.Parent = $(document.createElement("div")).addClass("form-group col-auto mb-auto wf-control");

                                        lbl = $(($t = document.createElement("label"), $t.htmlFor = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.ControlId), $t.innerHTML = this.FieldDef.Label, $t)).appendTo(this.Parent);

                                        this._required = $("<span>").addClass("wf-required").html("*");

                                        if (!this.IsRequired) {
                                            this._required.addClass("wf-hidden");
                                        }

                                        if (!System.String.isNullOrEmpty(this.FieldDef.Description)) {
                                            this._infoIcon = $("<span>").addClass("wf-tooltip-icon fas fa-info-circle").attr("title", System.String.replaceAll(this.FieldDef.Description, "\n", "<br>")).attr("data-toggle", "tooltip").attr("data-boundary", "window");

                                            this._infoIcon.tooltip({ trigger: "hover", placement: "auto", html: true, title: System.String.replaceAll(this.FieldDef.Description, "\n", "<br>") });
                                        }

                                        $task1 = this.CreateControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        ctrl = $taskResult1;

                                        if (ctrl != null) {
                                            if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon, this.DataItem.Action)) {
                                                $returnValue = ctrl;
                                                $step = 3;
                                                continue;
                                            }

                                            if (this.MainControl == null) {
                                                this.MainControl = ctrl.find((System.String.format("#", null) || "") + (this.ControlId || ""));
                                            }

                                            if (this.EditControl.CreateControlOnly) {
                                                if (Bridge.referenceEquals(ctrl, this.MainControl)) {
                                                    ctrlWrap = $("<span>").append(ctrl);

                                                    if (this._infoIcon != null) {
                                                        this.Parent.append(this._infoIcon);
                                                    }

                                                    ctrlWrap.append(this._required);

                                                    ctrl = ctrlWrap;
                                                } else {
                                                    prnt = this.MainControl.parent();

                                                    if (this._infoIcon != null) {
                                                        prnt.append(this._infoIcon);
                                                    }

                                                    prnt.append(this._required);
                                                }

                                                this.SetChangeHandler();
                                                $returnValue = ctrl;
                                                $step = 3;
                                                continue;
                                            }

                                            if (this._infoIcon != null) {
                                                this.Parent.append(this._infoIcon);
                                            }

                                            this.Parent.append(this._required).append(ctrl);
                                        }

                                        this.SetChangeHandler();

                                        $returnValue = this.Parent;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this.IsCreatingControl = false;

                                        if ($jumpFromFinally > -1) {
                                            $step = $jumpFromFinally;
                                            $jumpFromFinally = null;
                                        } else if ($async_e) {
                                            $tcs.setException($async_e);
                                            return;
                                        } else if (Bridge.isDefined($returnValue)) {
                                            $tcs.setResult($returnValue);
                                            return;
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            if ($step >= 1 && $step <= 2) {
                                $step = 3;
                                $asyncBody();
                                return;
                            }
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AppendClearContent: function (inputElem) {
                this._clearContentElem = $("<div>");
                this._clearContentElem.addClass("input-group-append input-group-text del-icon wf-hidden").on("click", Bridge.fn.bind(this, function (e) {
                    Adaptica.WebForms.WebApp.WebFormsApp.Log("Del icon clicked");

                    e.preventDefault();

                    if ((!this.EditControl.IsEnabled) && (this.FieldDef.SelectFunction === 0)) {
                        return;
                    }

                    this.SetControlValue("");
                    this.OnChange(null);

                    if ((inputElem != null) && (!Bridge.referenceEquals(inputElem.val(), ""))) {
                        inputElem.val("");
                    }

                    this._clearContentClicked = true;

                    Adaptica.WebForms.WebApp.Extensions.WFHide(this._clearContentElem);
                    inputElem != null ? inputElem.removeClass("wf-input-w-del") : null;
                    inputElem != null ? inputElem.focus() : null;
                })).insertAfter(inputElem);

                $("<span>").addClass("fa fa-times-circle").appendTo(this._clearContentElem);

                if (inputElem != null) {
                    inputElem.on("input", Bridge.fn.bind(this, function () {
                        if (!this.IsEditing) {
                            return;
                        }

                        if (!!((this.EditControl.AllowEdit(this.DataItem.DSPFID)) & (!Bridge.referenceEquals(inputElem.val(), "")))) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(this._clearContentElem);
                            inputElem.addClass("wf-input-w-del");
                        } else {
                            Adaptica.WebForms.WebApp.Extensions.WFHide(this._clearContentElem);
                        }
                    }));

                    inputElem.on("focus", Bridge.fn.bind(this, function () {
                        if (!!((this.EditControl.AllowEdit(this.DataItem.DSPFID)) & (!System.String.isNullOrEmpty(this.GetControlValue())))) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(this._clearContentElem);
                            inputElem.addClass("wf-input-w-del");
                        }

                    }));

                    inputElem.on("blur", Bridge.fn.bind(this, function () {
                        window.setTimeout(Bridge.fn.bind(this, function () {
                            var clicked = this._clearContentClicked;
                            this._clearContentClicked = false;
                            if (clicked) {
                                return;
                            }

                            Adaptica.WebForms.WebApp.Extensions.WFHide(this._clearContentElem);
                            inputElem.removeClass("wf-input-w-del");
                        }), 200);
                    }));
                }
            },
            SetClearContentVisibility: function (enable) { },
            SetChangeHandler: function () {
                var $t;
                ($t = this.MainControl) != null ? $t.change(Bridge.fn.bind(this, function () {
                    this.OnChange(this.GetControlValue());



                })) : null;
            },
            SetEnabled: function (enabled) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((this.MainControl == null) || (this.MainControl.length === 0)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ((this.MainControl == null) || (this.MainControl.length === 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("SetEnabled({0}), Field: {1}", Bridge.box(enabled, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                                        this.MainControl.prop("disabled", !enabled);

                                        if (enabled) {
                                            this.MainControl.removeClass("disabled");
                                        } else {
                                            this.MainControl.addClass("disabled");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("SetVisible({0}), Field: {1}", Bridge.box(visible, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                                        if (visible) {
                                            this._control.removeClass("wf-hidden");
                                        } else {
                                            this._control.addClass("wf-hidden");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetRequired: function (required) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetControl();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ((this._control == null) || (this._control.length === 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if (this._required != null) {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("SetRequired({0}), Field: {1}", Bridge.box(required, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                                            if (required) {
                                                this._required.removeClass("wf-hidden");
                                            } else {
                                                this._required.addClass("wf-hidden");
                                            }
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetControlValue: function () {
                var $t;
                return ($t = this.MainControl) != null ? $t.val() : null;
            },
            SetControlValue: function (value) {
                if (this.MainControl != null) {
                    this.MainControl.val(value);

                    this.EditControl.SetFontProperties(this.MainControl, value);

                    /* 
                                   var color = EditControl.GetTextColor(value);
                                   if (!string.IsNullOrEmpty(color))
                                   {
                                       MainControl.Css("color", color);
                                   }
                    */
                }
            },
            Focus: function () {
                if (!this.IsEnabled) {
                    return false;
                }

                window.setTimeout(Bridge.fn.bind(this, function () {
                    var $t;
                    ($t = this.MainControl) != null ? $t.focus() : null;
                }), 10);

                return true;
            },
            Change: function (handler) {
                this._changeHandlers.add(handler);
            },
            OnChange: function (value) {
                var $t;
                $t = Bridge.getEnumerator(this._changeHandlers);
                try {
                    while ($t.moveNext()) {
                        var handler = $t.Current;
                        handler(value);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            BeginEdit: function () {
                this.IsEditing = true;
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            BeforeEndEdit: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            EndEdit: function () {
                this.IsEditing = false;
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            EndFailed: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            Dispose: function () {
                var $t;

                ($t = this.MainControl) != null ? $t.off() : null;
                this._clearContentElem != null ? this._clearContentElem.off() : null;

                this._changeHandlers.clear();
                this._mainControl = null;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.IControlDataContext", {
        $kind: "interface"
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.IControl", {
        inherits: [System.IDisposable],
        $kind: "interface"
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ControlUtils", {
        statics: {
            fields: {
                IgnoreKeys: null
            },
            ctors: {
                init: function () {
                    this.IgnoreKeys = System.Array.init(["Home", "End", "PageUp", "PageDown", "Insert", "Shift", "Control", "Alt", "Clear", "Tab"], System.String);
                }
            },
            methods: {
                CreateValidId: function (s) {
                    return System.String.replaceAll(System.String.replaceAll(System.String.replaceAll(System.String.replaceAll(s, ",", "_"), "/", "_"), "+", "_"), "=", "_");
                },
                GetTextColor: function (dataItem, fieldDef, text) {
                    var item = dataItem;
                    if ((item != null ? item.FontColor : null) == null) {
                        return null;
                    }

                    return Adaptica.WebForms.WebApp.Controls.ControlUtils.GetTextColor$1(item.FontColor, fieldDef.Values, text);
                },
                GetTextColor$1: function (colors, defValues, text) {
                    var $t;
                    if (System.String.isNullOrEmpty(colors)) {
                        return null;
                    }

                    var colorCodes = System.String.split(colors, [44].map(function (i) {{ return String.fromCharCode(i); }}));

                    if ((System.String.isNullOrEmpty(defValues)) || (System.String.isNullOrEmpty(text))) {
                        return colorCodes[System.Array.index(0, colorCodes)];
                    }

                    var values = System.String.split(defValues, System.Array.init([44], System.Char).map(function (i) {{ return String.fromCharCode(i); }}), null, 0);

                    var index = ($t = System.String, System.Linq.Enumerable.from(values, $t).toList($t)).indexOf(text);

                    if (index !== -1 && index < colorCodes.length) {
                        return colorCodes[System.Array.index(index, colorCodes)];
                    }

                    return null;
                },
                SetFontProperties: function (dataItem, fieldDef, ctrl, text) {
                    var item = dataItem;
                    Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontProperties$1(item.FontColor, fieldDef != null ? fieldDef.Values : null, item.FontStyle, ctrl, text);
                },
                SetFontProperties$1: function (colors, defValues, fontStyle, ctrl, text) {
                    if (!System.String.isNullOrEmpty(colors)) {
                        var color = Adaptica.WebForms.WebApp.Controls.ControlUtils.GetTextColor$1(colors, defValues, text);
                        if (!System.String.isNullOrEmpty(color)) {
                            ctrl.css("color", color);
                        }
                    }

                    Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontStyle(ctrl, fontStyle);
                },
                SetFontStyle: function (ctrl, fontStyle) {
                    if ((fontStyle & 1) > 0) {
                        ctrl.css("font-weight", "bold");
                    }
                    if ((fontStyle & 2) > 0) {
                        ctrl.css("font-style", "italic");
                    }
                },
                CreateViewByFieldDefType: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                    var value = rec != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef) : null;

                    if (!System.String.isNullOrEmpty(value)) {
                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                            return new Adaptica.WebForms.WebApp.Controls.BlobView(formControl, editControl, dataItem, ds, fieldDef, rec);
                        }
                    }

                    var result;

                    switch (fieldDef.Type) {
                        case Adaptica.WebForms.Common.DataModel.FieldType.Bit: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.BitView(formControl, editControl, dataItem, ds, fieldDef, rec);

                                break;
                            }
                        case Adaptica.WebForms.Common.DataModel.FieldType.Enum: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.EnumView(formControl, editControl, dataItem, ds, fieldDef, rec);

                                break;
                            }
                        case Adaptica.WebForms.Common.DataModel.FieldType.Set: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.SetView(formControl, editControl, dataItem, ds, fieldDef, rec);

                                break;
                            }
                        case Adaptica.WebForms.Common.DataModel.FieldType.DateTime: 
                        case Adaptica.WebForms.Common.DataModel.FieldType.Date: 
                        case Adaptica.WebForms.Common.DataModel.FieldType.Time: 
                            {
                                result = new Adaptica.WebForms.WebApp.Controls.DateTimeView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                /* 
                                                   if (editControl.AllowEdit(dataItem.DSPFID))
                                                   {
                                                       result = new DateTimeView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                                   }
                                                   else
                                                   {
                                                       result = new EditView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                                   }
                                */

                                break;
                            }
                        default: 
                            {
                                if (Bridge.referenceEquals(dataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) {
                                    result = new Adaptica.WebForms.WebApp.Controls.EditView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                } else {
                                    result = new Adaptica.WebForms.WebApp.Controls.EditView(formControl, editControl, dataItem, ds, fieldDef, rec);
                                }

                                break;
                            }
                    }

                    return result;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.FormContainers", {
        fields: {
            Form: null,
            Top: null,
            NavBar: null,
            Common: null,
            Content: null
        },
        ctors: {
            ctor: function (form, top, navBar, common, content) {
                this.$initialize();
                this.Form = form;
                this.Top = top;
                this.NavBar = navBar;
                this.Common = common;
                this.Content = content;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs", {
        $kind: "nested class",
        fields: {
            Action: null
        },
        ctors: {
            ctor: function (Action) {
                this.$initialize();
                System.Object.call(this);
                this.Action = Action;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.BitView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        fields: {
            _input: null
        },
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $t;
                this.MainControl = (this._input = $(($t = document.createElement("input"), $t.id = this.ControlId, $t.type = "checkbox", $t)).attr("data-toggle", "toggle").attr("data-style", "round"));

                if (Bridge.referenceEquals(this.Value, "1")) {
                    this._input.attr("checked", "checked");
                }

                var result = $("<div>").addClass("input-group").append(this._input);

                var onText = "on";
                var offText = "off";
                if (!System.String.isNullOrEmpty(this.FieldDef.DisplayValues)) {
                    var dv = System.String.split(this.FieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                    offText = dv[System.Array.index(0, dv)];
                    onText = dv[System.Array.index(1, dv)];
                }

                eval(System.String.format("this._input.bootstrapToggle({{ size: 'sm', on: '{0}', off: '{1}' }});", onText, offText));

                return System.Threading.Tasks.Task.fromResult(result, $);
            },
            SetEnabled: function (enable) {
                if (enable) {
                    this.MainControl.bootstrapToggle('enable');
                } else {
                    this.MainControl.bootstrapToggle('disable');
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            GetControlValue: function () {
                var ch = this.MainControl.prop("checked");
                return (ch) ? "1" : "0";
            },
            SetControlValue: function (value) {
                var item = this._input;

                var isDisabled = item.prop("disabled") || item.prop("readonly");
                if (isDisabled) {
                    item.bootstrapToggle('enable');
                }

                if (System.String.equals(("1"), value)) {
                    item.bootstrapToggle('on');
                } else {
                    item.bootstrapToggle('off');
                }

                if (isDisabled) {
                    item.bootstrapToggle('disable');
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.BlobView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $t;
                var img = ($t = new Image(), $t.src = "data:image/png;base64," + (this.Value || ""), $t.className = "wf-dataImage", $t);

                return System.Threading.Tasks.Task.fromResult($(document.createElement("div")).addClass("form-group col-auto mb-auto wf-control wf-blob").append(img), $);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ControlBase", {
        inherits: [Adaptica.WebForms.WebApp.Controls.IControl,Adaptica.WebForms.WebApp.Controls.IControlDataContext],
        fields: {
            FieldName: null,
            ControlId: null,
            FormControl: null,
            DataItem: null,
            CurrentRecord: null,
            MainControl: null,
            View: null,
            IsEditing: false,
            SubControls: null,
            IsShown: false,
            _dset: null,
            _fieldDef: null,
            CreateControlOnly: false,
            IsDisposed: false
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    return false;
                }
            },
            NeedsProcessDataOnInsert: {
                get: function () {
                    return this.FormControl.NeedsProcessDataOnInsert;
                }
            },
            Dataset: {
                get: function () {
                    var $t;
                    if ((this._dset == null) && (!System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null))) {
                        this._dset = this.FormControl.CurrencyManager.GetCurrentDataset(this.DataItem.DSPFID);
                    }

                    return this._dset;
                }
            },
            FieldDef: {
                get: function () {
                    var $t;
                    if ((this._fieldDef == null) && (this.DataItem != null)) {
                        var header = ($t = this.Dataset) != null ? $t.Header : null;
                        this._fieldDef = header != null ? System.Linq.Enumerable.from(header.FieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault(Bridge.fn.bind(this, function (fld) {
                                return Bridge.referenceEquals(fld.Name, this.DataItem.FieldName);
                            }), null) : null;
                    }

                    return this._fieldDef;
                }
            },
            Value: {
                get: function () {
                    var $t, $t1;
                    if (((($t = this.DataItem) != null ? $t.DSPFID : null) == null) || (this.CurrentRecord == null)) {
                        return null;
                    }

                    return ($t1 = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1($t1, this.DataItem.FieldName) : null;
                },
                set: function (value) {
                    if ((this.IsEnabled) && (this.CurrentRecord != null)) {
                        if ((this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) && (Bridge.referenceEquals(value, "-1"))) {
                            value = null;
                        }

                        if (Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(this.CurrentRecord, this.FieldDef, value)) {
                        }
                    }
                }
            },
            Text: {
                get: function () {
                    var $t, $t1;
                    if (((($t = this.DataItem) != null ? $t.DSPFID : null) == null) || (this.CurrentRecord == null)) {
                        return null;
                    }

                    return ($t1 = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue($t1, this.FieldDef) : null;
                },
                set: function (value) {
                    if ((this.IsEnabled) && (this.CurrentRecord != null)) {
                        if (Adaptica.WebForms.Common.DataModel.RecordHelper.SetFieldValue(this.CurrentRecord, this.FieldDef, value)) {
                        }
                    }
                }
            },
            TextColor: {
                get: function () {
                    return this.GetTextColor(this.Text);
                }
            },
            IsEnabled: {
                get: function () {
                    var $t;
                    return (this.FormControl.EditMode) && this.AllowEdit(($t = this.DataItem) != null ? $t.DSPFID : null);
                }
            },
            IsVisible: {
                get: function () {
                    var $t, $t1;
                    return (this.FieldDef.Hidden === 0) && ((this.CurrentRecord == null) || (($t = Adaptica.WebForms.Common.DataModel.RecordHelper.IsFieldValueVisible(this.CurrentRecord, ($t1 = this.DataItem) != null ? $t1.FieldName : null), $t != null ? $t : true)));
                }
            },
            IsRequired: {
                get: function () {
                    var $t;
                    return (this.FieldDef.Required !== 0) || ((this.CurrentRecord != null) && (System.Nullable.eq(Adaptica.WebForms.Common.DataModel.RecordHelper.IsFieldValueRequired(this.CurrentRecord, ($t = this.DataItem) != null ? $t.FieldName : null), true)));
                }
            },
            IsReadOnly: {
                get: function () {
                    return this.IsRecordReadOnly(this.CurrentRecord);
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "BeforeEndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit",
            "EndFailed", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed",
            "AllowInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert",
            "AllowEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit",
            "AllowDelete", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "NeedsProcessDataOnInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$NeedsProcessDataOnInsert",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "IsValid", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "CreateControlOnly", "Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this.SubControls = new (System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.ControlBase)).ctor();
                this.CreateControlOnly = false;
            },
            ctor: function (formControl, dataItem, currentRecord) {
                if (currentRecord === void 0) { currentRecord = null; }
                var $t;

                this.$initialize();
                this.FormControl = formControl;
                this.DataItem = dataItem;

                if (dataItem == null) {
                    Adaptica.WebForms.WebApp.WebFormsApp.Log("DataItem is null");
                }

                if (currentRecord != null) {
                    this.CurrentRecord = currentRecord;
                } else {
                    this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(($t = this.DataItem) != null ? $t.DSPFID : null);
                    this.FormControl.CurrencyManager.addOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedInternal));
                }

                if (this.FieldDef != null) {
                    this.FieldName = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FieldDef.Name);
                    Bridge.ensureBaseProperty(this, "ControlId").$Adaptica$WebForms$WebApp$Controls$ControlBase$ControlId = System.String.format("ctrl_{0}", [this.FieldName]);
                }
            }
        },
        methods: {
            CurrentRecordChangedInternal: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $t, 
                    $t1, 
                    $t2, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1,2,3,4], $step);
                            switch ($step) {
                                case 0: {
                                    if (System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null)) {
                                        $step = 1;
                                        continue;
                                    } 
                                    $step = 3;
                                    continue;
                                }
                                case 1: {
                                    $task1 = this.CurrentRecordChanged(sender, e).wait();
                                    $step = 2;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 2: {
                                    $task1.getAwaitedResult();
                                    return;
                                }
                                case 3: {
                                    if (e != null) {
                                        if ((!Bridge.referenceEquals((($t1 = this.DataItem) != null ? $t1.DSPFID : null), e.DSPFID)) || ((this.MainControl == null) && (this.View == null))) {
                                            return;
                                        }
                                    }

                                    this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecord(($t2 = this.DataItem) != null ? $t2.DSPFID : null);
                                    $task2 = this.CurrentRecordChanged(sender, e).wait();
                                    $step = 4;
                                    if ($task2.isCompleted()) {
                                        continue;
                                    }
                                    $task2.continue($asyncBody);
                                    return;
                                }
                                case 4: {
                                    $task2.getAwaitedResult();
                                    window.setTimeout(Bridge.fn.bind(this, function () {
                                        var $step = 0,
                                            $task1, 
                                            $jumpFromFinally, 
                                            $asyncBody = Bridge.fn.bind(this, function () {
                                                for (;;) {
                                                    $step = System.Array.min([0,1], $step);
                                                    switch ($step) {
                                                        case 0: {
                                                            $task1 = this.SetControlProperties();
                                                            $step = 1;
                                                            if ($task1.isCompleted()) {
                                                                continue;
                                                            }
                                                            $task1.continue($asyncBody);
                                                            return;
                                                        }
                                                        case 1: {
                                                            $task1.getAwaitedResult();
                                                            return;
                                                        }
                                                        default: {
                                                            return;
                                                        }
                                                    }
                                                }
                                            }, arguments);

                                        $asyncBody();
                                    }), 100);
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            GetFunction: function () {
                return System.Linq.Enumerable.from(this.FormControl.FormData.Functions, Adaptica.WebForms.Common.DataModel.Function).firstOrDefault(Bridge.fn.bind(this, function (fn) {
                        var $t;
                        return Bridge.referenceEquals(fn.PFPFID, (($t = this.DataItem) != null ? $t.PFPFID : null));
                    }), null);
            },
            Focus: function () {
                var $t;
                if ((this.IsEnabled) && (this.MainControl != null)) {
                    if (this.View != null) {
                        return this.View.Focus();
                    }
                    /* 
                                   Window.SetTimeout(() =>
                                   {
                                       MainControl?.Focus();
                                   }, 100);
                    */
                    ($t = this.MainControl) != null ? $t.focus() : null;

                    return true;
                }

                return false;
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        this.SubControls.ForEach(Bridge.fn.bind(this, function (ctrl) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = ctrl.BeginEdit();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        this.IsEditing = true;
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeforeEndEdit: function () {
                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        this.SubControls.ForEach(Bridge.fn.bind(this, function (ctrl) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = ctrl.EndEdit();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        this.IsEditing = false;
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndFailed: function () {
                this.SubControls.ForEach(Bridge.fn.bind(this, function (ctrl) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = ctrl.EndFailed();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }));

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            AllowInsert: function (DSPFID) {
                var $t, $t1, $t2;
                if (System.String.isNullOrEmpty(DSPFID)) {
                    DSPFID = ($t = this.DataItem) != null ? $t.DSPFID : null;
                }

                if ((System.String.isNullOrEmpty(($t1 = this.DataItem) != null ? $t1.DSPFID : null)) || (!Bridge.referenceEquals((($t2 = this.DataItem) != null ? $t2.DSPFID : null), DSPFID))) {
                    return false;
                }

                return (this.Dataset != null) && (!Adaptica.WebForms.Common.DataModel.DatasetHelper.IsReadOnly(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanInsert(this.Dataset));
            },
            AllowEdit: function (DSPFID) {
                var $t, $t1;
                if ((System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null)) || (!Bridge.referenceEquals((($t1 = this.DataItem) != null ? $t1.DSPFID : null), DSPFID))) {
                    return false;
                }

                if ((this.Dataset == null) || (this.CurrentRecord == null) || (this.FieldDef == null)) {
                    return false;
                }

                var result = (!Adaptica.WebForms.Common.DataModel.DatasetHelper.IsReadOnly(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanUpdate(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.RecordHelper.CanUpdate(this.CurrentRecord)) && ((!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(this.FieldDef)) && (System.Nullable.neq(Adaptica.WebForms.Common.DataModel.RecordHelper.IsFieldReadOnly(this.CurrentRecord, this.FieldDef.Name), true)));

                Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("AllowEdit({0}), Field: {1}", Bridge.box(result, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                return result;
            },
            AllowDelete: function (DSPFID) {
                var $t, $t1;
                if ((System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.DSPFID : null)) || (!Bridge.referenceEquals((($t1 = this.DataItem) != null ? $t1.DSPFID : null), DSPFID))) {
                    return false;
                }

                return (this.Dataset != null) && (!Adaptica.WebForms.Common.DataModel.DatasetHelper.IsReadOnly(this.Dataset)) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanDelete(this.Dataset)) && (this.CurrentRecord != null) && (Adaptica.WebForms.Common.DataModel.RecordHelper.CanDelete(this.CurrentRecord));
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                var $t;
                return Bridge.referenceEquals((($t = this.DataItem) != null ? $t.DSPFID : null), DSPFID);
            },
            RaiseDataChanged: function () {

                this.CurrentRecordChangedInternal(null, null);

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            OnFormCreated: function () { },
            OnFormActivated: function () { },
            OnFormDeactivated: function () { },
            OnShow: function () {
                this.IsShown = true;
            },
            OnHide: function () {
                this.IsShown = false;
            },
            GetTextColor: function (text) {
                return Adaptica.WebForms.WebApp.Controls.ControlUtils.GetTextColor(this.DataItem, this.FieldDef, text);
            },
            SetFontProperties: function (control, text) {
                Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontProperties(this.DataItem, this.FieldDef, control, text);
            },
            IsValid: function (sb) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $t, 
                    ctrl, 
                    isValid, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7], $step);
                                switch ($step) {
                                    case 0: {
                                        result = true;
                                        $t = Bridge.getEnumerator(this.SubControls);
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        if ($t.moveNext()) {
                                            ctrl = $t.Current;
                                            $step = 2;
                                            continue;
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = ctrl.IsValid(sb);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        isValid = $taskResult1;
                                        if (!isValid) {
                                            result = false;
                                            $step = 4;
                                            continue;
                                        }
                                        $step = 1;
                                        continue;
                                    }
                                    case 4: {
                                        if (!result) {
                                            $tcs.setResult(result);
                                            return;
                                        }

                                        if (this.FieldDef == null) {
                                            $tcs.setResult(true);
                                            return;
                                        }

                                        if ((this.IsRequired) && (System.String.isNullOrEmpty(this.Text)) && (this.CurrentRecord != null)) {
                                            $step = 5;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 5: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("ValidationRequiredField", [this.FieldDef.Label]);
                                        $step = 6;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        sb.appendLine($taskResult2);
                                        result = false;
                                        $step = 7;
                                        continue;
                                    }
                                    case 7: {
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsRecordReadOnly: function (rec) {
                var $t;
                if (this.FieldDef == null) {
                    return false;
                }

                var readOnly = (this.Dataset.Header.ReadOnly > 0) || (this.FieldDef.SelectFunction > 0);
                if (!readOnly) {
                    var fieldValue = rec != null && ($t = rec.FieldValues) != null ? System.Linq.Enumerable.from($t, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(Bridge.fn.bind(this, function (fv) {
                            return Bridge.referenceEquals(fv.Name, this.FieldDef.Name);
                        }), null) : null;

                    readOnly = (fieldValue != null) ? (System.Nullable.gt((System.Nullable.bor(this.FieldDef.ReadOnly, fieldValue.ReadOnly)), 0)) : (this.FieldDef.ReadOnly > 0);
                }

                return readOnly;
            },
            SetControlProperties: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (System.String.isNullOrEmpty(($t = this.DataItem) != null ? $t.FieldName : null)) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        $task1 = this.SetVisible(this.IsVisible);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.SetEnabled(this.IsEnabled);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $task3 = this.SetRequired(this.IsRequired);
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetEnabled: function (enabled) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.View.SetEnabled(enabled);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 3: {
                                        if (this.MainControl != null) {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("SetEnabled({0}), Field: {1}", Bridge.box(enabled, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                                            this.MainControl.prop("disabled", !enabled);
                                            if (enabled) {
                                                this.MainControl.removeClass("disabled");
                                            } else {
                                                this.MainControl.addClass("disabled");
                                            }
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.View.SetVisible(visible);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 3: {
                                        if (this.MainControl != null) {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("SetVisible({0}), Field: {1}", Bridge.box(visible, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                                            if (visible) {
                                                this.MainControl.removeClass("wf-hidden");
                                            } else {
                                                this.MainControl.addClass("wf-hidden");
                                            }
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetRequired: function (required) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.SetRequired(required);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Dispose: function () {
                this.FormControl.CurrencyManager.removeOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedInternal));
                this._fieldDef = null;
                this._dset = null;
                this.View = null;
                this.MainControl = null;
                this.CurrentRecord = null;
                this.DataItem = null;
                this.FormControl = null;
                this.IsDisposed = true;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.DateTimeView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    editControl, 
                    format, 
                    qiFormat, 
                    icon, 
                    $t, 
                    id, 
                    disabled, 
                    color, 
                    htmlTemplate, 
                    group, 
                    inputElem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this._infoIcon != null) {
                                            this.Parent.append(this._infoIcon);
                                        }

                                        this.Parent.append(this._required);

                                        editControl = this.EditControl;
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemDateTimeJSFormat");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        format = $taskResult1;
                                        qiFormat = "YYYY-MM-DD HH:mm:ss";
                                        icon = "fa-calendar";
                                        $t = this.FieldDef.Type;
                                        if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Date) {
                                            $step = 2;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                                            $step = 4;
                                            continue;
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 2: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemDateJSFormat");
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        format = $taskResult2;
                                        qiFormat = "YYYY-MM-DD";
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemTimeJSFormat");
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        format = $taskResult3;
                                        qiFormat = "HH:mm:ss";
                                        icon = "fa-clock";
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        id = this.ControlId;
                                        disabled = this.IsReadOnly ? " disabled=\"disabled\"" : "";

                                        color = this.EditControl.GetTextColor(this.Value);
                                        if (!System.String.isNullOrEmpty(color)) {
                                            color = System.String.format(" style=\"color: {0}\"", [color]);
                                        }

                                        htmlTemplate = System.String.format("\r\n<div class=\"input-group\">\r\n  <div class=\"input-group date\" id=\"{0}_wrap\" data-target-input=\"nearest\">\r\n    <input id=\"{1}\" type=\"text\" class=\"form-control datetimepicker-input\" data-target=\"#{2}_wrap\"{3}{4}/>\r\n    <div id=\"{5}_append\" class=\"input-group-append\" data-target=\"#{6}_wrap\" data-toggle=\"datetimepicker\">\r\n      <div class=\"input-group-text\"><i class=\"fa {7}\"></i></div>\r\n    </div>\r\n  </div>\r\n</div>", id, id, id, disabled, color, id, id, icon);

                                        if (this.EditControl.CreateControlOnly) {
                                            this.Parent = $("<span>");
                                        }


                                        group = $(htmlTemplate);
                                        group.appendTo(this.Parent);

                                        var mmnt = null;
                                        if (!System.String.isNullOrEmpty(this.Value)) {
                                            mmnt = moment(this.Value, format);
                                        }

                                        $(function () {
                                          var elem = $('#' + id + '_wrap');
                                          elem.datetimepicker({ defaultDate: mmnt, format: format });
                                          elem.on('change.datetimepicker', function (e) { editControl.Value = moment(e.date).format(qiFormat); });
                                        });

                                        inputElem = group.find("input.datetimepicker-input");

                                        this.AppendClearContent(inputElem);

                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetChangeHandler: function () {
                var $t;
                ($t = this.MainControl) != null ? $t.change(Bridge.fn.bind(this, function (e) {
                    var v = this.GetControlValue();

                    if (System.String.isNullOrEmpty(v)) {
                        $('#' + this.ControlId + '_wrap').datetimepicker('clear');
                    }

                    this.OnChange(v);
                    e.preventDefault();
                    e.stopImmediatePropagation();













                })) : null;
            },
            SetEnabled: function (enable) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    append, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        append = this.Parent.find(System.String.format("#{0}_append", [this.ControlId]));
                                        if (enable) {
                                            append.show();
                                        } else {
                                            append.hide();
                                        }

                                        this.SetClearContentVisibility(enable);

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetEnabled.call(this, enable);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.EditView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        statics: {
            fields: {
                _intRegex: null,
                _floatRegex: null
            },
            ctors: {
                init: function () {
                    this._intRegex = new RegExp("^(\\+|-)?\\d*$");
                    this._floatRegex = new RegExp("^(\\+|-)?\\d*(\\.,)?\\d*$");
                }
            },
            methods: {
                SetFontIconValue: function (icon, value) {
                    if (System.String.isNullOrEmpty(value)) {
                        icon.html("");
                        return;
                    }

                    var isGMI = System.Text.RegularExpressions.Regex.isMatch(value, "^0*E[0-9A-F]{3}$", 1);
                    var isMDI = System.Text.RegularExpressions.Regex.isMatch(value, "^0*F[0-9A-F]{4}$", 1);

                    if ((!isGMI) && (!isMDI)) {
                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("Font icon \"{0}\" not found.", [value]));
                        return;
                    }

                    var className = (isGMI) ? "material-icons" : "mdi-set";

                    icon.attr("data-code", value);
                    Adaptica.WebForms.WebApp.Extensions.WFShow(icon.prop("class", className).addClass("wf-font-icon").html(System.String.format("&#x{0};", [value])));
                }
            }
        },
        fields: {
            _f4Elem: null,
            _icon: null,
            _groupIconInnerDiv: null,
            _groupIconDiv: null,
            _uploadInput: null,
            _uploadIcon: null,
            _allowedKeys: null,
            _fileName: null
        },
        alias: ["Dispose", "System$IDisposable$Dispose"],
        ctors: {
            init: function () {
                this._allowedKeys = System.Array.init([8, 9, 35, 36, 37, 39, 46], System.Int32);
            },
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    inputElem, 
                    inputGroup, 
                    result, 
                    $t, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8,9,10], $step);
                                switch ($step) {
                                    case 0: {
                                        inputElem = null;

                                        inputGroup = $("<div>").addClass("input-group");

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon, this.DataItem.Action)) {
                                            result = this.CreateFontIcon();
                                            this.MainControl = result;
                                            this.EditControl.CreateControlOnly = true;
                                            $tcs.setResult(result);
                                            return;
                                        }

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature, this.DataItem.Action)) {
                                        } else {
                                            inputElem = $(($t = document.createElement("input"), $t.id = this.ControlId, $t.className = "form-control wf-edit", $t.value = this.Value, $t.required = this.IsRequired, $t.disabled = this.IsReadOnly, $t)).appendTo(inputGroup);

                                            if (this.IsRequired) {
                                                inputElem.addClass("wf-required");
                                            }

                                            this.EditControl.SetFontProperties(inputElem, this.Value);
                                        }

                                        this.AppendClearContent(inputElem);

                                        if (this.FieldDef.SelectFunction > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        this.AppendF4(inputGroup, inputElem);
                                        $step = 7;
                                        continue;
                                    }
                                    case 2: {
                                        if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachmentOnline))) {
                                            $step = 3;
                                            continue;
                                        } else  {
                                            $step = 5;
                                            continue;
                                        }
                                    }
                                    case 3: {
                                        $task1 = this.AppendUpload(inputGroup, inputElem);
                                        $step = 4;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task1.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        if (!System.String.isNullOrEmpty(this.DataItem.Action)) {
                                            this.AppendAction(inputGroup, inputElem);
                                        }
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        if ((this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Integer) || (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float)) {
                                            inputElem.keydown(Bridge.fn.bind(this, function (keyboardEvent) {
                                                this.CheckKeyIsNumber(inputElem, keyboardEvent, this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float);
                                            }));

                                            inputElem.on("paste", Bridge.fn.bind(this, function () {
                                                window.setTimeout(Bridge.fn.bind(this, function () {
                                                    var $t1;
                                                    var isDecimal = this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float;
                                                    var regex = (isDecimal) ? Adaptica.WebForms.WebApp.Controls.EditView._floatRegex : Adaptica.WebForms.WebApp.Controls.EditView._intRegex;
                                                    var val = inputElem.val();
                                                    if (!regex.test(val)) {
                                                        var sb = new System.Text.StringBuilder("", val.length);
                                                        $t1 = Bridge.getEnumerator(val);
                                                        try {
                                                            while ($t1.moveNext()) {
                                                                var chr = $t1.Current;
                                                                if ((System.Char.isDigit(chr)) || (chr === 45 || (isDecimal && (chr === 44 || chr === 46)))) {
                                                                    sb.append(String.fromCharCode(chr));
                                                                }
                                                            }
                                                        } finally {
                                                            if (Bridge.is($t1, System.IDisposable)) {
                                                                $t1.System$IDisposable$Dispose();
                                                            }
                                                        }

                                                        inputElem.val(sb.toString());
                                                    }
                                                }), 10);
                                            }));
                                            /* 
                                                           inputElem.Change(evnt =>
                                                           {
                                                               var regex = (FieldDef.Type == FieldType.Integer) ? _intRegex : _floatRegex;
                                                               var className = "wf-invalid";

                                                               if (!regex.Test(inputElem.Val()))
                                                               {
                                                                   inputElem.AddClass(className);
                                                               }
                                                               else
                                                               {
                                                                   inputElem.RemoveClass(className);
                                                               }
                                                           });
                                            */
                                        }

                                        this.MainControl = inputElem;

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature, this.DataItem.Action)) {
                                            this.MainControl = this._icon;
                                            this.EditControl.CreateControlOnly = true;
                                        }

                                        if (this.IsCurrentLocationAction()) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 10;
                                        continue;
                                    }
                                    case 8: {
                                        $task2 = this.SetEnabled(false);
                                        $step = 9;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 9: {
                                        $task2.getAwaitedResult();
                                        $step = 10;
                                        continue;
                                    }
                                    case 10: {
                                        $tcs.setResult(inputGroup);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetCurrentLocation: function () {
                var $t;
                window.navigator.geolocation.getCurrentPosition(Bridge.fn.bind(this, function (position) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        lat, 
                        $long, 
                        value, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        lat = position.coords.latitude;
                                        $long = position.coords.longitude;

                                        value = System.String.format("{0},{1}", Bridge.box(lat, System.Double, System.Double.format, System.Double.getHashCode), Bridge.box($long, System.Double, System.Double.format, System.Double.getHashCode));

                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.GetCurrentLocationText(lat, $long);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        value = $taskResult1;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this.SetControlValue(value);
                                        this.OnChange(value);
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }), function (error) { }, ($t = new Object(), $t.enableHighAccuracy = true, $t.timeout = 5000, $t));
            },
            GetCurrentLocationText: function (lat, lon) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    address, 
                    options, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        address = "";

                                        options = { url: System.String.format("https://nominatim.openstreetmap.org/reverse?lat={0}&lon={1}&format=json", Bridge.box(lat, System.Double, System.Double.format, System.Double.getHashCode), Bridge.box(lon, System.Double, System.Double.format, System.Double.getHashCode)), success: function (data, textStatus, request) {
                                            var json = data;
                                            var housenumber = System.String.isNullOrEmpty(json.house_number) ? "" : System.String.format(" {0}", [json.house_number]);
                                            address = System.String.format("{0}{1}, {2}, {3}, {4}", json.address.road, housenumber, json.address.city, json.address.postcode, json.address.country);
                                        } };

                                        $task1 = System.Threading.Tasks.Task.fromPromise($.ajax(options));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $tcs.setResult(address);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CheckKeyIsNumber: function (inputElem, evt, isDecimal) {
                var val = inputElem.val();
                var charCode = evt.which;
                var key = evt.key;

                if (System.Array.indexOfT(this._allowedKeys, charCode) > -1) {
                    return;
                }

                if (charCode === 109) {
                    var ss = evt.target.selectionStart;
                    if ((ss === 0) && (System.String.indexOf(val, String.fromCharCode(45)) === -1)) {
                        return;
                    }
                }

                if ((evt.ctrlKey && (charCode === 86 || charCode === 67))) {
                    return;
                }

                if (charCode === 45 && (evt.shiftKey || evt.ctrlKey)) {
                    return;
                }

                if ((isDecimal) && (charCode === 188 || charCode === 190)) {
                    var ss1 = evt.target.selectionStart;
                    if ((System.String.indexOf(val, String.fromCharCode(46)) === -1) && (System.String.indexOf(val, String.fromCharCode(44)) === -1) && (ss1 > 0)) {
                        return;
                    }
                }

                if (System.Char.isDigit(key.charCodeAt(0))) {
                    return;
                }

                evt.preventDefault();
            },
            AppendF4: function (inputGroup, inputElem) {
                inputElem.addClass("f4");
                inputElem.prop("readonly", true);

                this._f4Elem = $("<div>").addClass("input-group-append input-group-text f4-icon").on("click", Bridge.fn.bind(this, function (e) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        lRec, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        e.preventDefault();

                                        if (!this.EditControl.IsEnabled) {
                                            return;
                                        }

                                        lRec = (this.EditControl.IsGridEdit) ? this.Record : this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.Dataset.DSPFID);
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetSelectFunction(this.FormControl, this.Dataset.DSPFID, this.FieldDef.Name, lRec);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                })).appendTo(inputGroup);

                $("<span>").addClass("fa fa-search").appendTo(this._f4Elem);

                if (!this.EditControl.AllowEdit(this.DataItem.DSPFID)) {
                    Adaptica.WebForms.WebApp.Extensions.WFHide(this._f4Elem);
                }
            },
            AppendUpload: function (inputGroup, inputElem) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    fieldPlaceholder, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        inputElem.addClass("wf-fileUpload");
                                        inputElem.prop("readonly", true);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AttachmentButton");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        fieldPlaceholder = $taskResult1;

                                        this._uploadInput = Adaptica.WebForms.WebApp.Extensions.WFHide($(System.String.format("<input type=\"file\" id=\"{0}_upload\" placeholder=\"{1}\">", this.ControlId, fieldPlaceholder)).on("change", Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                files, 
                                                name, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1,2,3,4], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                files = (this._uploadInput.get(0)).files;
                                                                if (files.length > 0) {
                                                                    $step = 1;
                                                                    continue;
                                                                } else  {
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                            }
                                                            case 1: {
                                                                $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetAttachmentKey(files[0].name);
                                                                $step = 2;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 2: {
                                                                $taskResult1 = $task1.getAwaitedResult();
                                                                name = $taskResult1;
                                                                this.SetControlValue(name);
                                                                this.OnChange(name);
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 3: {
                                                                inputElem.prop("placeholder", fieldPlaceholder);
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 4: {
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        })).appendTo(inputGroup));

                                        this._uploadIcon = $("<div>").addClass("input-group-append input-group-text wf-fileUpload-icon").on("click", Bridge.fn.bind(this, function (e) {
                                            e.preventDefault();

                                            if (!this.EditControl.IsEnabled) {
                                                return;
                                            }

                                            this._uploadInput.click();

                                        })).appendTo(inputGroup);


                                        $("<span>").addClass("fa fa-upload").appendTo(this._uploadIcon);
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AppendAction: function (inputGroup, inputElem) {
                var iconName = "";
                switch (this.DataItem.Action) {
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIURL: 
                        {
                            iconName = "fa-external-link-alt";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIEmail: 
                        {
                            iconName = "fa-envelope";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIMap: 
                        {
                            iconName = "fa-map";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIPhone: 
                        {
                            iconName = "fa-phone";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile: 
                        {
                            iconName = "fa-paperclip";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile: 
                        {
                            iconName = "fa-print";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature: 
                        {
                            iconName = "fa-file-signature";
                            break;
                        }
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocation: 
                    case Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText: 
                        {
                            iconName = "fa-location-dot";
                            break;
                        }
                }

                if (!System.String.isNullOrEmpty(iconName)) {
                    var icon = $("<i>").addClass(System.String.format("fas {0}", [iconName]));

                    this._groupIconInnerDiv = $("<div>").addClass("input-group-text").append(icon);

                    this._groupIconDiv = $("<div>").attr("id", System.String.format("{0}-append", [this.ControlId])).addClass("input-group-append").on("click", Bridge.fn.bind(this, function (e) {
                        var $step = 0,
                            $task1, 
                            $jumpFromFinally, 
                            lRec, 
                            value, 
                            $t, 
                            dSig, 
                            $asyncBody = Bridge.fn.bind(this, function () {
                                for (;;) {
                                    $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13], $step);
                                    switch ($step) {
                                        case 0: {
                                            if (this.IsEnabled) {
                                                e.stopPropagation();
                                                e.preventDefault();
                                            }

                                            lRec = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.Dataset.DSPFID);
                                            value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(lRec, this.FieldDef);

                                            if (!System.String.isNullOrEmpty(value)) {
                                                $step = 1;
                                                continue;
                                            } 
                                            $step = 13;
                                            continue;
                                        }
                                        case 1: {
                                            $t = this.DataItem.Action;
                                            if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIURL) {
                                                $step = 2;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIEmail) {
                                                $step = 3;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIMap) {
                                                $step = 4;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIPhone) {
                                                $step = 5;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile || $t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile) {
                                                $step = 6;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature) {
                                                $step = 7;
                                                continue;
                                            }
                                            else if ($t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocation || $t === Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText) {
                                                $step = 11;
                                                continue;
                                            }
                                            $step = 12;
                                            continue;
                                        }
                                        case 2: {
                                            if (System.String.indexOf(value, "://", 0, null, 4) > -1) {
                                                window.open(value);
                                            } else {
                                                window.open(System.String.format("http://{0}", [value]));
                                            }

                                            $step = 12;
                                            continue;
                                        }
                                        case 3: {
                                            window.open(System.String.format("mailto:{0}", [value]));
                                            $step = 12;
                                            continue;
                                        }
                                        case 4: {
                                            if (System.String.startsWith(value, "http")) {
                                                window.open(value);
                                            } else {
                                                value = System.String.replaceAll(value, String.fromCharCode(59), String.fromCharCode(32));

                                                window.open(System.String.format("https://maps.google.com?q={0}", [encodeURIComponent(value)]));
                                            }

                                            $step = 12;
                                            continue;
                                        }
                                        case 5: {
                                            window.open(System.String.format("tel:{0}", [value]));
                                            $step = 12;
                                            continue;
                                        }
                                        case 6: {
                                            window.open("GetFile.ashx" + (value || ""));
                                            $step = 12;
                                            continue;
                                        }
                                        case 7: {
                                            if (!System.String.isNullOrEmpty(value)) {
                                                $step = 8;
                                                continue;
                                            } 
                                            $step = 10;
                                            continue;
                                        }
                                        case 8: {
                                            dSig = new Adaptica.WebForms.WebApp.DataSignature();
                                            dSig.OnSuccessfulSignature = Bridge.fn.bind(this, function (signatureResult) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    Adaptica.WebForms.WebApp.WebFormsApp.Log(signatureResult);
                                                                    $task1 = this.FormControl.ReloadData();
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    this.FormControl.SetNeedsReloadParents();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });

                                            $task1 = dSig.SignData(value);
                                            $step = 9;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 9: {
                                            $task1.getAwaitedResult();
                                            $step = 10;
                                            continue;
                                        }
                                        case 10: {
                                            $step = 12;
                                            continue;
                                        }
                                        case 11: {
                                            this.GetCurrentLocation();
                                            $step = 12;
                                            continue;
                                        }

                                        case 13: {
                                            return;
                                        }
                                        default: {
                                            return;
                                        }
                                    }
                                }
                            }, arguments);

                        $asyncBody();
                    }));

                    if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature)) {
                        this._groupIconInnerDiv.append(this.FieldDef.Label);

                        this._groupIconDiv.append($("<div class=\"form-group mb-auto wf-control wf-dataSignature\">").append(this._groupIconInnerDiv));

                        var lRec = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.Dataset.DSPFID);
                        var value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(lRec, this.FieldDef);
                        this.CheckSignatureButtonState(value);

                    } else {
                        this._groupIconDiv.append(this._groupIconInnerDiv);
                    }

                    var outerDiv = $("<div>").attr("id", System.String.format("{0}-wrap", [this.ControlId])).attr("data-target-input", "nearest").addClass("input-group");

                    if (inputElem != null) {
                        outerDiv.append(inputElem);
                        if (this._clearContentElem != null) {
                            outerDiv.append(this._clearContentElem);
                        }
                    }

                    outerDiv.append(this._groupIconDiv);

                    this._icon = this._groupIconDiv;

                    inputGroup.append(outerDiv);
                }
            },
            CreateFontIcon: function () {
                this._icon = $("<i>");

                Adaptica.WebForms.WebApp.Controls.EditView.SetFontIconValue(this._icon, this.Value);

                var result = $("<div class=\"form-group col-auto mb-auto wf-control\">").append(this._icon);

                return result;
            },
            SetControlValue: function (value) {
                if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon, this.DataItem.Action)) {
                    Adaptica.WebForms.WebApp.Controls.EditView.SetFontIconValue(this._icon, value);
                    return;
                }

                Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetControlValue.call(this, value);

                if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile))) {
                    if (System.String.isNullOrEmpty(value)) {
                        Adaptica.WebForms.WebApp.Extensions.WFHide(this._icon);
                    } else {
                        Adaptica.WebForms.WebApp.Extensions.WFShow(this._icon);
                    }
                }

                if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature)) {
                    this.CheckSignatureButtonState(value);
                }
            },
            CheckSignatureButtonState: function (value) {
                if (System.String.isNullOrEmpty(value)) {
                    this._groupIconInnerDiv.addClass("wf-existingSignature");
                    this._groupIconInnerDiv.removeClass("button");
                    this._groupIconDiv.addClass("wf-existingSignature");
                } else {
                    this._groupIconInnerDiv.removeClass("wf-existingSignature");
                    this._groupIconInnerDiv.addClass("button");
                    this._groupIconDiv.removeClass("wf-existingSignature");
                }
            },
            IsCurrentLocationAction: function () {
                return (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocation)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationText)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIGetCurrentLocationReadOnly));
            },
            SetEnabled: function (enable) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    value, 
                    allowEdit, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (enable && this.IsCurrentLocationAction()) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetEnabled.call(this, enable);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        value = this.GetControlValue();
                                        allowEdit = this.EditControl.AllowEdit(this.DataItem.DSPFID);

                                        if (this.FieldDef.SelectFunction > 0) {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("F4 {0} - SetEnabled({1}), AllowEdit: {2}, Value: {3}", this.DataItem.FieldName, Bridge.box(enable, System.Boolean, System.Boolean.toString), Bridge.box(allowEdit, System.Boolean, System.Boolean.toString), value));
                                        }

                                        if ((enable) && (allowEdit)) {
                                            this._f4Elem != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._f4Elem) : null;
                                            this._uploadIcon != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._uploadIcon) : null;
                                        } else {
                                            this._f4Elem != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._f4Elem) : null;
                                            this._uploadIcon != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._uploadIcon) : null;
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetRequired: function (required) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetRequired.call(this, required);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("SetRequired({0}), Field: {1}", Bridge.box(required, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                                        if (required) {
                                            this.MainControl.addClass("wf-required");
                                        } else {
                                            this.MainControl.removeClass("wf-required");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeginEdit: function () {
                var result = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.BeginEdit.call(this);

                if ((this.IsCurrentLocationAction()) && (System.String.isNullOrEmpty(this.Value))) {
                    this.GetCurrentLocation();
                }

                return result;
            },
            BeforeEndEdit: function () {
                if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachmentOnline))) {
                    this._fileName = this.Value;
                }

                return Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.BeforeEndEdit.call(this);
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    files, 
                    fd, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachment)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIAttachmentOnline))) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 1: {
                                        files = (this._uploadInput.get(0)).files;
                                        if (files.length > 0) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        fd = new FormData();
                                        fd.append("file", files[0]);
                                        fd.append("fileName", this.GetControlValue());

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.UploadAttachment(fd);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }

                                    case 5: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.EndEdit.call(this);
                                        $step = 6;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Dispose: function () {
                this._f4Elem != null ? this._f4Elem.find("*").off() : null;
                this._f4Elem = null;

                Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.Dispose.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.EnumView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        fields: {
            _selectedValue: null,
            _selectedElem: null
        },
        ctors: {
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    value, 
                    $t, 
                    $t1, 
                    fieldValues, 
                    fieldDispValues, 
                    result, 
                    id, 
                    fieldValue, 
                    fieldDisplayValue, 
                    lbl, 
                    input, 
                    color, 
                    select, 
                    $t2, 
                    jqSelect, 
                    fieldValue1, 
                    fieldDisplayValue1, 
                    option, 
                    jqOption, 
                    fontHelper, 
                    fontStyle, 
                    inputGroup, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        value = ($t = (($t1 = this.Record) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1($t1, this.FieldDef.Name) : null), $t != null ? $t : "-1");

                                        fieldValues = System.String.split(System.String.format("-1,{0}", [this.FieldDef.Values]), [44].map(function (i) {{ return String.fromCharCode(i); }}));
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        fieldDispValues = System.String.split(System.String.format("{0},{1}", $taskResult1, this.FieldDef.DisplayValues), [44].map(function (i) {{ return String.fromCharCode(i); }}));


                                        if (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.ButtonPicker) {
                                            result = $("<div>").attr("id", this.ControlId).addClass("btn-group btn-group-toggle wf-enum wf-enum-buttonPicker").attr("data-toggle", "buttons");

                                            id = this.FormControl.CreateUniqueControlId();

                                            for (var i = 0; i < fieldValues.length; i = (i + 1) | 0) {
                                                fieldValue = { v : fieldValues[System.Array.index(i, fieldValues)] };
                                                fieldDisplayValue = fieldDispValues[System.Array.index(i, fieldDispValues)];

                                                lbl = { v : $("<label>").addClass("btn btn-secondary").appendTo(result) };

                                                if (this.IsReadOnly) {
                                                    lbl.v.addClass("disabled");
                                                }

                                                input = $("<input>").attr("type", "radio").attr("name", id).attr("id", id).attr("autocomplete", "off").appendTo(lbl.v);

                                                if (Bridge.referenceEquals(value, fieldValue.v)) {
                                                    this._selectedValue = fieldValue.v;
                                                    this._selectedElem = lbl.v;

                                                    lbl.v.addClass("wf-active");

                                                    color = this.EditControl.GetTextColor(fieldValue.v);
                                                    if (!System.String.isNullOrEmpty(color)) {
                                                        lbl.v.css("background-color", color);
                                                    }
                                                }

                                                lbl.v.append(fieldDisplayValue);

                                                lbl.v.on("click", (function ($me, fieldValue, lbl) {
                                                    return Bridge.fn.bind($me, function () {
                                                        if (!this.IsEnabled) {
                                                            return;
                                                        }

                                                        this._selectedElem != null ? this._selectedElem.removeClass("wf-active") : null;

                                                        this._selectedValue = fieldValue.v;
                                                        this._selectedElem = lbl.v;

                                                        lbl.v.addClass("wf-active");

                                                        result.find("label").css("background-color", "");

                                                        var color1 = this.EditControl.GetTextColor(fieldValue.v);
                                                        if (!System.String.isNullOrEmpty(color1)) {
                                                            lbl.v.css("background-color", color1);
                                                        }

                                                        this.OnChange(this._selectedValue);
                                                    });
                                                })(this, fieldValue, lbl));
                                            }
                                        } else {
                                            select = ($t2 = document.createElement("select"), $t2.id = this.ControlId, $t2.required = this.IsRequired, $t2.className = "form-control wf-enum", $t2.disabled = this.IsReadOnly, $t2);
                                            jqSelect = $(select);

                                            /* 
                                                           select.Add(new HTMLOptionElement()
                                                               {
                                                                   Value = "-1",
                                                                   Text = await WebFormsApp.GetTextAsync("NullPickerValue"),
                                                                   Style = {Color = "black"}
                                                               }
                                                           );
                                            */

                                            for (var i1 = 0; i1 < fieldValues.length; i1 = (i1 + 1) | 0) {
                                                fieldValue1 = fieldValues[System.Array.index(i1, fieldValues)];
                                                fieldDisplayValue1 = fieldDispValues[System.Array.index(i1, fieldDispValues)];

                                                option = ($t2 = document.createElement("option"), $t2.value = fieldValue1, $t2.text = fieldDisplayValue1, $t2.selected = (Bridge.referenceEquals(value, fieldValue1)), $t2);
                                                jqOption = $(option);

                                                if (System.String.isNullOrEmpty(option.style.color)) {
                                                    option.style.color = "black";
                                                }

                                                fontHelper = this.DataItem;
                                                fontStyle = fontHelper.FontStyle;

                                                this.EditControl.SetFontProperties(jqOption, fieldValue1);

                                                if (Bridge.referenceEquals(value, fieldValue1)) {
                                                    this.EditControl.SetFontProperties(jqSelect, fieldValue1);
                                                }

                                                select.add(option);
                                            }

                                            select.onchange = Bridge.fn.bind(this, function (evnt) {
                                                var idx = evnt.currentTarget.selectedIndex;
                                                var item = evnt.currentTarget.item(idx);
                                                select.style.color = item.style.color;
                                                select.style.fontWeight = item.style.fontWeight;

                                                this.OnChange(fieldValues[System.Array.index(idx, fieldValues)]);
                                            });

                                            result = $(select);
                                        }

                                        inputGroup = $("<div>").addClass("input-group").append(result);


                                        $tcs.setResult(inputGroup);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetControlValue: function () {
                if (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.ButtonPicker) {
                    return this._selectedValue;
                }

                return Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.GetControlValue.call(this);
            },
            SetEnabled: function (enable) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.ButtonPicker) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (enable) {
                                            this.MainControl.find("label").removeAttr("disabled");
                                            this.MainControl.find("input").removeAttr("disabled");
                                            this.MainControl.removeClass("disabled");
                                        } else {
                                            this.MainControl.find("label").attr("disabled", "disabled");
                                            this.MainControl.find("input").attr("disabled", "disabled");
                                            this.MainControl.addClass("disabled");
                                        }
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ViewBase.prototype.SetEnabled.call(this, enable);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.FormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.IControl],
        statics: {
            methods: {
                AppendClearContent: function (parent, inputElem, clearCallback) {
                    var clearContentClicked = false;
                    var clearElem = $("<div>");
                    clearElem.addClass("input-group-append input-group-text del-icon wf-hidden").on("click", function (e) {
                        e.preventDefault();

                        inputElem.val("");

                        clearContentClicked = true;

                        Adaptica.WebForms.WebApp.Extensions.WFHide(clearElem);
                        inputElem.removeClass("wf-input-w-del");
                        inputElem.focus();

                        if (!Bridge.staticEquals(clearCallback, null)) {
                            clearCallback();
                        }

                    }).appendTo(parent);

                    $("<span>").addClass("fa fa-times-circle").appendTo(clearElem);

                    inputElem.on("input", function () {
                        if (!Bridge.referenceEquals(inputElem.val(), "")) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(clearElem);
                            inputElem.addClass("wf-input-w-del");
                        } else {
                            Adaptica.WebForms.WebApp.Extensions.WFHide(clearElem);
                        }
                    });

                    inputElem.on("focus", function () {
                        if (!Bridge.referenceEquals(inputElem.val(), "")) {
                            Adaptica.WebForms.WebApp.Extensions.WFShow(clearElem);
                            inputElem.addClass("wf-input-w-del");
                        }
                    });

                    inputElem.on("blur", function () {
                        window.setTimeout(function () {
                            var clicked = clearContentClicked;
                            clearContentClicked = false;
                            if (clicked) {
                                return;
                            }

                            Adaptica.WebForms.WebApp.Extensions.WFHide(clearElem);
                            inputElem.removeClass("wf-input-w-del");
                        }, 200);
                    });

                    return clearElem;
                }
            }
        },
        fields: {
            _formControl: null,
            _containerContent: null,
            _controls: null,
            _jqControls: null,
            _tabControls: null,
            _vertical: false,
            _scrollX: 0,
            _scrollY: 0,
            _id: 0,
            ParentForm: null,
            CurrencyManager: null,
            Toolbar: null,
            TextFilter: null,
            ActiveFilter: null,
            FormData: null,
            Content: null,
            FormId: null,
            FormInternalID: null,
            IgnoreItems: false,
            IsInlineForm: false,
            CreateControlOnly: false,
            IsFullRowControl: false,
            Containers: null,
            OnToolbarAction: null,
            BreadCrumbSeparator: null,
            _firstLabelControl: null,
            FirstLabelValue: null,
            _searchBar: null,
            _searchInput: null,
            _searchBarClearInput: null,
            EditMode: false,
            _needsReloadData: false,
            _isActivated: false
        },
        props: {
            MainDSPFID: {
                get: function () {
                    return null;
                }
            },
            Controls: {
                get: function () {
                    return this._controls;
                }
            },
            Caption: {
                get: function () {
                    var $t;
                    return ($t = this.FormData) != null ? $t.Caption : null;
                }
            },
            BreadCrumb: {
                get: function () {
                    return (this.ParentForm == null) ? this.Caption : (this.IsInlineForm) ? this.ParentForm.BreadCrumb : System.String.format("{0}{1}{2}", this.ParentForm.BreadCrumb, this.BreadCrumbSeparator, this.Caption);
                }
            },
            NeedsProcessDataOnInsert: {
                get: function () {
                    var ds = this.CurrencyManager.MainDataset;
                    return (ds != null) && (ds.Header != null) && (ds.Header.InsertMode === 1);
                }
            },
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsVisible: {
                get: function () {
                    return this.IsActivated;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            NeedsReloadData: {
                get: function () {
                    return this._needsReloadData;
                },
                set: function (value) {
                    if (!this.FormData.IsMainMenu) {
                        this._needsReloadData = value;
                    }
                }
            },
            MasterID: {
                get: function () {
                    var $t, $t1, $t2;
                    var currRec = this.CurrencyManager.GetCurrentRecord(($t = this.CurrencyManager.MainDataset) != null ? $t.DSPFID : null);
                    /* ???
                                   if ((currRec != null) && (currRec.RecID == null))
                                   {
                                       CurrencyManager.SetCurrentRecord(CurrencyManager.MainDataset?.DSPFID, null);
                                   }
                    */
                    return ($t1 = (currRec != null ? currRec.MasterIDParent : null), $t1 != null ? $t1 : (($t2 = this.CurrencyManager.MainDataset) != null ? $t2.MasterIDParent : null));
                }
            },
            IsActivated: {
                get: function () {
                    return this._isActivated;
                }
            }
        },
        alias: [
            "CreateControlOnly", "Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly",
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._controls = new (System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.IControl)).ctor();
                this._jqControls = new (System.Collections.Generic.List$1($)).ctor();
                this._tabControls = new (System.Collections.Generic.Dictionary$2(System.String,System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.IControl))).ctor();
                this._vertical = false;
                this._scrollX = 0;
                this._scrollY = 0;
                this._id = 0;
                this.TextFilter = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).ctor();
                this.ActiveFilter = new (System.Collections.Generic.Dictionary$2(System.String,System.String)).ctor();
                this.IsFullRowControl = false;
                this.BreadCrumbSeparator = " > ";
            },
            ctor: function (formData, parentForm) {
                if (parentForm === void 0) { parentForm = null; }
                var $t;

                this.$initialize();
                this.FormData = formData;
                this.ParentForm = parentForm;
                this.CurrencyManager = new Adaptica.WebForms.Common.DataModel.CurrencyManager();

                this.FormInternalID = ($t = this.FormData.PFID, $t != null ? $t : this.FormData.PFPFID);
                this.FormId = "form-" + (Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FormInternalID) || "");
            }
        },
        methods: {
            CreateUniqueControlId: function () {
                return System.String.format("{0}_ctrl_{1}", this.FormId, Bridge.box(Bridge.identity(this._id, ((this._id = (this._id + 1) | 0))), System.Int32));
            },
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $taskResult9, 
                    $task10, 
                    $task11, 
                    $taskResult11, 
                    $task12, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    $taskResult1, 
                    template, 
                    tInfo, 
                    $t1, 
                    topContainer, 
                    navBar, 
                    tbarPanel, 
                    $t2, 
                    commonContainer, 
                    commonItems, 
                    activeTab, 
                    firstContainer, 
                    buttonContainer, 
                    editContainer, 
                    container, 
                    $t3, 
                    $t4, 
                    item, 
                    ctrl, 
                    jq, 
                    div, 
                    tabHeader, 
                    tabContent, 
                    tabHeaderOuter, 
                    tabContentOuter, 
                    row, 
                    activeItem, 
                    i, 
                    container1, 
                    $t5, 
                    caption, 
                    hasGrid, 
                    item1, 
                    $t6, 
                    tabItem, 
                    tabElem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,30,31,32,33,35,36,37,38,39,40,41,42], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((($t = this.FormData) != null ? $t.DataModule : null) != null) {
                                            this.CurrencyManager.LoadDataModule(this.FormData.DataModule, this.MainDSPFID);
                                        }

                                        this._formControl = $("<div>").addClass("wf").attr("id", this.FormId);

                                        if ((this.FormData != null) && (this.FormData.IsMainMenu)) {
                                            this._formControl.addClass("wf-mainMenu");
                                        }

                                        if ((this.FormData != null)) {
                                            $step = 1;
                                            continue;
                                        }
                                        $taskResult1 = false;
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("SystemSetFormIdClass");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $taskResult1 = (Bridge.referenceEquals($taskResult2, "1"));
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if ($taskResult1) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 4: {
                                        if (!System.String.isNullOrEmpty(this.FormData.ClearPFPFID)) {
                                            this._formControl.addClass(System.String.format("form-{0}", [this.FormData.ClearPFPFID]));
                                        }

                                        if (!System.String.isNullOrEmpty(this.FormData.ClearPFID)) {
                                            this._formControl.addClass(System.String.format("form-{0}", [this.FormData.ClearPFID]));
                                        }
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        template = null;
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.UseTemplate(($t1 = this.FormData) != null ? $t1.TemplateName : null);
                                        $step = 6;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        tInfo = $taskResult3;
                                        if (!System.String.isNullOrEmpty(tInfo != null ? tInfo.Html : null)) {
                                            template = $(tInfo.Html).appendTo(this._formControl);
                                        }

                                        topContainer = template != null ? template.find(".wf-toolbar") : null;
                                        if ((topContainer == null) || (topContainer.length === 0)) {
                                            topContainer = $("<div>").addClass("wf-container-top sticky-top");

                                            this._formControl.append(topContainer);
                                        }

                                        this.Toolbar = new Adaptica.WebForms.WebApp.Controls.ToolbarControl(this, "wf-form-nav");
                                        this.Toolbar.addOnAction(Bridge.fn.cacheBind(this, this.ToolbarActionHandler));
                                        this._controls.insert(0, this.Toolbar);

                                        this._containerContent = template != null ? template.find("*").filter(".wf-tmpl-fc") : null;

                                        if ((this._containerContent == null) || (this._containerContent.length === 0)) {
                                            this._containerContent = $("<div>").addClass("wf-container-content");

                                            this._formControl.append(this._containerContent);
                                        }

                                        $task4 = this.Toolbar.RenderControl();
                                        $step = 7;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        navBar = $taskResult4;
                                        this._jqControls.add(navBar);

                                        tbarPanel = $();
                                        if (tbarPanel.length > 1) {
                                            window.alert("Multiple toolbar panels defined.");
                                            navBar.appendTo(topContainer);
                                        } else {
                                            navBar.appendTo(tbarPanel.length > 0 ? tbarPanel : topContainer);
                                        }

                                        if ((this.FormData == null) || (this.IgnoreItems) || (this.IsInlineForm)) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 8: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.AddForm(this);

                                        if (this.IsInlineForm) {
                                            $step = 9;
                                            continue;
                                        } 
                                        $step = 11;
                                        continue;
                                    }
                                    case 9: {
                                        /* 
                                                       var formElem = new jQuery("<div>")
                                                           .AddClass("form-row  align-items-center")
                                                           .AppendTo(_containerContent);

                                                       await CreateItems(FormData.Design.Containers[0], formElem);
                                        */

                                        $task5 = this.CreateItems(($t2 = this.FormData.Design.Containers)[System.Array.index(0, $t2)], Bridge.fn.bind(this, function () {
                                            return $("<div>").addClass("form-row  align-items-center").appendTo(this._containerContent);
                                        }));
                                        $step = 10;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 10: {
                                        $task5.getAwaitedResult();
                                        $step = 11;
                                        continue;
                                    }
                                    case 11: {
                                        this.Content = this._formControl;
                                        this.OnFormCreated();

                                        $tcs.setResult(this._formControl);
                                        return;
                                    }
                                    case 12: {
                                        commonContainer = null;
                                        commonItems = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.ContainerItem)).ctor();
                                        activeTab = 0;

                                        firstContainer = 0;
                                        if (this.FormData.Design.Containers.length > 1) {
                                            $step = 13;
                                            continue;
                                        } 
                                        $step = 19;
                                        continue;
                                    }
                                    case 13: {
                                        commonContainer = $("<div>").addClass("wf-commonContainer").appendTo(topContainer);

                                        buttonContainer = null;
                                        editContainer = null;

                                        firstContainer = 1;
                                        activeTab = 1;
                                        container = ($t3 = this.FormData.Design.Containers)[System.Array.index(0, $t3)];
                                        $t4 = Bridge.getEnumerator(System.Linq.Enumerable.from(container.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).orderBy(function (ci) {
                                            return ci.Order;
                                        }));
                                        $step = 14;
                                        continue;
                                    }
                                    case 14: {
                                        if ($t4.moveNext()) {
                                            item = $t4.Current;
                                            $step = 15;
                                            continue;
                                        }
                                        $step = 18;
                                        continue;
                                    }
                                    case 15: {
                                        $task6 = this.CreateControl(item);
                                        $step = 16;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 16: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        ctrl = $taskResult6;
                                        if (ctrl == null) {
                                            $step = 14;
                                            continue;
                                        }

                                        if (System.String.equals(("Label"), item.ItemType)) {
                                            ctrl.Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly = true;
                                        }

                                        this._controls.add(ctrl);

                                        $task7 = ctrl.Adaptica$WebForms$WebApp$Controls$IControl$RenderControl();
                                        $step = 17;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        jq = $taskResult7;
                                        this._jqControls.add(jq);

                                        if (System.String.equals(("Label"), item.ItemType)) {
                                            this._firstLabelControl = Bridge.as(ctrl, Adaptica.WebForms.WebApp.Controls.LabelControl);
                                            this.FirstLabelValue = this._firstLabelControl.DisplayValue;
                                        }

                                        div = $("<div>").addClass("wf-commonContainer-item text-center").append(jq);

                                        if (System.String.equals(("Button"), item.ItemType)) {
                                            if (buttonContainer == null) {
                                                buttonContainer = $("<div>").addClass("wf-buttonContainer");
                                                commonContainer.append(buttonContainer);
                                            }

                                            buttonContainer.append(div);
                                        } else if (System.String.equals(("Edit"), item.ItemType)) {
                                            if (editContainer == null) {
                                                editContainer = $("<div>").addClass("form-row");
                                                commonContainer.append(editContainer);
                                            }

                                            editContainer.append(div);
                                        } else {
                                            buttonContainer = null;
                                            editContainer = null;
                                            commonContainer.append(div);
                                        }
                                        $step = 14;
                                        continue;
                                    }
                                    case 18: {
                                        this.CheckButtonsOnly(container, commonContainer);
                                        $step = 19;
                                        continue;
                                    }
                                    case 19: {
                                        tabHeader = $("<ul>").addClass("nav").attr("role", "tablist");

                                        tabContent = $("<div>").addClass("tab-content wf-tab-content");

                                        if (this._vertical) {
                                            tabHeader.addClass("nav-pills flex-column");

                                            tabHeaderOuter = $("<div>").addClass("col-md-2 mb-3").append(tabHeader);


                                            tabContentOuter = $("<div>").addClass("col-md-10").append(tabContent);

                                            row = $("<div>").addClass("row").append(tabHeaderOuter).append(tabContentOuter).appendTo(this._containerContent);
                                        } else {
                                            tabHeader.addClass("nav-tabs wf-nav-tabs").appendTo(topContainer);

                                            tabContent.appendTo(this._containerContent);
                                        }


                                        this.Containers = new Adaptica.WebForms.WebApp.Controls.FormContainers(this._formControl, topContainer, navBar, commonContainer, this._containerContent);

                                        activeItem = null;

                                        i = firstContainer;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        if ( i < this.FormData.Design.Containers.length ) {
                                            $step = 21;
                                            continue;
                                        }
                                        $step = 38;
                                        continue;
                                    }
                                    case 21: {
                                        container1 = ($t5 = this.FormData.Design.Containers)[System.Array.index(i, $t5)];
                                        caption = container1.Caption;

                                        if (container1.Items.length === 0) {
                                            $step = 37;
                                            continue;
                                        }

                                        if (!this.FormData.IsMainMenu) {
                                            $step = 22;
                                            continue;
                                        } 
                                        $step = 30;
                                        continue;
                                    }
                                    case 22: {
                                        if ((i === 0) || ((i === 1) && (commonItems.Count > 0))) {
                                            $step = 23;
                                            continue;
                                        } 
                                        $step = 29;
                                        continue;
                                    }
                                    case 23: {
                                        if (this.FormData.Design.Containers.length === ((i + 1) | 0)) {
                                            $step = 24;
                                            continue;
                                        } 
                                        $step = 28;
                                        continue;
                                    }
                                    case 24: {
                                        hasGrid = System.Linq.Enumerable.from(this.FormData.Design.Containers, Adaptica.WebForms.Common.DataModel.Container).any(function (c) {
                                            return System.Linq.Enumerable.from(c.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (item1) {
                                                return System.String.equals(("Grid"), item1.ItemType);
                                            });
                                        });
                                        if (hasGrid) {
                                            $step = 25;
                                            continue;
                                        } 
                                        $step = 27;
                                        continue;
                                    }
                                    case 25: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("ListLabel");
                                        $step = 26;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        caption = $taskResult8;
                                        $step = 27;
                                        continue;
                                    }



                                    case 30: {
                                        if ((System.String.isNullOrEmpty(caption)) && (container1.Items.length > 0)) {
                                            $step = 31;
                                            continue;
                                        } 
                                        $step = 35;
                                        continue;
                                    }
                                    case 31: {
                                        item1 = ($t6 = container1.Items)[System.Array.index(0, $t6)];

                                        if (item1.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) {
                                            caption = item1.Caption;
                                        }

                                        if ((container1.Items.length === 1) && (System.String.equals(("Grid"), item1.ItemType))) {
                                            $step = 32;
                                            continue;
                                        } 
                                        $step = 34;
                                        continue;
                                    }
                                    case 32: {
                                        $task9 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("ListLabel");
                                        $step = 33;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 33: {
                                        $taskResult9 = $task9.getAwaitedResult();
                                        caption = $taskResult9;
                                        $step = 34;
                                        continue;
                                    }

                                    case 35: {
                                        tabItem = $("<a>").addClass("nav-link wf-nav-tab").addClass((i === activeTab) ? "active" : "").attr("data-toggle", "tab").attr("href", System.String.format("#{0}_tab{1}", this.FormId, Bridge.box(i, System.Int32))).attr("role", "tab").html(caption);

                                        if (i === activeTab) {
                                            activeItem = tabItem;
                                        }

                                        tabHeader.append($(document.createElement("li")).addClass("nav-item wf-nav-item").append(tabItem));

                                        tabItem.on("shown.bs.tab", Bridge.fn.bind(this, function (e) {
                                            var newTab = $(e.target);
                                            var prevTab = $(e.relatedTarget);

                                            this.TabSwitch(prevTab, newTab);
                                        }));

                                        tabElem = { v : $("<div>").attr("id", System.String.format("{0}_tab{1}", this.FormId, Bridge.box(i, System.Int32))).attr("role", "tabpanel").addClass("tab-pane fade").addClass((i === activeTab) ? "show active" : "") };

                                        /* 
                                                       var formElem = new jQuery("<div>")
                                                           .AddClass("form-row  align-items-center")
                                                           .AppendTo(tabElem);

                                                       await CreateItems(container, formElem, $"#{FormId}_tab{i}");
                                        */
                                        $task10 = this.CreateItems(container1, (function ($me, tabElem) {
                                            return function () {
                                                return $("<div>").addClass("form-row  align-items-center").appendTo(tabElem.v);
                                            };
                                        })(this, tabElem), System.String.format("#{0}_tab{1}", this.FormId, Bridge.box(i, System.Int32)));
                                        $step = 36;
                                        if ($task10.isCompleted()) {
                                            continue;
                                        }
                                        $task10.continue($asyncBody);
                                        return;
                                    }
                                    case 36: {
                                        $task10.getAwaitedResult();
                                        tabContent.append(tabElem.v);
                                        $step = 37;
                                        continue;
                                    }
                                    case 37: {
                                        i = (i + 1) | 0;
                                        $step = 20;
                                        continue;
                                    }
                                    case 38: {
                                        $task11 = this.CheckIsNavigationValid();
                                        $step = 39;
                                        if ($task11.isCompleted()) {
                                            continue;
                                        }
                                        $task11.continue($asyncBody);
                                        return;
                                    }
                                    case 39: {
                                        $taskResult11 = $task11.getAwaitedResult();
                                        if (!$taskResult11) {
                                            $step = 40;
                                            continue;
                                        } 
                                        $step = 41;
                                        continue;
                                    }
                                    case 40: {
                                        this.Dispose();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 41: {
                                        $task12 = this.AddHelpTab(this.FormData, tabHeader, tabContent);
                                        $step = 42;
                                        if ($task12.isCompleted()) {
                                            continue;
                                        }
                                        $task12.continue($asyncBody);
                                        return;
                                    }
                                    case 42: {
                                        $task12.getAwaitedResult();
                                        if (activeItem != null) {
                                            this.TabSwitch(null, activeItem);
                                        }

                                        Adaptica.WebForms.WebApp.WebFormsApp.AddForm(this);

                                        this.Content = this._formControl;
                                        this.OnFormCreated();

                                        $tcs.setResult(this._formControl);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            TabSwitch: function (prevTab, newTab) {
                var $t, $t1;
                var tabItems = { v : null };
                var tabName;

                if (prevTab != null) {
                    tabName = prevTab.attr("href");
                    if ((!System.String.isNullOrEmpty(tabName)) && (this._tabControls.tryGetValue(tabName, tabItems))) {
                        $t = Bridge.getEnumerator(tabItems.v);
                        try {
                            while ($t.moveNext()) {
                                var control = $t.Current;
                                control.Adaptica$WebForms$WebApp$Controls$IControl$OnHide();
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }
                }

                if (newTab != null) {
                    tabName = newTab.attr("href");
                    if ((!System.String.isNullOrEmpty(tabName)) && (this._tabControls.tryGetValue(tabName, tabItems))) {
                        $t1 = Bridge.getEnumerator(tabItems.v);
                        try {
                            while ($t1.moveNext()) {
                                var control1 = $t1.Current;
                                control1.Adaptica$WebForms$WebApp$Controls$IControl$OnShow();
                            }
                        } finally {
                            if (Bridge.is($t1, System.IDisposable)) {
                                $t1.System$IDisposable$Dispose();
                            }
                        }
                    }
                }
            },
            CreateItems: function (container, parentFactory, tabName) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tabItems, 
                    parent, 
                    buttonsOnly, 
                    lastControlsFullRow, 
                    itemIndex, 
                    item, 
                    $t, 
                    control, 
                    isFullRow, 
                    ctrl, 
                    prevCtrl, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        if (tabName === void 0) { tabName = null; }
                                        tabItems = { v : null };
                                        if (!System.String.isNullOrEmpty(tabName)) {
                                            if (!this._tabControls.tryGetValue(tabName, tabItems)) {
                                                tabItems.v = new (System.Collections.Generic.List$1(Adaptica.WebForms.WebApp.Controls.IControl)).ctor();
                                                this._tabControls.add(tabName, tabItems.v);
                                            }
                                        }

                                        parent = parentFactory();


                                        buttonsOnly = false;
                                        if (this.FormData.Design.Containers.length <= 2) {
                                            buttonsOnly = this.CheckButtonsOnly(container, parent);

                                            if ((this.FormData.IsMainMenu) || (this.FormData.ShowSearchBar)) {
                                                this.CreateSearchBar();
                                            }
                                        }

                                        lastControlsFullRow = false;
                                        itemIndex = 0;
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        if ( itemIndex < container.Items.length ) {
                                            $step = 2;
                                            continue;
                                        }
                                        $step = 8;
                                        continue;
                                    }
                                    case 2: {
                                        item = ($t = container.Items)[System.Array.index(itemIndex, $t)];

                                        $task1 = this.CreateControl(item);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        control = { v : $taskResult1 };
                                        if (control.v != null) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        isFullRow = control.v.Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl;

                                        this._controls.add(control.v);
                                        tabItems.v != null ? tabItems.v.add(control.v) : null;

                                        $task2 = control.v.Adaptica$WebForms$WebApp$Controls$IControl$RenderControl();
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        ctrl = $taskResult2;
                                        this._jqControls.add(ctrl);

                                        if ((!buttonsOnly) && (Bridge.is(control.v, Adaptica.WebForms.WebApp.Controls.ButtonControl))) {
                                            prevCtrl = (this._controls.Count === 0) ? null : this._controls.getItem(((this._controls.Count - 1) | 0));
                                            if ((prevCtrl != null) && (!(Bridge.is(prevCtrl, Adaptica.WebForms.WebApp.Controls.ButtonControl)))) {
                                                parent = parentFactory();
                                            }
                                        }

                                        if (ctrl.parent().length === 0) {
                                            if (isFullRow) {
                                                if (!lastControlsFullRow) {
                                                    parent = parentFactory();
                                                }

                                                lastControlsFullRow = true;
                                            }

                                            parent.append(ctrl);

                                            if (isFullRow) {
                                                parent = parentFactory();
                                            }
                                        }
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        itemIndex = (itemIndex + 1) | 0;
                                        $step = 1;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateSearchBar: function () {
                var $t;
                Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("CreateSearchBar. PFID: {0}", [this.FormData.PFID]));

                if (this._searchBar != null) {
                    return;
                }

                var timeoutId = 0;
                this._searchInput = $(($t = document.createElement("input"), $t.className = "form-control wf-form-search", $t.autocomplete = "new-password", $t.onkeyup = Bridge.fn.bind(this, function (evnt) {
                        if ((evnt.altKey) || (evnt.metaKey)) {
                            return;
                        }

                        if ((evnt.ctrlKey) && (evnt.keyCode !== 86)) {
                            return;
                        }

                        if ((System.String.contains(evnt.key,"Arrow") || (System.Array.indexOfT(Adaptica.WebForms.WebApp.Controls.ControlUtils.IgnoreKeys, evnt.key) > -1))) {
                            return;
                        }

                        window.clearTimeout(timeoutId);

                        evnt.preventDefault();
                        if (evnt.keyCode === 13) {
                            var searchText = (evnt.currentTarget || evnt.target).value;
                            this.FilterButtons(searchText);
                        } else {
                            timeoutId = window.setTimeout(Bridge.fn.bind(this, function () {
                                var searchText1 = (evnt.currentTarget || evnt.target).value;
                                this.FilterButtons(searchText1);
                            }), 500);
                        }
                    }), $t));

                var searchIconElem = $("<span>").addClass("fas fa-search wf-search-icon");

                this._searchBar = $("<div>").addClass("wf-form-search-box fade show").appendTo(this.Containers.Top);

                var row = $("<div>").addClass("wf-search-row").append(searchIconElem).append(this._searchInput).appendTo(this._searchBar);

                this._searchBarClearInput = Adaptica.WebForms.WebApp.Controls.FormControl.AppendClearContent(row, this._searchInput, Bridge.fn.bind(this, function () {
                    this.FilterButtons("");
                }));

                Adaptica.WebForms.WebApp.WebFormsApp.Log("Form searchbar created.");
            },
            FilterButtons: function (searchText) {
                var $t;
                $t = Bridge.getEnumerator(this._controls);
                try {
                    while ($t.moveNext()) {
                        var ctrl = $t.Current;
                        var btn;
                        if (((btn = Bridge.as(ctrl, Adaptica.WebForms.WebApp.Controls.ButtonControl))) != null) {
                            if (System.String.isNullOrEmpty(searchText) || (System.String.indexOf(btn.Text, searchText, 0, null, 3) > -1)) {
                                btn.OnShow();
                            } else {
                                btn.OnHide();
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            CheckButtonsOnly: function (container, parent) {
                var buttonsOnly = System.Linq.Enumerable.from(container.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).all(function (item) {
                        return System.String.equals(("Button"), item.ItemType);
                    });
                if (buttonsOnly) {
                    parent.addClass("wf-buttonsOnly");
                    return true;
                }

                return false;
            },
            CreateControl: function (item) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    control, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((System.String.equals(("QIMobile.SignaturePad"), item.Action)) || (System.String.equals(("QIMobile.mbwblueqiconnector"), item.Action))) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile, item.Action)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        item.ItemType = "Button";
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DownloadFileActionButton");
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        item.Caption = $taskResult1;
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if (System.String.equals(Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile, item.Action)) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        item.ItemType = "Button";
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("PrintFileActionButton");
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        item.Caption = $taskResult2;
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        control = null;
                                        switch (item.ItemType) {
                                            case "Button": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.ButtonControl(this, item);
                                                    break;
                                                }
                                            case "Edit": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.EditControl(this, item);
                                                    break;
                                                }
                                            case "Grid": 
                                                {

                                                    control = this.CreateGrid(item);

                                                    break;
                                                }
                                            case "Image": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.ImageControl(this, item);
                                                    break;
                                                }
                                            case "Label": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.LabelControl(this, item);
                                                    break;
                                                }
                                            case "Memo": 
                                                {
                                                    control = new Adaptica.WebForms.WebApp.Controls.MemoControl(this, item);
                                                    break;
                                                }
                                        }

                                        $tcs.setResult(control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateGrid: function (item) {
                var $t;
                var control;

                if (Adaptica.WebForms.WebApp.Controls.GridControlBase.IsKanbanGrid(item)) {
                    control = new Adaptica.WebForms.WebApp.Controls.KanbanGridControl(this, item);
                } else {
                    var useMobileGrid = (window.screen.availWidth <= 420);
                    if (!System.String.isNullOrEmpty(($t = window.self.gridType) != null ? Bridge.toString($t) : null)) {
                        useMobileGrid = (Bridge.equals(("mobile"), window.self.gridType));
                    }

                    if (useMobileGrid) {
                        control = new Adaptica.WebForms.WebApp.Controls.MobileGridControl(this, item);
                    } else {
                        control = new Adaptica.WebForms.WebApp.Controls.DataTablesGridControl(this, item);
                    }
                }

                return control;
            },
            Focus: function () {
                var $t;
                var result = false;

                $t = Bridge.getEnumerator(this._controls);
                try {
                    while ($t.moveNext()) {
                        var control = $t.Current;
                        if (control.Adaptica$WebForms$WebApp$Controls$IControl$Focus()) {
                            result = true;
                            break;
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return result;
            },
            ToolbarActionHandler: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $task4, 
                    $task5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $task10, 
                    $taskResult10, 
                    $task11, 
                    $jumpFromFinally, 
                    handled, 
                    $t, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29], $step);
                            switch ($step) {
                                case 0: {
                                    if (!Bridge.staticEquals(this.OnToolbarAction, null)) {
                                        $step = 1;
                                        continue;
                                    } 
                                    $step = 3;
                                    continue;
                                }
                                case 1: {
                                    $task1 = this.OnToolbarAction(e.Action);
                                    $step = 2;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 2: {
                                    $taskResult1 = $task1.getAwaitedResult();
                                    handled = $taskResult1;
                                    if (handled) {
                                        return;
                                    }
                                    $step = 3;
                                    continue;
                                }
                                case 3: {
                                    $t = e.Action;
                                    if ($t === "Back") {
                                        $step = 4;
                                        continue;
                                    }
                                    else if ($t === "PrevRec") {
                                        $step = 6;
                                        continue;
                                    }
                                    else if ($t === "NextRec") {
                                        $step = 7;
                                        continue;
                                    }
                                    else if ($t === "Insert") {
                                        $step = 8;
                                        continue;
                                    }
                                    else if ($t === "Delete") {
                                        $step = 10;
                                        continue;
                                    }
                                    else if ($t === "Refresh") {
                                        $step = 12;
                                        continue;
                                    }
                                    else if ($t === "AddFavourite") {
                                        $step = 14;
                                        continue;
                                    }
                                    else if ($t === "RemoveFavourite") {
                                        $step = 19;
                                        continue;
                                    }
                                    else if ($t === "Edit") {
                                        $step = 24;
                                        continue;
                                    }
                                    else if ($t === "Save") {
                                        $step = 25;
                                        continue;
                                    }
                                    else if ($t === "Logout") {
                                        $step = 27;
                                        continue;
                                    }
                                    $step = 29;
                                    continue;
                                }
                                case 4: {
                                    $task2 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                    $step = 5;
                                    if ($task2.isCompleted()) {
                                        continue;
                                    }
                                    $task2.continue($asyncBody);
                                    return;
                                }
                                case 5: {
                                    $task2.getAwaitedResult();
                                    return;
                                }
                                case 6: {
                                    this.MovePrevRecord();
                                    return;
                                }
                                case 7: {
                                    this.MoveNextRecord();
                                    return;
                                }
                                case 8: {
                                    $task3 = this.DoInsert(this.CurrencyManager.MainDataset.DSPFID);
                                    $step = 9;
                                    if ($task3.isCompleted()) {
                                        continue;
                                    }
                                    $task3.continue($asyncBody);
                                    return;
                                }
                                case 9: {
                                    $task3.getAwaitedResult();
                                    return;
                                }
                                case 10: {
                                    $task4 = this.DeleteRecord(this.CurrencyManager.MainDataset.DSPFID);
                                    $step = 11;
                                    if ($task4.isCompleted()) {
                                        continue;
                                    }
                                    $task4.continue($asyncBody);
                                    return;
                                }
                                case 11: {
                                    $task4.getAwaitedResult();
                                    return;
                                }
                                case 12: {
                                    $task5 = this.ReloadData();
                                    $step = 13;
                                    if ($task5.isCompleted()) {
                                        continue;
                                    }
                                    $task5.continue($asyncBody);
                                    return;
                                }
                                case 13: {
                                    $task5.getAwaitedResult();
                                    return;
                                }
                                case 14: {
                                    $task6 = Adaptica.WebForms.WebApp.WebFormsApp.AddFavourite(this.FormInternalID, this.Caption, this.MasterID, this.FirstLabelValue);
                                    $step = 15;
                                    if ($task6.isCompleted()) {
                                        continue;
                                    }
                                    $task6.continue($asyncBody);
                                    return;
                                }
                                case 15: {
                                    $taskResult6 = $task6.getAwaitedResult();
                                    if ($taskResult6) {
                                        $step = 16;
                                        continue;
                                    } 
                                    $step = 18;
                                    continue;
                                }
                                case 16: {
                                    $task7 = this.Toolbar.CheckItemsStatus();
                                    $step = 17;
                                    if ($task7.isCompleted()) {
                                        continue;
                                    }
                                    $task7.continue($asyncBody);
                                    return;
                                }
                                case 17: {
                                    $task7.getAwaitedResult();
                                    $step = 18;
                                    continue;
                                }
                                case 18: {
                                    return;
                                }
                                case 19: {
                                    $task8 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveFavourite(this.FormInternalID, this.MasterID);
                                    $step = 20;
                                    if ($task8.isCompleted()) {
                                        continue;
                                    }
                                    $task8.continue($asyncBody);
                                    return;
                                }
                                case 20: {
                                    $taskResult8 = $task8.getAwaitedResult();
                                    if ($taskResult8) {
                                        $step = 21;
                                        continue;
                                    } 
                                    $step = 23;
                                    continue;
                                }
                                case 21: {
                                    $task9 = this.Toolbar.CheckItemsStatus();
                                    $step = 22;
                                    if ($task9.isCompleted()) {
                                        continue;
                                    }
                                    $task9.continue($asyncBody);
                                    return;
                                }
                                case 22: {
                                    $task9.getAwaitedResult();
                                    $step = 23;
                                    continue;
                                }
                                case 23: {
                                    return;
                                }
                                case 24: {
                                    this.BeginEdit();
                                    return;
                                }
                                case 25: {
                                    $task10 = this.EndEdit();
                                    $step = 26;
                                    if ($task10.isCompleted()) {
                                        continue;
                                    }
                                    $task10.continue($asyncBody);
                                    return;
                                }
                                case 26: {
                                    $taskResult10 = $task10.getAwaitedResult();
                                    return;
                                }
                                case 27: {
                                    $task11 = Adaptica.WebForms.WebApp.WebFormsApp.Logout();
                                    $step = 28;
                                    if ($task11.isCompleted()) {
                                        continue;
                                    }
                                    $task11.continue($asyncBody);
                                    return;
                                }
                                case 28: {
                                    $task11.getAwaitedResult();
                                    return;
                                }
                                case 29: {
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            AddHelpTab: function (form, tabHeader, tabContent) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    formId, 
                    $t, 
                    tabItem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (System.String.isNullOrEmpty(form.Description)) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        formId = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(($t = form.PFID, $t != null ? $t : form.PFPFID));

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("HelpTabTitle");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        tabItem = $("<a>").addClass("nav-link wf-nav-tab").attr("data-toggle", "tab").attr("href", System.String.format("#form-{0}_tab_help", [formId])).attr("role", "tab").html($taskResult1);

                                        $(document.createElement("li")).addClass("nav-item wf-nav-item").append(tabItem).appendTo(tabHeader);

                                        $("<div>").attr("id", System.String.format("form-{0}_tab_help", [formId])).attr("role", "tabpanel").addClass("tab-pane fade wf-help").html(System.String.replaceAll(form.Description, "\n", "<br>")).appendTo(tabContent);

                                        tabItem.on("shown.bs.tab", Bridge.fn.bind(this, function (e) {
                                            var newTab = $(e.target);
                                            var prevTab = $(e.relatedTarget);

                                            this.TabSwitch(prevTab, newTab);
                                        }));
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            OnFormCreated: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1], $step);
                            switch ($step) {
                                case 0: {
                                    $task1 = this.ActivateForm();
                                    $step = 1;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 1: {
                                    $task1.getAwaitedResult();
                                    window.setTimeout(Bridge.fn.bind(this, function () {
                                        var $step = 0,
                                            $task1, 
                                            $jumpFromFinally, 
                                            $asyncBody = Bridge.fn.bind(this, function () {
                                                for (;;) {
                                                    $step = System.Array.min([0,1], $step);
                                                    switch ($step) {
                                                        case 0: {
                                                            $task1 = this.OnFormCreatedInternal();
                                                            $step = 1;
                                                            if ($task1.isCompleted()) {
                                                                continue;
                                                            }
                                                            $task1.continue($asyncBody);
                                                            return;
                                                        }
                                                        case 1: {
                                                            $task1.getAwaitedResult();
                                                            return;
                                                        }
                                                        default: {
                                                            return;
                                                        }
                                                    }
                                                }
                                            }, arguments);

                                        $asyncBody();
                                    }), 100);
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            OnFormActivated: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }

                if (this._searchBar != null) {
                    window.setTimeout(Bridge.fn.bind(this, function () {
                        this._searchInput.focus();
                    }), 10);
                }
            },
            OnFormDeactivated: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }
            },
            OnShow: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnShow();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }

                if (this._searchBar != null) {
                    this._searchBar.addClass("show");
                    this._searchBar.removeClass("wf-hidden");
                }
            },
            OnHide: function () {
                var $t;
                if (this._controls != null) {
                    $t = Bridge.getEnumerator(this._controls);
                    try {
                        while ($t.moveNext()) {
                            var control = $t.Current;
                            control.Adaptica$WebForms$WebApp$Controls$IControl$OnHide();
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }

                if (this._searchBar != null) {
                    this._searchBar.removeClass("show");
                    this._searchBar.addClass("wf-hidden");
                }
            },
            OnFormCreatedInternal: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    control, 
                    $t1, 
                    ds, 
                    $t2, 
                    $t3, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        $t = Bridge.getEnumerator(this._controls);
                                        try {
                                            while ($t.moveNext()) {
                                                control = $t.Current;
                                                control.Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated();
                                            }
                                        } finally {
                                            if (Bridge.is($t, System.IDisposable)) {
                                                $t.System$IDisposable$Dispose();
                                            }
                                        }

                                        if ((($t1 = this.CurrencyManager) != null ? $t1.MainDataset : null) != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 1: {
                                        ds = this.CurrencyManager.MainDataset;

                                        if ((ds.Header.Read === 0) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanInsert(ds))) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = this.DoInsert(ds.DSPFID);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ((ds.Header.Read === 2) && (Adaptica.WebForms.Common.DataModel.DatasetHelper.CanUpdate(ds)) || (($t2 = (($t3 = this.FormData.DataModule) != null ? $t3.EditMode : null), $t2 != null ? $t2 : false))) {
                                            this.BeginEdit();
                                        }
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        $task2 = this.Toolbar.CheckItemsStatus();
                                        $step = 6;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task2.getAwaitedResult();
                                        this.CurrencyManager.addOnCurrentRecordChanged(Bridge.fn.bind(this, function (sender, args) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.Toolbar.CheckItemsStatus();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetNeedsReloadParents: function () {
                var parent = this.ParentForm;
                while (parent != null) {
                    parent.NeedsReloadData = true;
                    parent = parent.ParentForm;
                }
            },
            BeginEdit: function () {
                $(System.String.format("#{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FormId)])).addClass("editing");

                this.EditMode = true;
                var focused = false;

                this._controls.ForEach(function (control) {
                    var context;
                    if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                        context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit();
                    }

                    if ((!focused) && (control.Adaptica$WebForms$WebApp$Controls$IControl$Focus())) {
                        focused = true;
                    }
                });
            },
            BeforeEndEdit: function () {
                this._controls.ForEach(function (control) {
                    var context;
                    if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                        context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit();
                    }
                });
            },
            EndEdit: function (save) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (save === void 0) { save = true; }
                                        this.BeforeEndEdit();

                                        $(System.String.format("#{0}", [this.FormId])).removeClass("editing");

                                        if (!(!save)) {
                                            $step = 1;
                                            continue;
                                        }
                                        $taskResult1 = true;
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task2 = this.SaveForm();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $taskResult1 = ($taskResult2);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        result = $taskResult1;

                                        if (result) {
                                            this.EditMode = false;
                                            this._controls.ForEach(function (control) {
                                                var context;
                                                if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                                                    context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit();
                                                }
                                            });
                                        } else {
                                            this._controls.ForEach(function (control) {
                                                var context;
                                                if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                                                    context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed();
                                                }
                                            });
                                        }

                                        if (this.IsInlineForm) {
                                            this.ParentForm.EditMode = false;
                                        }

                                        $task3 = this.Toolbar.CheckItemsStatus();
                                        $step = 4;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AllowInsert: function (DSPFID) {
                if (DSPFID == null) {
                    return false;
                }

                return this._controls.Exists(function (control) {
                    return (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext)).Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert(DSPFID);
                });
            },
            AllowEdit: function (DSPFID) {
                if (DSPFID == null) {
                    return false;
                }

                return this._controls.Exists(function (control) {
                    return (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext)).Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit(DSPFID);
                }) || this.FormData.DataModule.AllowEditMode;
            },
            AllowDelete: function (DSPFID) {
                if (DSPFID == null) {
                    return false;
                }

                return this._controls.Exists(function (control) {
                    return (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext)).Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete(DSPFID);
                });
            },
            CheckIsNavigationValid: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    ds, 
                    defOK, 
                    $t1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,8], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((($t = this.CurrencyManager) != null ? $t.MainDataset : null) != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 8;
                                        continue;
                                    }
                                    case 1: {
                                        ds = this.CurrencyManager.MainDataset;

                                        if (this.IsNavigationInvalid(ds)) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 2: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        defOK = ($t1 = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t1.Caption = $taskResult3, $t1.AddClass = "btn-secondary", $t1);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AppTitle");
                                        $step = 4;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("TooManyRecordError");
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$1($taskResult1, $taskResult2, System.Array.init([defOK], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef));
                                        $step = 6;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task4.getAwaitedResult();
                                        $tcs.setResult(false);
                                        return;
                                    }

                                    case 8: {
                                        $tcs.setResult(true);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsNavigationInvalid$1: function (DSPFID) {
                var ds = this.CurrencyManager.MainDataset;
                if (Bridge.referenceEquals((ds != null ? ds.DSPFID : null), DSPFID)) {
                    return this.IsNavigationInvalid(ds);
                }

                return false;
            },
            IsNavigationInvalid: function (ds) {
                return (ds != null) && (ds.Records.length === 0) && (ds.RecordCount > 0) && (this._controls.TrueForAll(function (control) {
                    var $t, $t1;
                    return ($t = (($t1 = (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null ? $t1.Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation(ds.DSPFID) : null), $t != null ? $t : true);
                }));
            },
            AllowCurrentRecordNavigation$1: function (DSPFID) {
                var ds = this.CurrencyManager.MainDataset;
                if (Bridge.referenceEquals((ds != null ? ds.DSPFID : null), DSPFID)) {
                    return this.AllowCurrentRecordNavigation(ds);
                }

                return false;
            },
            AllowCurrentRecordNavigation: function (ds) {
                return (!this.EditMode) && (!this.IsInlineForm) && (ds != null) && (ds.Records.length > 1) && (this._controls.TrueForAll(function (control) {
                    var $t, $t1;
                    return ($t = (($t1 = (Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null ? $t1.Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation(ds.DSPFID) : null), $t != null ? $t : true);
                }));
            },
            MovePrevRecord: function () {
                var ds = this.CurrencyManager.MainDataset;
                if ((ds != null) && (!this.CurrencyManager.IsFirstRecord(ds.DSPFID))) {
                    this.CurrencyManager.MovePrevious(ds.DSPFID);
                }
            },
            MoveNextRecord: function () {
                var ds = this.CurrencyManager.MainDataset;
                if ((ds != null) && (!this.CurrencyManager.IsLastRecord(ds.DSPFID))) {
                    this.CurrencyManager.MoveNext(ds.DSPFID);
                }
            },
            RaiseDataChanged: function () { },
            ExecuteGridDefaultAction: function (DSPFID, record) {
                return System.Threading.Tasks.Task.fromResult(false, System.Boolean);
            },
            DoInsert: function (DSPFID) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        this.CurrencyManager.SetCurrentRecord(DSPFID, Adaptica.WebForms.Common.DataModel.DataHelpers.InsertRecord(this.CurrencyManager, this.CurrencyManager.GetCurrentDataset(DSPFID)));

                                        if (this.NeedsProcessDataOnInsert) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ProcessData(this);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this.RefreshData();
                                        this.BeginEdit();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            DeleteRecord: function (DSPFID) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    defCancel, 
                    $t, 
                    defDelete, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("CancelButton");
                                        $step = 1;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        defCancel = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult2, $t.AddClass = "btn-secondary", $t);

                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DeleteAction");
                                        $step = 2;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        defDelete = ($t = new Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef(), $t.Caption = $taskResult3, $t.AddClass = "btn-secondary", $t.Handler = Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.DoDelete(DSPFID);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }), $t);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("DeletingRecord");
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$1($taskResult1, "Vymazat vybran\u00fd z\u00e1znam?", System.Array.init([defCancel, defDelete], Adaptica.WebForms.WebApp.WebFormsApp.DialogButtonDef));
                                        $step = 4;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task4.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            DoDelete: function (DSPFID) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $task4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        this.CurrencyManager.GetCurrentRecord(DSPFID).Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Delete;
                                        this.CurrencyManager.SetCurrentRecord(DSPFID, null);

                                        $task1 = this.SetData();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if (this.ParentForm != null) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task2 = this.ParentForm.ReloadData();
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task2.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm(true);
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task3.getAwaitedResult();
                                        $task4 = this.Toolbar.CheckItemsStatus();
                                        $step = 6;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $task4.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ReloadData: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $t, 
                    $t1, 
                    textFilter, 
                    $t2, 
                    activeFilter, 
                    $t3, 
                    masterId, 
                    functionId, 
                    insertedRecordMasterId, 
                    overridenFunctionId, 
                    $t4, 
                    $t5, 
                    $t6, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        if (System.Nullable.eq((($t = this.FormData.DataModule) != null && ($t1 = $t.Datasets) != null ? $t1.length : null), 0)) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        textFilter = (($t2 = System.Collections.Generic.KeyValuePair$2(System.String,System.String), System.Linq.Enumerable.from(this.TextFilter, $t2).toList($t2)).ConvertAll(System.String, function (p) {
                                            return System.String.format("{0}:{1}", p.key, p.value);
                                        }).ToArray()).join("|");
                                        activeFilter = (($t3 = System.Collections.Generic.KeyValuePair$2(System.String,System.String), System.Linq.Enumerable.from(this.ActiveFilter, $t3).toList($t3)).ConvertAll(System.String, function (p) {
                                            return System.String.format("{0}:{1}", p.key, p.value);
                                        }).ToArray()).join("|");

                                        masterId = this.MasterID;
                                        functionId = this.FormData.PFPFID;

                                        insertedRecordMasterId = null;
                                        overridenFunctionId = null;
                                        if ((this.CurrencyManager.MainDataset != null && this.CurrencyManager.MainDataset.Header.Read === 0 && this.CurrencyManager.MainDataset.Header.Insert === 1)) {
                                            insertedRecordMasterId = (System.Linq.Enumerable.from(this.CurrencyManager.MainDataset.Records, Adaptica.WebForms.Common.DataModel.Record).select(function (r) {
                                                return r.RecID;
                                            }).where(function (s) {
                                                return !System.String.isNullOrEmpty(s);
                                            }).ToArray(System.String)).join(";");
                                            overridenFunctionId = this.FormData.PFID;
                                        }

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetFormData", { PFPFID: ($t4 = overridenFunctionId, $t4 != null ? $t4 : ($t5 = functionId, $t5 != null ? $t5 : this.FormData.PFID)), MasterID: ($t6 = insertedRecordMasterId, $t6 != null ? $t6 : masterId), TextFilter: textFilter, ActiveFilter: activeFilter }, "GET", Bridge.fn.bind(this, function (dto) {
                                            var $t7, $t8;
                                            if ((dto != null && ($t7 = dto.FormData) != null ? $t7.DataModule : null) != null) {
                                                Adaptica.WebForms.Common.DataModel.DataHelpers.MergeWith(this.FormData.DataModule, dto.FormData.DataModule, false);
                                                this.CurrencyManager.LoadDataModule(this.FormData.DataModule, this.MainDSPFID);
                                                this.RefreshData();
                                            }

                                            if ((!this.EditMode) && (this.AllowEdit(($t8 = this.CurrencyManager.MainDataset) != null ? $t8.DSPFID : null) && this.FormData.DataModule.EditMode)) {
                                                this.BeginEdit();
                                            }

                                            this.NeedsReloadData = false;

                                            return System.Threading.Tasks.Task.fromResult(null, System.Object);
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.Toolbar.CheckItemsStatus();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RefreshData: function () {
                this._controls.ForEach(function (control) {
                    var context;
                    if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                        context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged();
                    }
                });

                this.FirstLabelValue = this._firstLabelControl != null ? this._firstLabelControl.DisplayValue : null;
            },
            ShowRequiredFieldsError: function (sb) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AppTitle");
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2($taskResult1, sb.replace("\n", "<br>").toString(), $taskResult2);
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CheckRequiredFields: function (sb) {
                var result = true;

                this._controls.ForEach(Bridge.fn.bind(this, function (control) {
                    var $step = 0,
                        $task1, 
                        $taskResult1, 
                        $jumpFromFinally, 
                        context, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (((context = Bridge.as(control, Adaptica.WebForms.WebApp.Controls.IControlDataContext))) != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = context.Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid(sb);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = !!(result & $taskResult1);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }));

                return result;
            },
            SaveForm: function (silent) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    validationMessage, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5], $step);
                                switch ($step) {
                                    case 0: {
                                        if (silent === void 0) { silent = false; }
                                        if (!Adaptica.WebForms.Common.DataModel.FormHelper.IsChanged(this.FormData)) {
                                            $tcs.setResult(true);
                                            return;
                                        }

                                        result = false;
                                        validationMessage = new System.Text.StringBuilder();
                                        if (!this.CheckRequiredFields(validationMessage)) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.ShowRequiredFieldsError(validationMessage);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 5;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = this.SetData(silent);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        result = $taskResult2;

                                        if (result) {
                                            this.SetNeedsReloadParents();
                                        }
                                        $step = 5;
                                        continue;
                                    }
                                    case 5: {
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetData: function (silent) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (silent === void 0) { silent = false; }
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.SetData(this, silent);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;
                                        if (result) {
                                            this.SetNeedsReloadParents();
                                        }

                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ProcessData: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ProcessData(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;
                                        /* 
                                                   if (result)
                                                   {
                                                       SetNeedsReloadParents();
                                                   }
                                        */

                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ActivateForm: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        this._isActivated = true;
                                        this._formControl.show();

                                        this._jqControls.ForEach(Bridge.fn.bind(this, function (control) {
                                            if (!$.contains(this._formControl.get(0),control.get(0))) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(control);
                                            }
                                        }));

                                        window.scrollTo(this._scrollX, this._scrollY);

                                        if (this.NeedsReloadData) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.ReloadData().wait();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = this.Toolbar.CheckItemsStatus();
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        this.OnFormActivated();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RecalculateSize: function () {
                var ch = this._containerContent.height();
                var h = (((window.innerHeight - this.Content.find(".sticky-top").height()) | 0) - 10) | 0;
                this._containerContent.css("height", h);

                Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("resize. ContentHeight: {0}, calculated height: {1}.", Bridge.box(ch, System.Int32), Bridge.box(h, System.Int32)));
            },
            DeactivateForm: function () {
                this._scrollX = window.scrollX;
                this._scrollY = window.scrollY;

                this._formControl.hide();
                this._isActivated = false;

                this._jqControls.ForEach(Bridge.fn.bind(this, function (control) {
                    if (!$.contains(this._formControl.get(0),control.get(0))) {
                        Adaptica.WebForms.WebApp.Extensions.WFHide(control);
                    }
                }));

                this.OnFormDeactivated();
            },
            ExecuteFunction: function (pfpfid, evnt) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $task7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $task10, 
                    $taskResult10, 
                    $task11, 
                    $task12, 
                    $task13, 
                    $taskResult13, 
                    $task14, 
                    $task15, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $function, 
                    $t, 
                    masterIDParent, 
                    keyEvent, 
                    win, 
                    $t1, 
                    $taskResult2, 
                    $taskResult1, 
                    ds, 
                    $async_e, 
                    $async_e1, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,19,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,41,42,44,45,46], $step);
                                switch ($step) {
                                    case 0: {
                                        if (evnt === void 0) { evnt = null; }
                                        Adaptica.WebForms.WebApp.WebFormsApp.ShowSplash();
                                        
                                        $step = 1;
                                        continue;
                                    }
                                    case 1: {
                                        $function = System.Linq.Enumerable.from(this.FormData.Functions, Adaptica.WebForms.Common.DataModel.Function).firstOrDefault(function (fn) {
                                            return Bridge.referenceEquals(fn.PFPFID, pfpfid);
                                        }, null);
                                        if ($function == null) {
                                            $returnValue = null;
                                            $step = 44;
                                            continue;
                                        }

                                        $t = $function.FunctionType;
                                        if ($t === Adaptica.WebForms.Common.DataModel.FunctionType.OpenForm) {
                                            $step = 2;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FunctionType.ExecMacro) {
                                            $step = 16;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FunctionType.SpecialFunction) {
                                            $step = 23;
                                            continue;
                                        }
                                        $step = 43;
                                        continue;
                                    }
                                    case 2: {
                                        if (this.EditMode) {
                                            $step = 3;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 3: {
                                        $task5 = this.EndEdit();
                                        $step = 4;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        if (!$taskResult5) {
                                            $step = 5;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        $returnValue = null;
                                        $step = 44;
                                        continue;
                                    }

                                    case 7: {
                                        masterIDParent = null;
                                        if (!System.String.isNullOrEmpty($function.DSPFID) && this.CurrencyManager.GetCurrentRecordOrFirst($function.DSPFID) != null) {
                                            masterIDParent = Adaptica.WebForms.Common.DataModel.FunctionHelper.GetRecordMasterId($function, this.CurrencyManager.GetCurrentRecordOrFirst($function.DSPFID));
                                        }

                                        keyEvent = evnt;
                                        if ((keyEvent != null) && ((keyEvent.ctrlKey || keyEvent.metaKey))) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 14;
                                        continue;
                                    }
                                    case 8: {
                                        win = window.open((window.location.origin || "") + (window.location.pathname || "") + "?FormID=" + (encodeURIComponent(pfpfid) || ""), "_blank");
                                        if ((win == null) || (Bridge.referenceEquals((typeof win), "undefined"))) {
                                            $step = 9;
                                            continue;
                                        } 
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AppTitle");
                                        $step = 10;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 10: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("AcceptButton");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.ShowAlert$2($taskResult3, "Prohl\u00ed\u017ee\u010d pravd\u011bpodobn\u011b blokuje otev\u00edr\u00e1n\u00ed extern\u00edch oken, pros\u00edm zkontrolujte nastaven\u00ed.<br>V\u011bt\u0161inou je zobrazena ikonka v prav\u00e9 \u010d\u00e1sti adresn\u00edho \u0159\u00e1dku.", $taskResult4);
                                        $step = 12;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 12: {
                                        $task6.getAwaitedResult();
                                        $step = 13;
                                        continue;
                                    }
                                    case 13: {
                                        $returnValue = null;
                                        $step = 44;
                                        continue;
                                    }
                                    case 14: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetForm", { PFPFID: pfpfid, MasterID: masterIDParent }, Bridge.fn.bind(this, function (dto) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm$1(dto, this);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 15;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 15: {
                                        $task7.getAwaitedResult();
                                        $step = 44;
                                        $jumpFromFinally = 43;
                                        continue;
                                    }
                                    case 16: {
                                        this.BeforeEndEdit();

                                        if (($function.SaveDS === 1) && this.EditMode) {
                                            $step = 17;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 17: {
                                        $task8 = this.EndEdit();
                                        $step = 18;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 18: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        if (!$taskResult8) {
                                            $step = 19;
                                            continue;
                                        } 
                                        $step = 20;
                                        continue;
                                    }
                                    case 19: {
                                        $returnValue = null;
                                        $step = 44;
                                        continue;
                                    }

                                    case 21: {
                                        $task9 = this.ExecuteMacro($function);
                                        $step = 22;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 22: {
                                        $task9.getAwaitedResult();
                                        $step = 44;
                                        $jumpFromFinally = 43;
                                        continue;
                                    }
                                    case 23: {
                                        $t1 = $function.SpecFunctionType;
                                        if ($t1 === Adaptica.WebForms.Common.DataModel.SpecFunctionType.Save) {
                                            $step = 24;
                                            continue;
                                        }
                                        else if ($t1 === Adaptica.WebForms.Common.DataModel.SpecFunctionType.Cancel) {
                                            $step = 31;
                                            continue;
                                        }
                                        else if ($t1 === Adaptica.WebForms.Common.DataModel.SpecFunctionType.SaveAndInsert) {
                                            $step = 33;
                                            continue;
                                        }
                                        $step = 42;
                                        continue;
                                    }
                                    case 24: {
                                        if (!!this.EditMode) {
                                            $step = 25;
                                            continue;
                                        }
                                        $taskResult2 = true;
                                        $step = 27;
                                        continue;
                                    }
                                    case 25: {
                                        $task10 = this.EndEdit();
                                        $step = 26;
                                        if ($task10.isCompleted()) {
                                            continue;
                                        }
                                        $task10.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult10 = $task10.getAwaitedResult();
                                        $taskResult2 = $taskResult10;
                                        $step = 27;
                                        continue;
                                    }
                                    case 27: {
                                        if ($taskResult2) {
                                            $step = 28;
                                            continue;
                                        } 
                                        $step = 30;
                                        continue;
                                    }
                                    case 28: {
                                        $task11 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                        $step = 29;
                                        if ($task11.isCompleted()) {
                                            continue;
                                        }
                                        $task11.continue($asyncBody);
                                        return;
                                    }
                                    case 29: {
                                        $task11.getAwaitedResult();
                                        $step = 30;
                                        continue;
                                    }
                                    case 30: {
                                        $step = 44;
                                        $jumpFromFinally = 42;
                                        continue;
                                    }
                                    case 31: {
                                        $task12 = Adaptica.WebForms.WebApp.WebFormsApp.RemoveCurrentForm();
                                        $step = 32;
                                        if ($task12.isCompleted()) {
                                            continue;
                                        }
                                        $task12.continue($asyncBody);
                                        return;
                                    }
                                    case 32: {
                                        $task12.getAwaitedResult();
                                        $step = 44;
                                        $jumpFromFinally = 42;
                                        continue;
                                    }
                                    case 33: {
                                        if (!!this.EditMode) {
                                            $step = 34;
                                            continue;
                                        }
                                        $taskResult1 = true;
                                        $step = 36;
                                        continue;
                                    }
                                    case 34: {
                                        $task13 = this.EndEdit();
                                        $step = 35;
                                        if ($task13.isCompleted()) {
                                            continue;
                                        }
                                        $task13.continue($asyncBody);
                                        return;
                                    }
                                    case 35: {
                                        $taskResult13 = $task13.getAwaitedResult();
                                        $taskResult1 = $taskResult13;
                                        $step = 36;
                                        continue;
                                    }
                                    case 36: {
                                        if ($taskResult1) {
                                            $step = 37;
                                            continue;
                                        } 
                                        $step = 41;
                                        continue;
                                    }
                                    case 37: {
                                        ds = this.CurrencyManager.MainDataset;
                                        if (ds != null && ds.Header.Read === 0 && ds.Header.Insert === 1) {
                                            $step = 38;
                                            continue;
                                        } 
                                        $step = 40;
                                        continue;
                                    }
                                    case 38: {
                                        $task14 = this.DoInsert(this.CurrencyManager.MainDataset.DSPFID);
                                        $step = 39;
                                        if ($task14.isCompleted()) {
                                            continue;
                                        }
                                        $task14.continue($asyncBody);
                                        return;
                                    }
                                    case 39: {
                                        $task14.getAwaitedResult();
                                        $step = 40;
                                        continue;
                                    }

                                    case 41: {
                                        $step = 44;
                                        $jumpFromFinally = 42;
                                        continue;
                                    }
                                    case 42: {
                                        $step = 44;
                                        $jumpFromFinally = 43;
                                        continue;
                                    }

                                    case 44: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.HideSplash();

                                        $task15 = this.Toolbar.CheckItemsStatus();
                                        $step = 45;
                                        if ($task15.isCompleted()) {
                                            continue;
                                        }
                                        $task15.continue($asyncBody);
                                        return;
                                    }
                                    case 45: {
                                        $task15.getAwaitedResult();
                                        
                                        if ($jumpFromFinally > -1) {
                                            $step = $jumpFromFinally;
                                            $jumpFromFinally = null;
                                        } else if ($async_e) {
                                            $tcs.setException($async_e);
                                            return;
                                        } else if (Bridge.isDefined($returnValue)) {
                                            $tcs.setResult($returnValue);
                                            return;
                                        }
                                        $step = 46;
                                        continue;
                                    }
                                    case 46: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            if ($step >= 1 && $step <= 43) {
                                $step = 44;
                                $asyncBody();
                                return;
                            }
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ExecuteMacro: function ($function) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    selParams, 
                    $t, 
                    dto, 
                    data, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        selParams = ($t = new Adaptica.WebForms.Common.DTO.SelectionParams(), $t.PFPFID = $function.PFPFID, $t.DSPFID = $function.DSPFID, $t.DataForm = this.FormData, $t.CurrentRecord = this.CurrencyManager.GetCurrentRecord($function.DSPFID), $t);

                                        dto = ($t = new Adaptica.WebForms.Common.DTO.DataDTO(), $t.SelectionParams = selParams, $t);
                                        data = Adaptica.WebForms.WebApp.WebFormsApp.Serialize(dto);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("ExecuteFunction", data, "POST", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $task2, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                ex, 
                                                newFormData, 
                                                anyChanges, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3,4,5,6,8,9,10], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    if (System.String.equals(("exception"), dataDTO.Type)) {
                                                                        $step = 1;
                                                                        continue;
                                                                    } else  {
                                                                        $step = 2;
                                                                        continue;
                                                                    }
                                                                }
                                                                case 1: {
                                                                    ex = dataDTO.Data;
                                                                    window.alert(ex.Message);
                                                                    $step = 10;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    newFormData = dataDTO.FormData;
                                                                    anyChanges = Adaptica.WebForms.Common.DataModel.DataHelpers.MergeWith(this.FormData.DataModule, newFormData.DataModule, true);
                                                                    this.CurrencyManager.SetCurrentRecordToFirstFromDataModule($function.DSPFID, newFormData.DataModule);

                                                                    this.RefreshData();

                                                                    if (Adaptica.WebForms.Common.DataModel.FormHelper.IsChanged(newFormData)) {
                                                                        $step = 3;
                                                                        continue;
                                                                    } else  {
                                                                        $step = 4;
                                                                        continue;
                                                                    }
                                                                }
                                                                case 3: {
                                                                    this.BeginEdit();
                                                                    this.Focus();
                                                                    $step = 8;
                                                                    continue;
                                                                }
                                                                case 4: {
                                                                    if (this.EditMode) {
                                                                        $step = 5;
                                                                        continue;
                                                                    } 
                                                                    $step = 7;
                                                                    continue;
                                                                }
                                                                case 5: {
                                                                    $task1 = this.EndEdit();
                                                                    $step = 6;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 6: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    $step = 7;
                                                                    continue;
                                                                }

                                                                case 8: {
                                                                    if (anyChanges) {
                                                                        this.SetNeedsReloadParents();
                                                                    }

                                                                    $task2 = this.Toolbar.CheckItemsStatus();
                                                                    $step = 9;
                                                                    if ($task2.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task2.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 9: {
                                                                    $task2.getAwaitedResult();
                                                                    $step = 10;
                                                                    continue;
                                                                }
                                                                case 10: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetSiblingsByPFPFID: function (PFPFID) {
                var container = System.Linq.Enumerable.from(this.FormData.Design.Containers, Adaptica.WebForms.Common.DataModel.Container).firstOrDefault(function (x) {
                        return System.Linq.Enumerable.from(x.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (i) {
                                return Bridge.referenceEquals(i.PFPFID, PFPFID);
                            });
                    }, null);
                return container != null ? container.Items : null;
            },
            GetSiblingsByFieldName: function (fieldName) {
                var container = System.Linq.Enumerable.from(this.FormData.Design.Containers, Adaptica.WebForms.Common.DataModel.Container).firstOrDefault(function (x) {
                        return System.Linq.Enumerable.from(x.Items, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (i) {
                                return Bridge.referenceEquals(i.FieldName, fieldName);
                            });
                    }, null);
                return container != null ? container.Items : null;
            },
            Dispose: function () {
                var $t;

                Adaptica.WebForms.WebApp.WebFormsApp.ReleaseTemplate(this.FormData.TemplateName);

                this.Toolbar.removeOnAction(Bridge.fn.cacheBind(this, this.ToolbarActionHandler));

                $t = Bridge.getEnumerator(this._controls);
                try {
                    while ($t.moveNext()) {
                        var ctrl = $t.Current;
                        ctrl.System$IDisposable$Dispose();
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                this._jqControls.ForEach(function (jqControl) {
                    jqControl.off();
                });
                this._searchInput != null ? this._searchInput.off() : null;
                this._searchBarClearInput != null ? this._searchBarClearInput.off() : null;

                this._controls.clear();
                this._jqControls.clear();

                this._formControl.remove();
                this._formControl = null;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.SetView", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ViewBase],
        fields: {
            _itemsCount: 0,
            _items: null,
            _splittedValues: null,
            _splittedDispValues: null,
            _isSetting: false
        },
        props: {
            Value: {
                get: function () {
                    var $t;
                    return ($t = this.Record) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue($t, this.FieldDef) : null;
                }
            }
        },
        ctors: {
            init: function () {
                this._items = new (System.Collections.Generic.List$1($)).ctor();
            },
            ctor: function (formControl, editControl, dataItem, ds, fieldDef, rec) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ViewBase.ctor.call(this, formControl, editControl, dataItem, ds, fieldDef, rec);
            }
        },
        methods: {
            CreateControl: function () {
                var $t;
                var value = { };
                System.Int32.tryParse(this.Value, value);

                var jq = $("<div>");
                this.MainControl = jq;

                this._splittedValues = this.FieldDef.Values.split(",");
                this._splittedDispValues = this.FieldDef.DisplayValues.split(",");
                this._itemsCount = this._splittedValues.length;
                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var itemValue = System.Int32.parse(this._splittedValues[System.Array.index(i, this._splittedValues)]);

                    var input = $(($t = document.createElement("input"), $t.id = (this.ControlId || "") + (System.String.format("_{0}", [Bridge.box(i, System.Int32)]) || ""), $t.type = "checkbox", $t)).attr("data-toggle", "toggle").attr("data-style", "round");

                    this._items.add(input);

                    if ((value.v & (1 << itemValue)) !== 0) {
                        input.attr("checked", "checked");
                    }

                    var div = $("<div>").addClass("form-row wf-set");

                    $("<div>").addClass("col-auto wf-set-label").append(this._splittedDispValues[System.Array.index(i, this._splittedDispValues)]).appendTo(div);

                    $("<div>").addClass("col-auto wf-set-control").append(input).appendTo(div);

                    var group = $("<div>").addClass("input-group").append(div).appendTo(jq);


                    var onText = "on";
                    var offText = "off";

                    eval(System.String.format("input.bootstrapToggle({{ size: 'sm', on: '{0}', off: '{1}' }});", onText, offText));
                }


                return System.Threading.Tasks.Task.fromResult(jq, $);
            },
            SetEnabled: function (enable) {
                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var item = this._items.getItem(i);

                    if (enable) {
                        item.bootstrapToggle('enable');
                    } else {
                        item.bootstrapToggle('disable');
                    }
                }


                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetChangeHandler: function () {
                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var item = this._items.getItem(i);
                    item.change(Bridge.fn.bind(this, function () {
                        if (!this._isSetting) {
                            this.OnChange(this.GetControlValue());
                        }
                    }));
                }
            },
            GetControlValue: function () {
                var value = 0;

                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var ch = this._items.getItem(i).prop("checked");
                    if (ch) {
                        value = value | (1 << i);
                    }
                }

                return Bridge.toString(value);
            },
            SetControlValue: function (value) {
                this._isSetting = true;
                var v = { };
                System.Int32.tryParse(value, v);

                for (var i = 0; i < this._itemsCount; i = (i + 1) | 0) {
                    var itemValue = System.Int32.parse(this._splittedValues[System.Array.index(i, this._splittedValues)]);
                    var item = this._items.getItem(i);

                    var isDisabled = item.prop("disabled") || item.prop("readonly");
                    if (isDisabled) {
                        item.bootstrapToggle('enable');
                    }

                    if ((v.v & (1 << itemValue)) !== 0) {
                        item.bootstrapToggle('on');
                    } else {
                        item.bootstrapToggle('off');
                    }

                    if (isDisabled) {
                        item.bootstrapToggle('disable');
                    }
                }

                this._isSetting = false;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ToolbarControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.IControl,Adaptica.WebForms.WebApp.Controls.IControlDataContext],
        fields: {
            _formControl: null,
            _formId: null,
            _classesToAdd: null,
            _caption: null,
            _items: null,
            CreateControlOnly: false,
            IsFullRowControl: false,
            IsEnabled: false,
            IsVisible: false,
            IsRequired: false
        },
        events: {
            OnAction: null
        },
        props: {
            NeedsProcessDataOnInsert: {
                get: function () {
                    return false;
                }
            }
        },
        alias: [
            "CreateControlOnly", "Adaptica$WebForms$WebApp$Controls$IControl$CreateControlOnly",
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "BeforeEndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit",
            "EndFailed", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed",
            "AllowInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert",
            "AllowEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit",
            "AllowDelete", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "NeedsProcessDataOnInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$NeedsProcessDataOnInsert",
            "IsValid", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._items = new (System.Collections.Generic.Dictionary$2(System.String,$)).ctor();
                this.IsFullRowControl = false;
            },
            ctor: function (formControl, classedToAdd) {
                if (classedToAdd === void 0) { classedToAdd = null; }

                this.$initialize();
                this._formControl = formControl;

                this._formId = (this._formControl != null) ? this._formControl.FormId : "tmp-toolbar";

                this._classesToAdd = classedToAdd;
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tBar, 
                    rightContainer, 
                    showLogout, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7], $step);
                                switch ($step) {
                                    case 0: {
                                        tBar = $("<div>").addClass("bg-faded wf-form-nav");

                                        if (!System.String.isNullOrEmpty(this._classesToAdd)) {
                                            tBar.addClass(this._classesToAdd);
                                        }

                                        if (Adaptica.WebForms.WebApp.WebFormsApp.OpenFormsCount > 0) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BackButton");
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $("<div>").attr("title", $taskResult1).append($("<a>").addClass("fas fa-long-arrow-alt-left wf-nav-icon").click(Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Back")) : null;
                                        }))).appendTo(tBar);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this._caption = $("<div>").addClass("wf-tBar-caption").html(this._formControl.Caption).attr("title", this._formControl.BreadCrumb).appendTo(tBar);

                                        rightContainer = $("<div>").addClass("d-flex flex-row justify-content-end").attr("id", "navb").appendTo(tBar);

                                        $task2 = this.CreateItems(rightContainer);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        showLogout = true;
                                        if (Adaptica.WebForms.WebApp.WebFormsApp.IsRunningInPortal) {
                                            showLogout = QIWebForms.showLogout;
                                        }

                                        if (showLogout) {
                                            $step = 5;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 5: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("LogoutAction");
                                        $step = 6;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        $("<div>").addClass("nav-item wf-nav-logout").attr("title", $taskResult3).append($("<a>").addClass("fas fa-sign-out-alt wf-nav-icon").click(Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Logout")) : null;
                                        }))).appendTo(rightContainer);
                                        $step = 7;
                                        continue;
                                    }
                                    case 7: {
                                        $tcs.setResult(tBar);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Focus: function () {
                return false;
            },
            OnFormCreated: function () { },
            OnFormActivated: function () { },
            OnFormDeactivated: function () { },
            OnShow: function () { },
            OnHide: function () { },
            CreateItem: function (parent, id, titleId, itemClass, imageClass, handler) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    iClass, 
                    $t, 
                    item, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        iClass = ($t = imageClass, $t != null ? $t : "");
                                        if ((System.String.indexOf(iClass, "far ") === -1) && (System.String.indexOf(iClass, "fas ") === -1)) {
                                            iClass = "fas " + (iClass || "");
                                        }

                                        item = $("<div>").attr("id", id).addClass(System.String.format("nav-item {0}", [System.String.replaceAll(System.String.replaceAll(itemClass, "fas ", ""), "far ", "")])).append($("<a>").addClass(System.String.format("{0} wf-nav-icon nav-link", [iClass])).click(handler)).appendTo(parent);

                                        if (!System.String.isNullOrEmpty(titleId)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync(titleId);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        item.attr("title", $taskResult1);
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        this._items.add(id, item);

                                        $tcs.setResult(item);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateItems: function (tbItems) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    id, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        id = System.String.format("{0}-nav-prev", [this._formId]);
                                        $task1 = this.CreateItem(tbItems, id, "PrevRecAction", "wf-nav-prev", "fa-angle-left", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("PrevRec")) : null;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        id = System.String.format("{0}-nav-next", [this._formId]);
                                        $task2 = this.CreateItem(tbItems, id, "NextRecAction", "wf-nav-next", "fa-angle-right", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("NextRec")) : null;
                                        }));
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        id = System.String.format("{0}-nav-insert", [this._formId]);
                                        $task3 = this.CreateItem(tbItems, id, "InsertAction", "wf-nav-insert", "fa-plus", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Insert")) : null;
                                        }));
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        id = System.String.format("{0}-nav-refresh", [this._formId]);
                                        $task4 = this.CreateItem(tbItems, id, "Refresh", "wf-nav-refresh", "fa-redo-alt", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Refresh")) : null;
                                        }));
                                        $step = 4;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        /* 
                                                   id = $"{_formId}-nav-addFavourite";
                                                   await CreateItem(tbItems, id, "AddFavourite", "wf-nav-addFavourite", "far fa-heart", () =>
                                                       {
                                                           OnAction?.Invoke(this, new ToolbarEventArgs("AddFavourite"));
                                                       });

                                                   id = $"{_formId}-nav-removeFavourite";
                                                   await CreateItem(tbItems, id, "RemoveFavourite", "wf-nav-removeFavourite", "fas fa-heart", () =>
                                                       {
                                                           OnAction?.Invoke(this, new ToolbarEventArgs("RemoveFavourite"));
                                                       });
                                        */

                                        id = System.String.format("{0}-nav-edit", [this._formId]);
                                        $task5 = this.CreateItem(tbItems, id, "Edit", "wf-nav-edit", "fa-pen", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Edit")) : null;
                                        }));
                                        $step = 5;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        id = System.String.format("{0}-nav-save", [this._formId]);
                                        $task6 = this.CreateItem(tbItems, id, "SaveAction", "wf-nav-save", "fa-save", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Save")) : null;
                                        }));
                                        $step = 6;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 6: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        id = System.String.format("{0}-nav-delete", [this._formId]);
                                        $task7 = this.CreateItem(tbItems, id, "DeleteAction", "wf-nav-delete", "fa-trash", Bridge.fn.bind(this, function () {
                                            !Bridge.staticEquals(this.OnAction, null) ? this.OnAction(this, new Adaptica.WebForms.WebApp.Controls.ToolbarControl.ToolbarEventArgs("Delete")) : null;
                                        }));
                                        $step = 7;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $task8 = this.CheckItemsStatus();
                                        $step = 8;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task8.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CheckItemsStatus: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $task4, 
                    $task5, 
                    $task6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    action, 
                    id, 
                    cm, 
                    ds, 
                    isFilterForm, 
                    allowNav, 
                    $t, 
                    $taskResult6, 
                    $taskResult5, 
                    $taskResult4, 
                    $taskResult3, 
                    $taskResult2, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,12,13,14,15,16,17,18,19,20,21,22,24], $step);
                                switch ($step) {
                                    case 0: {
                                        action = { };

                                        cm = this._formControl != null ? this._formControl.CurrencyManager : null;
                                        ds = cm != null ? cm.MainDataset : null;

                                        isFilterForm = Bridge.is(this._formControl, Adaptica.WebForms.WebApp.Controls.FilterSelectionFormControl);

                                        allowNav = (ds != null) && (($t = (this._formControl != null ? this._formControl.AllowCurrentRecordNavigation$1(ds.DSPFID) : null), $t != null ? $t : false));
                                        id = System.String.format("{0}-nav-prev", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((allowNav)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                                if (this._formControl.CurrencyManager.IsFirstRecord(ds.DSPFID)) {
                                                    action.v.find("a.nav-link").addClass("disabled");
                                                } else {
                                                    action.v.find("a.nav-link").removeClass("disabled");
                                                }
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-next", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((allowNav)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                                if (this._formControl.CurrencyManager.IsLastRecord(ds.DSPFID)) {
                                                    action.v.find("a.nav-link").addClass("disabled");
                                                } else {
                                                    action.v.find("a.nav-link").removeClass("disabled");
                                                }
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-insert", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((ds != null) && (this._formControl.AllowInsert(ds.DSPFID)) && (!this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-refresh", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((this._formControl != null) && (!this._formControl.EditMode) && (!this._formControl.IsInlineForm) && (!this._formControl.FormData.IsMainMenu) && (!(Bridge.is(this._formControl, Adaptica.WebForms.WebApp.Controls.SelectionFormControl)))) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-addFavourite", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 1: {
                                        if ((this._formControl != null)) {
                                            $step = 2;
                                            continue;
                                        }
                                        $taskResult6 = false;
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.IsInFavourites(this._formControl.FormInternalID, this._formControl.MasterID);
                                        $step = 3;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $taskResult6 = (!$taskResult7);
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ($taskResult6) {
                                            $step = 5;
                                            continue;
                                        }
                                        $taskResult5 = false;
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        $taskResult5 = (!this._formControl.IsInlineForm);
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        if ($taskResult5) {
                                            $step = 7;
                                            continue;
                                        }
                                        $taskResult4 = false;
                                        $step = 8;
                                        continue;
                                    }
                                    case 7: {
                                        $taskResult4 = (!this._formControl.FormData.IsMainMenu);
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        if ($taskResult4) {
                                            $step = 9;
                                            continue;
                                        } else  {
                                            $step = 10;
                                            continue;
                                        }
                                    }
                                    case 9: {
                                        Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                        $step = 11;
                                        continue;
                                    }
                                    case 10: {
                                        Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                        $step = 11;
                                        continue;
                                    }

                                    case 12: {
                                        id = System.String.format("{0}-nav-removeFavourite", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            $step = 13;
                                            continue;
                                        } 
                                        $step = 24;
                                        continue;
                                    }
                                    case 13: {
                                        if ((this._formControl != null)) {
                                            $step = 14;
                                            continue;
                                        }
                                        $taskResult3 = false;
                                        $step = 16;
                                        continue;
                                    }
                                    case 14: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.IsInFavourites(this._formControl.FormInternalID, this._formControl.MasterID);
                                        $step = 15;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 15: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult3 = ($taskResult8);
                                        $step = 16;
                                        continue;
                                    }
                                    case 16: {
                                        if ($taskResult3) {
                                            $step = 17;
                                            continue;
                                        }
                                        $taskResult2 = false;
                                        $step = 18;
                                        continue;
                                    }
                                    case 17: {
                                        $taskResult2 = (!this._formControl.IsInlineForm);
                                        $step = 18;
                                        continue;
                                    }
                                    case 18: {
                                        if ($taskResult2) {
                                            $step = 19;
                                            continue;
                                        }
                                        $taskResult1 = false;
                                        $step = 20;
                                        continue;
                                    }
                                    case 19: {
                                        $taskResult1 = (!this._formControl.FormData.IsMainMenu);
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        if ($taskResult1) {
                                            $step = 21;
                                            continue;
                                        } else  {
                                            $step = 22;
                                            continue;
                                        }
                                    }
                                    case 21: {
                                        Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                        $step = 23;
                                        continue;
                                    }
                                    case 22: {
                                        Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                        $step = 23;
                                        continue;
                                    }

                                    case 24: {
                                        id = System.String.format("{0}-nav-edit", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((ds != null) && (this._formControl.AllowEdit(ds.DSPFID)) && (!this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-save", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((this._formControl != null) && (!isFilterForm) && (this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }

                                        id = System.String.format("{0}-nav-delete", [this._formId]);
                                        if (this._items.tryGetValue(id, action)) {
                                            if ((ds != null) && (this._formControl.AllowDelete(ds.DSPFID)) && (!this._formControl.EditMode)) {
                                                Adaptica.WebForms.WebApp.Extensions.WFShow(action.v);
                                            } else {
                                                Adaptica.WebForms.WebApp.Extensions.WFHide(action.v);
                                            }
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetCaption: function (caption) {
                this._caption.html(caption);
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.CheckItemsStatus();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeforeEndEdit: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.CheckItemsStatus();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndFailed: function () {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            AllowInsert: function (DSPFID) {
                return false;
            },
            AllowEdit: function (DSPFID) {
                return false;
            },
            AllowDelete: function (DSPFID) {
                return false;
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return true;
            },
            IsValid: function (sb) {
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            RaiseDataChanged: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = this.CheckItemsStatus();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Dispose: function () {
                var $t;
                if (!Bridge.staticEquals(this.OnAction, null)) {
                    $t = Bridge.getEnumerator(Bridge.fn.getInvocationList(this.OnAction));
                    try {
                        while ($t.moveNext()) {
                            var d = $t.Current;
                            this.removeOnAction(d);
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                }
                this._items.clear();
                this._formControl = null;
                this._caption = null;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ButtonControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _fullControl: null,
            _function: null
        },
        props: {
            IsDownloadLikeButton: {
                get: function () {
                    return (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile));
                }
            },
            IsDownloadButton: {
                get: function () {
                    var fn = this._function || this.GetFunction();

                    if (fn.FunctionType !== 3) {
                        return false;
                    }

                    return (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile));
                }
            },
            IsSignatureButton: {
                get: function () {
                    var fn = this._function || this.GetFunction();

                    if (fn.FunctionType !== 3) {
                        return false;
                    }

                    return Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileDataSignature);
                }
            },
            Text: {
                get: function () {
                    return this.DataItem.Caption;
                }
            },
            IsEnabled: {
                get: function () {
                    var $function = this._function || this.GetFunction();
                    if ($function == null) {
                        return false;
                    }

                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord($function.DSPFID);
                    if ((!System.String.isNullOrEmpty($function.DSPFID)) && (rec != null)) {
                        if (!System.String.isNullOrEmpty($function.EnableExpr)) {
                            return Adaptica.WebForms.Common.DataModel.FunctionHelper.IsFunctionEnabledForRecord($function, rec);
                        }

                        if ($function.FunctionType === 1) {
                            return true;
                        }

                        if ($function.FunctionType === 2) {
                            switch ($function.SpecFunctionType) {
                                case 0: 
                                    return this.FormControl.EditMode;
                                case 1: 
                                    return true;
                                case 2: 
                                    return this.FormControl.EditMode;
                            }
                        }

                        return true;
                    }

                    return true;
                }
            },
            Dataset: {
                get: function () {
                    if (this._dset == null) {
                        var fn = this._function || this.GetFunction();
                        if (fn != null) {
                            this._dset = this.FormControl.CurrencyManager.GetCurrentDataset(fn.DSPFID);
                        } else if (!System.String.isNullOrEmpty(this.DataItem.DSPFID)) {
                            this._dset = Bridge.ensureBaseProperty(this, "Dataset").$Adaptica$WebForms$WebApp$Controls$ControlBase$Dataset;
                        }
                    }

                    return this._dset;
                }
            },
            IsVisible: {
                get: function () {
                    var $function = this._function || this.GetFunction();
                    if ($function == null) {
                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("Button: {0}: invisible, no function.", [this.DataItem.Caption]));
                        return false;
                    }

                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord($function.DSPFID);

                    var result = (Adaptica.WebForms.Common.DataModel.FunctionHelper.IsAvailable($function) && Adaptica.WebForms.Common.DataModel.FunctionHelper.IsFunctionVisibleForRecord($function, rec) || $function.FunctionType !== 0);
                    Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("Button: {0}: visible: {1}, function.IsAvailable: {2}", this.DataItem.Caption, Bridge.box(result, System.Boolean, System.Boolean.toString), Bridge.box(Adaptica.WebForms.Common.DataModel.FunctionHelper.IsAvailable($function), System.Boolean, System.Boolean.toString)));

                    return result;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            ImageSource: {
                get: function () {
                    var $function = this._function || this.GetFunction();
                    if (($function != null ? $function.Icon : null) != null) {
                        return "data:image/png;base64," + ($function.Icon || "");
                    }
                    return null;
                }
            }
        },
        alias: [
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus"
        ],
        ctors: {
            ctor: function (form, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, form, dataItem);
                this._function = this.GetFunction();
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $function, 
                    isTile, 
                    colorHex, 
                    wfTileCss, 
                    htmlBtn, 
                    $t, 
                    s, 
                    formButtons, 
                    siblings, 
                    rec, 
                    value, 
                    div, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        $function = this._function || this.GetFunction();
                                        isTile = (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) || (this.FormControl.FormData.IsMainMenu);
                                        colorHex = isTile ? $function.FunctionColorHex : null;
                                        wfTileCss = (isTile) ? " wf-tile" : "";

                                        htmlBtn = ($t = document.createElement("button"), $t.type = "button", $t);
                                        if (!System.String.isNullOrEmpty(this.DataItem.FieldName)) {
                                            htmlBtn.id = this.ControlId;
                                        }

                                        htmlBtn.addEventListener("click", Bridge.fn.bind(this, function (e) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.ButtonClick(e);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        if (!System.String.isNullOrEmpty(colorHex)) {
                                            htmlBtn.style.backgroundColor = System.String.format("#{0}", [colorHex]);
                                        }

                                        if (isTile) {
                                            htmlBtn.className = "btn wf-tileButton";
                                        } else if (this.DataItem.Type !== Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.Unknown) {
                                            s = System.Enum.toString(Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum, this.DataItem.Type);
                                            htmlBtn.className = "btn " + String.fromCharCode(String.fromCharCode(s.charCodeAt(0)).toLowerCase().charCodeAt(0)) + (s.substr(1) || "");
                                        } else {
                                            htmlBtn.className = "btn button";
                                        }

                                        formButtons = false;
                                        this.MainControl = $(htmlBtn);
                                        if (!System.String.isNullOrEmpty(this.DataItem.PFPFID)) {
                                            siblings = this.FormControl.GetSiblingsByPFPFID(this.DataItem.PFPFID);
                                            if ((siblings != null) && (System.Linq.Enumerable.from(siblings, Adaptica.WebForms.Common.DataModel.ContainerItem).any(function (i) {
                                                return (!Bridge.referenceEquals(i.ItemType, "Button"));
                                            }))) {
                                                formButtons = true;
                                                this.MainControl.addClass("wf-formButton");
                                            }
                                        }

                                        if (($function != null) || (this.IsDownloadLikeButton)) {
                                            if ((isTile) && (!System.String.isNullOrEmpty($function.Icon))) {
                                                htmlBtn.appendChild(($t = new Image(), $t.src = "data:image/png;base64," + ($function.Icon || ""), $t.className = "wf-buttonImage", $t));
                                            }

                                            htmlBtn.appendChild(($t = document.createElement("div"), $t.className = "wf-buttonCaption", $t.innerHTML = this.DataItem.Caption, $t));
                                        }

                                        if ((isTile) && (!formButtons)) {
                                            $tcs.setResult(this.MainControl);
                                            return;
                                        }

                                        if ((this.IsDownloadLikeButton) || (this.IsDownloadButton)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 5;
                                        continue;
                                    }
                                    case 1: {
                                        rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.Dataset.DSPFID);
                                        value = rec != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, this.FieldDef) : null;
                                        if (System.String.isNullOrEmpty(value)) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetEnabled.call(this, false);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }

                                    case 5: {
                                        div = $(document.createElement("div")).addClass("form-group col-auto mb-auto wf-control wf-button");
                                        if (formButtons) {
                                            div.append($("<div>").addClass(System.String.format("wf-label-div{0}", [wfTileCss])).append($("<label>").addClass("wf-empty").html("&nbsp;")));
                                        }

                                        if (this.IsDownloadLikeButton) {
                                            $(($t = document.createElement("label"), $t.innerHTML = this.FieldDef.Label, $t)).appendTo(div);
                                        }

                                        div.append(htmlBtn);
                                        this._fullControl = div;

                                        if (!this.IsDownloadLikeButton) {
                                            $step = 6;
                                            continue;
                                        } 
                                        $step = 8;
                                        continue;
                                    }
                                    case 6: {
                                        $task2 = this.SetControlProperties();
                                        $step = 7;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $task2.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(div);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CurrentRecordChanged: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $function, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        $function = this._function || this.GetFunction();

                                        if ((e == null) || (($function != null) && (Bridge.referenceEquals(e.DSPFID, $function.DSPFID)))) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.SetVisible(this.IsVisible);
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task2.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ButtonClick: function (e) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    rec, 
                    value, 
                    rec1, 
                    value1, 
                    dSig, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,10], $step);
                                switch ($step) {
                                    case 0: {
                                        if ((this.IsDownloadLikeButton) || (this.IsDownloadButton)) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.Dataset.DSPFID);
                                        value = rec != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, this.FieldDef) : null;
                                        if (!System.String.isNullOrEmpty(value)) {
                                            window.open("GetFile.ashx" + (value || ""));
                                        }
                                        $step = 10;
                                        continue;
                                    }
                                    case 2: {
                                        if (this.IsSignatureButton) {
                                            $step = 3;
                                            continue;
                                        } else  {
                                            $step = 7;
                                            continue;
                                        }
                                    }
                                    case 3: {
                                        rec1 = this.FormControl.CurrencyManager.GetCurrentRecord(this.Dataset.DSPFID);
                                        value1 = rec1 != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec1, this.FieldDef) : null;
                                        if (!System.String.isNullOrEmpty(value1)) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        dSig = new Adaptica.WebForms.WebApp.DataSignature();
                                        dSig.OnSuccessfulSignature = Bridge.fn.bind(this, function (signatureResult) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                Adaptica.WebForms.WebApp.WebFormsApp.Log(signatureResult);
                                                                $task1 = this.FormControl.ReloadData();
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                this.FormControl.SetNeedsReloadParents();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        });

                                        $task1 = dSig.SignData(value1);
                                        $step = 5;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task1.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        $step = 9;
                                        continue;
                                    }
                                    case 7: {
                                        $task2 = this.FormControl.ExecuteFunction(this.DataItem.PFPFID, e);
                                        $step = 8;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task2.getAwaitedResult();
                                        $step = 9;
                                        continue;
                                    }

                                    case 10: {
                                        e.preventDefault();
                                        e.stopPropagation();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return true;
            },
            SetControlProperties: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("ButtonControl \"{0}\" - SetControlProperties()", [this.DataItem.Caption]));

                                        $task1 = this.SetVisible(this.IsVisible);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.SetEnabled(this.IsEnabled);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $task3 = this.SetRequired(this.IsRequired);
                                        $step = 3;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetEnabled: function (enabled) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.IsDownloadLikeButton) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetEnabled.call(this, enabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.IsDownloadLikeButton) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        if (this._fullControl == null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetVisible.call(this, visible);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        if (visible) {
                                            this._fullControl.removeClass("wf-hidden");
                                        } else {
                                            this._fullControl.addClass("wf-hidden");
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            OnShow: function () {
                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnShow.call(this);

                var isTile = (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) || (this.FormControl.FormData.IsMainMenu);
                var ctrl = (isTile) ? this.MainControl : this._fullControl;

                if (ctrl == null) {
                    return;
                }

                if (this.IsVisible) {
                    ctrl.removeClass("wf-hidden");
                }
            },
            OnHide: function () {
                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnHide.call(this);

                var isTile = (this.DataItem.Type === Adaptica.WebForms.Common.DataModel.ContainerItem.ControlTypeEnum.TileButton) || (this.FormControl.FormData.IsMainMenu);
                var ctrl = (isTile) ? this.MainControl : this._fullControl;

                ctrl != null ? ctrl.addClass("wf-hidden") : null;
            },
            Focus: function () {
                return false;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.GridControlBase", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        statics: {
            methods: {
                IsKanbanGrid: function (containerItem) {
                    var grid = containerItem;
                    return System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).any(function (col) {
                            return Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIKanban);
                        });
                }
            }
        },
        fields: {
            _formData: null,
            _currentRecord: null,
            _tableScrollTop: 0,
            _control: null,
            _gridContentElem: null,
            _searchBar: null,
            _searchBarClearInput: null,
            _searchInput: null,
            _searchText: null,
            _filterOnServer: false,
            _isVisible: false,
            _orgOnToolbarAction: null,
            ImageDisplayType: 0,
            ImageMinSize: 0,
            _searchBarFilterIcon: null,
            _activeFilter: null
        },
        props: {
            AllowInlineInsert: {
                get: function () {
                    var ds = this.Dataset;
                    return (ds != null) && (ds.Header != null) && (ds.Header.ReadOnly === 0) && (ds.Header.Insert === 1);
                }
            },
            HasFilters: {
                get: function () {
                    var $t;
                    return System.Nullable.gt((($t = this.Dataset) != null ? $t.Header.Filters.length : null), 0);
                }
            },
            IsActiveFilter: {
                get: function () {
                    return this.FormControl.ActiveFilter.containsKey(this.DataItem.DSPFID);
                }
            }
        },
        alias: [
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "AllowEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowEdit",
            "AllowDelete", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowDelete",
            "AllowInsert", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowInsert",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this.ImageDisplayType = 1;
            },
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
                this._formData = formControl.FormData;

                formControl.CurrencyManager.addOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedWrapper));

                this.InitImageDisplayType();
            }
        },
        methods: {
            InitImageDisplayType: function () {
                var idt = window.getComputedStyle(window.document.documentElement).getPropertyValue("--wf-grid-imageDisplayType");
                if (!System.String.isNullOrEmpty(idt)) {
                    this.ImageDisplayType = System.Int32.parse(idt);
                }

                if (this.ImageDisplayType === 1) {
                    var s = "";
                    var defCss = Adaptica.WebForms.WebApp.WebFormsApp.GetCssStyle(".wf-dataImage", ["width", "height", "max-height"]);
                    if (defCss != null) {
                        s = (!Bridge.referenceEquals(defCss[System.Array.index(0, defCss)], "")) ? defCss[System.Array.index(0, defCss)] : defCss[System.Array.index(1, defCss)];
                    }

                    if ((Bridge.referenceEquals(s, "")) || (Bridge.referenceEquals(s, "auto"))) {
                        s = window.getComputedStyle(window.document.documentElement).getPropertyValue("--wf-dataImage-size");
                    }

                    if (!Bridge.referenceEquals(s, "")) {
                        if (System.String.indexOf(s, "px") > -1) {
                            s = System.String.replaceAll(s, "px", "");
                        }
                        var minSize = { };
                        System.Int32.tryParse(s, minSize);
                        this.ImageMinSize = minSize.v;
                    }
                }
            },
            CurrentRecordChangedWrapper: function (sender, args) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        for (;;) {
                            $step = System.Array.min([0,1], $step);
                            switch ($step) {
                                case 0: {
                                    $task1 = this.CurrentRecordChanged(sender, args);
                                    $step = 1;
                                    if ($task1.isCompleted()) {
                                        continue;
                                    }
                                    $task1.continue($asyncBody);
                                    return;
                                }
                                case 1: {
                                    $task1.getAwaitedResult();
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }, arguments);

                $asyncBody();
            },
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    ds, 
                    header, 
                    fieldDefs, 
                    gridWrapper, 
                    gridElem, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        this._orgOnToolbarAction = this.FormControl.OnToolbarAction;
                                        this.FormControl.OnToolbarAction = Bridge.fn.cacheBind(this, this.OnToolbarActionInternal);

                                        ds = this.Dataset;
                                        header = ds != null ? ds.Header : null;
                                        fieldDefs = header != null ? header.FieldDefs : null;

                                        $task1 = this.CreateSearchBar(ds, fieldDefs);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        gridWrapper = $("<div>").addClass("wf-grid-wrapper");

                                        gridElem = $("<div>").addClass("col-auto wf-grid").appendTo(gridWrapper);

                                        this._gridContentElem = $("<div>").addClass("wf-grid-content").appendTo(gridElem);

                                        this._control = gridWrapper;

                                        $task2 = this.RefreshRecords(ds, fieldDefs);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            OnToolbarActionInternal: function (action) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $task4, 
                    $taskResult4, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    cloned, 
                    ds, 
                    $t, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9], $step);
                                switch ($step) {
                                    case 0: {
                                        if (Bridge.referenceEquals(action, "Insert")) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 1: {
                                        cloned = Adaptica.WebForms.Common.DataModel.FormHelper.CloneFormOnlyForInlineInsert(this._formData, this.FormControl.CurrencyManager, this.DataItem.DSPFID);

                                        if (this.NeedsProcessDataOnInsert) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ProcessData(this.FormControl, cloned);
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        ds = System.Linq.Enumerable.from(cloned.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).first(Bridge.fn.bind(this, function (x) {
                                            return Bridge.referenceEquals(x.DSPFID, this.DataItem.DSPFID);
                                        }));
                                        $task3 = this.CreateAutoFieldsForm(cloned, ds, ($t = ds.Records)[System.Array.index(0, $t)], this.GetGridColumns(), true);
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task3.getAwaitedResult();
                                        $tcs.setResult(true);
                                        return;
                                    }
                                    case 6: {
                                        if ((!Bridge.staticEquals(this._orgOnToolbarAction, null))) {
                                            $step = 7;
                                            continue;
                                        }
                                        $taskResult1 = false;
                                        $step = 9;
                                        continue;
                                    }
                                    case 7: {
                                        $task4 = this._orgOnToolbarAction(action);
                                        $step = 8;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        $taskResult1 = ($taskResult4);
                                        $step = 9;
                                        continue;
                                    }
                                    case 9: {
                                        $tcs.setResult($taskResult1);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateSearchBar: function (ds, fieldDefs) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    timeoutId, 
                    $t, 
                    searchIconElem, 
                    row, 
                    row2, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        this._filterOnServer = (ds.RecordCount > 0) && (ds.RecordCount !== ds.Records.length);

                                        if ((this._searchBar != null) || (Bridge.is(this.FormControl, Adaptica.WebForms.WebApp.Controls.FilterSelectionFormControl)) || ((ds.Records.length <= 0) && (!this._filterOnServer))) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        timeoutId = 0;
                                        this._searchInput = $(($t = document.createElement("input"), $t.className = "form-control wf-grid-search", $t.onkeyup = Bridge.fn.bind(this, function (evnt) {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1,2,3,4], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                if ((evnt.altKey) || (evnt.metaKey)) {
                                                                    return;
                                                                }

                                                                if ((evnt.ctrlKey) && (evnt.keyCode !== 86)) {
                                                                    return;
                                                                }

                                                                if ((System.String.contains(evnt.key,"Arrow") || (System.Array.indexOfT(Adaptica.WebForms.WebApp.Controls.ControlUtils.IgnoreKeys, evnt.key) > -1))) {
                                                                    return;
                                                                }

                                                                window.clearTimeout(timeoutId);

                                                                evnt.preventDefault();
                                                                if (evnt.keyCode === 13) {
                                                                    $step = 1;
                                                                    continue;
                                                                } else  {
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                            }
                                                            case 1: {
                                                                this._searchText = (evnt.currentTarget || evnt.target).value;
                                                                $task1 = this.SetTextFilter(ds, fieldDefs);
                                                                $step = 2;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 2: {
                                                                $task1.getAwaitedResult();
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 3: {
                                                                timeoutId = window.setTimeout(Bridge.fn.bind(this, function () {
                                                                    var $step = 0,
                                                                        $task1, 
                                                                        $jumpFromFinally, 
                                                                        $asyncBody = Bridge.fn.bind(this, function () {
                                                                            for (;;) {
                                                                                $step = System.Array.min([0,1], $step);
                                                                                switch ($step) {
                                                                                    case 0: {
                                                                                        this._searchText = (evnt.currentTarget || evnt.target).value;
                                                                                        $task1 = this.SetTextFilter(ds, fieldDefs);
                                                                                        $step = 1;
                                                                                        if ($task1.isCompleted()) {
                                                                                            continue;
                                                                                        }
                                                                                        $task1.continue($asyncBody);
                                                                                        return;
                                                                                    }
                                                                                    case 1: {
                                                                                        $task1.getAwaitedResult();
                                                                                        return;
                                                                                    }
                                                                                    default: {
                                                                                        return;
                                                                                    }
                                                                                }
                                                                            }
                                                                        }, arguments);

                                                                    $asyncBody();
                                                                }), 500);
                                                                $step = 4;
                                                                continue;
                                                            }
                                                            case 4: {
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }), $t));

                                        searchIconElem = $("<span>").addClass("fas fa-search wf-search-icon");

                                        this._searchBar = $("<div>").addClass("wf-grid-search-box fade wf-hidden");

                                        row = $("<div>").addClass("wf-search-row").appendTo(this._searchBar);

                                        if (this.HasFilters) {
                                            this._searchBar.addClass("wf-with-filter");
                                            row.append(this.CreateSearchBarFilterIcon());
                                        }

                                        row.append(searchIconElem).append(this._searchInput);

                                        row2 = $("<div>").addClass("wf-search-row").appendTo(this._searchBar);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("RecordsCountFormatted", [Bridge.toString(this.Dataset.RecordCount)]);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $("<div>").addClass("wf-grid-recCount").html($taskResult1).appendTo(row2);

                                        this._searchBarClearInput = Adaptica.WebForms.WebApp.Controls.FormControl.AppendClearContent(row, this._searchInput, Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                this._searchText = this._searchInput.val();
                                                                $task1 = this.SetTextFilter(ds, fieldDefs);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));

                                        this._searchBar.appendTo(this.FormControl.Containers.Top);
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetTextFilter: function (ds, fieldDefs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    textFilters, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (!this._filterOnServer) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.RefreshRecords(ds, fieldDefs);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        textFilters = this.FormControl.TextFilter;
                                        if (textFilters.containsKey(this.DataItem.DSPFID)) {
                                            if (System.String.isNullOrEmpty(this._searchText)) {
                                                textFilters.remove(this.DataItem.DSPFID);
                                            } else {
                                                textFilters.setItem(this.DataItem.DSPFID, this._searchText);
                                            }
                                        } else {
                                            if (!System.String.isNullOrEmpty((this._searchText))) {
                                                textFilters.add(this.DataItem.DSPFID, this._searchText);
                                            }
                                        }

                                        $task2 = this.FormControl.ReloadData();
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RefreshRecords: function (dset, fieldDefs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    header, 
                    recs, 
                    cnt, 
                    $t, 
                    $t1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6], $step);
                                switch ($step) {
                                    case 0: {
                                        if (dset === void 0) { dset = null; }
                                        if (fieldDefs === void 0) { fieldDefs = null; }
                                        Adaptica.WebForms.WebApp.WebFormsApp.Log("Refresh records called.");

                                        if (dset == null) {
                                            dset = this.FormControl.CurrencyManager.GetCurrentDataset(this.DataItem.DSPFID);
                                        }

                                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("Dataset dsid: {0}, dspfid: {1}.", dset.DSID, dset.DSPFID));

                                        /* 
                                                   var currRec = FormControl.CurrencyManager.GetCurrentRecord(dset.DSPFID);
                                                   if ((currRec != null) && (currRec.RecID == null))  // new record
                                                   {
                                                       WebFormsApp.Log("Current record is empty or has empty RecId.");
                                                       //CreateAutoFieldsForm(dset, currRec, GetGridColumns(), true);
                                                       return;
                                                   }
                                        */

                                        header = dset != null ? dset.Header : null;
                                        if (fieldDefs == null) {
                                            fieldDefs = header != null ? header.FieldDefs : null;
                                            if (fieldDefs == null) {
                                                Adaptica.WebForms.WebApp.WebFormsApp.Log("No field definitions.");
                                                $tcs.setResult(null);
                                                return;
                                            }
                                        }

                                        this.ClearTable();

                                        recs = (System.String.isNullOrEmpty(this._searchText)) ? System.Linq.Enumerable.from(dset.Records, Adaptica.WebForms.Common.DataModel.Record).orderBy(function (rec) {
                                            return rec.RecNo;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.Record) : System.Linq.Enumerable.from(dset.Records, Adaptica.WebForms.Common.DataModel.Record).where(Bridge.fn.bind(this, function (rec) {
                                            return System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).any(Bridge.fn.bind(this, function (fd) {
                                                return this.SearchMatcher(rec, fd, this._searchText);
                                            }));
                                        })).orderBy(function (rec) {
                                            return rec.RecNo;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.Record);

                                        $task1 = this.CreateGridContent(this._formData, dset, this.DataItem, fieldDefs, recs);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        if (this._searchBar != null) {
                                            $step = 2;
                                            continue;
                                        } else  {
                                            $step = 4;
                                            continue;
                                        }
                                    }
                                    case 2: {
                                        cnt = (System.String.isNullOrEmpty(this._searchText)) ? this.Dataset.RecordCount : recs.length;
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("RecordsCountFormatted", [Bridge.toString(cnt)]);
                                        $step = 3;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        this._searchBar.find(".wf-grid-recCount").html($taskResult2);

                                        if ((this._isVisible) && ((cnt > 1) || (!System.String.isNullOrEmpty(this._searchText)) || (this.IsActiveFilter))) {
                                            this._searchBar.addClass("show");
                                            this._searchBar.removeClass("wf-hidden");
                                        } else {
                                            this._searchBar.removeClass("show");
                                            this._searchBar.addClass("wf-hidden");
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task3 = this.CreateSearchBar(this.Dataset, ($t = this.Dataset) != null && ($t1 = $t.Header) != null ? $t1.FieldDefs : null);
                                        $step = 5;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task3.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        window.setTimeout(Bridge.fn.bind(this, function () {
                                            this._searchInput != null ? this._searchInput.focus() : null;
                                        }), 10);
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ClearTable: function () {
                this._gridContentElem.find("*").off("click");
                this._gridContentElem.empty();
            },
            SearchMatcher: function (rec, fd, textToSearch) {
                return (fd.Hidden === 0) && (fd.Type !== Adaptica.WebForms.Common.DataModel.FieldType.Blob) && (System.String.indexOf(Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fd), textToSearch, 0, null, 3) > -1);
            },
            SetColumnValue: function (col, valueElem, fieldDef, value, text, color) {
                if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileFontIcon)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreateMobileFontValue(valueElem, value);
                    }
                } else if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreateDownloadFileValue(valueElem, value);
                    }
                } else if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreatePrintFileValue(valueElem, value);
                    }
                } else if (Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIURL)) {
                    if (!System.String.isNullOrEmpty(value)) {
                        this.CreateUrlValue(valueElem, value);
                    }
                } else {
                    if ((!System.String.isNullOrEmpty(text)) && (fieldDef.Type >= Adaptica.WebForms.Common.DataModel.FieldType.Memo) && (fieldDef.Type <= Adaptica.WebForms.Common.DataModel.FieldType.LString)) {
                        valueElem.html(System.String.replaceAll(text, "_", "_<wbr>")).attr("title", text);
                    } else {
                        valueElem.html(text).attr("title", text);
                    }

                    Adaptica.WebForms.WebApp.Controls.ControlUtils.SetFontProperties$1(color, fieldDef.Values, col.FontStyle, valueElem, value);
                }
            },
            CreateMobileFontValue: function (valueElem, value) {
                var icon = $("<i>");

                Adaptica.WebForms.WebApp.Controls.EditView.SetFontIconValue(icon, value);

                valueElem.append(icon);
            },
            CreateUrlValue: function (valueElem, value) {
                var url = value;

                if ((System.String.indexOf(url, "://", 0, null, 4) === -1) && (!System.String.startsWith(url, "//"))) {
                    url = System.String.format("//{0}", [value]);
                }

                var jq = $("<a>").attr("href", "#").html(value).on("click", function (e) {
                    e.stopPropagation();
                    e.preventDefault();

                    window.open(url);
                });

                valueElem.append(jq);
            },
            CreateDownloadFileValue: function (valueElem, value) {
                this.CreateFileLinkValue("paperclip", valueElem, value);
            },
            CreatePrintFileValue: function (valueElem, value) {
                this.CreateFileLinkValue("print", valueElem, value);
            },
            CreateFileLinkValue: function (iconClass, valueElem, value) {
                var icon = $("<i>").addClass(System.String.format("fas fa-{0}", [iconClass]));

                var groupIconInnerDiv = $("<div>").addClass("input-group-text").append(icon);

                var groupIconDiv = $("<div>").attr("id", System.String.format("{0}-append", [this.ControlId])).addClass("input-group-append").on("click", function (e) {
                    e.stopPropagation();
                    e.preventDefault();

                    window.open("GetFile.ashx" + (value || ""));
                }).append(groupIconInnerDiv);

                valueElem.append(groupIconDiv);
            },
            OnRowClick: function (form, dset, recs, cols, localRecNo) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    rec, 
                    $function, 
                    cloned, 
                    ds, 
                    $t, 
                    masterId, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.IsEditing) {
                                            $tcs.setResult(null);
                                            return;
                                        }

                                        rec = recs[System.Array.index(localRecNo, recs)];
                                        this.FormControl.CurrencyManager.SetCurrentRecord(dset.DSPFID, rec);

                                        $task1 = this.FormControl.ExecuteGridDefaultAction(dset.DSPFID, rec);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        if ($taskResult1) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 2: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        $function = System.Linq.Enumerable.from(form.Functions, Adaptica.WebForms.Common.DataModel.Function).firstOrDefault(Bridge.fn.bind(this, function (fn) {
                                            return (Bridge.referenceEquals(fn.DSPFID, dset.DSPFID)) && (this.IsFunctionEnabled(fn, rec));
                                        }), null);
                                        if ($function == null) {
                                            $step = 4;
                                            continue;
                                        } else  {
                                            $step = 6;
                                            continue;
                                        }
                                    }
                                    case 4: {
                                        cloned = Adaptica.WebForms.Common.DataModel.FormHelper.CloneFormOnlyForInlineEdit(this._formData, this.FormControl.CurrencyManager, this.DataItem.DSPFID, rec);
                                        ds = System.Linq.Enumerable.from(cloned.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).first(Bridge.fn.bind(this, function (x) {
                                            return Bridge.referenceEquals(x.DSPFID, this.DataItem.DSPFID);
                                        }));
                                        $task2 = this.CreateAutoFieldsForm(cloned, ds, ($t = ds.Records)[System.Array.index(0, $t)], this.GetGridColumns(), false);
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task2.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 6: {
                                        masterId = Adaptica.WebForms.Common.DataModel.FunctionHelper.GetRecordMasterId($function, rec);
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$1("GetForm", { PFPFID: $function.PFPFID, MasterID: masterId }, Bridge.fn.bind(this, function (dto) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CreateForm$1(dto, this.FormControl);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 7;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $task3.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetSearchableColumnList: function (dset) {
                var columns = System.Linq.Enumerable.from(dset.Header.FieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).where(function (fd) {
                        return function (_o1) {
                                _o1.add(1);
                                _o1.add(2);
                                _o1.add(4);
                                _o1.add(5);
                                _o1.add(6);
                                _o1.add(7);
                                _o1.add(8);
                                _o1.add(9);
                                return _o1;
                            }(new (System.Collections.Generic.List$1(System.Int32)).ctor()).contains(fd.Type) && (fd.Hidden === 0);
                    }).select(function (fd) {
                    return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetSearchHint(fd);
                }).toList(System.String);

                columns.Sort();

                return Bridge.toArray(columns).join("<br>");
            },
            CreateAutoFieldsForm: function (form, dset, rec, gridColumns, beginEdit) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    fDefs, 
                    ds, 
                    c, 
                    items, 
                    col, 
                    fieldDef, 
                    fd, 
                    ci, 
                    $t, 
                    edit, 
                    currentFormId, 
                    inlineForm, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (beginEdit === void 0) { beginEdit = false; }
                                        fDefs = dset.Header.FieldDefs;

                                        ds = dset;
                                        if (!Bridge.referenceEquals(ds.DSPFID, this.DataItem.DSPFID)) {
                                            ds = System.Linq.Enumerable.from(form.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).firstOrDefault(Bridge.fn.bind(this, function (d) {
                                                return Bridge.referenceEquals(d.DSPFID, this.DataItem.DSPFID);
                                            }), null);
                                        }

                                        c = new Adaptica.WebForms.Common.DataModel.Container();
                                        items = new (System.Collections.Generic.List$1(Adaptica.WebForms.Common.DataModel.ContainerItem)).ctor();

                                        for (var i = 0; i < gridColumns.length; i = (i + 1) | 0) {
                                            col = { v : gridColumns[System.Array.index(i, gridColumns)] };

                                            fieldDef = System.Linq.Enumerable.from(fDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                                return function (fld) {
                                                    return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                                };
                                            })(this, col), null);
                                            if (fieldDef.Hidden !== 0) {
                                                continue;
                                            }

                                            fd = null;
                                            ci = null;
                                            if (ds != null) {
                                                fd = System.Linq.Enumerable.from(ds.Header.FieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).firstOrDefault((function ($me, col) {
                                                    return function (f) {
                                                        return Bridge.referenceEquals(f.Name, col.v.FieldName);
                                                    };
                                                })(this, col), null);
                                            }
                                            if (fd != null && fd.Type === 3) {
                                                ci = ($t = new Adaptica.WebForms.Common.DataModel.Image(), $t.ItemType = "Image", $t);
                                            } else if (fd != null && fd.Type === 4) {
                                                ci = ($t = new Adaptica.WebForms.Common.DataModel.Memo(), $t.ItemType = "Memo", $t);
                                            } else {
                                                edit = ($t = new Adaptica.WebForms.Common.DataModel.Edit(), $t.ItemType = "Edit", $t.FontColor = col.v.FontColor, $t.FontStyle = col.v.FontStyle, $t);
                                                ci = edit;
                                            }

                                            ci.DSPFID = this.DataItem.DSPFID;
                                            ci.FieldName = col.v.FieldName;
                                            ci.Action = col.v.Action;
                                            ci.Order = col.v.Order;
                                            items.add(ci);
                                        }

                                        c.Items = System.Linq.Enumerable.from(items, Adaptica.WebForms.Common.DataModel.ContainerItem).orderBy(function (i1) {
                                            return i1.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.ContainerItem);
                                        form.Design.Containers = System.Array.init([c], Adaptica.WebForms.Common.DataModel.Container);

                                        currentFormId = Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm.FormId;
                                        currentFormId = (currentFormId || "") + "_AutoFieldsForm";

                                        inlineForm = ($t = new Adaptica.WebForms.WebApp.Controls.InlineFormControl(this.DataItem, form, this.FormControl), $t.FormId = currentFormId, $t.IsInlineForm = true, $t);
                                        inlineForm.CurrencyManager.SetCurrentRecord(dset.DSPFID, rec);

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DisplayFormControl(inlineForm);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        inlineForm.RefreshData();

                                        if (beginEdit) {
                                            inlineForm.BeginEdit();
                                        }
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            HandleImageOnLoad: function (img) {
                img.on("load", Bridge.fn.bind(this, function () {
                    var imgElem = Bridge.as(img.get(0), HTMLImageElement);

                    img.off("load");

                    var w = imgElem.naturalWidth;
                    var h = imgElem.naturalHeight;
                    if (this.ImageDisplayType === 0) {
                        if (h > w) {
                            img.removeClass("wf-dataImage");
                            img.addClass("wf-dataImage-h");
                        }
                    } else {
                        var canvas = Bridge.as(document.createElement("canvas"), HTMLCanvasElement);
                        var ctx = Bridge.as(canvas.getContext("2d"), CanvasRenderingContext2D);
                        if (w > h) {
                            var newWidth = System.Decimal.toInt((System.Decimal(this.ImageMinSize).div(System.Decimal(h))).mul(System.Decimal(w)), System.Int32);
                            canvas.width = newWidth;
                            canvas.height = this.ImageMinSize;
                            ctx.drawImage(imgElem, 0, 0, newWidth, this.ImageMinSize);
                        } else {
                            var newHeight = System.Decimal.toInt((System.Decimal(this.ImageMinSize).div(System.Decimal(w))).mul(System.Decimal(h)), System.Int32);
                            canvas.width = this.ImageMinSize;
                            canvas.height = newHeight;
                            ctx.drawImage(imgElem, 0, 0, this.ImageMinSize, newHeight);
                        }

                        var url = canvas.toDataURL();
                        img.attr("src", url);
                    }

                }));
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return false;
            },
            AllowEdit: function (DSPFID) {
                return this.FormControl.CurrencyManager.GetCurrentDataset(this.DataItem.DSPFID).Header.SaveMode === 1;
            },
            AllowDelete: function (DSPFID) {
                return false;
            },
            AllowInsert: function (DSPFID) {
                return Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.AllowInsert.call(this, DSPFID) || this.AllowInlineInsert;
            },
            IsFunctionEnabled: function (f, record) {
                return Adaptica.WebForms.Common.DataModel.FunctionHelper.IsFunctionEnabledForRecord(f, record);
            },
            RaiseDataChanged: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.RaiseDataChanged.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.RefreshRecords();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            Focus: function () {
                return false;
            },
            OnShow: function () {
                this._isVisible = true;

                if ((this._searchBar != null) && (this.Dataset.RecordCount > 1)) {
                    this._searchBar.addClass("show");
                    this._searchBar.removeClass("wf-hidden");
                }
                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnShow.call(this);
            },
            OnHide: function () {
                this._isVisible = false;

                if (this._searchBar != null) {
                    this._searchBar.removeClass("show");
                    this._searchBar.addClass("wf-hidden");
                }

                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.OnHide.call(this);
            },
            Dispose: function () {
                if (this.IsDisposed) {
                    return;
                }

                this.FormControl.CurrencyManager.removeOnCurrentRecordChanged(Bridge.fn.cacheBind(this, this.CurrentRecordChangedWrapper));

                if (this._gridContentElem != null) {
                    this._gridContentElem.find(".wf-grid-row").off("click");
                    this._gridContentElem.empty();
                }

                if ((!Bridge.staticEquals(this._orgOnToolbarAction, null)) && (Bridge.staticEquals(this.FormControl.OnToolbarAction, this._orgOnToolbarAction))) {
                    this.FormControl.OnToolbarAction = this._orgOnToolbarAction;
                }

                this._searchInput != null ? this._searchInput.off() : null;
                this._searchBarClearInput != null ? this._searchBarClearInput.off() : null;

                this._formData = null;
                this._currentRecord = null;
                this._control = null;
                this._gridContentElem = null;
                this._searchInput = null;
                this._searchBar = null;

                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.Dispose.call(this);
            },
            GetActiveFilterNames: function () {
                var $t, $t1;
                return (($t = this.Dataset) != null && ($t1 = $t.Header.Filters) != null ? System.Linq.Enumerable.from($t1, Adaptica.WebForms.Common.DataModel.Filter).select(function (f) {
                        return f.Name;
                    }).toList(System.String) : null) || new (System.Collections.Generic.List$1(System.String)).ctor();
            },
            FilterForName: function (filterName) {
                var $t;
                return ($t = this.Dataset) != null ? System.Linq.Enumerable.from($t.Header.Filters, Adaptica.WebForms.Common.DataModel.Filter).firstOrDefault(function (f) {
                        return Bridge.referenceEquals(f.Name, filterName);
                    }, null) : null;
            },
            ActiveFilterFor: function (filterName) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    filter, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        filter = this.FilterForName(filterName);
                                        if (filter == null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.ApplyActiveFilter(null);
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    case 3: {
                                        if (filter.Type === 1) {
                                            $step = 4;
                                            continue;
                                        } else  {
                                            $step = 6;
                                            continue;
                                        }
                                    }
                                    case 4: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.ShowFilterForm(null, filter, Bridge.fn.bind(this, function () {
                                            var $step = 0,
                                                $task1, 
                                                $jumpFromFinally, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    for (;;) {
                                                        $step = System.Array.min([0,1], $step);
                                                        switch ($step) {
                                                            case 0: {
                                                                $task1 = this.ApplyActiveFilter(filter);
                                                                $step = 1;
                                                                if ($task1.isCompleted()) {
                                                                    continue;
                                                                }
                                                                $task1.continue($asyncBody);
                                                                return;
                                                            }
                                                            case 1: {
                                                                $task1.getAwaitedResult();
                                                                return;
                                                            }
                                                            default: {
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                        }));
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task2.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 6: {
                                        $task3 = this.ApplyActiveFilter(filter);
                                        $step = 7;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 7: {
                                        $task3.getAwaitedResult();
                                        $step = 8;
                                        continue;
                                    }
                                    case 8: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ApplyActiveFilter: function (filter) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    filterId, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        this._activeFilter = filter;

                                        filterId = filter != null ? filter.ID : null;
                                        if (this.FormControl.ActiveFilter.containsKey(this.DataItem.DSPFID)) {
                                            if (System.String.isNullOrEmpty(filterId)) {
                                                this.FormControl.ActiveFilter.remove(this.DataItem.DSPFID);
                                                this._searchBarFilterIcon.removeClass("mdi-filter").addClass("mdi-filter-outline");
                                                this.SetCaption();
                                            } else {
                                                this.FormControl.ActiveFilter.setItem(this.DataItem.DSPFID, filterId);
                                                this._searchBarFilterIcon.removeClass("mdi-filter-outline").addClass("mdi-filter");
                                                this.SetCaption();
                                            }
                                        } else {
                                            if (!System.String.isNullOrEmpty(filterId)) {
                                                this.FormControl.ActiveFilter.add(this.DataItem.DSPFID, filterId);
                                                this._searchBarFilterIcon.removeClass("mdi-filter-outline").addClass("mdi-filter");
                                                this.SetCaption();
                                            }
                                        }


                                        $task1 = this.FormControl.ReloadData();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetCaption: function () {
                if (this._activeFilter == null) {
                    this.FormControl.Toolbar.SetCaption(this.FormControl.Caption);
                    this._searchBarFilterIcon.removeAttr("title");
                } else {
                    this.FormControl.Toolbar.SetCaption((this.FormControl.Caption || "") + " &nbsp; &nbsp; Filtr: " + (this._activeFilter.Name || ""));
                    this._searchBarFilterIcon.attr("title", this._activeFilter.Name);
                }
            },
            CreateSearchBarFilterIcon: function () {
                this._searchBarFilterIcon = $("<i>");
                this._searchBarFilterIcon.addClass("mdi mdi-filter-outline wf-filter-icon").on("click", Bridge.fn.bind(this, function (ev) {
                    this.DisplayActionSheet(ev.currentTarget);
                    ev.preventDefault();
                }));

                return this._searchBarFilterIcon;
            },
            DisplayActionSheet: function (elem) {
                var cancelAction = Adaptica.WebForms.WebApp.WebFormsApp.GetText("CancelButton");
                var removeFilterAction = this.IsActiveFilter ? Adaptica.WebForms.WebApp.WebFormsApp.GetText("CancelFilterAction") : null;
                Adaptica.WebForms.WebApp.Controls.ActionSheet.DisplayActionSheet(elem, Adaptica.WebForms.WebApp.WebFormsApp.GetText("ActiveFilter"), cancelAction, removeFilterAction, Bridge.fn.bind(this, function (selectedFilter) {
                    var $step = 0,
                        $task1, 
                        $task2, 
                        $jumpFromFinally, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7], $step);
                                switch ($step) {
                                    case 0: {
                                        if (!Bridge.referenceEquals(selectedFilter, cancelAction)) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 7;
                                        continue;
                                    }
                                    case 1: {
                                        if (Bridge.referenceEquals(selectedFilter, removeFilterAction)) {
                                            $step = 2;
                                            continue;
                                        } else  {
                                            $step = 4;
                                            continue;
                                        }
                                    }
                                    case 2: {
                                        $task1 = this.ActiveFilterFor(null);
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task2 = this.ActiveFilterFor(selectedFilter);
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $task2.getAwaitedResult();
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }), this.GetActiveFilterNames().ToArray());
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.EditControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _control: null,
            IsGridEdit: false
        },
        props: {
            IsEnabled: {
                get: function () {
                    return (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileCurrentLocalTime)) || Bridge.ensureBaseProperty(this, "IsEnabled").$Adaptica$WebForms$WebApp$Controls$ControlBase$IsEnabled;
                }
            },
            IsVisible: {
                get: function () {
                    if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileCurrentLocalTime)) {
                        return false;
                    }

                    return Bridge.ensureBaseProperty(this, "IsVisible").$Adaptica$WebForms$WebApp$Controls$ControlBase$IsVisible;
                }
            }
        },
        alias: [
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "AllowCurrentRecordNavigation", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$AllowCurrentRecordNavigation",
            "IsValid", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsValid",
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "BeforeEndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeforeEndEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit",
            "EndFailed", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndFailed"
        ],
        ctors: {
            ctor: function (form, dataItem, currentRecord) {
                if (currentRecord === void 0) { currentRecord = null; }

                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, form, dataItem, currentRecord);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                var $t;
                var value;

                value = ((this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) || (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Set)) ? ($t = this.Value, $t != null ? $t : "-1") : this.Text;

                this.View.SetControlValue(value);

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.CurrentRecord == null) {
                                            this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.DataItem.DSPFID);
                                        }

                                        this.View = Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateViewByFieldDefType(this.FormControl, this, this.DataItem, this.Dataset, this.FieldDef, this.CurrentRecord);
                                        $task1 = this.View.GetControl();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        this._control = $taskResult1;
                                        this.MainControl = this.View.MainControl;

                                        $task2 = this.SetControlProperties();
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        this.View.Change(Bridge.fn.bind(this, function (s) {
                                            this.Value = s;
                                        }));

                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            RaiseDataChanged: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.RaiseDataChanged.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $task2 = this.CurrentRecordChanged(null, null);
                                        $step = 2;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            AllowCurrentRecordNavigation: function (DSPFID) {
                return Bridge.referenceEquals(this.DataItem.DSPFID, DSPFID);
            },
            IsValid: function (sb) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    value, 
                    $t, 
                    _discard1, 
                    maxValue, 
                    d, 
                    _discard2, 
                    _discard3, 
                    _discard4, 
                    _discard5, 
                    _discard6, 
                    _discard7, 
                    _discard8, 
                    _discard9, 
                    _discard10, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,12,13,15], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.IsValid.call(this, sb);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;
                                        value = this.Value;

                                        if ((result) && (!System.String.isNullOrEmpty(value))) {
                                            $step = 2;
                                            continue;
                                        } 
                                        $step = 15;
                                        continue;
                                    }
                                    case 2: {
                                        $t = this.FieldDef.Type;
                                        if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Integer) {
                                            $step = 3;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Float) {
                                            $step = 7;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) {
                                            $step = 11;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Date) {
                                            $step = 12;
                                            continue;
                                        }
                                        else if ($t === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                                            $step = 13;
                                            continue;
                                        }
                                        $step = 14;
                                        continue;
                                    }
                                    case 3: {
                                        _discard1 = { };
                                        if (!System.Int32.tryParse(value, _discard1)) {
                                            $step = 4;
                                            continue;
                                        } 
                                        $step = 6;
                                        continue;
                                    }
                                    case 4: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("ValidationInvalidNumberField", [this.FieldDef.Label]);
                                        $step = 5;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 5: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        sb.appendLine($taskResult2);
                                        result = false;
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {
                                        $step = 14;
                                        continue;
                                    }
                                    case 7: {
                                        maxValue = System.Decimal(99999999999.9999, 4);

                                        value = Adaptica.WebForms.WebApp.Extensions.NormalizeFloat(value);
                                        d = { };

                                        if ((!System.Decimal.tryParse(value, null, d)) || (maxValue.neg().gt(d.v) || d.v.gt(maxValue))) {
                                            $step = 8;
                                            continue;
                                        } 
                                        $step = 10;
                                        continue;
                                    }
                                    case 8: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("ValidationInvalidFloatField", [this.FieldDef.Label]);
                                        $step = 9;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 9: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        sb.appendLine($taskResult3);
                                        result = false;
                                        $step = 10;
                                        continue;
                                    }
                                    case 10: {
                                        $step = 14;
                                        continue;
                                    }
                                    case 11: {
                                        _discard2 = { };
                                        _discard3 = { };
                                        _discard4 = { };
                                        _discard5 = { };
                                        if ((!System.DateTime.tryParseExact(value, "yyyy-MM-dd HH:mm:ss.fff", null, _discard2)) && (!System.DateTime.tryParseExact(value, "yyyy-MM-dd HH:mm:ss", null, _discard3)) && (!System.DateTime.tryParseExact(value, "yyyy-MM-dd HH:mm", null, _discard4)) && (!System.DateTime.tryParse(value, null, _discard5))) {
                                            sb.appendLine("Chybn\u00e1 hodnota");
                                            result = false;
                                        }

                                        $step = 14;
                                        continue;
                                    }
                                    case 12: {
                                        _discard6 = { };
                                        if (!System.DateTime.tryParseExact(value, "yyyy-MM-dd", null, _discard6)) {
                                            sb.appendLine("Chybn\u00e1 hodnota");
                                            result = false;
                                        }

                                        $step = 14;
                                        continue;
                                    }
                                    case 13: {
                                        _discard7 = { };
                                        _discard8 = { };
                                        _discard9 = { };
                                        _discard10 = { };
                                        if ((!System.DateTime.tryParseExact(value, "HH:mm:ss.fff", null, _discard7)) && (!System.DateTime.tryParseExact(value, "HH:mm:ss", null, _discard8)) && (!System.DateTime.tryParseExact(value, "HH:mm", null, _discard9)) && (!System.DateTime.tryParse(value, null, _discard10))) {
                                            sb.appendLine("Chybn\u00e1 hodnota");
                                            result = false;
                                        }

                                        $step = 14;
                                        continue;
                                    }

                                    case 15: {
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.BeginEdit();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.BeginEdit.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeforeEndEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.BeforeEndEdit();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileCurrentLocalTime)) {
                                            this.Text = System.DateTime.format(System.DateTime.getNow(), "O", System.Globalization.CultureInfo.invariantCulture);
                                        }

                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.BeforeEndEdit.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.EndEdit();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.EndEdit.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndFailed: function () {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (this.View != null) {
                                            $step = 1;
                                            continue;
                                        } 
                                        $step = 3;
                                        continue;
                                    }
                                    case 1: {
                                        $task1 = this.View.EndFailed();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $task1.getAwaitedResult();
                                        $step = 3;
                                        continue;
                                    }
                                    case 3: {
                                        $task2 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.EndFailed.call(this);
                                        $step = 4;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.FilterSelectionFormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.FormControl],
        fields: {
            _onSaved: null
        },
        ctors: {
            ctor: function (formData, parentForm, onSaved) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.FormControl.ctor.call(this, formData, parentForm);
                this._onSaved = onSaved;
            }
        },
        methods: {
            EndEdit: function (save) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (save === void 0) { save = true; }
                                        $task1 = Adaptica.WebForms.WebApp.Controls.FormControl.prototype.EndEdit.call(this, save);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        result = $taskResult1;

                                        if (result) {
                                            this._onSaved();
                                        }

                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.ImageControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _topControl: null,
            _fileInput: null,
            _image: null,
            _required: null
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    return true;
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus"
        ],
        ctors: {
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIImage)) {
                                            result = this.CreateEditableImage();
                                        } else {
                                            result = this.CreateImage();
                                        }

                                        $task1 = this.SetEnabled(this.IsEnabled);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        this._topControl = result;
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            CreateEditableImage: function () {
                var $t;
                var div = $("<div>").addClass("text-center wf-qiImage");

                var ctrl = this.CreateImage();
                this._image = this.MainControl;
                var parent = this._image.parent();
                this._image.detach();

                var del = this.CreateImageButton("fas fa-trash");
                var add = this.CreateImageButton("fas fa-plus-square");
                var cam = this.CreateImageButton("fas fa-camera");

                del.on("click", Bridge.fn.bind(this, function () {
                    if (!this.IsEnabled) {
                        return;
                    }

                    var width = this._image.css("width");

                    this._image.css("visibility", "hidden");
                    this._image.attr("src", "");
                    this._image.addClass("empty");
                    this.Value = null;
                }));

                add.on("click", Bridge.fn.bind(this, function (e) {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (!this.IsEnabled) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        e.preventDefault();
                                        $step = 4;
                                        continue;
                                    }
                                    case 2: {
                                        e.preventDefault();

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("SessionState", null, "POST", Bridge.fn.bind(this, function (dto) {
                                            this._fileInput.click();
                                            return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
                                        }), function (statusCode, statusText, errorText) {
                                            if (statusCode === 401) {
                                                window.setTimeout(Bridge.fn.bind(this, function () {
                                                    var $step = 0,
                                                        $task1, 
                                                        $jumpFromFinally, 
                                                        $asyncBody = Bridge.fn.bind(this, function () {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.DoLogout();
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        }, arguments);

                                                    $asyncBody();
                                                }), 100);
                                            }

                                            return System.Threading.Tasks.Task.fromResult(false, System.Boolean);
                                        });
                                        $step = 3;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 3: {
                                        $task1.getAwaitedResult();
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    $asyncBody();
                }));

                var addLabel = $("<label>").attr("for", System.String.format("{0}_file", [this.ControlId])).append(add);

                this._fileInput = ($t = document.createElement("input"), $t.id = System.String.format("{0}_file", [this.ControlId]), $t.type = "file", $t);

                this._fileInput.onchange = Bridge.fn.bind(this, function (evnt) {
                    var file = this._fileInput.files[0];
                    this.CreateImageFromFile(file);
                });

                var jqInput = $(this._fileInput).addClass("wf-dataImage-select");

                var imgOuterDiv = $("<div>").addClass("wf-dataImage-outer").append(this._image);

                var tmpFocus = $("<input>").attr("type", "text").addClass("wf-input-hidden");

                imgOuterDiv.on("click", Bridge.fn.bind(this, function () {
                    if (!this.IsEnabled) {
                        return;
                    }

                    ctrl.find(".wf-dataImage-outer.active").removeClass("active");
                    imgOuterDiv.addClass("active");
                    tmpFocus.focus();
                }));

                tmpFocus.on("blur", function () {
                    imgOuterDiv.removeClass("active");
                });

                div.append(imgOuterDiv).append($("<div>").addClass("wf-dataImage-buttons").append(del).append(addLabel).append(jqInput).append(tmpFocus));

                parent.append(div);


                $("html").on("paste", Bridge.fn.bind(this, function (e) {
                    var $t1;
                    if (!this.FormControl.IsActivated) {
                        return;
                    }

                    var active = this._topControl.find(".wf-dataImage-outer.active");
                    if (active.length === 0) {
                        return;
                    }

                    var d = e;
                    if (e.originalEvent != null) {
                        d = e.originalEvent;
                    }
                    var evnt = d;

                    var cb = evnt.clipboardData;
                    for (var i = 0; i < cb.types.length; i = (i + 1) | 0) {
                        var cbType = ($t1 = cb.types)[System.Array.index(i, $t1)];
                        if ((System.String.indexOf(cbType, "image", 0, null, 5) === -1) && (System.String.indexOf(cb.items[i].type, "image", 0, null, 5) === -1)) {
                            continue;
                        }

                        var file = cb.items[i].getAsFile();
                        this.CreateImageFromFile(file);
                    }
                }));


                this.MainControl = div;

                return ctrl;
            },
            CreateImage: function () {
                var $t, $t1, $t2;
                var id = this.ControlId;
                var label = ($t = this.FieldDef) != null ? $t.Label : null;

                var divElem = $("<div>").addClass("form-group col-auto wf-w-100-minus-scroll mb-auto wf-control wf-image");

                $(($t1 = document.createElement("label"), $t1.htmlFor = id, $t1.innerHTML = label, $t1)).appendTo(divElem);

                this._required = $("<span>").addClass("wf-required").html("*").appendTo(divElem);

                if (!this.IsRequired) {
                    this._required.addClass("wf-hidden");
                }

                var inputGroup = $("<div>").addClass("input-group").appendTo(divElem);

                var val = this.Value;
                this._image = ($t1 = $(($t2 = new Image(), $t2.id = id, $t2.className = "wf-dataImage", $t2)).appendTo(inputGroup), this.MainControl = $t1, $t1);

                if (System.String.isNullOrEmpty(val)) {
                    this.MainControl.addClass("empty");
                    this.MainControl.css("visibility", "hidden");
                } else {
                    this._image.attr("src", "data:image/png;base64," + (val || ""));
                }

                return divElem;
            },
            CreateImageButton: function (className) {
                var btn = $("<i>").addClass(className);

                return $("<span>").append(btn);
            },
            CurrentRecordChanged: function (sender, e) {
                var $t;
                if (this._image != null) {
                    var value = ($t = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue($t, this.FieldDef) : null;
                    if (System.String.isNullOrEmpty(value)) {
                        this._image.css("visibility", "hidden");
                    } else {
                        this._image.attr("src", "data:image/png;base64," + (value || ""));
                        this._image.show();
                        this._image.css("visibility", "visible");
                    }
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetRequired: function (required) {
                if (required) {
                    this._required != null ? this._required.removeClass("wf-hidden") : null;
                } else {
                    this._required != null ? this._required.addClass("wf-hidden") : null;
                }

                return Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.SetRequired.call(this, required);
            },
            CreateImageFromFile: function (f) {
                var file = Bridge.cast(f, File);

                this.GetFileInBase64(file, Bridge.fn.bind(this, function (data) {
                    var commaIdx = System.String.indexOf(data, String.fromCharCode(44));
                    var imgType = data.substr(0, commaIdx);
                    var imgData = data.substr(((commaIdx + 1) | 0));
                    this.Value = imgData;

                    this._image.attr("src", "data:image/png;base64," + (imgData || ""));
                    this._image.show();
                    this._image.css("visibility", "visible");
                    this._image.removeClass("empty");
                }));
            },
            GetFileInBase64: function (file, okEvent, errEvent) {
                if (okEvent === void 0) { okEvent = null; }
                if (errEvent === void 0) { errEvent = null; }
                var reader = new FileReader();
                reader.onerror = function (evnt) {
                    !Bridge.staticEquals(errEvent, null) ? errEvent(reader, evnt) : null;
                };
                reader.onload = function () {
                    !Bridge.staticEquals(okEvent, null) ? okEvent(Bridge.toString(reader.result)) : null;
                };

                reader.readAsDataURL(file);
            },
            Focus: function () {
                this._topControl.find(".wf-dataImage-outer").click();

                return true;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.InlineFormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.FormControl],
        fields: {
            _gridData: null
        },
        props: {
            MainDSPFID: {
                get: function () {
                    return this._gridData.DSPFID;
                }
            },
            MasterID: {
                get: function () {
                    var $t, $t1, $t2;
                    var currRec = this.CurrencyManager.GetCurrentRecord(($t = this.CurrencyManager.MainDataset) != null ? $t.DSPFID : null);
                    return ($t1 = (currRec != null ? currRec.MasterIDParent : null), $t1 != null ? $t1 : (($t2 = this.CurrencyManager.MainDataset) != null ? $t2.MasterIDParent : null));
                }
            }
        },
        ctors: {
            ctor: function (gridData, formData, parentForm) {
                if (parentForm === void 0) { parentForm = null; }

                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.FormControl.ctor.call(this, formData, parentForm);
                this._gridData = gridData;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.LabelControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _timer: null,
            _interval: 0
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    var result = false;

                    var fd = this.FieldDef;
                    if ((fd != null) && (fd.Type >= 4) && (fd.Type <= 7)) {
                        result = true;
                    }

                    return result;
                }
            },
            DisplayValue: {
                get: function () {
                    var $t;
                    return ($t = this.MainControl) != null ? $t.html() : null;
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "RaiseDataChanged", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$RaiseDataChanged",
            "Focus", "Adaptica$WebForms$WebApp$Controls$IControl$Focus",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._timer = System.DateTime.getDefaultValue();
                this._timer = System.DateTime.getMinValue();
            },
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    value, 
                    displayValue, 
                    ctrl, 
                    result, 
                    labelElem, 
                    inputGroup, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        value = this.Value;
                                        displayValue = this.Text;

                                        ctrl = $("<div>").addClass("wf-label").html(displayValue);

                                        result = ctrl;
                                        if (!this.CreateControlOnly) {
                                            labelElem = $(document.createElement("label"));

                                            inputGroup = $("<div>").addClass("input-group").append(ctrl);

                                            result = $(document.createElement("div")).addClass("form-group col-auto wf-control wf-label").append(labelElem).append(inputGroup);
                                        }

                                        this.MainControl = ctrl;

                                        this.SetFontProperties(ctrl, value);

                                        if (System.String.isNullOrEmpty(displayValue)) {
                                            this.MainControl.css("visibility", "hidden");
                                        }

                                        this.SetInterval();

                                        $task1 = this.SetControlProperties();
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetInterval: function () {
                var v = this.Value;

                if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QITimer)) {
                    this.ClearInterval();

                    if (!System.String.isNullOrEmpty(v)) {
                        if (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) {
                            this._timer = System.DateTime.parseExact(v, "yyyy-MM-dd HH:mm:ss.fff", null);
                        } else if (this.FieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                            this._timer = System.DateTime.parseExact(v, "HH:mm:ss.fff", null);
                        }

                        this.Refresh();

                        this._interval = window.setInterval(Bridge.fn.cacheBind(this, this.Refresh), 1000);
                    } else {
                        this.MainControl.html(System.TimeSpan.zero.toString("hh\\:mm\\:ss"));
                    }
                }
            },
            ClearInterval: function () {
                if (this._interval !== 0) {
                    window.clearInterval(this._interval);
                    this._interval = 0;
                }
            },
            Refresh: function () {
                var $t;
                var s = (System.DateTime.subdd(System.DateTime.getNow(), this._timer));
                var v = (s.getTotalDays() > 1) ? s.toString("d\\.hh\\:mm\\:ss") : s.toString("HH\\:mm\\:ss");
                ($t = this.MainControl) != null ? $t.html(v) : null;
            },
            RaiseDataChanged: function () {
                this.CurrentRecordChangedInternal(null, null);
                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            CurrentRecordChanged: function (sender, e) {
                var $t, $t1;
                this.CurrentRecord = this.FormControl.CurrencyManager.GetCurrentRecordOrFirst(this.DataItem.DSPFID);
                var value = ($t = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue($t, this.FieldDef) : null;
                var displayValue = ($t1 = this.CurrentRecord) != null ? Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue($t1, this.FieldDef) : null;

                if (System.String.isNullOrEmpty(displayValue)) {
                    this.ClearInterval();

                    this.MainControl.css("visibility", "hidden");

                    return System.Threading.Tasks.Task.fromResult(null, System.Object);
                }

                var color = this.GetTextColor(value);
                if (!System.String.isNullOrEmpty(color)) {
                    this.MainControl.css("color", color);
                }

                if (Bridge.referenceEquals(this.DataItem.Action, "QIMobile.Timer")) {
                    this.SetInterval();
                } else {
                    this.MainControl.html(displayValue);
                }

                this.MainControl.css("visibility", "visible");

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            Focus: function () {
                return false;
            },
            Dispose: function () {
                this.ClearInterval();

                Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.Dispose.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.MemoControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.ControlBase],
        fields: {
            _control: null,
            _required: null,
            _infoIcon: null,
            _linkRegex: null,
            QrCode: null,
            CreateCopyIcon: false
        },
        props: {
            IsFullRowControl: {
                get: function () {
                    return true;
                }
            }
        },
        alias: [
            "IsFullRowControl", "Adaptica$WebForms$WebApp$Controls$IControl$IsFullRowControl",
            "RenderControl", "Adaptica$WebForms$WebApp$Controls$IControl$RenderControl",
            "BeginEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$BeginEdit",
            "EndEdit", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$EndEdit"
        ],
        ctors: {
            init: function () {
                this.CreateCopyIcon = false;
            },
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.ControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            RenderControl: function () {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $task2, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    isQrCode, 
                    isHtml, 
                    $class, 
                    id, 
                    label, 
                    $t, 
                    $t1, 
                    inputGroup, 
                    $t2, 
                    node, 
                    jq, 
                    textArea, 
                    $t3, 
                    inputElem, 
                    copyIcon, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,7,8], $step);
                                switch ($step) {
                                    case 0: {
                                        isQrCode = Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileQRCodeImage);
                                        isHtml = Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileHTMLText);

                                        $class = (isQrCode) ? "wf-qrCode" : "wf-memo";

                                        id = this.GetId();
                                        label = ($t = this.FieldDef) != null ? $t.Label : null;

                                        this._control = $(document.createElement("div")).addClass("form-group mb-auto wf-w-100-minus-scroll wf-control").addClass($class);

                                        if (!isHtml) {
                                            $(($t1 = document.createElement("label"), $t1.htmlFor = id, $t1.innerHTML = label, $t1)).appendTo(this._control);

                                            if (!System.String.isNullOrEmpty(($t1 = this.FieldDef) != null ? $t1.Description : null)) {
                                                this._infoIcon = $("<span>").addClass("wf-tooltip-icon fas fa-info-circle").attr("title", System.String.replaceAll(this.FieldDef.Description, "\n", "<br>")).attr("data-toggle", "tooltip").attr("data-boundary", "window").appendTo(this._control);

                                                this._infoIcon.tooltip({ trigger: "hover", placement: "auto", html: true, title: System.String.replaceAll(this.FieldDef.Description, "\n", "<br>") });
                                            }

                                            this._required = $("<span>").addClass("wf-required").html("*").appendTo(this._control);

                                            if (!this.IsRequired) {
                                                this._required.addClass("wf-hidden");
                                            }
                                        }

                                        inputGroup = $("<div>").addClass("input-group").appendTo(this._control);

                                        if (isQrCode) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 2;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        this.MainControl = $("<img>").attr("id", id).attr("src", this.GetQrCodeUrl()).addClass("form-control").addClass($class).appendTo(inputGroup);
                                        $step = 7;
                                        continue;
                                    }
                                    case 2: {
                                        if (isHtml) {
                                            $step = 3;
                                            continue;
                                        } else  {
                                            $step = 5;
                                            continue;
                                        }
                                    }
                                    case 3: {
                                        this.CreateControlOnly = true;

                                        this.MainControl = $("<div>").addClass("wf-html").appendTo(inputGroup);

                                        $task1 = this.GetHtml();
                                        $step = 4;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 4: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        $t2 = Bridge.getEnumerator(($taskResult1).body.childNodes, "getEnumerator");
                                        try {
                                            while ($t2.moveNext()) {
                                                node = $t2.Current;
                                                jq = $(node);
                                                this.MainControl.first().append(jq);
                                            }
                                        } finally {
                                            if (Bridge.is($t2, System.IDisposable)) {
                                                $t2.System$IDisposable$Dispose();
                                            }
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 5: {
                                        textArea = ($t3 = document.createElement("textarea"), $t3.id = id, $t3.className = "form-control " + ($class || ""), $t3.value = this.Value, $t3.required = this.IsRequired, $t3.disabled = this.IsReadOnly || !this.IsEnabled, $t3);

                                        inputElem = $(textArea).appendTo(inputGroup);

                                        inputElem.change(Bridge.fn.bind(this, function () {
                                            this.Value = inputElem.val();
                                        }));

                                        if (this.CreateCopyIcon) {
                                            copyIcon = $("<span>").appendTo(inputGroup);

                                            $("<i>").addClass("far fa-copy wf-memo-copy-icon").appendTo(copyIcon);

                                            copyIcon.on("click", function () {
                                                var isDisabled = textArea.disabled;
                                                textArea.disabled = false;
                                                textArea.select();
                                                textArea.setSelectionRange(0, 99999);
                                                document.execCommand("copy");
                                                textArea.setSelectionRange(0, 0);
                                                textArea.disabled = isDisabled;
                                            });
                                        }

                                        this.MainControl = inputElem;
                                        $step = 6;
                                        continue;
                                    }

                                    case 7: {
                                        $task2 = this.SetControlProperties();
                                        $step = 8;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $task2.getAwaitedResult();
                                        $tcs.setResult(this._control);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            GetQrCodeUrl: function () {
                return System.String.format("{0}GetQrCode?wfsid={1}&qrText={2}", Adaptica.WebForms.WebApp.Config.DataUrl, encodeURIComponent(Adaptica.WebForms.WebApp.WebFormsApp.SSID), encodeURIComponent(this.Value));
            },
            GetHtml: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    result, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        result = null;

                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.GetDataAsync$2("GetDataByToken", { Token: this.Value, IsHtml: true }, "GET", Bridge.fn.bind(this, function (dataDTO) {
                                            var $step = 0,
                                                $task1, 
                                                $taskResult1, 
                                                $jumpFromFinally, 
                                                $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                $returnValue, 
                                                $async_e, 
                                                $asyncBody = Bridge.fn.bind(this, function () {
                                                    try {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1,2,3], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    $task1 = Adaptica.WebForms.WebApp.WebFormsApp.CheckException(dataDTO);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $taskResult1 = $task1.getAwaitedResult();
                                                                    if ($taskResult1) {
                                                                        $step = 2;
                                                                        continue;
                                                                    } 
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 2: {
                                                                    result = this.ProcessHtml(dataDTO.Data);
                                                                    $step = 3;
                                                                    continue;
                                                                }
                                                                case 3: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                                default: {
                                                                    $tcs.setResult(null);
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    } catch($async_e1) {
                                                        $async_e = System.Exception.create($async_e1);
                                                        $tcs.setException($async_e);
                                                    }
                                                }, arguments);

                                            $asyncBody();
                                            return $tcs.task;
                                        }));
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(result);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            ProcessHtml: function (html) {
                var $t;
                var appUrl = "https://qi.adaptica.cz/dev-mobile-web";

                var parser = new DOMParser();
                var doc = parser.parseFromString(html, "text/html");
                $t = Bridge.getEnumerator(doc.querySelectorAll("a"), "getEnumerator");
                try {
                    while ($t.moveNext()) {
                        var link = Bridge.cast($t.Current, HTMLAnchorElement);
                        var href = link.href;
                        if (System.String.startsWith(href, appUrl, 3)) {
                            if (this._linkRegex == null) {
                                this._linkRegex = new System.Text.RegularExpressions.Regex.ctor("formId=([^&]+).*?masterId=([^&]+)");
                            }

                            var match = this._linkRegex.match(href);
                            if (match.getSuccess()) {
                                var formId = match.getGroups().get(1).getValue();
                                var masterId = match.getGroups().get(2).getValue();
                                if (System.String.isNullOrEmpty(masterId)) {
                                    masterId = "null";
                                } else {
                                    masterId = System.String.format("'{0}'", [masterId]);
                                }

                                link.href = System.String.format("javascript:Adaptica.WebForms.WebApp.WebFormsApp.GetForm('{0}', {1}, Adaptica.WebForms.WebApp.WebFormsApp.CurrentForm)", formId, masterId);
                            }
                        } else {
                            link.target = "_blank";
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return doc;
            },
            CurrentRecordChanged: function (sender, e) {
                var $step = 0,
                    $task1, 
                    $taskResult1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    jq, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4], $step);
                                switch ($step) {
                                    case 0: {
                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileQRCodeImage)) {
                                            $(System.String.format("#{0}", [this.GetId()])).attr("src", this.GetQrCodeUrl());
                                        }

                                        if (Bridge.referenceEquals(this.DataItem.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIMobileHTMLText)) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 3;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        $task1 = this.GetHtml();
                                        $step = 2;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 2: {
                                        $taskResult1 = $task1.getAwaitedResult();
                                        jq = $(($taskResult1).body.childNodes);
                                        this.MainControl.add(jq);
                                        $step = 4;
                                        continue;
                                    }
                                    case 3: {
                                        this.MainControl.val(this.Text);
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            BeginEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    id, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        id = this.GetId();
                                        $(System.String.format("#{0}", [id])).addClass("editing");

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.BeginEdit.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            EndEdit: function () {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    id, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        id = this.GetId();
                                        $(System.String.format("#{0}", [id])).removeClass("editing");

                                        $task1 = Adaptica.WebForms.WebApp.Controls.ControlBase.prototype.EndEdit.call(this);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetVisible: function (visible) {
                if (visible) {
                    this._control.removeClass("wf-hidden");
                } else {
                    this._control.addClass("wf-hidden");
                }

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            SetRequired: function (required) {
                if (this._required != null) {
                    Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("SetRequired({0}), Field: {1}", Bridge.box(required, System.Boolean, System.Boolean.toString), this.DataItem.FieldName));

                    if (required) {
                        this._required.removeClass("wf-hidden");
                    } else {
                        this._required.addClass("wf-hidden");
                    }
                }

                return System.Threading.Tasks.Task.fromResult(true, System.Boolean);
            },
            GetId: function () {
                return "ctrl_" + (Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this.FieldDef.Name) || "");
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.SelectionFormControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.FormControl],
        fields: {
            SourceForm: null,
            DSPFID: null,
            FieldName: null,
            OriginalRecord: null
        },
        ctors: {
            ctor: function (formData, sourceForm, dspfid, fieldName, originalRecord) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.FormControl.ctor.call(this, formData, sourceForm);
                this.SourceForm = sourceForm;
                this.DSPFID = dspfid;
                this.FieldName = fieldName;
                this.OriginalRecord = originalRecord;
            }
        },
        methods: {
            ExecuteGridDefaultAction: function (dspfid, record) {
                var $step = 0,
                    $task1, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1], $step);
                                switch ($step) {
                                    case 0: {
                                        $task1 = Adaptica.WebForms.WebApp.WebFormsApp.ExecuteSelectFunctionAsync(this, dspfid, record);
                                        $step = 1;
                                        if ($task1.isCompleted()) {
                                            continue;
                                        }
                                        $task1.continue($asyncBody);
                                        return;
                                    }
                                    case 1: {
                                        $task1.getAwaitedResult();
                                        $tcs.setResult(true);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.DataTablesGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        fields: {
            _table: null,
            _notFound: null,
            _notFoundMsg: null,
            _dataTable: null,
            _isCreating: false,
            _isRecalculating: false,
            _cols: null,
            _eventsAttached: false
        },
        props: {
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            IsVisible: {
                get: function () {
                    return true;
                }
            },
            IsResponsive: {
                get: function () {
                    return false;
                }
            },
            FloatThead: {
                get: function () {
                    return true;
                }
            },
            Scroller: {
                get: function () {
                    return false;
                }
            },
            ColReorder: {
                get: function () {
                    return false;
                }
            },
            ControlId: {
                get: function () {
                    return System.String.format("ctrl_{0}", [this.FormControl.CreateUniqueControlId()]);
                }
            }
        },
        alias: [
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._eventsAttached = false;
            },
            ctor: function (form, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, form, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                if ((Bridge.referenceEquals(this.DataItem.DSPFID, (e != null ? e.DSPFID : null))) && (this._control != null)) {
                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.DataItem.DSPFID);
                    this.SetRecordSelectedClass(rec, true);

                    this._currentRecord = rec;
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetRecordSelectedClass: function (rec, readScrollTop) {
                var $t, $t1;
                if (readScrollTop === void 0) { readScrollTop = false; }
                var id;

                if ((this._currentRecord != null) && (!Bridge.referenceEquals(this._currentRecord, rec))) {
                    id = ($t = this._currentRecord.RecID, $t != null ? $t : Bridge.toString(this._currentRecord.RecNo));
                    $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(id)])).removeClass("wf-grid-row-selected");
                }

                if (rec == null) {
                    return;
                }

                id = ($t1 = rec.RecID, $t1 != null ? $t1 : Bridge.toString(rec.RecNo));

                var row = $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(id)]));
                row.addClass("wf-grid-row-selected");

                if (readScrollTop) {
                    this._tableScrollTop = row.closest(".dataTables_scrollBody").scrollTop();
                }
            },
            GetGridColumns: function () {
                if (this._cols == null) {
                    var grid = this.DataItem;
                    this.CreateColumns(grid, this.Dataset.Header.FieldDefs);
                }

                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $taskResult9, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tbody, 
                    rows, 
                    selRecord, 
                    selRow, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    id, 
                    $t, 
                    row, 
                    i, 
                    col, 
                    color, 
                    fieldDef, 
                    fieldValue, 
                    $t1, 
                    cell, 
                    text, 
                    value, 
                    $taskResult2, 
                    valueElem, 
                    imgElem, 
                    $t2, 
                    img, 
                    rowValueCol, 
                    edt, 
                    edit, 
                    txt, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17,18,19,20,22,23,24,25,26,27,29,30,32,33,34,35,36,37,38,39,40], $step);
                                switch ($step) {
                                    case 0: {
                                        Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("Creating grid content, dateset dsid: {0}, dataset dspfid: {1}, recs count: {2}", dset.DSID, dset.DSPFID, Bridge.box(recs.length, System.Int32)));

                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 34;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (this._notFound != null) {
                                            this._notFound.remove();
                                            this._notFound = null;

                                            this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._control.find(".wf-grid-datatables")) : null;
                                        }

                                        if (this._table == null) {
                                            this.CreateGridHeader(containerItem, fieldDefs);
                                        }

                                        tbody = $("<tbody>").appendTo(this._table);

                                        this._table != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._table) : null;

                                        rows = null;
                                        if (this._dataTable != null) {
                                            rows = System.Array.init(recs.length, null, System.Object);
                                        }

                                        selRecord = null;
                                        selRow = null;

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 33;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(localRecNo.v, recs)];

                                        id = ($t = rec.RecID, $t != null ? $t : Bridge.toString(rec.RecNo));

                                        row = $("<tr>").addClass(System.String.format("wf-grid-row id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(id)]));

                                        if (this._currentRecord != null && (((this._currentRecord.RecID == null) && (this._currentRecord.RecNo === rec.RecNo)) || (Bridge.referenceEquals((this._currentRecord != null ? this._currentRecord.RecID : null), rec.RecID)))) {
                                            selRecord = rec;
                                            selRow = row;
                                        }

                                        if (this._dataTable != null) {
                                            rows[System.Array.index(recNo, rows)] = row.get(0);
                                        } else {
                                            row.appendTo(tbody);
                                        }

                                        row.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if (!System.String.isNullOrEmpty(Bridge.toString(window.getSelection()))) {
                                                                            $tcs.setResult(null);
                                                                            return;
                                                                        }

                                                                        Adaptica.WebForms.WebApp.WebFormsApp.Log("row click");

                                                                        if (!this.IsEditing) {
                                                                            e.stopImmediatePropagation();
                                                                            e.preventDefault();
                                                                        }

                                                                        $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                        })(this, localRecNo));

                                        i = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 31;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i, this._cols)] };
                                        color = col.v.FontColor;
                                        fieldDef = { v : System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null) };

                                        fieldValue = rec != null && ($t1 = rec.FieldValues) != null ? System.Linq.Enumerable.from($t1, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault((function ($me, fieldDef) {
                                            return function (fd) {
                                                return System.String.equals(fd.Name, fieldDef.v != null ? fieldDef.v.Name : null);
                                            };
                                        })(this, fieldDef), null) : null;
                                        if (fieldValue != null && System.Nullable.hasValue(fieldValue.ViewType)) {
                                            fieldDef.v.Type = System.Nullable.getValue(fieldValue.ViewType);
                                            fieldDef.v.Values = fieldValue.ViewValues;
                                            fieldDef.v.DisplayValues = fieldValue.ViewDisplayValues;
                                            fieldDef.v.Mask = fieldValue.ViewMask;
                                        }

                                        cell = $("<td>").appendTo(row);

                                        cell.addClass("fld-" + (System.String.replaceAll(col.v.FieldName, String.fromCharCode(44), String.fromCharCode(95)) || ""));

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef.v);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef.v);

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        color = "#7b7b7b";
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 22;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 15: {
                                        if (System.String.equals(text, "1")) {
                                            $step = 16;
                                            continue;
                                        }  else {
                                            $step = 18;
                                            continue;
                                        }
                                    }
                                    case 16: {
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 17;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        $taskResult2 = $taskResult5;
                                        $step = 20;
                                        continue;
                                    }
                                    case 18: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 19;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 19: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult2 = $taskResult6;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        text = $taskResult2;
                                        $step = 21;
                                        continue;
                                    }

                                    case 22: {
                                        valueElem = null;

                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            $step = 23;
                                            continue;
                                        } else  {
                                            $step = 24;
                                            continue;
                                        }
                                    }
                                    case 23: {
                                        valueElem = $("<div>").addClass("wf-grid-value wf-grid-image").appendTo(cell);

                                        imgElem = ($t2 = new Image(), $t2.className = "wf-dataImage", $t2);

                                        img = $(imgElem).appendTo(valueElem);

                                        if (!System.String.isNullOrEmpty(text)) {
                                            this.HandleImageOnLoad(img);

                                            img.attr("src", "data:image/png;base64," + (text || ""));
                                        } else {
                                            img.css("visibility", "hidden");
                                        }
                                        $step = 29;
                                        continue;
                                    }
                                    case 24: {
                                        rowValueCol = $("<div>").appendTo(cell);

                                        valueElem = $("<div>").addClass("wf-grid-value").appendTo(rowValueCol);

                                        if ((this.AllowEdit(dset.DSPFID)) && (!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef.v))) {
                                            $step = 25;
                                            continue;
                                        } else  {
                                            $step = 27;
                                            continue;
                                        }
                                    }
                                    case 25: {
                                        edt = ($t2 = new Adaptica.WebForms.Common.DataModel.Edit(), $t2.DSPFID = dset.DSPFID, $t2.Caption = fieldDef.v.Label, $t2.FieldName = fieldDef.v.Name, $t2.FontColor = col.v.FontColor, $t2.FontStyle = col.v.FontStyle, $t2.Type = col.v.Type, $t2.Action = col.v.Action, $t2);

                                        edit = ($t2 = new Adaptica.WebForms.WebApp.Controls.EditControl(this.FormControl, edt, rec), $t2.CreateControlOnly = true, $t2.IsGridEdit = true, $t2);
                                        this.SubControls.add(edit);

                                        $task7 = edit.RenderControl();
                                        $step = 26;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        ($taskResult7).appendTo(valueElem);
                                        $step = 28;
                                        continue;
                                    }
                                    case 27: {
                                        if ((Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile))) {
                                            cell.addClass("wf-grid-cell-download");
                                        }

                                        this.SetColumnValue(col.v, valueElem, fieldDef.v, value, text, color);
                                        $step = 28;
                                        continue;
                                    }

                                    case 29: {
                                        if (i === 0) {
                                            valueElem != null ? valueElem.addClass("wf-grid-first") : null;
                                        }
                                        $step = 30;
                                        continue;
                                    }
                                    case 30: {
                                        i = (i + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 32: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 33: {
                                        if (this._dataTable == null) {
                                            this.CreateDataTable();
                                        } else {
                                            this._dataTable.rows.add(Bridge.unbox(rows)).draw();
                                            if (this.FloatThead) {
                                                this._table.floatThead("reflow");
                                            }
                                        }

                                        if (selRecord != null) {
                                            this.SetRecordSelectedClass(selRecord);
                                            window.setTimeout(Bridge.fn.bind(this, function () {
                                                if (!this.IsElementInViewport(Bridge.as(selRow.get(0), HTMLElement))) {
                                                    selRow.closest(".dataTables_scrollBody").scrollTop(this._tableScrollTop);
                                                }
                                            }), 50);
                                        }
                                        $step = 40;
                                        continue;
                                    }
                                    case 34: {
                                        if (((this._filterOnServer) && (System.String.isNullOrEmpty(this._searchText)))) {
                                            $step = 35;
                                            continue;
                                        }  else {
                                            $step = 37;
                                            continue;
                                        }
                                    }
                                    case 35: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 36;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 36: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult1 = ($taskResult8 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 39;
                                        continue;
                                    }
                                    case 37: {
                                        $task9 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 38;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 38: {
                                        $taskResult9 = $task9.getAwaitedResult();
                                        $taskResult1 = $taskResult9;
                                        $step = 39;
                                        continue;
                                    }
                                    case 39: {
                                        txt = $taskResult1;

                                        if (this._notFound == null) {
                                            this._notFound = $("<div>").addClass("form-row wf-msg").appendTo(this._gridContentElem);

                                            this._notFoundMsg = $("<div>").addClass("col-auto").html(txt).appendTo(this._notFound);
                                        } else {
                                            this._notFoundMsg.html(txt);
                                        }

                                        this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._control.find(".wf-grid-datatables")) : null;
                                        $step = 40;
                                        continue;
                                    }
                                    case 40: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsElementInViewport: function (e) {
                var el = null;

                if (Bridge.is(e, $)) {
                    el = Bridge.as((Bridge.as(e, $)).get(0), HTMLElement);
                } else if (Bridge.is(e, HTMLElement)) {
                    el = Bridge.as(e, HTMLElement);
                }

                if (el == null) {
                    throw new System.Exception("Invalid type");
                }

                var rect = el.getBoundingClientRect();

                var h = window.innerHeight;
                if (h === 0) {
                    h = window.document.documentElement.clientHeight;
                }
                var w = window.innerHeight;
                if (w === 0) {
                    w = window.document.documentElement.clientWidth;
                }

                return (rect.top >= 0 && rect.left >= 0 && rect.bottom <= h && rect.right <= w);
            },
            CreateColumns: function (grid, fieldDefs) {
                var tmpCols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                        return col.Order;
                    }).toList(Adaptica.WebForms.Common.DataModel.GridColumn);

                var colIdx = 0;
                var i = (tmpCols.Count - 1) | 0;
                while (i > colIdx) {
                    var col = { v : tmpCols.getItem(i) };
                    var fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                            return function (fld) {
                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                            };
                        })(this, col), null);
                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                        tmpCols.removeAt(i);
                        tmpCols.insert(colIdx, col.v);
                        colIdx = (colIdx + 1) | 0;
                    } else {
                        i = (i - 1) | 0;
                    }
                }

                this._cols = tmpCols.ToArray();
            },
            CreateGridHeader: function (containerItem, fieldDefs) {
                var $t;
                var grid = containerItem;

                this.CreateColumns(grid, fieldDefs);

                this._table = $("<table>").attr("id", this.ControlId).addClass("wf-grid-datatables table table-striped table-bordered nowrap");

                if (this.IsResponsive) {
                    this._table.addClass("dt-responsive");
                }

                var tHead = $("<thead>").appendTo(this._table);

                if (Bridge.equals(("no"), window.self.gridHeader)) {
                    tHead.addClass("wf-hidden");
                }

                var tHeadRow = $("<tr>").appendTo(tHead);

                $t = Bridge.getEnumerator(this._cols);
                try {
                    while ($t.moveNext()) {
                        var col = { v : $t.Current };
                        var fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                return function (fld) {
                                    return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                };
                            })(this, col), null);
                        var isDownload = (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile));
                        var lbl = fieldDef.Label;

                        var cell = $("<th>").addClass("wf-grid-header").html(lbl).appendTo(tHeadRow);

                        cell.addClass("fld-" + (System.String.replaceAll(col.v.FieldName, String.fromCharCode(44), String.fromCharCode(95)) || ""));

                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                            cell.addClass("wf-grid-cell-img");
                        }

                        if (isDownload) {
                            cell.addClass("wf-grid-cell-download");
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                this._gridContentElem.append(this._table);
            },
            ClearTable: function () {
                if (this._table == null) {
                    return;
                }

                this._dataTable.rows().remove().draw();
            },
            OnFormActivated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormActivated.call(this);
                if (this.IsResponsive) {
                    this._dataTable != null ? this._dataTable.responsive.recalc() : null;
                }

                this.OnShownOrActivated();
            },
            OnFormDeactivated: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormDeactivated.call(this);
            },
            OnShow: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnShow.call(this);

                this.OnShownOrActivated();
            },
            OnHide: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnHide.call(this);

                this.OnHiddenOrDeactivated();
            },
            OnShownOrActivated: function () {
                if ((this.IsShown) && (!this._eventsAttached)) {
                    this._eventsAttached = true;

                    window.addEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));

                    if (this._searchBar != null) {
                        window.setTimeout(Bridge.fn.bind(this, function () {
                            this._searchInput.focus();
                        }), 10);
                    }
                }

                this.RecalculateSize();
            },
            OnHiddenOrDeactivated: function () {
                window.removeEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));
                this._eventsAttached = false;
            },
            RecalculateSize: function () {
                if ((this._notFound != null) || (this._isRecalculating)) {
                    return;
                }

                window.setTimeout(Bridge.fn.bind(this, function () {
                    var $t;
                    if (this._isRecalculating) {
                        return;
                    }

                    this._isRecalculating = true;

                    var sTopElem = this.FormControl.Content.find(".sticky-top");
                    var prnt = this._gridContentElem.parent();

                    var h = this._gridContentElem.height();
                    var sTop = sTopElem.height();
                    var sTopOffsetTop = sTopElem.offset().top;
                    var scrollH = (prnt.prop("offsetHeight") - this._gridContentElem.prop("offsetHeight")) | 0;

                    var calc = (((((window.innerHeight - sTop) | 0) - sTopOffsetTop) | 0) - (((scrollH + 10) | 0))) | 0;
                    this._gridContentElem.css("height", calc);

                    var sh = prnt.prop("scrollHeight");
                    var oh = prnt.prop("offsetHeight");
                    var ch = prnt.prop("clientHeight");

                    Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("resize - controlId: {0}, grid height: {1}, sticky top height: {2}, new calculated height: {3}, parent scroll height: {4}, parent offset height: {5}, parent client height: {6}, scrollbar height: {7}.", this.ControlId, Bridge.box(h, System.Int32), Bridge.box(sTop, System.Int32), Bridge.box(calc, System.Int32), Bridge.box(sh, System.Int32), Bridge.box(oh, System.Int32), Bridge.box(ch, System.Int32), Bridge.box(scrollH, System.Int32)));

                    if (this.Scroller) {
                        if (this._dataTable != null) {
                            window.setTimeout(Bridge.fn.bind(this, function () {
                                this._dataTable.scroller.measure(true);
                            }), 10);
                        }
                    }

                    if (this.FloatThead) {
                        ($t = this._table) != null ? $t.floatThead("reflow") : null;
                    }

                    this._isRecalculating = false;
                }), 10);
            },
            OnScroll: function () {
                if (this.FloatThead) {
                    this._table.floatThead("reflow");
                }
                Adaptica.WebForms.WebApp.WebFormsApp.Log("Reflow.");
            },
            OnFormCreated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormCreated.call(this);

                if (this._notFound == null) {
                    this.CreateDataTable();
                }
            },
            CreateDataTable: function () {
                if ((this._dataTable == null) && (!this._isCreating)) {
                    this._isCreating = true;
                    window.setTimeout(Bridge.fn.bind(this, function () {
                        var s = { pageLength: -1, info: false, paging: false, ordering: false, searching: false, stateSave: true, stateDuration: -1, autoWidth: false, dom: "Rt" };


                        if (this.ColReorder) {
                            var opts = { };
                            opts.allowReorder = true;
                            opts.allowResize = false;
                            opts.floatThead = true;
                            s.colReorder = opts;
                        }

                        s.colResize = { isEnabled: true, hasBoundCheck: false };

                        if (this.Scroller) {
                            s.scroller = true;
                            s.scrollY = "200px";
                            s.scrollCollapse = true;
                            s.scrollResize = true;
                            s.deferRender = true;
                        }

                        if (this.IsResponsive) {
                            var resp = { };
                            resp.details = false;
                            s.responsive = resp;
                        }

                        /* 
                                           FixedHeaderOpts fh = (FixedHeaderOpts)new object();
                                           fh.header = true;
                                           fh.headerOffset = FormControl.Content.Find(".sticky-top").Height() - 7;

                                           s.fixedHeader = fh;
                        */
                        var tbl = jQuery(this._table);
                        tbl.dataTable.defaults.pageLength = -1;
                        this._dataTable = tbl.DataTable(s);

                        this._dataTable.on("column-reorder.dt", Bridge.fn.bind(this, function (event, settings) {
                            var reorderArgs = arguments[2];
                            if (this.Scroller) {
                                this._dataTable.scroller.measure(true);
                            }
                        }));

                        /* 
                                           if (ColReorder)
                                           {
                                               _dataTable.colReorder().ColReorder();
                                           }
                        */

                        if (this.FloatThead) {
                            var opts1 = { };
                            opts1.top = (this.FormControl.Content.find(".sticky-top").height() - 7) | 0;
                            opts1.position = "absolute";
                            opts1.scrollContainer = true;
                            opts1.autoReflow = true;

                            var support = { };
                            support.bootstrap = true;
                            support.datatables = true;

                            opts1.support = support;

                            tbl.floatThead(opts1);
                        }

                        this.RecalculateSize();

                        this._isCreating = false;
                    }), 100);

                }
            },
            Dispose: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.Dispose.call(this);
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.KanbanGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        statics: {
            fields: {
                undefinedColor: null
            },
            ctors: {
                init: function () {
                    this.undefinedColor = "#7b7b7b";
                }
            }
        },
        fields: {
            _cols: null,
            _notFound: null,
            _notFoundMsg: null
        },
        ctors: {
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            GetGridColumns: function () {
                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    grid, 
                    kanbanControl, 
                    kanbanCol, 
                    colorCodes, 
                    $t, 
                    kanbanField, 
                    kanbanValues, 
                    kanbanDispValues, 
                    kanbanPanels, 
                    kv, 
                    panel, 
                    color, 
                    heading, 
                    nextColor, 
                    setColor, 
                    prevColor, 
                    maxH, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    kValue, 
                    panel1, 
                    bgColor, 
                    item, 
                    i1, 
                    col, 
                    color1, 
                    fieldDef, 
                    text, 
                    value, 
                    $taskResult2, 
                    valueElem, 
                    img, 
                    $t1, 
                    h, 
                    txt, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17,18,19,20,22,23,25,26,27,28,29,30,31,32,33], $step);
                                switch ($step) {
                                    case 0: {
                                        grid = containerItem;
                                        this._cols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                                            return col.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.GridColumn);

                                        kanbanControl = $("<div>").addClass("wf-kanban").appendTo(this._gridContentElem);

                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 27;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (this._notFound != null) {
                                            this._notFound.remove();
                                            this._notFound = null;

                                            this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._control.find(".wf-kanban")) : null;
                                        }

                                        kanbanCol = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).first(function (col) {
                                            return Bridge.referenceEquals(col.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIKanban);
                                        });
                                        colorCodes = ($t = kanbanCol.FontColor) != null ? System.String.split($t, [44].map(function (i) {{ return String.fromCharCode(i); }})) : null;

                                        kanbanField = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault(function (fld) {
                                            return Bridge.referenceEquals(fld.Name, kanbanCol.FieldName);
                                        }, null);
                                        kanbanValues = Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumValues(kanbanField);
                                        kanbanDispValues = Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumDisplayValues(kanbanField);

                                        kanbanPanels = new (System.Collections.Generic.Dictionary$2(System.Int32,$)).ctor();
                                        for (var i = 0; i < kanbanValues.length; i = (i + 1) | 0) {
                                            kv = kanbanValues[System.Array.index(i, kanbanValues)];
                                            panel = $("<div>").addClass("wf-kanban-panel").appendTo(kanbanControl);

                                            kanbanPanels.add(kv, panel);

                                            color = colorCodes != null ? colorCodes[System.Array.index(i, colorCodes)] : null;
                                            if (System.String.isNullOrEmpty(color)) {
                                                color = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                            }

                                            heading = $("<div>").addClass("wf-kanban-heading").attr("style", System.String.format("background-color: {0};", [color])).text(kanbanDispValues[System.Array.index(i, kanbanDispValues)]).appendTo(panel);

                                            if (i < ((kanbanValues.length - 1) | 0)) {
                                                nextColor = colorCodes != null ? colorCodes[System.Array.index(((i + 1) | 0), colorCodes)] : null;
                                                if (System.String.isNullOrEmpty(nextColor)) {
                                                    nextColor = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                                }

                                                $("<div>").addClass("triangle").attr("style", System.String.format("border-top-color: {0};border-bottom-color: {1};", nextColor, nextColor)).appendTo(kanbanControl);
                                            }

                                            setColor = true;
                                            if (i === 0) {
                                                panel.addClass("wf-kanban-panel-first");
                                                setColor = false;
                                            } else if (i === ((kanbanValues.length - 1) | 0)) {
                                                panel.addClass("wf-kanban-panel-last");
                                            }

                                            if (setColor) {
                                                prevColor = colorCodes != null ? colorCodes[System.Array.index(((i - 1) | 0), colorCodes)] : null;
                                                if (System.String.isNullOrEmpty(prevColor)) {
                                                    prevColor = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                                }
                                                panel.attr("style", System.String.format("--wf-color: {0};", [prevColor]));
                                            }
                                        }

                                        maxH = 0;
                                        this._cols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                                            return col.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.GridColumn);

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 26;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(recNo, recs)];

                                        kValue = System.Int32.parse(Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(rec, kanbanCol.FieldName));
                                        panel1 = kanbanPanels.getItem(kValue);

                                        bgColor = colorCodes != null ? colorCodes[System.Array.index(Adaptica.WebForms.WebApp.Extensions.IndexOf(System.Int32, kanbanValues, kValue), colorCodes)] : null;
                                        if (System.String.isNullOrEmpty(bgColor)) {
                                            bgColor = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                        }

                                        item = $("<div>").addClass("wf-kanban-item").attr("style", System.String.format("background-color: {0}10;", [bgColor])).appendTo(panel1);

                                        item.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    e.preventDefault();

                                                                    $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });
                                        })(this, localRecNo));

                                        i1 = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i1 < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 24;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i1, this._cols)] };
                                        if ((Bridge.referenceEquals(col.v.FieldName, kanbanCol.FieldName)) || (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile)) || (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile))) {
                                            $step = 23;
                                            continue;
                                        }

                                        color1 = col.v.FontColor;
                                        fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null);

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef);
                                        if (System.String.isNullOrEmpty(text)) {
                                            text = "&nbsp;";
                                        }

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        color1 = Adaptica.WebForms.WebApp.Controls.KanbanGridControl.undefinedColor;
                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 22;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 15: {
                                        if (System.String.equals(text, "1")) {
                                            $step = 16;
                                            continue;
                                        }  else {
                                            $step = 18;
                                            continue;
                                        }
                                    }
                                    case 16: {
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 17;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        $taskResult2 = $taskResult5;
                                        $step = 20;
                                        continue;
                                    }
                                    case 18: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 19;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 19: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult2 = $taskResult6;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        text = $taskResult2;
                                        $step = 21;
                                        continue;
                                    }

                                    case 22: {
                                        valueElem = $("<div>").addClass("wf-kanban-item-value").appendTo(item);

                                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            img = $(($t1 = new Image(), $t1.className = "wf-dataImage", $t1)).appendTo(valueElem);

                                            if (!System.String.isNullOrEmpty(text)) {
                                                img.attr("src", "data:image/png;base64," + (text || ""));

                                                h = img.height();
                                                if (h > maxH) {
                                                    maxH = h;
                                                }
                                            } else {
                                                img.css("visibility", "hidden");
                                            }
                                        } else {
                                            this.SetColumnValue(col.v, valueElem, fieldDef, value, text, color1);
                                        }
                                        $step = 23;
                                        continue;
                                    }
                                    case 23: {
                                        i1 = (i1 + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 25: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 26: {
                                        $step = 33;
                                        continue;
                                    }
                                    case 27: {
                                        if (((this._filterOnServer) && (System.String.isNullOrEmpty(this._searchText)))) {
                                            $step = 28;
                                            continue;
                                        }  else {
                                            $step = 30;
                                            continue;
                                        }
                                    }
                                    case 28: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 29;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 29: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $taskResult1 = ($taskResult7 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 32;
                                        continue;
                                    }
                                    case 30: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 31;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 31: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult1 = $taskResult8;
                                        $step = 32;
                                        continue;
                                    }
                                    case 32: {
                                        txt = $taskResult1;

                                        if (this._notFound == null) {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("_notFound is null");

                                            this._notFound = $("<div>").addClass("form-row wf-msg").appendTo(this._gridContentElem);

                                            this._notFoundMsg = $("<div>").addClass("col-auto").html(txt).appendTo(this._notFound);
                                        } else {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("_notFound not null, setting text");
                                            this._notFoundMsg.html(txt);
                                        }

                                        this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._control.find(".wf-kanban")) : null;
                                        $step = 33;
                                        continue;
                                    }
                                    case 33: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            SetColumnValue: function (col, valueElem, fieldDef, value, text, color) {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.SetColumnValue.call(this, col, valueElem, fieldDef, value, text, color);

                if (Bridge.referenceEquals(text, "&nbsp;")) {
                    text = "";
                }

                valueElem.attr("title", System.String.format("{0}: {1}", fieldDef.Label, text));
            },
            ClearTable: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.ClearTable.call(this);

                if (this._notFound != null) {
                    this._notFound.remove();
                    this._notFound = null;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.MobileGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        fields: {
            _cols: null
        },
        props: {
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            IsVisible: {
                get: function () {
                    return true;
                }
            }
        },
        alias: [
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible"
        ],
        ctors: {
            ctor: function (formControl, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, formControl, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                if ((Bridge.referenceEquals(this.DataItem.DSPFID, e.DSPFID)) && (this._control != null)) {

                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.DataItem.DSPFID);
                    if (!Bridge.referenceEquals(this._currentRecord, rec)) {
                        if ((this._currentRecord != null ? this._currentRecord.RecID : null) != null) {
                            $(System.String.format(".wf-grid-row.id-{0}", [System.String.replaceAll(this._currentRecord.RecID, ",", "_")])).removeClass("wf-grid-row-selected");
                        }
                    }

                    if ((rec != null ? rec.RecID : null) != null) {
                        $(System.String.format(".wf-grid-row.id-{0}", [System.String.replaceAll(rec.RecID, ",", "_")])).addClass("wf-grid-row-selected");
                    }

                    this._currentRecord = rec;
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            CreateGridRow: function (form, dset, recs, cols, localRecNo) {
                var idClass = (recs[System.Array.index(localRecNo, recs)].RecID != null) ? System.String.format("id-{0}", [System.String.replaceAll(recs[System.Array.index(localRecNo, recs)].RecID, ",", "_")]) : "";

                var result = $("<div>").addClass(System.String.format("col-auto wf-grid-row {0}", [idClass])).appendTo(this._gridContentElem);

                if (localRecNo % 2 === 0) {
                    result.addClass("even");
                }

                return result;
            },
            GetGridColumns: function () {
                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $taskResult2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    grid, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    gridRowElem, 
                    innerRow, 
                    imageElem, 
                    othersElem, 
                    rowValueRow, 
                    prevIsLeftCol, 
                    i, 
                    col, 
                    nextCol, 
                    fieldDef, 
                    fieldValue, 
                    $t, 
                    isLeftCol, 
                    text, 
                    value, 
                    valueElem, 
                    img, 
                    $t1, 
                    rowValueCol, 
                    edt, 
                    edit, 
                    txt, 
                    $taskResult1, 
                    rowValueRow1, 
                    rowValue, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36], $step);
                                switch ($step) {
                                    case 0: {
                                        grid = containerItem;

                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 30;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        this._cols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                                            return col.Order;
                                        }).ToArray(Adaptica.WebForms.Common.DataModel.GridColumn);

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 29;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(recNo, recs)];

                                        gridRowElem = this.CreateGridRow(form, dset, recs, this._cols, localRecNo.v);
                                        gridRowElem.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        for (;;) {
                                                            $step = System.Array.min([0,1], $step);
                                                            switch ($step) {
                                                                case 0: {
                                                                    e.preventDefault();

                                                                    $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                    $step = 1;
                                                                    if ($task1.isCompleted()) {
                                                                        continue;
                                                                    }
                                                                    $task1.continue($asyncBody);
                                                                    return;
                                                                }
                                                                case 1: {
                                                                    $task1.getAwaitedResult();
                                                                    return;
                                                                }
                                                                default: {
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                            });
                                        })(this, localRecNo));

                                        innerRow = $("<div>").addClass("form-row").appendTo(gridRowElem);
                                        imageElem = $("<div>").addClass("wf-grid-row-image d-none").appendTo(innerRow);
                                        othersElem = $("<div>").addClass("col-auto flex-fill").appendTo(innerRow);

                                        rowValueRow = null;
                                        prevIsLeftCol = true;

                                        i = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 27;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i, this._cols)] };
                                        nextCol = (i < ((this._cols.length - 1) | 0)) ? this._cols[System.Array.index(((i + 1) | 0), this._cols)] : null;
                                        fieldDef = { v : System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null) };

                                        if (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile)) {
                                            $step = 26;
                                            continue;
                                        }

                                        fieldValue = rec != null && ($t = rec.FieldValues) != null ? System.Linq.Enumerable.from($t, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault((function ($me, fieldDef) {
                                            return function (fd) {
                                                return System.String.equals(fd.Name, fieldDef.v != null ? fieldDef.v.Name : null);
                                            };
                                        })(this, fieldDef), null) : null;
                                        if (fieldValue != null && System.Nullable.hasValue(fieldValue.ViewType)) {
                                            fieldDef.v.Type = System.Nullable.getValue(fieldValue.ViewType);
                                            fieldDef.v.Values = fieldValue.ViewValues;
                                            fieldDef.v.DisplayValues = fieldValue.ViewDisplayValues;
                                            fieldDef.v.Mask = fieldValue.ViewMask;
                                        }

                                        isLeftCol = (i <= 1) || ((nextCol != null) && (nextCol.RelatePrevious === 1)) || (!prevIsLeftCol);

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef.v);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef.v);

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task2 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task2.isCompleted()) {
                                            continue;
                                        }
                                        $task2.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult2 = $task2.getAwaitedResult();
                                        text = $taskResult2;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 18;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 17;
                                        continue;
                                    }
                                    case 15: {
                                        $task4 = (System.String.equals(text, "1") ? Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption") : Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption"));
                                        $step = 16;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 16: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 17;
                                        continue;
                                    }

                                    case 18: {
                                        if (isLeftCol) {
                                            rowValueRow = $("<div>").addClass("form-row").appendTo(othersElem);
                                        } else {
                                            rowValueRow.addClass("container");
                                        }

                                        valueElem = null;

                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            $step = 19;
                                            continue;
                                        } else  {
                                            $step = 20;
                                            continue;
                                        }
                                    }
                                    case 19: {
                                        imageElem.removeClass("d-none");

                                        if (!System.String.isNullOrEmpty(text)) {
                                            valueElem = $("<div>").addClass("wf-grid-value wf-grid-image").appendTo(imageElem);

                                            img = $(($t1 = new Image(), $t1.className = "wf-dataImage", $t1)).appendTo(valueElem);

                                            this.HandleImageOnLoad(img);

                                            img.attr("src", "data:image/png;base64," + (text || ""));

                                        }
                                        $step = 25;
                                        continue;
                                    }
                                    case 20: {
                                        rowValueCol = $("<div>").addClass("col-auto").appendTo(rowValueRow);

                                        valueElem = $("<div>").addClass("wf-grid-value").appendTo(rowValueCol);

                                        if ((this.AllowEdit(dset.DSPFID)) && (!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef.v))) {
                                            $step = 21;
                                            continue;
                                        } else  {
                                            $step = 23;
                                            continue;
                                        }
                                    }
                                    case 21: {
                                        edt = ($t1 = new Adaptica.WebForms.Common.DataModel.Edit(), $t1.DSPFID = dset.DSPFID, $t1.Caption = fieldDef.v.Label, $t1.FieldName = fieldDef.v.Name, $t1.FontColor = col.v.FontColor, $t1.FontStyle = col.v.FontStyle, $t1.Type = col.v.Type, $t1);

                                        edit = new Adaptica.WebForms.WebApp.Controls.EditControl(this.FormControl, edt, rec);
                                        edit.CreateControlOnly = true;
                                        this.SubControls.add(edit);

                                        $task5 = edit.RenderControl();
                                        $step = 22;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 22: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        ($taskResult5).appendTo(valueElem);
                                        $step = 24;
                                        continue;
                                    }
                                    case 23: {
                                        this.SetColumnValue(col.v, valueElem, fieldDef.v, value, text, col.v.FontColor);
                                        $step = 24;
                                        continue;
                                    }
                                    case 24: {
                                        if (!isLeftCol) {
                                            valueElem.addClass("float-right");
                                        }
                                        $step = 25;
                                        continue;
                                    }
                                    case 25: {
                                        if (i === 0) {
                                            valueElem != null ? valueElem.addClass("wf-grid-first") : null;
                                        }

                                        prevIsLeftCol = isLeftCol;
                                        $step = 26;
                                        continue;
                                    }
                                    case 26: {
                                        i = (i + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 28: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 29: {
                                        $step = 36;
                                        continue;
                                    }
                                    case 30: {
                                        if ((this._filterOnServer)) {
                                            $step = 31;
                                            continue;
                                        }  else {
                                            $step = 33;
                                            continue;
                                        }
                                    }
                                    case 31: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 32;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 32: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult1 = ($taskResult6 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 35;
                                        continue;
                                    }
                                    case 33: {
                                        $task7 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 34;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 34: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        $taskResult1 = $taskResult7;
                                        $step = 35;
                                        continue;
                                    }
                                    case 35: {
                                        txt = $taskResult1;

                                        rowValueRow1 = $("<div>").addClass("form-row").appendTo(this._gridContentElem);

                                        rowValue = $("<div>").addClass("col-auto").html(txt).appendTo(rowValueRow1);

                                        window.setTimeout(Bridge.fn.bind(this, function () {
                                            this._searchInput.focus();
                                        }), 100);
                                        $step = 36;
                                        continue;
                                    }
                                    case 36: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            }
        }
    });

    Bridge.define("Adaptica.WebForms.WebApp.Controls.TabulatorGridControl", {
        inherits: [Adaptica.WebForms.WebApp.Controls.GridControlBase],
        fields: {
            _table: null,
            _notFound: null,
            _notFoundMsg: null,
            _tabulator: null,
            _isCreating: false,
            _isRecalculating: false,
            _cols: null,
            _eventsAttached: false
        },
        props: {
            IsEnabled: {
                get: function () {
                    return true;
                }
            },
            IsRequired: {
                get: function () {
                    return false;
                }
            },
            IsVisible: {
                get: function () {
                    return true;
                }
            },
            IsResponsive: {
                get: function () {
                    return false;
                }
            },
            FloatThead: {
                get: function () {
                    return true;
                }
            },
            Scroller: {
                get: function () {
                    return false;
                }
            },
            ColReorder: {
                get: function () {
                    return false;
                }
            },
            ControlId: {
                get: function () {
                    return System.String.format("ctrl_{0}", [this.FormControl.CreateUniqueControlId()]);
                }
            }
        },
        alias: [
            "IsEnabled", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsEnabled",
            "IsRequired", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsRequired",
            "IsVisible", "Adaptica$WebForms$WebApp$Controls$IControlDataContext$IsVisible",
            "OnFormActivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormActivated",
            "OnFormDeactivated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormDeactivated",
            "OnShow", "Adaptica$WebForms$WebApp$Controls$IControl$OnShow",
            "OnHide", "Adaptica$WebForms$WebApp$Controls$IControl$OnHide",
            "OnFormCreated", "Adaptica$WebForms$WebApp$Controls$IControl$OnFormCreated",
            "Dispose", "System$IDisposable$Dispose"
        ],
        ctors: {
            init: function () {
                this._eventsAttached = false;
            },
            ctor: function (form, dataItem) {
                this.$initialize();
                Adaptica.WebForms.WebApp.Controls.GridControlBase.ctor.call(this, form, dataItem);
            }
        },
        methods: {
            CurrentRecordChanged: function (sender, e) {
                if ((Bridge.referenceEquals(this.DataItem.DSPFID, e.DSPFID)) && (this._control != null)) {
                    var rec = this.FormControl.CurrencyManager.GetCurrentRecord(this.DataItem.DSPFID);
                    this.SetRecordSelectedClass(rec, true);

                    this._currentRecord = rec;
                }

                return System.Threading.Tasks.Task.fromResult(null, System.Object);
            },
            SetRecordSelectedClass: function (rec, readScrollTop) {
                if (readScrollTop === void 0) { readScrollTop = false; }
                if (!Bridge.referenceEquals(this._currentRecord, rec)) {
                    if ((this._currentRecord != null ? this._currentRecord.RecID : null) != null) {
                        $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(this._currentRecord.RecID)])).removeClass("wf-grid-row-selected");
                    }
                }

                if ((rec != null ? rec.RecID : null) != null) {
                    var row = $(System.String.format(".wf-grid-row.id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(rec.RecID)]));
                    row.addClass("wf-grid-row-selected");

                    if (readScrollTop) {
                        this._tableScrollTop = row.closest(".tabulator_scrollBody").scrollTop();
                    }
                }
            },
            GetGridColumns: function () {
                return this._cols;
            },
            CreateGridContent: function (form, dset, containerItem, fieldDefs, recs) {
                var $step = 0,
                    $task1, 
                    $task2, 
                    $task3, 
                    $taskResult3, 
                    $task4, 
                    $taskResult4, 
                    $task5, 
                    $taskResult5, 
                    $task6, 
                    $taskResult6, 
                    $task7, 
                    $taskResult7, 
                    $task8, 
                    $taskResult8, 
                    $task9, 
                    $taskResult9, 
                    $jumpFromFinally, 
                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                    $returnValue, 
                    tbody, 
                    rows, 
                    selRecord, 
                    selRow, 
                    maxH, 
                    recNo, 
                    localRecNo, 
                    rec, 
                    row, 
                    i, 
                    col, 
                    color, 
                    fieldDef, 
                    fieldValue, 
                    $t, 
                    cell, 
                    text, 
                    value, 
                    $taskResult2, 
                    valueElem, 
                    img, 
                    $t1, 
                    h, 
                    edt, 
                    edit, 
                    txt, 
                    $taskResult1, 
                    $async_e, 
                    $asyncBody = Bridge.fn.bind(this, function () {
                        try {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17,18,19,20,22,23,24,25,26,27,29,30,32,33,34,35,36,37,38,39,40], $step);
                                switch ($step) {
                                    case 0: {
                                        if (recs.length > 0) {
                                            $step = 1;
                                            continue;
                                        } else  {
                                            $step = 34;
                                            continue;
                                        }
                                    }
                                    case 1: {
                                        if (this._notFound != null) {
                                            this._notFound.remove();
                                            this._notFound = null;

                                            this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._control.find(".wf-grid-tabulator")) : null;
                                        }

                                        if (this._table == null) {
                                            this.CreateGridHeader(containerItem, fieldDefs);
                                        }

                                        tbody = $("<tbody>").appendTo(this._table);

                                        this._table != null ? Adaptica.WebForms.WebApp.Extensions.WFShow(this._table) : null;

                                        rows = null;
                                        if (this._tabulator != null) {
                                            rows = System.Array.init(recs.length, null, System.Object);
                                        }

                                        selRecord = null;
                                        selRow = null;
                                        maxH = 0;

                                        recNo = 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 2: {
                                        if ( recNo < recs.length ) {
                                            $step = 3;
                                            continue;
                                        }
                                        $step = 33;
                                        continue;
                                    }
                                    case 3: {
                                        localRecNo = { v : recNo };
                                        rec = recs[System.Array.index(localRecNo.v, recs)];

                                        row = $("<tr>").addClass(System.String.format("wf-grid-row id-{0}", [Adaptica.WebForms.WebApp.Controls.ControlUtils.CreateValidId(rec.RecID)]));

                                        if (Bridge.referenceEquals((this._currentRecord != null ? this._currentRecord.RecID : null), rec.RecID)) {
                                            selRecord = rec;
                                            selRow = row;
                                        }

                                        if (this._tabulator != null) {
                                            rows[System.Array.index(recNo, rows)] = row.get(0);
                                        } else {
                                            row.appendTo(tbody);
                                        }

                                        row.on("click", (function ($me, localRecNo) {
                                            return Bridge.fn.bind($me, function (e) {
                                                var $step = 0,
                                                    $task1, 
                                                    $jumpFromFinally, 
                                                    $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                                                    $returnValue, 
                                                    $async_e, 
                                                    $asyncBody = Bridge.fn.bind(this, function () {
                                                        try {
                                                            for (;;) {
                                                                $step = System.Array.min([0,1], $step);
                                                                switch ($step) {
                                                                    case 0: {
                                                                        if (!System.String.isNullOrEmpty(Bridge.toString(window.getSelection()))) {
                                                                            $tcs.setResult(null);
                                                                            return;
                                                                        }

                                                                        Adaptica.WebForms.WebApp.WebFormsApp.Log("row click");

                                                                        e.stopImmediatePropagation();
                                                                        e.preventDefault();

                                                                        $task1 = this.OnRowClick(form, dset, recs, this._cols, localRecNo.v);
                                                                        $step = 1;
                                                                        if ($task1.isCompleted()) {
                                                                            continue;
                                                                        }
                                                                        $task1.continue($asyncBody);
                                                                        return;
                                                                    }
                                                                    case 1: {
                                                                        $task1.getAwaitedResult();
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                    default: {
                                                                        $tcs.setResult(null);
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        } catch($async_e1) {
                                                            $async_e = System.Exception.create($async_e1);
                                                            $tcs.setException($async_e);
                                                        }
                                                    }, arguments);

                                                $asyncBody();
                                                return $tcs.task;
                                            });
                                        })(this, localRecNo));

                                        i = 0;
                                        $step = 4;
                                        continue;
                                    }
                                    case 4: {
                                        if ( i < this._cols.length ) {
                                            $step = 5;
                                            continue;
                                        }
                                        $step = 31;
                                        continue;
                                    }
                                    case 5: {
                                        col = { v : this._cols[System.Array.index(i, this._cols)] };
                                        color = col.v.FontColor;
                                        fieldDef = { v : System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                                            return function (fld) {
                                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                                            };
                                        })(this, col), null) };

                                        fieldValue = rec != null && ($t = rec.FieldValues) != null ? System.Linq.Enumerable.from($t, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault((function ($me, fieldDef) {
                                            return function (fd) {
                                                return System.String.equals(fd.Name, fieldDef.v != null ? fieldDef.v.Name : null);
                                            };
                                        })(this, fieldDef), null) : null;
                                        if (fieldValue != null && System.Nullable.hasValue(fieldValue.ViewType)) {
                                            fieldDef.v.Type = System.Nullable.getValue(fieldValue.ViewType);
                                            fieldDef.v.Values = fieldValue.ViewValues;
                                            fieldDef.v.DisplayValues = fieldValue.ViewDisplayValues;
                                            fieldDef.v.Mask = fieldValue.ViewMask;
                                        }

                                        cell = $("<td>").appendTo(row);

                                        text = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldDisplayValue(rec, fieldDef.v);
                                        value = Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue(rec, fieldDef.v);

                                        if (text == null) {
                                            $step = 6;
                                            continue;
                                        } else  {
                                            $step = 14;
                                            continue;
                                        }
                                    }
                                    case 6: {
                                        color = "#7b7b7b";
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 7;
                                            continue;
                                        } else  {
                                            $step = 9;
                                            continue;
                                        }
                                    }
                                    case 7: {
                                        $task3 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueNotSetCaption");
                                        $step = 8;
                                        if ($task3.isCompleted()) {
                                            continue;
                                        }
                                        $task3.continue($asyncBody);
                                        return;
                                    }
                                    case 8: {
                                        $taskResult3 = $task3.getAwaitedResult();
                                        text = $taskResult3;
                                        $step = 13;
                                        continue;
                                    }
                                    case 9: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                                            $step = 10;
                                            continue;
                                        } 
                                        $step = 12;
                                        continue;
                                    }
                                    case 10: {
                                        $task4 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NullPickerValue");
                                        $step = 11;
                                        if ($task4.isCompleted()) {
                                            continue;
                                        }
                                        $task4.continue($asyncBody);
                                        return;
                                    }
                                    case 11: {
                                        $taskResult4 = $task4.getAwaitedResult();
                                        text = $taskResult4;
                                        $step = 12;
                                        continue;
                                    }

                                    case 13: {
                                        $step = 22;
                                        continue;
                                    }
                                    case 14: {
                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Bit) {
                                            $step = 15;
                                            continue;
                                        } 
                                        $step = 21;
                                        continue;
                                    }
                                    case 15: {
                                        if (System.String.equals(text, "1")) {
                                            $step = 16;
                                            continue;
                                        }  else {
                                            $step = 18;
                                            continue;
                                        }
                                    }
                                    case 16: {
                                        $task5 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueTrueCaption");
                                        $step = 17;
                                        if ($task5.isCompleted()) {
                                            continue;
                                        }
                                        $task5.continue($asyncBody);
                                        return;
                                    }
                                    case 17: {
                                        $taskResult5 = $task5.getAwaitedResult();
                                        $taskResult2 = $taskResult5;
                                        $step = 20;
                                        continue;
                                    }
                                    case 18: {
                                        $task6 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("BitValueFalseCaption");
                                        $step = 19;
                                        if ($task6.isCompleted()) {
                                            continue;
                                        }
                                        $task6.continue($asyncBody);
                                        return;
                                    }
                                    case 19: {
                                        $taskResult6 = $task6.getAwaitedResult();
                                        $taskResult2 = $taskResult6;
                                        $step = 20;
                                        continue;
                                    }
                                    case 20: {
                                        text = $taskResult2;
                                        $step = 21;
                                        continue;
                                    }

                                    case 22: {
                                        valueElem = null;

                                        if (fieldDef.v.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                                            $step = 23;
                                            continue;
                                        } else  {
                                            $step = 24;
                                            continue;
                                        }
                                    }
                                    case 23: {
                                        valueElem = $("<div>").addClass("wf-grid-value wf-grid-image").appendTo(cell);

                                        img = $(($t1 = new Image(), $t1.className = "wf-dataImage", $t1)).appendTo(valueElem);

                                        if (!System.String.isNullOrEmpty(text)) {
                                            img.attr("src", "data:image/png;base64," + (text || ""));

                                            h = img.height();
                                            if (h > maxH) {
                                                maxH = h;
                                            }
                                        } else {
                                            img.css("visibility", "hidden");
                                        }
                                        $step = 29;
                                        continue;
                                    }
                                    case 24: {
                                        /* 
                                                                   var rowValueCol = new jQuery("<div>")
                                                                       .AppendTo(cell);

                                                                   valueElem = new jQuery("<div>")
                                                                       .AddClass("wf-grid-value")
                                                                       .AppendTo(rowValueCol);
                                        */

                                        cell.addClass("wf-grid-value");
                                        valueElem = cell;

                                        if ((this.AllowEdit(dset.DSPFID)) && (!Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef.v))) {
                                            $step = 25;
                                            continue;
                                        } else  {
                                            $step = 27;
                                            continue;
                                        }
                                    }
                                    case 25: {
                                        edt = ($t1 = new Adaptica.WebForms.Common.DataModel.Edit(), $t1.DSPFID = dset.DSPFID, $t1.Caption = fieldDef.v.Label, $t1.FieldName = fieldDef.v.Name, $t1.FontColor = col.v.FontColor, $t1.FontStyle = col.v.FontStyle, $t1.Type = col.v.Type, $t1);

                                        edit = ($t1 = new Adaptica.WebForms.WebApp.Controls.EditControl(this.FormControl, edt, rec), $t1.CreateControlOnly = true, $t1);
                                        this.SubControls.add(edit);

                                        $task7 = edit.RenderControl();
                                        $step = 26;
                                        if ($task7.isCompleted()) {
                                            continue;
                                        }
                                        $task7.continue($asyncBody);
                                        return;
                                    }
                                    case 26: {
                                        $taskResult7 = $task7.getAwaitedResult();
                                        ($taskResult7).appendTo(valueElem);
                                        $step = 28;
                                        continue;
                                    }
                                    case 27: {
                                        if (Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile)) {
                                            cell.addClass("wf-grid-cell-download");
                                        }

                                        this.SetColumnValue(col.v, valueElem, fieldDef.v, value, text, color);
                                        $step = 28;
                                        continue;
                                    }

                                    case 29: {
                                        if (i === 0) {
                                            valueElem != null ? valueElem.addClass("wf-grid-first") : null;
                                        }
                                        $step = 30;
                                        continue;
                                    }
                                    case 30: {
                                        i = (i + 1) | 0;
                                        $step = 4;
                                        continue;
                                    }

                                    case 32: {
                                        recNo = (recNo + 1) | 0;
                                        $step = 2;
                                        continue;
                                    }
                                    case 33: {
                                        if (this._tabulator == null) {
                                            this.CreateTable();
                                        } else {
                                        }

                                        if (selRecord != null) {
                                            this.SetRecordSelectedClass(selRecord);
                                            window.setTimeout(Bridge.fn.bind(this, function () {
                                                if (!this.IsElementInViewport(Bridge.as(selRow.get(0), HTMLElement))) {
                                                    selRow.closest(".tabulator_scrollBody").scrollTop(this._tableScrollTop);
                                                }
                                            }), 50);
                                        }
                                        $step = 40;
                                        continue;
                                    }
                                    case 34: {
                                        if (((this._filterOnServer) && (System.String.isNullOrEmpty(this._searchText)))) {
                                            $step = 35;
                                            continue;
                                        }  else {
                                            $step = 37;
                                            continue;
                                        }
                                    }
                                    case 35: {
                                        $task8 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync$1("TooManyRecordsMessage", [Bridge.box(dset.RecordCount, System.Int32)]);
                                        $step = 36;
                                        if ($task8.isCompleted()) {
                                            continue;
                                        }
                                        $task8.continue($asyncBody);
                                        return;
                                    }
                                    case 36: {
                                        $taskResult8 = $task8.getAwaitedResult();
                                        $taskResult1 = ($taskResult8 || "") + "<div class=\"form-row\">" + (this.GetSearchableColumnList(dset) || "") + "</div>";
                                        $step = 39;
                                        continue;
                                    }
                                    case 37: {
                                        $task9 = Adaptica.WebForms.WebApp.WebFormsApp.GetTextAsync("NoRecordsFoundMessage");
                                        $step = 38;
                                        if ($task9.isCompleted()) {
                                            continue;
                                        }
                                        $task9.continue($asyncBody);
                                        return;
                                    }
                                    case 38: {
                                        $taskResult9 = $task9.getAwaitedResult();
                                        $taskResult1 = $taskResult9;
                                        $step = 39;
                                        continue;
                                    }
                                    case 39: {
                                        txt = $taskResult1;

                                        if (this._notFound == null) {

                                            this._notFound = $("<div>").addClass("form-row wf-msg").appendTo(this._gridContentElem);

                                            this._notFoundMsg = $("<div>").addClass("col-auto").html(txt).appendTo(this._notFound);
                                        } else {
                                            this._notFoundMsg.html(txt);
                                        }

                                        this._control != null ? Adaptica.WebForms.WebApp.Extensions.WFHide(this._control.find(".wf-grid-tabulator")) : null;
                                        $step = 40;
                                        continue;
                                    }
                                    case 40: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                    default: {
                                        $tcs.setResult(null);
                                        return;
                                    }
                                }
                            }
                        } catch($async_e1) {
                            $async_e = System.Exception.create($async_e1);
                            $tcs.setException($async_e);
                        }
                    }, arguments);

                $asyncBody();
                return $tcs.task;
            },
            IsElementInViewport: function (e) {
                var el = null;

                if (Bridge.is(e, $)) {
                    el = Bridge.as((Bridge.as(e, $)).get(0), HTMLElement);
                } else if (Bridge.is(e, HTMLElement)) {
                    el = Bridge.as(e, HTMLElement);
                }

                if (el == null) {
                    throw new System.Exception("Invalid type");
                }

                var rect = el.getBoundingClientRect();

                var h = window.innerHeight;
                if (h === 0) {
                    h = window.document.documentElement.clientHeight;
                }
                var w = window.innerHeight;
                if (w === 0) {
                    w = window.document.documentElement.clientWidth;
                }

                return (rect.top >= 0 && rect.left >= 0 && rect.bottom <= h && rect.right <= w);
            },
            CreateGridHeader: function (containerItem, fieldDefs) {
                var $t;
                var grid = containerItem;

                var tmpCols = System.Linq.Enumerable.from(grid.GridColumns, Adaptica.WebForms.Common.DataModel.GridColumn).orderBy(function (col) {
                        return col.Order;
                    }).toList(Adaptica.WebForms.Common.DataModel.GridColumn);

                var colIdx = 0;
                var i = (tmpCols.Count - 1) | 0;
                while (i > colIdx) {
                    var col = { v : tmpCols.getItem(i) };
                    var fieldDef = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col) {
                            return function (fld) {
                                return Bridge.referenceEquals(fld.Name, col.v.FieldName);
                            };
                        })(this, col), null);
                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Blob) {
                        tmpCols.removeAt(i);
                        tmpCols.insert(colIdx, col.v);
                        colIdx = (colIdx + 1) | 0;
                    } else {
                        i = (i - 1) | 0;
                    }
                }

                this._cols = tmpCols.ToArray();

                this._table = $("<table>").attr("id", this.ControlId).addClass("wf-grid-tabulator table table-striped table-bordered xnowrap");

                if (this.IsResponsive) {
                    this._table.addClass("dt-responsive");
                }

                var tHead = $("<thead>").appendTo(this._table);

                if (Bridge.equals(("no"), window.self.gridHeader)) {
                    tHead.addClass("wf-hidden");
                }

                var tHeadRow = $("<tr>").appendTo(tHead);

                $t = Bridge.getEnumerator(this._cols);
                try {
                    while ($t.moveNext()) {
                        var col1 = { v : $t.Current };
                        var fieldDef1 = System.Linq.Enumerable.from(fieldDefs, Adaptica.WebForms.Common.DataModel.FieldDef).singleOrDefault((function ($me, col1) {
                                return function (fld) {
                                    return Bridge.referenceEquals(fld.Name, col1.v.FieldName);
                                };
                            })(this, col1), null);
                        var isDownload = Bridge.referenceEquals(col1.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIDownloadFile) || Bridge.referenceEquals(col1.v.Action, Adaptica.WebForms.Common.DataModel.ContainerItem.QIPrintFile);
                        var lbl = (isDownload) ? "" : fieldDef1.Label;

                        var cell = $("<th>").addClass("wf-grid-header").html(lbl).appendTo(tHeadRow);

                        if (isDownload) {
                            cell.addClass("wf-grid-cell-download");
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                this._gridContentElem.append(this._table);
            },
            ClearTable: function () {
                if (this._table == null) {
                    return;
                }

                this._tabulator.clearData();
            },
            OnFormActivated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormActivated.call(this);

                this.OnShownOrActivated();
            },
            OnFormDeactivated: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormDeactivated.call(this);
            },
            OnShow: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnShow.call(this);

                this.OnShownOrActivated();
            },
            OnHide: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnHide.call(this);

                this.OnHiddenOrDeactivated();
            },
            OnShownOrActivated: function () {
                if ((this.IsShown) && (!this._eventsAttached)) {
                    this._eventsAttached = true;

                    window.addEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));

                    if (this._searchBar != null) {
                        window.setTimeout(Bridge.fn.bind(this, function () {
                            this._searchInput.focus();
                        }), 10);
                    }
                }

                this.RecalculateSize();
            },
            OnHiddenOrDeactivated: function () {
                window.removeEventListener("resize", Bridge.fn.cacheBind(this, this.RecalculateSize));
                this._eventsAttached = false;
            },
            RecalculateSize: function () {
                if ((this._notFound != null) || (this._isRecalculating)) {
                    return;
                }

                window.setTimeout(Bridge.fn.bind(this, function () {
                    if (this._isRecalculating) {
                        return;
                    }

                    this._isRecalculating = true;

                    var sTopElem = this.FormControl.Content.find(".sticky-top");
                    var prnt = this._gridContentElem.parent();

                    var h = this._gridContentElem.height();
                    var sTop = sTopElem.height();
                    var sTopOffsetTop = sTopElem.offset().top;
                    var scrollH = (prnt.prop("offsetHeight") - this._gridContentElem.prop("offsetHeight")) | 0;

                    var calc = (((((window.innerHeight - sTop) | 0) - sTopOffsetTop) | 0) - (((scrollH + 10) | 0))) | 0;
                    this._gridContentElem.css("height", calc);

                    var sh = prnt.prop("scrollHeight");
                    var oh = prnt.prop("offsetHeight");
                    var ch = prnt.prop("clientHeight");

                    Adaptica.WebForms.WebApp.WebFormsApp.Log(System.String.format("resize - controlId: {0}, grid height: {1}, sticky top height: {2}, new calculated height: {3}, parent scroll height: {4}, parent offset height: {5}, parent client height: {6}, scrollbar height: {7}.", this.ControlId, Bridge.box(h, System.Int32), Bridge.box(sTop, System.Int32), Bridge.box(calc, System.Int32), Bridge.box(sh, System.Int32), Bridge.box(oh, System.Int32), Bridge.box(ch, System.Int32), Bridge.box(scrollH, System.Int32)));

                    this._isRecalculating = false;
                }), 10);
            },
            OnScroll: function () {
                if (this.FloatThead) {
                    this._table.floatThead("reflow");
                }
                Adaptica.WebForms.WebApp.WebFormsApp.Log("Reflow.");
            },
            OnFormCreated: function () {
                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.OnFormCreated.call(this);

                if (this._notFound == null) {
                    this.CreateTable();
                }
            },
            CreateTable: function () {
                if ((this._tabulator == null) && (!this._isCreating)) {
                    this._isCreating = true;
                    window.setTimeout(Bridge.fn.bind(this, function () {
                        var tbl = jQuery(this._table);

                        this._tabulator = new Tabulator('#' + tbl.attr('id'), { layout:"fitColumns", movableColumns:true, resizableColumns:true, resizableRows:false, pagination:false, height:"100%", columnDefaults: { formatter: "html" } });

                        this.RecalculateSize();

                        this._isCreating = false;
                    }), 100);

                }
            },
            Dispose: function () {
                this.OnHiddenOrDeactivated();

                Adaptica.WebForms.WebApp.Controls.GridControlBase.prototype.Dispose.call(this);
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,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