Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.WebApp.WebFormsUtils", {
        statics: {
            methods: {
                ResolveIncludes: function () {
                    var $step = 0,
                        $task1, 
                        $jumpFromFinally, 
                        $tcs = new System.Threading.Tasks.TaskCompletionSource(), 
                        $returnValue, 
                        completed, 
                        resolved, 
                        includes, 
                        $async_e, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            try {
                                for (;;) {
                                    $step = System.Array.min([0,1], $step);
                                    switch ($step) {
                                        case 0: {
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("Resolving includes");

                                            completed = false;
                                            resolved = 0;
                                            includes = $("[data-wf-include]");
                                            includes.each(function (i, element) {
                                                var jqElem = $(element);
                                                jqElem.load("user_" + (jqElem.data("wf-include") || ""), "", function (responseText, textStatus, xhr) {
                                                    if (Bridge.referenceEquals(textStatus, "error")) {
                                                        jqElem.load(jqElem.data("wf-include"));
                                                    }

                                                    resolved = (resolved + 1) | 0;
                                                    completed = (resolved === includes.length);
                                                });
                                            });

                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("Waiting all includes to be resolved resolved");
                                            $task1 = Adaptica.WebForms.WebApp.WebFormsApp.WaitFor(function () {
                                                return completed;
                                            });
                                            $step = 1;
                                            if ($task1.isCompleted()) {
                                                continue;
                                            }
                                            $task1.continue($asyncBody);
                                            return;
                                        }
                                        case 1: {
                                            $task1.getAwaitedResult();
                                            Adaptica.WebForms.WebApp.WebFormsApp.Log("Includes resolved");
                                            $tcs.setResult(null);
                                            return;
                                        }
                                        default: {
                                            $tcs.setResult(null);
                                            return;
                                        }
                                    }
                                }
                            } catch($async_e1) {
                                $async_e = System.Exception.create($async_e1);
                                $tcs.setException($async_e);
                            }
                        }, arguments);

                    $asyncBody();
                    return $tcs.task;
                },
                SetOverflow: function (style, value) {
                    var $t;
                    var oldValue = style.overflow;
                    style.overflow = value;

                    return ($t = oldValue, $t != null ? $t : "");
                },
                GetSize: function (elem) {
                    if (elem == null) {
                        return new (System.ValueTuple$2(System.Int32,System.Int32)).$ctor1(0, 0);
                    }

                    var style = elem.style;
                    var oldValue = Adaptica.WebForms.WebApp.WebFormsUtils.SetOverflow(elem.style, "hidden");
                    var width = elem.clientWidth;
                    var height = elem.clientHeight;
                    Adaptica.WebForms.WebApp.WebFormsUtils.SetOverflow(style, oldValue);
                    return new (System.ValueTuple$2(System.Int32,System.Int32)).$ctor1(width, height);
                },
                GetViewPortSize: function () {
                    var vPort = new (System.ValueTuple$2(System.Int32,System.Int32)).$ctor1(100, 100);
                    if (window.innerWidth > 0) {
                        vPort.Item1 = window.innerWidth;
                    }
                    if (window.innerHeight > 0) {
                        vPort.Item2 = window.innerHeight;
                    }

                    var doc = window.document;
                    var html = doc.documentElement;
                    var body = doc.body;
                    if (body == null) {
                        body = doc.getElementsByTagName("body")[0];
                    }

                    var htmlSize = Adaptica.WebForms.WebApp.WebFormsUtils.GetSize(html);
                    var bodySize = Adaptica.WebForms.WebApp.WebFormsUtils.GetSize(body);

                    return new (System.ValueTuple$2(System.Int32,System.Int32)).$ctor1(Math.max(htmlSize.Item1, bodySize.Item1), Math.max(htmlSize.Item2, bodySize.Item2));
                },
                RemoveTemplateStylesFromDom: function (name) {
                    var elem = window.document.getElementById(System.String.format("wf-css-{0}", [name]));
                    elem != null ? elem.parentNode.removeChild(elem) : null;
                },
                AddTemplateStylesToDom: function (name, tInfo) {
                    if (!System.String.isNullOrEmpty(tInfo.Css)) {
                        var elem = document.getElementById(System.String.format("wf-css-{0}", [name]));
                        if (elem == null) {
                            elem = document.createElement("style");
                            elem.id = System.String.format("wf-css-{0}", [name]);
                            elem.innerHTML = tInfo.Css;

                            var head = document.getElementsByTagName("head");
                            head[0].appendChild(elem);
                        }
                    }
                },
                ShowElement: function (action) {
                    action.removeClass("wf-hidden");
                },
                HideElement: function (action) {
                    action.addClass("wf-hidden");
                }
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,ewogICJ2ZXJzaW9uIjogMywKICAiZmlsZSI6ICJVdGlscy5qcyIsCiAgInNvdXJjZVJvb3QiOiAiIiwKICAic291cmNlcyI6IFsiV2ViRm9ybXNVdGlscy5jcyJdLAogICJuYW1lcyI6IFsiIl0sCiAgIm1hcHBpbmdzIjogIjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs0Q0FjWUE7OzRDQUVBQTs0Q0FDQUE7NENBQ0FBLFdBQWVBOzRDQUNmQSxjQUFjQSxBQUFzQkEsVUFBQ0EsR0FBR0E7Z0RBRXBDQSxhQUFhQSxFQUFXQTtnREFDeEJBLFlBQVlBLFdBQVVBLHNDQUF1Q0EsQUFBOEJBLFVBQUNBLGNBQWNBLFlBQVlBO29EQUVsSEEsSUFBSUE7d0RBRUFBLFlBQVlBOzs7b0RBR2hCQTtvREFDQUEsWUFBWUEsQ0FBQ0EsYUFBWUE7Ozs7NENBSWpDQTs0Q0FDQUEsU0FBTUEsNkNBQW9CQSxBQUFhQTt1REFBTUE7Ozs7Ozs7Ozs7OzRDQUU3Q0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7dUNBRThCQSxPQUEyQkE7O29CQUV6REEsZUFBa0JBLEFBQVFBO29CQUMxQkEsaUJBQWlCQTs7b0JBRWpCQSxPQUFPQTs7bUNBR3lDQTtvQkFFaERBLElBQUlBLFFBQVFBO3dCQUNSQSxPQUFPQSxLQUFJQTs7O29CQUdmQSxZQUFZQTtvQkFDWkEsZUFBZUEsbURBQVlBO29CQUMzQkEsWUFBWUE7b0JBQ1pBLGFBQWFBO29CQUNiQSxtREFBWUEsT0FBT0E7b0JBQ25CQSxPQUFPQSxLQUFJQSx1REFBNEJBLE9BQU9BOzs7b0JBSzlDQSxZQUFxQ0EsS0FBSUE7b0JBQ3pDQSxJQUFJQTt3QkFDaEJBLGNBQWFBOztvQkFDREEsSUFBSUE7d0JBQ2hCQSxjQUFhQTs7O29CQUVEQSxVQUFVQTtvQkFDVkEsV0FBV0E7b0JBQ1hBLFdBQVdBO29CQUNYQSxJQUFJQSxRQUFRQTt3QkFDUkEsT0FBT0E7OztvQkFFWEEsZUFBZUEsK0NBQVFBO29CQUN2QkEsZUFBZUEsK0NBQVFBOztvQkFFdkJBLE9BQU9BLEtBQUlBLHVEQUE0QkEsU0FBU0EsZ0JBQWdCQSxpQkFBaUJBLFNBQVNBLGdCQUFnQkE7O3VEQUcvREE7b0JBRTNDQSxXQUFXQSwrQkFBK0JBLG9DQUEyQkE7b0JBQ3JFQSxRQUFNQSxPQUFLQSw0QkFBNEJBLFFBQU1BLEFBQU1BOztrREFHYkEsTUFBYUE7b0JBRW5EQSxJQUFJQSxDQUFDQSw0QkFBcUJBO3dCQUV0QkEsV0FBV0Esd0JBQXdCQSxvQ0FBMkJBO3dCQUM5REEsSUFBSUEsUUFBUUE7NEJBRVJBLE9BQU9BOzRCQUNQQSxVQUFVQSxvQ0FBMkJBOzRCQUNyQ0EsaUJBQWlCQTs7NEJBRWpCQSxXQUFXQTs0QkFDWEEsb0JBQW9CQTs7Ozt1Q0FLREE7b0JBRTNCQTs7dUNBRzJCQTtvQkFFM0JBIiwKICAic291cmNlc0NvbnRlbnQiOiBbInVzaW5nIFN5c3RlbTtcclxudXNpbmcgU3lzdGVtLlRocmVhZGluZy5UYXNrcztcclxudXNpbmcgQnJpZGdlO1xyXG51c2luZyBCcmlkZ2UuSHRtbDU7XHJcbnVzaW5nIEJyaWRnZS5qUXVlcnkyO1xyXG51c2luZyBSZXR5cGVkO1xyXG5cclxubmFtZXNwYWNlIEFkYXB0aWNhLldlYkZvcm1zLldlYkFwcFxyXG57XHJcbiAgICBbRmlsZU5hbWUoXCJVdGlscy5qc1wiKV1cclxuICAgIHB1YmxpYyBzdGF0aWMgY2xhc3MgV2ViRm9ybXNVdGlsc1xyXG4gICAge1xyXG4gICAgICAgIHB1YmxpYyBzdGF0aWMgYXN5bmMgVGFzayBSZXNvbHZlSW5jbHVkZXMoKVxyXG4gICAgICAgIHtcclxuICAgICAgICAgICAgV2ViRm9ybXNBcHAuTG9nKFwiUmVzb2x2aW5nIGluY2x1ZGVzXCIpO1xyXG4gICAgICAgICAgICBcclxuICAgICAgICAgICAgdmFyIGNvbXBsZXRlZCA9IGZhbHNlO1xyXG4gICAgICAgICAgICB2YXIgcmVzb2x2ZWQgPSAwO1xyXG4gICAgICAgICAgICB2YXIgaW5jbHVkZXMgPSBqUXVlcnkuU2VsZWN0KFwiW2RhdGEtd2YtaW5jbHVkZV1cIik7XHJcbiAgICAgICAgICAgIGluY2x1ZGVzLkVhY2goKEFjdGlvbjxpbnQsRWxlbWVudD4pKChpLCBlbGVtZW50KSA9PlxyXG4gICAgICAgICAgICB7XHJcbiAgICAgICAgICAgICAgICB2YXIganFFbGVtID0gbmV3IGpRdWVyeShlbGVtZW50KTtcclxuICAgICAgICAgICAgICAgIGpxRWxlbS5Mb2FkKFwidXNlcl9cIiArIGpxRWxlbS5EYXRhPHN0cmluZz4oXCJ3Zi1pbmNsdWRlXCIpLCBcIlwiLCAoQWN0aW9uPHN0cmluZyxzdHJpbmcsanFYSFI+KSgocmVzcG9uc2VUZXh0LCB0ZXh0U3RhdHVzLCB4aHIpID0+XHJcbiAgICAgICAgICAgICAgICB7XHJcbiAgICAgICAgICAgICAgICAgICAgaWYgKHRleHRTdGF0dXMgPT0gXCJlcnJvclwiKVxyXG4gICAgICAgICAgICAgICAgICAgIHtcclxuICAgICAgICAgICAgICAgICAgICAgICAganFFbGVtLkxvYWQoanFFbGVtLkRhdGE8c3RyaW5nPihcIndmLWluY2x1ZGVcIikpO1xyXG4gICAgICAgICAgICAgICAgICAgIH1cclxuXHJcbiAgICAgICAgICAgICAgICAgICAgcmVzb2x2ZWQrKztcclxuICAgICAgICAgICAgICAgICAgICBjb21wbGV0ZWQgPSAocmVzb2x2ZWQgPT0gaW5jbHVkZXMuTGVuZ3RoKTtcclxuICAgICAgICAgICAgICAgIH0pKTtcclxuICAgICAgICAgICAgfSkpO1xyXG5cclxuICAgICAgICAgICAgV2ViRm9ybXNBcHAuTG9nKFwiV2FpdGluZyBhbGwgaW5jbHVkZXMgdG8gYmUgcmVzb2x2ZWQgcmVzb2x2ZWRcIik7XHJcbiAgICAgICAgICAgIGF3YWl0IFdlYkZvcm1zQXBwLldhaXRGb3IoKEZ1bmM8Ym9vbD4pKCgpID0+IGNvbXBsZXRlZCkpO1xyXG5cclxuICAgICAgICAgICAgV2ViRm9ybXNBcHAuTG9nKFwiSW5jbHVkZXMgcmVzb2x2ZWRcIik7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIHByaXZhdGUgc3RhdGljIHN0cmluZyBTZXRPdmVyZmxvdyhDU1NTdHlsZURlY2xhcmF0aW9uIHN0eWxlLCBzdHJpbmcgdmFsdWUpXHJcbiAgICAgICAge1xyXG4gICAgICAgICAgICBzdHJpbmcgb2xkVmFsdWUgPSAoc3RyaW5nKXN0eWxlLk92ZXJmbG93O1xyXG4gICAgICAgICAgICBzdHlsZS5PdmVyZmxvdyA9IHZhbHVlO1xyXG5cclxuICAgICAgICAgICAgcmV0dXJuIG9sZFZhbHVlID8/IFwiXCI7XHJcbiAgICAgICAgfVxyXG5cclxuICAgICAgICBwcml2YXRlIHN0YXRpYyBTeXN0ZW0uVmFsdWVUdXBsZTxpbnQgLGludCA+IEdldFNpemUoSFRNTEVsZW1lbnQgZWxlbSlcclxuICAgICAgICB7XHJcbiAgICAgICAgICAgIGlmIChlbGVtID09IG51bGwpXHJcbiAgICAgICAgICAgICAgICByZXR1cm4gbmV3IFN5c3RlbS5WYWx1ZVR1cGxlPGludCwgaW50PigwLCAwKTtcclxuXHJcbiAgICAgICAgICAgIC8vXHJcbiAgICAgICAgICAgIHZhciBzdHlsZSA9IGVsZW0uU3R5bGU7XHJcbiAgICAgICAgICAgIHZhciBvbGRWYWx1ZSA9IFNldE92ZXJmbG93KGVsZW0uU3R5bGUsIFwiaGlkZGVuXCIpO1xyXG4gICAgICAgICAgICB2YXIgd2lkdGggPSBlbGVtLkNsaWVudFdpZHRoO1xyXG4gICAgICAgICAgICB2YXIgaGVpZ2h0ID0gZWxlbS5DbGllbnRIZWlnaHQ7XHJcbiAgICAgICAgICAgIFNldE92ZXJmbG93KHN0eWxlLCBvbGRWYWx1ZSk7XHJcbiAgICAgICAgICAgIHJldHVybiBuZXcgU3lzdGVtLlZhbHVlVHVwbGU8aW50LCBpbnQ+KHdpZHRoLCBoZWlnaHQpO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgcHVibGljIHN0YXRpYyBTeXN0ZW0uVmFsdWVUdXBsZTxpbnQgLGludCA+IEdldFZpZXdQb3J0U2l6ZSgpXHJcbiAgICAgICAge1xyXG4gICAgICAgICAgICBTeXN0ZW0uVmFsdWVUdXBsZTxpbnQgLGludCA+IHZQb3J0ID0gbmV3IFN5c3RlbS5WYWx1ZVR1cGxlPGludCwgaW50PigxMDAsIDEwMCk7XHJcbiAgICAgICAgICAgIGlmIChXaW5kb3cuSW5uZXJXaWR0aCA+IDApXHJcbnZQb3J0Lkl0ZW0xPSBXaW5kb3cuSW5uZXJXaWR0aDtcclxuICAgICAgICAgICAgaWYgKFdpbmRvdy5Jbm5lckhlaWdodCA+IDApXHJcbnZQb3J0Lkl0ZW0yPSBXaW5kb3cuSW5uZXJIZWlnaHQ7XHJcblxyXG4gICAgICAgICAgICB2YXIgZG9jID0gV2luZG93LkRvY3VtZW50O1xyXG4gICAgICAgICAgICB2YXIgaHRtbCA9IGRvYy5Eb2N1bWVudEVsZW1lbnQ7XHJcbiAgICAgICAgICAgIHZhciBib2R5ID0gZG9jLkJvZHk7XHJcbiAgICAgICAgICAgIGlmIChib2R5ID09IG51bGwpXHJcbiAgICAgICAgICAgICAgICBib2R5ID0gZG9jLkdldEVsZW1lbnRzQnlUYWdOYW1lKFwiYm9keVwiKVswXTtcclxuXHJcbiAgICAgICAgICAgIHZhciBodG1sU2l6ZSA9IEdldFNpemUoaHRtbCk7XHJcbiAgICAgICAgICAgIHZhciBib2R5U2l6ZSA9IEdldFNpemUoYm9keSk7XHJcblxyXG4gICAgICAgICAgICByZXR1cm4gbmV3IFN5c3RlbS5WYWx1ZVR1cGxlPGludCwgaW50PihNYXRoLk1heChodG1sU2l6ZS5JdGVtMSwgYm9keVNpemUuSXRlbTEpLCBNYXRoLk1heChodG1sU2l6ZS5JdGVtMiwgYm9keVNpemUuSXRlbTIpKTtcclxuICAgICAgICB9XHJcblxyXG4gICAgICAgIHB1YmxpYyBzdGF0aWMgdm9pZCBSZW1vdmVUZW1wbGF0ZVN0eWxlc0Zyb21Eb20oc3RyaW5nIG5hbWUpXHJcbiAgICAgICAge1xyXG4gICAgICAgICAgICB2YXIgZWxlbSA9IFdpbmRvdy5Eb2N1bWVudC5HZXRFbGVtZW50QnlJZChzdHJpbmcuRm9ybWF0KFwid2YtY3NzLXswfVwiLG5hbWUpKTtcclxuICAgICAgICAgICAgZWxlbSE9bnVsbD9lbGVtLlBhcmVudE5vZGUuUmVtb3ZlQ2hpbGQoZWxlbSk6KE5vZGUpbnVsbDtcclxuICAgICAgICB9XHJcblxyXG4gICAgICAgIHB1YmxpYyBzdGF0aWMgdm9pZCBBZGRUZW1wbGF0ZVN0eWxlc1RvRG9tKHN0cmluZyBuYW1lLCBUZW1wbGF0ZUluZm8gdEluZm8pXHJcbiAgICAgICAge1xyXG4gICAgICAgICAgICBpZiAoIXN0cmluZy5Jc051bGxPckVtcHR5KHRJbmZvLkNzcykpXHJcbiAgICAgICAgICAgIHtcclxuICAgICAgICAgICAgICAgIHZhciBlbGVtID0gRG9jdW1lbnQuR2V0RWxlbWVudEJ5SWQoc3RyaW5nLkZvcm1hdChcIndmLWNzcy17MH1cIixuYW1lKSk7XHJcbiAgICAgICAgICAgICAgICBpZiAoZWxlbSA9PSBudWxsKVxyXG4gICAgICAgICAgICAgICAge1xyXG4gICAgICAgICAgICAgICAgICAgIGVsZW0gPSBEb2N1bWVudC5DcmVhdGVFbGVtZW50KFwic3R5bGVcIik7XHJcbiAgICAgICAgICAgICAgICAgICAgZWxlbS5JZCA9IHN0cmluZy5Gb3JtYXQoXCJ3Zi1jc3MtezB9XCIsbmFtZSk7XHJcbiAgICAgICAgICAgICAgICAgICAgZWxlbS5Jbm5lckhUTUwgPSB0SW5mby5Dc3M7XHJcblxyXG4gICAgICAgICAgICAgICAgICAgIHZhciBoZWFkID0gRG9jdW1lbnQuR2V0RWxlbWVudHNCeVRhZ05hbWUoXCJoZWFkXCIpO1xyXG4gICAgICAgICAgICAgICAgICAgIGhlYWRbMF0uQXBwZW5kQ2hpbGQoZWxlbSk7XHJcbiAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICB9XHJcblxyXG4gICAgICAgIHB1YmxpYyBzdGF0aWMgdm9pZCBTaG93RWxlbWVudChqUXVlcnkgYWN0aW9uKVxyXG4gICAgICAgIHtcclxuICAgICAgICAgICAgYWN0aW9uLlJlbW92ZUNsYXNzKFwid2YtaGlkZGVuXCIpO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgcHVibGljIHN0YXRpYyB2b2lkIEhpZGVFbGVtZW50KGpRdWVyeSBhY3Rpb24pXHJcbiAgICAgICAge1xyXG4gICAgICAgICAgICBhY3Rpb24uQWRkQ2xhc3MoXCJ3Zi1oaWRkZW5cIik7XHJcbiAgICAgICAgfVxyXG5cclxuICAgIH1cclxufVxyXG4iXQp9Cg==
