Bridge.assembly("WebFormsBase", function ($asm, globals) {
    "use strict";

    Bridge.define("Adaptica.WebForms.Common.DataModel.ContainerItemFontHelper", {
        fields: {
            FontStyle: 0,
            FontColor: null
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.DatasetHelper", {
        statics: {
            methods: {
                FilterOnServer: function (ds) {
                    return (ds.RecordCount > 0) && (ds.RecordCount !== ds.Records.length);
                },
                IsReadOnly: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.ReadOnly === 1;
                },
                CanRead: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Read === 1;
                },
                CanInsert: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Insert === 1;
                },
                CanUpdate: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Update === 1;
                },
                CanDelete: function (ds) {
                    if (ds.Header == null) {
                        return false;
                    }

                    return ds.Header.Delete === 1;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldDefHelpers", {
        statics: {
            methods: {
                IsVisible: function (fieldValue) {
                    return fieldValue.Hidden === 0;
                },
                IsReadOnly: function (fieldValue) {
                    return fieldValue.ReadOnly === 1;
                },
                IsRequired: function (fieldValue) {
                    return fieldValue.Required === 1;
                },
                GetFormatString: function (fieldDef) {
                    var $t;
                    if (System.String.isNullOrEmpty(fieldDef.Mask)) {
                        if (fieldDef.Type === 9) {
                            return "N2";
                        }
                        return null;
                    }

                    var mask = System.Linq.Enumerable.from(($t = System.String, System.Linq.Enumerable.from(System.String.split(fieldDef.Mask, System.Array.init([59], System.Char).map(function (i) {{ return String.fromCharCode(i); }})), $t).toList($t)), System.String).firstOrDefault(null, null);
                    return mask;
                },
                GetEnumCaption: function (fieldDef, value) {
                    var $t;
                    if (value == null) {
                        return null;
                    }
                    var values = System.String.split(fieldDef.Values, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                    var captions = System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                    return captions[System.Array.index(($t = System.String, System.Linq.Enumerable.from(values, $t).toList($t)).indexOf(value), captions)];
                },
                GetEnumValues: function (fieldDef) {
                    return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumValues$1(fieldDef, fieldDef.Values);
                },
                GetEnumValues$1: function (fieldDef, value) {
                    if (value == null) {
                        return null;
                    }
                    var values = System.String.split(fieldDef.Values, [44].map(function (i) {{ return String.fromCharCode(i); }}));

                    return System.Array.convertAll(values, function (s) { return System.Int32.parse(s); });
                },
                GetEnumDisplayValues: function (fieldDef) {
                    return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumDisplayValues$1(fieldDef, fieldDef.Values);
                },
                GetEnumDisplayValues$1: function (fieldDef, value) {
                    if (value == null) {
                        return null;
                    }
                    return System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                },
                GetSetCaption: function (fieldDef, strValue) {
                    if (strValue == null) {
                        return null;
                    }

                    var value = { };
                    System.Int32.tryParse(strValue, value);

                    var itemCount = 0;
                    var result = "";
                    var values = System.String.split(fieldDef.Values, [44].map(function (i) {{ return String.fromCharCode(i); }}));
                    var captions = System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}));

                    for (var i = 0; i < values.length; i = (i + 1) | 0) {
                        var itemValue = System.Int32.parse(values[System.Array.index(i, values)]);
                        if ((value.v & (1 << itemValue)) !== 0) {
                            if (itemCount > 0) {
                                result = (result || "") + ((", " + (captions[System.Array.index(i, captions)] || "")) || "");
                            } else {
                                result = captions[System.Array.index(i, captions)];
                            }

                            itemCount = (itemCount + 1) | 0;
                        }
                    }

                    return result;
                },
                GetSearchHint: function (fieldDef) {
                    if (function (_o1) {
                            _o1.add(1);
                            _o1.add(2);
                            return _o1;
                        }(new (System.Collections.Generic.List$1(System.Int32)).ctor()).contains(fieldDef.Type)) {
                        return System.String.format("{0}: {1}", fieldDef.Label, (System.String.split(fieldDef.DisplayValues, [44].map(function (i) {{ return String.fromCharCode(i); }}))).join(", "));
                    }
                    return fieldDef.Label;
                },
                Clone: function (fieldDef) {
                    var $t;
                    return ($t = new Adaptica.WebForms.Common.DataModel.FieldDef(), $t.Name = fieldDef.Name, $t.Type = fieldDef.Type, $t.Hidden = fieldDef.Hidden, $t.Required = fieldDef.Required, $t.ReadOnly = fieldDef.ReadOnly, $t.ProcessChange = fieldDef.ProcessChange, $t.SelectFunction = fieldDef.SelectFunction, $t.SelectFunctionID = fieldDef.SelectFunctionID, $t.Label = fieldDef.Label, $t.Values = fieldDef.Values, $t.DisplayValues = fieldDef.DisplayValues, $t.Mask = fieldDef.Mask, $t.Description = fieldDef.Description, $t);
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FieldValueHelper", {
        statics: {
            methods: {
                IsVisible: function (fieldValue) {
                    return (System.Nullable.hasValue(fieldValue.Visible)) && (System.Nullable.getValue(fieldValue.Visible) === 1);
                },
                IsReadOnly: function (fieldValue) {
                    return (System.Nullable.hasValue(fieldValue.ReadOnly)) && (System.Nullable.getValue(fieldValue.ReadOnly) === 1);
                },
                IsRequired: function (fieldValue) {
                    return (System.Nullable.hasValue(fieldValue.Required)) && (System.Nullable.getValue(fieldValue.Required) === 1);
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FormHelper", {
        statics: {
            methods: {
                IsChanged: function (form, silentOnly) {
                    var $t;
                    if (silentOnly === void 0) { silentOnly = false; }
                    if ((($t = form.DataModule) != null ? $t.Datasets : null) == null || (form.DataModule.Datasets.length === 0)) {
                        return false;
                    }

                    return System.Linq.Enumerable.from(form.DataModule.Datasets, Adaptica.WebForms.Common.DataModel.Dataset).where(function (ds) {
                            return silentOnly && ds.SilentSave || !silentOnly;
                        }).any(function (ds) {
                        return System.Linq.Enumerable.from(ds.Records, Adaptica.WebForms.Common.DataModel.Record).any(function (r) {
                                switch (r.Event) {
                                    case Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None: 
                                        return false;
                                    default: 
                                        return true;
                                }
                            });
                    });
                },
                Clone: function (T, source) {

                    var serialized = JSON.stringify(source, function (s, o) {
                        /* 
                                       if (s == "Design")
                                       {
                                           return null;
                                       }
                        */

                        return o;
                    });

                    return Newtonsoft.Json.JsonConvert.DeserializeObject(serialized, T);
                },
                CloneFormOnlyForInlineEdit: function (form, currencyManager, currentDSPFID, record) {
                    var clone = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Form, form);
                    clone.DataModule.Datasets.forEach(function (d) {
                            Adaptica.WebForms.WebApp.Extensions.Clear(Adaptica.WebForms.Common.DataModel.Record, d.Records);

                            if (Bridge.referenceEquals(d.DSPFID, currentDSPFID)) {
                                var nRecord = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Record, record);
                                Adaptica.WebForms.WebApp.Extensions.Add(Adaptica.WebForms.Common.DataModel.Record, d.Records, nRecord);
                            } else {
                                var r = currencyManager.GetCurrentRecord(d.DSPFID);
                                if (r != null) {
                                    Adaptica.WebForms.WebApp.Extensions.Add(Adaptica.WebForms.Common.DataModel.Record, d.Records, Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Record, r));
                                }
                            }
                            d.RecordCount = d.Records.length;
                        });

                    return clone;
                },
                CloneFormOnlyForInlineInsert: function (form, currencyManager, currentDSPFID) {
                    var clone = Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Form, form);
                    clone.DataModule.Datasets.forEach(function (d) {
                            Adaptica.WebForms.WebApp.Extensions.Clear(Adaptica.WebForms.Common.DataModel.Record, d.Records);

                            if (Bridge.referenceEquals(d.DSPFID, currentDSPFID)) {
                                Adaptica.WebForms.Common.DataModel.DataHelpers.InsertRecord(currencyManager, d);
                            } else {
                                var r = currencyManager.GetCurrentRecord(d.DSPFID);
                                if (r != null) {
                                    Adaptica.WebForms.WebApp.Extensions.Add(Adaptica.WebForms.Common.DataModel.Record, d.Records, Adaptica.WebForms.Common.DataModel.FormHelper.Clone(Adaptica.WebForms.Common.DataModel.Record, r));
                                }
                            }
                            d.RecordCount = d.Records.length;
                        });

                    return clone;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.FunctionHelper", {
        statics: {
            methods: {
                GetRecordMasterId: function ($function, record) {
                    if (System.String.isNullOrEmpty($function.MasterFields)) {
                        return null;
                    }
                    var m = System.Text.RegularExpressions.Regex.match($function.MasterFields, "ID(?<leftsuffix>.*)=(?:(?<fieldName>.*)\\.)*ID(?<rightsuffix>.*)");
                    var fieldName = m.getGroups().getByName("fieldName").getSuccess() ? m.getGroups().getByName("fieldName").getValue() : null;
                    var suffix = m.getGroups().getByName("rightsuffix").getSuccess() ? m.getGroups().getByName("rightsuffix").getValue() : null;
                    return Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldId(record, fieldName, suffix);
                },
                GetMasterId: function (form, item) {
                    return null;
                },
                IsAvailable: function ($function) {

                    var id = $function.PFU;
                    if (System.String.isNullOrEmpty(id)) {
                        id = $function.PFPFU;
                    }

                    return (System.String.endsWith(id, "11262") || System.String.endsWith(id, "11241") || System.String.endsWith(id, "11263") || System.String.endsWith(id, "9999") || System.String.endsWith(id, "11513") || System.String.endsWith(id, "11309") || System.String.endsWith(id, "11460") || System.String.endsWith(id, "11474") || System.String.endsWith(id, "10158") || System.String.endsWith(id, "11557") || System.String.endsWith(id, "11624") || System.String.endsWith(id, "11566") || System.String.endsWith(id, "10516")) && (System.Array.indexOfT(Adaptica.WebForms.Common.DataModel.Function.fullBUID, $function.BUID) > -1);
                },
                IsFunctionVisibleForRecord: function ($function, record) {
                    if (System.String.isNullOrEmpty($function.VisibleExpr)) {
                        return true;
                    }

                    return Adaptica.WebForms.Common.DataModel.FunctionHelper.EvaluateExpressionForRecord($function.VisibleExpr, record);
                },
                IsFunctionEnabledForRecord: function ($function, record) {
                    if (System.String.isNullOrEmpty($function.EnableExpr)) {
                        return true;
                    }

                    return Adaptica.WebForms.Common.DataModel.FunctionHelper.EvaluateExpressionForRecord($function.EnableExpr, record);
                },
                EvaluateExpressionForRecord: function (expression, record) {
                    if ((record != null ? record.FieldValues : null) == null) {
                        return true;
                    }

                    var result;
                    result = false;

                    var expr = new System.Text.StringBuilder(expression);
                    record.FieldValues.forEach(function (fv) {
                            expr.replace(System.String.format("\"MasterDS.{0}\"", [fv.Name]), fv.Value);
                        });

                    try {
                        var e = expr.replace("<>", "!=").replace("=", "==").replace(" AND ", " && ").replace(" And ", " && ").replace(" and ", " && ").replace(" OR ", " || ").replace(" Or ", " || ").replace(" or ", " || ").toString();

                        result = eval(e);
                    } catch (ex) {
                        ex = System.Exception.create(ex);
                        System.Console.WriteLine(System.String.format("Error: {0}", [ex.Message]));
                    }
                    return result;
                }
            }
        }
    });

    Bridge.define("Adaptica.WebForms.Common.DataModel.RecordHelper", {
        statics: {
            methods: {
                GetFieldValue$1: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);
                    var value = fv != null ? fv.Value : null;
                    if (System.String.isNullOrEmpty(value)) {
                        return null;
                    }

                    return value;
                },
                GetFieldValue: function (record, fieldDef) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldDef.Name);
                        }, null);
                    var value = fv != null ? fv.Value : null;
                    if (System.String.isNullOrEmpty(value)) {
                        return null;
                    }

                    return value;
                },
                GetFieldDisplayValue: function (record, fieldDef) {
                    if (record == null) {
                        return null;
                    }

                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldDef.Name);
                        }, null);
                    var value = fv != null ? fv.Value : null;
                    if (System.String.isNullOrEmpty(value)) {
                        return null;
                    }

                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Enum) {
                        return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetEnumCaption(fieldDef, value);
                    }

                    if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Set) {
                        return Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetSetCaption(fieldDef, value);
                    }

                    var mask = Adaptica.WebForms.Common.DataModel.FieldDefHelpers.GetFormatString(fieldDef);
                    var hasMask = !System.String.isNullOrEmpty(mask);


                    if (((fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Memo) || (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.LMemo)) && (Adaptica.WebForms.Common.DataModel.FieldDefHelpers.IsReadOnly(fieldDef))) {
                        value = System.String.replaceAll(value, "\n", "<br>");
                    } else if ((fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) || (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Date) || (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Time)) {
                        var currentCulture = System.Globalization.CultureInfo.getCurrentCulture();
                        var lang = Adaptica.WebForms.WebApp.WebFormsApp.GetText("SystemShortCountryCode");
                        if (System.String.isNullOrEmpty(lang)) {
                            lang = window.navigator.language;
                        }

                        if (System.String.isNullOrEmpty(lang)) {
                            lang = "cs";
                        }

                        try {
                            System.Globalization.CultureInfo.setCurrentCulture(new System.Globalization.CultureInfo(lang));
                        } catch ($e1) {
                            $e1 = System.Exception.create($e1);
                            Bridge.Console.log(System.String.format("Cannot find language: {0}", [lang]));
                        }

                        try {
                            if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.DateTime) {
                                var dt = System.DateTime.parseExact(value, "yyyy-MM-dd HH:mm:ss.fff", null);
                                return System.String.format("{0} {1}", System.DateTime.format(dt, "d"), System.DateTime.format(dt, System.Globalization.CultureInfo.getCurrentCulture().dateTimeFormat.longTimePattern));

                            }

                            if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Date) {
                                var dt1 = System.DateTime.parseExact(value, "yyyy-MM-dd", null);
                                return System.DateTime.format(dt1, "d");
                            }

                            if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Time) {
                                var dt2 = System.DateTime.parseExact(value, "HH:mm:ss.fff", null);
                                return System.DateTime.format(dt2, System.Globalization.CultureInfo.getCurrentCulture().dateTimeFormat.longTimePattern);
                            }
                        } finally {
                            System.Globalization.CultureInfo.setCurrentCulture(currentCulture);
                        }
                    }


                    if (hasMask) {
                        if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Integer) {
                            value = System.Int32.format(System.Int32.parse(value), mask);
                        } else if (fieldDef.Type === Adaptica.WebForms.Common.DataModel.FieldType.Float) {
                            value = Bridge.Int.format(System.Decimal(value, System.Globalization.CultureInfo.invariantCulture), mask);
                        } else {
                        }
                    }


                    return value;
                },
                SetFieldValue: function (record, fieldDef, value) {
                    var $t;
                    if (Bridge.referenceEquals(value, "")) {
                        value = null;
                    }

                    var result = false;
                    var fieldValue = null;

                    var fvIdx = -1;
                    for (var i = 0; i < record.FieldValues.length; i = (i + 1) | 0) {
                        var fv = ($t = record.FieldValues)[System.Array.index(i, $t)];
                        if (Bridge.referenceEquals(fv.Name, fieldDef.Name)) {
                            fvIdx = i;
                            fieldValue = fv;
                        }
                    }

                    if (fieldValue == null && value == null) {
                        return false;
                    }

                    if (fieldValue == null) {
                        fieldValue = new Adaptica.WebForms.Common.DataModel.FieldValue.$ctor1(fieldDef);
                        record.FieldValues.push(fieldValue);
                        result = true;
                    }

                    if (value != null) {
                        switch (fieldDef.Type) {
                            case Adaptica.WebForms.Common.DataModel.FieldType.Float: 
                                {
                                    value = Adaptica.WebForms.WebApp.Extensions.NormalizeFloat(value);
                                    break;
                                }
                            case Adaptica.WebForms.Common.DataModel.FieldType.DateTime: 
                                {
                                    var dt = System.DateTime.parse(value);
                                    value = System.DateTime.format(dt, "yyyy-MM-dd HH:mm:ss.fff");
                                    break;
                                }
                            case Adaptica.WebForms.Common.DataModel.FieldType.Date: 
                                {
                                    var dt1 = System.DateTime.parse(value);
                                    value = System.DateTime.format(dt1, "yyyy-MM-dd");
                                    break;
                                }
                            case Adaptica.WebForms.Common.DataModel.FieldType.Time: 
                                {
                                    var dt2 = System.DateTime.parse(value);
                                    value = System.DateTime.format(dt2, "HH:mm:ss.fff");
                                    break;
                                }
                        }
                    }

                    if (!Bridge.referenceEquals(fieldValue.Value, value)) {
                        fieldValue.Value = value;
                        result = true;
                    }
                    if (result && record.Event === Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.None) {
                        record.Event = Adaptica.WebForms.Common.DataModel.Record.RecordEventEnum.Update;
                    }
                    return result;
                },
                GetFieldId: function (record, idFieldName, suffix) {
                    var $t, $t1, $t2, $t3;
                    if (idFieldName == null) {
                        return System.String.format("{0},{1}", Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, "ic" + ((($t = suffix, $t != null ? $t : "")).toLowerCase() || "")), Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, "u" + ((($t1 = suffix, $t1 != null ? $t1 : "")).toLowerCase() || "")));
                    }
                    return System.String.format("{0},{1}", Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, (idFieldName || "") + ".ic" + ((($t2 = suffix, $t2 != null ? $t2 : "")).toLowerCase() || "")), Adaptica.WebForms.Common.DataModel.RecordHelper.GetFieldValue$1(record, (idFieldName || "") + ".u" + ((($t3 = suffix, $t3 != null ? $t3 : "")).toLowerCase() || "")));
                },
                IsFieldReadOnly: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);

                    return fv != null ? Bridge.cast((System.Nullable.eq(fv.ReadOnly, 1)), System.Boolean, true) : null;
                },
                IsFieldValueRequired: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);

                    return fv != null ? Bridge.cast((System.Nullable.eq(fv.Required, 1)), System.Boolean, true) : null;
                },
                IsFieldValueVisible: function (record, fieldName) {
                    var fv = System.Linq.Enumerable.from(record.FieldValues, Adaptica.WebForms.Common.DataModel.FieldValue).firstOrDefault(function (i) {
                            return Bridge.referenceEquals(i.Name, fieldName);
                        }, null);

                    return fv != null ? Bridge.cast((System.Nullable.eq(fv.Visible, 1)), System.Boolean, true) : null;
                },
                CanUpdate: function (rec) {
                    return rec.Update === 1;
                },
                CanDelete: function (rec) {
                    return rec.Delete === 1;
                }
            }
        }
    });
});

//# sourceMappingURL=data:application/json;base64,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
