
var Signature = {};

// Conversion functions
( function() {
	function stringToArrayBuffer(data)
	{
		var arrBuff = new ArrayBuffer(data.length);
		var writer = new Uint8Array(arrBuff);
		for (var i = 0, len = data.length; i < len; i++)
		{
			writer[i] = data.charCodeAt(i);
		}
		return arrBuff;
	}

	function arrayBufferToString( buffer )
	{
		var binary = '';
		var bytes = new Uint8Array( buffer );
		var len = bytes.byteLength;
		for (var i = 0; i < len; i++)
		{
			binary += String.fromCharCode( bytes[ i ] );
		}
		return binary;
	}

	// From Private Key to a PKCS#8
	function privateKeyToPkcs8(privateKey)
	{
		var rsaPrivateKey = forge.pki.privateKeyToAsn1(privateKey);
		var privateKeyInfo = forge.pki.wrapRsaPrivateKey(rsaPrivateKey);
		var privateKeyInfoDer = forge.asn1.toDer(privateKeyInfo).getBytes();
		var privateKeyInfoDerBuff = stringToArrayBuffer(privateKeyInfoDer);

		return privateKeyInfoDerBuff;
	}

// From Public Key to a PKCS#8
	function publicKeyToPkcs8(pk)
	{
		var subjectPublicKeyInfo = forge.pki.publicKeyToAsn1(pk);
		var der = forge.asn1.toDer(subjectPublicKeyInfo).getBytes();
		return stringToArrayBuffer(der);
	}

	function CreateDownload(text)
	{
		var data = new Blob([text], {type: 'application/x-x509-user-cert'});
		var textFile = window.URL.createObjectURL(data);
		return textFile;
	}

	function CertInfo(cert)
	{
		// Convert to ASN
		var asn1Cert = forge.pki.certificateToAsn1(cert);

		// Convert to DER format
		var p12Der = forge.asn1.toDer(asn1Cert).getBytes();

		// Encode with Base64
		var p12b64  = forge.util.encode64(p12Der);

		var j = '<a href="data:application/x-x509-ca-cert;base64,' + p12b64 + '" download="cert.der">Certificate Information</a><br>';
		try { j += "NAME: " + cert.subject.getField('CN').value + "<br>" } catch (err) {};
		try { j += "MAIL: " + cert.subject.getField('E').value + "<br>" } catch(err) {};
		try { j += "ISSUER: " + cert.issuer.getField('CN').value + "<br>" } catch(err) {};
		return j;
	}


	// Create a CryptoKey from  from a PKCS#12 Private Key
	function importCryptoKeyPkcs8(privateKey,extractable)
	{
		var privateKeyInfoDerBuff = privateKeyToPkcs8(privateKey);

		//Importa la clave en la webcrypto
		return crypto.subtle.importKey(
			'pkcs8',
			privateKeyInfoDerBuff,
			{ name: "RSASSA-PKCS1-v1_5", hash:{name:"SHA-256"}},
			extractable,
			["sign"]
		);
	}

	function Sign(hashToSign)
	{
		// Get PFX
		return new Promise((resolve, reject) => 
		{
	 	var fileInput = document.getElementById('pfx');
	 	var file = fileInput.files[0];

		// Read it
		var reader = new FileReader();
		reader.onload = function(e)
		{
			var cert = null;
			var contents = e.target.result;
			var pkcs12Der = arrayBufferToString(contents)
			//var pkcs12B64 = forge.util.encode64(pkcs12Der);
			var privateKey = null;
			var privateKeyId = null;
			var pkcs12;

			try
			{
				var pkcs12Asn1 = forge.asn1.fromDer(pkcs12Der);
				var password = $('#pfxp').val();

				pkcs12 = forge.pkcs12.pkcs12FromAsn1(pkcs12Asn1, false, password);
			}
			catch(err)
			{
				var reason = {};
				
				if ((err.message.toLowerCase().indexOf('invalid password') > -1)  || (err.message.toLowerCase().indexOf('wrong password') > -1))
				{
					//alert('Certifikát nemůže být ověřen. Pravděpodobně bylo zadáno chybné heslo.');
					reason.reason = 'invalidPassword';
					reason.text = 'Certifikát nemůže být ověřen. Pravděpodobně bylo zadáno chybné heslo.';
				}
				else
				if ((!file.name.toLowerCase().endsWith('.pfx')) && (!file.name.toLowerCase().endsWith('.p12')))
				{
					//alert('Neplatný certifikát. Je vyžadováno použití certifikátu obsahujícího soukromý klíč typu .pfx nebo .p12.');
					reason.reason = "invalidCertificate";
					reason.text = 'Certifikát nemůže být ověřen. Pravděpodobně bylo zadáno chybné heslo.';
				}
				else
				{
					reason.reason = err;
					alert(err);
				}

				reject(reason);
				return;
			}

			// find private key
			for(var sci = 0; sci < pkcs12.safeContents.length; ++sci)
			{
				var safeContents = pkcs12.safeContents[sci];
				for(var sbi = 0; sbi < safeContents.safeBags.length; ++sbi)
				{
					var safeBag = safeContents.safeBags[sbi];
					if(safeBag.type === forge.pki.oids.keyBag)
					{
						//Found plain private key
						privateKey = safeBag.key;
						privateKeyId = forge.util.bytesToHex(safeBag.attributes.localKeyId[0]);
						break;
					}
					else
					if(safeBag.type === forge.pki.oids.pkcs8ShroudedKeyBag)
					{
						// found encrypted private key
						privateKey = safeBag.key;
						privateKeyId = forge.util.bytesToHex(safeBag.attributes.localKeyId[0]);
						break;
					}
				}

				if (privateKeyId !== null)
					break;
			}

			if (privateKeyId === null)
			{
				//alert('Použitý certifikát neobsahuje soukromý klíč!');

				var reason = {};
				reason.reason = 'noPrivateKey';
				reason.text = 'Použitý certifikát neobsahuje soukromý klíč!'; 
				reject(reason);

				return;
			}

			cert = pkcs12.getBags({localKeyIdHex: privateKeyId, bagType: forge.pki.oids.certBag}).localKeyId[0].cert;

			importCryptoKeyPkcs8(privateKey,true).then(function(cryptoKey)
			{
				// Signed!

				var digestToSignBuf = stringToArrayBuffer(hashToSign);
				var pem = forge.pki.certificateToPem(cert);

				crypto.subtle.sign(
					{name: "RSASSA-PKCS1-v1_5", hash: { name: "SHA-256" }},
					cryptoKey,
					digestToSignBuf)
					.then(function(signature)
					{
						sign = arrayBufferToString(signature);
						signatureB64 = forge.util.encode64(sign);

						resolve({ signature: signatureB64, publicCert: forge.util.encode64(pem) });
					})
				.catch(err => alert("Chyba: " + err));
			});
		}

		reader.readAsArrayBuffer(file);
	});
	}

	Signature.Sign = function(data)
	{
		return Sign(data);
	}
})();

// Signature.Sign(data).then((signature) => { ... });
